package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.yeejoin.amos.boot.module.common.api.mapper.CustomBaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;
import java.util.Map;

/**
 * 注册登记信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-17
 */
public interface IdxBizJgRegisterInfoMapper extends CustomBaseMapper<IdxBizJgRegisterInfo> {

    @Select("select \"USE_ORG_CODE\" from idx_biz_jg_register_info where \"RECORD\" = #{equipCode}")
    String getUseOrgCodeByEquip(@Param("equipCode") String equipCode);

    @Select("update idx_biz_jg_register_info set \"USE_ORG_CODE\" = #{useOrgCode} where \"RECORD\" = #{equipCode}")
    Boolean updateUseOrgCodeByEquip(@Param("equipCode") String equipCode,@Param("useOrgCode") String useOrgCode);

    @Select("select code as dictDataKey,name as dictDataValue from tz_equipment_category where parent_id = ( SELECT sub.id from tz_equipment_category as sub where sub.code = #{equipCode}) order by dictDataKey desc")
    List<DictionarieValueModel> queryAllEquCategoriesUnderTheEquList(@Param("equipCode") String equipCode);

    List<Map<String, Object>> getProjectContraption(@Param("uscUnitCreditCode") String uscUnitCreditCode,
                                                    @Param("useUnitCreditCode") String useUnitCreditCode,
                                                    @Param("equCategoryCode")String equCategoryCode,
                                                    @Param("city")String city);

    @Select("SELECT SEQUENCE_NBR,REC_DATE,ORG_BRANCH_NAME,ORG_BRANCH_CODE,USE_UNIT_NAME,USE_UNIT_CREDIT_CODE,EQU_LIST_CODE,EQU_LIST,EQU_CATEGORY,EQU_CATEGORY_CODE,USE_ORG_CODE,CODE96333,EQU_CODE,SUPERVISORY_CODE,USE_PLACE,ADDRESS,EQU_STATE,STATUS,USE_INNER_CODE,FACTORY_NUM,PRODUCE_UNIT_NAME,INSPECT_REPORT,NEXT_INSPECT_DATE,CONSTRUCTION_TYPE,USC_UNIT_CREDIT_CODE,USC_UNIT_NAME,EQU_DEFINE,EQU_DEFINE_CODE,PRODUCT_NAME,BRAND_NAME,EQU_TYPE,DATA_SOURCE,IS_INTO_MANAGEMENT,WHETHER_VEHICLE_CYLINDER,WHETHER_SKID_MOUNTED_PRESSURE_VESSEL,DATE_FORMAT(PRODUCE_DATE,'%Y-%m-%d %H:%i:%s')as PRODUCE_DATE,PROJECT_CONTRAPTION from idx_biz_view_jg_all WHERE PROJECT_CONTRAPTION is not null")
    List<Map<String, Object>> esSynchronousProjectContraption();

    @Select("SELECT " +
    "jui.PROJECT_CONTRAPTION AS value " +
    "FROM " +
    "idx_biz_jg_use_info jui " +
    "LEFT JOIN idx_biz_jg_register_info jri ON jri.\"RECORD\" = jui.\"RECORD\" " +
    "WHERE " +
    "jui.USE_UNIT_CREDIT_CODE = #{useUnitCreditCode} " +
    "AND jui.PROJECT_CONTRAPTION IS NOT NULL " +
    "AND jri.\"USE_ORG_CODE\" IS NULL " +
    "GROUP BY " +
    "jui.PROJECT_CONTRAPTION")
    List<Map<String, Object>> getProjectContraptionList(String useUnitCreditCode);

    void updateCylinderCategoryByRecordBatch(@Param("recordList") List<String> recordList, @Param("cylinderCategory") String cylinderCategory);

    /**
     * 批量更新 CYLINDER_CATEGORY 根据 equCode
     *
     * @param cylinderCategory 需要更新的参数列表
     * @param equCodeList equCode列表
     * @return 更新成功返回 true，失败返回 false
     */
    Boolean updateCylinderCategoryByEquCodeBatch(@Param("cylinderCategory") String cylinderCategory, @Param("equCodeList") List<String> equCodeList);

    Integer selectByEquCodeAndClaimStatus(@Param("equCode") String equCode, @Param("sequenceNbr") String sequenceNbr, @Param("record") String record);

    Integer selectInstallNoticeEqByEquCode(@Param("equCode") String equCode, @Param("sequenceNbr") String sequenceNbr);

    @Select("SELECT COUNT(*)\n" +
            "    FROM idx_biz_jg_register_info jri\n" +
            "    INNER JOIN idx_biz_jg_other_info joi\n" +
            "    ON jri.RECORD = joi.RECORD\n" +
            "    WHERE joi.CLAIM_STATUS = '已认领'\n" +
            "    AND (jri.car_number = CAST(#{carNumber} AS VARCHAR) OR CAST(#{carNumber} AS VARCHAR) IS NULL)\n" +
            "    AND (jri.record <> CAST(#{record} AS VARCHAR) OR CAST(#{record} AS VARCHAR) IS NULL)")
    Integer checkCarNumberUniquenessWithHisCC(@Param("carNumber") String carNumber, @Param("record") String record);

    @Select("SELECT COUNT(*)\n" +
            "    FROM idx_biz_jg_register_info jri\n" +
            "    INNER JOIN idx_biz_jg_other_info joi\n" +
            "    ON jri.RECORD = joi.RECORD\n" +
            "    WHERE joi.CLAIM_STATUS = '已认领'\n" +
            "    AND (jri.car_number = CAST(#{carNumber} AS VARCHAR) OR CAST(#{carNumber} AS VARCHAR) IS NULL)\n" +
            "    AND (jri.use_org_code <> CAST(#{useOrgCode} AS VARCHAR) OR CAST(#{useOrgCode} AS VARCHAR) IS NULL)")
    Integer checkCarNumberUniqueness(@Param("carNumber") String carNumber, @Param("useOrgCode") String useOrgCode);
}
