package com.yeejoin.amos.boot.module.ys.biz.controller;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.ys.biz.feign.PrivilegeFeginService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;
import java.util.stream.Collectors;
/**
 * @author chang xiangyu
 * @date 2024-09-24
 */
@RestController
@Api(tags = "TreeToList")
@RequestMapping(value = "/tree-to-list")
public class TreeToListController extends BaseController {
    private static final String REGULATOR_UNIT_TREE = "REGULATOR_UNIT_TREE";
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private PrivilegeFeginService privilegeFeginService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getTreeToList")
    @ApiOperation(httpMethod = "GET", value = "根据当前登录人获取监管机构平铺列表数据", notes = "根据当前登录人获取监管机构平铺列表数据")
    public ResponseModel<Object> getTreeChildList(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        //   获取结果数据
        ArrayList<LinkedHashMap> resultLinkedHashMapList = getResultList();
        //   分页
        int start = (current - 1) * size;
        int end = Math.min(start + size, resultLinkedHashMapList.size());
        List<LinkedHashMap> pageData = resultLinkedHashMapList.subList(start, end);
        Page page = new Page(resultLinkedHashMapList.size(), current, (int) Math.ceil((double) resultLinkedHashMapList.size() / size), size, pageData, true);
        return ResponseHelper.buildResponse(page);
    }


    /**
     * 过滤数据
     *
     * @param resultList
     * @param linkedHashMap
     */
    private static void clearSafeMap(ArrayList<LinkedHashMap> resultList, LinkedHashMap linkedHashMap,String regionName) {
        LinkedHashMap<String, String> safeLinkedHashMap = new LinkedHashMap<>();
        safeLinkedHashMap.put("companyName", (String) linkedHashMap.get("companyName"));
        safeLinkedHashMap.put("agencyCode", (String) linkedHashMap.get("agencyCode"));
        safeLinkedHashMap.put("companyCode", (String) linkedHashMap.get("companyCode"));
        safeLinkedHashMap.put("sequenceNbr", (String) linkedHashMap.get("sequenceNbr"));
        safeLinkedHashMap.put("parentId", (String) linkedHashMap.get("parentId"));
        safeLinkedHashMap.put("regionName",regionName);
        resultList.add(safeLinkedHashMap);
    }



    /**
     * @return 返回最终数据对象
     */
    private ArrayList<LinkedHashMap> getResultList() {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(reginParams)) {
            return null;
        }
        Long id = reginParams.getCompany().getSequenceNbr();
        List<LinkedHashMap> data = (List<LinkedHashMap>) redisUtils.get(REGULATOR_UNIT_TREE);
        ArrayList<LinkedHashMap> result = new ArrayList<>();
        List<LinkedHashMap> linkedHashMaps = screenData(result, data, id.toString());
        //getFinallyResult
        ArrayList<LinkedHashMap> resultLinkedHashMapList = mapToDeepList(linkedHashMaps);
        return resultLinkedHashMapList;
    }

    public List<LinkedHashMap> screenData(List<LinkedHashMap> result, List<LinkedHashMap> data, String id) {
        if (!ObjectUtils.isEmpty(result)) {
            return result;
        }
        List<LinkedHashMap> list = data.stream().filter(item -> item.get("sequenceNbr").toString().equals(id)).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(list)) {
            return list;
        }
        for (LinkedHashMap item : data) {
            if (!ObjectUtils.isEmpty(item.get("children"))) {
                List<LinkedHashMap> children = screenData(result, (List<LinkedHashMap>) item.get("children"), id);
                if (!ObjectUtils.isEmpty(children)) {
                    result = children;
                    break;
                }
            }
        }
        return result;
    }

    /**
     * 将树平铺为列表并返回
     *
     * @return
     */
    public ArrayList<LinkedHashMap> mapToDeepList(List<LinkedHashMap> linkedHashMapList) {
        ArrayList<LinkedHashMap> resultList = new ArrayList<>();

        FeignClientResult tree = privilegeFeginService.getTree();
        //获取机构数据Map(region,regionObjectMap)对象
        HashMap<String, HashMap> regionTreeToHashMapByRegionCode = regionTreeToHashMapByRegionCode((ArrayList<LinkedHashMap>) tree.getResult());

        insertToResultList(linkedHashMapList, resultList, regionTreeToHashMapByRegionCode,"");
        return resultList;

    }


    /**
     * doDepth 深度优先搜索平铺linkedHashMapList并塞入,resultList
     *
     * @param linkedHashMapList
     * @param resultList
     * @return
     */
    public ArrayList<LinkedHashMap> insertToResultList
    (List<LinkedHashMap> linkedHashMapList, ArrayList<LinkedHashMap> resultList, HashMap<String, HashMap> regionTreeToHashMapByRegionCode, String regionNamePrefix) {

        for (LinkedHashMap linkedHashMap : linkedHashMapList) {
            HashMap companyCodeHashMap = regionTreeToHashMapByRegionCode.get(linkedHashMap.get("companyCode"));
            String regionNameSuffix ="";
            if(companyCodeHashMap!=null){
                regionNameSuffix += (String) companyCodeHashMap.get("regionName");
            }

            if (linkedHashMap.get("children") != null) {
                clearSafeMap(resultList, linkedHashMap,regionNamePrefix+regionNameSuffix);
                insertToResultList((ArrayList<LinkedHashMap>) linkedHashMap.get("children"), resultList, regionTreeToHashMapByRegionCode, regionNamePrefix+regionNameSuffix);
            } else {
                clearSafeMap(resultList, linkedHashMap,regionNamePrefix+regionNameSuffix);
            }

        }
        return resultList;
    }

    /**
     * 广度优先遍历将区划树平铺并加入HashMap<regionCode,regionName>
     *
     * @param list
     * @return 返回区划数据HashMap<regionCode, 区划数据map>
     */
    public HashMap<String, HashMap> regionTreeToHashMapByRegionCode(ArrayList<LinkedHashMap> list) {
        Queue tempQueue = new LinkedList();
        HashMap<String, HashMap> hashMap = new HashMap();
        for (LinkedHashMap linkedHashMap : list) {
            tempQueue.offer(linkedHashMap);
        }
        while (tempQueue.size() != 0) {
            LinkedHashMap poll = (LinkedHashMap) tempQueue.poll();
            //过滤数据,只加入所需数据
            HashMap<String, String> objectHashMap = new HashMap<>();
            objectHashMap.put("sequenceNbr", (String) poll.get("sequenceNbr"));
            objectHashMap.put("regionCode", String.valueOf(poll.get("regionCode")));
            objectHashMap.put("regionName", (String) poll.get("regionName"));

            objectHashMap.put("parentId", (String) poll.get("parentId"));
            hashMap.put(String.valueOf(poll.get("regionCode")), objectHashMap);
            if (poll.get("children") != null) {
                ArrayList<LinkedHashMap> children = (ArrayList<LinkedHashMap>) poll.get("children");
                for (LinkedHashMap child : children) {
                    tempQueue.offer(child);
                }
            }
        }
        return hashMap;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    class Page {
        //总条数
        private Integer total;
        //当前页码
        private Integer current;
        //总页数
        private Integer pages;
        //显示条数
        private Integer size;
        //用来存放查询出来的数据
        private Object records;
        private boolean searchCount;

    }
}
