package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.BaseBill;
import com.yeejoin.equipmanage.common.entity.Scrap;
import com.yeejoin.equipmanage.common.entity.ScrapDetail;
import com.yeejoin.equipmanage.common.entity.SystemDic;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.common.vo.StockDataVO;
import com.yeejoin.equipmanage.service.IScrapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "报废Api")
@RequestMapping(value = "/scrap", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ScrapController extends AbstractBaseController {

	@Autowired
	IScrapService iScrapService;

	/**
	 * 新增
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveScrap(HttpServletRequest request, @RequestBody Scrap scrap) {
		return iScrapService.save(scrap);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iScrapService.removeById(id);
	}

	/**
	 * 修改
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdScrap(HttpServletRequest request, @RequestBody Scrap scrap) {
		return iScrapService.updateById(scrap);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Scrap selectById(HttpServletRequest request, @PathVariable Long id) {
		return iScrapService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<Scrap> listPage(String pageNum, String pageSize, Scrap scrap) {
		Page<Scrap> pageBean;
		QueryWrapper<Scrap> scrapQueryWrapper = new QueryWrapper<>();
		Class<? extends Scrap> aClass = scrap.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(scrap);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(scrap);
						scrapQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(scrap);
						scrapQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(scrap);
						scrapQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(scrap);
						scrapQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<Scrap> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		// scrapQueryWrapper.eq("user_id", getUserId());
		// scrapQueryWrapper.eq("org_code",
		// getSelectedOrgInfo().getCompany().getOrgCode());
		page = iScrapService.pageList(pageBean, scrapQueryWrapper);
		return page;
	}

	/**
	 * 新建报废
	 * 
	 * @param list
	 * @return
	 */
	@RequestMapping(value = "/create/{type}", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "报废", notes = "根据id查询")
	public Scrap create(@RequestBody List<ScrapDetail> list, @PathVariable String type) throws Exception {
		return iScrapService.create(list, type, getUserInfo());
	}

	/**
	 * 执行报废
	 * 
	 * @param param
	 * @return
	 */
	@RequestMapping(value = "/exec", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "报废", notes = "根据id查询")
	public BaseBill exec(@RequestBody Scrap param) throws Exception {
		Scrap scrap = iScrapService.exec(param);
		BaseBill baseBill = new BaseBill(scrap.getBillCode(), getUserInfo().getRealName(), DateUtils.getNowStrLong(),
				scrap.getId(), new ArrayList<StockDataVO>());
		return baseBill;
	}

	/**
	 * 执行报废
	 * 
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/reason", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "报废", notes = "根据id查询")
	public List<SystemDic> reason() {
		return iScrapService.reason();
	}

	/**
	 * <pre>
	 * &#64;Description: TODO
	 * </pre>
	 *
	 * @MethodName:
	 * @Param:
	 * @Return: ResponseModel
	 * @Throws
	 * @Author keyong
	 * @Date 2021/6/17 11:33
	 */
	@RequestMapping(value = "/airport/car", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "机场车载报废接口", notes = "车载装备报废", produces = "application/json;charset=UTF-8")
	public ResponseModel scrapOnCar(@RequestBody Long id) {
		try {
			iScrapService.scrapOnCar(id);
		} catch (Exception e) {
			return CommonResponseUtil.failure("车载装备报废失败！");
		}
		return CommonResponseUtil.success();
	}

	/**
	 * <pre>
	 * &#64;Description: TODO
	 * </pre>
	 *
	 * @MethodName:
	 * @Param:
	 * @Return: ResponseModel
	 * @Throws
	 * @Author keyong
	 * @Date 2021/6/17 11:43
	 */
	@RequestMapping(value = "/airport/person", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "机场人员装备退装接口", notes = "人员装备报废", produces = "application/json;charset=UTF-8")
	public ResponseModel scrapOnPerson(@RequestBody String id) {
		try {
			iScrapService.scrapOnPerson(Long.valueOf(id));
		} catch (Exception e) {
			return CommonResponseUtil.failure("人员装备报废失败！");
		}
		return CommonResponseUtil.success();
	}
}
