/*
 Navicat Premium Data Transfer

 Source Server         : 172.16.6.60
 Source Server Type    : MySQL
 Source Server Version : 50722
 Source Host           : 172.16.6.60:3306
 Source Schema         : empty-jcs

 Target Server Type    : MySQL
 Target Server Version : 50722
 File Encoding         : 65001

 Date: 20/08/2021 10:08:52
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for cb_contract
-- ----------------------------
DROP TABLE IF EXISTS `cb_contract`;
CREATE TABLE `cb_contract`  (
  `sequence_nbr` bigint(30) NOT NULL COMMENT '唯一主键',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '合同名称',
  `signed_company` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '签订单位名称',
  `signed_company_id` bigint(30) NULL DEFAULT NULL COMMENT '签订单位id',
  `begin_date` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '合同开始日期',
  `end_date` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '合同结束日期',
  `signed_date` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '签订日期',
  `contract_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '合同编号',
  `org_code` bit(1) NULL DEFAULT b'0' COMMENT '机构代码用于权限过滤',
  `company` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单位名称',
  `company_id` bigint(20) NULL DEFAULT NULL COMMENT '单位id',
  `rec_user_id` bigint(20) NOT NULL COMMENT '更新人id',
  `rec_user_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '更新人名称',
  `rec_date` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除（0：未删除，1：已删除）',
  `company_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '1' COMMENT '单位类型（1维保单位，0联动单位）',
  `type_code` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '合同类型code',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '合同类型',
  `service_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '服务内容',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '维保合同' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_contract
-- ----------------------------

-- ----------------------------
-- Table structure for cb_data_dictionary
-- ----------------------------
DROP TABLE IF EXISTS `cb_data_dictionary`;
CREATE TABLE `cb_data_dictionary`  (
  `sequence_nbr` bigint(19) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'id',
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'code',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '名称',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型',
  `type_desc` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型说明',
  `parent` bigint(19) NULL DEFAULT NULL COMMENT '父级',
  `rec_user_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人名称',
  `rec_user_id` varchar(19) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员',
  `rec_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  `sort_num` int(11) NULL DEFAULT 1 COMMENT '排序字段',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  UNIQUE INDEX `type_code_idx`(`code`, `type`) USING BTREE COMMENT '类型code唯一索引'
) ENGINE = InnoDB AUTO_INCREMENT = 1152 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '数据字典' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_data_dictionary
-- ----------------------------
INSERT INTO `cb_data_dictionary` VALUES (1, '1', '指挥员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (2, '2', '炊事员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (3, '3', '机坪保洁员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (4, '4', '通讯员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (5, '5', '消防车驾驶员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (6, '6', '战斗员', 'GWMC', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (7, '7', 'A1', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (8, '8', 'A2', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (9, '9', 'A3', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (10, '10', 'A4', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (11, '11', 'A5', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (12, '12', 'A6', 'YGCJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (13, '13', '支队队长', 'XZZW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (14, '14', '支队指导员', 'XZZW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (15, '15', '大队长', 'XZZW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (16, '16', '大队指导员', 'XZZW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (17, '17', '企业消防救援队员', 'XFRYLB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (18, '18', '企业消防管理人员', 'XFRYLB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (19, '19', '志愿消防救援队员', 'XFRYLB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (20, '20', '管理指挥干部', 'XFJYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (21, '21', '总监', 'XFJYJB', NULL, 20, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (22, '22', '副总监', 'XFJYJB', NULL, 20, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (23, '23', '助理总监', 'XFJYJB', NULL, 20, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (24, '24', '专业技术干部', 'XFJYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (25, '25', '指挥长', 'XFJYJB', NULL, 24, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (26, '26', '高级指挥长', 'XFJYJB', NULL, 25, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (27, '27', '一级指挥长', 'XFJYJB', NULL, 25, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (28, '28', '二级指挥长', 'XFJYJB', NULL, 25, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (29, '29', '三级指挥长', 'XFJYJB', NULL, 25, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (30, '30', '指挥员', 'XFJYJB', NULL, 24, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (31, '31', '一级指挥员', 'XFJYJB', NULL, 30, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (32, '32', '二级指挥员', 'XFJYJB', NULL, 30, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (33, '33', '三级指挥员', 'XFJYJB', NULL, 30, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (34, '34', '四级指挥员', 'XFJYJB', NULL, 30, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (35, '35', '消防员', 'XFJYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (36, '36', '高级消防员', 'XFJYJB', NULL, 35, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (37, '37', '一级消防长', 'XFJYJB', NULL, 36, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (38, '38', '二级消防长', 'XFJYJB', NULL, 36, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (39, '39', '三级消防长', 'XFJYJB', NULL, 36, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (40, '40', '中级消防员', 'XFJYJB', NULL, 35, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (41, '41', '一级消防士', 'XFJYJB', NULL, 40, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (42, '42', '二级消防士', 'XFJYJB', NULL, 40, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (43, '43', '初级消防员', 'XFJYJB', NULL, 35, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (44, '44', '三级消防士', 'XFJYJB', NULL, 43, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (45, '45', '四级消防士', 'XFJYJB', NULL, 43, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (46, '46', '预备消防士', 'XFJYJB', NULL, 43, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (47, '47', '灭火指挥', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (48, '48', '建筑火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (49, '49', '地下空间火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (50, '50', '化工火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (51, '51', '列车火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (52, '52', '航空器火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (53, '53', '船舶火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (54, '54', '地铁火灾', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (56, '56', '抢险救援', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (57, '57', '危险化学品泄漏事故', 'ZJLY', NULL, 56, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (58, '58', '道路交通事故', 'ZJLY', NULL, 56, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (59, '59', '建筑坍塌事故', 'ZJLY', NULL, 56, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (61, '61', '信息通信', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (62, '62', '计算机网络', 'ZJLY', NULL, 61, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (63, '63', '有线', 'ZJLY', NULL, 61, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (64, '64', '无线', 'ZJLY', NULL, 61, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (65, '65', '卫星', 'ZJLY', NULL, 61, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (67, '67', '消防装备', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (68, '68', '消防员防护装备', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (69, '69', '消防车、船、飞行器', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (70, '70', '灭火器材装备', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (71, '71', '灭火药剂', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (72, '72', '抢险救援器材', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (73, '73', '特种消防装备', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (74, '74', '防火检查与火灾调查装备', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (76, '76', '消防监督', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (77, '77', '火灾调查', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (78, '78', '危险化学品', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (79, '79', '供水', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (80, '80', '供电', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (81, '81', '供气', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (82, '82', '医疗救护', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (83, '83', '建筑', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (84, '84', '气象', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (85, '85', '环保', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (86, '86', '交通运输', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (87, '87', '地震', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (88, '88', '核生化', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (89, '89', '海事', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (90, '90', '其他', 'ZJLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (91, '91', '民航灭火救援指挥员（一级）', 'GWZZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (92, '92', '民航灭火救援指挥员（二级）', 'GWZZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (93, '93', '民航灭火救援指挥员（三级）', 'GWZZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (94, '94', '在职', 'RYZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (95, '95', '离职', 'RYZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (96, '96', '退休', 'RYZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (97, '97', '牺牲', 'RYZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (98, '98', '其他', 'RYZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (99, '99', '小学', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (100, '100', '初中', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (101, '101', '高中', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (102, '102', '中专', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (103, '103', '大专', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (104, '104', '本科', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (105, '105', '研究生', 'XLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (106, '106', '学士', 'XWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (107, '107', '硕士', 'XWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (108, '108', '博士', 'XWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (111, '111', '消防救援总队', 'XFJGLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (112, '112', '省消防救援总队', 'XFJGLX', NULL, 111, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (113, '113', '消防救援支队', 'XFJGLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (114, '114', '城市消防救援支队', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (115, '115', '地区消防救援支队', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (116, '116', '企（事）业单位专职消防救援支队', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (117, '117', '企（事）业单位义务消防救援大队', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (118, '118', '企（事）业单位监控大队', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (120, '120', '身份证', 'RYZJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (121, '121', '护照', 'RYZJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (122, '122', '其他', 'RYZJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (123, '123', '固定期合同', 'HTLB', '合同类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (124, '124', '无固定器合同', 'HTLB', '合同类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (125, '125', '劳务派遣合同', 'HTLB', '合同类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (126, '126', '父亲', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (127, '127', '母亲', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (128, '128', '配偶', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (129, '129', '儿子', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (130, '130', '女儿', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (131, '131', '兄弟', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (132, '132', '姐妹', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (133, '133', '同学', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (134, '134', '同事', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (135, '135', '朋友', 'RJGX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (136, '136', '其他', 'ZJLY', NULL, 47, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (137, '137', '其他', 'ZJLY', NULL, 56, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (138, '138', '其他', 'ZJLY', NULL, 61, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (139, '139', '其他', 'ZJLY', NULL, 67, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (140, '140', '灭火抢险救援类', 'XFRYGW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (141, '141', '战斗员', 'XFRYGW', NULL, 140, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (142, '142', '消防车驾驶员', 'XFRYGW', NULL, 140, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (143, '143', '火场文书', 'XFRYGW', NULL, 140, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (144, '144', '机坪保洁员', 'XFRYGW', NULL, 140, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (145, '145', '通信类', 'XFRYGW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (146, '146', '通讯员', 'XFRYGW', NULL, 145, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (147, '147', '财务均需类', 'XFRYGW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (148, '148', '炊事员', 'XFRYGW', NULL, 147, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (149, '149', '其他', 'XFRYGW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (150, '150', '公安', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (151, '151', '交通', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 2);
INSERT INTO `cb_data_dictionary` VALUES (152, '152', '反恐', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 3);
INSERT INTO `cb_data_dictionary` VALUES (153, '153', '应急', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 4);
INSERT INTO `cb_data_dictionary` VALUES (154, '154', '供水', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 5);
INSERT INTO `cb_data_dictionary` VALUES (155, '155', '供电', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 6);
INSERT INTO `cb_data_dictionary` VALUES (156, '156', '供气', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 7);
INSERT INTO `cb_data_dictionary` VALUES (157, '157', '供热', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 8);
INSERT INTO `cb_data_dictionary` VALUES (158, '158', '通信', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 9);
INSERT INTO `cb_data_dictionary` VALUES (159, '159', '医疗救护', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 10);
INSERT INTO `cb_data_dictionary` VALUES (160, '160', '铁路', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 11);
INSERT INTO `cb_data_dictionary` VALUES (161, '161', '公路', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 12);
INSERT INTO `cb_data_dictionary` VALUES (162, '162', '民航', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 13);
INSERT INTO `cb_data_dictionary` VALUES (163, '163', '环保', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 14);
INSERT INTO `cb_data_dictionary` VALUES (164, '164', '气象', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 15);
INSERT INTO `cb_data_dictionary` VALUES (165, '165', '安监', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 16);
INSERT INTO `cb_data_dictionary` VALUES (166, '166', '海事', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 17);
INSERT INTO `cb_data_dictionary` VALUES (167, '167', '地震', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 18);
INSERT INTO `cb_data_dictionary` VALUES (168, '168', '水利', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 19);
INSERT INTO `cb_data_dictionary` VALUES (169, '169', '林业', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 20);
INSERT INTO `cb_data_dictionary` VALUES (170, '170', '新闻宣传', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 21);
INSERT INTO `cb_data_dictionary` VALUES (171, '171', '武警', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 22);
INSERT INTO `cb_data_dictionary` VALUES (172, '172', '防化部队', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 23);
INSERT INTO `cb_data_dictionary` VALUES (173, '173', '工程兵部队', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 24);
INSERT INTO `cb_data_dictionary` VALUES (174, '174', '陆航', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 25);
INSERT INTO `cb_data_dictionary` VALUES (175, '175', '建筑单位', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 26);
INSERT INTO `cb_data_dictionary` VALUES (176, '176', '其他有关单位', 'YJLDDW', '应急联动单位类别', NULL, NULL, NULL, NULL, b'0', 27);
INSERT INTO `cb_data_dictionary` VALUES (177, '177', '消防车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (178, '178', '通信指挥车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (179, '179', '快速调动车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (180, '180', '主力泡沫车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (181, '181', '重型泡沫车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (182, '182', '中型泡沫车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (183, '183', '破拆抢险车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (184, '184', '火场照明车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (185, '185', '干粉车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (186, '186', '保障车', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (187, '187', '其他', 'CLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (188, '188', '通知', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (189, '189', '待命', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (190, '190', '出动', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (191, '191', '途中', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (192, '192', '到场', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (193, '193', '出水', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (194, '194', '停水', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (195, '195', '返队', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (196, '196', '执勤', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (197, '197', '驻防', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (198, '198', '其他', 'CLQWZT', NULL, 190, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (199, '199', '训练', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (200, '200', '加油', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (201, '201', '试车', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (202, '202', '验收', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (203, '203', '公务', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (204, '204', '故障', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (205, '205', '修理', 'CLQWZT', NULL, 204, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (206, '206', '保养', 'CLQWZT', NULL, 204, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (207, '207', '其他', 'CLQWZT', NULL, 204, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (208, '208', '报废', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (209, '209', '演练', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (210, '210', '其他', 'CLQWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (211, '211', '民用建筑', 'JZWSYXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (212, '212', '住宅', 'JZWSYXZ', NULL, 211, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (213, '213', '集体宿舍', 'JZWSYXZ', NULL, 211, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (214, '214', '公共', 'JZWSYXZ', NULL, 211, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (215, '215', '工业建筑', 'JZWSYXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (216, '216', '农业建筑', 'JZWSYXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (217, '217', '民用机场', 'JZWSYXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (218, '218', '航站楼', 'JZWSYXZ', NULL, 217, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (219, '219', '停车场', 'JZWSYXZ', NULL, 217, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (220, '220', '集体宿舍', 'JZWSYXZ', NULL, 217, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (221, '221', '驻场单位', 'JZWSYXZ', NULL, 217, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (222, '222', '其他', 'JZWSYXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (226, '226', '人工上报', 'JQLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (228, '228', '对讲呼入', 'JQLY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (229, '229', '一般火灾', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (230, '230', '航空器救援', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 2);
INSERT INTO `cb_data_dictionary` VALUES (235, '235', '突发事件救援', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 3);
INSERT INTO `cb_data_dictionary` VALUES (237, '237', '漏油现场安全保障', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 4);
INSERT INTO `cb_data_dictionary` VALUES (238, '238', '专机保障', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 5);
INSERT INTO `cb_data_dictionary` VALUES (242, '242', '其他', 'JQLB', NULL, NULL, NULL, NULL, NULL, b'0', 6);
INSERT INTO `cb_data_dictionary` VALUES (243, '243', '一级', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (244, '244', '二级', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (245, '245', '三级', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (246, '246', '大火', 'HSQK', NULL, NULL, NULL, NULL, NULL, b'0', 3);
INSERT INTO `cb_data_dictionary` VALUES (247, '247', '中火', 'HSQK', NULL, NULL, NULL, NULL, NULL, b'0', 2);
INSERT INTO `cb_data_dictionary` VALUES (248, '248', '小火', 'HSQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (249, '249', '有烟', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (250, '250', '有浓烟', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (251, '251', '有火星', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (252, '252', '有火光', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (253, '253', '有烟有火', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (254, '254', '有爆炸声', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (255, '255', '其他', 'YWQK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (256, '256', '固体', 'RSWXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (257, '257', '液体', 'RSWXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (258, '258', '气体', 'RSWXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (259, '259', '其他', 'RSWXZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (260, '260', '警情接报', 'JCJYWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (261, '261', '力量调派', 'JCJYWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (262, '262', '值班确警', 'JCJYWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (263, '263', '处置跟踪', 'JCJYWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (264, '264', '处置结束', 'JCJYWZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (265, '265', '预案调派', 'LLDPLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (266, '266', '自主调派', 'LLDPLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (267, '267', '车辆', 'LLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (268, '268', '人员', 'LLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (269, '269', '队伍', 'LLLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (270, '270', '呼入', 'DHHJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (271, '271', '呼出', 'DHHJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (272, '272', '其他', 'DHHJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (273, '273', '警情报送', 'BSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (274, '274', '融合调度', 'BSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (275, '275', '外部协调', 'BSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (276, '276', '力量调度（任务派发）', 'BSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (277, '277', '警情接报', 'DHYWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (278, '278', '融合调度', 'DHYWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (279, '279', '力量调度', 'DHYWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (280, '280', '通知', 'ZZZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (281, '281', '待命', 'ZZZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (282, '282', '出动', 'ZZZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (283, '283', '途中', 'ZZZT', NULL, 282, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (284, '284', '到场', 'ZZZT', NULL, 282, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (285, '285', '返队', 'ZZZT', NULL, 282, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (286, '286', '执勤', 'ZZZT', NULL, 282, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (287, '287', '其他', 'ZZZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (288, '288', '灭火出动', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (289, '289', '火情侦察', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (290, '290', '战斗展开', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (291, '291', '灭火', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (292, '292', '火场救人', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (293, '293', '疏散和保护物资', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (294, '294', '火场破拆', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (295, '295', '战斗结束', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (296, '296', '总结汇报', 'SZZHZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (297, '297', '警情初报', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (298, '298', '警情归并', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (299, '299', '非警情', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (300, '300', '其他', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (301, '301', '系统报送', 'BSFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (302, '302', '短信报送', 'BSFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (303, '303', '电话语音提醒', 'BSFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (304, '304', '其他', 'BSFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (305, '305', '05L', 'PJPD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (306, '306', '05R', 'PJPD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (307, '307', '23L', 'PJPD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (308, '308', '23R', 'PJPD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (309, '309', '后续在维护', 'GWZZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (310, '310', '其他', 'GWZZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (311, '311', '电话', 'JQBSFS', NULL, NULL, 'tb6', '2810078', '2021-06-18 13:59:01', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (312, '312', '短信', 'JQBSFS', NULL, NULL, 'tb6', '2810078', '2021-06-18 13:59:37', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (313, '313', '警情续报', 'JQBSLX', NULL, NULL, 'tb6', '2810078', '2021-06-18 14:01:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (314, '314', '非警情确认', 'JQBSLX', NULL, NULL, 'tb6', '2810078', '2021-06-18 14:01:35', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (315, '315', '警情结案', 'JQBSLX', NULL, NULL, 'tb6', '2810078', '2021-06-18 14:01:39', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (316, '316', '有', 'YWWXP', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (317, '317', '无', 'YWWXP', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (318, '318', '航站楼', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (319, '319', '停车场', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (320, '320', '集体宿舍', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (321, '321', '驻场单位', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (322, '322', '集体宿舍', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (323, '323', '工业建筑', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (324, '324', '农业建筑', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (325, '325', '民用机场', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (326, '326', '住宅', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (327, '327', '其他', 'JZWLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (331, '331', '融合调度', 'JQDDLX', NULL, NULL, 'tb6', '2810078', '2021-06-18 15:04:49', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (332, '332', '外部协调', 'JQDDLX', NULL, NULL, 'tb6', '2810078', '2021-06-18 15:05:00', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (333, '333', '组长', 'JGNBZW', NULL, NULL, NULL, NULL, '2021-06-22 10:21:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (334, '334', '副组长', 'JGNBZW', NULL, NULL, NULL, NULL, '2021-06-22 10:22:27', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (335, '335', '管理负责人', 'JGNBZW', NULL, NULL, NULL, NULL, '2021-06-22 10:22:50', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (336, '336', '成员', 'JGNBZW', NULL, NULL, NULL, NULL, '2021-06-22 10:23:08', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (337, '337', '无', 'JGNBZW', NULL, NULL, NULL, NULL, '2021-06-22 10:23:24', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (338, '338', '法定代表人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:27:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (339, '339', '部门负责人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:27:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (340, '340', '消防安全负责人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:28:23', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (341, '341', '消防安全管理人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:28:51', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (342, '242', '归口管理部门负责人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:29:38', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (343, '343', '专职义务消防队管理人', 'XFGLGW', NULL, NULL, NULL, NULL, '2021-06-22 10:30:09', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (344, '344', '身份证', 'ZJLX', NULL, NULL, NULL, NULL, '2021-06-22 11:33:13', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (345, '345', '军官证', 'ZJLX', NULL, NULL, NULL, NULL, '2021-06-22 11:33:35', b'0', 2);
INSERT INTO `cb_data_dictionary` VALUES (346, '346', '男', 'XB', NULL, NULL, NULL, NULL, '2021-06-24 14:54:09', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (347, '347', '女', 'XB', NULL, NULL, NULL, NULL, '2021-06-24 14:54:28', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (348, '348', '是', 'AQPX', NULL, NULL, NULL, NULL, '2021-06-24 14:55:25', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (349, '349', '否', 'AQPX', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (350, '350', '1', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (351, '351', '2', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (352, '352', '3', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (353, '353', '4', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (354, '354', '5', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (355, '355', '6', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (356, '356', '7', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (357, '357', '8', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (358, '358', '9', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (359, '359', '10', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (360, '360', '11', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:55:46', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (361, '361', '12', 'SHZQ', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (362, '362', '电气焊工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (363, '363', '电工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (364, '364', '烘烤工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (365, '365', '熬炼工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (366, '366', '油漆工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (367, '367', '清洗工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (368, '368', '木工', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (369, '369', '仓库保管员', 'CZLB', NULL, NULL, NULL, NULL, '2021-06-24 14:59:59', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (370, '370', '一般单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:39:16', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (371, '371', '重点单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:40:34', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (372, '372', '驻场单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:41:54', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (373, '373', '外部协议单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:46:12', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (374, '374', '场内联动单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:46:16', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (375, '375', '供应商单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:46:19', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (376, '376', '消防维护单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:52:23', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (377, '377', '其他单位', 'GLLB', NULL, NULL, NULL, NULL, '2021-06-24 15:52:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (378, '378', '事业单位', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:00:49', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (379, '379', '国家行政机关', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:00:52', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (380, '380', '政府', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:00:54', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (381, '381', '国有企业', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:00:57', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (382, '382', '国有控股企业', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:01:03', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (383, '383', '私营企业', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:01:07', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (384, '384', '外资企业', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:01:10', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (385, '385', '合资企业', 'DWXZ', NULL, NULL, NULL, NULL, '2021-06-24 16:01:12', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (386, 'hydrant', '消火栓', 'XFSYLX', NULL, NULL, NULL, NULL, '2021-06-28 10:45:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (387, 'crane', '消防水鹤', 'XFSYLX', NULL, NULL, NULL, NULL, '2021-06-28 10:45:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (388, 'pool', '消防水池', 'XFSYLX', NULL, NULL, NULL, NULL, '2021-06-28 10:45:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (389, 'natural', '天然水源', 'XFSYLX', NULL, NULL, NULL, NULL, '2021-06-28 10:45:26', b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (390, '738', '金属氰化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (391, '739', '有机酰卤', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (392, '740', '芳香烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (393, '741', '卤素与卤间化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (394, '742', '酚', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (395, '743', '腈', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (396, '744', '氨', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (397, '745', '金属乙炔化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (398, '746', '硝基烷烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (399, '747', '金属氨基化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (400, '748', '非金属氧化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (401, '749', '羧酸酯', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (402, '750', '金属氧化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (403, '751', '磷化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (404, '752', '非金属氢化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (405, '753', '无机酰卤', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (406, '754', '金属氢化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (407, '755', '有机迭氮化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (408, '756', '二甲亚砜', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (409, '757', '卤代硅烷', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (410, '758', '环氧化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (411, '759', '卤代烷', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (412, '760', '硅烷', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (413, '761', '卤代炔', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (414, '762', '脂肪胺', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (415, '763', '非活泼金属', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (416, '764', '卤素含氧酸盐', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (417, '765', '卤代烯', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (418, '766', '无机酸', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (419, '767', '酰胺', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (420, '768', '有机过氧化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (421, '769', '硝酸酯', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (422, '770', '醚', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (423, '771', '烷烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (424, '772', '金属烷氧化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (425, '773', '醛', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (426, '774', '硼烷', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (427, '775', '酮', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (428, '776', '非金属卤化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (429, '777', '铬酸盐', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (430, '778', '酸酐', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (431, '779', '非金属单质', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (432, '780', '烯烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (433, '781', '丙烯酰基化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (434, '782', '无机碱', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (435, '783', '硫化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (436, '784', '卤代芳烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (437, '785', '芳香胺', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (438, '786', '硫酸', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (439, '787', '硝基芳香化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (440, '788', '无机迭氮化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (441, '789', '醇', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (442, '790', '硝酸', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (443, '791', '无机过氧化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (444, '792', '空气(氧气)', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (445, '793', '硝酸盐', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (446, '794', '金属烃基化合物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (447, '795', '有机酸', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (448, '796', '炔烃', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (449, '797', '金属卤化物', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (450, '798', '高锰酸盐', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (451, '799', '活泼金属', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (452, '800', '未指定的化学类别', 'CHEMICALTYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (801, '801', '涡轮风扇发动机', 'FDJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (802, '802', '涡轮喷气式发动机', 'FDJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (803, '803', '涡轮螺旋桨发动机', 'FDJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (804, '804', '活塞式发动机', 'FDJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (805, '805', '其他', 'FDJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (806, '806', '航空汽油', 'RYLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (807, '807', '航空煤油', 'RYLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (808, '808', '航空柴油', 'RYLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (809, '809', '市政', 'HSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (810, '810', '单位', 'HSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (811, '811', '居民', 'HSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (812, '812', '其他', 'HSLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (813, '813', '干式', 'XHSXTLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (814, '814', '湿式', 'XHSXTLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (815, '815', '室外', 'XHSFZXS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (816, '816', '地上', 'XHSFZXS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (817, '817', '地下', 'XHSFZXS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (818, '818', '室内', 'XHSFZXS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (819, '819', '其他', 'XHSFZXS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (820, '820', '卡式', 'XFSDJK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (821, '821', '内扣式', 'XFSDJK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (822, '822', '螺纹式', 'XFSDJK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (823, '823', '其他', 'XFSDJK', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (824, '824', '值班主班', 'DUTY_POST_TYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (825, '825', '值班副班', 'DUTY_POST_TYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (826, '826', '值班领导', 'DUTY_POST_TYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (827, '827', '值班组员', 'DUTY_POST_TYPE', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (828, '828', '协议', 'LDDWLB', '联动单位类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (829, '829', '联动', 'LDDWLB', '联动单位类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (830, '830', '企（事）业单位医疗救援队（站）', 'XFJGLX', NULL, 113, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (831, '831', '项目负责人', 'WBRYLB', '维保人员类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (832, '832', '消防设置操作员', 'WBRYLB', '维保人员类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (833, '833', '其他', 'WBRYLB', '维保人员类别', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (834, '834', '在职', 'WBRYZT', '维保人员状态', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (835, '835', '休假', 'WBRYZT', '维保人员状态', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (836, '836', '离职', 'WBRYZT', '维保人员状态', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (837, '837', '一级注册消防工程师', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (838, '838', '二级注册消防工程师', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (839, '839', '三级/高级技能', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (840, '840', '四级/中级技能', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (841, '841', '五级/初级技能', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (842, '842', '其他', 'WBZYZS', '维保人员职业资格证书', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (843, '843', '注册消防工程师', 'WBZYZG', '维保人员职业资格', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (844, '844', '消防设施操作员', 'WBZYZG', '维保人员职业资格', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (845, '845', '建（构）筑物消防员', 'WBZYZG', '维保人员职业资格', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (846, '846', '其他', 'WBZYZG', '维保人员职业资格', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (847, '847', '12T 吊车', 'JYZBLX', '救援装备类型', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (848, '848', '20T 吊车', 'JYZBLX', '救援装备类型', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (849, '849', '25T 吊车', 'JYZBLX', '救援装备类型', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (850, '850', '55T 吊车', 'JYZBLX', '救援装备类型', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (851, '851', '75T 吊车', 'JYZBLX', '救援装备类型', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (852, '852', '一级', 'NHDJ', '耐火等级', NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (853, '853', '二级', 'NHDJ', '耐火等级', NULL, NULL, NULL, NULL, b'0', 2);
INSERT INTO `cb_data_dictionary` VALUES (854, '854', '三级', 'NHDJ', '耐火等级', NULL, NULL, NULL, NULL, b'0', 3);
INSERT INTO `cb_data_dictionary` VALUES (855, '855', '四级', 'NHDJ', '耐火等级', NULL, NULL, NULL, NULL, b'0', 4);
INSERT INTO `cb_data_dictionary` VALUES (856, '856', '主动反馈', 'FKFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (857, '857', '电话回访', 'FKFS', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (858, '858', '未完成', 'WCZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (859, '859', '已完成', 'WCZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (860, '860', '已接警', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (861, '861', '已派遣', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (862, '862', '救援已到达', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (863, '863', '维保已到达', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (864, '864', '救援完成', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (865, '865', '救援回访', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (866, '866', '维修完成', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (867, '867', '报修人已反馈', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (868, '868', '维保已处置', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (869, '869', '投诉人已回访', 'CZHJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (870, '870', '一级响应', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (871, '871', '二级响应', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (872, '872', '三级响应', 'XYJB', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (873, '873', '人为原因', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (874, '874', '外部原因', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (875, '875', '门系统', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (876, '876', '曳引系统', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (877, '877', '导向系统', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (878, '878', '轿厢', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (879, '879', '控制系统', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (880, '880', '电气系统', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (881, '881', '安全保护装置', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (882, '882', '生活垃圾导致开关门受阻，电梯停止运行', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (883, '883', '野蛮搬运导致门变形，电梯无法运行', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (884, '884', '装修垃圾导致开关门受阻，电梯停止运行', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (885, '885', '超载', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (886, '886', '阻挡关门时间过长，电梯无法运行', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (887, '887', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (888, '888', '电梯在运行过程中出现的停电', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (889, '889', '	\r\n电气部件进水导致的短路故障', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (890, '890', '机房温度过高，电气控制系统自动保护', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (891, '891', '	\r\n故障后自动回复运行', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (892, '892', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (893, '893', '轿门锁失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (894, '894', '厅门锁失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (895, '895', '门机故障', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (896, '896', '门刀与滚轮（球）间距调整不良', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (897, '897', '安全触板、光幕等防夹人保护装置无效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (898, '898', '主动门与从动门之间的联动失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (899, '899', '门触点失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (900, '900', '门挂轮破损', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (901, '901', '门导向系统失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (902, '902', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (903, '903', '平衡系数不在标准范围内', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (904, '904', '曳引轮（轴）磨损超出标准范围内', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (905, '905', '曳引机缺油或油量过多', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (906, '906', '传动皮带过松', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (907, '907', '	\r\n钢丝绳卡阻或跳槽', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (908, '908', '	\r\n钢丝绳磨损超出标准范围', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (909, '909', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (910, '910', '导靴磨损超出标准范围', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (911, '911', '导轨润滑缺陷', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (912, '912', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (913, '913', '轿厢壁变形', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (914, '914', '照明失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (915, '915', '紧急报警失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (916, '916', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (917, '917', '控制主板失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (918, '918', '电气元器件（接触器、继电器、驱动器件等）失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (919, '919', '平层感应器失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (920, '920', '极限开关、急停开关、维修开关等传感器失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (921, '921', '电气连接不可靠', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (922, '922', '编码器失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (923, '923', '主电源开关失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (924, '924', '	\r\n召唤失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (925, '925', '电梯重启故障', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (926, '926', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (927, '927', '变频器失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (928, '928', '电动机失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (929, '929', '制动器故障', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (930, '930', '主电源断开', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (931, '931', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (932, '932', '安全回路断开', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (933, '933', '消防开关失效', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (934, '934', '限速器开关动作', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (935, '935', '	\r\n安全钳开关动作', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (936, '936', '	\r\n缓冲器开关动作', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (937, '937', '张紧轮开关动作', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (938, '938', '上行超速保护开关动作', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (939, '939', '其他', 'GZYY', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (940, '940', '维修成功', 'WXJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (941, '941', '其他', 'WXJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (942, '942', '满意', 'FKJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (943, '943', '不满意', 'FKJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (944, '944', '已处置', 'CZJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (945, '945', '未处置', 'CZJG', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (946, '946', '困人救援', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (947, '947', '故障维修', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (948, '948', '投诉咨询', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (949, '949', '使用单位', 'PQDW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (950, '950', '维保单位', 'PQDW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (951, '951', '一级响应', 'PQDW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (952, '952', '二级响应', 'PQDW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (953, '953', '三级响应', 'PQDW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (954, '954', '电话呼入', 'JQLYN', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (955, '955', '电梯', 'TZSBFL', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (956, '956', '已派遣', 'PQZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (957, '957', '未派遣', 'PQZT', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (958, '958', '警情初报', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (959, '959', '警情归并', 'BJLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (960, '960', '困人救援', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (961, '961', '故障维修', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (962, '962', '投诉咨询', 'JQLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (963, '963', '电话报警', 'JQLYLX', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (964, '964', '接警', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (965, '965', '派遣', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (966, '966', '抵达', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (967, '967', '救出', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (968, '968', '救援回访', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (969, '969', '维修反馈', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (970, '970', '报修反馈', 'JQJD', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1001, NULL, '一级', 'BZDJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1002, NULL, '二级', 'BZDJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1003, NULL, '三级', 'BZDJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1004, NULL, '四级', 'BZDJ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1005, '1005', '101', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1006, '1006', '102', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1007, '1007', '103', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1008, '1008', '104', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1009, '1009', '105', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1010, '1010', '106', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1011, '1011', '107', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1012, '1012', '108', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1013, '1013', '109', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1014, '1014', '110', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1015, '1015', '111', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1016, '1016', '112', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1017, '1017', '113', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1018, '1018', '114', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1019, '1019', '115', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1020, '1020', '116', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1021, '1021', '117', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1022, '1022', '118', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1023, '1023', '119', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1024, '1024', '120', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1025, '1025', '121', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1026, '1026', '122', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1027, '1027', '123', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1028, '1028', '124', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1029, '1029', '125', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1030, '1030', '126', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1031, '1031', '127', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1032, '1032', '128', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1033, '1033', '129', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1034, '1034', '130', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1035, '1035', '131', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1036, '1036', '132', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1037, '1037', '133', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1038, '1038', '134', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1039, '1039', '135', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1040, '1040', '136', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1041, '1041', '137', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1042, '1042', '138', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1043, '1043', '139', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1044, '1044', '140', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1045, '1045', '141', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1046, '1046', '142', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1047, '1047', '143', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1048, '1048', '144', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1049, '1049', '145', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1050, '1050', '147', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1051, '1051', '148', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1052, '1052', '201', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1053, '1053', '202', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1054, '1054', '203', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1055, '1055', '204', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1056, '1056', '205', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1057, '1057', '206', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1058, '1058', '207', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1059, '1059', '208', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1060, '1060', '209', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1061, '1061', '210', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1062, '1062', '211', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1063, '1063', '212', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1064, '1064', '213', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1065, '1065', '214', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1066, '1066', '215', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1067, '1067', '216', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1068, '1068', '217', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1069, '1069', '218', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1070, '1070', '219', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1071, '1071', '220', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1072, '1072', '221', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1073, '1073', '222', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1074, '1074', '223', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1075, '1075', '224', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1076, '1076', '225', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1077, '1077', '301', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1078, '1078', '302', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1079, '1079', '303', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1080, '1080', '304', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1081, '1081', '305', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1082, '1082', '306', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1083, '1083', '307', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1084, '1084', '308', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1085, '1085', '309', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1086, '1086', '310', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1087, '1087', '311', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1088, '1088', '312', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1089, '1089', '313', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1090, '1090', '314', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1091, '1091', '315', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1092, '1092', '316', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1093, '1093', '317', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1094, '1094', '318', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1095, '1095', '319', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1096, '1096', '320', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1097, '1097', '321', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1098, '1098', '322', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1099, '1099', '324', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1100, '1100', '325', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1101, '1101', '326', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1102, '1102', '327', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1103, '1103', '328', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1104, '1104', '329', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1105, '1105', '330', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1106, '1106', '331', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1107, '1107', '332', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1108, '1108', '333', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1109, '1109', '334', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1110, '1110', '335', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1111, '1111', '336', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1112, '1112', '337', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1113, '1113', '338', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1114, '1114', '339', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1115, '1115', '340', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1116, '1116', '341', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1117, '1117', '342L', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1118, '1118', '342R', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1119, '1119', '343', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1120, '1120', '344L', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1121, '1121', '344R', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1122, '1122', '345', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1123, '1123', '346', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1124, '1124', '347', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1125, '1125', '348', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1126, '1126', '401', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1127, '1127', '402', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1128, '1128', '403', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1129, '1129', '404', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1130, '1130', '405', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1131, '1131', '406', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1132, '1132', '425', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1133, '1133', '701', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1134, '1134', '702', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1135, '1135', '703', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1136, '1136', '704', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1137, '1137', '705', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1138, '1138', '706', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1139, '1139', '707', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1140, '1140', '708', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1141, '1141', '709', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1142, '1142', '710', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1143, '1143', '711', 'FJJW', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1144, '1144', '左发动机', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1145, '1145', '右发动机', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1146, '1146', '襟翼故障', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1147, '1147', '起落架液压油故障', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1148, '1148', '货舱火灾报警', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1149, '1149', '刹车故障', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1150, '1150', '挡风玻璃裂', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);
INSERT INTO `cb_data_dictionary` VALUES (1151, '1151', '起落架转向故障', 'FJSSWZ', NULL, NULL, NULL, NULL, NULL, b'0', 1);

-- ----------------------------
-- Table structure for cb_duty_person_shift
-- ----------------------------
DROP TABLE IF EXISTS `cb_duty_person_shift`;
CREATE TABLE `cb_duty_person_shift`  (
  `sequence_nbr` bigint(20) NOT NULL COMMENT '物理主键',
  `duty_date` date NULL DEFAULT NULL COMMENT '值班日期',
  `shift_id` bigint(20) NULL DEFAULT NULL COMMENT '值班班次id',
  `instance_id` bigint(20) NOT NULL COMMENT '实例id',
  `rec_user_id` bigint(32) NULL DEFAULT NULL COMMENT '更新人员id',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人员',
  `rec_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  `app_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识（数据隔离使用）',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  UNIQUE INDEX `uni_idx_instance_id_duty_date`(`instance_id`, `duty_date`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '值班人员日期关联关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_duty_person_shift
-- ----------------------------

-- ----------------------------
-- Table structure for cb_duty_shift
-- ----------------------------
DROP TABLE IF EXISTS `cb_duty_shift`;
CREATE TABLE `cb_duty_shift`  (
  `sequence_nbr` bigint(20) NOT NULL COMMENT '物理主键',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '班次名称',
  `start_time` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '开始时间',
  `end_time` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结束时间',
  `color` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '颜色',
  `rec_user_id` bigint(32) NULL DEFAULT NULL COMMENT '更新人员id',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人员',
  `rec_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `app_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '系统标识（数据隔离使用）',
  `org_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件机构',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '值班班次' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_duty_shift
-- ----------------------------

-- ----------------------------
-- Table structure for cb_dynamic_form_column
-- ----------------------------
DROP TABLE IF EXISTS `cb_dynamic_form_column`;
CREATE TABLE `cb_dynamic_form_column`  (
  `sequence_nbr` bigint(20) NOT NULL COMMENT '物理主键',
  `field_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名',
  `field_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '中文名',
  `field_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段类型(web使用）',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组主键',
  `query_strategy` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `not_null` bit(1) NOT NULL DEFAULT b'0' COMMENT '不能为空',
  `block` bit(1) NULL DEFAULT b'0' COMMENT '是否一行显示(兼容已有动态表单使用)',
  `group_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '所属分组编号',
  `column_config` json NULL COMMENT '配置json',
  `rec_user_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人名称',
  `rec_user_id` varchar(19) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员',
  `rec_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提示信息',
  `sort` bigint(11) NULL DEFAULT NULL,
  `org_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  UNIQUE INDEX `unique_idx_code_type_name`(`group_code`, `field_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动态表单树形分组字段表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_dynamic_form_column
-- ----------------------------
INSERT INTO `cb_dynamic_form_column` VALUES (7, 'businessCategory', '经营类别', 'select', 7, 'eq', b'0', b'0', '244', '{\"url\": \"\", \"data\": [], \"dict\": \"GLLB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 10:58:11', b'0', NULL, 5, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (9, 'companyLocation', '单位地址', 'inputPoi', 7, 'like', b'0', b'0', '244', '{\"url\": \"http://172.16.10.66:3011\", \"type\": \"url\"}', NULL, NULL, '2021-08-19 10:29:38', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (10, 'companyPhone', '单位电话', 'input', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-07-07 02:59:34', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (11, 'companyMaleEmployees', '男员工人数', 'inputNumber', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-07-12 03:06:11', b'0', NULL, 7, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (12, 'companyFemaleEmployees', '女员工人数', 'inputNumber', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-07-12 03:06:13', b'0', NULL, 8, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (13, 'companyPhoto', '单位照片', 'upload', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-07-07 02:59:31', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (14, 'coordinate', '标注/标绘坐标数组', 'inputBitmap', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-08-19 09:13:14', b'1', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (15, 'managementType', '管理类别', 'select', 7, 'eq', b'0', b'0', '244', '{\"url\": \"\", \"data\": [], \"dict\": \"GLLB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 10:58:59', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (16, 'companyNature', '单位性质', 'select', 7, 'eq', b'0', b'0', '244', '{\"url\": \"\", \"data\": [], \"dict\": \"DWXZ\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 10:58:44', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (17, 'departmentPhoto', '部门照片', 'upload', 8, 'eq', b'0', b'0', '245', NULL, NULL, NULL, '2021-07-07 02:53:52', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (18, 'departmentPhone', '下属部门电话', 'input', 8, 'like', b'0', b'0', '245', NULL, NULL, NULL, '2021-07-12 03:06:48', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (19, 'MaleEmployees', '部门男员工人数', 'inputNumber', 8, 'eq', b'0', b'0', '245', NULL, NULL, NULL, '2021-07-12 03:06:25', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (20, 'FemaleEmployees', '部门女员工人数', 'inputNumber', 8, 'eq', b'0', b'0', '245', NULL, NULL, NULL, '2021-07-12 03:06:27', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (21, 'departmentLocation', '部门地址', 'input', 8, 'like', b'0', b'0', '245', NULL, NULL, NULL, '2021-07-07 02:53:45', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (22, 'gender', '性别', 'radio', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"XB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:41:04', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (23, 'certificatesTypeCode', '证件类型', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"RYZJLX\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:41:25', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (24, 'telephone', '联系电话', 'input', 9, 'like', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:52', b'0', NULL, 5, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (25, 'stateCode', '人员状态', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"RYZT\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:02', b'0', NULL, 6, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (26, 'internalPositionCode', '消防管理组织机构内部职务', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"JGNBZW\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:04', b'0', NULL, 9, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (27, 'fireManagementPostCode', '消防管理岗位', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"XFGLGW\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:28', b'0', NULL, 10, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (28, 'administrativePositionCode', '行政职务', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"XZZW\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:29', b'0', NULL, 8, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (29, 'safetyTraining', '是否进行安全培训', 'radio', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"AQPX\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:39', b'0', NULL, 7, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (30, 'positionType', '岗位类型', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"GWMC\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:42:59', b'0', NULL, 11, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (31, 'certificateType', '持证类别', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"CZLB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:43:09', b'0', NULL, 12, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (32, 'holdingTime', '持证时间', 'datetime', 9, 'eq', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:41', b'0', NULL, 13, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (33, 'auditCycle', '审核周期', 'select', 9, 'eq', b'0', b'0', '246', '{\"url\": \"\", \"data\": [], \"dict\": \"SHZQ\", \"type\": \"dict\"}', NULL, NULL, '2021-07-07 07:43:12', b'0', NULL, 14, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (34, 'personImg', '人员照片', 'upload', 9, 'eq', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:41', b'0', NULL, 15, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (35, 'certificatesNumber', '证件号码', 'input', 9, 'like', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:48', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (36, 'certificateImg', '重点工种资质证书', 'upload', 9, 'eq', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:41', b'0', NULL, 16, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (37, 'personNumber', '员工编号', 'input', 9, 'like', b'0', b'0', '246', NULL, NULL, NULL, '2021-07-07 02:47:57', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810001, 'userId', '用户id', 'input', 132828674810, 'eq', b'1', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:35', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810002, 'userName', '用户名称', 'input', 132828674810, 'like', b'0', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:38', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810003, 'carId', '车辆id', 'input', 132828674810, 'eq', b'1', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:45', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810004, 'carName', '车辆名称', 'input', 132828674810, 'like', b'0', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:45', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810005, 'teamId', '消防队伍id', 'input', 132828674810, 'eq', b'1', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:50', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810006, 'teamName', '消防队伍名称', 'input', 132828674810, 'like', b'0', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:50', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810007, 'postType', '岗位id', 'input', 132828674810, 'eq', b'1', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:53', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674810008, 'postTypeName', '岗位名称', 'input', 132828674810, 'like', b'0', b'0', 'dutyCar', NULL, NULL, NULL, '2021-07-06 08:19:53', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811001, 'userId', '用户id', 'input', 132828674811, 'eq', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811002, 'userName', '用户名称', 'input', 132828674811, 'like', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811003, 'deptId', '部门id', 'input', 132828674811, 'eq', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811004, 'deptName', '部门名称', 'input', 132828674811, 'like', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811005, 'postType', '岗位id', 'input', 132828674811, 'eq', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674811006, 'postTypeName', '岗位名称', 'input', 132828674811, 'like', b'0', b'0', 'dutyPerson', NULL, NULL, NULL, '2021-07-13 02:29:15', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812006, 'beginDate', '值班开始时间', 'input', 132828674812, 'ge', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-15 02:56:51', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812007, 'endDate', '值班结束时间', 'input', 132828674812, 'le', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-15 02:57:43', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812008, 'jsDutyLeader', '机场值班领导', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812009, 'fireDutyLeader', '消救部领导', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812010, 'branchDutyLeader', '消防支队领导', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812011, 'emcDutyLeader', '应急指挥科领导', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812012, 'dutyPersonOne', '值班员正班', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812013, 'dutyPersonTwo', '值班员副班', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812014, 'succeedPersonOne', '接班员正班', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:39', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812015, 'succeedPersonTwo', '接班员副班', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:40', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812016, 'dutyPersonLeader', '值班员经理', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:40', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812017, 'succeedPersonLeader', '接班员经理', 'input', 132828674812, 'like', b'0', b'0', 'shiftChanges', NULL, NULL, NULL, '2021-07-13 02:28:40', b'0', NULL, NULL, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812018, 'fireRescueCapability', '消防救援能力', 'input', 132828674813, 'like', b'0', b'0', 'linkageUnit', NULL, NULL, NULL, '2021-07-15 02:28:35', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812019, 'responsibilitiesSituation', '职责_简要情况', 'input', 132828674813, 'like', b'0', b'0', 'linkageUnit', NULL, NULL, NULL, '2021-07-15 02:28:36', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812020, 'emergencyServiceContent', '应急服务内容', 'input', 132828674813, 'like', b'0', b'0', 'linkageUnit', NULL, NULL, NULL, '2021-07-15 02:28:36', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812021, 'unitSituation', '单位_简要情况', 'input', 132828674813, 'like', b'0', b'0', 'linkageUnit', NULL, NULL, NULL, '2021-07-15 02:28:37', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812023, 'formerName', '企业曾用名', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 06:03:13', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812024, 'legalPerson', '法人代表', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:22:50', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812025, 'address', '地址', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:22:53', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812026, 'coordinate', '标注/标绘坐标数组', 'inputBitmap', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-08-19 09:03:15', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812027, 'nature', '企业性质', 'select', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:22:57', b'0', NULL, 5, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812028, 'nation', '国别', 'select', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:00', b'0', NULL, 6, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812029, 'province', '所在省份', 'select', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:01', b'0', NULL, 7, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812030, 'mainProductType', '主要产品类型', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:03', b'0', NULL, 8, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812031, 'totalFixedAssets', '固定资产总值', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:05', b'0', NULL, 9, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812032, 'draftingTechStandards', '拟制技术标准', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:07', b'0', NULL, 10, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812033, 'totalStaff', '总人数', 'inputNumber', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:08', b'0', NULL, 11, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812034, 'technicianNumber', '技术人员数量', 'inputNumber', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:09', b'0', NULL, 12, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812035, 'enterpriseType', '生产企业类型', 'select', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:10', b'0', NULL, 13, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812036, 'qualification', '资质', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:11', b'0', NULL, 14, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812037, 'history', '历史沿革', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:12', b'0', NULL, 15, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812038, 'mainTestEquipment', '主要检测设备', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:13', b'0', NULL, 16, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812039, 'majorDevelopRecord', '重大研制记录', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:15', b'0', NULL, 17, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812040, 'salesTel', '销售电话', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:16', b'0', NULL, 18, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812041, 'serviceTel', '服务电话', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-15 09:23:18', b'0', NULL, 19, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812042, 'gender', '性别', 'radio', 11, 'eq', b'0', b'0', 'maintenancePerson', '{\"url\": \"\", \"data\": [], \"dict\": \"XB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-26 13:43:32', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812043, 'nation', '民族', 'select', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-16 02:07:10', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812044, 'idNumber', '身份证号码', 'input', 11, 'like', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-16 02:07:04', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812045, 'tel', '手机号码', 'input', 11, 'like', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-16 02:07:08', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812046, 'professionalCertificate', '职业资格证书', 'select', 11, 'eq', b'0', b'0', 'maintenancePerson', '{\"url\": \"\", \"data\": [], \"dict\": \"WBZYZS\", \"type\": \"dict\"}', NULL, NULL, '2021-07-21 09:45:58', b'0', NULL, 8, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812047, 'qualification', '职业资格', 'select', 11, 'eq', b'0', b'0', 'maintenancePerson', '{\"url\": \"\", \"data\": [], \"dict\": \"WBZYZG\", \"type\": \"dict\"}', NULL, NULL, '2021-07-21 09:56:46', b'0', NULL, 9, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812048, 'certificateNo', '证书编号', 'input', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-21 09:28:41', b'0', NULL, 10, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812050, 'amosAccount', '系统账户', 'treeSelect', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-21 12:57:58', b'0', NULL, 6, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812051, 'registerId', '注册号', 'input', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-21 09:27:45', b'0', NULL, 11, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812052, 'category', '类别', 'select', 11, 'eq', b'0', b'0', 'maintenancePerson', '{\"url\": \"\", \"data\": [], \"dict\": \"WBRYLB\", \"type\": \"dict\"}', NULL, NULL, '2021-07-21 09:46:59', b'0', NULL, 5, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812053, 'status', '状态', 'select', 11, 'eq', b'0', b'0', 'maintenancePerson', '{\"url\": \"\", \"data\": [], \"dict\": \"WBRYZT\", \"type\": \"dict\"}', NULL, NULL, '2021-07-21 09:47:06', b'0', NULL, 7, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812054, 'remark', '备注', 'input', 10, 'like', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-19 13:41:07', b'0', NULL, 20, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812055, 'registeredCapital', '注册资本', 'input', 10, 'eq', b'0', b'0', 'maintenanceCompany', NULL, NULL, NULL, '2021-07-19 05:45:10', b'0', NULL, 21, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812057, 'registrationStartTime', '注册有效期开始时间', 'datetime', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-21 09:27:46', b'0', NULL, 12, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812058, 'registrationEndTime', '注册有效期结束时间', 'datetime', 11, 'eq', b'0', b'0', 'maintenancePerson', NULL, NULL, NULL, '2021-07-21 09:27:48', b'0', NULL, 13, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812060, 'building', '所在建筑', 'treeSelect', 132828674814, 'eq', b'0', b'0', 'maintenanceDepartment', NULL, NULL, NULL, '2021-07-27 07:00:16', b'0', NULL, 1, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812061, 'adrerss', '部门地址', 'input', 132828674814, 'like', b'0', b'0', 'maintenanceDepartment', NULL, NULL, NULL, '2021-07-20 11:03:37', b'0', NULL, 2, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812062, 'maleStaffNumber', '部门男员工人数', 'inputNumber', 132828674814, 'eq', b'0', b'0', 'maintenanceDepartment', NULL, NULL, NULL, '2021-07-25 16:31:52', b'0', NULL, 3, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812063, 'femaleStaffNumber', '部门女员工人数', 'inputNumber', 132828674814, 'eq', b'0', b'0', 'maintenanceDepartment', NULL, NULL, NULL, '2021-07-25 16:31:48', b'0', NULL, 4, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812064, 'tel', '下属部门电话', 'input', 132828674814, 'eq', b'0', b'0', 'maintenanceDepartment', NULL, NULL, NULL, '2021-07-20 11:07:04', b'0', NULL, 5, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812065, 'longitude', '经度', 'input', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-08-19 09:13:17', b'0', NULL, 9, NULL);
INSERT INTO `cb_dynamic_form_column` VALUES (132828674812066, 'latitude', '纬度', 'input', 7, 'eq', b'0', b'0', '244', NULL, NULL, NULL, '2021-08-19 09:13:19', b'0', NULL, 10, NULL);

-- ----------------------------
-- Table structure for cb_dynamic_form_group
-- ----------------------------
DROP TABLE IF EXISTS `cb_dynamic_form_group`;
CREATE TABLE `cb_dynamic_form_group`  (
  `sequence_nbr` bigint(20) NOT NULL COMMENT '物理主键',
  `group_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分组名称',
  `group_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分组编号',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父级id(树形关系时使用)',
  `group_config` json NULL COMMENT '分组配置',
  `org_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `rec_user_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人名称',
  `rec_user_id` varchar(19) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员',
  `rec_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  UNIQUE INDEX `unique_idx_group_code`(`group_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动态表单分组表(支持树形)' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_dynamic_form_group
-- ----------------------------
INSERT INTO `cb_dynamic_form_group` VALUES (7, '机场单位', '244', 0, NULL, '10', 1, NULL, NULL, '2021-07-07 10:25:47', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (8, '机场单位下属部门', '245', 0, NULL, '10', 1, NULL, NULL, '2021-07-07 02:26:36', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (9, '机场人员', '246', 0, NULL, '10', 1, NULL, NULL, '2021-07-07 02:26:41', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (10, '维保单位', 'maintenanceCompany', 0, NULL, '10', 1, NULL, NULL, '2021-07-15 11:55:05', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (11, '维保人员', 'maintenancePerson', 0, NULL, '10', 1, NULL, NULL, '2021-07-15 11:55:05', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (132828674810, '值班车辆', 'dutyCar', 0, NULL, '10', 1, NULL, NULL, '2021-07-06 08:00:03', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (132828674811, '值班排班', 'dutyPerson', 0, NULL, '10', 1, NULL, NULL, '2021-07-06 08:00:08', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (132828674812, '交接班', 'shiftChanges', 0, NULL, '10', 1, NULL, NULL, '2021-07-06 08:00:08', b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (132828674813, '联动单位', 'linkageUnit', 0, NULL, '10', 1, NULL, NULL, NULL, b'0');
INSERT INTO `cb_dynamic_form_group` VALUES (132828674814, '维保部门', 'maintenanceDepartment', 0, NULL, '10', 1, NULL, NULL, '2021-07-20 10:58:20', b'0');

-- ----------------------------
-- Table structure for cb_dynamic_form_instance
-- ----------------------------
DROP TABLE IF EXISTS `cb_dynamic_form_instance`;
CREATE TABLE `cb_dynamic_form_instance`  (
  `sequence_nbr` bigint(20) NOT NULL,
  `field_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '字段名',
  `field_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '中文名',
  `field_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '分组编号',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组id',
  `field_value` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动态配置字段的值',
  `field_value_label` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'field_value的描述（冗余字段，在列表时查询时显示）',
  `instance_id` bigint(20) NOT NULL COMMENT '设备实例id',
  `form_column_id` bigint(20) NOT NULL COMMENT '字段定义信息的主键',
  `query_strategy` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `rec_user_name` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人名称',
  `app_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用标识（数据隔离使用）',
  `rec_user_id` varchar(19) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员',
  `rec_date` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除(没用到)',
  `not_null` bit(1) NOT NULL DEFAULT b'0' COMMENT '不能为空',
  `block` bit(1) NULL DEFAULT b'0' COMMENT '是否一行显示(兼容已有动态表单使用)',
  `column_config` json NULL COMMENT '配置json',
  `sort` bigint(11) NULL DEFAULT NULL,
  `org_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  UNIQUE INDEX `u_idx_instance_id`(`instance_id`, `group_code`, `field_code`) USING BTREE,
  INDEX `idx_group_code`(`group_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动态表单实例表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_dynamic_form_instance
-- ----------------------------

-- ----------------------------
-- Table structure for cb_failure_audit
-- ----------------------------
DROP TABLE IF EXISTS `cb_failure_audit`;
CREATE TABLE `cb_failure_audit`  (
  `sequence_nbr` bigint(20) NOT NULL AUTO_INCREMENT,
  `auditor` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '审核人',
  `audit_department` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '审核部门',
  `audit_department_id` bigint(20) NULL DEFAULT NULL COMMENT '审核部门的id',
  `audit_result` int(255) NULL DEFAULT NULL COMMENT '审核结果 0：同意 1：拒绝 2：退回',
  `audit_time` datetime(0) NOT NULL COMMENT '审核时间',
  `audit_opinion` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '审核意见',
  `fault_id` bigint(20) NULL DEFAULT NULL COMMENT '设备故障报修单id',
  `rec_user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人ID',
  `rec_date` datetime(0) NOT NULL COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否已被删除(0：未删除，1：已删除)',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1428283868785528834 CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '故障报修审核记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_failure_audit
-- ----------------------------

-- ----------------------------
-- Table structure for cb_failure_details
-- ----------------------------
DROP TABLE IF EXISTS `cb_failure_details`;
CREATE TABLE `cb_failure_details`  (
  `sequence_nbr` bigint(64) NOT NULL,
  `current_status` bigint(30) NULL DEFAULT NULL COMMENT '当前状态',
  `failure_code` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '故障单号',
  `failure_equipment_id` int(11) NULL DEFAULT NULL COMMENT '故障设备ID',
  `failure_equipment` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '故障设备',
  `fault_time` date NOT NULL COMMENT '故障时间',
  `fault_phenomenon` varchar(300) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '故障现象',
  `submission_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '报送人',
  `submission_pid` int(30) NOT NULL COMMENT '报送人ID',
  `biz_code` bigint(50) NULL DEFAULT NULL COMMENT '组织code',
  `submission_time` datetime(0) NOT NULL COMMENT '报送时间',
  `submission_branch` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '送达部门',
  `submission_branch_id` bigint(30) NOT NULL COMMENT '送达部门ID',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '更新人',
  `rec_user_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人ID',
  `rec_date` datetime(0) NOT NULL COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否已被删除(0：未删除，1：已删除)',
  `process_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '流程ID',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '故障报修单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_failure_details
-- ----------------------------

-- ----------------------------
-- Table structure for cb_failure_maintain
-- ----------------------------
DROP TABLE IF EXISTS `cb_failure_maintain`;
CREATE TABLE `cb_failure_maintain`  (
  `sequence_nbr` bigint(20) NOT NULL COMMENT '主键',
  `maintain_man` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '维修人',
  `maintain_time` datetime(0) NULL DEFAULT NULL COMMENT '维修时间',
  `maintain_phone` bigint(11) NULL DEFAULT NULL COMMENT '维修人手机号',
  `biz_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '所属部门ID',
  `department` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '所属部门',
  `maintain_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '维修内容',
  `recore_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '记录类型',
  `acceptance_opinion` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '验收意见',
  `fault_id` bigint(20) NULL DEFAULT NULL COMMENT '设备故障报修主表ID',
  `rec_user_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '更新人',
  `rec_user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人ID',
  `rec_date` datetime(0) NOT NULL COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否已被删除(0：未删除，1：已删除)',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  INDEX `fault_id`(`fault_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '故障报修维修记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_failure_maintain
-- ----------------------------

-- ----------------------------
-- Table structure for cb_failure_repairlog
-- ----------------------------
DROP TABLE IF EXISTS `cb_failure_repairlog`;
CREATE TABLE `cb_failure_repairlog`  (
  `sequence_nbr` bigint(64) NOT NULL,
  `process_auditor_id` int(30) NULL DEFAULT NULL COMMENT '流程处理人ID',
  `process_auditor_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '流程处理人',
  `process_department_id` bigint(32) NULL DEFAULT NULL COMMENT '部门id',
  `process_department` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '处理人所属部门',
  `process_result` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '流程处理结果',
  `process_time` datetime(0) NOT NULL COMMENT '流程处理时间',
  `fault_id` bigint(20) NULL DEFAULT NULL COMMENT '设备故障报修主表ID',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '更新人',
  `rec_user_id` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人ID',
  `rec_date` datetime(0) NOT NULL COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否已被删除(0：未删除，1：已删除)',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '流程日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_failure_repairlog
-- ----------------------------

-- ----------------------------
-- Table structure for cb_failure_verify
-- ----------------------------
DROP TABLE IF EXISTS `cb_failure_verify`;
CREATE TABLE `cb_failure_verify`  (
  `sequence_nbr` bigint(20) NOT NULL AUTO_INCREMENT,
  `acceptor` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '验收人',
  `verify_department` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '验收部门',
  `verify_department_id` bigint(20) NULL DEFAULT NULL COMMENT '验收部门的id',
  `verify_result` int(255) NULL DEFAULT NULL COMMENT '审核结果 0：同意 1：拒绝 ',
  `verify_time` datetime(0) NOT NULL COMMENT '验收时间',
  `verify_opinion` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NULL DEFAULT NULL COMMENT '验收意见',
  `fault_id` bigint(20) NULL DEFAULT NULL COMMENT '设备故障报修单id',
  `rec_user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人ID',
  `rec_date` datetime(0) NOT NULL COMMENT '更新时间',
  `is_delete` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否已被删除(0：未删除，1：已删除)',
  `rec_user_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '更新人',
  PRIMARY KEY (`sequence_nbr`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1428178176061902850 CHARACTER SET = utf8 COLLATE = utf8_bin COMMENT = '故障报修验收记录' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_failure_verify
-- ----------------------------

-- ----------------------------
-- Table structure for cb_fire_chemical
-- ----------------------------
DROP TABLE IF EXISTS `cb_fire_chemical`;
CREATE TABLE `cb_fire_chemical`  (
  `sequence_nbr` bigint(20) NOT NULL,
  `cas_no` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'casNo',
  `danger_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '国际危险号',
  `defend_way` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '防护处理',
  `dispose` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '处理措施',
  `english_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '英文名',
  `formula` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分子式',
  `ingredient` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主要成分',
  `leak_way` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '泄漏处理',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '中文名',
  `property` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '性状',
  `store` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '贮藏方法',
  `symptom` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '症状',
  `tabu` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '禁忌物/禁忌',
  `type_code` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型code',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型名称',
  `un` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '国标号',
  `image` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '化学品图片',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `rec_user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人名称',
  `rec_user_id` varchar(19) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员',
  `rec_date` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `is_delete` bit(1) NULL DEFAULT b'0' COMMENT '是否删除',
  PRIMARY KEY (`sequence_nbr`) USING BTREE,
  INDEX `FKr7mkhg90ko8po3u2b86ivgjpq`(`type_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '危化品' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cb_fire_chemical
-- ----------------------------
INSERT INTO `cb_fire_chemical` VALUES (1, '109-78-4', '112', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '3-hydroxypropionitrile；ethylene Cyanohydrin', 'C3H5NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '3-羟基丙腈；氰化乙醇', '外观与性状：无色至淡黄色液体。\r\n熔点(℃)：-46\r\n相对密度(水=1)：1.04\r\n沸点(℃)：228(分解)\r\n相对密度(空气=1)：2.45\r\n饱和蒸气压(kPa)：2.67(117℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于丙酮、乙醇、氯仿、乙醚、不溶于苯、四氯化碳。\r\n主要用途：用于制造丙烯酸酯的中间体及用作纤维素酯和无机盐的溶剂。\r\n主要成分：纯品\r\nCAS号：109-78-4\r\n相对分子质量：71.08\r\n化学类别：109-78-4\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氰化氢。\r\n急性毒性：LD50：10000mg/kg(大鼠经口)；1800mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激作用，反复接触可引起肾损害。\r\n危险特性：遇明火能燃烧。受高热或与酸接触会产生剧毒的氰化物气体。与氯磺酸、发烟硫酸、硫酸、氢氧化钠能发生强烈反应。\r\n', '氧化剂、潮湿空气、酸类、碱类。', '743', '腈', '223', 'upload/jcs/studio_normalapp_3157169/475112802C42485D5E1B557551C3044.jpg', NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (2, '1313-27-5', NULL, '监测方法：硫氰酸盐分光光度法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可能残留\0', 'molybdenum trioxide', 'MoO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '三氧化钼', '外观与性状：白色晶状粉末。\r\n熔点(℃)：795\r\n相对密度(水=1)：4.69\r\n沸点(℃)：1150(升华)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于浓硝酸、浓盐酸、易溶于浓碱。\r\n主要用途：用于制各种钼盐、钼金属, 为酚及醇等的还原剂。\r\n主要成分：(以干基计算)≥95.5％；倍半氧化物≤0.03％；镍≤ 0.005％；磷≤ 0.002％； 硫≤ 0.002％；砷≤ 0.005％。\r\nCAS号：1313-27-5\r\n相对分子质量：143.94\r\n化学类别：1313-27-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：125mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激作用。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '750', '金属氧化物', NULL, 'http://yeejoin.3322.org:3194/file/getFile?in=chemical\\20191023\\金属氧化物.png', NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (3, '1314-06-3', NULL, '监测方法：火焰原子吸收光谱法；α－糠偶酰二肟比色法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：尽可能减少直接接触。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'nickelic oxide；nickel peroxide', 'Ni2O3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '三氧化二镍；氧化高镍', '外观与性状：黑色、有光泽的粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：4.83\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于硫酸、硝酸、盐酸、氨水。\r\n主要用途：用作陶瓷、玻璃、搪瓷的颜料, 并用于制镍粉。\r\n主要成分：(以镍计)≥60％；盐酸不溶物≤ 0.2％；氯化物≤0.01％；硫酸盐≤0.06％；硝酸盐≤0.05％；铜≤0.01％；钴≤0.2％；碱金属及碱土金属＜0.3％。\r\nCAS号：1314-06-3\r\n相对分子质量：165.40\r\n化学类别：1314-06-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，有毒，具致敏性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入后对呼吸道有刺激性。可引起哮喘和肺嗜酸细胞增多症，可致支气管炎。对眼有刺激性。皮肤接触可引起皮炎和湿疹，常伴有剧烈瘙痒，称之为“镍痒症”。镍有致癌性。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '750', '金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (4, '56-81-5', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'glycerol；glycerin', 'C3H8O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '丙三醇；甘油', '外观与性状：无色粘稠液体, 无气味, 有暖甜味, 能吸潮。\r\n熔点(℃)：20\r\n相对密度(水=1)：1.26(20℃)\r\n沸点(℃)：182(2.7KPa)\r\n相对密度(空气=1)：3.1\r\n饱和蒸气压(kPa)：0.4(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于醇、与水混溶、不溶于氯仿、醚、油类。\r\n主要用途：用于气相色谱固定液及有机合成, 也可用作溶剂、气量计及水压机减震剂、软化剂、抗生素发酵用营养剂、干燥剂等。\r\n主要成分：纯品\r\nCAS号：56-81-5\r\n相对分子质量：92.09\r\n化学类别：56-81-5\r\n燃烧性：可燃\r\n闪点：160\r\n引燃温度：370\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：12600mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。 对眼睛、皮肤有刺激作用。接触时间长能引起头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (5, '592-41-6', '31009', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '1-hexene；butylethene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '1-己烯；丁基乙烯', '外观与性状：无色易挥发液体。\r\n熔点(℃)：-139.9\r\n相对密度(水=1)：0.67\r\n沸点(℃)：64.5\r\n相对密度(空气=1)：3.0\r\n饱和蒸气压(kPa)：41.32(38℃)\r\n燃烧热(kJ/mol)：3981.9\r\n临界温度(℃)：243.5\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用于制造香料、染料及合成树脂。\r\n主要成分：纯品\r\nCAS号：592-41-6\r\n相对分子质量：84.16\r\n化学类别：592-41-6\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：253\r\n爆炸下限：1.2\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过10℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有刺激和麻醉作用。吸入后引起头痛、咳嗽、呼吸困难；大量吸入出现中枢神经系统抑制、精神错乱、神志丧失。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类。', '780', '烯烃', '2370', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (6, '9003-27-4', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、接\0', 'polybutylene；polybutene', '[C4H8]n', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '聚异丁烯；增粘剂T603', '外观与性状：白色或灰白色、无臭、无味固体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.91-0.93\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于乙醇、丙酮、等\r\n主要用途：可制成管道、薄膜、板材、各种容器和抽成单丝。\r\n主要成分：\r\nCAS号：9003-27-4\r\n相对分子质量：\r\n化学类别：9003-27-4\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤和粘膜有轻度刺激作用。吸入高浓度蒸气可以发生窒息和中毒。吸入和误服中毒可表现头痛、恶心、呕吐、腹泻、嗜睡。长期接触可引起皮肤干燥和皲裂。\r\n危险特性：粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。加热分解产生易燃气体。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (7, '7440-31-5', NULL, '监测方法：火焰原子吸收光谱法；催化极谱法\r\n工程控制：一般不需要特殊防护，但需防止烟尘危害。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：\r\n', '操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接触。搬运时轻装轻卸，防止包装破损。配备\0', 'tin', 'Sn', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收', '锡', '外观与性状：银白色金属。\r\n熔点(℃)：232\r\n相对密度(水=1)：7.29\r\n沸点(℃)：2260\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于制白铁板、巴毕脱合金、锡箔、活字金、合金、化学药品等。\r\n主要成分：纯品\r\nCAS号：7440-31-5\r\n相对分子质量：118.69\r\n化学类别：7440-31-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：630(粉云)\r\n爆炸下限：190(g/m3)\r\n爆炸上限：\r\n最小点火能：80\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):117\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化锡。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激作用。长期吸入锡的烟雾或粉尘可引起锡尘肺（或锡末沉着症）。\r\n危险特性：其粉体遇高温、明火能燃烧。\r\n', '强氧化剂、强酸。', '763', '非活泼金属', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (8, '590-28-3', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的\0', 'potassium cyanate', 'KOCN', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '氰酸钾', '外观与性状：白色晶体。\r\n熔点(℃)：\r\n相对密度(水=1)：2.06\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于乙醇。\r\n主要用途：用于有机合成和制催眠药、麻醉药，也用作除草剂。\r\n主要成分：纯品\r\nCAS号：590-28-3\r\n相对分子质量：81.12\r\n化学类别：590-28-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氰化氢、氧化钾。\r\n急性毒性：LD50：1000mg/kg(大鼠经口)；320mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：给狗腹腔注射400mg/kg，出现呕吐、流泪、流涎、呼吸加快、震颤、抽搐等，甚至死亡。受高热或与酸接触产生剧毒氰化物气体。\r\n危险特性：受高热或与酸接触会产生剧毒的氰化物气体。\r\n', '酸类。', '738', '金属氰化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (9, '13463-67-7', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，戴一般作业防护手套。避免产生粉尘。避免与酸类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'titanium(IV)oxide；titanium dioxide', 'TiO2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '二氧化钛；钛白粉', '外观与性状：白色粉末。\r\n熔点(℃)：1560\r\n相对密度(水=1)：3.9\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于稀碱、稀酸、溶于热浓硫酸、盐酸、硝酸。\r\n主要用途：是一种重要的白色颜料和瓷器釉料。\r\n主要成分：含量:≥98％ 。\r\nCAS号：13463-67-7\r\n相对分子质量：79.9\r\n化学类别：13463-67-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃。\r\n侵入途径：吸入、食入。\r\n健康危害：长期吸入氧化钛粉尘的工人，肺部无任何变化，亦未发生接触性皮炎、过敏反应。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '750', '金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (10, '7440-50-8', NULL, '监测方法：火焰原子吸收光谱法；催化极谱法；5－Br－PADAP比色法\r\n工程控制：一般不需特殊防护。\r\n呼吸系统防护：一般不需要特殊防护，但可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：一般不需要特殊防护，但建议特殊情况下，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：\r\n', '操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、卤素、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消防器材及\0', 'copper powder', 'Cu', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收', '铜粉', '外观与性状：带有红色光泽的金属。\r\n熔点(℃)：1083\r\n相对密度(水=1)：8.92\r\n沸点(℃)：2595\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于硝酸、热浓硫酸、微溶于盐酸。\r\n主要用途：供制造化学用具、电力用具、建筑材料和其他工业装置及用具。\r\n主要成分：纯品\r\nCAS号：7440-50-8\r\n相对分子质量：63.55\r\n化学类别：7440-50-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：700(粉云)\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化铜。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、卤素、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，粉尘具刺激性，对环境有严重危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：大量吸入铜烟雾可引起金属烟热。患者有寒战、体温升高，伴有呼吸道刺激症状。长期接触铜尘的工人常发生接触性皮炎和鼻、眼的刺激症状，引起咽痛、咳嗽、鼻塞、鼻炎等，甚至引起鼻中隔穿孔。长期吸入尚可引起肺部纤维组织增生。\r\n危险特性：其粉体遇高温、明火能燃烧。\r\n', '强酸、强氧化剂、卤素。', '763', '非活泼金属', NULL, 'http://yeejoin.3322.org:3194/file/getFile?in=chemical\\20191023\\铜粉.png', NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (11, '7782-92-5', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。尤其要注意避免与水接触。搬\0', 'sodium amide；sodamide', 'NaNH2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '氨基化钠', '外观与性状：白色结晶粉末，有氨的气味，易潮解。\r\n熔点(℃)：210\r\n相对密度(水=1)：1.40\r\n沸点(℃)：400\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于煤油。\r\n主要用途：用于制造氰化钠，有机合成中用作缩合促进剂，也作脱水剂、烷基化剂等。\r\n主要成分：纯品\r\nCAS号：7782-92-5\r\n相对分子质量：39.01\r\n化学类别：7782-92-5\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氨、氧化钠。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过10℃，相对湿度不超过75％。保持容器密封。应与氧化剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具强烈刺激性和腐蚀性。吸入其粉尘，对呼吸道有强烈刺激性，或造成灼伤。眼及皮肤接触可致灼伤。如口服，腐蚀口腔及消化道。\r\n危险特性：受高热、接触明火或与氧化剂混合，可发生爆炸。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。\r\n', '强氧化剂、水、空气、强酸、卤素、醇类。', '747', '金属氨基化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (12, '7758-87-4', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，避免产生粉尘。避免与酸类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'calcium phosphate,tribasic；tricalcium phosphate', 'Ca3(PO4)2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '磷酸钙；磷酸三钙', '外观与性状：白色、无臭、无味的晶体或无定形粉末。\r\n熔点(℃)：1670\r\n相对密度(水=1)：3.18\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于乙醇、乙酸、溶于酸。\r\n主要用途：用于制陶瓷、乳色玻璃、磷酸一钙、磨光粉、医药品、橡胶、媒染剂等。\r\n主要成分：纯品\r\nCAS号：7758-87-4\r\n相对分子质量：310.18\r\n化学类别：7758-87-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃。\r\n侵入途径：吸入、食入。\r\n健康危害：在生产加工、使用过程中，磷酸钙粉末可进入呼吸道，其职业危害取决于所含有杂质二氧化硅和氟。据有关资料报道，磷酸盐只有在剂量很大的情况下，才可能引起全身毒性作用，在一般生产条件下的剂量没有危险。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (13, NULL, NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），穿防毒物渗透工作服，戴安全防护眼镜，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'diphenyl and diphenyl ether；Dowtherm A', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '联苯-联苯醚；导生A; 二尼尔', '外观与性状：无色液体, 有特殊的刺激性气味。\r\n熔点(℃)：12.3\r\n相对密度(水=1)：\r\n沸点(℃)：258\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于乙醚、乙醇、等\r\n主要用途：用于低压高温的热载体。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：123.9\r\n引燃温度：\r\n爆炸下限：0.6(121℃)\r\n爆炸上限：6.2(160℃)\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、成分未知的黑色烟雾。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒常无潜伏期，一般在数分钟到半小时内发病。主要症状有眼和上呼吸道刺激、头痛、头晕、恶心、呕吐、嗜睡等，甚至有短暂的意识丧失。对皮肤有轻度刺激性，有致敏性。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (14, '1313-99-1', NULL, '监测方法：火焰原子吸收光谱法；α－糠偶酰二肟比色法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：尽可能减少直接接触。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'nickel oxide；nickelous oxide', 'NiO', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '氧化镍；一氧化镍', '外观与性状：绿色粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：6.6-6.8\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于碱液、溶于酸、等\r\n主要用途：用作陶瓷和玻璃的颜料。\r\n主要成分：纯品\r\nCAS号：1313-99-1\r\n相对分子质量：74.70\r\n化学类别：1313-99-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，有毒，具致敏性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤的影响在生产中较为常见，主要表现为皮炎或过敏性湿疹。皮疹有强烈的瘙痒，称镍痒症。镍工可患过敏性肺炎、支气管炎、支气管肺炎、肾上腺皮质功能不全等。镍有致癌性。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸、过氧化氢。', '750', '金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (15, '540-54-5', '31019', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1-chloropropane；n-propyl chloride', 'C3H7Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '1-氯丙烷；丙基氯', '外观与性状：无色液体，有氯仿的气味。\r\n熔点(℃)：-122.8\r\n相对密度(水=1)：0.89\r\n沸点(℃)：47.2\r\n相对密度(空气=1)：2.71\r\n饱和蒸气压(kPa)：40.00(25.5℃)\r\n燃烧热(kJ/mol)：1999.3\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作有机合成中间体及溶剂。\r\n主要成分：纯品\r\nCAS号：540-54-5\r\n相对分子质量：78.54\r\n化学类别：540-54-5\r\n燃烧性：易燃\r\n闪点：<-20\r\n引燃温度：520\r\n爆炸下限：2.6\r\n爆炸上限：11.1\r\n最小点火能：1.08\r\n最大爆炸压力：1.110\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度下抑制中枢神经系统。长期过量接触对肝、肾有损害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热分解产生有毒的氯化物气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱。', '759', '卤代烷', '1278', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (16, NULL, NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬\0', 'zinc dialkyl dithiophosphate', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '二烷基二硫代磷酸锌；T202', '外观与性状：\r\n熔点(℃)：<-10\r\n相对密度(水=1)：1.05-1.15\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：润滑油添加剂，防腐蚀、耐磨损、抗氧化。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化物、氧化磷。\r\n急性毒性：LD50：6800mg/kg(小鼠皮下)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒症状与有机磷农药中毒相似，但少见。慢性毒作用主要表现为程度不同的神经衰弱综合征。\r\n危险特性：受热分解，放出磷、硫的氧化物等毒性气体。\r\n', '强氧化剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (17, NULL, NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。禁止震动、撞\0', 'nitrogen pentoxide', 'N2O5', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '五氧化二氮', '外观与性状：无色柱状结晶，极易潮解。\r\n熔点(℃)：30\r\n相对密度(水=1)：1.64\r\n沸点(℃)：47(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：53.32/2.4℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于热水。\r\n主要用途：用作炸药。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：108.01\r\n化学类别：\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、接触潮气可分解。\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过10℃，相对湿度不超过75％。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：氮氧化物中毒时，有眼和呼吸道刺激症状及头痛、头晕、无力、心悸、恶心等。中度和重度时，出现呼吸困难、紫绀、胸部紧迫感、泡沫痰，可因肺水肿而引起死亡。慢性作用：主要表现为神经衰弱综合征及慢性呼吸道炎症。\r\n危险特性：具有强氧化性。受热分解放出有毒的氧化氮烟气。受高热、撞击或与易燃物、有机物接触，有发生爆炸的危险。\r\n', '强还原剂、水、易燃或可燃物、活性金属粉末。', '748', '非金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (18, '123-39-7', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'N-methylformamide', 'C2H5NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', 'N-甲基甲酰胺；甲基替甲酰胺', '外观与性状：无色液体，有氨味。\r\n熔点(℃)：-3.8\r\n相对密度(水=1)：1.01\r\n沸点(℃)：180~185\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：123-39-7\r\n相对分子质量：59.07\r\n化学类别：123-39-7\r\n燃烧性：易燃\r\n闪点：22\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：4000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。其蒸气或雾对眼睛、皮肤、粘膜和呼吸道有刺激作用。\r\n危险特性：遇明火、高热易燃。与氧化剂能发生强烈反应。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、酸类、碱类。', '767', '酰胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (19, '39108-12-8', 'T11003', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、卤素、接触。\0', 'magnesium azide', 'Mg(N3)2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。收入塑料桶内。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '迭氮镁', '外观与性状：黄绿色结晶固体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.84\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作起爆药。\r\n主要成分：\r\nCAS号：39108-12-8\r\n相对分子质量：108.35\r\n化学类别：39108-12-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：氮氧化物、氧化镁。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，不燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：热解时，放出有毒的NOx 烟雾，对眼睛、上呼吸道有刺激作用，甚至发生肺水肿。\r\n危险特性：受热、接触明火、或受到摩擦、震动、撞击时可发生爆炸。\r\n', '强氧化剂、卤素。', '788', '无机迭氮化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (20, '63918-97-8', '11022', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。禁止震\0', 'lead trinitroresorcinate；Lead styphnate', 'C6HN3O8Pb.H2O', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '三硝基间苯二酚铅；收敛酸铅', '外观与性状：桔黄色至暗褐色结晶，日光下可分解。\r\n熔点(℃)：\r\n相对密度(水=1)：2.9-3.1\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于醚、氯仿、苯、甲苯、微溶于丙酮、乙醇。\r\n主要用途：与叠氮化铅混合作为起爆药, 用于雷管装药。\r\n主要成分：\r\nCAS号：63918-97-8\r\n相对分子质量：468.30\r\n化学类别：63918-97-8\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氧化铅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存过程中应保持不少于20％的水作稳定剂。储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦\0', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，易燃，有毒，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有毒。分解时，放出有毒的氮氧化物及铅烟雾。\r\n危险特性：干燥时，即使数量很少，如接触火焰、火花或受到震动、撞击、摩擦亦会引起分解爆炸。\r\n', '强氧化剂。', '787', '硝基芳香化合物', '0130', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (21, '121-82-4', '11041', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与酸类、碱类、接触。搬\0', 'cyclotrimethylene trinitramine；Hexogen', 'C3H6N6O6', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '环三次甲基三硝铵；黑索金', '外观与性状：白色晶状固体。\r\n熔点(℃)：204\r\n相对密度(水=1)：1.82\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：2142.4\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于苯、芳烃、乙醚、溶于丙酮。\r\n主要用途：用于填装炮弹、导爆索、雷管等。\r\n主要成分：\r\nCAS号：121-82-4\r\n相对分子质量：222.15\r\n化学类别：121-82-4\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：100mg/kg(大鼠经口)；59mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。保持容器密封。应与酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，可燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入中毒可发生癫痫样发作；误服可引起头晕、恶心、呕吐、流涎、多汗，重者发生抽搐。\r\n危险特性：受摩擦、撞击易发生爆炸。其爆速、猛度、威力比梯恩梯、特屈儿都大。\r\n', '强酸、强碱。', '794', '金属烃基化合物', '0072', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (22, '79-38-9', '21034', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免\0', 'chlorotrifluoroethylene', 'C2ClF3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。如有可能，将漏出气用排风\0', '三氟氯乙烯', '外观与性状：无色，微有乙醚气味的气体。\r\n熔点(℃)：-157.5\r\n相对密度(水=1)：1.30\r\n沸点(℃)：-26.2\r\n相对密度(空气=1)：4.13\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：107\r\n临界压力(MPa)：4.05\r\n辛醇/水分配系数：\r\n溶解性：溶于醚。\r\n主要用途：用于制造树脂。\r\n主要成分：纯品\r\nCAS号：79-38-9\r\n相对分子质量：116.47\r\n化学类别：79-38-9\r\n燃烧性：易燃\r\n闪点：-27.8\r\n引燃温度：\r\n爆炸下限：8.4\r\n爆炸上限：38.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、氯化氢。\r\n急性毒性：LD50：268mg/kg(小鼠经口)\r\nLC50：1000ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入。\r\n健康危害：接触高浓度三氟氯乙烯，出现头昏、眩晕、恶心、乏力、睡眠障碍等，一般都能恢复。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热能引起燃烧爆炸。在生产和贮存过程中, 易发生自聚反应, 应加阻聚剂。在火场高温下，能发生聚合放热，使容器破裂。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、活性金属粉末。', '765', '卤代烯', '1082', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (23, '13463-39-3', '61031', '监测方法：火焰原子吸收光谱法；α－糠偶酰二肟比色法\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸\0', 'nickel carbonyl；nickel tetracarbonyl', 'C4O4Ni', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖\0', '羰基镍；四羰基镍', '外观与性状：无色挥发性液体，有煤烟气味。\r\n熔点(℃)：-25\r\n相对密度(水=1)：1.32\r\n沸点(℃)：43\r\n相对密度(空气=1)：5.9\r\n饱和蒸气压(kPa)：53.32/25.8℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：200(约)\r\n临界压力(MPa)：3.04\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、等多数有机溶剂。\r\n主要用途：用于制高纯镍粉，也用于电子工业，及制造塑料中间体，也用作催化剂。\r\n主要成分：纯品\r\nCAS号：13463-39-3\r\n相对分子质量：170.73\r\n化学类别：13463-39-3\r\n燃烧性：易燃\r\n闪点：<4\r\n引燃温度：\r\n爆炸下限：2.0\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳。\r\n急性毒性：LD50：39mg/kg(大鼠腑腔内)；63mg/kg(大鼠经皮)\r\nLC50：35ppm，7小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：动物阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”\0', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，为致癌物，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道有刺激作用，并有全身毒作用，可导致肺、肝、脑损害。如肺水肿抢救不及时，可引起死亡。急性中毒：早期表现有头痛、头晕、步态不稳、视力模糊、眼刺激、恶心、心悸、胸闷、气短等。迟发的症状主要有明显的胸闷、气短、严重呼吸困难、紫绀、咳嗽、大量粉红色泡沫痰，?\n危险特性：易燃，本品在空气中氧化，加热至60℃时发生爆炸。受热、接触酸或酸雾会放出剧毒的烟雾。\r\n', '强氧化剂、酸类。', '800', '未指定的化学类别', '1259', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (24, '562-49-2', '32007', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '3,3-dimethylpentane', 'C7H16', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。或在\0', '3,3-二甲基戊烷；二乙基二甲基甲烷', '外观与性状：无色液体。\r\n熔点(℃)：-135\r\n相对密度(水=1)：0.69(20℃)\r\n沸点(℃)：86～87\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：4794.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作气相色谱对比样品以及用于有机合成。\r\n主要成分：含量 99％。\r\nCAS号：562-49-2\r\n相对分子质量：100.21\r\n化学类别：562-49-2\r\n燃烧性：易燃\r\n闪点：-6\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品属烃类，吸入高浓度烃类化合物蒸气可引起轻度呼吸道刺激、头晕、欣快感、精神错乱、恶心和呼吸困难；极高浓度吸入可致昏迷甚至死亡。液体进入肺部，可引起吸入性肺炎或肺水肿。高浓度蒸气对眼有轻度刺激性；液体可引起眼部暂时性红肿和疼痛。液体对皮肤有轻度刺激性；反?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂接触发生化学反应或引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、卤素。', '771', '烷烃', '1206', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (25, '25109-57-3', '61084', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', '3,4-dibromobutanone；1,2-dibromo-3-butanone', 'C4H6Br2O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '3,4-二溴丁酮；1,2-二溴-3-丁酮', '外观与性状：液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.97(15℃)\r\n沸点(℃)：80(0.13kPa)\r\n相对密度(空气=1)：8.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：25109-57-3\r\n相对分子质量：229.91\r\n化学类别：25109-57-3\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强烈催泪性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有毒，具强烈催泪性。人在本品 18.8mg/m3环境下，几秒钟内失去工作能力；１－２秒可致显著呼吸道疾患。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的溴化物气体。\r\n', '强氧化剂。', '775', '酮', '2648', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (26, '616-45-5', '61085', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩；可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止烟雾或粉尘泄漏到工作场所空气中。避免\0', '2-pyrrolidone；butyrolactam', 'C4H7NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。若是液体，防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容\0', '2-吡咯酮；4-丁内酰胺', '外观与性状：无色到淡黄色液体或结晶。\r\n熔点(℃)：25\r\n相对密度(水=1)：1.11\r\n沸点(℃)：245\r\n相对密度(空气=1)：2.9\r\n饱和蒸气压(kPa)：1.33/122℃\r\n燃烧热(kJ/mol)：2286.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、氯仿、乙酸乙酯、等多数有机溶剂。\r\n主要用途：用作增塑剂、聚合剂、杀虫剂等的溶剂。\r\n主要成分：纯品\r\nCAS号：616-45-5\r\n相对分子质量：85.11\r\n化学类别：616-45-5\r\n燃烧性：可燃\r\n闪点：129\r\n引燃温度：145\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：328mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：摄入、吸入或经皮吸收对身体有害。其蒸气和气溶胶对眼睛、粘膜、呼吸道、皮肤有刺激作用。\r\n危险特性：可燃。遇明火能燃烧。与氧化剂可发生反应。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、强碱、强酸、强还原剂。', '775', '酮', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (27, '83-32-9', '41515', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时轻装轻卸，防止包\0', 'acenaphthene；1,2-dihydroacena-phthylene', 'C12H10', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。使用无火花工具收集回收或运至废物处理场所处置。', '苊；萘己环', '外观与性状：白色针状结晶。\r\n熔点(℃)：95\r\n相对密度(水=1)：1.02(20℃)\r\n沸点(℃)：277.5\r\n相对密度(空气=1)：5.32\r\n饱和蒸气压(kPa)：1.33(131.2℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于热苯、醚、醇。\r\n主要用途：用作染料中间体, 也可用作杀虫剂、杀菌剂等。\r\n主要成分：纯品\r\nCAS号：83-32-9\r\n相对分子质量：154.21\r\n化学类别：83-32-9\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过32℃，相对湿度不超过80％。包装密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第4.1类  易燃固体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激性。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解产生有毒的烟气。\r\n', '强氧化剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (28, '79-92-5', '41537', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：一般不需特殊防护。必要时，戴安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时要轻\0', 'camphene', 'C10H16', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集运至废物处理场所处置。大量泄漏：用塑料布、帆布覆盖。使用无火花工具收集回收或运至废物处理场所处置。', '莰烯；2,2-二甲基-3-亚甲基降菠烷', '外观与性状：无色或微黄结晶，具有樟脑的气味。\r\n熔点(℃)：50～51\r\n相对密度(水=1)：0.84\r\n沸点(℃)：159\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：5.32(75.7℃)\r\n燃烧热(kJ/mol)：6139.6\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于乙醇、溶于乙醚。\r\n主要用途：用于医药，及合成樟脑、香料等原料。\r\n主要成分：纯品\r\nCAS号：79-92-5\r\n相对分子质量：136.23\r\n化学类别：79-92-5\r\n燃烧性：易燃\r\n闪点：34\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过32℃，相对湿度不超过80％。包装密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第4.1类  易燃固体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼、鼻、咽喉有刺激性。高浓度接触引起头痛、恶心、兴奋、出汗。极高浓度接触出现精神错乱、昏睡，甚至昏迷。高浓度对肾脏有损害。对皮肤有刺激性。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。燃烧时产生大量烟雾。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (29, '91-20-3', '41511', '监测方法：气相色谱法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：高浓度蒸气接触可应该佩戴过滤式防毒面具（半面罩）；可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接\0', 'naphthalene', 'C10H8', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，使用无火花工具收集于干燥、洁净、有盖的容器中。运至空旷处引爆。或在保证安全情况下，就地焚烧。大量泄漏：用塑料布、帆布覆盖。使用无火\0', '萘；并苯', '外观与性状：白色易挥发晶体，有温和芳香气味，粗萘有煤焦油臭味。\r\n熔点(℃)：80.1\r\n相对密度(水=1)：1.16\r\n沸点(℃)：217.9\r\n相对密度(空气=1)：4.42\r\n饱和蒸气压(kPa)：0.13(52.6℃)\r\n燃烧热(kJ/mol)：5148.9\r\r\n临界温度(℃)：457.2\r\n临界压力(MPa)：4.05\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于无水乙醇、醚、苯。\r\n主要用途：用于制造染料中间体、樟脑丸、皮革、木材保护剂等。\r\n主要成分：纯品\r\nCAS号：91-20-3\r\n相对分子质量：128.16\r\n化学类别：91-20-3\r\n燃烧性：易燃\r\n闪点：78.9\r\n引燃温度：526\r\n爆炸下限：28～38mg/m3\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：大鼠皮下最低中毒剂量(TDL0)：3500mg/kg/12周(间歇)，疑致肿瘤剂，致淋巴瘤，包括何杰金氏病，致子宫肿瘤。小鼠吸入最低中毒浓度(TCL0)：30ppm/6小时/2年(间歇)，致肿瘤，致肺肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过32℃，相对湿度不超过80％。包装密封。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第4.1类  易燃固体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体和土壤可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：具有刺激作用，高浓度致溶血性贫血及肝、肾损害。急性中毒：吸入高浓度萘蒸气或粉尘时，出现眼及呼吸道刺激、角膜混浊、头痛、恶心、呕吐、食欲减退、腰痛、尿频，尿中出现蛋白及红、白细胞。亦可发生视神经炎和视网膜炎。重者可发生中毒性脑病和肝损害。口服中毒主要引起溶?\n危险特性：遇明火、高热易燃。燃烧时放出有毒的刺激性烟雾。与强氧化剂如铬酸酐、氯酸盐和高锰酸钾等接触，能发生强烈反应，引起燃烧或爆炸。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂。', '800', '未指定的化学类别', '1334', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (30, '7440-46-2', '43007', '监测方法：\r\n工程控制：密闭操作。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿化学防护服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员穿化学防护服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、卤素、接触。尤其要注意避免与水接触。在氩气中操作处置。搬运时要轻装轻卸，防止包装及容器\0', 'cesium', 'Cs', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿化学防护服。不要直接接触泄漏物。小量泄漏：收入金属容器并保存在煤油或液体石蜡中。大量泄漏：与有关技术部门联系，确定清除方法。', '铯；金属铯', '外观与性状：银白色柔软金属或银白色液体。\r\n熔点(℃)：28.5\r\n相对密度(水=1)：1.87\r\n沸点(℃)：679\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(279℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于酸、乙醇。\r\n主要用途：用作光电池、电子管的吸气剂、氢化催化剂等。\r\n主要成分：纯品\r\nCAS号：7440-46-2\r\n相对分子质量：132.91\r\n化学类别：7440-46-2\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：\r\n急性毒性：LD50：1700mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '浸于煤油中。储存于阴凉、通风的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。包装要求密封，不可与空气接触。应与氧化剂、卤素、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的\0', '危险性类别：第4.3类  遇湿易燃物品\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：尚未见铯中毒的病例报告。工人长期接触未见对健康有影响。动物急性中毒表现以神经、肌肉的兴奋为特征。\r\n危险特性：化学反应活性很高，在潮湿空气中能自燃。与空气中的氧气反应则生成超氧化物，如混有有机物等，发生爆炸性反应。与水和酸强烈反应, 发热冒烟, 甚至发生燃烧爆炸。与卤素及其它氧化剂剧烈反应。\r\n', '强氧化剂、空气、水、氧、卤素、磷。', '799', '活泼金属', '1407', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (31, '7681-55-2', '51517', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要轻装轻卸，防止包装\0', 'sodium iodate', 'NaIO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：避免扬尘，小心扫起，收集转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所\0', '碘酸钠', '外观与性状：白色棱形结晶或晶状粉末。\r\n熔点(℃)：分解\r\n相对密度(水=1)：4.28\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、丙酮、不溶于乙醇。\r\n主要用途：用作分析试剂、药物、消毒剂、饲料添加剂。\r\n主要成分：纯品\r\nCAS号：7681-55-2\r\n相对分子质量：197.92\r\n化学类别：7681-55-2\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：碘化氢。\r\n急性毒性：LD50：119mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装密封。应与还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、上呼吸道、粘膜和皮肤有刺激性。\r\n危险特性：无机氧化剂。能与铝、砷、铜、碳、金属硫化物、有机物、磷、硒、硫剧烈反应。具有腐蚀性。\r\n', '强还原剂、活性金属粉末、硫、磷、铝。', '764', '卤素含氧酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (32, NULL, '61676', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空\0', '4-nitroethylbenzene；p-nitroethylbenzene', 'C8H9NO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成\0', '4-硝基乙苯；对硝基乙苯', '外观与性状：无色油状液体。\r\n熔点(℃)：-32\r\n相对密度(水=1)：1.12\r\n沸点(℃)：245～246\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：3.06(135℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：151.17\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：112\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入或经皮肤吸收本品可引起中毒。能引起高铁血红蛋白血症，贫血。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的腐蚀性烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强碱、强酸。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (33, '609-73-4', '61691', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还\0', '2-nitroiodobenzene；2-iodonitrobenzene', 'C6H4INO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '2-硝基碘苯；2-碘硝基苯', '外观与性状：黄色针状结晶。\r\n熔点(℃)：54\r\n相对密度(水=1)：1.92\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：97.18(288℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：609-73-4\r\n相对分子质量：249.01\r\n化学类别：609-73-4\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。对眼睛和皮肤有刺激作用。可引起高铁血红蛋白血症而出现紫绀。易经皮肤吸收中毒。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强碱。', '784', '卤代芳烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (34, '3034-19-3', '61815', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。必要时，建议佩戴空气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、酸类、接\0', '2-nitrophenylhydrazine；o-nitrophenylhydrazine', 'C6H7N3O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '2-硝基苯肼；邻硝基苯肼', '外观与性状：桔红色粉末。\r\n熔点(℃)：90～92\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：3034-19-3\r\n相对分子质量：153.14\r\n化学类别：3034-19-3\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：178mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、上呼吸道和皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。与氧化剂混合能形成爆炸性混合物。经摩擦、震动或撞击可引起燃烧或爆炸。\r\n', '强氧化剂、强酸、强还原剂。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (35, NULL, '61815', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。必要时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、酸类\0', '3-nitrophenylhydrazine；m-nitrophenylhydrazine', 'C6H7N3O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '3-硝基苯肼；间硝基苯肼', '外观与性状：黄色结晶。\r\n熔点(℃)：210(分解)\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：153.14\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、粘膜、上呼吸道和皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。与氧化剂混合能形成爆炸性混合物。经摩擦、震动或撞击可引起燃烧或爆炸。\r\n', '强氧化剂、强酸、强还原剂。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (36, '577-19-5', '61688', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还\0', '2-nitrobromobenzene；o-nitrobromobenzene', 'C6H4BrNO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '2-硝基溴苯；邻硝基溴苯', '外观与性状：黄色结晶。\r\n熔点(℃)：43\r\n相对密度(水=1)：1.62\r\n沸点(℃)：261\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：100.77(258℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、丙酮、苯、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：577-19-5\r\n相对分子质量：202.01\r\n化学类别：577-19-5\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。对眼睛和皮肤有刺激作用。经皮肤吸收迅速，吸收后引起高铁血红蛋白血症，出现紫绀。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强碱。', '784', '卤代芳烃', '2732', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (37, '578-54-1', '61754', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空\0', '2-ethylaniline；o-ethylaniline', 'C8H11N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '2-乙基苯胺；邻乙基苯胺', '外观与性状：黄色或橘红色液体。\r\n熔点(℃)：-63.5\r\n相对密度(水=1)：0.98\r\n沸点(℃)：215\r\n相对密度(空气=1)：4.17\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：4687.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、甲苯、等\r\n主要用途：用作药品、染料、杀虫剂的中间体。\r\n主要成分：纯品\r\nCAS号：578-54-1\r\n相对分子质量：121.18\r\n化学类别：578-54-1\r\n燃烧性：易燃\r\n闪点：91\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1260mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。储存期不可太长，规定三个月轮换一次。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛有强烈的刺激作用。对粘膜、上呼吸道有刺激性。吸收进入体内可引起高铁血红蛋白血症，出现紫绀。\r\n危险特性：遇明火、高热易燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '酸类、酸酐、酰基氯、氯仿、强氧化剂。', '785', '芳香胺', '2273', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (38, '95-56-7', '61710', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', '2-bromophenol；o-bromophenol', 'C6H5BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的\0', '2-溴苯酚；邻溴苯酚', '外观与性状：黄色到红色油状液体，具有不愉快的气味。\r\n熔点(℃)：5.6\r\n相对密度(水=1)：1.49\r\n沸点(℃)：195\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.73(87.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：95-56-7\r\n相对分子质量：173.01\r\n化学类别：95-56-7\r\n燃烧性：易燃\r\n闪点：42\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：652mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜、上呼吸道有刺激性。长期接触可引起眼睛的强烈刺激或灼伤。\r\n危险特性：遇明火、高热易燃。受高热分解产生有毒的溴化物气体。与强氧化剂接触可发生化学反应。\r\n', '酰基氯、酸酐、强氧化剂。', '742', '酚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (39, '598-72-1', '61618', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）；可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、还原剂、碱类、接触。搬运时要轻装轻卸，\0', '2-bromopropionic acid', 'C3H5BrO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。若是液体，尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入\0', '2-溴丙酸；α-溴丙酸', '外观与性状：无色液体或固体。\r\n熔点(℃)：24.5\r\n相对密度(水=1)：1.70\r\n沸点(℃)：203(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.33(96℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、乙醚、等\r\n主要用途：用作化学试剂，及用于有机合成。\r\n主要成分：纯品\r\nCAS号：598-72-1\r\n相对分子质量：152.98\r\n化学类别：598-72-1\r\n燃烧性：可燃\r\n闪点：100\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：250mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：小鼠经皮最低中毒剂量(TDL0)：4800mg/kg(12周，间断)，致癌阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。能引起皮肤灼伤。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的溴化物气体。\r\n', '碱、强还原剂、强氧化剂。', '742', '酚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (40, '95-46-5', '61669', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：高浓度环境中，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-bromotoluene；o-bromotoluene', 'C7H7Br', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '2-溴甲苯；邻溴甲苯', '外观与性状：无色液体。\r\n熔点(℃)：-26\r\n相对密度(水=1)：1.42\r\n沸点(℃)：181.7\r\n相对密度(空气=1)：5.9\r\n饱和蒸气压(kPa)：1.33(59.1℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯、可混溶于四氯化碳。\r\n主要用途：用于有机合成及用作溶剂。\r\n主要成分：纯品\r\nCAS号：95-46-5\r\n相对分子质量：171.04\r\n化学类别：95-46-5\r\n燃烧性：可燃\r\n闪点：78\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：1864mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤有刺激性。\r\n危险特性：可燃。遇明火能燃烧。受高热分解产生有毒的溴化物气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂。', '784', '卤代芳烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (41, '540-51-2', '61587', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还\0', '2-bromoethanol；2-bromoethyl alcohol', 'C2H5BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。尽可能切断泄漏源。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。\0', '2-溴乙醇', '外观与性状：无色或浅黄色液体，其水溶液具有甜的焦灼味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.76\r\n沸点(℃)：149\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.67(57℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成及用作溶剂。\r\n主要成分：纯品\r\nCAS号：540-51-2\r\n相对分子质量：124.97\r\n化学类别：540-51-2\r\n燃烧性：易燃\r\n闪点：40\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼睛和皮肤有强烈刺激性。吸入后可由于喉和支气关的痉挛、炎症和水肿，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火易燃。受高热燃烧并分解产生有毒气体。\r\n', '强酸、强还原剂、强氧化剂、酸酐、酰基氯。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (42, '119-93-7', '61805', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸\0', '3,3\'-dimethylbenzidine；o-tolidine', 'C14H16N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '3,3\'-二甲基联苯胺；邻联甲苯胺', '外观与性状：白色至微红色有闪光的片状结晶。\r\n熔点(℃)：131～132\r\n相对密度(水=1)：\r\n沸点(℃)：415\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：用作染料、乌来糖树脂的交联剂、鉴定金及水中游离氯的试剂。\r\n主要成分：纯品\r\nCAS号：119-93-7\r\n相对分子质量：212.30\r\n化学类别：119-93-7\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：404mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对呼吸道和眼有刺激性。对皮肤无刺激性；易经皮肤吸收。慢性影响：无长期职业性接触致慢性影响的报道。动物喂饲本品可导致肾损害甚至肾功能衰竭。\r\n危险特性：可燃。遇明火、高热可燃。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (43, '95-76-1', '61768', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、\0', '3,4-dichloroaniline', 'C6H5Cl2N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '3,4-二氯苯胺', '外观与性状：褐色针状结晶。\r\n熔点(℃)：72\r\n相对密度(水=1)：\r\n沸点(℃)：272\r\n相对密度(空气=1)：5.59\r\n饱和蒸气压(kPa)：0.13(80.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于多数有机溶剂。\r\n主要用途：用于染料中间体、农药中间体及生物组分中间体。\r\n主要成分：纯品\r\nCAS号：95-76-1\r\n相对分子质量：162.02\r\n化学类别：95-76-1\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：265\r\n爆炸下限：2.8(153℃)\r\n爆炸上限：7.2(179℃)\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：648mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品为强高铁血红蛋白形成剂；对中枢神经系统、肝、肾有损害。引起头痛，头晕，恶心，呕吐、指端、口唇、耳廓紫绀，呼吸困难等。\r\n危险特性：遇明火、高热可燃。受高热分解，产生有毒的氮氧化物和氯化物气体。与强氧化剂接触可发生化学反应。\r\n', '酸类、酰基氯、酸酐、强氧化剂。', '785', '芳香胺', '1059', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (44, '95-75-0', '61660', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空\0', '3,4-dichlorotoluene', 'C7H6Cl2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '3,4-二氯甲苯', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：-15.3\r\n相对密度(水=1)：1.26\r\n沸点(℃)：208.9\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、丙酮、苯、四氯化碳。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：95-75-0\r\n相对分子质量：161.03\r\n化学类别：95-75-0\r\n燃烧性：可燃\r\n闪点：85\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜和皮肤有刺激性。持续高浓度吸入其蒸气可出现呼吸道炎症，甚至发生肺水肿。对眼有刺激性。皮肤接触可引起红斑、大疱，或发生湿疹。\r\n危险特性：遇明火能燃烧。受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂、强碱。', '784', '卤代芳烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (45, '542-76-7', '61105', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴导管式防毒面具。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿连衣式胶布防毒衣，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', '3-chloropropionitrile；β-chloropropionitrile', 'C3H4ClN', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成\0', '3-氯丙腈；β-氯丙腈', '外观与性状：无色有特殊臭味的液体。\r\n熔点(℃)：-51\r\n相对密度(水=1)：1.14\r\n沸点(℃)：176(分解)\r\n相对密度(空气=1)：3.09\r\n饱和蒸气压(kPa)：0.80(50℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于乙醇、丙酮、乙醚、苯、四氯化碳。\r\n主要用途：用作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：542-76-7\r\n相对分子质量：89.53\r\n化学类别：542-76-7\r\n燃烧性：可燃\r\n闪点：75.6\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、氰化氢、氯化氢、氧化氮。\r\n急性毒性：LD50：100mg/kg(大鼠经口)；9mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收可能致死。对眼、呼吸道和粘膜有刺激性。动物中毒时出现深度麻醉作用。\r\n危险特性：遇明火、高热可燃。受高热分解，产生有毒的氮氧化物和氯化物气体。\r\n', '强酸、强碱、强氧化剂、强还原剂。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (46, '121-73-3', '61678', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂\0', '3-nitrochlorobenzene；m-chloronitrobenzene', 'C6H4ClNO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '3-硝基氯苯；间氯硝基苯', '外观与性状：淡黄色结晶。\r\n熔点(℃)：46\r\n相对密度(水=1)：1.53\r\n沸点(℃)：236\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用作有机合成中间体\r\n主要成分：纯品\r\nCAS号：121-73-3\r\n相对分子质量：157.56\r\n化学类别：121-73-3\r\n燃烧性：可燃\r\n闪点：103\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：420mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有刺激作用，引起高铁血红蛋白血症、溶血性贫血及中枢神经系统抑制。主要中毒表现有眼及上呼吸道刺激症状，头痛，头昏，呼吸困难，紫绀，贫血，血尿，血红蛋白和管型尿，恶心，呕吐，腹部疼痛，嗜睡，兴奋和幻觉，以及肌肉无力和共济失调。\r\n危险特性：遇明火能燃烧。受高热分解，产生有毒的氮氧化物和氯化物气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强碱、强还原剂。', '787', '硝基芳香化合物', '1578', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (47, '92-67-1', '61802', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、\0', '4-aminobiphenyl；p-aminophenylbenzene', 'C12H11N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '4-氨基联苯；对氨基联苯', '外观与性状：棕褐色粉末。\r\n熔点(℃)：52～54\r\n相对密度(水=1)：\r\n沸点(℃)：191(2.0kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.0(191℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：92-67-1\r\n相对分子质量：169.23\r\n化学类别：92-67-1\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌物质。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为致癌物，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有刺激性。吸收后可引起高铁血红蛋白血症，出现紫绀。吸入、口服或经皮肤吸收可致死。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、酸类、酰基氯、酸酐。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (48, '504-24-5', '61842', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运\0', '4-aminopyridine；γ-pyridylamine', 'C5H6N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '4-氨基吡啶；γ-吡啶胺', '外观与性状：无色针状结晶。\r\n熔点(℃)：158～159\r\n相对密度(水=1)：\r\n沸点(℃)：273\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.73(180℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醚、苯、易溶于乙醇。\r\n主要用途：用于有机合成及制药工业。\r\n主要成分：纯品\r\nCAS号：504-24-5\r\n相对分子质量：94.12\r\n化学类别：504-24-5\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：20mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为致癌物，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：如吸入、口服或经皮吸收可中毒死亡。对眼睛、上呼吸道、粘膜和皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、酸类。', '800', '未指定的化学类别', '2671', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (49, '371-40-4', '61762', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空\0', '4-fluoroaniline；p-fluoroaniline', 'C6H6FN', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', '4-氟苯胺；对氟苯胺', '外观与性状：淡黄色的油状液体，有刺激性气味。\r\n熔点(℃)：-0.8\r\n相对密度(水=1)：1.17\r\n沸点(℃)：180.5～182.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、等\r\n主要用途：用作染料中间体。\r\n主要成分：纯品\r\nCAS号：371-40-4\r\n相对分子质量：111.12\r\n化学类别：371-40-4\r\n燃烧性：可燃\r\n闪点：73\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氟化氢。\r\n急性毒性：LD50：417mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收可能引起死亡。蒸气或雾对眼、粘膜、上呼吸道和皮肤有刺激性。吸入进入体内可引起高铁血红蛋白血症。高浓度接触引起紫绀。\r\n危险特性：遇明火、高热可燃。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '酸类、酰基氯、酸酐、氯仿、强氧化剂。', '785', '芳香胺', '2941', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (50, '79-11-8', '81603', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气或烟雾时，必须佩戴导管式防毒面具。必要时，建议佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作场所禁止吸烟、进食和饮水，饭前要洗手。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、碱类、接触。搬运时要轻装轻\0', 'chloroacetic acid；monochloroacetic acid', 'C2H3ClO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收\0', '氯乙酸；一氯醋酸', '外观与性状：无色结晶，有潮解性。\r\n熔点(℃)：63\r\n相对密度(水=1)：1.58\r\n沸点(℃)：189\r\n相对密度(空气=1)：3.26\r\n饱和蒸气压(kPa)：0.67(71.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、氯仿、二硫化碳。\r\n主要用途：用于制农药和作有机合成中间体。\r\n主要成分：含量: 一级≥96.5; 二级≥95.0％。\r\nCAS号：79-11-8\r\n相对分子质量：94.49\r\n化学类别：79-11-8\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：>500\r\n爆炸下限：8.0\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：76mg/kg(大鼠经口)；255mg/kg(小鼠经口)\r\nLC50：180mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入高浓度本品蒸气或皮肤接触其溶液后，可迅速大量吸收，造成急性中毒。吸入初期为上呼吸道刺激症状。中毒后数小时即可出现心、肺、肝、肾及中枢神经损害，重者呈现严重酸中毒。患者可有抽搐、昏迷、休克、血尿和肾功能衰竭。酸雾可致眼部刺激症状和角膜灼伤。皮肤灼伤可出?\n危险特性：遇明火、高热可燃。受高热分解产生有毒的腐蚀性烟气。与强氧化剂接触可发生化学反应。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、强碱、强还原剂。', '795', '有机酸', '1750', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (51, '541-88-8', '81604', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。必要时，佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作场所禁止吸烟、进食和饮水，饭前要洗手。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、碱类\0', 'chloroacetic anhydride', 'C4H4Cl2O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '氯乙酸酐', '外观与性状：无色至微黄色结晶，有刺激气味。\r\n熔点(℃)：46\r\n相对密度(水=1)：\r\n沸点(℃)：217.0\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(67.2℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、氯仿。\r\n主要用途：用作中间体。\r\n主要成分：纯品\r\nCAS号：541-88-8\r\n相对分子质量：170.98\r\n化学类别：541-88-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、酸类、碱类、醇类、胺类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的腐蚀性烟气。与强氧化剂接触可发生化学反应。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、酸类、碱类、醇类、胺类。', '778', '酸酐', '1751', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (52, '79-40-9', '81118', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）或隔离式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作场所禁止吸烟、进食和饮水，饭前要洗手。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中。避免与氧化剂、醇类、接触。尤其要注\0', 'chloroacetyl chloride', 'C2H2Cl2O', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器内，回收或运至废物处理场所\0', '氯乙酰氯', '外观与性状：无色透明液体，有刺激性气味。\r\n熔点(℃)：-22.5\r\n相对密度(水=1)：1.50\r\n沸点(℃)：107\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：8.00(41.5℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于丙酮、可混溶于乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：79-40-9\r\n相对分子质量：112.95\r\n化学类别：79-40-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：120mg/kg(大鼠经口)\r\nLC50：4620mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、醇类、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入后可能由于喉、支气管的痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：不燃。能与很多物质发生剧烈反应导致燃烧爆炸。受热或遇水分解放热, 放出有毒的腐蚀性烟气。具有较强的腐蚀性。\r\n', '强氧化剂、水、醇类。', '739', '有机酰卤', '1752', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (53, '10034-85-2', '81019', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其烟雾时，佩戴自吸过滤式防毒面具（全面罩）或空气呼吸器。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、接触。搬运时要轻装轻卸，防止包装及\0', 'hydroiodic acid', 'HI', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖\0', '氢碘酸', '外观与性状：无色至浅黄色有刺激性臭味的液体，在空气中强烈发烟。\r\n熔点(℃)：-50.8(纯品)\r\n相对密度(水=1)：1.70(57%)\r\n沸点(℃)：126.7(57%)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作还原剂，也用于合成碘烷及其他碘化物。\r\n主要成分：含量 57.0％。\r\nCAS号：10034-85-2\r\n相对分子质量：127.91\r\n化学类别：10034-85-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、碱类、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：有强腐蚀作用。其蒸气或烟雾对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。\r\n危险特性：暴露在空气中可发生氧化反应。与氟、钾、硝酸、氯酸钾等剧烈反应。对大多数金属有强腐蚀性。\r\n', '碱类、强氧化剂、氨、活性金属粉末、空气。', '766', '无机酸', '1787', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (54, '7664-39-3', '81016', '监测方法：离子选择性电极法；氟试剂－镧盐比色法\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其烟雾时，佩戴自吸过滤式防毒面具（全面罩）或空气呼吸器。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与碱类、活性金属粉末、玻璃制品、接触。搬运时要轻装\0', 'hydrofluoric acid', 'HF', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖\0', '氢氟酸', '外观与性状：无色透明有刺激性臭味的液体。商品为40%的水溶液。\r\n熔点(℃)：-83.1(纯)\r\n相对密度(水=1)：1.26(75%)\r\n沸点(℃)：120(35.3%)\r\n相对密度(空气=1)：1.27\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶。\r\n主要用途：用作分析试剂、高纯氟化物的制备、玻璃蚀刻及电镀表面处理等。\r\n主要成分：含量: 高浓度 55.0％; 低浓度 40％。\r\nCAS号：7664-39-3\r\n相对分子质量：20.01\r\n化学类别：7664-39-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：1044mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过85％。保持容器密封。应与碱类、活性金属粉末、玻璃制品、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤有强烈的腐蚀作用。灼伤初期皮肤潮红、干燥。创面苍白，坏死，继而呈紫黑色或灰黑色。深部灼伤或处理不当时，可形成难以愈合的深溃疡，损及骨膜和骨质。本品灼伤疼痛剧烈。眼接触高浓度本品可引起角膜穿孔。接触其蒸气，可发生支气管炎、肺炎等。慢性影响：眼和上呼吸?\n危险特性：本品不燃，但能与大多数金属反应，生成氢气而引起爆炸。遇Ｈ发泡剂立即燃烧。腐蚀性极强。\r\n', '强碱、活性金属粉末、玻璃制品。', '766', '无机酸', '1790', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (55, '10035-10-6', '81017', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其烟雾时，佩戴自吸过滤式防毒面具（全面罩）或空气呼吸器。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离易燃、可燃物。防止蒸气泄漏到工作场所空气中。避免与碱类、活性金属粉末、接触。搬运\0', 'hydrobromic acid', 'HBr', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖\0', '氢溴酸', '外观与性状：无色液体，具有刺激性酸味。\r\n熔点(℃)：-66.5(纯品)\r\n相对密度(水=1)：1.49(47%)\r\n沸点(℃)：126(47%)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于醇、乙酸。\r\n主要用途：用于制造无机溴化物和有机溴化物，用作分析试剂、触媒及还原剂。\r\n主要成分：纯品\r\nCAS号：10035-10-6\r\n相对分子质量：80.92\r\n化学类别：10035-10-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢。\r\n急性毒性：LD50：76mg/kg(大鼠静脉)\r\nLC50：9460mg/m3，1小时(大鼠吸入)；2694mg/m3，1小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过85％。保持容器密封。应与易燃物或可燃物、碱类、活性金属粉末、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：可引起皮肤、粘膜的刺激或灼伤。长期低浓度接触可引起呼吸道刺激症状和消化功能障碍。\r\n危险特性：对大多数金属有强腐蚀性。能与普通金属发生反应, 放出氢气而与空气形成爆炸性混合物。遇Ｈ发泡剂立即燃烧。遇氰化物能产生剧毒的氰化氢气体。\r\n', '碱类、氨、活性金属粉末、易燃或可燃物。', '766', '无机酸', '1788', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (56, '64013-16-7', '81527', '监测方法：火焰原子吸收光谱法\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与碱类、氰化物、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒\0', 'antimony triiodide；antimony iodide', 'SbI3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '三碘化锑；碘化锑', '外观与性状：红色结晶, 高温时挥发, 在水中分解生成碘化锑沉淀。\r\n熔点(℃)：170\r\n相对密度(水=1)：4.77(22℃)\r\n沸点(℃)：401\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(163.6℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醇、盐酸、不溶于氯仿。\r\n主要用途：用于制药工业。\r\n主要成分：纯品\r\nCAS号：64013-16-7\r\n相对分子质量：502.16\r\n化学类别：64013-16-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：氧化锑、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装密封。应与碱类、氰化物、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有腐蚀性和毒性。对眼睛、粘膜、皮肤和上呼吸道有强烈刺激作用。\r\n危险特性：本身不燃烧，但遇高热能放出有毒的烟气。遇氰化物能产生剧毒的氰化氢气体。遇Ｈ发泡剂立即燃烧。遇钾、钠剧烈反应。具有腐蚀性。\r\n', '强碱、潮湿空气、氰化物。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (57, '407-25-0', '81102', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴导管式防毒面具或自吸式长管面具。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、碱类、醇类、接触。搬运时要轻装轻卸，防止包装及容\0', 'trifluoroacetic anhydride', 'C4F6O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或\0', '三氟乙酸酐；三氟醋酸酐', '外观与性状：无色液体, 有刺激性气味, 易挥发。\r\n熔点(℃)：-65\r\n相对密度(水=1)：1.49(25℃)\r\n沸点(℃)：39.5～40.1\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作分析试剂、溶剂、催化剂、脱水缩合剂、羟基和氨基三氟乙酰化时的保护剂。\r\n主要成分：纯品\r\nCAS号：407-25-0\r\n相对分子质量：210.03\r\n化学类别：407-25-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、酸类、碱类、醇类、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤，具催泪性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤和粘膜具有强烈刺激作用，并能引起灼伤。\r\n危险特性：遇低级醇和水起化学反应而分解。对很多金属尤其是潮湿空气存在下有腐蚀性。\r\n', '强氧化剂、强酸、强碱、水、醇类。', '778', '酸酐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (58, '865-44-1', '81521', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴头罩型电动送风过滤式防尘呼吸器。；可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。空气中浓度较高时，必须佩戴自给式呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防酸碱塑料工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿防酸碱塑料工作服，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与还原剂、碱类、氰化物、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防\0', 'iodine trichloride', 'ICl3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '三氯化碘', '外观与性状：黄色或棕色晶体, 有刺激性气味, 具强吸湿性, 遇水易分解, 在室温下能挥发。\r\n熔点(℃)：33\r\n相对密度(水=1)：3.20(-4℃)\r\n沸点(℃)：77(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醇、醚、苯、四氯化碳。\r\n主要用途：用作氯化剂及氧化剂, 测定碘值及用于医药。\r\n主要成分：纯品\r\nCAS号：865-44-1\r\n相对分子质量：233.26\r\n化学类别：865-44-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化物、氯气、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、碱类、氰化物、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有刺激作用。对皮肤有强腐蚀性。加热分解成一氯化碘和极毒的氯气。\r\n危险特性：受高热分解，放出腐蚀性、刺激性的烟雾。吸潮或遇水会产生大量的腐蚀性烟雾。具有强腐蚀性。\r\n', '易燃或可燃物、潮湿空气、碱类、氰化物、强还原剂。', '741', '卤素与卤间化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (59, '7719-12-2', '81041', '监测方法：钼酸铵比色法\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）或隔离式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），戴化学安全防护眼镜，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、碱类、接触。尤\0', 'phosphorus trichloride', 'PCl3', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。在专家指导下清除。', '三氯化磷', '外观与性状：无色澄清液体，在潮湿空气中发烟。\r\n熔点(℃)：-111.8\r\n相对密度(水=1)：1.57\r\n沸点(℃)：74.2\r\n相对密度(空气=1)：4.75\r\n饱和蒸气压(kPa)：13.33(21℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于二硫化碳、醚、四氯化碳、苯。\r\n主要用途：用于制造有机磷化合物，也用作试剂等。\r\n主要成分：含量: 工业级 一级≥99.0％; 二级≥96.0％; 试剂级 分析纯≥95.5％。\r\nCAS号：7719-12-2\r\n相对分子质量：137.34\r\n化学类别：7719-12-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化氢、氧化磷、磷烷。\r\n急性毒性：LD50：550mg/kg(大鼠经口)\r\nLC50：582.4mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。包装必须密封，切勿受潮。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。不宜久存，以免变质。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：三氯化磷在空气中可生成盐酸雾。对皮肤、粘膜有刺激腐蚀作用。短期内吸入大量蒸气可引起上呼吸道刺激症状，出现咽喉炎、支气管炎，严重者可发生喉头水肿致窒息、肺炎或肺水肿。皮肤及眼接触，可引起刺激症状或灼伤。严重眼灼伤可致失明。慢性影响：长期低浓度接触可引起眼及?\n危险特性：遇水猛烈分解, 产生大量的热和浓烟, 甚至爆炸。对很多金属尤其是潮湿空气存在下有腐蚀性。\r\n', '强碱、强氧化剂、水、酸类、醇类、钾、钠、金属氧化物。', '776', '非金属卤化物', '1809', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (60, '112-24-3', '82026', '监测方法：\r\n工程控制：密闭操作，注意通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴直接式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防腐工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴化学安全防护眼镜，穿防腐工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'triethylenetetramine', 'C6H18N4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，\0', '三乙四胺；三亚乙基四胺', '外观与性状：无色或微黄色粘稠液体。\r\n熔点(℃)：12\r\n相对密度(水=1)：0.98\r\n沸点(℃)：278\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、微溶于乙醚、溶于乙醇。\r\n主要用途：用作络合试剂、碱性气体的脱水剂、染料中间体、环氧树脂的溶剂等。\r\n主要成分：总氮量≥94.0％。\r\nCAS号：112-24-3\r\n相对分子质量：146.24\r\n化学类别：112-24-3\r\n燃烧性：可燃\r\n闪点：143\r\n引燃温度：337\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：4340mg/kg(大鼠经口)；805mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.2类  碱性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、刺激性，可致人体灼伤，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气或雾对鼻、喉和呼吸道有刺激作用。高浓度吸入可引起头痛、恶心、呕吐和昏迷。极高浓度或长时间吸入可引起意识丧失，甚至死亡。蒸气、液体或雾对眼有强烈腐蚀作用，重者可致失明。皮肤接触可发生灼伤；对皮肤有强致敏作用；可经皮肤吸收引起中毒。口服液体灼伤消?\n危险特性：遇明火、高热可燃。燃烧时，放出有毒气体。能腐蚀铜及其合金。\r\n', '酸类、酰基氯、酸酐、强氧化剂、氯仿。', '762', '脂肪胺', '2259', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (61, '7789-60-8', '81056', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）或自给式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、碱类、接触。尤其要注意避免与水接触\0', 'phosphorus tribromide', 'PBr3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：将地面洒上苏打灰，然后用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。在专家\0', '三溴化磷', '外观与性状：无色或淡黄色发烟液体，有刺激性臭味。\r\n熔点(℃)：-40\r\n相对密度(水=1)：2.85\r\n沸点(℃)：175.3\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.33(47.8℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于丙酮、氯仿、四氯化碳、二硫化碳。\r\n主要用途：用作测定糖和氧的试剂，用于有机合成。\r\n主要成分：纯品\r\nCAS号：7789-60-8\r\n相对分子质量：270.72\r\n化学类别：7789-60-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：溴化氢、氧化磷、磷烷。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。包装必须密封，切勿受潮。应与氧化剂、酸类、碱类、等分开存放，切忌混储。不宜久存，以免变质。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入后可能由于喉、支气管的痉挛、水肿、炎症，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇水发热、冒烟甚至燃烧爆炸。具有腐蚀性。\r\n', '强碱、水、醇类、强氧化剂、酸类、碱类、钾、钠。', '776', '非金属卤化物', '1808', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (62, '7727-15-3', '81058', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴一级或二级自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴一级或二级自吸过滤式防尘口罩，戴化学安全防护眼镜，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免与氧化剂、碱类、醇类、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防止包装及容器损\0', 'aluminium tribromide', 'AlBr3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。不要直接接触泄漏物。小量泄漏：将地面洒上苏打灰，然后用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：在专家指导下清除。', '三溴化铝(无水)', '外观与性状：白色或淡黄色片状或块状固体，易潮解。\r\n熔点(℃)：97.5\r\n相对密度(水=1)：3.20\r\n沸点(℃)：264\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(81℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇、乙醚、二硫化碳。\r\n主要用途：用作分析试剂、有机合成异构化的催化剂。\r\n主要成分：纯品\r\nCAS号：7727-15-3\r\n相对分子质量：266.69\r\n化学类别：7727-15-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：溴化氢、氧化铝。\r\n急性毒性：LD50：1598mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、碱类、醇类、等分开存放，切忌混储。不宜久存，以免变质。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、粘膜、呼吸道和皮肤有刺激作用，吸入可能由于喉、支气管的炎症、痉挛、水肿，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、气短、喉炎、头痛、恶心和呕吐。\r\n危险特性：受高热分解产生有毒的溴化物气体。与水强烈反应产生高热, 可发生爆炸。与金属钾和钠能形成对撞击敏感的物质。具有腐蚀性。\r\n', '强氧化剂、水、醇类、碱类。', '797', '金属卤化物', '1725', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (63, '10294-33-4', '81059', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴导管式防毒面具或氧气呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与碱类、醇类、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防\0', 'boron tribromide；boron bromide', 'BBr3', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以将地面洒上苏打灰，然后用大量水冲洗，洗水稀释后放入废水\0', '三溴化硼；溴化硼', '外观与性状：无色或稍带黄色的发烟液体，有强烈的刺激性臭味。\r\n熔点(℃)：-45\r\n相对密度(水=1)：2.65\r\n沸点(℃)：91.7\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：5.33(14℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于四氯化碳。\r\n主要用途：用于有机硼合成和高纯硼的制取。\r\n主要成分：含量≥99.999％。\r\nCAS号：10294-33-4\r\n相对分子质量：250.54\r\n化学类别：10294-33-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气、光照。\r\n燃烧(分解)产物：溴化氢、氧化硼。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与碱类、醇类、等分开存放，切忌混储。不宜久存，以免变质。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入后可能由于喉、支气管的痉挛、水肿、炎症，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：受热或遇水分解，放出有毒的腐蚀性气体，有时会发生爆炸。具有腐蚀性。\r\n', '碱类、水、醇类。', '776', '非金属卤化物', '2692', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (64, '7789-61-9', '81523', '监测方法：火焰原子吸收光谱法\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防酸碱塑料工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防酸碱塑料工作服，戴橡胶手套。避免产生粉尘。避免与氧化剂、碱类、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防止包装及容器损坏。\0', 'antimony tribromide；antimony bromide', 'SbBr3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '三溴化锑；溴化锑', '外观与性状：黄色结晶，有潮解性。\r\n熔点(℃)：96.6\r\n相对密度(水=1)：4.15\r\n沸点(℃)：280\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(93.9℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于盐酸。\r\n主要用途：用作试剂。\r\n主要成分：纯品\r\nCAS号：7789-61-9\r\n相对分子质量：361.48\r\n化学类别：7789-61-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、碱类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对呼吸道有刺激性，接触后可引起咳嗽、恶心和口中金属味。高浓度接触发生肺水肿、心律不齐，甚至心跳停止，造成死亡。皮肤或眼接触可致灼伤。慢性影响：反复接触引起头痛、食欲不振、咽干、失眠。可能发生肝肾损害。\r\n危险特性：受热或遇水分解放热, 放出有毒的腐蚀性烟气。具有腐蚀性。\r\n', '强氧化剂、碱类。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (65, '75-69-4', '22047', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。必要时，戴安全防护眼镜。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。远离易燃、可燃物。防止气体或蒸气泄漏到工作场所空气中。避免与氧化剂、铝、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'trichlorofluoromethane；Freon-11', 'CCl3F', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '三氯氟甲烷；氟里昂-11', '外观与性状：无色液体或气体，有醚味。\r\n熔点(℃)：-111\r\n相对密度(水=1)：1.48\r\n沸点(℃)：23.7\r\n相对密度(空气=1)：1.49\r\n饱和蒸气压(kPa)：202.65(44.1℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：198\r\n临界压力(MPa)：4.38\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于乙醇、醚。\r\n主要用途：用作致冷剂、气溶杀虫药发射剂。\r\n主要成分：纯品\r\nCAS号：75-69-4\r\n相对分子质量：137.37\r\n化学类别：75-69-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、易燃物或可燃物、铝、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体可造成污染，该物质对大气臭氧层破坏力极强。\r\n侵入途径：吸入。\r\n健康危害：高浓度可诱发心律不齐和抑制呼吸功能。对人的慢性影响未见报道。\r\n危险特性：不燃。受高热分解，放出有毒的氟化物和氯化物气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、易燃或可燃物、铝。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (66, '51-28-5', '11052', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿紧袖工作服，长筒胶鞋。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿紧袖工作服，长筒胶鞋，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、碱类、活性金属粉\0', '2,4-dinitrophenol', 'C6H4N2O5', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用水润湿，然后收集回收或运至废物\0', '2,4-二硝基苯酚', '外观与性状：淡黄色固体。\r\n熔点(℃)：112～114\r\n相对密度(水=1)：1.7\r\n沸点(℃)：\r\n相对密度(空气=1)：6.4\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：2708.6\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于冷水、乙醇、乙醚、丙酮、苯、氯仿。\r\n主要用途：用于有机合成、染料、炸药等。\r\n主要成分：\r\nCAS号：51-28-5\r\n相对分子质量：184.11\r\n化学类别：51-28-5\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：30mg/kg(大鼠经口)；700mg/kg(豚鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱类、活性金属粉末、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，易燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品直接作用于能量代射过程，可使细胞氧化过程增强，磷酰化过程抑制。急性中毒：表现为皮肤潮红、口渴、大汗、烦躁不安、全身无力、胸闷、心率和呼吸加快、体温升高(可达40℃以上)、抽搐、肌肉强直，以致昏迷。最后可因血压下降、肺及脑水肿而死亡。成人口服致死量约1克。慢\r\n危险特性：遇火种、高温、摩擦、震动或接触碱性物质、氧化剂均易引起爆炸。与重金属粉末能起化学反应生成金属盐, 增加敏感度。粉尘在流动和搅拌时，会有静电积累。\r\n', '强氧化剂、强碱、酰基氯、酸酐、活性金属粉末。', '787', '硝基芳香化合物', '0076', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (67, '99-35-4', '11054', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿紧袖工作服，长筒胶鞋。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿紧袖工作服，长筒胶鞋，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂\0', '1,3,5-trinitrobenzene(dry or wetted with less than', 'C6H3N3O6', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。避免震动、撞击和摩擦。小量泄漏：使用无火花工具收集运至废物处理场所处置。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用水润湿，然后收集回收或\0', '1,3,5-三硝基苯(干的或含水<30％)；对称三硝基苯', '外观与性状：白色或黄色斜方结晶。\r\n熔点(℃)：123\r\n相对密度(水=1)：1.76\r\n沸点(℃)：315(分解)\r\n相对密度(空气=1)： \r\n饱和蒸气压(kPa)：0.27(175℃)\r\n燃烧热(kJ/mol)：2774.3\r\n临界温度(℃)：516.5\r\n临界压力(MPa)： \r\n辛醇/水分配系数： \r\n溶解性：不溶于水、微溶于热乙醇、易溶于乙醚、丙酮、苯。\r\n主要用途：用于制造猛性炸药。\r\n主要成分：\r\nCAS号：99-35-4\r\n相对分子质量：213.11\r\n化学类别：99-35-4\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度： \r\n爆炸下限： \r\n爆炸上限： \r\n最小点火能： \r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：280mg/kg(大鼠经口)；  572mg/kg(小鼠经口)\r\nLC50： \r\n致癌性：\r\n', '储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。应与氧化剂、还原剂、活性金属粉末、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对动物，有形成高铁血红蛋白作用，可致肝脏及中枢神经系统损害，引起呼吸困难。\r\n危险特性：加热至120℃ 以上发生放热分解。遇火焰或火花迅速燃烧。受到撞击、摩擦、震动或在密封状态下受热会发生爆炸。与氧化剂接触猛烈反应。\r\n', '强氧化剂、强还原剂、活性金属粉末、强碱。', '787', '硝基芳香化合物', '0214', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (68, '75-50-3', '21045', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器或空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧\0', 'trimethylamine；TMA', 'C3H9N', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水\0', '三甲胺(无水)；无水三甲胺', '外观与性状：无色、有鱼油臭的气体。\r\n熔点(℃)：-117.1\r\n相对密度(水=1)：0.66(-5℃)\r\n沸点(℃)：3\r\n相对密度(空气=1)：2.09\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：2353.8\r\n临界温度(℃)：161\r\n临界压力(MPa)：4.15\r\n辛醇/水分配系数：0.27\r\n溶解性：溶于水、乙醇、乙醚、等\r\n主要用途：用作分析试剂和用于有机合成，也用作消毒剂等。\r\n主要成分：纯品\r\nCAS号：75-50-3\r\n相对分子质量：59.11\r\n化学类别：75-50-3\r\n燃烧性：易燃\r\n闪点：-6.7\r\n引燃温度：190\r\n爆炸下限：2.0\r\n爆炸上限：11.6\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对人体的主要危害是对眼、鼻、咽喉和呼吸道的刺激作用。浓三甲胺水溶液能引起皮肤剧烈的烧灼感和潮红，洗去溶液后皮肤上仍可残留点状出血。长期接触感到眼、鼻、咽喉干燥不适。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热易引起燃烧爆炸。受热分解产生有毒的烟气。与氧化剂接触猛烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、卤素。', '762', '脂肪胺', '1083', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (69, '75-46-7', '22032', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'trifluoromethane；fluoroform', 'CHF3', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '三氟甲烷；氟仿', '外观与性状：无色无臭气体。\r\n熔点(℃)：-155\r\n相对密度(水=1)：1.52(-80℃)\r\n沸点(℃)：-84\r\n相对密度(空气=1)：2.43\r\n饱和蒸气压(kPa)：2504(20℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：25.7\r\n临界压力(MPa)：4.84\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作低温致冷剂及作为灭火剂和制造四氟乙烯的原料。\r\n主要成分：纯品\r\nCAS号：75-46-7\r\n相对分子质量：70.01\r\n化学类别：75-46-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、易燃物或可燃物、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：接触后可引起头痛、恶心和呕吐，有麻醉作用。\r\n危险特性：不燃。受热分解释出剧毒的烟雾。\r\n', '强氧化剂、易燃或可燃物。', '759', '卤代烷', '1984', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (70, '7637-07-2', '23018', '监测方法：苯羟乙酸分光光度法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器或氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿带面罩式胶布防毒衣，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与醇类、碱类、接触。尤其要注意避免与水接触。搬运时轻装轻卸，防止钢瓶及\0', 'boron trifluoride；boron fluoride', 'BF3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器要妥善处理，修复、检验后再用。', '三氟化硼；氟化硼', '外观与性状：无色气体，有窒息性，在潮湿空气中可产生浓密白烟。\r\n熔点(℃)：-126.8\r\n相对密度(水=1)：\r\n沸点(℃)：-100\r\n相对密度(空气=1)：2.35\r\n饱和蒸气压(kPa)：1013.25(-58℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-12.26\r\n临界压力(MPa)：4.98\r\n辛醇/水分配系数：\r\n溶解性：溶于冷水。\r\n主要用途：用作有机合成中的催化剂，也用于制造火箭的高能燃料。\r\n主要成分：纯品\r\nCAS号：7637-07-2\r\n相对分子质量：67.82\r\n化学类别：7637-07-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢、氧化硼。\r\n急性毒性：LD50：\r\nLC50：1180mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与醇类、碱类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒。\r\n侵入途径：吸入。\r\n健康危害：急性中毒：主要症状有干咳、气急、胸闷、胸部紧迫感；部分患者出现恶心、食欲减退、流涎；吸入量多时，有震颤及抽搐，亦可引起肺炎。皮肤接触可致灼伤。\r\n危险特性：化学反应活性很高，遇水发生爆炸性分解。与铜及其合金有可能生成具有爆炸性的氯乙炔。暴露在空气中遇潮气时迅速水解成氟硼酸与硼酸，产生白色烟雾。腐蚀性很强，冷时也能腐蚀玻璃。\r\n', '水、胺类、醇类、碱类。', '776', '非金属卤化物', '1008', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (71, '7783-54-2', '23016', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。防止气体泄漏到工作场\0', 'nitrogen trifluoride；nitrogen fluoride', 'NF3', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '三氟化氮', '外观与性状：无色、带霉味的气体。\r\n熔点(℃)：-208.5\r\n相对密度(水=1)：1.89(沸点,液体)\r\n沸点(℃)：-129\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作高能燃料。\r\n主要成分：纯品\r\nCAS号：7783-54-2\r\n相对分子质量：70.01\r\n化学类别：7783-54-2\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：19000mg/m3，1小时(大鼠吸入)；5600mg/m3，4小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，有毒。\r\n侵入途径：吸入。\r\n健康危害：尚未见职业性中毒报道。\r\n危险特性：强氧化剂。受热或与火焰、电火化、有机物等接触能燃烧，甚至爆炸。与易燃物（如苯）和可燃物（如糖、纤维素等）接触会发生剧烈反应，甚至引起燃烧。与还原剂能发生强烈反应，引起燃烧爆炸。\r\n', '还原剂、易燃或可燃物。', '776', '非金属卤化物', '2451', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (72, '133-74-0', '21001', '监测方法：\r\n工程控制：密闭系统，通风，防爆电器与照明。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤素、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止\0', 'hydrogen', 'H2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏出气用排风机送至空旷地方或装设适当喷头烧掉。漏气容器要妥善处理，修复、检验后再用。', '氢；氢气', '外观与性状：无色无臭气体。\r\n熔点(℃)：-259.2\r\n相对密度(水=1)：0.07(-252℃)\r\n沸点(℃)：-252.8\r\n相对密度(空气=1)：0.07\r\n饱和蒸气压(kPa)：13.33(-257.9℃)\r\n燃烧热(kJ/mol)：241.0\r\n临界温度(℃)：-240\r\n临界压力(MPa)：1.30\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于乙醇、乙醚。\r\n主要用途：用于合成氨和甲醇等，石油精制，有机物氢化及作火箭燃料。\r\n主要成分：含量: 工业级≥98.0％；高纯≥99.999％。\r\nCAS号：133-74-0\r\n相对分子质量：2.01\r\n化学类别：133-74-0\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：400\r\n爆炸下限：4.1\r\n爆炸上限：74.1\r\n最小点火能：0.019\r\n最大爆炸压力：0.720\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：水。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入。\r\n健康危害：本品在生理学上是惰性气体，仅在高浓度时，由于空气中氧分压降低才引起窒息。在很高的分压下，氢气可呈现出麻醉作用。\r\n危险特性：与空气混合能形成爆炸性混合物，遇热或明火即爆炸。气体比空气轻，在室内使用和储存时，漏气上升滞留屋顶不易排出，遇火星会引起爆炸。氢气与氟、氯、溴等卤素会剧烈反应。\r\n', '强氧化剂、卤素。', '779', '非金属单质', '1049', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (73, '75-61-6', '61577', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱金属、接触。搬运时要轻装轻卸，防止包装及容\0', 'dibromodifluoromethane；difluorodibromomethane', 'CBr2F2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '二溴二氟甲烷；二氟二溴甲烷', '外观与性状：无色液体。\r\n熔点(℃)：-141\r\n相对密度(水=1)：2.31\r\n沸点(℃)：24.5\r\n相对密度(空气=1)：7.24\r\n饱和蒸气压(kPa)：83.07(21.1℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于甲醇、乙醚。\r\n主要用途：合成染料、药物、灭火剂、第四胺化合物。\r\n主要成分：纯品\r\nCAS号：75-61-6\r\n相对分子质量：209.83\r\n化学类别：75-61-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱金属、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入后引起肺刺激、胸痛，可因肺水肿而死亡。\r\n危险特性：不燃。受热分解产生有毒的烟气。与碱金属能发生剧烈反应。与活性金属粉末（如镁、铝等）能发生反应, 引起分解。\r\n', '强氧化剂、铝、碱金属、镁锌。', '759', '卤代烷', '1941', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (74, '594-71-8', '61578', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '2-chloro-2-nitropropane；2-nitro-2-chloropropane', 'C3H6ClNO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专\0', '2-硝基-2-氯丙烷；2-氯-2-硝基丙烷', '外观与性状：微黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.19(20℃)\r\n沸点(℃)：134\r\n相对密度(空气=1)：4.26\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作杀虫剂、碳氢化合物的溶剂。\r\n主要成分：纯品\r\nCAS号：594-71-8\r\n相对分子质量：123.54\r\n化学类别：594-71-8\r\n燃烧性：易燃\r\n闪点：57(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氯化氢。\r\n急性毒性：LD50：580mg/kg(小鼠经口)\r\nLC50：55000mg/m3，3小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤和呼吸道有刺激作用。\r\n危险特性：遇明火、高热、或与氧化剂接触能燃烧, 并散发出有毒气体。急剧加热时可发生爆炸。受高热分解放出有毒的气体。\r\n', '强氧化剂、酸类。', '746', '硝基烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (75, '600-25-9', '61578', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1-chloro-1-nitropropane；1-nitro-1-chloropropane', 'C3H6ClNO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专\0', '1-硝基-1-氯丙烷；1-氯-1-硝基丙烷', '外观与性状：淡黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.21(20℃)\r\n沸点(℃)：139.5\r\n相对密度(空气=1)：4.26\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作杀虫剂、碳氢化合物的溶剂。\r\n主要成分：纯品\r\nCAS号：600-25-9\r\n相对分子质量：123.54\r\n化学类别：600-25-9\r\n燃烧性：可燃\r\n闪点：62(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氯化氢。\r\n急性毒性：LD50：510mg/kg(小鼠经口)\r\nLC50：66000mg/m3，3小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤和呼吸道有刺激作用。\r\n危险特性：遇明火、高热能燃烧。急剧加热时可发生爆炸。与氧化剂可发生反应。接触酸或酸气能产生有毒气体。\r\n', '强氧化剂、酸类。', '746', '硝基烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (76, '594-72-9', '61579', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1,1-dichloro-1-nitroethane', 'C2H3Cl2NO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '1,1-二氯-1-硝基乙烷', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.42\r\n沸点(℃)：124\r\n相对密度(空气=1)：5.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作溶剂及消毒剂。\r\n主要成分：纯品\r\nCAS号：594-72-9\r\n相对分子质量：143.96\r\n化学类别：594-72-9\r\n燃烧性：可燃\r\n闪点：76(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：410mg/kg(大鼠经口)；240mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：动物实验表明，本品对肺有刺激性；出现心、肝、肾和血管损害。\r\n危险特性：遇明火、高热能燃烧。与氧化剂接触猛烈反应。受高热分解，产生有毒的氮氧化物和氯化物气体。\r\n', '强氧化剂、强还原剂。', '746', '硝基烷烃', '2650', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (77, '78-92-2', '33552', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、\0', '2-butyl alcohol；sec-butyl alcohol', 'C4H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统\0', '2-丁醇；仲丁醇', '外观与性状：无色透明液体，有类似葡萄酒的气味。\r\n熔点(℃)：-114.7\r\n相对密度(水=1)：0.81\r\n沸点(℃)：99.5\r\n相对密度(空气=1)：2.55\r\n饱和蒸气压(kPa)：1.33(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：245\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.61\r\n溶解性：溶于水。\r\n主要用途：用于制造甲乙酮，合成香精、染料等的原料，也用作溶剂。\r\n主要成分：纯品\r\nCAS号：78-92-2\r\n相对分子质量：74.12\r\n化学类别：78-92-2\r\n燃烧性：易燃\r\n闪点：24\r\n引燃温度：390\r\n爆炸下限：1.7\r\n爆炸上限：9.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6480mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有刺激和麻醉作用。大量吸入对眼、鼻、喉有刺激作用，并出现头痛、眩晕、倦怠、恶心等症状。对兔皮肤无刺激性，但对兔眼有严重损伤。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受热分解放出有毒气体。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '酸类、酰基氯、酸酐、强氧化剂、卤素。', '789', '醇', '1120', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (78, '90-02-8', '61599', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', 'salicylaldehyde；o-hydroxybenzaldehyde', 'C7H6O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '水杨醛；邻羟基苯甲醛', '外观与性状：无色澄清油状液体，有焦灼味及杏仁气味。\r\n熔点(℃)：-7\r\n相对密度(水=1)：1.17\r\n沸点(℃)：197\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(33℃)\r\n燃烧热(kJ/mol)：3328.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作分析试剂、香料、汽油添加剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：90-02-8\r\n相对分子质量：122.12\r\n化学类别：90-02-8\r\n燃烧性：可燃\r\n闪点：76\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：520mg/kg(大鼠经口)；3000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对呼吸道有刺激性，吸入后引起咳嗽、胸痛。对眼和皮肤有刺激性。\r\n危险特性：遇高热、明火及强氧化剂易引起燃烧并放出有毒气体。\r\n', '强氧化剂、强酸、强碱。', '773', '醛', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (79, '107-07-3', '61583', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', '2-chloroethanol', 'C2H5ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系\0', '2-氯乙醇', '外观与性状：无色液体，微具醚香味。\r\n熔点(℃)：-67.5\r\n相对密度(水=1)：1.20\r\n沸点(℃)：128.8\r\n相对密度(空气=1)：2.78\r\n饱和蒸气压(kPa)：1.33(30.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、酸、乙醚。\r\n主要用途：用于制造乙二醇、环氧乙烷，及医药、染料、农药的合成等。\r\n主要成分：纯品\r\nCAS号：107-07-3\r\n相对分子质量：80.52\r\n化学类别：107-07-3\r\n燃烧性：易燃\r\n闪点：60\r\n引燃温度：425\r\n爆炸下限：4.9\r\n爆炸上限：15.9\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、光气、氯化氢。\r\n急性毒性：LD50：71mg/kg(大鼠经口)；67mg/kg(兔经皮)\r\nLC50：290mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度蒸气对眼、上呼吸道有刺激性。高浓度吸入出现头痛、头晕、嗜睡、恶心、呕吐，继之乏力、呼吸困难、紫绀、共济失调、抽搐、昏迷。重者发生脑和肺水肿。可因循环和呼吸衰竭而死亡。皮肤接触，可出现皮肤红斑；可经皮吸收引起中毒。口服可致死。慢性影响有头痛、乏力、胃?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。高热时能分解出剧毒的光气。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危?\n', '碱、强氧化剂。', '789', '醇', '1135', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (80, '78-89-7', '61584', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', '2-chloro-1-propanol', 'C3H7ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', '2-氯-1-丙醇；2-氯-1-羟基丙烷', '外观与性状：稍带醚臭的无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.11\r\n沸点(℃)：133\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于多数有机溶剂。\r\n主要用途：是制造环氧丙烷的重要中间体，也广泛用于聚酯树脂生产。\r\n主要成分：纯品\r\nCAS号：78-89-7\r\n相对分子质量：94.54\r\n化学类别：78-89-7\r\n燃烧性：易燃\r\n闪点：44\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：218mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼有刺激性。可引起皮肤刺激。\r\n危险特性：遇高热、明火有引起燃烧的危险。受高热分解放出有毒的气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、酰基氯、酸酐、强碱。', '789', '醇', '2611', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (81, '627-30-5', '61584', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', '3-chloro-1-propanol', 'C3H7ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', '3-氯-1-丙醇；三亚甲基氯醇', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.13\r\n沸点(℃)：160~162\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：627-30-5\r\n相对分子质量：94.54\r\n化学类别：627-30-5\r\n燃烧性：可燃\r\n闪点：73\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：2300mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：遇高热、明火有引起燃烧的危险。受高热分解放出有毒的气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '789', '醇', '2849', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (82, '127-00-4', '61584', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', '1-chloro-2-propanol', 'C3H7ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', '1-氯-2-丙醇', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.11\r\n沸点(℃)：127\r\n相对密度(空气=1)：3.26\r\n饱和蒸气压(kPa)：0.65(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：127-00-4\r\n相对分子质量：94.54\r\n化学类别：127-00-4\r\n燃烧性：易燃\r\n闪点：51.7\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：1000ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：遇明火、高热易燃。与氧化剂可发生反应。受热分解产生有毒的氯化物气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱、酸酐、酰基氯。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (83, '96-23-1', '61585', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还\0', '1,3-dichloro-2-propanol；1,3-dichloroisopropyl alc', 'C3H6Cl2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后\0', '1,3-二氯-2-丙醇；1,3-二氯异丙醇', '外观与性状：无色液体，微有氯仿气味。\r\n熔点(℃)：-4\r\n相对密度(水=1)：1.37\r\n沸点(℃)：174\r\n相对密度(空气=1)：4.45\r\n饱和蒸气压(kPa)：0.13(28.0℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：96-23-1\r\n相对分子质量：129.00\r\n化学类别：96-23-1\r\n燃烧性：可燃\r\n闪点：73.9\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：90mg/kg(大鼠经口)；200mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜有强烈刺激性，吸入后损害呼吸道。此外尚有麻醉和损害实质性脏器的作用。急性吸入或经皮吸收中毒时，出现头痛、头晕、乏力、嗜睡、恶心、呕吐和上腹疼痛。重者有谵妄、休克和昏迷。病程中常伴有肝脏、心肌及肾损害，肺炎及肺水肿，皮肤粘膜出血，以及溶血性贫血等?\n危险特性：遇高热、明火或与氧化剂接触, 有引起燃烧的危险。高热时能分解出剧毒的光气。吸湿性强，遇水很快释出氯化氢。\r\n', '强酸、强氧化剂、强还原剂、酰基氯、酸酐。', '789', '醇', '2750', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (84, '102-81-8', '61588', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：尽可能减少直接接触。工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'dibutylaminoethanol；2-dibutyaminoethanol', 'C10H23NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '二丁氨基乙醇；N,N-二丁基乙醇胺', '外观与性状：无色液体, 微有氨的气味。\r\n熔点(℃)：-75\r\n相对密度(水=1)：0.89(20℃)\r\n沸点(℃)：224-232\r\n相对密度(空气=1)：6.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于甲醇、乙醇、乙醚、芳烃、乙酸乙酯、微溶于烃类。\r\n主要用途：用作溶剂、萃取剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：102-81-8\r\n相对分子质量：173.29\r\n化学类别：102-81-8\r\n燃烧性：可燃\r\n闪点：93\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：1070mg/kg(大鼠经口)；1.68ml/Kg(兔经皮]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有刺激性。\r\n危险特性：遇明火、高热可燃。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '789', '醇', '2873', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (85, '98-00-0', '61590', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'furfuryl alcohol', 'C5H6O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '呋喃甲醇；糠醇', '外观与性状：无色易流动液体，具有特殊的苦辣气味。\r\n熔点(℃)：-31\r\n相对密度(水=1)：1.13\r\n沸点(℃)：171\r\n相对密度(空气=1)：3.37\r\n饱和蒸气压(kPa)：0.13(31.8℃)\r\n燃烧热(kJ/mol)：2546.3\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于乙醇、乙醚、苯、氯仿。\r\n主要用途：用于合成树脂和加工染料等。\r\n主要成分：纯品\r\nCAS号：98-00-0\r\n相对分子质量：98.10\r\n化学类别：98-00-0\r\n燃烧性：可燃\r\n闪点：65\r\n引燃温度：490\r\n爆炸下限：1.8\r\n爆炸上限：16.3\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：275mg/kg(大鼠经口)；600mg/kg(兔经皮)\r\nLC50：233ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与酸类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品系刺激剂。高浓度持续吸入引起咳嗽、气短和胸部紧束感。极高浓度可引起死亡。蒸气对眼有刺激性，液体可引起眼部炎症和角膜混浊。皮肤接触其液体，引起皮肤干燥和刺激。口服出现头痛、恶心，口腔和胃刺激。\r\n危险特性：遇明火、高热可燃。与氧化剂可发生反应。与强酸接触能发生强烈反应, 引起燃烧或爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '酰基氯、氧、酸类。', '789', '醇', '2874', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (86, '111-88-6', '61591', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还\0', 'n-octyl mercaptan', 'C8H18S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专\0', '辛硫醇', '外观与性状：水白色液体，略有气味。\r\n熔点(℃)：-49.2\r\n相对密度(水=1)：0.84\r\n沸点(℃)：199.1\r\n相对密度(空气=1)：5.0\r\n饱和蒸气压(kPa)：0.21(37.7℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醇。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-88-6\r\n相对分子质量：146.30\r\n化学类别：111-88-6\r\n燃烧性：易燃\r\n闪点：46(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：如吸入或口服，对机体有害。对皮肤和眼有刺激性。接触后出现恶心、 头痛和呕吐。\r\n危险特性：遇高热、明火或与氧化剂接触, 有引起燃烧的危险。受高热分解产生有毒的硫化物烟气。\r\n', '碱、强氧化剂、强还原剂、碱金属。', '789', '醇', '3071', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (87, '98-02-2', '61591', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'furfuryl mercaptan；2-furanmethanethiol', 'C5H6OS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专\0', '糠硫醇；2-硫代呋喃甲醇', '外观与性状：无色油状液体，有恶臭。\r\n熔点(℃)：\r\n相对密度(水=1)：1.13\r\n沸点(℃)：155\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于有机合成, 用作硝酸腐蚀的抑制剂。\r\n主要成分：纯品\r\nCAS号：98-02-2\r\n相对分子质量：114.17\r\n化学类别：98-02-2\r\n燃烧性：易燃\r\n闪点：45\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：220mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。不宜久存，以免变质。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有刺激作用。接触后可引起恶心、头痛、呕吐。\r\n危险特性：遇高热、明火或与氧化剂接触, 有引起燃烧的危险。受高热分解产生有毒的硫化物烟气。\r\n', '氧化剂、还原剂、碱类、碱金属。', '789', '醇', '3071', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (88, '4410-99-5', '61591', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-phenylethylmercaptan；2-phenylethanethiol', 'C8H10S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后\0', '2-苯基乙硫醇；苯乙硫醇', '外观与性状：无色液体, 有令人不愉快的气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.03(15.5℃)\r\n沸点(℃)：193-225\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用于有机合成, 用作试剂。\r\n主要成分：纯品\r\nCAS号：4410-99-5\r\n相对分子质量：138.23\r\n化学类别：4410-99-5\r\n燃烧性：易燃\r\n闪点：71\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有刺激作用。接触后可引起头痛、恶心和呕吐。\r\n危险特性：遇明火、高热易燃。受高热分解产生有毒的硫化物烟气。接触强酸或受热分解放出有毒的甲醛气体。\r\n', '强氧化剂、强碱。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (89, '503-17-3', '31017', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-butyne；crotonylene', 'C4H6', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '2-丁炔；巴豆炔', '外观与性状：无色液体。\r\n熔点(℃)：-32.2\r\n相对密度(水=1)：0.69\r\n沸点(℃)：27\r\n相对密度(空气=1)：1.91\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：503-17-3\r\n相对分子质量：54.09\r\n化学类别：503-17-3\r\n燃烧性：易燃\r\n闪点：<-20\r\n引燃温度：\r\n爆炸下限：1.4\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过20℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮吸收，对机体可能产生危害。有刺激性。\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂能发生强烈反应, 引起燃烧或爆炸。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类。', '796', '炔烃', '1144', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (90, NULL, '61591', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '3-fluoropropyl mercaptan', 'C3H7FS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '3-氟丙基硫醇', '外观与性状：液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：100-101\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：94.14\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氟化氢。\r\n急性毒性：LD50：>100mg/kg(大鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (91, '1639-09-4', '61591', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'heptyl mercaptan；n-heptyl mercaptan', 'C7H16S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '庚硫醇', '外观与性状：具有强烈臭味的无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.84(20℃)\r\n沸点(℃)：57-58(1.33kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇、醚。\r\n主要用途：可用于生产燃料添加剂* 催化剂、农药、香料、溶剂和合成橡胶。\r\n主要成分：纯品\r\nCAS号：1639-09-4\r\n相对分子质量：132.27\r\n化学类别：1639-09-4\r\n燃烧性：易燃\r\n闪点：41\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱金属、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：目前无本品人和动物中毒的资料。本品属硫醇类，硫醇主要作用于中枢神经系统。低浓度吸入硫醇类蒸气引起头痛、恶心；较高浓度时具有不同程度的麻醉作用；高浓度可引起呼吸麻痹致死。\r\n危险特性：遇高热、明火或与氧化剂接触, 有引起燃烧的危险。受高热分解产生有毒的硫化物烟气。\r\n', '氧化剂、还原剂、碱金属、碱类。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (92, '111-76-2', '61592', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'ethylene glycol monobutyl ether', 'C6H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '乙二醇丁醚', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：-74.8\r\n相对密度(水=1)：0.90\r\n沸点(℃)：170.2\r\n相对密度(空气=1)：4.07\r\n饱和蒸气压(kPa)：40.00/140℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作溶剂和测定铁、钼的试剂。\r\n主要成分：纯品\r\nCAS号：111-76-2\r\n相对分子质量：118.17\r\n化学类别：111-76-2\r\n燃烧性：可燃\r\n闪点：71(O.C)\r\n引燃温度：244\r\n爆炸下限：1.1(170℃)\r\n爆炸上限：10.6(180℃)\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2500mg/kg(大鼠经口)；1200mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、等分开存放，切忌混储。不宜大量储存或久存。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气后，导致呼吸道刺激及肝肾损害。蒸气对眼有刺激性。皮肤接触可致皮炎。\r\n危险特性：遇明火、高热可燃。与氧化剂可发生反应。在空气中或在阳光照射下容易生成爆炸性的过氧化物。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、酰基氯、酸酐、卤素。', '770', '醚', '2369', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (93, '505-60-2', '61595', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂\0', 'dichlorodiethyl sulfide；mustard gas', 'C4H8Cl2S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '二氯二乙硫醚；芥子气', '外观与性状：无色油状液体，有大蒜气味，工业品呈深褐色。\r\n熔点(℃)：14.4\r\n相对密度(水=1)：1.27\r\n沸点(℃)：217(分解)\r\n相对密度(空气=1)：5.4\r\n饱和蒸气压(kPa)：0.01/30℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于丙酮、苯、乙醇、醚、四氯化碳、汽油、等\r\n主要用途：用于有机合成及制造军用毒气、药物等。\r\n主要成分：纯品\r\nCAS号：505-60-2\r\n相对分子质量：159.08\r\n化学类别：505-60-2\r\n燃烧性：可燃\r\n闪点：105\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫、氯化氢。\r\n急性毒性：LD50：0.7mg/kg(大鼠静脉)；20mg/kg(兔经皮)\r\nLC50：420mg/m3，2分钟(大鼠吸入)；100mg/m3， 10分钟(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，为致癌物。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：芥子气为糜烂性毒剂，对眼、呼吸道和皮肤都有作用。对皮肤能引起红肿、起泡以至溃烂。眼接触可致结膜炎、角膜混浊或有溃疡形成。吸入蒸气或雾损伤上呼吸道，高浓度可致肺损伤，重度损伤表现为咽喉、气管、支气管粘膜坏死性炎症。全身中毒症状有全身不适、疲乏、头痛、头晕、?\n危险特性：遇明火、高热可燃。与氧化剂可发生反应。受热分解或接触酸或酸雾时能释出有毒的硫氧化物或氯化物气体。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、水、酸类。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (94, '592-88-1', '61595', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂\0', 'diallyl thioether；allyl sulfide', 'C6H10S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专\0', '二烯丙基硫醚；烯丙基硫', '外观与性状：无色油状液体, 有蒜臭味。\r\n熔点(℃)：-83\r\n相对密度(水=1)：0.89\r\n沸点(℃)：139\r\n相对密度(空气=1)：3.90\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、氯仿、四氯化碳。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：592-88-1\r\n相对分子质量：114.21\r\n化学类别：592-88-1\r\n燃烧性：易燃\r\n闪点：46\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。本品具有强烈刺激性。高浓度接触严重损害粘膜、上呼吸道、眼和皮肤。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热易燃。遇水蒸气、酸或酸雾会产生易燃和有毒的硫化氢气体。\r\n', '强氧化剂、强碱。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (95, '10436-39-2', '61580', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化\0', 'tetrachloropropene', 'C3H2Cl4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水\0', '四氯丙烯', '外观与性状：无色、透明液体, 工业品常呈棕黄色。\r\n熔点(℃)：\r\n相对密度(水=1)：1.51\r\n沸点(℃)：167.1\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用于合成耐热塑料, 为制造1,2-二氯丙烯的中间产物。\r\n主要成分：纯品\r\nCAS号：10436-39-2\r\n相对分子质量：179.86\r\n化学类别：10436-39-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：3.73ml/kg(兔经皮)\r\nLC50：1500mg/m3(大鼠吸入)；3000mg/m3(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、活性金属粉末、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：抑制中枢神经系统；刺激呼吸道粘膜。对动物能导致呼吸道刺激、运动性兴奋及呼吸加速，然后呼吸极度困难、共济失调、轻瘫、四肢麻痹。本品对皮肤有强烈刺激性。可经皮吸收。\r\n危险特性：受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂、强碱、钾、钠。', '765', '卤代烯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (96, '63-25-2', '61888', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免\0', 'Sevin powder；1-naphthyl-N-methyl carbamate', 'C12H11NO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '西维因粉剂；1-萘基-N-甲基氨基甲酸酯', '外观与性状：白色结晶，工业品略带灰色或粉红色。\r\n熔点(℃)：145\r\n相对密度(水=1)：1.23\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、苯、丙酮、等多数有机溶剂。\r\n主要用途：用作杀虫剂。\r\n主要成分：\r\nCAS号：63-25-2\r\n相对分子质量：201.22\r\n化学类别：63-25-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：250～560mg/kg(大鼠经口)；4000mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：主要是抑制胆碱酯酶，使乙酰胆碱在组织中蓄积。主要症状为流涎、恶心、流泪、瞳孔缩小、视力模糊、肌束震颤等。其抑制胆碱酯酶的作用持续时间较短，停止接触后，胆碱酯酶恢复较快。\r\n危险特性：遇明火、高热可燃。与强氧化剂接触可发生化学反应。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、强碱。', '800', '未指定的化学类别', '2757', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (97, '1563-66-2', '61889', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。搬运时要轻装轻卸，防止包装\0', 'Furadan；Carbofuran', 'C12H15NO3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '呋喃丹；虫螨威', '外观与性状：纯品为白色无臭结晶，工业品稍有苯酚气味。\r\n熔点(℃)：153\r\n相对密度(水=1)：1.18\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于多数有机溶剂。\r\n主要用途：作农药杀虫剂。\r\n主要成分：\r\nCAS号：1563-66-2\r\n相对分子质量：221.38\r\n化学类别：1563-66-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：5.3mg/kg(大鼠经口)；885mg/kg(兔经皮)\r\nLC50：85ppm，2小时(哺乳类动物吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，剧毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：主要抑制体内胆碱酯酶活性，使乙酰胆碱在组织中蓄积而引起中毒。作用机制和有机磷农药中毒相似。中毒表现有流涎、流泪、瞳孔缩小及肌束震颤等。但与有机磷农药相比，抑制胆碱酯酶的作用持续的时间较短。停止接触后，胆碱酯酶恢复较快。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、碱类。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (98, '1582-09-8', '61892', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。\0', 'Trifluralin', 'C13H16F3N3O4', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '氟乐灵', '外观与性状：纯度为98% 是橙黄色结晶，有芳香气味。\r\n熔点(℃)：48.5-49\r\n相对密度(水=1)：\r\n沸点(℃)：139-140(0.56kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用作农用除草剂。\r\n主要成分：\r\nCAS号：1582-09-8\r\n相对分子质量：335.29\r\n化学类别：1582-09-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氟化物。\r\n急性毒性：LD50：>10000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：目前末见接触本品而引起中毒的病例。有报道，经常接触本品者，可引起接触性皮炎和光感性皮炎。\r\n危险特性：遇明火、高热可燃。受热分解, 放出有毒的氮氧化物和氟化物烟气。\r\n', '强氧化剂、强酸。', '800', '未指定的化学类别', '2779', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (99, '88-85-7', '61893', '监测方法：4-氨基安替比林分光光度法；溶剂解吸－气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。尽可能采取隔离操作。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意检测毒物。\r\n', '密闭操作，提供充分的局部排风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接触。搬运时要轻\0', 'dinitrobutylphenol；2-sec-butyl-4,6-dinitrophenol', 'C10H12N2O5', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '二硝基仲丁基苯酚', '外观与性状：暗黄色蜡状固体。\r\n熔点(℃)：69-73\r\n相对密度(水=1)：1.00\r\n沸点(℃)：\r\n相对密度(空气=1)：7.73\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于染料、有机合成、木材防腐等。\r\n主要成分：\r\nCAS号：88-85-7\r\n相对分子质量：240.21\r\n化学类别：88-85-7\r\n燃烧性：易燃\r\n闪点：40\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：25mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：直接作用于能量代谢过程，吸收后基础代谢率明显增加，体温增加。本品可经呼吸道和皮肤吸收进入体内。急性中毒有皮肤潮红、大汗、口渴、烦躁不安、全身乏力、心率和呼吸加快，高热可达40℃以上，可出现抽搐、肌肉强直、昏迷，最后血压下降而死亡。经口中毒可发生肝炎、粒细胞?\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强酸。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (100, '1910-42-5', '61896', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免\0', 'Paraquat', 'C12H14Cl2N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '百草枯', '外观与性状：白色粉末。\r\n熔点(℃)：>300\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、溶于醇、丙酮。\r\n主要用途：用作除草剂。\r\n主要成分：\r\nCAS号：1910-42-5\r\n相对分子质量：257.16\r\n化学类别：1910-42-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：139～162mg/kg(大鼠经口)；325mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：属中等毒类物质。中毒多为误服所引起，引起口腔、咽部的炎性损伤，同时可引起食管炎、胃炎。对心、肝、肾有损害作用。中毒出现终末支气管和肺泡上皮独特的增生。中毒数日后，出现呼吸困难、紫绀、呼吸衰竭，往往导致死亡。职业接触中毒主要由皮肤污染引起。长期接触可引起指?\n危险特性：遇明火、高热可燃。与强氧化剂接触可发生化学反应。受热分解放出有毒气体。\r\n', '强氧化剂、强酸、强碱。', '800', '未指定的化学类别', '2781', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (101, '126-99-8', '31013', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2-chloro-1,3-butadiene', 'C4H5Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '2-氯-1,3-丁二烯(抑制了的)；氯代丁二烯', '外观与性状：无色液体，有辛辣气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.96\r\n沸点(℃)：59.4\r\n相对密度(空气=1)：3.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：重要有机化工原料，用作有机合成中间体、氯丁橡胶的单体等。\r\n主要成分：纯品\r\nCAS号：126-99-8\r\n相对分子质量：88.54\r\n化学类别：126-99-8\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：\r\n爆炸下限：4.0\r\n爆炸上限：20.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：900mg/kg(大鼠经口)；260mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人和动物均不明确。\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏\0', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：以中枢神经系统抑制和呼吸道刺激作用为主。急性中毒：短期吸入高浓度蒸气出现流泪、咽干痛、胸闷、呼吸困难；结膜及咽部充血；肺部散在罗音；并有头昏、头痛、乏力、四肢麻木、步态不稳、恶心、呕吐、昏迷、抽搐等。个别发生急性肺水肿而死亡。急性期后可出现肝、肾损害及脱?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受高热分解产生有毒的氯化物气体。与强氧化剂发生反应, 可引起燃烧。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类。', '765', '卤代烯', '1991', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (102, '1420-06-0', '61904', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、碱类、接触\0', 'triphenomorph；trifenmorph', 'C23H23NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', 'N-三苯甲基吗啉；蜗螺净', '外观与性状：白色或淡黄色固体。\r\n熔点(℃)：185-187\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于氯仿、多数有机溶剂。\r\n主要用途：在农业上用于杀灭蜗牛和钉螺。\r\n主要成分：纯品\r\nCAS号：1420-06-0\r\n相对分子质量：329.44\r\n化学类别：1420-06-0\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：450～2200mg/kg(大鼠经口)；1000mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品可引起头晕、头痛、恶心、呕吐、幻视、神智模糊、口唇紫绀、胸闷、谵语、抽搐、昏迷等。\r\n危险特性：遇明火、高热可燃。受热分解，放出氮、硫的氧化物等毒性气体。\r\n', '强氧化剂、强酸、强碱。', '800', '未指定的化学类别', '2588', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (103, '140-56-7', '61904', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装\0', 'sodium p(dimethylamino)benzenediazo sulfonate', 'C8H10N3O3SNa', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '对二甲基氨基苯重氮磺酸钠；敌克松', '外观与性状：纯品为淡黄色结晶, 工业品为黄棕色无味粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于多数有机溶剂，溶于水、易溶于乙醇。\r\n主要用途：用作农用杀菌剂。\r\n主要成分：纯品\r\nCAS号：140-56-7\r\n相对分子质量：251.24\r\n化学类别：140-56-7\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、硫化物、氧化钠。\r\n急性毒性：LD50：60mg/kg(大鼠经口)；>100mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：动物中毒表现为萎靡、嗜睡，严重者有抽搐或昏迷。对人的致死量估计为2g。\r\n危险特性：遇明火、高热可燃。受热分解，放出氮、硫的氧化物等毒性气体。\r\n', '强氧化剂、强酸。', '747', '金属氨基化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (104, '1332-21-4', '61906', '监测方法：\r\n工程控制：密闭操作，局部排风。最好采用湿式操作。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：注意个人清洁卫生。\r\n', '密闭操作，局部排风。最好采用湿式操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'asbestos', NULL, NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '石棉', '外观与性状：白、灰、绿或褐色的纤维状。\r\n熔点(℃)：>1000\r\n相对密度(水=1)：2.5\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作隔热材料、粘合物、火炉及热汽管被覆物、过滤介质、耐火手套及衣物、闸带等。\r\n主要成分：\r\nCAS号：1332-21-4\r\n相对分子质量：\r\n化学类别：1332-21-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，为致癌物。\r\n侵入途径：吸入。\r\n健康危害：长期接触石棉者可引起石棉肺，病人有咳嗽、胸痛、呼吸困难等。晚期并发肺心病，出现水肿等心力衰竭现象。本品有致癌性，可引起肺癌和胸膜间皮瘤。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', NULL, '800', '未指定的化学类别', '2590', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (105, NULL, '81005', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离易燃、可燃物。避免产生粉尘。避免与碱类、接触。搬运时要轻装轻卸，防止包装及容\0', 'hydroxylamine nitrate', 'H4N2O4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硝酸羟胺', '外观与性状：无色结晶。\r\n熔点(℃)：48\r\n相对密度(水=1)：\r\n沸点(℃)：100(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于多数有机溶剂。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：96.05\r\n化学类别：\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与易燃物或可燃物、碱类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，有毒，具强腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有强腐蚀性。能强烈腐蚀皮肤、眼睛和粘膜，甚至造成灼伤。\r\n危险特性：有强腐蚀性。加热至 100℃以上挥发分解，并易爆炸。\r\n', '易燃或可燃物、碱类。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (106, '7446-11-9', '81010', '监测方法：氯化钡比浊法\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）；可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离易燃、可燃物。避免与还原剂、碱类、活性金属粉末、接触。尤其要注意避免与水接触。搬运时要轻装\0', 'sulfur trioxide', 'SO3', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。若是液体，小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器内，回收或运至\0', '三氧化硫；硫酸酐', '外观与性状：针状固体或液体，有刺激性气味。\r\n熔点(℃)：16.8\r\n相对密度(水=1)：1.97\r\n沸点(℃)：44.8\r\n相对密度(空气=1)：2.8\r\n饱和蒸气压(kPa)：37.32/25℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：有机合成用磺化剂。\r\n主要成分：纯品\r\nCAS号：7446-11-9\r\n相对分子质量：80.06\r\n化学类别：7446-11-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、还原剂、碱类、活性金属粉末、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：其毒性表现与硫酸同。对皮肤、粘膜等组织有强烈的刺激和腐蚀作用。可引起结膜炎、水肿。角膜混浊，以致失明；引起呼吸道刺激症状，重者发生呼吸困难和肺水肿；高浓度引起喉痉挛或声门水肿而死亡。口服后引起消化道的烧伤以至溃疡形成。严重者可能有胃穿孔、腹膜炎、喉痉挛和?\n危险特性：与水发生爆炸性剧烈反应。与氧气、氟、氧化铅、次亚氯酸、过氯酸、磷、四氟乙烯等接触剧烈反应。与有机材料如木、棉花或草接触，会着火。吸湿性极强，在空气中产生有毒的白烟。遇潮时对大多数金属有强腐蚀性。\r\n', '强碱、强还原剂、活性金属粉末、水、易燃或可燃物。', '748', '非金属氧化物', '1829', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (107, '10025-67-9', '81032', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与酸类、碱类、醇类、碱金属、接触。尤其要注意避免与\0', 'sulfur chloride；disulfur dichloride', 'S2Cl2', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器内，回收或运至\0', '一氯化硫；二氯化二硫', '外观与性状：发红光的暗黄色液体，在空气中发烟并有刺激性气味。\r\n熔点(℃)：-80\r\n相对密度(水=1)：1.69\r\n沸点(℃)：138\r\n相对密度(空气=1)：4.7\r\n饱和蒸气压(kPa)：1.33/19℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、苯、醚、二硫化碳、四氯化碳。\r\n主要用途：用作氯化剂或硫化剂。\r\n主要成分：纯品\r\nCAS号：10025-67-9\r\n相对分子质量：135.04\r\n化学类别：10025-67-9\r\n燃烧性：不燃\r\n闪点：118\r\n引燃温度：234\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氧化硫、硫化氢。\r\n急性毒性：LD50：\r\nLC50：150ppm(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过35℃，相对湿度不超过80％。应与酸类、碱类、醇类、碱金属、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，高毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：具有窒息性气味，对眼和上呼吸道粘膜有强烈的刺激性，并可致严重皮肤灼伤。少数严重中毒者可引起肺水肿。\r\n危险特性：与水或潮气发生反应，散发出刺激性和腐蚀性的氯化氢气体。遇潮时对大多数金属有强腐蚀性。\r\n', '酸类、碱类、醇类、过氧化物、水、碱金属。', '783', '硫化物', '1828', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (108, NULL, '81049', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。防止蒸气泄漏到工作场所空气中。避免与醇类、碱类、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防止包装及容器\0', 'lead tetrachloride', 'PbCl4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。小量泄漏：将地面洒上苏打灰，然后用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器\0', '四氯化铅', '外观与性状：黄色油状发烟液体。\r\n熔点(℃)：-15\r\n相对密度(水=1)：3.18\r\n沸点(℃)：105(爆炸)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚。\r\n主要用途：用于有机盐合成。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：349.00\r\n化学类别：\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气、受热。\r\n燃烧(分解)产物：氯化物、氧化铅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与醇类、碱类、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：铅及其化合物损害造血、神经、消化系统及肾脏。职业中毒主要为慢性。神经系统主要表现为神经衰弱综合征、周围神经病（以运动功能受累较明显），重者出现铅中毒性脑病。消化系统表现有齿龈铅线、食欲不振、恶心、腹胀、腹泻或便秘；腹绞痛见于中等及较重病例。造血系统损害出?\n危险特性：具有强氧化性。受高热能引起爆炸。遇潮能分解出有毒的氯化氢烟雾。\r\n', '水、醇类、碱类。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (109, '7446-14-2', '81062', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免产生粉尘。避免与碱类、接触。搬运时轻装轻卸，保持包装完整，防止洒漏。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'lead sulfate；sulfuric acid,lead salt', 'PbSO4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。用砂土、蛭石或其它惰性材料吸收。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硫酸铅', '外观与性状：白色单斜方晶体, 味甜。\r\n熔点(℃)：1000(分解)\r\n相对密度(水=1)：6.2\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：微溶于热水、浓硫酸、溶于浓盐酸、浓碱、不溶于醇。\r\n主要用途：用作草酸的触媒, 用于制白色颜料、电池及快干漆等。\r\n主要成分：纯品\r\nCAS号：7446-14-2\r\n相对分子质量：303.25\r\n化学类别：7446-14-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化铅、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与碱类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，有毒，具强腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：损害造血、神经、消化系统及肾脏。职业中毒主要为慢性。神经系统主要表现为神经衰弱综合征，周围神经病（以运动功能受累较明显），重者出现铅中毒性脑病。消化系统表现有齿龈铅线、食欲不振、恶心、腹胀、腹泻或便秘；腹绞痛见于中等及较重病例。造血系统损害出现卟啉代谢障?\n危险特性：不燃。\r\n', '强碱。', '783', '硫化物', '1794', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (110, NULL, '81103', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。搬运时要轻装轻卸，\0', 'boron trifluoride acetic anhydride', 'C4H6BF3O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '三氟化硼醋酸酐；三氟化硼酐', '外观与性状：白色结晶性粉末, 易潮解。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：169.91\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、氧化硼。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、粘膜、皮肤有强烈刺激作用，可致皮肤灼伤。\r\n危险特性：遇明火、高热可燃。具有腐蚀性。\r\n', '氧化剂、碱类。', '778', '酸酐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (111, '75-29-6', '31020', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-chloropropane；isopropyl chloride', 'C3H7Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-氯丙烷；异丙基氯', '外观与性状：无色液体。\r\n熔点(℃)：-117.6\r\n相对密度(水=1)：0.86\r\n沸点(℃)：35.3\r\n相对密度(空气=1)：2.71\r\n饱和蒸气压(kPa)：40.00(25.5℃)\r\n燃烧热(kJ/mol)：2014.8\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于甲醇、乙醚。\r\n主要用途：用作溶剂和用于异丙胺制造。\r\n主要成分：纯品\r\nCAS号：75-29-6\r\n相对分子质量：78.54\r\n化学类别：75-29-6\r\n燃烧性：易燃\r\n闪点：-32\r\n引燃温度：590\r\n爆炸下限：2.8\r\n爆炸上限：10.7\r\n最小点火能：1.55\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具麻醉性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有很强的麻醉作用；对肝和肾脏有损害；对皮肤和粘膜有轻度刺激作用；溅入眼内引起疼痛和刺激症状。\r\n危险特性：其蒸气与空气可形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热分解产生有毒的氯化物气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱。', '759', '卤代烷', '2356', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (112, '506-96-7', '81110', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', 'acetyl bromide', 'C2H3BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '乙酰溴；溴乙酰', '外观与性状：无色发烟液体，露置空气中变黄。\r\n熔点(℃)：-96.5\r\n相对密度(水=1)：1.52\r\n沸点(℃)：76.7\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、氯仿、苯。\r\n主要用途：用于有机合成、染料制造。\r\n主要成分：纯品\r\nCAS号：506-96-7\r\n相对分子质量：122.96\r\n化学类别：506-96-7\r\n燃烧性：易燃\r\n闪点：1\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤和粘膜有明显的刺激作用。吸入可引起呼吸道的明显危害。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，受热分解放出溴化氢和剧毒的碳酰溴。与水和乙醇发生激烈分解生成溴氢酸和乙酸。遇潮时对大多数金属有强腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '800', '未指定的化学类别', '1716', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (113, NULL, '81111', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', 'propionyl bromide', 'C3H5BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '丙酰溴；溴丙酰', '外观与性状：无色或浅黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.52\r\n沸点(℃)：103\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：136.98\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道和皮肤有刺激作用，可引起灼伤。\r\n危险特性：易燃，受热分解放出溴化氢和剧毒的碳酰溴。与水和乙醇发生激烈分解生成溴氢酸和乙酸。遇潮时对大多数金属有强腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (114, '563-76-8', '81113', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', '2-bromopropionyl bromide', 'C3H4Br2O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '2-溴丙酰溴', '外观与性状：无色或浅黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：2.06\r\n沸点(℃)：152~154\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.33/48℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于乙酸、苯、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：563-76-8\r\n相对分子质量：215.88\r\n化学类别：563-76-8\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。可引起灼伤。对粘膜、上呼吸道、眼、皮肤等组织有极强的破坏作用。吸入后可能因喉、支气管的炎症、水肿、痉挛，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心、呕吐。\r\n危险特性：可燃。与水发生剧烈反应，释出白色烟雾状的刺激性和腐蚀性的溴化氢气体。遇潮时对大多数金属有强腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '741', '卤素与卤间化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (115, '507-02-8', '81114', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中\0', 'acety1 iodide；ethanoyl iodide', 'C2H3IO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '乙酰碘；碘乙酰', '外观与性状：无色发烟液体, 在潮气中或空气中变棕色。\r\n熔点(℃)：\r\n相对密度(水=1)：2.07(20℃)\r\n沸点(℃)：108\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、苯。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：507-02-8\r\n相对分子质量：169.96\r\n化学类别：507-02-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤和粘膜有刺激作用。吸入或误服可引起中毒。毒性比乙酰氯、乙酰溴强。蒸气对呼吸道粘膜有强烈刺激和腐蚀性。遇水或水蒸气产生有毒或腐蚀性的烟雾。\r\n危险特性：可燃。遇水或乙醇发生反应放出有毒和腐蚀性的气体。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、醇类、潮湿空气。', '800', '未指定的化学类别', '1898', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (116, '142-61-0', '81115', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', 'hexanoyl chloride；caproyl chloride', 'C6H11ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至\0', '己酰氯；氯化己酰', '外观与性状：无色液体。\r\n熔点(℃)：-87.3\r\n相对密度(水=1)：0.97\r\n沸点(℃)：151~153\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、氯仿、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：142-61-0\r\n相对分子质量：134.61\r\n化学类别：142-61-0\r\n燃烧性：易燃\r\n闪点：50\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、光气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入、摄入或经皮肤吸收对身体有害。吸入可能由于喉、支气管的痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，与水或潮气发生反应，散发出刺激性和腐蚀性的氯化氢气体。对大多数金属有腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (117, '79-37-8', '81116', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾\0', 'ethanedioyl chloride；oxalyl chloride', 'C2Cl2O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入\0', '乙二酰氯；草酰氯', '外观与性状：无色发烟液体，有刺激性气味。\r\n熔点(℃)：-12\r\n相对密度(水=1)：1.49\r\n沸点(℃)：63\r\n相对密度(空气=1)：4.4\r\n饱和蒸气压(kPa)：20.0/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、苯、氯仿。\r\n主要用途：用于有机氯化物制备，也用于制作军用毒气。\r\n主要成分：纯品\r\nCAS号：79-37-8\r\n相对分子质量：126.93\r\n化学类别：79-37-8\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、光气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与碱类、醇类、等分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：具有强烈的刺激性，可引起皮肤和粘膜的严重灼伤。少量吸入，引起食欲减退，以后出现咳嗽、呼吸困难、易疲劳、腹泻、呕吐、头痛、气喘、视力减退等。\r\n危险特性：可燃。遇高温（ 600℃以下）或与脱水剂（三氯化铝）共存时加热分解为剧毒的光气和一氧化碳。遇水分解生成盐酸和草酸。与钾 -钠合金接触剧烈反应。\r\n', '碱类、水、醇类。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (118, '79-36-7', '81118', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中\0', '2,2-dichloroacetyl chloride；dichloroethanoyl chlo', 'C2HCl3O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至\0', '2,2-二氯乙酰氯', '外观与性状：发烟液体, 有刺激性气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.53(16℃)\r\n沸点(℃)：108\r\n相对密度(空气=1)：5.1\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于乙醚。\r\n主要用途：作为有机合成中间体、氯乙酰化剂。\r\n主要成分：纯品\r\nCAS号：79-36-7\r\n相对分子质量：147.39\r\n化学类别：79-36-7\r\n燃烧性：可燃\r\n闪点：66\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：2460mg/kg(大鼠经口)；650mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。对眼睛、皮肤、粘膜和上呼吸道有刺激作用，可引起灼伤。吸入后能引起喉、支气管的炎症、水肿、痉挛，化学性肺炎或肺水肿。接触后可引起烧灼感、咳嗽、喘息、气短、头痛、恶心和呕吐等。\r\n危险特性：能与很多物质发生剧烈反应导致燃烧爆炸。受热或遇水、酸分解放热, 放出有毒烟气。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、强碱、水、醇类。', '739', '有机酰卤', '1765', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (119, '108-94-1', '33590', '监测方法：气相色谱法；糠醛比色法；溶剂解吸－气相色谱法\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'cyclohexanone；ketohexamethylene', 'C6H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '环己酮', '外观与性状：无色或浅黄色透明液体，有强烈的刺激性臭味。\r\n熔点(℃)：-45\r\n相对密度(水=1)：0.95\r\n沸点(℃)：115.6\r\n相对密度(空气=1)：3.38\r\n饱和蒸气压(kPa)：1.33(38.7℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：385.9\r\n临界压力(MPa)：4.06\r\n辛醇/水分配系数：0.81\r\n溶解性：微溶于水、可混溶于醇、醚、苯、丙酮、等多数有机溶剂。\r\n主要用途：主要用于制造己内酰胺和己二酸，也是优良的溶剂。\r\n主要成分：含量: 优级≥99.5％;合格品≥99.0％。\r\nCAS号：108-94-1\r\n相对分子质量：98.14\r\n化学类别：108-94-1\r\n燃烧性：易燃\r\n闪点：43\r\n引燃温度：420\r\n爆炸下限：1.1\r\n爆炸上限：9.4\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1535mg/kg(大鼠经口)；948mg/kg(兔经皮)\r\nLC50：32080mg/m3，4小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：动物可疑阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有麻醉和刺激作用。急性中毒：主要表现有眼、鼻、喉粘膜刺激症状和头晕、胸闷、全身无力等症状。重者可出现休克、昏迷、四肢抽搐、肺水肿，最后因呼吸衰竭而死亡。脱离接触后能较快恢复正常。液体对皮肤有刺激性；眼接触有可能造成角膜损害。慢性影响：长期反复接触可?\n危险特性：易燃，遇高热、明火有引起燃烧的危险。与氧化剂接触猛烈反应。\r\n', '强氧化剂、强还原剂、塑料。', '775', '酮', '1915', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (120, '110-82-7', '31004', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度超标时，戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'cyclohexane；hexahydrobenzene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '环己烷；六氢化苯', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：6.5\r\n相对密度(水=1)：0.78\r\n沸点(℃)：80.7\r\n相对密度(空气=1)：2.90\r\n饱和蒸气压(kPa)：13.33(60.8℃)\r\n燃烧热(kJ/mol)：3916.1\r\n临界温度(℃)：280.4\r\n临界压力(MPa)：4.05\r\n辛醇/水分配系数：7(计算值)\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯、丙酮、等多数有机溶剂。\r\n主要用途：用作一般溶剂、色谱分析标准物质及用于有机合成。\r\n主要成分：纯品\r\nCAS号：110-82-7\r\n相对分子质量：84.16\r\n化学类别：110-82-7\r\n燃烧性：易燃\r\n闪点：-16.5\r\n引燃温度：245\r\n爆炸下限：1.2\r\n爆炸上限：8.4\r\n最小点火能：0.22\r\n最大爆炸压力：0.843\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：12705mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼和上呼吸道有轻度刺激作用。持续吸入可引起头晕、恶心、倦睡和其他一些麻醉症状。液体污染皮肤可引起痒感。\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触发生强烈反应, 甚至引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '1145', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (121, '108-91-8', '82021', '监测方法：\r\n工程控制：密闭操作，注意通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴直接式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防腐工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴化学安全防护眼镜，穿防腐工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'cyclohexylamine；hexahydroaniline', 'C6H13N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。从上风处进入现场。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗\0', '环己胺；六氢苯胺', '外观与性状：无色液体，有不愉快的气味。\r\n熔点(℃)：-17.7\r\n相对密度(水=1)：0.86\r\n沸点(℃)：134.5\r\n相对密度(空气=1)：3.42\r\n饱和蒸气压(kPa)：1.17(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作锅炉水处理剂及腐蚀抑制剂，橡胶促进剂，有机合成中间体。\r\n主要成分：含量: 优级≥98.5％;一级≥95.0％。\r\nCAS号：108-91-8\r\n相对分子质量：92.19\r\n化学类别：108-91-8\r\n燃烧性：易燃\r\n闪点：32(O.C)\r\n引燃温度：293\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：710mg/kg(大鼠经口)；227mg/kg(兔经皮)\r\nLC50：7500mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.2类  碱性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气可发生急性中毒。中毒表现有剧烈呕吐及腹泻；瞳孔散大和对光反应迟钝、视力模糊、萎靡、语言障碍。人体斑贴试验见25％本品溶液引起严重的皮肤刺激，并可能致过敏反应。\r\n危险特性：易燃，遇明火、高热易燃。受热分解释出剧毒的烟雾。与氧化剂接触猛烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、酰基氯、酸酐、强氧化剂。', '762', '脂肪胺', '2357', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (122, '96-41-3', '33556', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。\0', 'cyclopentanol；cyclopentyl alcohol', 'C5H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '环戊醇；羟基环戊烷', '外观与性状：无色澄清液体, 有令人愉快的气味。\r\n熔点(℃)：-19\r\n相对密度(水=1)：0.95(20℃)\r\n沸点(℃)：139.5\r\n相对密度(空气=1)：2.97\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、可混溶于酮、醚。\r\n主要用途：用作香料及药品的溶剂和染料中间体。\r\n主要成分：纯品\r\nCAS号：96-41-3\r\n相对分子质量：86.13\r\n化学类别：96-41-3\r\n燃烧性：易燃\r\n闪点：51\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或口服对身体有害。高浓度下可能有麻醉作用。具有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂。', '789', '醇', '2244', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (123, '120-92-3', '33590', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'cyclopentanone', 'C5H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '环戊酮', '外观与性状：水白色液体，有醚样的气味。\r\n熔点(℃)：-58.2\r\n相对密度(水=1)：0.95\r\n沸点(℃)：130.6\r\n相对密度(空气=1)：2.3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用于药品、生物制品、杀虫剂和合成橡胶的中间体。\r\n主要成分：纯品\r\nCAS号：120-92-3\r\n相对分子质量：84.12\r\n化学类别：120-92-3\r\n燃烧性：易燃\r\n闪点：26\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1950mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害，对眼、皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂、强碱、强还原剂。', '775', '酮', '2245', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (124, '287-92-3', '31003', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。\0', 'cyclopentane；pentamethylene', 'C5H10', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液\0', '环戊烷；五亚甲基', '外观与性状：无色透明液体，有苯样的气味。\r\n熔点(℃)：-93.7\r\n相对密度(水=1)：0.75\r\n沸点(℃)：49.3\r\n相对密度(空气=1)：2.42\r\n饱和蒸气压(kPa)：53.32(31℃)\r\n燃烧热(kJ/mol)：3287.8\r\n临界温度(℃)：238.6\r\n临界压力(MPa)：4.52\r\n辛醇/水分配系数：7(计算值)\r\n溶解性：不溶于水、溶于醇、醚、苯、四氯化碳、丙酮、等多数有机溶剂。\r\n主要用途：用作溶剂和色谱分析的标准物质。\r\n主要成分：纯品\r\nCAS号：287-92-3\r\n相对分子质量：70.08\r\n化学类别：287-92-3\r\n燃烧性：易燃\r\n闪点：-25\r\n引燃温度：361\r\n爆炸下限：1.4\r\n爆炸上限：8.0\r\n最小点火能：0.23\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过26℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入后可引起头痛、头晕、定向力障碍、兴奋、倦睡、共济失调和麻醉作用。呼吸系统和心脏可受到影响。对眼有轻度刺激作用。口服致中枢神经系统抑制、粘膜出血和腹泻等。本品对皮肤有脱脂作用，引起皮肤干燥、发红等。\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触发生强烈反应, 甚至引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '1146', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (125, '142-29-0', '31008', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。灌装\0', 'cyclopentene', 'C5H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不\0', '环戊烯', '外观与性状：无色液体。\r\n熔点(℃)：-93.3\r\n相对密度(水=1)：0.77\r\n沸点(℃)：44.2\r\n相对密度(空气=1)：2.35\r\n饱和蒸气压(kPa)：10.13(-10℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：233\r\n临界压力(MPa)：4.79\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯、等多数有机溶剂。\r\n主要用途：用于有机合成，作树脂的交联剂。\r\n主要成分：纯品\r\nCAS号：142-29-0\r\n相对分子质量：68.13\r\n化学类别：142-29-0\r\n燃烧性：易燃\r\n闪点：-30\r\n引燃温度：395\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1656mg/kg(大鼠经口)；1231mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过10℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品恶臭，较低浓度时已难耐受，因此一般不易发性中毒、 嗅阈为36.14mg/m3。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与氧化剂接触发生强烈反应, 甚至引起燃烧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '780', '烯烃', '2246', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (126, '629-20-9', '32028', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'cyclooctatetraene', 'C8H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '环辛四烯；1,3,5,7-环辛四烯', '外观与性状：无色至黄色液体。\r\n熔点(℃)：-27\r\n相对密度(水=1)：0.93\r\n沸点(℃)：142～143\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.05(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、丙酮、苯。\r\n主要用途：用于制合成纤维、染料和药物等, 也广泛用于有机合成。\r\n主要成分：纯品\r\nCAS号：629-20-9\r\n相对分子质量：104.14\r\n化学类别：629-20-9\r\n燃烧性：易燃\r\n闪点：22\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。对眼睛和皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂。', '780', '烯烃', '2358', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (127, '292-64-8', '33504', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'cyclooctane；octamethylene', 'C8H16', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '环辛烷', '外观与性状：无色液体或潮湿的白色固体, 有类似樟脑的气味。\r\n熔点(℃)：14.7\r\n相对密度(水=1)：0.83\r\n沸点(℃)：140(93.31kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：93.31(140℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于苯。\r\n主要用途：用于有机合成, 用作化学试剂。\r\n主要成分：纯品\r\nCAS号：292-64-8\r\n相对分子质量：112.2\r\n化学类别：292-64-8\r\n燃烧性：易燃\r\n闪点：30\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。对眼和皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与强氧化剂接触可发生化学反应。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (128, '931-87-3', '32027', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（全面罩）或自给式呼吸器。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'cyclooctene', 'C8H14', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '环辛烯', '外观与性状：无色液体。\r\n熔点(℃)：(顺)-12;(反)-59\r\n相对密度(水=1)：0.85\r\n沸点(℃)：(顺)138;(反)143\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.40;10.40(反)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：931-87-3\r\n相对分子质量：110.19\r\n化学类别：931-87-3\r\n燃烧性：易燃\r\n闪点：25\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。对眼和皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (129, '24969-06-0', '32197', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触\0', 'epoxy resin', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。若是液体，尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容。\0', '环氧树脂', '外观与性状：根据分子结构和分子量大小的不同, 其物态可从无臭、无味的黄色透明液体至固体。\r\n熔点(℃)：145～155\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于丙酮、乙二醇、甲苯。\r\n主要用途：用作金属涂料、金属粘合剂、玻璃纤维增强结构材料、防腐材料、金属加工用模具等, 在电器工业中用作绝缘材料。\r\n主要成分：\r\nCAS号：24969-06-0\r\n相对分子质量：350-8000\r\n化学类别：24969-06-0\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：490(粉云)\r\n爆炸下限：12\r\n爆炸上限：\r\n最小点火能：9\r\n最大爆炸压力：0.540\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：11400mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：制备和使用环氧树脂的工人，可有头痛、恶心、食欲不振、眼灼痛、眼睑水肿、上呼吸道刺激、皮肤病症等。本品的主要危害为引起过敏性皮肤病，其表现形式为瘙痒性红斑、丘疹、疱疹、湿疹性皮炎等。\r\n危险特性：易燃，遇明火、高热能燃烧。受高热分解放出有毒的气体。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂。', '800', '未指定的化学类别', '1866', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (130, '66-25-1', '33573', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'n-hexaldehyde；hexanal', 'C6H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '己醛；正己醛', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：-56.3\r\n相对密度(水=1)：0.83\r\n沸点(℃)：128.7\r\n相对密度(空气=1)：3.45\r\n饱和蒸气压(kPa)：1.15(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于苯、丙酮、易溶于乙醇、乙醚。\r\n主要用途：用作增塑剂，以及用于橡胶、树脂、杀虫剂的有机合成。\r\n主要成分：纯品\r\nCAS号：66-25-1\r\n相对分子质量：100.16\r\n化学类别：66-25-1\r\n燃烧性：易燃\r\n闪点：32(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4890mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、还原剂、碱类、分开存放，切忌混储。不宜久存，以免变质。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用，引起咳嗽、流泪、流涎；个别人有恶心、头痛、胸骨后疼痛和呼吸困难等。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。在潮湿空气中缓慢分解。\r\n', '强氧化剂、强还原剂、强碱。', '773', '醛', '1207', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (131, '123-66-0', '33600', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethyl caproate；ethyl hexoate', 'C8H16O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '己酸乙酯', '外观与性状：无色液体，有香气。\r\n熔点(℃)：\r\n相对密度(水=1)：0.87\r\n沸点(℃)：167\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于多数有机溶剂。\r\n主要用途：用于有机合成、人造香精。\r\n主要成分：纯品\r\nCAS号：123-66-0\r\n相对分子质量：144.21\r\n化学类别：123-66-0\r\n燃烧性：易燃\r\n闪点：49\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道、眼和皮肤有刺激性。\r\n危险特性：遇高热、明火有引起燃烧的危险。受热放出辛辣的腐蚀性烟雾。\r\n', '酸类、碱、强氧化剂、强还原剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (132, '110-54-3', '31005', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'n-hexane；hexyl hydride', 'C6H14', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '己烷；正己烷', '外观与性状：无色液体，有微弱的特殊气味。\r\n熔点(℃)：-95.6\r\n相对密度(水=1)：0.66\r\n沸点(℃)：68.7\r\n相对密度(空气=1)：2.97\r\n饱和蒸气压(kPa)：13.33(15.8℃)\r\n燃烧热(kJ/mol)：4159.1\r\n临界温度(℃)：234.8\r\n临界压力(MPa)：3.09\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成，用作溶剂、化学试剂、涂料稀释剂、聚合反应的介质等。\r\n主要成分：纯品\r\nCAS号：110-54-3\r\n相对分子质量：86.17\r\n化学类别：110-54-3\r\n燃烧性：易燃\r\n闪点：-25.5\r\n引燃温度：244\r\n爆炸下限：1.2\r\n爆炸上限：6.9\r\n最小点火能：0.24\r\n最大爆炸压力：0.850\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：28710mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有麻醉和刺激作用。长期接触可致周围神经炎。急性中毒：吸入高浓度本品出现头痛、头晕、恶心、共济失调等，重者引起神志丧失甚至死亡。对眼和上呼吸道有刺激性。    慢性中毒：长期接触出现头痛、头晕、乏力、胃纳减退；其后四肢远端逐渐发展成感觉异常，麻木，触、痛、?\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触发生强烈反应, 甚至引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '1208', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (133, '108-88-3', '32052', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器或氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'methylbenzene；Toluene', 'C7H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '甲苯', '外观与性状：无色透明液体，有类似苯的芳香气味。\r\n熔点(℃)：-94.9\r\n相对密度(水=1)：0.87\r\n沸点(℃)：110.6\r\n相对密度(空气=1)：3.14\r\n饱和蒸气压(kPa)：4.89(30℃)\r\n燃烧热(kJ/mol)：3905.0\r\n临界温度(℃)：318.6\r\n临界压力(MPa)：4.11\r\n辛醇/水分配系数：2.69\r\n溶解性：不溶于水、可混溶于苯、醇、醚、等多数有机溶剂。\r\n主要用途：用于掺合汽油组成及作为生产甲苯衍生物、炸药、染料中间体、药物等的主要原料。\r\n主要成分：纯品\r\nCAS号：108-88-3\r\n相对分子质量：92.14\r\n化学类别：108-88-3\r\n燃烧性：易燃\r\n闪点：4\r\n引燃温度：535\r\n爆炸下限：1.2\r\n爆炸上限：7.0\r\n最小点火能：2.5\r\n最大爆炸压力：0.666\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5000mg/kg(大鼠经口)；12124mg/kg(兔经皮)\r\nLC50：20003mg/m3，8小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有严重危害，对空气、水环境及水源可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对皮肤、粘膜有刺激性，对中枢神经系统有麻醉作用。急性中毒：短时间内吸入较高浓度本品可出现眼及上呼吸道明显的刺激症状、眼结膜及咽部充血、头晕、头痛、恶心、呕吐、胸闷、四肢无力、步态蹒跚、意识模糊。重症者可有躁动、抽搐、昏迷。慢性中毒：长期接触可发生神经衰弱?\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '740', '芳香烃', '1294', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (134, '67-56-1', '32058', '监测方法：气相色谱法；变色酸分光光度法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧\0', 'methyl alcohol；methanol', 'CH4O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗\0', '甲醇；木酒精', '外观与性状：无色澄清液体，有刺激性气味。\r\n熔点(℃)：-97.8\r\n相对密度(水=1)：0.79\r\n沸点(℃)：64.8\r\n相对密度(空气=1)：1.11\r\n饱和蒸气压(kPa)：13.33(21.2℃)\r\n燃烧热(kJ/mol)：727.0\r\n临界温度(℃)：240\r\n临界压力(MPa)：7.95\r\n辛醇/水分配系数：-0.82/-0.66\r\n溶解性：溶于水、可混溶于醇、醚、等多数有机溶剂。\r\n主要用途：主要用于制甲醛、香精、染料、医药、火药、防冻剂等。\r\n主要成分：纯品\r\nCAS号：67-56-1\r\n相对分子质量：32.04\r\n化学类别：67-56-1\r\n燃烧性：易燃\r\n闪点：11\r\n引燃温度：385\r\n爆炸下限：5.5\r\n爆炸上限：44.0\r\n最小点火能：0.215\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5628mg/kg(大鼠经口)；15800mg/kg(兔经皮)\r\nLC50：83776mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱金属、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对中枢神经系统有麻醉作用；对视神经和视网膜有特殊选择作用，引起病变；可致代射性酸中毒。急性中毒：短时大量吸入出现轻度眼上呼吸道刺激症状（口服有胃肠道刺激症状）；经一段时间潜伏期后出现头痛、头晕、乏力、眩晕、酒醉感、意识朦胧、谵妄，甚至昏迷。视神经及视网膜?\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂接触发生化学反应或引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、酸酐、强氧化剂、碱金属。', '789', '醇', '1230', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (135, '80-62-6', '32149', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl methacrylate；methacrylic acid methyl ester', 'C5H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。或用不燃性分散剂制成的乳液刷洗，洗液稀\0', '甲基丙烯酸甲酯；α-甲基丙烯酸甲酯', '外观与性状：无色易挥发液体, 并具有强辣味。\r\n熔点(℃)：-50\r\n相对密度(水=1)：0.94(20℃)\r\n沸点(℃)：101\r\n相对密度(空气=1)：2.86\r\n饱和蒸气压(kPa)：5.33(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.38\r\n溶解性：微溶于水、溶于乙醇、等\r\n主要用途：用作有机玻璃的单体, 也用于制造其他树脂、塑料、涂料、粘合剂、润滑剂、木材和软木的浸润剂、纸张上光剂等。\r\n主要成分：纯品\r\nCAS号：80-62-6\r\n相对分子质量：100.12\r\n化学类别：80-62-6\r\n燃烧性：易燃\r\n闪点：10\r\n引燃温度：435\r\n爆炸下限：2.12\r\n爆炸上限：12.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：光照易聚合。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：7872mg/kg(大鼠经口)\r\nLC50：12412mg/m3(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。避光保存。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、卤素、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有麻醉作用，有刺激性。急性中毒：表现有粘膜刺激症状、乏力、恶心、反复呕吐、头痛、头晕、胸闷，可有急识障碍。慢性影响：体检发现接触者中血压增高、萎缩性鼻炎、结膜炎和植物神经功能障碍百分比增高。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。在受热、光和紫外线的作用下易发生聚合，粘度逐渐增加，严重时整个容器的单体可全部发生不规则爆发性聚合。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '氧化剂、酸类、碱类、还原剂、过氧化物、胺类、卤素。', '781', '丙烯酰基化合物', '1247', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (136, '97-63-2', '32149', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethyl methacrylate；ethyl-α-methyl acrylate', 'C6H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '甲基丙烯酸乙酯；异丁烯酸乙酯', '外观与性状：无色液体，易挥发, 有刺激性。\r\n熔点(℃)：-75\r\n相对密度(水=1)：0.91(25℃)\r\n沸点(℃)：118～119\r\n相对密度(空气=1)：3.28\r\n饱和蒸气压(kPa)：2.0(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.94\r\n溶解性：微溶于水、可混溶于醇、醚。\r\n主要用途：用于制备聚合物和共聚物、合成树脂、有机玻璃和涂料等。\r\n主要成分：纯品\r\nCAS号：97-63-2\r\n相对分子质量：114.16\r\n化学类别：97-63-2\r\n燃烧性：易燃\r\n闪点：15\r\n引燃温度：410\r\n爆炸下限：1.8\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：光照易聚合。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：14800mg/kg(大鼠经口)\r\nLC50：15400mg/m3，3小时(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。避光保存。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。中毒表现有烧灼感、咳嗽、喘息、气短、喉炎、头痛、恶心和呕吐。可引起过敏反应。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。在受热、光和紫外线的作用下易发生聚合，粘度逐渐增加，严重时整个容器的单体可全部发生不规则爆发性聚合。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、强碱。', '781', '丙烯酰基化合物', '2277', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (137, '3153-36-4', '61615', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。特别注意眼和呼吸道的防护。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'ethyl 4-chloro-n-butanoate；ethyl 4-chlorobutyrate', 'C6H11ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。收集于密闭容器中作好标记，等待处理。也可以用\0', '4-氯正丁酸乙酯', '外观与性状：无色液体, 有催泪性。\r\n熔点(℃)：-70\r\n相对密度(水=1)：1.08\r\n沸点(℃)：186\r\n相对密度(空气=1)：4.51\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚、丙酮。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：3153-36-4\r\n相对分子质量：150.61\r\n化学类别：3153-36-4\r\n燃烧性：易燃\r\n闪点：51\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性，具催泪性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有催泪性和刺激性。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：受热易分解，燃烧时产生有毒的氯化物气体。\r\n', '氧化剂、还原剂、酸类、碱类。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (138, '97-86-9', '33601', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴直接式防毒面具（半面罩）。必要时，佩戴导管式防毒面具或自给式呼吸器\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'isobutyl methacrylate；methacrylic acid isobutyl e', 'C8H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '甲基丙烯酸异丁酯；异丁烯酸异丁酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.89\r\n沸点(℃)：155\r\n相对密度(空气=1)：3.82\r\n饱和蒸气压(kPa)：2.67(60℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇、醚。\r\n主要用途：作为有机合成的单体, 用于合成树脂、塑料和涂料等。\r\n主要成分：纯品\r\nCAS号：97-86-9\r\n相对分子质量：142.19\r\n化学类别：97-86-9\r\n燃烧性：易燃\r\n闪点：48\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6400～12800mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，在受热、光和紫外线的作用下易发生聚合，粘度逐渐增加，严重时整个容器的单体可全部发生不规则爆发性聚合。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、强碱。', '781', '丙烯酰基化合物', '2283', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (139, '110-83-8', '32022', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'cyclohexene；tetrahydrobenzene', 'C6H10', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散\0', '环己烯；四氢化苯', '外观与性状：无色液体，有特殊刺激性气味。\r\n熔点(℃)：-103.7\r\n相对密度(水=1)：0.81\r\n沸点(℃)：83.0\r\n相对密度(空气=1)：2.8\r\n饱和蒸气压(kPa)：21.33(38℃)\r\n燃烧热(kJ/mol)：3728.1\r\n临界温度(℃)：287.3\r\n临界压力(MPa)：4.35\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、醚。\r\n主要用途：用于有机合成、油类萃取及用作溶剂。\r\n主要成分：纯品\r\nCAS号：110-83-8\r\n相对分子质量：82.15\r\n化学类别：110-83-8\r\n燃烧性：易燃\r\n闪点：<-20\r\n引燃温度：244\r\n爆炸下限：1.2\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有麻醉作用，吸入后引起恶心、呕吐、头痛和神志丧失。对眼和皮肤有刺激性。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂能发生强烈反应, 引起燃烧或爆炸。长期储存, 可生成具有潜在爆炸危险性的过氧化物。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类。', '780', '烯烃', '2256', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (140, '123-30-8', '61720', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻\0', '4-aminophenol；p-aminophenol', 'C6H7NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '4-氨基苯酚；对氨基苯酚', '外观与性状：白色至灰褐色结晶。\r\n熔点(℃)：184(分解)\r\n相对密度(水=1)：\r\n沸点(℃)：150(0.4kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.4(150℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、醇、醚。\r\n主要用途：用于制造染料、药物及塑料固化剂等。\r\n主要成分：纯品\r\nCAS号：123-30-8\r\n相对分子质量：109.12\r\n化学类别：123-30-8\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：375mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具致敏性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入过量的本品粉尘，可引起高铁血红蛋白血症。有致敏作用，能引起支气管哮喘、接触性变应性皮炎。本品不易经皮肤吸收。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '酸类、酰基氯、酸酐、氯仿、强氧化剂。', '742', '酚', '2512', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (141, '108-87-2', '32012', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。灌装\0', 'methylcyclohexane', 'C7H14', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '甲基环己烷；六氢化甲苯', '外观与性状：无色液体。\r\n熔点(℃)：-126.4\r\n相对密度(水=1)：0.79\r\n沸点(℃)：100.3\r\n相对密度(空气=1)：3.39\r\n饱和蒸气压(kPa)：5.33(22℃)\r\n燃烧热(kJ/mol)：4563.7\r\n临界温度(℃)：299.1\r\n临界压力(MPa)：3.48\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、丙酮、苯、石油醚、四氯化碳、等\r\n主要用途：用作溶剂、色谱分析标准物质，及作为校正温度计的标准，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：108-87-2\r\n相对分子质量：98.18\r\n化学类别：108-87-2\r\n燃烧性：易燃\r\n闪点：-4\r\n引燃温度：250\r\n爆炸下限：1.2\r\n爆炸上限：6.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2250mg/kg(小鼠经口)\r\nLC50：41500mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：皮肤接触可引起发红、干燥皲裂、溃疡等。至今无中毒报道。动物实验本品毒性类似环己烷，但麻醉作用比环己烷强。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂能发生强烈反应, 引起燃烧或爆炸。在火场中，受热的容器有爆炸危险。高速冲击、流动、激荡后可因产生静电火花放电引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '2296', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (142, '10118-76-0', '51049', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要轻\0', 'calcium permanganate', 'Ca(MnO4)2.5H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '过锰酸钙；高锰酸钙', '外观与性状：紫色结晶。\r\n熔点(℃)：分解\r\n相对密度(水=1)：2.4\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于液氨。\r\n主要用途：用于纺织工业及水的消毒。\r\n主要成分：纯品\r\nCAS号：10118-76-0\r\n相对分子质量：368.03\r\n化学类别：10118-76-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化钙、氧化锰。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：。\r\n危险特性：强氧化剂。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。遇硫酸、铵盐或过氧化氢能发生爆炸。遇甘油、乙醇能引起自燃。\r\n', '易燃或可燃物、强还原剂、磷、硫、活性金属粉末。', '798', '高锰酸盐', '1456', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (143, '10101-50-5', '51047', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要轻装\0', 'sodium permanganate', 'NaMnO4.3H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集于密闭容器中作好标记，等待处理。大量泄漏：用塑料布、帆布覆盖。然后收集回收或\0', '过锰酸钠；高锰酸钠', '外观与性状：紫色到红紫色结晶或粉末，易潮解。\r\n熔点(℃)：170(分解)\r\n相对密度(水=1)：2.47\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、液氨。\r\n主要用途：用作氧化剂、杀菌剂、解毒剂，也可作高锰酸钾的代用品。\r\n主要成分：含量: 15～17％的水溶液。\r\nCAS号：10101-50-5\r\n相对分子质量：195.97\r\n化学类别：10101-50-5\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化锰。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须密封，防止受潮。应与易燃物或可燃物、还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有强烈刺激性。高浓度接触严重损害粘膜、上呼吸道、眼睛和皮肤。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐等。\r\n危险特性：强氧化剂。遇硫酸、铵盐或过氧化氢能发生爆炸。遇甘油、乙醇能引起自燃。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。\r\n', '强还原剂、活性金属粉末、易燃或可燃物、硫、磷。', '798', '高锰酸盐', '1503', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (144, '1304-29-6', '51008', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、醇类、活性金属粉末、接触。搬运时要轻装轻卸\0', 'barium peroxide；barium dioxide', 'BaO2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：避免扬尘，收集收集于密闭容器中作好标记，等待处理。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所\0', '过氧化钡；二氧化钡', '外观与性状：白色或灰白色粉末。\r\n熔点(℃)：450\r\n相对密度(水=1)：4.96\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于乙醇、乙醚、丙酮。\r\n主要用途：用于钡盐或过氧化氢的制备，用作氧化剂、漂白剂、媒染剂、消毒剂等。\r\n主要成分：含量≥90.0％。\r\nCAS号：1304-29-6\r\n相对分子质量：169.36\r\n化学类别：1304-29-6\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化钡。\r\n急性毒性：LD50：50mg/kg(小鼠皮下)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装密封。注意防潮和雨淋。应与还原剂、酸类、醇类、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：口服后急性中毒表现为恶心、呕吐、腹痛、腹泻、脉缓、进行性肌麻痹、心律紊乱、血钾明显降低等。可致死。本品粉尘对呼吸道有刺激性。眼及皮肤接触有强烈刺激性，甚至造成灼伤。慢性影响：长期接触钡化合物的工人，可有无力、气促、流涎、口腔粘膜肿胀糜烂、 鼻炎、结膜炎、腹\r\n危险特性：强氧化剂。特别是在少量水的润湿下，与可燃物的混合物在轻微的碰撞或摩擦下会燃烧。遇低级醇和水起化学反应而分解。急剧加热时可发生爆炸。\r\n', '强还原剂、水、酸类、易燃或可燃物、醇类、二氧化碳、活性金属粉末。', '791', '无机过氧化物', '1449', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (145, '1313-60-6', '51002', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作时不得进食、饮水或吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、醇类、活性金属粉末、接触。尤其要注意避免与\0', 'sodium peroxide；sodium dioxide', 'Na2O2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集于密闭容器中作好标记，等待处理。大量泄漏：用塑料布、帆布覆盖。然后收集回收或\0', '过氧化钠；二氧化钠', '外观与性状：米黄色粉末或颗粒，加热则变为黄色，有吸湿性。\r\n熔点(℃)：460(分解)\r\n相对密度(水=1)：2.80\r\n沸点(℃)：657(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用于医药、印染、漂白及用作分析试剂等。\r\n主要成分：工业级 有效氧含量≥35.5％;氧化钙为3.5±0.5％。\r\nCAS号：1313-60-6\r\n相对分子质量：77.99\r\n化学类别：1313-60-6\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧气、氧化钠。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过35℃，相对湿度不超过75％。包装密封。注意防潮和雨淋。应与还原剂、酸类、醇类、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品粉尘刺激眼和呼吸道，腐蚀鼻中隔；皮肤直接接触可引起灼伤；误服可造成消化道灼伤。\r\n危险特性：强氧化剂。能与可燃物、有机物或易氧化物质形成爆炸性混合物，经摩擦和与少量水接触可导致燃烧或爆炸。与硫磺、酸性腐蚀液体接触时，能发生燃烧或爆炸。遇潮气、酸类会分解并放出氧气而助燃。急剧加热时可发生爆炸。具有较强的腐蚀性。\r\n', '强还原剂、水、酸类、易燃或可燃物、醇类、二氧化碳、活性金属粉末。', '791', '无机过氧化物', '1504', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (146, '17014-71-0', '51003', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。避免与还原剂、酸类、醇类、活性金属粉末、接触。尤其要注意避免与水接触。搬运时\0', 'potassium peroxide；potassium dioxide', 'K2O2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集于密闭容器中作好标记，等待处理。大量泄漏：收集回收或运至废物处理场所处置。', '过氧化钾；二氧化钾', '外观与性状：黄色无定形块状物，易潮解。\r\n熔点(℃)：490(分解)\r\n相对密度(水=1)：3.5\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于乙醇。\r\n主要用途：用作氧化剂、漂白剂、氧发生剂。\r\n主要成分：工业级 有效氧含量≥31％。\r\nCAS号：17014-71-0\r\n相对分子质量：110.19\r\n化学类别：17014-71-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化钾。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。相对湿度保持在75％以下。库温不超过35℃，相对湿度不超过75％。包装密封。注意防潮和雨淋。应与还原剂、酸类、醇类、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：对局部有刺激和腐蚀性。刺激眼和呼吸道，腐蚀鼻中隔；皮肤直接接触可引起灼伤；误服可造成消化道灼伤。\r\n危险特性：强氧化剂。能与可燃物、有机物或易氧化物质形成爆炸性混合物，经摩擦和与少量水接触可导致燃烧或爆炸。与硫磺、酸性腐蚀液体接触时，能发生燃烧或爆炸。遇潮气、酸类会分解并放出氧气而助燃。急剧加热时可发生爆炸。具有较强的腐蚀性。\r\n', '强还原剂、水、酸类、易燃或可燃物、醇类、二氧化碳、活性金属粉末。', '791', '无机过氧化物', '1491', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (147, '13477-00-4', '51035', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、醇类、接触。搬运时要轻\0', 'barium chlorate', 'Ba(ClO3)2.H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。收集回收或运至废\0', '氯酸钡', '外观与性状：无色棱形结晶或白色粉末。\r\n熔点(℃)：414(无水)\r\n相对密度(水=1)：3.18\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于乙醇。\r\n主要用途：用作分析试剂，也用于烟花和炸药的制造。\r\n主要成分：纯品\r\nCAS号：13477-00-4\r\n相对分子质量：322.29\r\n化学类别：13477-00-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化物、氧化钡。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、酸类、醇类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：属可溶性钡盐，有较高毒性。吸入后刺激上呼吸道。眼和皮肤接触有刺激性。口服可引起腹痛、恶心、呕吐、腹泻、脉缓、面色苍白、紫绀、呼吸困难、流涎、惊厥、昏迷、胃肠出血、进行性肌麻痹、心律紊乱等。可致死。慢性影响：长期接触钡化合物的工人，可有无力、气促、流涎、口?\n危险特性：强氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。与硫酸接触容易发生爆炸。急剧加热时可发生爆炸。\r\n', '强还原剂、易燃或可燃物、强酸、醇类、硫、磷、铝、镁', '764', '卤素含氧酸盐', '1445', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (148, '3811-04-9', '51031', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、醇类、接触。搬运时要\0', 'potassium chlorate', 'KClO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '氯酸钾；白药粉', '外观与性状：无色片状结晶或白色颗粒粉末，味咸而凉。\r\n熔点(℃)：368.4\r\n相对密度(水=1)：2.32\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于醇、甘油。\r\n主要用途：用于火柴、烟花、炸药的制造，以及合成印染、医药，也用作分析试剂。\r\n主要成分：含量:工业级 一级≥99.5％;二级≥99.2％。\r\nCAS号：3811-04-9\r\n相对分子质量：122.55\r\n化学类别：3811-04-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化物、氧化钾。\r\n急性毒性：LD50：1870mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与易燃物或可燃物、还原剂、酸类、醇类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对人的致死量约10ｇ。口服急性中毒表现为高铁血红蛋白血症，胃肠炎，肝肾损害，甚至窒息。粉尘对呼吸道有刺激性。\r\n危险特性：强氧化剂。常温下稳定，在400℃ 以上则分解并放出氧气。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。急剧加热时可发生爆炸。\r\n', '强还原剂、易燃或可燃物、醇类、强酸、硫、磷、铝、镁', '764', '卤素含氧酸盐', '1485', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (149, '7775-09-9', '51030', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、醇类、接触。搬运时要轻装轻\0', 'sodium chlorate', 'NaClO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '氯酸钠；氯酸碱', '外观与性状：无色无臭结晶，味咸而凉，有潮解性。\r\n熔点(℃)：248～261\r\n相对密度(水=1)：2.49\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、微溶于乙醇。\r\n主要用途：用作氧化剂，及制氯酸盐、除草剂、医药品等，也用于冶金矿石处理。\r\n主要成分：含量:工业级 一级≥99.0％;二级≥98.5％。\r\nCAS号：7775-09-9\r\n相对分子质量：106.45\r\n化学类别：7775-09-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧气、氯化物、氧化钠。\r\n急性毒性：LD50：1200mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、醇类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品粉尘对呼吸道、眼及皮肤有刺激性。口服急性中毒，表现为高铁血红蛋白血症，胃肠炎，肝肾损伤，甚至发生窒息。\r\n危险特性：强氧化剂。受强热或与强酸接触时即发生爆炸。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。急剧加热时可发生爆炸。\r\n', '强还原剂、易燃或可燃物、醇类、强酸、硫、磷、铝。', '764', '卤素含氧酸盐', '1495', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (150, '10192-29-7', '51029', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。禁止\0', 'ammonium chlorate', 'NH4ClO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '氯酸铵', '外观与性状：白色结晶或块状。\r\n熔点(℃)：102(爆炸)\r\n相对密度(水=1)：1.8\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于醇。\r\n主要用途：用作氧化剂、试剂。\r\n主要成分：含量: 10％。\r\nCAS号：10192-29-7\r\n相对分子质量：101.49\r\n化学类别：10192-29-7\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：氮氧化物、氯化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与易燃物或可燃物、还原剂、酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃。\r\n侵入途径：吸入、食入。\r\n健康危害：口服急性中毒，表现为高铁血红蛋白血症，胃肠炎，肝肾损伤，甚至窒息。\r\n危险特性：强氧化剂。不稳定，在常温下有时也会发生自燃爆炸，加热至100℃ 以上时能爆炸分解。遇有机物等易于自燃。常因撞击、摩擦、加热及氧化反应时发生爆炸。\r\n', '强还原剂、易燃或可燃物、强酸、硫、磷、硫酸。', '764', '卤素含氧酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (151, '10326-21-3', '51032', '监测方法：火焰原子吸收光谱法；达旦黄比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止\0', 'magnesium chlorate', 'Mg(ClO3)2.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运\0', '氯酸镁', '外观与性状：白色结晶或粉末，味苦，有潮解性。\r\n熔点(℃)：35\r\n相对密度(水=1)：1.80\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于乙醇。\r\n主要用途：用于医药、干燥剂及脱叶剂。\r\n主要成分：含量:工业级≥40％; 试剂级(特定)≥40％。\r\nCAS号：10326-21-3\r\n相对分子质量：299.33\r\n化学类别：10326-21-3\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化物。\r\n急性毒性：LD50：6438mg/kg(大鼠经口)；5235mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对呼吸道有刺激性；为高铁血红蛋白形成剂。接触后出现头痛、头昏、虚弱；高浓度可致呼吸紊乱、虚脱甚至死亡。眼和皮肤接触有刺激性，可致灼伤。\r\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。\r\n', '易燃或可燃物、强还原剂、硫、磷。', '764', '卤素含氧酸盐', '2723', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (152, '1333-82-0', '51519', '监测方法：二苯碳酰二肼比色法；火焰原子吸收光谱法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时\0', 'chromium trioxide；chromic anhydride', 'CrO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。或用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废\0', '三氧化铬；铬酸酐', '外观与性状：暗红色或暗紫色斜方结晶，易潮解。\r\n熔点(℃)：196\r\n相对密度(水=1)：2.70\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、硫酸、硝酸。\r\n主要用途：用于电镀工业、医药工业、印刷工业、鞣革和织物媒染。\r\n主要成分：含量:工业级 一级≥99.5％。\r\nCAS号：1333-82-0\r\n相对分子质量：100.01\r\n化学类别：1333-82-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：可能产生有害的毒性烟雾。\r\n急性毒性：LD50：80mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人和动物均有充分证据，人类致癌物。\r\n', '储存于阴凉、干燥、通风良好的库房。库温不超过35℃，相对湿度不超过75％。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒，为致癌物，具腐蚀性、刺激性，可致人体灼伤，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒：吸入后可引起急性呼吸道刺激症状、鼻出血、声音嘶哑、鼻粘膜萎缩，有时出现哮喘和紫绀。重者可发生化学性肺炎。口服可刺激和腐蚀消化道，引起恶心、呕吐、腹痛、血便等；重者出现呼吸困难、紫绀、休克、肝损害及急性肾功能衰竭等。慢性影响：有接触性皮炎、铬溃疡?\n危险特性：强氧化剂。与易燃物（如苯）和可燃物（如糖、纤维素等）接触会发生剧烈反应，甚至引起燃烧。与还原性物质如镁粉、铝粉、硫、磷等混合后, 经摩擦或撞击, 能引起燃烧或爆炸。具有较强的腐蚀性。\r\n', '易燃或可燃物、强还原剂、活性金属粉末、硫、磷。', '750', '金属氧化物', '1463', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (153, '7631-99-4', '51055', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、酸类、接\0', 'sodium nitrate', 'NaNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸钠；智利硝', '外观与性状：无色透明或白微带黄色的菱形结晶，味微苦，易潮解。\r\n熔点(℃)：306.8\r\n相对密度(水=1)：2.26\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、液氨、微溶于乙醇、甘油。\r\n主要用途：用于搪瓷、玻璃业、染料业、医药，农业上用作肥料。\r\n主要成分：含量:工业级  一级≥99.2％;二级≥98.3％。\r\nCAS号：7631-99-4\r\n相对分子质量：85.01\r\n化学类别：7631-99-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：3236mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与还原剂、活性金属粉末、酸类、易燃物或可燃物、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对皮肤、粘膜有刺激性。大量口服中毒时，患者剧烈腹痛、呕吐、血便、休克、全身抽搐、昏迷，甚至死亡。\r\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与易氧化物、硫磺、亚硫酸氢钠、还原剂、强酸接触能引起燃烧或爆炸。燃烧分解时, 放出有毒的氮氧化物气体。受高热分解，产生有毒的氮氧化物。\r\n', '强还原剂、活性金属粉末、强酸、易燃或可燃物、铝。', '793', '硝酸盐', '1498', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (154, '10022-31-8', '51060', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、碱类、接触。搬运时要\0', 'barium nitrate', 'Ba(NO3)2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸钡', '外观与性状：无色或白色有光泽的立方结晶，微具吸湿性。\r\n熔点(℃)：592\r\n相对密度(水=1)：3.24\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、浓硫酸、不溶于醇、浓硝酸。\r\n主要用途：用于烟火、搪瓷、杀虫剂、制造钡盐等。\r\n主要成分：含量:工业级 一级≥99.0％;二级≥98.5％。\r\nCAS号：10022-31-8\r\n相对分子质量：261.34\r\n化学类别：10022-31-8\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒。\r\n侵入途径：吸入、食入。\r\n健康危害：误服后表现为恶心、呕吐、腹痛、腹泻、脉缓、头痛、眩晕等。严重中毒出现进行性肌麻痹、心律紊乱、血压降低、血钾明显降低等。可死于心律紊乱和呼吸肌麻痹。肾脏可能受损。大量吸入本品粉尘亦可引起中毒，但消化道反应较轻。长期接触可致口腔炎、鼻炎、结膜炎、腹泻、心动过?\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '酸类、碱、酸酐、易燃或可燃物、强还原剂。', '793', '硝酸盐', '1446', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (155, '7757-79-1', '51056', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、活性金属粉末、接触。搬运\0', 'potassium nitrate', 'KNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '硝酸钾；火硝', '外观与性状：无色透明斜方或三方晶系颗粒或白色粉末。\r\n熔点(℃)：334\r\n相对密度(水=1)：2.11\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、不溶于无水乙醇、乙醚。\r\n主要用途：用于制造烟火、火药、火柴、医药，以及玻璃工业。\r\n主要成分：含量:工业级 一级≥99.5％;二级≥99.0％;三级≥98％。\r\nCAS号：7757-79-1\r\n相对分子质量：101.10\r\n化学类别：7757-79-1\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：3750mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与还原剂、酸类、易燃物或可燃物、活性金属粉末、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品粉尘对呼吸道有刺激性，高浓度吸入可引起肺水肿。大量接触可引起高铁血红蛋白血症，影响血液携氧能力，出现头痛、头晕、紫绀、恶心、呕吐。重者引起呼吸紊乱、虚脱，甚至死亡。口服引起剧烈腹痛、呕吐、血便、休克、全身抽搐、昏迷，甚至死亡。对皮肤和眼睛有强烈刺?\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。燃烧分解时, 放出有毒的氮氧化物气体。受热分解，放出氧气。\r\n', '强还原剂、强酸、易燃或可燃物、活性金属粉末。', '793', '硝酸盐', '1486', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (156, '13477-34-4', '51057', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器\0', 'calcium nitrate；lime nitrate', 'Ca(NO3)2.4H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处\0', '硝酸钙；钙硝石', '外观与性状：无色透明单斜结晶或粉末。\r\n熔点(℃)：45\r\n相对密度(水=1)：1.9\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、液氨、丙酮、醇、乙醇、不溶于浓硝酸。\r\n主要用途：用于制造烟火、炸药、火柴、肥料等。\r\n主要成分：含量≥99.0％。\r\nCAS号：13477-34-4\r\n相对分子质量：236.15\r\n化学类别：13477-34-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：3900mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与还原剂、酸类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品粉尘，对鼻、喉及呼吸道有刺激性，引起咳嗽及胸部不适等。对眼有刺激性。长期反复接触粉尘对皮肤有刺激性。\r\n危险特性：强氧化剂。受热分解，放出氧气。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。燃烧分解时, 放出有毒的氮氧化物气体。受高热分解，产生有毒的氮氧化物。\r\n', '强还原剂、强酸、磷、铝、硫。', '793', '硝酸盐', '1454', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (157, NULL, '51522', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。必要时，佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要轻装轻\0', 'ferric nitrate', 'Fe(NO3)3.9H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：小心扫起，收集于密闭容器中做好标记，待处理。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铁；硝酸高铁', '外观与性状：无色或淡紫色的单斜结晶，易潮解。\r\n熔点(℃)：47.2\r\n相对密度(水=1)：1.68\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇、丙酮。\r\n主要用途：用作媒染剂、医药、分析试剂、催化剂等。\r\n主要成分：含量: 分析纯≥13.6％。\r\nCAS号：\r\n相对分子质量：404.02\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：3250mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入本品粉尘对呼吸道有刺激性。粉尘对眼有强烈刺激和腐蚀作用。皮肤接触其浓水溶液或粉尘可造成灼伤。对消化道有腐蚀性，大量口服引起呕吐、头痛、头晕、紫绀、休克和惊厥，重者可致死。可引起高铁血红蛋白血症。大量铁在体内蓄积可引起胃痛、恶心、便秘等。\r\n危险特性：无机氧化剂。与可燃物的混合物易于着火，并会猛烈燃烧。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。高温时分解，释出剧毒的氮氧化物气体。\r\n', '易燃或可燃物、强还原剂、活性金属粉末、硫、磷。', '793', '硝酸盐', '1466', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (158, '10196-18-6', '51062', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全护目境。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全护目境，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要轻装轻\0', 'zinc nitrate；nitric acid zinc salt,hexahydrate', 'Zn(NO3)2.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸锌', '外观与性状：无色结晶，易潮解。\r\n熔点(℃)：36.4\r\n相对密度(水=1)：2.07\r\n沸点(℃)：105～131(失去6H2O)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于乙醇。\r\n主要用途：用于酸化催化剂、乳胶凝结剂、树脂加工催化剂、印染媒染剂、机器零件镀锌、配制钢铁磷化剂及化学试剂等。\r\n主要成分：纯品\r\nCAS号：10196-18-6\r\n相对分子质量：297.49\r\n化学类别：10196-18-6\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物、氧化锌。\r\n急性毒性：LD50：1190mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有腐蚀性。在高温下分解产生有刺激和剧毒的氮氧化物气体，吸入引起中毒。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与硫、磷、炭末、铜、金属硫化物及有机物接触剧烈反应。受高热分解，产生有毒的氮氧化物。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '1514', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (159, '7784-27-2', '51522', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、活性金属粉末、接触。搬\0', 'aluminium nitrate', 'Al(NO3)3.9H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铝', '外观与性状：无色或白色易潮解的单斜晶体。\r\n熔点(℃)：73.5\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于冷水、乙醇、二硫化碳、不溶于乙酸乙酯、微溶于丙酮。\r\n主要用途：用于有机合成、石油加工的催化剂、纺织工业的媒染剂。\r\n主要成分：纯品\r\nCAS号：7784-27-2\r\n相对分子质量：375.14\r\n化学类别：7784-27-2\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化氮、氧化铝。\r\n急性毒性：LD50：264mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、酸类、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品粉尘对上呼吸道有刺激性，吸入后引起咳嗽和胸部不适。对眼有刺激性。口服引起恶心、呕吐。长期接触对皮肤有刺激性。\r\n危险特性：无机氧化剂。与可燃物的混合物易于着火，并会猛烈燃烧。高温时分解，释出剧毒的氮氧化物气体。\r\n', '强还原剂、强酸、活性金属粉末、易燃或可燃物、硫、磷。', '793', '硝酸盐', '1438', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (160, '6484-52-2', '51069', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、酸类、活性金属粉末、接触。\0', 'ammonium nitrate', 'NH4NO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：小心扫起，收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铵；硝铵', '外观与性状：无色无臭的透明结晶或呈白色的小颗粒，有潮解性。\r\n熔点(℃)：169.6\r\n相对密度(水=1)：1.72\r\n沸点(℃)：210(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇、丙酮、氨水、不溶于乙醚。\r\n主要用途：用作分析试剂、氧化剂、致冷剂、烟火和炸药原料。\r\n主要成分：纯品\r\nCAS号：6484-52-2\r\n相对分子质量：80.05\r\n化学类别：6484-52-2\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：4820mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、酸类、活性金属粉末、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道、眼及皮肤有刺激性。接触后可引起恶心、呕吐、头痛、虚弱、无力和虚脱等。大量接触可引起高铁血红蛋白血症，影响血液的携氧能力，出现紫绀、头痛、头晕、虚脱，甚至死亡。口服引起剧烈腹痛、呕吐、血便、休克、全身抽搐、昏迷，甚至死亡。\r\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与可燃物粉末混合能发生激烈反应而爆炸。受强烈震动也会起爆。急剧加热时可发生爆炸。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。\r\n', '强还原剂、强酸、易燃或可燃物、活性金属粉末。', '793', '硝酸盐', '1942', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (161, '7761-88-8', '51063', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、碱类、醇类、接触。搬运时要轻装轻\0', 'silver nitrate', 'AgNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收\0', '硝酸银', '外观与性状：无色透明的斜方结晶或白色的结晶，有苦味。\r\n熔点(℃)：212\r\n相对密度(水=1)：4.35\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、碱、微溶于乙醚。\r\n主要用途：用于照相乳剂、镀银、制镜、印刷、医药、染毛发等，也用于电子工业。\r\n主要成分：纯品\r\nCAS号：7761-88-8\r\n相对分子质量：169.87\r\n化学类别：7761-88-8\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：50mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。库温不超过30℃，相对湿度不超过80％。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、碱类、醇类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒。\r\n侵入途径：吸入、食入。\r\n健康危害：误服硝酸银可引起剧烈腹痛、呕吐、血便，甚至发生胃肠道穿孔。可造成皮服和眼灼伤。长期接触本品的工人会出现全身性银质沉着症。表现包括：全身皮肤广泛的色素沉着，呈灰蓝黑色或浅石板色；眼部银质沉着造成眼损害；呼吸道银质沉着造成慢性支气管炎等。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。受高热分解，产生有毒的氮氧化物。\r\n', '强还原剂、强碱、氨、醇类、镁易燃或可燃物。', '793', '硝酸盐', '1493', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (162, '13446-18-9', '51522', '监测方法：火焰原子吸收光谱法；达旦黄比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防\0', 'magnesium nitrate', 'Mg(NO3)2.2H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：小心扫起，收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸镁', '外观与性状：白色、易潮解的单斜晶体，有苦味。\r\n熔点(℃)：129.0\r\n相对密度(水=1)：2.02\r\n沸点(℃)：330\r\n相对密度(空气=1)：6.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、溶于乙醇、液氨。\r\n主要用途：主要用于制造烟花，也用作化学试剂。\r\n主要成分：含量:分析纯≥99.0％。\r\nCAS号：13446-18-9\r\n相对分子质量：184.37\r\n化学类别：13446-18-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：5440mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品粉尘对上呼吸道有刺激性，引起咳嗽和气短。刺激眼睛和皮肤，引起红肿和疼痛。大量口服出现腹痛、腹泻、呕吐、紫绀、血压下降、眩晕、惊厥和虚脱。\r\n危险特性：强氧化剂。在火场中能助长任何燃烧物的火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '强还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '1474', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (163, '10099-74-8', '51065', '监测方法：双硫腙比色法；火焰原子吸收光谱法；石墨炉原子吸收光谱法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，\0', 'lead nitrate', 'Pb(NO3)2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铅', '外观与性状：白色立方或单斜晶体，硬而发亮。\r\n熔点(℃)：470(分解)\r\n相对密度(水=1)：4.53\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、液氨、微溶于乙醇。\r\n主要用途：用于铅盐、媒染剂、烟花等的制造。\r\n主要成分：纯品\r\nCAS号：10099-74-8\r\n相对分子质量：331.23\r\n化学类别：10099-74-8\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：3613mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物不明确。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：铅及其化合物损害造血、神经、消化系统及肾脏损害。职业中毒主要为慢性。神经系统主要表现为神经衰弱综合征、周围神经病（以运动功能受累较明显），重者出现铅中毒性脑病。消化系统表现有齿龈铅线、食欲不振、恶心、腹胀、腹泻或便秘；腹绞痛见于中度及重度中毒病例。造血系?\n危险特性：无机氧化剂。遇易氧化物立即猛烈反应，着火爆炸。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。受高热分解，产生有毒的氮氧化物。\r\n', '强还原剂、活性金属粉末、易燃或可燃物。', '793', '硝酸盐', '1469', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (164, '20694-39-7', '51522', '监测方法：磷酸－高碘酸钾比色法；火焰原子吸收光谱法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（半面罩）；可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸\0', 'manganous nitrate；manganese nitrate', 'Mn(NO3)2.4H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。或用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回\0', '硝酸锰；硝酸亚锰', '外观与性状：粉红色结晶，易潮解。\r\n熔点(℃)：25.8\r\n相对密度(水=1)：1.82\r\n沸点(℃)：129.4\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、溶于乙醇。\r\n主要用途：用作中间体、催化剂及制造二氧化锰，并用作陶瓷着色剂、金属磷化剂、分析试剂等。\r\n主要成分：纯品\r\nCAS号：20694-39-7\r\n相对分子质量：251.01\r\n化学类别：20694-39-7\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。对眼睛、皮肤、粘膜和上呼吸道有刺激性。可引起呼吸道炎症和肺炎。\r\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '2724', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (165, '108-09-8', '32176', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器或空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1,3-dimethylbutylamine；2-amino-4-methylpentane', 'C6H15N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '1,3-二甲基丁胺；2-氨基-4-甲基戊烷', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.75\r\n沸点(℃)：106～109\r\n相对密度(空气=1)：3.5\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：108-09-8\r\n相对分子质量：101.19\r\n化学类别：108-09-8\r\n燃烧性：易燃\r\n闪点：12\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：470mg/kg(大鼠经口)；600mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\r\n健康危害：吸入、口服或经皮吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性，吸入后可因喉、支气管的痉挛、炎症，化学性肺炎或肺水肿而致死。长时间接触可引起强烈刺激或灼伤。\r\n危险特性：易燃，遇明火、高热易燃。与氧化剂接触发生强烈反应, 甚至引起燃烧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、酰基氯、酸酐、二氧化碳、强氧化剂。', '762', '脂肪胺', '2379\r', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (166, '112-07-2', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '2-butoxyethyl acetate；ethylene glycol monobutyl e', 'C8H16O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后\0', '醋酸-2-丁氧基乙酯', '外观与性状：无色液体, 有特臭。\r\n熔点(℃)：-63\r\n相对密度(水=1)：0.94\r\n沸点(℃)：192\r\n相对密度(空气=1)：5.5\r\n饱和蒸气压(kPa)：0.04(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于烃类、多数有机溶剂。\r\n主要用途：用作油漆涂料的溶剂, 也作为织物、皮革、印刷染色溶剂等。\r\n主要成分：纯品\r\nCAS号：112-07-2\r\n相对分子质量：160.22\r\n化学类别：112-07-2\r\n燃烧性：可燃\r\n闪点：87.8\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：7460mg/kg(大鼠经口)；1560mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤有刺激作用，其蒸气或雾对粘膜有刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', NULL, '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (167, '60-23-1', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', '2-aminoethanethiol；becaptan', 'C2H7NS', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '巯乙胺；半胱胺', '外观与性状：白色结晶, 有不适气味。\r\n熔点(℃)：95-97\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于醇。\r\n主要用途：用于辐射病的治疗和防护, 并用于有机合成。\r\n主要成分：纯品\r\nCAS号：60-23-1\r\n相对分子质量：77.15\r\n化学类别：60-23-1\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、硫化物、氧化硫。\r\n急性毒性：LD50：630mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入、摄入后对身体有害。可能有刺激作用，接触后引起头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、水。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (168, '7789-33-5', NULL, '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与水接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残\0', 'iodine bromide', 'IBr', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。用砂土、蛭石或其它惰性材料吸收。收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收或运至废物处理场所处置。', '溴化碘', '外观与性状：黑褐色晶体。\r\n熔点(℃)：36\r\n相对密度(水=1)：4.42\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：7789-33-5\r\n相对分子质量：206.81\r\n化学类别：7789-33-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气、光照。\r\n燃烧(分解)产物：溴化氢、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有强烈刺激作用。\r\n危险特性：受热或遇水分解放热, 放出有毒的腐蚀性烟气。\r\n', '醇类、水、潮湿空气、钾、钠、磷、等。', '741', '卤素与卤间化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (169, '107-25-5', '21042', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免\0', 'methyl vinyl ether', 'C3H6O', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。喷雾状水稀释。漏气容器要妥善\0', '乙烯基甲基醚', '外观与性状：无色有香味的气体。\r\n熔点(℃)：-122.0\r\n相对密度(水=1)：\r\n沸点(℃)：5.5\r\n相对密度(空气=1)：1.99\r\n饱和蒸气压(kPa)：174.38/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用于有机合成及医药。\r\n主要成分：纯品\r\nCAS号：107-25-5\r\n相对分子质量：58.08\r\n化学类别：107-25-5\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：2.6\r\n爆炸上限：39.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、卤素、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，吸入有害。\r\n侵入途径：吸入。\r\n健康危害：吸入对身体有害，能引起快速的窒息。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '酸类、强氧化剂、卤素。', '770', '醚', '1087', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (170, '7803-62-5', '21050', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免\0', 'silane；silicon tetrahydride', 'SiH4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。喷雾状水稀释。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器要妥善处理\0', '甲硅烷；四氢化硅', '外观与性状：无色气体，有恶臭。\r\n熔点(℃)：-185\r\n相对密度(水=1)：0.68/-182℃\r\n沸点(℃)：-112\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、四氯化碳。\r\n主要用途：用作固态电器、布漆。\r\n主要成分：纯品\r\nCAS号：7803-62-5\r\n相对分子质量：32.12\r\n化学类别：7803-62-5\r\n燃烧性：易燃\r\n闪点：<-50\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、潮湿空气。\r\n燃烧(分解)产物：氧化硅、氢气。\r\n急性毒性：LD50：\r\nLC50：9600ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。钢瓶温度不应超过52℃。保持容器密封。应与氧化剂、碱类、卤素、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入。\r\n健康危害：吸入甲硅烷蒸气后，引起头痛、头晕、发热、恶心、多汗；严重者面色苍白、脉搏微弱、昏迷。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热极易燃烧爆炸。暴露在空气中能自燃。与氟、氯等接触会发生剧烈的化学反应。\r\n', '强氧化剂、氧、碱、卤素。', '760', '硅烷', '2203', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (171, '80-15-9', '52021', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。防止蒸气\0', 'cumene hydroperoxide；isopropylbenzene hydroperoxi', 'C9H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '过氧化羟基异丙苯；过氧化羟基茴香素', '外观与性状：无色至淡黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.05\r\n沸点(℃)：153\r\n相对密度(空气=1)：5.4\r\n饱和蒸气压(kPa)：1.07(100℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于乙醇、丙酮。\r\n主要用途：用作聚合催化剂、交联剂。\r\n主要成分：纯品\r\nCAS号：80-15-9\r\n相对分子质量：152.20\r\n化学类别：80-15-9\r\n燃烧性：易燃\r\n闪点：56\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：380mg/kg(大鼠经口)；500mg/kg(大鼠经皮)\r\nLC50：220ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与易燃物或可燃物、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。禁止震动、\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，有毒，具强刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮吸收后对身体有害。高浓度时，对眼睛、皮肤、粘膜和上呼吸道有强烈刺激作用。接触后可引起烧灼感、咳嗽、喉炎、头痛、恶心和呕吐。\r\n危险特性：易燃，具有强氧化性。遇热、明火或与酸、碱接触剧烈反应会造成燃烧爆炸。与还原剂、促进剂、有机物、可燃物等接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '还原剂、易燃或可燃物、酸类、铜、铅、及其合金。', '768', '有机过氧化物', '2116', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (172, '565-59-3', '32007', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2,3-dimethylpentane', 'C7H16', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。或在\0', '2,3-二甲基戊烷；2-乙基-3-甲基丁烷', '外观与性状：无色液体。\r\n熔点(℃)：-135\r\n相对密度(水=1)：0.69(20℃)\r\n沸点(℃)：89.8\r\n相对密度(空气=1)：3.45\r\n饱和蒸气压(kPa)：5.33(13.9℃)\r\n燃烧热(kJ/mol)：4802.4\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯。\r\n主要用途：用作色谱分析标准物质以及用于有机合成。\r\n主要成分：含量≥99％。\r\nCAS号：565-59-3\r\n相对分子质量：100.21\r\n化学类别：565-59-3\r\n燃烧性：易燃\r\n闪点：<-7\r\n引燃温度：335\r\n爆炸下限：1.1\r\n爆炸上限：6.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：无本品吸入中毒资料。本品属烃类，吸入高浓度烃类化合物蒸气可引起轻度呼吸道刺激、头晕、欣快感、精神错乱、恶心和呼吸困难；极高浓度吸入可致昏迷甚至死亡。液体进入肺部，可能引起吸入性肺炎或肺水肿。高浓度蒸气对眼有轻度刺激性，液体可引起眼部暂时性红肿和疼痛。液体?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂接触发生化学反应或引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、卤素。', '771', '烷烃', '1206', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (173, NULL, '52021', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。防止蒸气泄漏到工作场所空气中\0', 'diisopropylbenzene  hydroperoxide', 'C12H18O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用惰性、潮湿的不燃物料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降低蒸\0', '过氧化氢二异丙苯；过氧化羟基二异丙苯', '外观与性状：无色至淡黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作引发剂、氧化剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：194.26\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：391mg/kg(小鼠)[TDL]\r\nLC50：\r\n致癌性：\r\n', '商品通常稀释后储装。储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、还原剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。禁止震动、撞\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，具强刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：皮肤接触可引起灼伤，对粘膜有强烈刺激作用。\r\n危险特性：易燃，具有强氧化性。遇热、明火或与酸、碱接触剧烈反应会造成燃烧爆炸。与还原剂、促进剂、有机物、可燃物等接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '强还原剂、酸类、碱类、易燃或可燃物、硫、磷、等。', '768', '有机过氧化物', '2171', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (174, '1338-23-4', '52032', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与还原\0', 'methyl ethyl ketone peroxide；MEKP', 'C8H14O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降低\0', '过氧化甲乙酮；过氧化丁酮', '外观与性状：无色透明液体，有特殊臭味。\r\n熔点(℃)：<-20\r\n相对密度(水=1)：1.09\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、烃类、溶于醇、醚、酯。\r\n主要用途：用于树脂制造等。\r\n主要成分：纯品\r\nCAS号：1338-23-4\r\n相对分子质量：174.20\r\n化学类别：1338-23-4\r\n燃烧性：易燃\r\n闪点：50(O.C)\r\n引燃温度：177\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：484mg/kg(大鼠经口)\r\nLC50：200ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。禁止震动、撞击和摩擦。', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，有毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：刺激粘膜，使高铁血红蛋白形成。本品蒸气或雾对呼吸道有强烈刺激性。吸入后可引起头痛、嗜睡、恶心、呕吐等。蒸气对眼有刺激性；液体或雾可造成严重眼损害，甚至可导致失明。皮肤接触可引起灼伤。口服强烈刺激消化道，引起腹痛、恶心、呕吐、头晕、呼吸困难、流涎和抑郁。大?\n危险特性：易燃，遇氧化物、有机物、易燃物、促进剂会剧烈反应、着火或爆炸。遇热源或阳光可引起分解。\r\n', '强还原剂、酸类、碱。', '768', '有机过氧化物', '2550', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (175, '3851-87-4', '52042', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴乳胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。防止蒸气泄漏到工作场所\0', '3,5,5-trimethyl caproyl peroxide', 'C18H34O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '过氧化(双)3,5,5-三甲基己酰；催化剂K', '外观与性状：无色液体, 具有刺激性气味。\r\n熔点(℃)：<-70\r\n相对密度(水=1)：0.89-0.91\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于丙酮、氯仿、等\r\n主要用途：用作乙烯基单体自由基聚合反应的引发剂。\r\n主要成分：纯品\r\nCAS号：3851-87-4\r\n相对分子质量：314.46\r\n化学类别：3851-87-4\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '商品通常稀释后储装。储存于阴凉、通风的库房。远离火种、热源。库温控制在 0℃以下。应与还原剂、酸类、碱类、易燃物或可燃物、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，有毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：未见毒性资料及人体危害资料。\r\n危险特性：易燃，氧化性极强。在常温下剧烈分解。受冲击、摩擦有发生爆炸的危险。与还原剂、促进剂、有机物、易燃物、酸类或胺类物品接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '酸类、碱类、易燃或可燃物、还原剂。', '768', '有机过氧化物', '2128', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (176, '93-59-4', '52055', '监测方法：\r\n工程控制：密闭操作，注意通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、酸类、碱类\0', 'perbenzoic acid；benzoyl hydroperoxide', 'C7H6O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用惰性、潮湿的不燃材料混合吸收。若大量泄漏，与有关技术部门联系，确定清除方法。', '过苯甲酸；过氧化氢苯甲酰', '外观与性状：无色或白色棱柱形结晶体。\r\n熔点(℃)：42\r\n相对密度(水=1)：\r\n沸点(℃)：80~100\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于甲醇、溶于乙醇、乙醚、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：93-59-4\r\n相对分子质量：138.11\r\n化学类别：93-59-4\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，有毒，对环境有危害，对水体和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：。\r\n危险特性：具有强氧化性。遇热源和明火有燃烧爆炸的危险。与还原剂、促进剂、有机物、可燃物等接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '强氧化剂、强还原剂、酸类、碱类。', '795', '有机酸', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (177, NULL, '52058', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。定期体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。避免产生粉尘。避免与还原剂、\0', 'tert-butyl peroxyphthalic acid', 'C12H14O5', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '叔丁基过苯二甲酸；第三丁基过苯二甲酸', '外观与性状：白色结晶固体。\r\n熔点(℃)：96-99\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、稀碱液。\r\n主要用途：用作聚合反应催化剂及氧化剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：238.16\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，具刺激性，对环境有危害，对水体和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤、眼睛及粘膜有刺激作用。\r\n危险特性：在干燥状态下受震动、撞击、高热及遇明火易引起爆炸。与还原剂、促进剂、有机物、可燃物等接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '还原剂、易燃或可燃物、活性金属粉末。', '795', '有机酸', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (178, '614-45-9', '52076', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。防止蒸气泄漏到\0', 'tert-butyl perbenzoate；tert-butyl peroxybenzoate', 'C11H14O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后\0', '叔丁基过苯甲酸酯；过苯甲酸叔丁酯', '外观与性状：无色至微黄色液体, 略有芳香味。\r\n熔点(℃)：8\r\n相对密度(水=1)：1.02\r\n沸点(℃)：112(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.044(50℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用于化学中间体、聚合引发剂。\r\n主要成分：纯品\r\nCAS号：614-45-9\r\n相对分子质量：194.23\r\n化学类别：614-45-9\r\n燃烧性：易燃\r\n闪点：93\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1010mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。禁止震动、撞击和\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤有刺激作用。蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。吸入、摄入或经皮吸收后对身体有害。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。干燥时经震动、撞击会引起爆炸。与还原剂、促进剂、有机物、易燃物、酸类或胺类物品接触会发生剧烈反应，有燃烧爆炸的危险。\r\n', '还原剂、易燃或可燃物。', '749', '羧酸酯', '2890', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (179, '105-64-6', '52086', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与酸类、碱类、接\0', 'diisopropyl peroxydicarbonate', 'C8H14O6', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '过氧化二碳酸二异丙酯', '外观与性状：无色液体，低温时为无色结晶性粉末。\r\n熔点(℃)：8~10\r\n相对密度(水=1)：1.08\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于烃类、醚、酯、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：105-64-6\r\n相对分子质量：206.20\r\n化学类别：105-64-6\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2140mg/kg(大鼠经口)；2025mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '必须用二甲苯等稀释后于 -10℃冰箱中储存。或用透气容器在 -10℃处储存。储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，具强刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：动物实验表明，本品对眼有强烈刺激性。\r\n危险特性：易燃，强氧化剂。在正常环境温度下会爆炸。对热、震动、撞击和摩擦相当敏感, 极易分解发生爆炸。与易燃物、有机物、还原剂、促进剂、酸类接触发生强烈反应而引起燃烧或爆炸。\r\n', '酸类、碱类。', '768', '有机过氧化物', '2133', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (180, '16111-62-9', '52089', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。远离易燃、可燃物。防止蒸气泄漏到\0', '(bis-2-ethylhexyl)peroxy dicarbonate', 'C18H34O6', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '双乙基己基过氧化二碳酸酯', '外观与性状：透明液体, 商品通常是工业纯无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用作乙烯基单体聚合引发剂、不饱和聚酯固化交联剂等。\r\n主要成分：纯品\r\nCAS号：16111-62-9\r\n相对分子质量：346.46\r\n化学类别：16111-62-9\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过15℃。保持容器密封。应与易燃物或可燃物、氧化剂、还原剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。禁止震动、撞击\0', '危险性类别：第5.2类  有机过氧化物\r\n危险性综述：本品易燃，具爆炸性，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼、皮肤、粘膜有刺激作用。\r\n危险特性：易燃，在室温下迅速分解，气体接触空气自燃。受震动或受热易引起爆炸。与易燃物、有机物、还原剂、促进剂、酸类接触发生强烈反应而引起燃烧或爆炸。\r\n', '强氧化剂、强还原剂、强酸、易燃或可燃物。', '768', '有机过氧化物', '2122', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (181, '7446-08-4', '61015', '监测方法：二氨基联苯胺比色法\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留\0', 'selenium dioxide；selenious acid anhydride', 'SeO2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '二氧化硒；亚硒酐', '外观与性状：白色或微红色有光泽的针状结晶粉末，有刺激性气味。\r\n熔点(℃)：340~350\r\n相对密度(水=1)：3.95\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13/157℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、丙酮、苯、乙酸。\r\n主要用途：用作氧化剂、催化剂、试剂等。\r\n主要成分：纯品\r\nCAS号：7446-08-4\r\n相对分子质量：110.96\r\n化学类别：7446-08-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化硒。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过35℃，相对湿度不超过80％。应与易燃物或可燃物、酸类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤、粘膜有较强的刺激性。大量吸入本品蒸气可引起化学性支气管炎、化学性肺炎或肺水肿。进入眼内可引起结膜炎。可引起接触性皮炎和皮肤灼伤。\r\n危险特性：本身不能燃烧。若遇高热，升华产生剧毒的气体。\r\n', '强酸、氨、易燃或可燃物。', '748', '非金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (182, NULL, '61019', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。避免产生粉尘。避免与氧化剂、酸类、碱类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设\0', 'selenium tetrachloride', 'SeCl4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '四氯化硒', '外观与性状：淡黄色结晶，易潮解。\r\n熔点(℃)：305\r\n相对密度(水=1)：3.78\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13/74℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于二硫化碳。\r\n主要用途：用于电子仪器和仪表工业。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：220.79\r\n化学类别：\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化物、氧化硒。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过35℃，相对湿度不超过80％。应与氧化剂、酸类、碱类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：。\r\n危险特性：遇高热分解释出剧毒的气体。能与磷、钾、过氧化钾、过氧化钠剧烈反应。遇水或潮湿空气分解出有腐蚀性和刺激性的气体。\r\n', '强氧化剂、强酸、强碱、磷、钾。', '776', '非金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (183, '108-08-7', '32007', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2,4-dimethylpentane', 'C7H16', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。或在\0', '2,4-二甲基戊烷；二异丙基甲烷', '外观与性状：无色液体。\r\n熔点(℃)：-123.4\r\n相对密度(水=1)：0.67(20℃)\r\n沸点(℃)：80.5(101.3kPa)\r\n相对密度(空气=1)：3.48\r\n饱和蒸气压(kPa)：1.09(21℃)\r\n燃烧热(kJ/mol)：4802.4\r\n临界温度(℃)：247.1\r\n临界压力(MPa)：2.78\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：108-08-7\r\n相对分子质量：100.21\r\n化学类别：108-08-7\r\n燃烧性：易燃\r\n闪点：-12\r\n引燃温度：335\r\n爆炸下限：1.6\r\n爆炸上限：6.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：无本品吸入中毒资料。本品属烃类，吸入高浓度烃类化合物蒸气可引起轻度呼吸道刺激、头晕、欣快感、精神错乱、恶心和呼吸困难；极高浓度吸入可致昏迷甚至死亡。液体进入肺部，可能引起吸入性肺炎或肺水肿。高浓度蒸气对眼有轻度刺激性；液体可引起眼暂时性红肿和疼痛，对皮肤?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂接触发生化学反应或引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、卤素。', '771', '烷烃', '1206', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (184, '10102-45-1', '61023', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。车间应配备急救设备及药品。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要\0', 'thallium nitrate；thallous nitrate', 'TlNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硝酸铊；硝酸亚铊', '外观与性状：白色结晶。\r\n熔点(℃)：206(α型)\r\n相对密度(水=1)：5.55\r\n沸点(℃)：450(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于丙酮、不溶于乙醇。\r\n主要用途：用于烟花和分析试剂, 与高氯酸和氯化亚汞及树脂混和产生绿火, 作海上标记物。\r\n主要成分：纯品\r\nCAS号：10102-45-1\r\n相对分子质量：266.40\r\n化学类别：10102-45-1\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：45mg/kg(犬经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品助燃，高毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒时，表现为胃肠炎、上行性神经麻痹、颅神经损害、中毒性脑病等还可有肝脏损害。慢性中毒主要表现为多发性神经炎和脱发。可有视神经损害。\r\n危险特性：与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。经摩擦、震动或撞击可引起燃烧或爆炸。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '2727', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (185, '1314-12-1', '61023', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。车间应配备急救设备及药品。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容\0', 'thallium monooxide；thallous oxide', 'Tl2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '一氧化铊；氧化亚铊', '外观与性状：黑色粉末。 具有潮解性, 暴露在空气中易氧化。\r\n熔点(℃)：300\r\n相对密度(水=1)：9.52(16℃)\r\n沸点(℃)：1865\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、溶于酸、醇。\r\n主要用途：用作分析试剂, 用于制造光学玻璃及玻璃装饰品。\r\n主要成分：纯品\r\nCAS号：1314-12-1\r\n相对分子质量：424.78\r\n化学类别：1314-12-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：氧化铊。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：为强烈的神经毒物，对肝、肾有损害作用。吸入、摄入可引起急性中毒。表现有恶心、呕吐、腹部绞痛、厌食等症状；上行性神经麻痹、颅神经损害；重症者可发生中毒性脑病，脱发为其特异表现。皮肤出现皮疹，指甲有白色横纹。可有肝、肾损害。慢性中毒：主要症状有脱发、乏力、胃?\n危险特性：遇高热、明火会产生剧毒的蒸气。\r\n', '强氧化剂、强酸、空气。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (186, '20816-12-0', '61026', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残\0', 'osmium tetroxide；osmic anhydride', 'OsO4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '四氧化锇；锇酸酐', '外观与性状：白色或淡黄色结晶，有类似氯的气味。\r\n熔点(℃)：41.0\r\n相对密度(水=1)：4.91\r\n沸点(℃)：130\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.93/20℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、四氯化碳、氨水。\r\n主要用途：用作催化剂、氧化剂、化学试剂，还用于医药和制造白热气灯的纱罩等。\r\n主要成分：纯品\r\nCAS号：20816-12-0\r\n相对分子质量：254.20\r\n化学类别：20816-12-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：可能产生有害的毒性烟雾。\r\n急性毒性：LD50：14mg/kg(大鼠经口)；162mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道及皮肤有强烈刺激作用。可引起严重眼结膜炎、支气管炎、肺炎等，可因肺炎而致死。吸收后可引起肾炎和血尿。对皮肤可引起坏死性皮炎。进入眼内可引起严重眼损害。\r\n危险特性：强氧化剂。蒸气在灼烧时与氢接触会引起爆炸。与有机物接触剧烈反应。\r\n', '强还原剂、易燃或可燃物。', '750', '金属氧化物', '2471', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (187, '12125-08-5', '61027', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与酸类、碱类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急\0', 'ammonium chloroosmate；osmium ammonium chloride', '(NH4)2OsCl6', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '氯锇酸铵；氯化锇铵', '外观与性状：红色粉末或深红色八面形结晶。\r\n熔点(℃)：\r\n相对密度(水=1)：2.92\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醇。\r\n主要用途：用作分析试剂。\r\n主要成分：纯品\r\nCAS号：12125-08-5\r\n相对分子质量：439.62\r\n化学类别：12125-08-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物、氯化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、碱类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入、食入。\r\n健康危害：剧毒。与皮肤接触后可使皮肤呈黑色；受高热后放出有毒气体。\r\n危险特性：强氧化剂。蒸气在灼烧时与氢接触会引起爆炸。与有机物接触剧烈反应。\r\n', '强酸、强碱。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (188, '1314-62-1', '61028', '监测方法：N－肉桂酸－邻－甲苯羟胺分光光度法；N－肉桂酸－邻－甲苯羟胺比色法\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留\0', 'vanadium pentoxide', 'V2O5', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '五氧化二钒；钒酸酐', '外观与性状：橙黄色或红棕色结晶粉末。\r\n熔点(℃)：690\r\n相对密度(水=1)：3.35\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于乙醇、溶于浓酸、碱。\r\n主要用途：广泛用于有机合成工业及硫酸工业中，也用作玻璃搪瓷着色剂，磁性材料。\r\n主要成分：含量: ≥99.0％；硅≤0.15％； 铁≤0.20％； 磷≤0.03％； 硫≤0.01％； 砷≤0.01％；氧化二钠和氧化二钾≤ 1.0％。\r\nCAS号：1314-62-1\r\n相对分子质量：182.00\r\n化学类别：1314-62-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：可能产生有害的毒性烟雾。\r\n急性毒性：LD50：10mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，高毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸系统和皮肤有损害作用。急性中毒：可引起鼻、咽、肺部刺激症状，接触者出现眼烧灼感、流泪、咽痒、干咳、胸闷、全身不适、倦怠等表现，重者出现支气管炎或支气管肺炎。皮肤高浓度接触可致皮炎，剧烈瘙痒。慢性中毒：长期接触可引起慢性支气管炎、肾损害、视力障碍等。\r\n危险特性：不燃。与三氟化氯、锂接触剧烈反应。\r\n', '强酸、易燃或可燃物。', '750', '金属氧化物', '2862', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (189, '10101-83-4', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。避免产生粉尘。避免与还原剂、接触。搬运时轻装轻卸，保持包装完整，防止洒漏。配备泄漏应急处理设备。倒空的\0', 'sodium tellurate；sodium tellurate VI', 'Na2TeO4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '碲酸钠', '外观与性状：白色粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作试剂。\r\n主要成分：纯品\r\nCAS号：10101-83-4\r\n相对分子质量：237.58\r\n化学类别：10101-83-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化钠、氧化碲。\r\n急性毒性：LD50：385mg/kg(大鼠经口)；165mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：热解放出有毒的氧化碲和氧化钠烟雾。\r\n危险特性：受高热分解, 放出有毒的蒸气。\r\n', '强还原剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (190, '353-59-3', NULL, '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。防止气体泄漏到工作场所空气中。避免与碱金属、碱土金属、接触。搬运时戴好钢瓶安全\0', 'monobromomonochlorodifluoromethane；chlorodifluoro', 'CBrClF2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '一溴一氯二氟甲烷；二氟氯溴甲烷', '外观与性状：无色气体。\r\n熔点(℃)：-161\r\n相对密度(水=1)：1.88(21℃)\r\n沸点(℃)：-4\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作灭火剂。\r\n主要成分：纯品\r\nCAS号：353-59-3\r\n相对分子质量：165.36\r\n化学类别：353-59-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢、氯化氢、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与碱金属、碱土金属、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：\r\n危险性综述：本品不燃，有毒，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：热解能放出剧毒的氟、氯、溴离子烟雾。\r\n危险特性：在空气中不发生燃烧爆炸。受高热分解，放出有毒的氟、氯、溴化物的烟气。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '碱金属、碱土金属、活性金属粉末。', '759', '卤代烷', '1974', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (191, '598-92-5', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1-chloro-1-nitroethane', 'C2H4ClNO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '1-氯-1-硝基乙烷', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.26(20℃)\r\n沸点(℃)：127.5\r\n相对密度(空气=1)：3.6\r\n饱和蒸气压(kPa)：1.57(20℃)\r\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇。\r\n主要用途：用于有机合成及消毒和杀虫。\r\n主要成分：纯品\r\nCAS号：598-92-5\r\n相对分子质量：109.5\r\n化学类别：598-92-5\r\n燃烧性：易燃\r\n闪点：56\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氮氧化物。\r\n急性毒性：LD50：620mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：对呼吸道和眼有刺激作用，对皮肤有刺激性。未见人接触本品引起损害的报道。\r\n危险特性：遇明火、高热易燃。受高热分解，产生有毒的氮氧化物和氯化物气体。\r\n', '强氧化剂、强酸、活性金属粉末。', '746', '硝基烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (192, '111-86-4', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸\0', 'octylamine', 'C8H19N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '辛胺', '外观与性状：无色液体。\r\n熔点(℃)：-5~1\r\n相对密度(水=1)：0.78\r\n沸点(℃)：175-177\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于醇、醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-86-4\r\n相对分子质量：129.25\r\n化学类别：111-86-4\r\n燃烧性：可燃\r\n闪点：62\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：100mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入本品蒸气或雾对呼吸道有刺激性。蒸气对眼有刺激性；液体或雾对眼有强烈刺激性，引起眼损害。对皮肤有强烈刺激性。摄入灼伤消化道，引起剧烈腹痛、恶心、呕吐和虚脱，大量摄入可致死。\r\n危险特性：遇明火、高热可燃。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强酸、酰基氯、酸酐。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (193, '13768-86-0', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时轻装轻卸，保持包装完整，防止洒漏。配备泄漏应\0', 'selenium trioxide', 'SeO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '三氧化硒', '外观与性状：微黄色无定形粉末, 易吸潮。\r\n熔点(℃)：120(分解)\r\n相对密度(水=1)：3.6\r\n沸点(℃)：\r\n相对密度(空气=1)：2.78\r\n饱和蒸气压(kPa)：0.17(175℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、易溶于乙醇、不溶于醚、氯仿、四氯化碳。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：13768-86-0\r\n相对分子质量：126.96\r\n化学类别：13768-86-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化硒。\r\n急性毒性：LD50：\r\nLC50：\r\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、还原剂、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有腐蚀性。\r\n危险特性：受高热分解, 放出有毒的蒸气。\r\n', '易燃或可燃物、强还原剂。', '748', '非金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (194, '112-88-9', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1-octadecane', 'C18H36', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '十八烯', '外观与性状：无色液体。\r\n熔点(℃)：17.5\r\n相对密度(水=1)：0.79(20℃)\r\n沸点(℃)：314.2\r\n相对密度(空气=1)：0.71\r\n饱和蒸气压(kPa)：2.0(179℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于热丙酮。\r\r\n主要用途：用于有机合成及用作表面活性剂、气相色谱对比样品。\r\n主要成分：纯品\r\nCAS号：112-88-9\r\n相对分子质量：252.48\r\n化学类别：112-88-9\r\n燃烧性：可燃\r\n闪点：148\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。对眼和皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (195, '13067-93-1', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻卸\0', 'surecide；cyanophenphos', 'C15H14NO2PS', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '苯腈磷；苯腈硫磷', '外观与性状：结晶固体。\r\n熔点(℃)：83\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.0000018(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于酮、芳烃。\r\n主要用途：用作农用杀虫剂。\r\n主要成分：\r\nCAS号：13067-93-1\r\n相对分子质量：303.33\r\n化学类别：13067-93-1\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、硫化氢、氧化硫。\r\n急性毒性：LD50：29mg/kg(大鼠经口)；44mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：\r\n危险性综述：本品可燃，高毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害： 属高毒杀虫剂。 其中毒表现及对胆碱酯酶活性的影响同一般有机磷农摇*\r\n危险特性：遇明火、高热可燃。受高热分解，放出有毒的氮、磷和硫的氧化物烟气。\r\n', '强氧化剂。', '800', '未指定的化学类别', '2769', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (196, '6125-21-9', '33523', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂、\0', '1,3-dinitropropane', 'C3H6N2O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '1,3-二硝基丙烷', '外观与性状：黄色液体, 带有刺激性气味, 性质极不稳定。\r\n熔点(℃)：-21.4\r\n相对密度(水=1)：1.35(26℃)\r\n沸点(℃)：103\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：6125-21-9\r\n相对分子质量：134.1\r\n化学类别：6125-21-9\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤、眼睛、粘膜和上呼吸道有强烈刺激性，吸收进入体内后可引起紫绀。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。强烈震动及受热或遇无机碱类、氧化剂、烃类、胺类及三氯化铝、六甲基苯等均能引起燃烧爆炸。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强还原剂、强酸、强碱、胺类。', '746', '硝基烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (197, '10049-04-4', NULL, '监测方法：酸性紫R比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与还原剂、接触。搬运时要轻装轻卸，防止包\0', 'chlorine dioxide；chlorine oxide', 'ClO2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。喷雾状水稀释。漏气容器要妥善处理，修复、检验\0', '二氧化氯', '外观与性状：黄红色气体, 有刺激性气味。\r\n熔点(℃)：-59\r\n相对密度(水=1)：3.09(11℃)\r\n沸点(℃)：9.9(97.2kPa,爆炸)\r\n相对密度(空气=1)：2.3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作漂白剂、除臭剂、氧化剂等。\r\n主要成分：纯品\r\nCAS号：10049-04-4\r\n相对分子质量：67.45\r\n化学类别：10049-04-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有强烈刺激性。接触后主要引起眼和呼吸道刺激。吸入高浓度可发生肺水肿。能致死。对呼吸道产生严重损伤浓度的本品气体，可能对皮肤有刺激性。皮肤接触或摄入本品的高浓度溶液，可引起强烈刺激和腐蚀。长期接触可导致慢性支气管炎。\r\n危险特性：具有强氧化性。能与许多化学物质发生爆炸性反应。对热、震动、撞击和摩擦相当敏感, 极易分解发生爆炸。\r\n', '还原剂、易燃或可燃物、活性金属粉末。', '748', '非金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (198, '13826-83-0', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与酸类、碱类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄\0', 'ammonium borofluoride；ammonium fluoborate', 'NH4BF4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硼氟化铵', '外观与性状：无色晶体。\r\n熔点(℃)：升华\r\n相对密度(水=1)：1.87(15℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于氨水。\r\n主要用途：用作铸镁，助溶剂, 并用于制电焊条等。\r\n主要成分：纯品\r\nCAS号：13826-83-0\r\n相对分子质量：104.84\r\n化学类别：13826-83-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：\r\n聚合危害：\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氮氧化物、氧化硼、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与酸类、碱类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤和粘膜有刺激性。\r\n危险特性：受热分解, 放出有毒的氮氧化物和氟化物烟气。\r\n', '强酸、强碱、潮湿空气。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (199, '128-37-0', '无资料', '监测方法：4-氨基安替比林分光光度法；溶剂解吸－气相色谱法\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。\0', '2,6-di-tert-butyl-p-cresol', 'C15H24O', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '2,6-二叔丁基对甲酚', '外观与性状：白色结晶。\r\n熔点(℃)：68\r\n相对密度(水=1)：1.05\r\n沸点(℃)：265\r\n相对密度(空气=1)：7.6\r\n饱和蒸气压(kPa)：0.0013(20℃)\r\n燃烧热(kJ/mol)：无资料\r\n临界温度(℃)：无资料\r\n临界压力(MPa)：无资料\r\n辛醇/水分配系数：无资料\r\n溶解性：不溶于水、溶于甲醇、乙醇、苯、石油醚、等\r\n主要用途：用作石油制品、燃料、橡胶、塑料、食品、饲料、药品等的抗氧剂。\r\n主要成分：纯品\r\nCAS号：128-37-0\r\n相对分子质量：220.36\r\n化学类别：128-37-0\r\n燃烧性：可燃\r\n闪点：126.7\r\n引燃温度：470\r\n爆炸下限：无资料\r\n爆炸上限：无资料\r\n最小点火能：无资料\r\n最大爆炸压力：无资料\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：890mg/kg(大鼠经口)\r\nLC50：无资料\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激作用，长时间的接触对眼睛有害并引起头痛、恶心和眩晕。\r\n危险特性：遇明火、高热、或与氧化剂接触能燃烧, 并散发出有毒气体。\r\n', '氧化剂、碱类、酰基氯、酸酐、铜、及其合金。', '742', '酚', '无资料', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (200, '544-00-3', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。定期体检。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'diisoamylamine', 'C10H23N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '二异戊胺；N,N-二(3-甲基丁基)胺', '外观与性状：无色液体。\r\n熔点(℃)：-44\r\n相对密度(水=1)：0.77(20℃)\r\n沸点(℃)：188\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醇、醚、氯仿、微溶于水。\r\n主要用途：用于医药、染料、抗氧剂、乳化剂、防腐剂和橡胶硫化促进剂等的生产。\r\n主要成分：纯品\r\nCAS号：544-00-3\r\n相对分子质量：157.29\r\n化学类别：544-00-3\r\n燃烧性：易燃\r\n闪点：58\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入、食入。\r\n健康危害：误服可发生中毒。中毒后出现头晕、恶心、呕吐、视物不清、瞳孔散大、呼吸困难、面色苍白，继之出现紫绀、躁动和抽搐，终至呼吸麻痹、心跳停止。肝、肾受到损害。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强酸、酰基氯。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (201, '506-78-5', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、酸类、碱类、接触。搬运时要轻装轻卸，防止包装及容\0', 'cyanogen iodide', 'ICN', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '碘化氰', '外观与性状：白色针状晶体。\r\n熔点(℃)：146-147\r\n相对密度(水=1)：2.59\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于甲醇、醚。\r\n主要用途：用作昆虫保存剂。\r\n主要成分：纯品\r\nCAS号：506-78-5\r\n相对分子质量：152.94\r\n化学类别：506-78-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：氧化氮、氰化氢、碘化氢。\r\n急性毒性：LD50：44mg/kg(大鼠皮下)[LD]；23.5mg/kg(兔经口)[LD]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：\r\n危险性综述：本品不燃，高毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入、摄入本品可能致死。对眼睛、皮肤、粘膜和上呼吸道有刺激作用。\r\n危险特性：受高热分解，放出腐蚀性、刺激性的烟雾。\r\n', '强氧化剂、强酸、强碱。', '776', '非金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (202, '13746-66-2', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒\0', 'potassium ferricyanide；potassium ferricyanate', 'C6FeN6.3K', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '铁氰化钾；赤血盐', '外观与性状：红色晶体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.85(17℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于丙酮、微溶于醇。\r\n主要用途：用作化学试剂, 也用于冶金、照相、颜料等行业。\r\n主要成分：纯品\r\nCAS号：13746-66-2\r\n相对分子质量：329.26\r\n化学类别：13746-66-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：氧化氮、氰化氢、氧化钾。\r\n急性毒性：LD50：2970mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体可能有害。可致肾损害。加热或酸作用下可产生氰化氢。\r\n危险特性：受高热分解，放出腐蚀性、刺激性的烟雾。\r\n', '强氧化剂、强酸。', '738', '金属氰化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (203, '78-97-7', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通\0', 'acetaldehyde cyanohydrin；2-hydroxypropionitrile', 'C3H5NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '乳腈；2-羟基丙腈', '外观与性状：无色至淡黄色液体。\r\n熔点(℃)：-40\r\n相对密度(水=1)：0.99\r\n沸点(℃)：183\r\n相对密度(空气=1)：2.45\r\n饱和蒸气压(kPa)：1.33(74℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于丙酮、乙醇、多数有机溶剂。\r\n主要用途：主要用作溶剂和制备丙烯腈、丙烯酸酯和乳酸乙酯。\r\n主要成分：纯品\r\nCAS号：78-97-7\r\n相对分子质量：71.08\r\n化学类别：78-97-7\r\n燃烧性：可燃\r\n闪点：76\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：87mg/kg(大鼠经口)；20mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：如吸入、摄入或经皮肤吸收后可致死。对眼睛、皮肤有刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (204, '110-67-8', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'β-methoxypropionitrile；β-methoxyethyl cyanide', 'C4H7NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', 'β-甲氧基丙腈', '外观与性状：无色液体。\r\n熔点(℃)：-63\r\n相对密度(水=1)：0.93(30℃)\r\n沸点(℃)：160\r\n相对密度(空气=1)：2.9\r\n饱和蒸气压(kPa)：1.33(55℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于乙醇、甲苯、普通溶剂。\r\n主要用途：用作医药甲氧苄氨嘧啶的中间体, 是一种很好的溶剂, 可代替糠醛分离丁二烯。\r\n主要成分：纯品\r\nCAS号：110-67-8\r\n相对分子质量：85.11\r\n化学类别：110-67-8\r\n燃烧性：可燃\r\n闪点：61\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：4390mg/kg(大鼠经口)；3200mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。本品对皮肤有刺激作用。其蒸气和雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸、强碱、水。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (205, '1689-84-5', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免\0', '3,5-dibromo-4-hydroxybenzonitrile；2,6-dibromo-4-c', 'C7H3Br2NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '3,5-二溴-4-羟基苯腈', '外观与性状：灰白色粉末。\r\n熔点(℃)：194-195\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作粮食作物的除草剂。\r\n主要成分：纯品\r\nCAS号：1689-84-5\r\n相对分子质量：276.93\r\n化学类别：1689-84-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、溴化氢。\r\n急性毒性：LD50：110mg/kg(小鼠经口)；190mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。本品对眼睛、粘膜、皮肤和上呼吸道有刺激作用。接触本品工人的尿中硫氰酸盐排出增多。\r\n危险特性：遇明火、高热可燃。受高热分解，放出有毒的氮、溴化物烟气。\r\n', '强氧化剂、强酸。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (206, '638-65-3', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、接触。搬运时要轻装轻卸，防\0', 'octadecanonitrile；Stearonitrile', 'C18H35N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '十八烷腈；硬脂腈', '外观与性状：白色蜡状物质。\r\n熔点(℃)：41\r\n相对密度(水=1)：0.82(41℃)\r\n沸点(℃)：214(1.73kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于乙醇、乙醚。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：638-65-3\r\n相对分子质量：265.49\r\n化学类别：638-65-3\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：小鼠经口可引起一过性的抑制状态，表现为少动、无力；大鼠经口，2g/kg，30次，见白细胞增多症，肝肿大等；大鼠涂皮，未见局部反应及全身中毒迹象。对眼睛有刺激作用。热解可产生有毒的氮氧化物和氰化氢气体。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (207, '646-06-0', '32096', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1,3-dioxolane', 'C3H6O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系\0', '1,3-二氧戊环；乙二醇缩甲醛', '外观与性状：水白色液体。\r\n熔点(℃)：-95\r\n相对密度(水=1)：1.06\r\n沸点(℃)：74\r\n相对密度(空气=1)：2.6\r\n饱和蒸气压(kPa)：9.33(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作低沸点化合物的溶剂，及油脂、蜡、染料及纤维素衍生物的萃取剂。\r\n主要成分：纯品\r\nCAS号：646-06-0\r\n相对分子质量：74.08\r\n化学类别：646-06-0\r\n燃烧性：易燃\r\n闪点：2(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3000mg/kg(大鼠经口)；8480mg/kg(兔经皮)\r\nLC50：20650mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有稳定剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品为麻醉剂，蒸气有刺激作用。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、强氧化剂。', '758', '环氧化合物', '1166', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (208, '6923-52-0', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：避免高浓度吸入。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', 'antimony triacetate', 'C6H9O6Sb', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '三乙酸锑', '外观与性状：白色、有酸味、结晶体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：6923-52-0\r\n相对分子质量：298.89\r\n化学类别：6923-52-0\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化锑。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛有刺激性。职业性中毒可引起气管炎、胃肠炎、头痛、头晕、疲乏、无力等。\r\n危险特性：遇明火、高热可燃。受高热分解，放出腐蚀性、刺激性的烟雾。\r\n', '强氧化剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (209, NULL, NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可能残留\0', 'calcium superphosphate', NULL, NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '过磷酸钙；过磷酸石灰', '外观与性状：灰白色至深灰色（有的带粉红色）粉末, 有酸味。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：可用作基肥、追肥或种肥。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：\r\n化学类别：\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：接触者，少数可能发生皮炎、出现皮疹，烧灼感和瘙痒，面部皮肤水肿，眼灼痛及流泪，停止接触后这些症状很快消失。本品粉尘落入眼内，引起结膜的剧烈刺激，眼脸水肿，角膜混浊，有时甚至角膜穿孔及虹膜脱出。据报道，接触者有前臂骨骼的改变，神经系统功能障碍，嗅阈改变，多?\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (210, '67-63-0', '32064', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂\0', '2-propanol；isopropyl alcohol', 'C3H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '2-丙醇；异丙醇', '外观与性状：无色透明液体，有似乙醇和丙酮混合物的气味。\r\n熔点(℃)：-88.5\r\n相对密度(水=1)：0.79\r\n沸点(℃)：80.3\r\n相对密度(空气=1)：2.07\r\n饱和蒸气压(kPa)：4.40(20℃)\r\n燃烧热(kJ/mol)：1984.7\r\n临界温度(℃)：275.2\r\n临界压力(MPa)：4.76\r\n辛醇/水分配系数：<0.28\r\n溶解性：溶于水、醇、醚、苯、氯仿、等多数有机溶剂。\r\n主要用途：是重要的化工产品和原料。主要用于制药、化妆品、塑料、香料、涂料等。\r\n主要成分：纯品\r\nCAS号：67-63-0\r\n相对分子质量：60.10\r\n化学类别：67-63-0\r\n燃烧性：易燃\r\n闪点：12\r\n引燃温度：399\r\n爆炸下限：2.0\r\n爆炸上限：12.7\r\n最小点火能：0.65\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5045mg/kg(大鼠经口)；12800mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：接触高浓度蒸气出现头痛、倦睡、共济失调以及眼、鼻、喉刺激症状。口服可致恶心、呕吐、腹痛、腹泻、倦睡、昏迷甚至死亡。长期皮肤接触可致皮肤干燥、皲裂。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂接触猛烈反应。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类、酸酐、卤素。', '789', '醇', '1219', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (211, '1592-23-0', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。\0', 'calcium stearate', 'C36H70CaO4', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '硬脂酸钙；十八酸钙', '外观与性状：纯品为白色结晶粉末, 普通品是白色略带黄色的粉末物质。\r\n熔点(℃)：150\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于热乙醇。\r\n主要用途：用作聚氯乙烯等塑料的无毒稳定剂、防水防雨材料的防水剂、油漆的平光剂、润滑油的增厚剂和铅笔芯的润滑剂等。\r\n主要成分：钙含量:6.3￣6.8％; 游离酸≤0.5; 水分≤3 。\r\nCAS号：1592-23-0\r\n相对分子质量：607.03\r\n化学类别：1592-23-0\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：400\r\n爆炸下限：25(g/m3)\r\n爆炸上限：\r\n最小点火能：15\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):690\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化钙。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：大鼠长期吸入本品，可见到支气管周围组织纤维化或支气管扩张等。长期吸入本品粉尘，可能会引起肺部纤维化的尘肺改变。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (212, '25322-68-3', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止烟雾或粉尘泄漏到工作场所空气中。避免与氧化剂、接触。\0', 'poly(ethylene glycol)；carbowax4000', 'H[C2H4O]nOH', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。若是液体，防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑\0', '多乙二醇', '外观与性状：白色结晶或液体, 有轻微特殊气味。\r\n熔点(℃)：50-55\r\n相对密度(水=1)：1.20(20℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醇、不溶于醚。\r\n主要用途：用作气相色谱固定液。\r\n主要成分：纯品\r\nCAS号：25322-68-3\r\n相对分子质量：3400(平均)\r\n化学类别：25322-68-3\r\n燃烧性：可燃\r\n闪点：>246\r\n引燃温度：305\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：33750mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对身体有害, 对眼睛、皮肤有刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (213, NULL, NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作前后不饮酒，用温水洗澡。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，配备泄漏应急处理设备。倒空的容器可能残留有害物。', NULL, NULL, NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '苯三唑十八胺；T406油性剂', '外观与性状：微黄色、蜡状固体。\r\n熔点(℃)：52-60\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：\r\n化学类别：\r\n燃烧性：\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：\r\n聚合危害：\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：\r\n侵入途径：食入。\r\n健康危害：本品经口毒性极低。它是高沸点的化合物，不易挥发，未见到中毒的报道。\r\n危险特性：\r\n', NULL, '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (214, '9002-88-4', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻\0', 'polyethylene', '[C2H4]n', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '高密度聚乙烯', '外观与性状：无臭、无味、无毒性的白色颗粒或粉末。\r\n熔点(℃)：130-145\r\n相对密度(水=1)：0.94-0.95\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于多数有机溶剂，微溶于热甲苯、乙酸、等\r\n主要用途：用于日用品和工业用品, 还可用作中空制品、单丝、延伸带、薄膜、电绝缘制品等。\r\n主要成分：纯品\r\nCAS号：9002-88-4\r\n相对分子质量：\r\n化学类别：9002-88-4\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：450(粉云)\r\n爆炸下限：10(g/m3)\r\n爆炸上限：\r\n最小点火能：30\r\n最大爆炸压力：0.51\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：其热解产物对呼吸道有刺激作用。本身基本无毒。\r\n危险特性：受热分解放出易燃气体能与空气形成爆炸性混合物。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (215, '112-27-6', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'triethylene glycol；triglycol', 'C6H14O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '三乙二醇；三甘醇', '外观与性状：无色粘稠液体, 有吸水性。\r\n熔点(℃)：-7\r\n相对密度(水=1)：1.12(25℃)\r\n沸点(℃)：285\r\n相对密度(空气=1)：5.2\r\n饱和蒸气压(kPa)：0.0013(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于醇、苯、与水混溶、微溶于醚、不溶于石油醚。\r\n主要用途：作为溶剂用于硝化纤维、各种树脂、树胶, 也可用于气相色谱以及有机合成。\r\n主要成分：纯品\r\nCAS号：112-27-6\r\n相对分子质量：150.7\r\n化学类别：112-27-6\r\n燃烧性：可燃\r\n闪点：165\r\n引燃温度：371\r\n爆炸下限：0.9\r\n爆炸上限：9.2\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：17000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼和皮肤无刺激性。无中毒病例报道。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (216, '9003-07-0', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应品\0', 'polypropylene', '[C3H6]n', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '聚丙烯(等规)', '外观与性状：白色、无臭、无味固体。\r\n熔点(℃)：165-170\r\n相对密度(水=1)：0.90-0.91\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：可用作工程塑料, 适用于制电视机、收音机外壳、电器绝缘材料、防腐管道、板材、贮槽等, 也用于编织包装袋、包装薄膜。\r\n主要成分：纯品\r\nCAS号：9003-07-0\r\n相对分子质量：\r\n化学类别：9003-07-0\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：420(粉云)\r\n爆炸下限：20(g/m3)\r\n爆炸上限：\r\n最小点火能：30\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):269\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：本身无毒, 注意不同添加剂的毒性。热解产物酸、醛等对眼、上呼吸道有刺激作用。\r\n危险特性：粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。加热分解产生易燃气体。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (217, '1317-38-0', NULL, '监测方法：火焰原子吸收光谱法；5－Br－PADAP比色法；催化极谱法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与还原剂、碱金属、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容\0', 'copper oxide black；copper monoxide', 'CuO', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '氧化铜', '外观与性状：黑褐色粉末。\r\n熔点(℃)：1026\r\n相对密度(水=1)：6.32(粉末)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于稀酸、不溶于乙醇。\r\n主要用途：制人造丝、陶瓷、釉及搪瓷、电池、石油脱硫剂、杀虫剂，也供制氢、催化剂、绿色玻璃等用。\r\n主要成分：含量: ≥98％；盐酸不溶物≤0.20％；水可溶物≤0.10％；氯化物≤0.20％；硫酸盐≤0.20％。\r\nCAS号：1317-38-0\r\n相对分子质量：79.54\r\n化学类别：1317-38-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化铜。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与还原剂、碱金属、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入大量氧化铜烟雾可引起金属烟热，出现寒战、体温升高，同时可伴有呼吸道刺激症状。长期接触，可见呼吸道及眼结膜刺激、鼻衄、鼻粘膜出血点或溃疡，甚至鼻中隔穿孔以及皮炎，也可出现胃肠道症状。有报道，长期吸入尚可引起肺部纤维组织增生。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强还原剂、铝、碱金属。', '750', '金属氧化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (218, '3322-62-1', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', '9-octadeceneamide；Oleamide', 'C18H35ON', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。小心扫起，若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '油酸酰胺；油酰胺', '外观与性状：白色片状或粉末状固体。\r\n熔点(℃)：72-76\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于酮、酯、乙醇、乙醚、不溶于水。\r\n主要用途：用作聚乙烯、聚丙烯吹塑薄膜滑爽剂、抗静电剂、颜料和染料的分散剂、印刷油墨的添加剂、涂料打字复写的配合剂及纤维油剂等。\r\n主要成分：纯品\r\nCAS号：3322-62-1\r\n相对分子质量：281.5\r\n化学类别：3322-62-1\r\n燃烧性：可燃\r\n闪点：210\r\n引燃温度：235\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：目前未见职业中毒的资料报道。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '767', '酰胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (219, NULL, NULL, '监测方法：\r\n工程控制：密闭操作。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：保持良好的卫生习惯。\r\n', '密闭操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应品种和数量的消防器材及\0', 'barium salt of phosphosulfurized polyisobutylene；', NULL, NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硫磷化聚异丁烯钡盐', '外观与性状：\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：作为内燃机油的辅剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化物、氧化磷。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：毒性很低生产中不致引起急性中毒。\r\n危险特性：受热分解，放出磷、硫的氧化物等毒性气体。\r\n', '强氧化剂。', '794', '金属烃基化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (220, '7757-82-6', NULL, '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：及时换洗工作服。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可能残留\0', 'sodium sulfate,anhydrous', 'Na2SO4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '硫酸钠；无水芒硝', '外观与性状：白色、无臭、有苦味的结晶或粉末, 有吸湿性。\r\n熔点(℃)：884\r\n相对密度(水=1)：2.68\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于乙醇、溶于水、溶于甘油。\r\n主要用途：用于制水玻璃、玻璃、瓷釉、纸浆、致冷混合剂、洗涤剂、干燥剂、染料稀释剂、分析化学试剂、医药品等。\r\n主要成分：纯品\r\nCAS号：7757-82-6\r\n相对分子质量：142.04\r\n化学类别：7757-82-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：硫化物。\r\n急性毒性：LD50：5989mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛和皮肤有刺激作用。基本无毒。\r\n危险特性：未有特殊的燃烧爆炸特性。受高热分解产生有毒的硫化物烟气。\r\n', '强酸、铝、镁', '783', '硫化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (221, '513-38-2', '32048', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意检测毒物。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1-iodo-2-methylpropane；1-iodo-iso-butane', 'C4H9I', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '1-碘-2-甲基丙烷；碘化异丁烷', '外观与性状：无色或微黄色液体，见光变成棕色。\r\n熔点(℃)：-93\r\n相对密度(水=1)：1.5～1.6\r\n沸点(℃)：120\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚。\r\n主要用途：可作为溶剂, 并用于有机合成。\r\n主要成分：含量: 95％。\r\nCAS号：513-38-2\r\n相对分子质量：184.0\r\n化学类别：513-38-2\r\n燃烧性：易燃\r\n闪点：<10\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、碘化氢。\r\n急性毒性：LD50：\r\nLC50：6700mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对呼吸道、眼睛和皮肤有刺激性。热解可放出有毒气体。接触后可引起烧灼感、咳嗽、喉炎、气短、头痛、恶心和呕吐等。\r\n危险特性：易燃，遇明火、高热、或与氧化剂接触能燃烧, 并散发出有毒气体。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '759', '卤代烷', '2391', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (222, '9002-86-2', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘\0', 'polyvinyl chloride；PVC', '[C2H3Cl]n', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '聚氯乙烯(高分子量)', '外观与性状：白色或淡黄色粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：1.41\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于多数有机溶剂。\r\n主要用途：用于制造管、棒、板、薄膜、中空制品及各种工农业用品和日用品。\r\n主要成分：纯品\r\nCAS号：9002-86-2\r\n相对分子质量：\r\n化学类别：9002-86-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：780(粉云)\r\n爆炸下限：60(g/m3 )\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):47\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：聚氯乙烯生产过程中可有粉尘和单体氯乙烯。吸入氯乙烯单体气体可发生麻醉症状，严重者可致死。长期吸入氯乙烯，可出现神经衰弱征候群，消化系统症状，肝脾肿大，皮肤出现硬皮样改变，肢端溶骨症。长期吸入高浓度氯乙烯，可发生肝脏血管肉瘤。长期吸入聚氯乙烯粉尘，可引起肺?\n危险特性：粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (223, '71348-71-5', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', '2,4Di-tert-butylphenyl-3,5-di-tert-butyl-4-hydro；', 'C29H42O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '添加剂O；光稳定剂120', '外观与性状：白色或浅黄色粉末。\r\n熔点(℃)：194-197\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于甲醇、丙酮、甲苯、乙酸乙酯、烃类、溶于氯仿。\r\n主要用途：作为光稳定剂用于聚丙烯和聚乙烯, 也用于聚甲醛和聚苯乙烯。\r\n主要成分：\r\nCAS号：71348-71-5\r\n相对分子质量：438.6\r\n化学类别：71348-71-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具刺激作用。目前未见职业中毒的资料报道。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (224, NULL, NULL, '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：一般不需要特殊防护，但当作业场所空气中氧气浓度低于18％时，必须佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应品种和数量的消防器\0', 'alkyl benzene；LAB', 'C6H5R(R=C9-C15)', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容\0', '烷基苯；十二烷基苯', '外观与性状：无色或微黄色透明液体。\r\n熔点(℃)：-48\r\n相对密度(水=1)：0.85-0.87\r\n沸点(℃)：245\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：主要用于制造表面活性剂、各种合成洗涤剂等。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：237-245\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：(约)100\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害： 未见生产过程中本品中毒的报道*\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '740', '芳香烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (225, '9002-89-5', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避\0', 'polyvinyl alcohol；PVA', '[C2H4O]n', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '聚乙烯醇', '外观与性状：乳白色粉末。\r\n熔点(℃)：\r\n相对密度(水=1)：1.31-1.34(结晶体)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于石油醚、等溶于水。\r\n主要用途：用于制造聚乙烯醇缩醛、耐汽油管道和维尼纶合成纤维、织物处理剂、乳化剂、纸张涂层、粘合剂等。\r\n主要成分：\r\nCAS号：9002-89-5\r\n相对分子质量：\r\n化学类别：9002-89-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：410(粉云)\r\n爆炸下限：125(g/m3 )\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):20\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害，对眼睛和皮肤有刺激作用。\r\n危险特性：粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。加热分解产生易燃气体。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (226, '557-05-1', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器\0', 'zinc stearate', 'C36H70O4Zn', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '硬脂酸锌；十八酸锌', '外观与性状：纯品为白色轻质粉末, 普通品是带微黄色的重质粉末。\r\n熔点(℃)：120\r\n相对密度(水=1)：1.10\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于乙醇、乙醚、溶于热乙醇、等\r\n主要用途：用作橡胶制品的软化润滑剂、纺织品的打光剂、聚氯乙烯塑料的稳定剂、油漆和珐琅的平光剂以及化妆品面粉的原料等。\r\n主要成分：锌含量:10~11％; 游离酸≤0.5; 水分≤1 。　\r\nCAS号：557-05-1\r\n相对分子质量：632.32\r\n化学类别：557-05-1\r\n燃烧性：可燃\r\n闪点：277\r\n引燃温度：420\r\n爆炸下限：20(g/m3)\r\n爆炸上限：\r\n最小点火能：10\r\n最大爆炸压力：最大爆炸压力上升速率(100kPa):>690\r\n稳定性：\r\n聚合危害：\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化锌。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：人吸入本品可发生支气管肺炎。美国有使用硬脂酸锌作痱子粉而发生中毒的病例报道。长期吸入硬脂酸锌粉尘可引起尘肺，患者有气促、咳嗽、咳痰等症状。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (227, NULL, NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', 'lauryl-stearyl thiodipropionate', 'C36H70O4S', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '硫代二丙酸十八烷基十二酯；硫代二丙酸月桂十八酯', '外观与性状：白色粉末。\r\n熔点(℃)：55-59\r\n相对密度(水=1)：0.91(4℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于甲苯、不溶于水。\r\n主要用途：用作聚烯烃的辅助抗氧剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：599.02\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有刺激作用。目前未见职业中毒的资料报道。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (228, '150-60-7', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接触。搬运时要轻装轻\0', 'dibenzyl disulfide；benzyl disulfide', 'C14H14S2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '二硫化二苄；二苄基二硫', '外观与性状：粉色固体。\r\n熔点(℃)：70-72\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于多数有机溶剂。\r\n主要用途：用作抗氧剂及稳定剂。\r\n主要成分：纯品\r\nCAS号：150-60-7\r\n相对分子质量：246.38\r\n化学类别：150-60-7\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：接触者有恶心、乏力、食欲下降，可以恢复。目前，未见中毒报道。\r\n危险特性：遇明火、高热可燃。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂、酸类。', '783', '硫化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (229, '471-34-1', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：及时换洗工作服。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，避免产生粉尘。避免与酸类、接触。', 'calcium carbonate', 'CaCO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '碳酸钙', '外观与性状：无臭、无味的白色粉末或无色结晶。\r\n熔点(℃)：825(分解)\r\n相对密度(水=1)：2.70-2.95\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于酸。\r\n主要用途：用于制水泥、陶瓷、石灰、钙盐、牙膏、染料、颜料、矿泉水、人造石、油灰、中和剂、催化剂、填料、医药品等。\r\n主要成分：纯品\r\nCAS号：471-34-1\r\n相对分子质量：100.09\r\n化学类别：471-34-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '应与酸类、分开存放。', '危险性类别：\r\n危险性综述：本品不燃。\r\n侵入途径：吸入、食入。\r\n健康危害：从事开采加工的工人常出现上呼吸道炎症、支气管炎，可伴有肺气肿。Ｘ线胸片上出现淋巴结钙化，肺纹理增强。 作业工人患尘肺主要与本品中所含有二氧化硅杂质有关。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', '强酸。', '782', '无机碱', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (230, '50813-16-6', NULL, '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：及时换洗工作服。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'sodium hexametaphosphate', '(NaPO3)6', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '六偏磷酸钠；磷酸钠玻璃', '外观与性状：无色透明、玻璃状固体，吸湿性强。\r\n熔点(℃)：616(分解)\r\n相对密度(水=1)：2.5\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于多数有机溶剂，溶于水。\r\n主要用途：用于水软化、化纤浆粕除铁离子、铜版纸生产的浆料扩散剂等。\r\n主要成分：纯品\r\nCAS号：50813-16-6\r\n相对分子质量：611.76\r\n化学类别：50813-16-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：自然分解产物未知。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：六偏磷酸钠粉尘对眼、鼻腔、口腔、呼吸道粘膜有刺激作用。吸入可引起气管炎及支气管炎。溅入眼内引起结膜炎。误服后可造成消化道灼伤、粘膜糜烂、出血等。\r\n危险特性：未有特殊的燃烧爆炸特性。\r\n', NULL, '751', '磷化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (231, '12125-02-9', NULL, '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与酸类、碱类、接触。搬运时轻装轻卸，防止包装破损。配备泄漏应急处理设备。倒空的容器可\0', 'ammonium chloride', 'NH4Cl', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '氯化铵；硇砂', '外观与性状：无臭、味咸、容易吸潮的白色粉末或结晶颗粒。\r\n熔点(℃)：520\r\n相对密度(水=1)：1.53\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.133\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于乙醇、溶于水、溶于甘油。\r\n主要用途：用于医药、干电池、织物印染、肥料、鞣革、电镀、洗涤剂等。\r\n主要成分：纯品\r\nCAS号：12125-02-9\r\n相对分子质量：53.49\r\n化学类别：12125-02-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氮氧化物。\r\n急性毒性：LD50：1650mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、碱类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品不燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤、粘膜有刺激性，可引起肝肾功能损害，诱发肝昏迷，造成氮质血症和代谢性酸中毒等。健康人应用50g 氯化铵可致重度中毒，有肝病、肾病、慢性心脏病的患者，5g即可引起严重中毒。口服中毒引起化学性胃炎，严重者由于血氨显著增高，诱发肝昏迷。严重中毒时造成肝、肾?\n危险特性：未有特殊的燃烧爆炸特性。受高热分解产生有毒的腐蚀性烟气。\r\n', '强酸、强碱、铅、银。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (232, '7440-01-9', '22009', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需特殊防护。但当作业场所空气中氧气浓度低于18％时，必须佩戴空气呼吸器、氧气呼吸器或长管面具\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。防止气体泄漏到工作场所空气中。远离易燃、可燃物。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'neon', 'Ne', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '氖', '外观与性状：无色无臭气体。\r\n熔点(℃)：-248.7\r\n相对密度(水=1)：1.20(-246℃)\r\n沸点(℃)：-245.9\r\n相对密度(空气=1)：0.7\r\n饱和蒸气压(kPa)：101.32(-246℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-228.7\r\n临界压力(MPa)：2.73\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用于填充电子管、霓虹灯及液化深冷源等。\r\n主要成分：纯品\r\nCAS号：7440-01-9\r\n相对分子质量：20.18\r\n化学类别：7440-01-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具窒息性。\r\n侵入途径：吸入。\r\n健康危害：本品在高浓度时，可使空气中氧分压降低而有窒息的危险。表现有呼吸加快、注意力不集中、共济失调。继之疲倦乏力、烦躁不安、恶心、呕吐、昏迷、抽搐，以致死亡。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', NULL, '779', '非金属单质', '1065', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (233, '75-01-4', '21037', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。实行就业前和定期的体检。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免\0', 'chloroethylene；vinyl chloride', 'C2H3Cl', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '氯乙烯；乙烯基氯', '外观与性状：无色、有醚样气味的气体。\r\n熔点(℃)：-159.8\r\n相对密度(水=1)：0.91\r\n沸点(℃)：-13.4\r\n相对密度(空气=1)：2.15\r\n饱和蒸气压(kPa)：346.53(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：142\r\n临界压力(MPa)：5.60\r\n辛醇/水分配系数：1.38\r\n溶解性：微溶于水、溶于乙醇、乙醚、丙酮、等多数有机溶剂。\r\n主要用途：用作塑料原料及用于有机合成，也用作冷冻剂等。\r\n主要成分：含量: 纯度≥99.99％。\r\nCAS号：75-01-4\r\n相对分子质量：62.50\r\n化学类别：75-01-4\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：415\r\n爆炸下限：3.6\r\n爆炸上限：31.0\r\n最小点火能：\r\n最大爆炸压力：0.666\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌物质。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，为致癌物，氯乙烯在环境中能参与光化学烟雾反应。\r\n侵入途径：吸入。\r\n健康危害：急性毒性表现为麻醉作用；长期接触可引起氯乙烯病。急性中毒：轻度中毒时病人出现眩晕、胸闷、嗜睡、步态蹒跚等；严重中毒可发生昏迷、抽搐，甚至造成死亡。皮肤接触氯乙烯液体可致红斑、水肿或坏死。慢性中毒：表现为神经衰弱综合征、肝肿大、肝功能异常、消化功能障碍、雷?\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。燃烧或无抑制剂时可发生剧烈聚合。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '765', '卤代烯', '1086', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (234, '75-00-3', '21036', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，建议选择自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄\0', 'chloroethane；ethyl chloride', 'C2H5Cl', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '氯乙烷；乙基氯', '外观与性状：无色气体，有类似醚样的气味。\r\n熔点(℃)：-140.8\r\n相对密度(水=1)：0.92\r\n沸点(℃)：12.5\r\n相对密度(空气=1)：2.20\r\n饱和蒸气压(kPa)：53.32(-3.9℃)\r\n燃烧热(kJ/mol)：1349.3\r\n临界温度(℃)：187.2\r\n临界压力(MPa)：5.23\r\n辛醇/水分配系数：1.54\r\n溶解性：微溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作聚丙烯的催化剂，也用作冷冻剂、麻醉剂、杀虫剂等。\r\n主要成分：纯品\r\nCAS号：75-00-3\r\n相对分子质量：64.52\r\n化学类别：75-00-3\r\n燃烧性：易燃\r\n闪点：-43(O.C)\r\n引燃温度：510\r\n爆炸下限：3.6\r\n爆炸上限：14.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：160000mg/m3，2小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：动物为可疑阳性，人类无可靠数据。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、活性金属粉末、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：有刺激和麻醉作用。高浓度损害心、肝、肾。吸入2％～4％浓度时可引起运动失调、轻度痛觉减退，并很快出现知觉消失，但其刺激作用非常轻微；高浓度接触引起麻醉，出现中枢抑制，可出现循环和呼吸抑制。皮肤接触后可因局部迅速降温，造成冻伤。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、钾、钠、及其合金。', '759', '卤代烷', '1037', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (235, '74-87-3', '23040', '监测方法：气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，必须佩戴正压自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到\0', 'chloromethane；methyl chloride', 'CH3Cl', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，将残余气或漏出气用排风机送至水洗塔或与\0', '氯甲烷；甲基氯', '外观与性状：无色气体，有醚样的微甜气味。\r\n熔点(℃)：-97.7\r\n相对密度(水=1)：0.92\r\n沸点(℃)：-23.7\r\n相对密度(空气=1)：1.78\r\n饱和蒸气压(kPa)：506.62(22℃)\r\n燃烧热(kJ/mol)：685.5\r\n临界温度(℃)：143.8\r\n临界压力(MPa)：6.68\r\n辛醇/水分配系数：0.95\r\n溶解性：易溶于水、乙醇、氯仿、等\r\n主要用途：用作致冷剂、甲基化剂，还用于有机合成。\r\n主要成分：含量≥99％。\r\nCAS号：74-87-3\r\n相对分子质量：50.49\r\n化学类别：74-87-3\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：632\r\n爆炸下限：7.0\r\n爆炸上限：19.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：5300mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对水体和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：本品有刺激和麻醉作用，严重损伤中枢神经系统，亦能损害肝、肾和睾丸。急性中毒：轻度者有头痛、眩晕、恶心、呕吐、视力模糊、步态蹒跚、精神错乱等。严重中毒时，可出现谵妄、躁动、抽搐、震颤、视力障碍、昏迷，呼气中有酮体味。尿中检出甲酸盐和酮体有助于诊断。皮肤接触?\n危险特性：与空气混合能形成爆炸性混合物。遇火花或高热能引起爆炸，并生成光气。接触铝及其合金能生成自燃性的铝化合物。\r\n', '强氧化剂。', '759', '卤代烷', '1063', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (236, '13863-41-7', '23026', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器、氧气呼吸器或长管面具。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿带面罩式胶布防毒衣，戴橡胶手套。防止气体或蒸气泄漏到工作场所空气中。远离易燃、可燃物。避免与水接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防\0', 'bromine chloride；chlorine bromide', 'BrCl', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '氯化溴；溴化氯', '外观与性状：桔红色、挥发性不稳定的液体或气体。\r\n熔点(℃)：-66\r\n相对密度(水=1)：\r\n沸点(℃)：10\r\n相对密度(空气=1)：4.1\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醚。\r\n主要用途：用作工业消毒剂。\r\n主要成分：纯品\r\nCAS号：13863-41-7\r\n相对分子质量：115.4\r\n化学类别：13863-41-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯气、溴气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。应与易燃物或可燃物、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品在１０℃时分解放出剧毒、腐蚀性的氯和溴烟雾。吸潮或遇水反应放出有毒烟雾。对皮肤、眼睛和粘膜有强烈的刺激性和腐蚀性。\r\n危险特性：具有强氧化性。与易燃物、可燃物接触能引起剧烈燃烧。具有较强的腐蚀性。室温下迅速分解, 放出剧毒的氯和溴的烟雾。吸潮或遇水会产生大量的腐蚀性烟雾。\r\n', '易燃或可燃物。', '741', '卤素与卤间化合物', '2901', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (237, '506-77-4', '23027', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。采用隔离式操作。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器、氧气呼吸器或长管面具。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。采用隔离式操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿带面罩式胶布防毒衣，戴橡胶手套。防止气体或蒸气泄漏到工作场所空气中。避免与碱类、醇类、酸类、接触。尤其要注意避免与水接触\0', 'cyanogen chloride；chlorocyan', 'CClN', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。若是气体，尽可能切断泄漏源。合理通风，加速扩散。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器要妥善处理，修复、检验后\0', '氯化氰；氯甲腈', '外观与性状：无色液体或气体，有催泪性。\r\n熔点(℃)：-6.5\r\n相对密度(水=1)：1.22\r\n沸点(℃)：13.1\r\n相对密度(空气=1)：1.98\r\n饱和蒸气压(kPa)：134.63(20℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：506-77-4\r\n相对分子质量：61.47\r\n化学类别：506-77-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化氢、氰化氢、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与碱类、醇类、酸类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，高毒，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品在体内代谢形成氢氰酸，作用与氢氰酸相似，但对眼和呼吸道还有强烈的刺激作用。低浓度对呼吸道及眼即有强刺激作用，引起气管炎和支气管炎；高浓度时，引起眩晕、恶心、大量流泪、咳嗽、呼吸困难、肺水肿，甚至迅速死亡。慢性影响：可有不同程度的呕吐、腹泻、尿痛、咳嗽?\n危险特性：化学反应活性较高，能与许多物质发生化学反应。受热分解或接触水、水蒸气会发生剧烈反应，释出剧毒和腐蚀性的烟雾。\r\n', '水、碱类、醇类、酸类。', '743', '腈', '1589', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (238, '7647-01-0', '22022', '监测方法：硫氰酸汞比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿化学防护服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿化学防护服，戴橡胶手套。避免产生烟雾。防止气体泄漏到工作场所空气中。避免与碱类、活性金属粉末、接触。尤其要\0', 'hydrogen chloride', 'HCl', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离300m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿化学防护服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。喷氨水或其它稀碱液中和。构筑围堤或挖坑收容产生的大\0', '氯化氢；盐酸', '外观与性状：无色有刺激性气味的气体。\r\n熔点(℃)：-114.2\r\n相对密度(水=1)：1.19\r\n沸点(℃)：-85.0\r\n相对密度(空气=1)：1.27\r\n饱和蒸气压(kPa)：4225.6(20℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：51.4\r\n临界压力(MPa)：8.26\r\n辛醇/水分配系数：\r\n溶解性：易溶于水。\r\n主要用途：制染料、香料、药物、各种氯化物及腐蚀抑制剂。\r\n主要成分：纯品\r\nCAS号：7647-01-0\r\n相对分子质量：36.46\r\n化学类别：7647-01-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：4600mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与碱类、活性金属粉末、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入。\r\n健康危害：本品对眼和呼吸道粘膜有强烈的刺激作用。急性中毒：出现头痛、头昏、恶心、眼痛、咳嗽、痰中带血、声音嘶哑、呼吸困难、胸闷、胸痛等。重者发生肺炎、肺水肿、肺不张。眼角膜可见溃疡或混浊。皮肤直接接触可出现大量粟粒样红色小丘疹而呈潮红痛热。慢性影响：长期较高浓度接?\n危险特性：无水氯化氢无腐蚀性，但遇水时有强腐蚀性。能与一些活性金属粉末发生反应, 放出氢气。遇氰化物能产生剧毒的氰化氢气体。\r\n', '碱类、活性金属粉末。', '752', '非金属氢化物', '1050', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (239, '75-72-9', '22040', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶碰撞、损坏。配备泄漏应急处理设备。', 'chlorotrifluoromethane；monochlorotrifluoromethane', 'CClF3', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '氯三氟甲烷；一氯三氟甲烷', '外观与性状：无色无臭气体。\r\n熔点(℃)：-181\r\n相对密度(水=1)：1.70\r\n沸点(℃)：-81.4\r\n相对密度(空气=1)：3.6\r\n饱和蒸气压(kPa)：2030(12℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：28.9\r\n临界压力(MPa)：4\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：是一种超低温的致冷剂, 也用作泡沫塑料发泡剂、半导体装置、等离子刻蚀剂。\r\n主要成分：含量:一级≥99.5％; 二级≥99.5％。\r\nCAS号：75-72-9\r\n相对分子质量：104.5\r\n化学类别：75-72-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具窒息性。\r\n侵入途径：吸入。\r\n健康危害：有窒息作用。接触后可有头痛、恶心和眩晕。\r\n危险特性：不燃。遇火或赤热金属可发生热分解，释放出高毒的烟雾。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '759', '卤代烷', '1022', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (240, '7782-50-5', '23002', '监测方法：甲基橙比色法；甲基橙分光光度法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴空气呼吸器或氧气呼吸器。紧急事态抢救或撤离时，必须佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴空气呼吸器，穿带面罩式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与醇类、接触。搬运时轻\0', 'chlorine', 'Cl2', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，用管道将\0', '氯；氯气', '外观与性状：黄绿色、有刺激性气味的气体。\r\n熔点(℃)：-101\r\n相对密度(水=1)：1.47\r\n沸点(℃)：-34.5\r\n相对密度(空气=1)：2.48\r\n饱和蒸气压(kPa)：506.62(10.3℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：144\r\n临界压力(MPa)：7.71\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、碱液。\r\n主要用途：用于漂白，制造氯化合物、盐酸、聚氯乙烯等。\r\n主要成分：含量: 工业级≥99.5％。\r\nCAS号：7782-50-5\r\n相对分子质量：70.91\r\n化学类别：7782-50-5\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：\r\nLC50：850mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与易燃物或可燃物、醇类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，高毒，具刺激性，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入。\r\n健康危害：对眼、呼吸道粘膜有刺激作用。急性中毒：轻度者有流泪、咳嗽、咳少量痰、胸闷，出现气管炎和支气管炎的表现；中度中毒发生支气管肺炎或间质性肺水肿，病人除有上述症状的加重外，出现呼吸困难、轻度紫绀等；重者发生肺水肿、昏迷和休克，可出现气胸、纵隔气肿等并发症。吸入?\n危险特性：本品不会燃烧, 但可助燃。一般可燃物大都能在氯气中燃烧，一般易燃气体或蒸气也都能与氯气形成爆炸性混合物。氯气能与许多化学品如乙炔、松节油、乙醚、氨、燃料气、烃类、氢气、金属粉末等猛烈反应发生爆炸或生成爆炸性物质。它几乎对金属和非金属都有腐蚀作用。\r\n', '易燃或可燃物、醇类、乙醚、氢。', '741', '卤素与卤间化合物', '1017', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (241, '2551-62-4', '22021', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴过滤式防毒面具（半面罩）。或自给式呼吸器。\r\n眼睛防护：必要时，戴安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'sulfur hexafluoride', 'F6S', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '六氟化硫', '外观与性状：无色无臭气体。\r\n熔点(℃)：-51\r\n相对密度(水=1)：1.67(-100℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：5.11\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：45.6\r\n临界压力(MPa)：3.37\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、乙醇、乙醚。\r\n主要用途：用作电子设备和雷达波导的气体绝缘体。\r\n主要成分：纯品\r\nCAS号：2551-62-4\r\n相对分子质量：146.05\r\n化学类别：2551-62-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化硫、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃。\r\n侵入途径：吸入。\r\n健康危害：纯品基本无毒。但产品中如混杂低氟化硫、氟化氢，特别是十氟化硫时，则毒性增强。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、易燃或可燃物。', '776', '非金属卤化物', '1080', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (242, '116-15-4', '22037', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（全面罩）或自给式呼吸器。\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员自吸过滤式防毒面具（半面罩），远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'hexafluoropropylene；perfluoropropylene', 'C3F6', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '六氟丙烯；全氟丙烯', '外观与性状：无色无臭气体。\r\n熔点(℃)：-152.6\r\n相对密度(水=1)：1.58\r\n沸点(℃)：-29.4\r\n相对密度(空气=1)：5.18\r\n饱和蒸气压(kPa)：788.16(27℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：85\r\n临界压力(MPa)：3.25\r\n辛醇/水分配系数：\r\n溶解性：微溶于乙醇、乙醚。\r\n主要用途：作为制备氟磺酸离子交换膜、氟碳油和全氟环氧丙烷等的原料。\r\n主要成分：纯品\r\nCAS号：116-15-4\r\n相对分子质量：150.02\r\n化学类别：116-15-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢。\r\n急性毒性：LD50：\r\nLC50：11200mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：生产工人短时间吸入较多的六氟丙烯，有头昏、无力、睡眠欠佳等症状。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、易燃或可燃物。', '765', '卤代烯', '1858', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (243, '7783-06-4', '21006', '监测方法：硝酸银比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器或空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。及时换洗工作服。作业人员应学会自救互救。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到\0', 'hydrogen sulfide', 'H2S', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离300m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容\0', '硫化氢', '外观与性状：无色、有恶臭的气体。\r\n熔点(℃)：-85.5\r\n相对密度(水=1)：\r\n沸点(℃)：-60.4\r\n相对密度(空气=1)：1.19\r\n饱和蒸气压(kPa)：2026.5(25.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：100.4\r\n临界压力(MPa)：9.01\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇。\r\n主要用途：用于化学分析如鉴定金属离子。\r\n主要成分：纯品\r\nCAS号：7783-06-4\r\n相对分子质量：34.08\r\n化学类别：7783-06-4\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：260\r\n爆炸下限：4.0\r\n爆炸上限：46.0\r\n最小点火能：0.077\r\n最大爆炸压力：0.490\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化硫。\r\n急性毒性：LD50：\r\nLC50：618mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具强刺激性，对环境有危害，对水体和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：本品是强烈的神经毒物，对粘膜有强烈刺激作用。急性中毒：短期内吸入高浓度硫化氢后出现流泪、眼痛、眼内异物感、畏光、视物模糊、流涕、咽喉部灼热感、咳嗽、胸闷、头痛、头晕、乏力、意识模糊等。部分患者可有心肌损害。重者可出现脑水肿、肺水肿。极高浓度(1000mg/m3 以上\r\n危险特性：易燃，与空气混合能形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与浓硝酸、发烟硝酸或其它强氧化剂剧烈反应，发生爆炸。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱类。', '752', '非金属氢化物', '1053', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (244, '7803-51-2', '23005', '监测方法：钼酸胺比色法；火焰光度气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器或氧气呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，戴化学安全防护眼镜，穿带面罩式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所\0', 'hydrogen phosphide；phosphine', 'PH3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，将漏出气用排风机送至空旷地方或装设\0', '磷化氢；膦', '外观与性状：无色，有类似大蒜气味的气体。\r\n熔点(℃)：-132.5\r\n相对密度(水=1)：\r\n沸点(℃)：-87.5\r\n相对密度(空气=1)：1.2\r\n饱和蒸气压(kPa)：53.32(-98.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于热水、微溶于冷水、溶于乙醇、乙醚。\r\n主要用途：用于缩合催化剂，聚合引发剂及制备磷的有机化合物等。\r\n主要成分：纯品\r\nCAS号：7803-51-2\r\n相对分子质量：34.04\r\n化学类别：7803-51-2\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：100\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化磷。\r\n急性毒性：LD50：\r\nLC50：15.3mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，高毒。\r\n侵入途径：吸入。\r\n健康危害：磷化氢作用于细胞酶，影响细胞代谢，发生内窒息。其主要损害神经系统、呼吸系统、心脏、肾脏及肝脏。10mg/m3接触6小时，有中毒症状；409~846mg/m3时，半至１时发生死亡。急性中毒：轻度中毒，病人有头痛、乏力、恶心、失眠、口渴、鼻咽发干、胸闷、咳嗽和低热等；中度中毒，?\n危险特性：极易燃，具有强还原性。遇热源和明火有燃烧爆炸的危险。暴露在空气中能自燃。与氧接触会爆炸，与卤素接触激烈反应。与氧化剂能发生强烈反应。\r\n', '强氧化剂。', '752', '非金属氢化物', '2199', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (245, '540-67-0', '21041', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，必须佩戴空气呼吸器\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体或蒸气泄漏到工作场所空气中。避免与氧化\0', 'methyl ethyl ether；methyloxyethane', 'C3H8O', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '甲乙醚；甲氧基乙烷', '外观与性状：无色液体或气体。\r\n熔点(℃)：-139.2\r\n相对密度(水=1)：0.73\r\n沸点(℃)：11.0\r\n相对密度(空气=1)：2.07\r\n饱和蒸气压(kPa)：53.32(-7.8℃)\r\n燃烧热(kJ/mol)：2105.4\r\n临界温度(℃)：164.7\r\n临界压力(MPa)：4.40\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用于医药。\r\n主要成分：纯品\r\nCAS号：540-67-0\r\n相对分子质量：60.09\r\n化学类别：540-67-0\r\n燃烧性：易燃\r\n闪点：-37\r\n引燃温度：190\r\n爆炸下限：2.0\r\n爆炸上限：10.1\r\n最小点火能：\r\n最大爆炸压力：0.830\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过５℃（装于受压容器中例外）。应与氧化剂、酸类、卤素、分开存放，切忌混储。不宜久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：对皮肤、粘膜有刺激作用；对中枢神经系统有抑制、麻醉作用。\r\n危险特性：与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。长期储存, 可生成具有潜在爆炸危险性的过氧化物。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、卤素。', '770', '醚', '1039', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (246, '74-82-8', '21007', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时轻装轻卸，防止钢瓶\0', 'methane；Marsh gas', 'CH4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，将漏出气用排风机送至空旷地方或装\0', '甲烷；沼气', '外观与性状：无色无臭气体。\r\n熔点(℃)：-182.5\r\n相对密度(水=1)：0.42(-164℃)\r\n沸点(℃)：-161.5\r\n相对密度(空气=1)：0.55\r\n饱和蒸气压(kPa)：53.32(-168.8℃)\r\n燃烧热(kJ/mol)：889.5\r\n临界温度(℃)：-82.6\r\n临界压力(MPa)：4.59\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、乙醚。\r\n主要用途：用作燃料和用于炭黑、氢、乙炔、甲醛等的制造。\r\n主要成分：纯品\r\nCAS号：74-82-8\r\n相对分子质量：16.04\r\n化学类别：74-82-8\r\n燃烧性：易燃\r\n闪点：-188\r\n引燃温度：538\r\n爆炸下限：5.3\r\n爆炸上限：15\r\n最小点火能：0.28\r\n最大爆炸压力：0.717\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具窒息性。\r\n侵入途径：吸入。\r\n健康危害：甲烷对人基本无毒，但浓度过高时，使空气中氧含量明显降低，使人窒息。当空气中甲烷达25％～30％时，可引起头痛、头晕、乏力、注意力不集中、呼吸和心跳加速、共济失调。若不及时脱离，可致窒息死亡。皮肤接触液化本品，可致冻伤。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与五氧化溴、氯气、次氯酸、三氟化氮、液氧、二氟化氧及其它强氧化剂接触剧烈反应。\r\n', '强氧化剂、氟、氯。', '771', '烷烃', '1971', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (247, '115-10-6', '21040', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。\0', 'methyl ether；dimethyl ether', 'C2H6O', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '甲醚；(二)甲醚', '外观与性状：无色气体，有醚类特有的气味。\r\n熔点(℃)：-141.5\r\n相对密度(水=1)：0.66\r\n沸点(℃)：-23.7\r\n相对密度(空气=1)：1.62\r\n饱和蒸气压(kPa)：533.2(20℃)\r\n燃烧热(kJ/mol)：1453\r\n临界温度(℃)：127\r\n临界压力(MPa)：5.33\r\n辛醇/水分配系数：\r\n溶解性：溶于水、醇、乙醚。\r\n主要用途：用作致冷剂、溶剂、萃取剂、聚合物的催化剂和稳定剂。\r\n主要成分：纯品\r\nCAS号：115-10-6\r\n相对分子质量：46.07\r\n化学类别：115-10-6\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：350\r\n爆炸下限：3.4\r\n爆炸上限：27.0\r\n最小点火能：0.29\r\n最大爆炸压力：0.880\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：308000mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：对中枢神经系统有抑制作用，麻醉作用弱。吸入后可引起麻醉、窒息感。对皮肤有刺激性。\r\n危险特性：易燃气体。与空气混合能形成爆炸性混合物。接触热、火星、火焰或氧化剂易燃烧爆炸。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、卤素。', '770', '醚', '1033', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (248, '74-93-1', '21047', '监测方法：溶剂洗脱－气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（全面罩）或自给式呼吸器。。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化\0', 'methyl mercaptan；methanethiol', 'CH4S', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。如有可能，将漏出气用排\0', '甲硫醇；硫氢甲烷', '外观与性状：无色气体，有不愉快的气味。\r\n熔点(℃)：-123.1\r\n相对密度(水=1)：0.87\r\n沸点(℃)：7.6\r\n相对密度(空气=1)：1.66\r\n饱和蒸气压(kPa)：53.32(-7.9℃)\r\n燃烧热(kJ/mol)：1244.0\r\n临界温度(℃)：197\r\n临界压力(MPa)：7.23\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等\r\n主要用途：用于有机合成及喷气机添加剂、杀虫剂、催化剂等。\r\n主要成分：纯品\r\nCAS号：74-93-1\r\n相对分子质量：48.10\r\n化学类别：74-93-1\r\n燃烧性：易燃\r\n闪点：-17.8\r\n引燃温度：\r\n爆炸下限：3.9\r\n爆炸上限：21.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：1325mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过25℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具麻醉性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入。\r\n健康危害：吸入后可引起头痛、恶心及不同程度的麻醉作用；高浓度吸入可引起呼吸麻痹而死亡。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇热源、明火、氧化剂有燃烧爆炸的危险。与水、水蒸气、酸类反应产生有毒和易燃气体。与氧化剂接触猛烈反应。\r\n', '强氧化剂、卤素、酸类。', '789', '醇', '1064', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (249, '993-00-0', '21051', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触毒物时，应该佩戴过滤式防毒面具（全面罩）或自给式呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止气体或蒸气泄漏到工作场所空\0', 'methylchlorosilane；chloromethyl silane', 'CH5ClSi', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后\0', '甲基氯硅烷；氯甲基硅烷', '外观与性状：无色气体或液体, 具有强烈的气味。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：9\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于制取硅橡胶、硅油和发泡灵等。\r\n主要成分：纯品\r\nCAS号：993-00-0\r\n相对分子质量：80.6\r\n化学类别：993-00-0\r\n燃烧性：易燃\r\n闪点：13\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品遇潮气易水解并放出有毒和腐蚀性氯化氢气体。本品对眼、皮肤和粘膜有刺激性，可致皮肤灼伤。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。\r\n', '强氧化剂、潮湿空气。', '757', '卤代硅烷', '2534', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (250, '75-21-8', '21039', '监测方法：气相色谱法；变色酸分光光度法；直接进样－气相色谱法\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与酸类、碱类、醇类、\0', 'epoxyethane；ethylene oxide', 'C2H4O', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构\0', '环氧乙烷；氧化乙烯', '外观与性状：无色气体。\r\n熔点(℃)：-112.2\r\n相对密度(水=1)：0.87\r\n沸点(℃)：10.4\r\n相对密度(空气=1)：1.52\r\n饱和蒸气压(kPa)：145.91(20℃)\r\n燃烧热(kJ/mol)：1262.8\r\n临界温度(℃)：195.8\r\n临界压力(MPa)：7.19\r\n辛醇/水分配系数：-0.30(计算)\r\n溶解性：易溶于水、多数有机溶剂。\r\n主要用途：用于制造乙二醇、表面活性剂、洗涤剂、增塑剂以及树脂等。\r\n主要成分：纯品\r\nCAS号：75-21-8\r\n相对分子质量：44.05\r\n化学类别：75-21-8\r\n燃烧性：易燃\r\n闪点：<-17.8(O.C)\r\n引燃温度：429\r\n爆炸下限：3.0\r\n爆炸上限：100\r\n最小点火能：0.065\r\n最大爆炸压力：0.970\r\n稳定性：不稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌物。\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。库温不宜超过30℃。应与酸类、碱类、醇类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，有毒，为致癌物，具刺激性，具致敏性，对环境有危害。\r\n侵入途径：吸入、经皮吸收。\r\n健康危害：是一种中枢神经抑制剂、刺激剂和原浆毒物。急性中毒：患者有剧烈的搏动性头痛、头晕、恶心和呕吐、流泪、呛咳、胸闷、呼吸困难；重者全身肌肉颤动、言语障碍、共济失调、出汗、神志不清，以致昏迷。还可见心肌损害和肝功能异常。抢救恢复后可有短暂精神失常，迟发性功能性失?\n危险特性：其蒸气能与空气形成范围广阔的爆炸性混合物。遇热源和明火有燃烧爆炸的危险。若遇高热可发生剧烈分解，引起容器破裂或爆炸事故。接触碱金属、氢氧化物或高活性催化剂如铁、锡和铝的无水氯化物及铁和铝的氧化物可大量放热，并可能引起爆炸。其蒸气比空气重，能在较低处扩散到?\n', '酸类、碱、醇类、氨、铜。', '758', '环氧化合物', '1040', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (251, '75-19-4', '21014', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤素、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时要轻装轻卸，\0', 'cyclopropane；trimethylene', 'C3H6', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。如无危险，就地燃烧，同时喷\0', '环丙烷；三亚甲基', '外观与性状：无色气体, 有石油醚样气味。\r\n熔点(℃)：-126.6\r\n相对密度(水=1)：0.72(-79℃)\r\n沸点(℃)：-33\r\n相对密度(空气=1)：1.88\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：工业上用于有机合成, 医药上可作麻醉剂。\r\n主要成分：纯品\r\nCAS号：75-19-4\r\n相对分子质量：42.08\r\n化学类别：75-19-4\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：500\r\n爆炸下限：2.4\r\n爆炸上限：10.4\r\n最小点火能：0.17\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入。\r\n健康危害：具有麻醉作用。动物吸入超过一定浓度时引起血压下降，导致呼吸麻痹而死亡。在工业生产和使用中，本品一般对人体无明显危害。近来国外首例报道一青年因吸入环丙烷而死于一间仓库内。尸解见肺充血和出血性水肿，气管充血，并较早发生细胞自溶现象。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物，遇明火、高热极易燃烧爆炸。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、卤素。', '771', '烷烃', '1027', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (252, '7440-59-7', '22007', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需特殊防护。当作业场所空气中氧气浓度低于18％时，必须佩戴空气呼吸器、氧气呼吸器或长管面具\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。防止气体泄漏到工作场所空气中。远离易燃、可燃物。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'helium', 'He', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '氦', '外观与性状：无色无臭的惰性气体。\r\n熔点(℃)：-272.1\r\n相对密度(水=1)：0.15(-271℃)\r\n沸点(℃)：-268.9\r\n相对密度(空气=1)：0.14\r\n饱和蒸气压(kPa)：202.64(-268℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-267.9\r\n临界压力(MPa)：0.23\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、乙醇。\r\n主要用途：用于气球、温度计、电子管、潜水服等的充气。\r\n主要成分：含量:高纯≥99.999％; 一级≥99.995％; 二级≥99.99％。\r\nCAS号：7440-59-7\r\n相对分子质量：4.00\r\n化学类别：7440-59-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃。\r\n侵入途径：吸入。\r\n健康危害：本品为惰性气体，高浓度时可使氧分压降低而有窒息危险。当空气中氦浓度增高时，患者先出现呼吸加快、注意力不集中、共济失调；继之出现疲倦无力、烦躁不安、恶心、呕吐、昏迷、抽搐，以致死亡。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', NULL, '779', '非金属单质', '1046', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (253, '75-44-5', '23038', '监测方法：紫外分光光度法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。采用隔离式操作。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常作业时，应该佩戴过滤式防毒面具（全面罩）或自给式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。实行就业前和定期的体检。\r\n', '严加密闭，提供充分的局部排风和全面通风。采用隔离式操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，穿胶布防毒衣，戴橡胶手套。防止气体或蒸气泄漏到工作场所空气中。避免与醇类、碱类、接触。尤其要注意避\0', 'Phosgene；carbonyl chloride', 'COCl2', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。喷氨水或其它稀碱液中和。构筑围堤或挖坑收容产生的大量废\0', '光气；碳酰氯', '外观与性状：纯品为无色有特殊气味的气体，低温时为黄绿色液体。\r\n熔点(℃)：-118\r\n相对密度(水=1)：1.37\r\n沸点(℃)：8.3\r\n相对密度(空气=1)：3.5\r\n饱和蒸气压(kPa)：202.65(27.3℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：182\r\n临界压力(MPa)：5.67\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于芳烃、苯、四氯化碳、氯仿、乙酸、等多数有机溶剂。\r\n主要用途：用于有机合成，制造染料、橡胶、农药和塑料等。\r\n主要成分：纯品\r\nCAS号：75-44-5\r\n相对分子质量：98.92\r\n化学类别：75-44-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：\r\nLC50：1400mg/m3，1/2小时(大鼠吸入)\r\n致癌性：\r\n', '用特殊规定的容器盛装、储存，并配稀碱、稀氨喷淋吸收装置。储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。应与醇类、碱类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，高毒，对环境有危害，对水体和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：主要损害呼吸道，导致化学性支气管炎、肺炎、肺水肿。急性中毒：轻度中毒，患者有流泪、畏光、咽部不适、咳嗽、胸闷等；中度中毒，除上述症状加重外，患者出现轻度呼吸困难、轻度紫绀；重度中毒出现肺水肿或成人呼吸窘迫综合征，患者剧烈咳嗽、咯大量泡沫痰、呼吸窘迫、明显?\n危险特性：不燃。化学反应活性较高，遇水后有强烈腐蚀性。\r\n', '水、醇类、碱类。', '753', '无机酰卤', '1076', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (254, '7782-41-4', '23001', '监测方法：离子选择性电极法；氟试剂－镧盐比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器或氧气呼吸器。紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与活性金属粉末、接触。搬运\0', 'fluorine', 'F2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。将残余气或漏出气用排风机送至水洗塔或与塔\0', '氟', '外观与性状：淡黄色气体，有刺激性气味。\r\n熔点(℃)：-218\r\n相对密度(水=1)：1.14(-200℃)\r\n沸点(℃)：-187\r\n相对密度(空气=1)：1.70\r\n饱和蒸气压(kPa)：101.32(-187℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-129\r\n临界压力(MPa)：5.57\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作火箭燃料中的氧化剂，以及用于氟化合物、含氟塑料、氟橡胶等的制造。\r\n主要成分：纯品\r\nCAS号：7782-41-4\r\n相对分子质量：38.00\r\n化学类别：7782-41-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：233mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与易燃物或可燃物、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，高毒，具强刺激性。\r\n侵入途径：吸入。\r\n健康危害：本品高浓度时有强烈的腐蚀作用。急性中毒：高浓度接触眼和上呼吸道出现强烈的刺激症状，重者引起肺水肿、肺出血、喉及支气管痉挛。氟对皮肤、粘膜有强烈的刺激作用，高浓度可引起严重灼伤。慢性影响：可引起慢性鼻炎、咽炎、喉炎、气管炎、植物神经功能紊乱和骨骼改变。尿氟?\n危险特性：强氧化剂。是最活泼的非金属元素，几乎可与所有的物质发生剧烈反应而燃烧。与氢气混合时会引起爆炸。特别是与水或杂质接触时，可发生激烈反应而燃烧，使容器破裂。氟对许多金属有腐蚀性，并能形成一层保护性金属氟化物。\r\n', '易燃或可燃物、活性金属粉末。', '741', '卤素与卤间化合物', '1045', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (255, '124-38-9', '22019', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。防止气体泄漏到工作场所空气中。远离易燃、可燃物。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'carbon dioxide', 'CO2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '二氧化碳；碳酸酐', '外观与性状：无色无臭气体。\r\n熔点(℃)：-56.6(527kPa)\r\n相对密度(水=1)：1.56(-79℃)\r\n沸点(℃)：-78.5(升华)\r\n相对密度(空气=1)：1.53\r\n饱和蒸气压(kPa)：1013.25(-39℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：31\r\n临界压力(MPa)：7.39\r\n辛醇/水分配系数：\r\n溶解性：溶于水、烃类、等多数有机溶剂。\r\n主要用途：用于制糖工业、制碱工业、制铅白等，也用于冷饮、灭火及有机合成。\r\n主要成分：纯品\r\nCAS号：124-38-9\r\n相对分子质量：44.01\r\n化学类别：124-38-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃。\r\n侵入途径：吸入。\r\n健康危害：在低浓度时，对呼吸中枢呈兴奋作用, 高浓度时则产生抑制甚至麻痹作用。中毒机制中还兼有缺氧的因素。急性中毒：人进入高浓度二氧化碳环境，在几秒钟内迅速昏迷倒下，反射消失、瞳孔扩大或缩小、大小便失禁、呕吐等，更严重者出现呼吸停止及休克，甚至死亡。固态(干冰)和液态?\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', NULL, '748', '非金属氧化物', '1013', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (256, '107-89-1', '61598', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', '3-hydroxybutyraldehyde；Aldol', 'C4H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '3-羟基丁醛；3-丁醇醛', '外观与性状：无色稠厚液体。\r\n熔点(℃)：-88\r\n相对密度(水=1)：1.11\r\n沸点(℃)：79\r\n相对密度(空气=1)：3.04\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：2284.8\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、乙醚。\r\n主要用途：用作促进剂、防老剂、溶剂和矿石的浮选，以及制作香精等。\r\n主要成分：纯品\r\nCAS号：107-89-1\r\n相对分子质量：88.10\r\n化学类别：107-89-1\r\n燃烧性：可燃\r\n闪点：65.6(O.C)\r\n引燃温度：250\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2180mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、等分开存放，切忌混储。不宜大量储存或久存。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼、呼吸道和皮肤有刺激性。\r\n危险特性：遇高热、明火或与氧化剂接触, 有引起燃烧的危险。受热分解释出有毒的巴豆醛气体。\r\n', '强氧化剂、强酸、酰基氯、酸酐。', '773', '醛', '2839', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (257, '56-23-5', '61554', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴直接式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴安全护目境。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴安全护目境，穿防毒物渗透工作服，戴防化学品手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、活性金属粉末、接触。搬运时要轻装轻卸，防止包装及容器损\0', 'carbon tetrachloride；tetrachloromethane', 'CCl4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。喷雾状水冷却和稀释蒸汽，保护现场人员，但不要\0', '四氯化碳；四氯甲烷', '外观与性状：无色有特臭的透明液体，极易挥发。\r\n熔点(℃)：-22.6\r\n相对密度(水=1)：1.60\r\n沸点(℃)：76.8\r\n相对密度(空气=1)：5.3\r\n饱和蒸气压(kPa)：13.33(23℃)\r\n燃烧热(kJ/mol)：364.9\r\n临界温度(℃)：283.2\r\n临界压力(MPa)：45.58\r\n辛醇/水分配系数：2.6\r\n溶解性：微溶于水、易溶于多数有机溶剂。\r\n主要用途：用于有机合成、致冷剂、杀虫剂。亦作有机溶剂。\r\n主要成分：含量: 工业级 一级≥99.5％;二级≥99.0％。\r\nCAS号：56-23-5\r\n相对分子质量：153.84\r\n化学类别：56-23-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：光气、氯化物。\r\n急性毒性：LD50：2350mg/kg(大鼠经口)；5070mg/kg(大鼠经皮)\r\nLC50：50400mg/m3，4小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：动物阳性，人类可疑。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。保持容器密封。应与氧化剂、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度本品蒸气对粘膜有轻度刺激作用，对中枢神经系统有麻醉作用，对肝、肾有严重损害。急性中毒：吸入较高浓度本品蒸气，最初出现眼及上呼吸道刺激症状。随后可出现中枢神经系统抑制和胃肠道症状。较严重病例数小时或数天后出现中毒性肝肾损伤。重者甚至发生肝坏死、肝昏迷?\n危险特性：本品不会燃烧，但遇明火或高温易产生剧毒的光气和氯化氢烟雾。在潮湿的空气中逐渐分解成光气和氯化氢。\r\n', '活性金属粉末、强氧化剂。', '759', '卤代烷', '1846', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (258, '78-95-5', '61601', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'chloroacetone；acetonyl chloride', 'C3H5ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统\0', '氯丙酮；一氯丙酮', '外观与性状：无色液体, 有刺激性气味。\r\n熔点(℃)：-44.5\r\n相对密度(水=1)：1.16\r\n沸点(℃)：120\r\n相对密度(空气=1)：3.2\r\n饱和蒸气压(kPa)：1.33(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、乙醚、氯仿。\r\n主要用途：用作杀虫剂, 催泪剂, 也用于制药物等。\r\n主要成分：纯品\r\nCAS号：78-95-5\r\n相对分子质量：92.52\r\n化学类别：78-95-5\r\n燃烧性：易燃\r\n闪点：7.0\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：100mg/kg(大鼠经口)；140mg/kg(兔经皮)\r\nLC50：262ppm，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强烈催泪性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品在日光的作用下分解而生成催泪性极强的气体，是一种催泪性毒剂。误服与皮肤接触、吸入会中毒。\r\n危险特性：遇明火、高热易燃。与氧化剂接触猛烈反应。受热分解能放出剧毒的光气。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱。', '775', '酮', '1695', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (259, '79-52-7', '61605', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'trichlorotrifluoroacetone；1,1,3-trichloro-1,3,3-t', 'C3Cl3F3O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '1,1,3-三氯-1,3,3-三氟丙酮；三氯三氟丙酮', '外观与性状：无色液体。\r\n熔点(℃)：<-78\r\n相对密度(水=1)：\r\n沸点(℃)：84.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于多数有机溶剂。\r\n主要用途：用作溶剂、络合剂。\r\n主要成分：纯品\r\nCAS号：79-52-7\r\n相对分子质量：215.39\r\n化学类别：79-52-7\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氟化物。\r\n急性毒性：LD50：280mg/kg(大鼠经口)\r\nLC50：20000mg/m3，1/2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有刺激和麻醉作用。动物的急性中毒症状：眼及呼吸道粘膜显著刺激，短时间兴奋，共济失调，呼吸困难，痉挛。死亡动物出现内脏器官充血，肺出血及较大块的水肿。\r\n危险特性：在高温下可燃烧。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '775', '酮', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (260, '3926-62-3', '61610', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。定期体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。避免产生粉尘。避免与氧化剂、酸类、碱类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设\0', 'sodium chloroacetate；chloroacetic acid sodium sal', 'C2H2ClO2Na', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '一氯乙酸钠；氯醋酸钠', '外观与性状：白色粉末或结晶。\r\n熔点(℃)：200(分解)\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、微溶于甲醇、不溶于丙酮。\r\n主要用途：是合成农药、医药等的原料。\r\n主要成分：纯品\r\nCAS号：3926-62-3\r\n相对分子质量：116.48\r\n化学类别：3926-62-3\r\n燃烧性：不燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化钠。\r\n急性毒性：LD50：80mg/kg(大鼠经口)；170mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激和腐蚀作用。\r\n危险特性：受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂、强酸、强碱。', '800', '未指定的化学类别', '2659', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (261, '7425-48-1', '61615', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。特别注意眼和呼吸道的防护。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', 'ethyl-3-chloro-n-butanoate；ethyl-3-chloro-n-butyr', 'C6H11ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '3-氯正丁酸乙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.05\r\n沸点(℃)：109\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：7425-48-1\r\n相对分子质量：150.61\r\n化学类别：7425-48-1\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有毒，有刺激性。受高热释放出有毒气体。\r\n危险特性：遇明火、高热易燃。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (262, '78-93-3', '32073', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-butanone；methyl ethyl ketone', 'C4H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '2-丁酮；甲基乙基酮', '外观与性状：无色液体，有似丙酮的气味。\r\n熔点(℃)：-85.9\r\n相对密度(水=1)：0.81\r\n沸点(℃)：79.6\r\n相对密度(空气=1)：2.42\r\n饱和蒸气压(kPa)：9.49(20℃)\r\n燃烧热(kJ/mol)：2441.8\r\n临界温度(℃)：260\r\n临界压力(MPa)：4.40\r\n辛醇/水分配系数：0.29\r\n溶解性：溶于水、乙醇、乙醚、可混溶于油类。\r\n主要用途：用作溶剂、脱蜡剂，也用于多种有机合成，及作为合成香料和医药的原料。\r\n主要成分：纯品\r\nCAS号：78-93-3\r\n相对分子质量：72.11\r\n化学类别：78-93-3\r\n燃烧性：易燃\r\n闪点：-9\r\n引燃温度：404\r\n爆炸下限：1.7\r\n爆炸上限：11.4\r\n最小点火能：0.27\r\n最大爆炸压力：0.830\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3400mg/kg(大鼠经口)；6480mg/kg(兔经皮)\r\nLC50：23520mg/m3，8小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼、鼻、喉、粘膜有刺激性。长期接触可致皮炎。本品常与己酮同-[2]混合应用，能加强己酮-[2]引起的周围神经病现象，但单独接触丁酮未发现有周围神经病现象。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱类、强还原剂。', '775', '酮', '1193', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (263, '7425-45-8', '61615', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。特别注意眼和呼吸道的防护。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', 'ethyl-2-chloro-n-butanoate；2-chlorobutyric acid, ', 'C6H11ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '2-氯正丁酸乙酯；2-氯丁酸乙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.06\r\n沸点(℃)：163-164\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：7425-45-8\r\n相对分子质量：150.61\r\n化学类别：7425-45-8\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有毒，有刺激性。受高热能放出有毒气体。\r\n危险特性：遇明火、高热易燃。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (264, '812-01-1', '61616', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。特别注意眼和呼吸道的防护。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离易燃、可燃物。防止蒸气泄漏到工作场所空气中。避免与还原剂、酸类、\0', 'methyl chlorosulfonate', 'CH3ClO3S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。小量泄漏：用干燥的砂土或类似物质吸收，大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器内，回收或运至废物处理场所处置。', '氯磺酸甲酯', '外观与性状：无色油状液体, 有刺激性气味。\r\n熔点(℃)：-70\r\n相对密度(水=1)：1.49(10℃)\r\n沸点(℃)：133-135(分解)\r\n相对密度(空气=1)：4.51\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：在有机合成反应中起甲基化作用, 也用作军用毒气。\r\n主要成分：纯品\r\nCAS号：812-01-1\r\n相对分子质量：130.57\r\n化学类别：812-01-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、硫化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、酸类、碱类、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性，具强烈催泪性。\r\n侵入途径：吸入、食入。\r\n健康危害：低浓度时有强烈的催泪作用和呼吸道刺激作用，可引起肺水肿。对皮肤有烧灼作用。兔吸入，4mg/Lx30分钟，24小时后死亡。在45-60mg/m3浓度下，人不能耐受１分钟。在用于工业方面的危害未见报道。\r\n危险特性：受热分解产生有毒的氯化物气体。遇水、水蒸气或酸类产生有毒和腐蚀性的气体。\r\n', '强还原剂、强酸、强碱、易燃或可燃物。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (265, '590-92-1', '61618', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、碱类、接触。搬运时要轻装轻卸，\0', '3-bromopropionic acid', 'C3H5BrO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '3-溴丙酸；β-溴丙酸', '外观与性状：无色片状结晶。\r\n熔点(℃)：62.5\r\n相对密度(水=1)：1.48\r\n沸点(℃)：140/6.0kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：6.0/140℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、丙酮、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：590-92-1\r\n相对分子质量：152.98\r\n化学类别：590-92-1\r\n燃烧性：可燃\r\n闪点：65\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：2000mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的溴化物气体。\r\n', '碱、强氧化剂、强还原剂。', '795', '有机酸', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (266, '600-00-0', '61619', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'ethyl-2-bromoisobutanoate；ethyl-2-bromo-2-methylp', 'C6H11BrO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降低\0', '2-溴异丁酸乙酯；2-溴-2-甲基丙酸乙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.33\r\n沸点(℃)：65-67(1.47kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.47(65-67℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：600-00-0\r\n相对分子质量：195.06\r\n化学类别：600-00-0\r\n燃烧性：易燃\r\n闪点：60\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有毒。有腐蚀性。受高热放出有毒气体。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。受高热分解放出有毒的气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '氧化剂、还原剂、酸类、碱类。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (267, '542-54-1', '61629', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', '4-methyl pentanenitrile', 'C6H11N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '4-甲基戊腈', '外观与性状：无色液体。\r\n熔点(℃)：-51\r\n相对密度(水=1)：0.80\r\n沸点(℃)：155\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：101.44/156℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：542-54-1\r\n相对分子质量：97.16\r\n化学类别：542-54-1\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：488mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：兔皮下注射最低致死量为 89mg/kg，出现震颤和呼吸困难。\r\n危险特性：遇明火易燃。受高热分解放出有毒的气体。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (268, '89-32-7', '61623', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、碱类、\0', 'pyromellitic dianhydride', 'C10H2O6', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '均苯四甲酸酐；均苯四甲酸二酐', '外观与性状：白色粉末。\r\n熔点(℃)：286\r\n相对密度(水=1)：1.68\r\n沸点(℃)：397~400\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：4.00/305℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于乙醚、氯仿、溶于乙醇、丙酮、乙酸乙酯。\r\n主要用途：用作环氧树脂的熟化、交联剂、中间体。\r\n主要成分：纯品\r\nCAS号：89-32-7\r\n相对分子质量：218.12\r\n化学类别：89-32-7\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4000mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼睛和皮肤有刺激性。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。在潮湿空气中水解为均苯四甲酸。\r\n', '酸类、碱、醇类、水、强氧化剂。', '778', '酸酐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (269, '124-12-9', '61629', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'octanenitrile；heptyl cyanide', 'C8H15N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '辛腈；庚基氰', '外观与性状：无色液体。\r\n熔点(℃)：-45\r\n相对密度(水=1)：0.81\r\n沸点(℃)：189-200\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于乙醇、溶于乙醚。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：124-12-9\r\n相对分子质量：125.22\r\n化学类别：124-12-9\r\n燃烧性：易燃\r\n闪点：73\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1760mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害，具有刺激作用。腈类化合物能析出氰离子，抑制细胞呼吸，造成组织缺氧。\r\n危险特性：遇明火易燃。受高热分解放出有毒的气体。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (270, '646-20-8', '61630', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', '1,5-dicyanopentane；pimelonitrile', 'C7H10N2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '1,5-二氰戊烷；庚二腈', '外观与性状：无色液体。\r\n熔点(℃)：-31.4\r\n相对密度(水=1)：0.95\r\n沸点(℃)：175(1.87kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.87(175℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：646-20-8\r\n相对分子质量：122.17\r\n化学类别：646-20-8\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：300mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤有刺激作用。吸入、摄入或经皮肤吸收后对身体有害。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：遇明火能燃烧。与氧化剂可发生反应。遇高热分解释出剧毒的气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (271, '629-40-3', '61630', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', '1,6-dicyanohexane；suberonitrile', 'C8H12N2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '1,6-二氰基己烷；辛二腈', '外观与性状：无色至淡黄色液体。\r\n熔点(℃)：-3.5\r\n相对密度(水=1)：0.95\r\n沸点(℃)：185(2.0kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.0(185℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：629-40-3\r\n相对分子质量：136.20\r\n化学类别：629-40-3\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：310mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤有刺激作用。摄入、吸入或经皮肤吸收后对身体有害。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：遇明火能燃烧。遇高热分解释出剧毒的气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (272, '2417-90-5', '61635', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏\0', 'β-bromopropionitrile；3-bromoethyl cyanide', 'C3H4BrN', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', 'β-溴丙腈；3-溴丙腈', '外观与性状：无色或淡黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.62\r\n沸点(℃)：92(3.33kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：3.33(92℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于醇、醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：2417-90-5\r\n相对分子质量：133.98\r\n化学类别：2417-90-5\r\n燃烧性：易燃\r\n闪点：97\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有强烈刺激作用。毒作用比氯丙腈稍弱。\r\n危险特性：遇明火、高热易燃。遇高热分解释出剧毒的气体。与水或水蒸气、酸或酸雾能发生反应产生有毒气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (273, '4170-30-3', '32071', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、\0', '2-butenal；crotonaldehyde', 'C4H6O', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水\0', '2-丁烯醛(抑制了的)；巴豆醛', '外观与性状：无色或淡黄色液体，有窒息性刺激臭味。\r\n熔点(℃)：-76\r\n相对密度(水=1)：0.85\r\n沸点(℃)：104\r\n相对密度(空气=1)：2.41\r\n饱和蒸气压(kPa)：4.00(20℃)\r\n燃烧热(kJ/mol)：2268.0\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.63\r\n溶解性：微溶于水、可混溶于乙醇、乙醚、苯、甲苯、等多数有机溶剂。\r\n主要用途：用于制正丁醇、正丁醛、硫化促进剂。\r\n主要成分：含量≥70％。\r\nCAS号：4170-30-3\r\n相对分子质量：70.09\r\n化学类别：4170-30-3\r\n燃烧性：易燃\r\n闪点：13\r\n引燃温度：230\r\n爆炸下限：2.1\r\n爆炸上限：15.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：240mg/kg(小鼠经口)；380mg/kg(兔经皮)\r\nLC50：4000mg/m3，1/2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼结膜及上呼吸道粘膜有强烈刺激作用。长期接触引起慢性鼻炎、神经系统机能障碍。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。在空气中非常容易氧化生成过氧化物, 受热或撞击、甚至轻微摩擦即发生爆炸。在火场高温下，能发生聚合放热，使容器破裂。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会?\n', '强氧化剂、碱类、氧。', '773', '醛', '1143', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (274, '617-83-4', '61637', '监测方法：异菸酸钠－巴比妥钠比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏\0', 'diethyl cyanamide；N-cyanodiethylamine', 'C5H10N2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '氰化二乙胺；二乙氨基氰', '外观与性状：无色液体。\r\n熔点(℃)：-80\r\n相对密度(水=1)：0.85\r\n沸点(℃)：186-188\r\n相对密度(空气=1)：3.4\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成等。\r\n主要成分：纯品\r\nCAS号：617-83-4\r\n相对分子质量：98.15\r\n化学类别：617-83-4\r\n燃烧性：易燃\r\n闪点：69\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：100mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤、粘膜有强烈的刺激作用。受热分解或接触酸液、酸雾能放出有毒的氰化物气体，应引起注意。接触水或水蒸气能产生有腐蚀性、有毒的气体。\r\n危险特性：易燃，与氧化剂接触猛烈反应。受热分解或接触酸液、酸雾能放出有毒的氰化物气体。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。\r\n', '强氧化剂、强还原剂、强酸、强碱、潮湿空气。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (275, '529-19-1', '61639', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'o-tolunitrile；o-cyanotoluene', 'C8H7N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '2-甲基苯甲腈；邻甲基苯甲腈', '外观与性状：无色液体。\r\n熔点(℃)：-14~-13\r\n相对密度(水=1)：0.99\r\n沸点(℃)：205\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：4306.7\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：529-19-1\r\n相对分子质量：117.15\r\n化学类别：529-19-1\r\n燃烧性：可燃\r\n闪点：84\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：600mg/kg(兔经皮)[LDL0]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤有刺激作用，其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：遇明火能燃烧。与强氧化剂接触可发生化学反应。受高热分解放出有毒的气体。\r\n', '强氧化剂、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (276, '555-21-5', '61642', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与\0', '4-nitrophenylacetonitrile；p-nitrobenzyl cyanide', 'C8H6N2O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '4-硝基苯乙腈；对硝基苄基氰', '外观与性状：无色片状结晶。\r\n熔点(℃)：116~117\r\n相对密度(水=1)：\r\n沸点(℃)：196/1.6kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.60/196℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯、等多数有机溶剂。\r\n主要用途：用作染料及药品合成中间体。\r\n主要成分：纯品\r\nCAS号：555-21-5\r\n相对分子质量：162.15\r\n化学类别：555-21-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：47mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有刺激性。\r\n危险特性：遇明火能燃烧。与强氧化剂接触可发生化学反应。受高热分解放出有毒的气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (277, '4733-50-0', '61643', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', '3,6-dihydroxyphthalonitrile；2,3-dicyanohydroquino', 'C8H4N2O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '3,6-二羟基邻苯二甲腈；2,3-二氰基对苯二酚', '外观与性状：微黄色片状结晶。\r\n熔点(℃)：230\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、苯、易溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：4733-50-0\r\n相对分子质量：160.13\r\n化学类别：4733-50-0\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激作用。\r\n危险特性：遇明火能燃烧。与强氧化剂接触可发生化学反应。受高热分解放出有毒的气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (278, '111-19-3', '81116', '监测方法：\r\n工程控制：加强局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。定期体检。\r\n', '加强局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、醇类\0', 'sebacoyl chloride；sebacoyl dichloride', 'C10H16Cl2O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '氯化癸二酰；癸二酰氯', '外观与性状：液体。\r\n熔点(℃)：-2.5\r\n相对密度(水=1)：1.12\r\n沸点(℃)：168(1.60kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.40(137-140℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醚、烃类。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-19-3\r\n相对分子质量：239.14\r\n化学类别：111-19-3\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有强烈刺激作用。吸入后可引起喉、支气管的痉挛、水肿、炎症，化学性肺炎或肺水肿。接触后可引起烧灼感、咳嗽、喘息、气短、喉炎、头痛、恶心和呕吐。\r\n危险特性：遇高热、明火有引起燃烧的危险。具有腐蚀性。\r\n', '氧化剂、强碱、水、醇类。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (279, '79-44-7', '81119', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', 'dimethylcarbamyl chloride', 'C3H6ClNO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '二甲基氨基甲酰氯', '外观与性状：无色透明液体。\r\n熔点(℃)：-33\r\n相对密度(水=1)：1.68\r\n沸点(℃)：167\r\n相对密度(空气=1)：3.73\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：79-44-7\r\n相对分子质量：107.54\r\n化学类别：79-44-7\r\n燃烧性：可燃\r\n闪点：68\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：1000mg/kg(大鼠经口)\r\nLC50：180ppm，6小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道和皮肤有强烈刺激作用。吸入后，可因喉、支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。中毒表现有咳嗽、喘息、气短、喉炎、头痛、恶心和呕吐。\r\n危险特性：可燃。遇高热、明火或与氧化剂接触, 有引起燃烧的危险。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。\r\n', '强氧化剂、强碱、水、碱类。', '800', '未指定的化学类别', '2262', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (280, '527-69-5', '81120', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中\0', 'α-furoyl chloride；pyromucyl chloride', 'C5H3ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '呋喃甲酰氯；糠酰氯', '外观与性状：无色或浅黄色液体。\r\n熔点(℃)：-2\r\n相对密度(水=1)：1.32\r\n沸点(℃)：173\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.33/66℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醚、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：527-69-5\r\n相对分子质量：130.53\r\n化学类别：527-69-5\r\n燃烧性：可燃\r\n闪点：85\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入可能由于喉、支气管痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：可燃。遇高热、明火或与氧化剂接触, 有引起燃烧的危险。在空气中受热分解释出剧毒的光气和氯化氢气体。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。\r\n', '强氧化剂、强碱、水、醇类、碱类。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (281, '557-98-2', '31021', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-chloropropene', 'C3H5Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-氯丙烯', '外观与性状：无色液体。\r\n熔点(℃)：-138.6\r\n相对密度(水=1)：0.90\r\n沸点(℃)：22.5\r\n相对密度(空气=1)：2.63\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：-0.24\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：557-98-2\r\n相对分子质量：76.53\r\n化学类别：557-98-2\r\n燃烧性：易燃\r\n闪点：-34\r\n引燃温度：\r\n爆炸下限：4.5\r\n爆炸上限：16.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：267000mg/m3(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材\0', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有强烈刺激性。高浓度严重损害粘膜、上呼吸道、眼睛和皮肤。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。本品遇火焰或受热会发生分解，产生剧毒的光气和腐蚀性的氯化氢气体。在火场高温下，能发生聚合放热，使容器破裂。遇酸性催化剂如路易斯催化剂、齐格勒催化剂、硫酸、氯化铁、氯化铝等都?\n', '强氧化剂、酸类、碱。', '765', '卤代烯', '2456', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (282, '89-75-8', '81122', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）；可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、碱类、醇类、接触。尤其要注意避免与水接触。搬\0', '2,4-dichlorobenzoyl chloride', 'C7H3Cl3O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。若是液体，防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液\0', '2,4-二氯苯甲酰氯；2,4-二氯代氯化苯甲酰', '外观与性状：无色至浅黄色的液体或固体。\r\n熔点(℃)：16~18\r\n相对密度(水=1)：1.49\r\n沸点(℃)：150/4.53kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.00/111℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、氯仿、等多数有机溶剂。\r\n主要用途：用于有机合成，用作染料、制药工业的中间体。\r\n主要成分：纯品\r\nCAS号：89-75-8\r\n相对分子质量：209.46\r\n化学类别：89-75-8\r\n燃烧性：可燃\r\n闪点：137\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入可能由于喉、支气管痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：可燃。遇高热、明火有引起燃烧的危险。与氧化剂可发生反应。与水或潮气发生反应，散发出刺激性和腐蚀性的氯化氢气体。遇潮时对大多数金属有腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (283, '100-07-2', '81123', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作\0', '4-methoxybenzoyl chloride；p-anisoyl chloride', 'C8H7ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '4-甲氧基苯甲酰氯；对甲氧基苯甲酰氯', '外观与性状：淡黄色液体。\r\n熔点(℃)：22\r\n相对密度(水=1)：\r\n沸点(℃)：145/1.87kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.87/145℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：100-07-2\r\n相对分子质量：170.60\r\n化学类别：100-07-2\r\n燃烧性：可燃\r\n闪点：87\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对粘膜、上呼吸道、眼睛和皮肤有强烈刺激作用。吸入后可因喉、支气管的炎症、水肿、痉挛，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心、呕吐。\r\n危险特性：可燃。在室温时有爆炸的危险。遇明火、高热易引起燃烧爆炸。与氧化剂接触猛烈反应。遇水发生剧烈反应, 散发出具有刺激性和腐蚀性的氯化氢气体。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、水、强碱。', '739', '有机酰卤', '1729', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (284, '21615-34-9', '81123', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中\0', '2-methoxybenzoyl chloride', 'C8H7ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '2-甲氧基苯甲酰氯；茴香酰氯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.15\r\n沸点(℃)：128/1.07kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.07/128℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：21615-34-9\r\n相对分子质量：170.60\r\n化学类别：21615-34-9\r\n燃烧性：可燃\r\n闪点：84\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、潮湿空气。\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入可能由于喉、支气管的痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：可燃。在室温时有爆炸的危险。遇明火、高热易引起燃烧爆炸。与氧化剂接触猛烈反应。遇水发生剧烈反应, 散发出具有刺激性和腐蚀性的氯化氢气体。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、强碱、水、醇类。', '739', '有机酰卤', '1729', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (285, '1711-05-3', '81123', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作\0', '3-methoxybenzoyl chloride；m-anisoyl chloride', 'C8H7ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '3-甲氧基苯甲酰氯；间甲氧基苯甲酰氯', '外观与性状：淡黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.21\r\n沸点(℃)：124/2.00kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.00/124℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：1711-05-3\r\n相对分子质量：170.60\r\n化学类别：1711-05-3\r\n燃烧性：可燃\r\n闪点：92\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对粘膜、上呼吸道、眼睛和皮肤有强烈刺激作用。吸入后可因喉、支气管的炎症、水肿、痉挛，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心、呕吐。\r\n危险特性：可燃。在室温时有爆炸的危险。遇明火、高热易引起燃烧爆炸。与氧化剂接触猛烈反应。遇水发生剧烈反应, 散发出具有刺激性和腐蚀性的氯化氢气体。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、强碱、醇类、水。', '739', '有机酰卤', '1729', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (286, '88-95-9', '81125', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类\0', '1,2-benzenedicarbonyl chloride；phthaloyl dichlori', 'C8H4Cl2O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至\0', '邻苯二甲酰氯；二氯化邻苯二甲酰', '外观与性状：无色至浅黄色液体。\r\n熔点(℃)：12\r\n相对密度(水=1)：1.41\r\n沸点(℃)：269~271\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚、苯、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：88-95-9\r\n相对分子质量：203.02\r\n化学类别：88-95-9\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、光气、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉和支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。能引起灼伤。\r\n危险特性：遇明火、高热可燃。与强氧化剂接触可发生化学反应。受高热分解产生有毒的腐蚀性烟气。具有腐蚀性。\r\n', '水、醇类、强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (287, '824-72-6', '81128', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。定期体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中\0', 'benzene phosphorus oxychloride；phenyl dichloro sp', 'C6H5Cl2OP', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '苯膦酰二氯；苯氧氯化膦', '外观与性状：无色至亮黄色液体, 有微弱的果香味。\r\n熔点(℃)：3\r\n相对密度(水=1)：1.38\r\n沸点(℃)：258\r\n相对密度(空气=1)：6.7\r\n饱和蒸气压(kPa)：2.00(137℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、氯仿、四氯化碳。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：824-72-6\r\n相对分子质量：194.98\r\n化学类别：824-72-6\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化磷。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。本品对眼睛、皮肤、粘膜和上呼吸道有激烈的刺激作用。吸入后可引起喉、支气管的痉挛、水肿，化学性肺炎或肺水肿。接触后可引起烧灼感、咳嗽、喘息、气短、头痛、恶心和呕吐。\r\n危险特性：受热发生分解释出有刺激性和腐蚀性的气体。遇水或潮湿空气分解出有腐蚀性和刺激性的气体。\r\n', '强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (288, '91270-74-5', '81129', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中\0', '1-naphthoxyphosphorus dichloride；α-naphthyloxych', 'C10H7Cl2OP', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '1-萘氧二氯化膦', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.08(15℃)\r\n沸点(℃)：180(2.40kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.40(180℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于无水乙醇、乙醚。\r\n主要用途：用于有机分析中测定碳和氢。\r\n主要成分：纯品\r\nCAS号：91270-74-5\r\n相对分子质量：245.06\r\n化学类别：91270-74-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化磷。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：误服或吸入会中毒。对皮肤、眼睛和粘膜有刺激性和腐蚀性。与水或水蒸气发生反应释出有毒性和易燃的蒸气。\r\n危险特性：可燃。遇水或水蒸气反应放出有毒和易燃的气体。\r\n', '强氧化剂、强碱、潮湿空气。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (289, '2524-03-0', '81131', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所\0', 'O,O\'-dimethylthiophosphoryl chloride', 'C2H6ClO2PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', 'O,O\'-二甲基硫代磷酰氯', '外观与性状：无色或微黄色液体，有令人窒息的刺激性气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.33\r\n沸点(℃)：66/2.13kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.32/40℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于苯、氯仿、乙醚、等多数有机溶剂。\r\n主要用途：用于合成有机磷杀虫剂。\r\n主要成分：纯品\r\nCAS号：2524-03-0\r\n相对分子质量：160.56\r\n化学类别：2524-03-0\r\n燃烧性：可燃\r\n闪点：105\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氯化氢、氧化硫、磷烷。\r\n急性毒性：LD50：1800mg/kg(小鼠经口)\r\nLC50：340mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，有毒，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：过量接触刺激上呼吸道。高浓度对肺有刺激性，出现咳嗽、不适、呼吸困难等。患呼吸系统疾病者，对本毒物的敏感性增加。\r\n危险特性：遇明火、高热可燃。当加热到 120℃以上时，开始急剧分解。若遇高热可发生剧烈分解，引起容器破裂或爆炸事故。遇水或醇分解释出有毒烟雾。具有腐蚀性。\r\n', '强氧化剂、强碱。', '739', '有机酰卤', '2267', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (290, '2524-04-1', '81132', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所\0', 'O,O\'-diethylthiophosphoryl chloride；diethyl chlor', 'C4H10ClO2PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', 'O,O\'-二乙基硫代磷酰氯', '外观与性状：无色透明液体。\r\n熔点(℃)：-75\r\n相对密度(水=1)：1.20\r\n沸点(℃)：85/1.33kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.68/70℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于苯、乙醚、脂肪、等多数有机溶剂。\r\n主要用途：用于合成农药。\r\n主要成分：纯品\r\nCAS号：2524-04-1\r\n相对分子质量：188.61\r\n化学类别：2524-04-1\r\n燃烧性：可燃\r\n闪点：110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氧化硫、氯化氢、氧化磷。\r\n急性毒性：LD50：1340mg/kg(大鼠经口)\r\nLC50：20ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而死亡。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。撞击能引起爆炸。遇水反应产生有毒和腐蚀性的烟雾。\r\n', '强氧化剂、水、强碱。', '800', '未指定的化学类别', '2751', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (291, '78-86-4', '32033', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧\0', '2-chlorobutane；sec-butylchloride', 'C4H9Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统\0', '2-氯丁烷；仲丁基氯', '外观与性状：无色透明液体，有类似醚的气味。\r\n熔点(℃)：-131.3\r\n相对密度(水=1)：0.87\r\n沸点(℃)：68.2\r\n相对密度(空气=1)：3.2\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：247.5\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、乙醚、氯仿、等多数有机溶剂。\r\n主要用途：用于有机合成，及用作溶剂。\r\n主要成分：纯品\r\nCAS号：78-86-4\r\n相对分子质量：92.57\r\n化学类别：78-86-4\r\n燃烧性：易燃\r\n闪点：<0\r\n引燃温度：\r\n爆炸下限：1.8\r\n爆炸上限：10.1\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：17460mg/kg(大鼠经口)；20000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害，对眼睛、皮肤有刺激性。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受高热分解产生有毒的腐蚀性烟气。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱。', '759', '卤代烷', '1127', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (292, '80-10-4', '81133', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾\0', 'diphenyldichlorosilane', 'C12H10Cl2Si', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '二苯二氯硅烷', '外观与性状：无色液体，有刺激性气味，易潮解。\r\n熔点(℃)：-22\r\n相对密度(水=1)：1.19\r\n沸点(℃)：305.2\r\n相对密度(空气=1)：8.45\r\n饱和蒸气压(kPa)：0.27/125℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于多数有机溶剂。\r\n主要用途：用于制造硅酮润滑脂。\r\n主要成分：纯品\r\nCAS号：80-10-4\r\n相对分子质量：245.22\r\n化学类别：80-10-4\r\n燃烧性：可燃\r\n闪点：142\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化硅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气对呼吸道有强烈刺激性。皮肤或眼接触可致灼伤。口服灼伤口腔和消化道。\r\n危险特性：可燃。与氧化剂接触猛烈反应。受热分解或接触酸、酸雾能散发出有毒的烟雾。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、水。', '757', '卤代硅烷', '1769', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (293, '18171-74-9', '81133', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类\0', 'tert-butyltrichlorosilane', 'C4H9Cl3Si', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '叔丁基三氯硅烷', '外观与性状：白色结晶。\r\n熔点(℃)：97~100\r\n相对密度(水=1)：1.16\r\n沸点(℃)：132~134\r\n相对密度(空气=1)：6.4\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、乙醚、等多数有机溶剂。\r\n主要用途：用于制造硅酮。\r\n主要成分：纯品\r\nCAS号：18171-74-9\r\n相对分子质量：191.56\r\n化学类别：18171-74-9\r\n燃烧性：易燃\r\n闪点：40\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化硅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：该物质对粘膜、上呼吸道、眼、皮肤等组织有极强的破坏作用。吸入后可能因喉、支气管的炎症、水肿、痉挛，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心、呕吐。\r\n危险特性：遇明火、高热易燃。与氧化剂接触猛烈反应。遇水或水蒸气发生剧烈反应释出有刺激性和腐蚀性的氯化氢烟雾。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、酸类、强碱、酸酐。', '757', '卤代硅烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (294, '107-72-2', '81133', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中\0', 'pentyl trichloro silane；amyl trichlorosilane', 'C5H11Cl3Si', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至\0', '戊基三氯硅烷', '外观与性状：无色透明液体, 带有刺激性臭味, 遇水分解。\r\n熔点(℃)：\r\n相对密度(水=1)：1.14(20℃)\r\n沸点(℃)：169.2\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于多数有机溶剂。\r\n主要用途：制备高分子有机硅化合物。\r\n主要成分：纯品\r\nCAS号：107-72-2\r\n相对分子质量：205.59\r\n化学类别：107-72-2\r\n燃烧性：易燃\r\n闪点：30\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化硅。\r\n急性毒性：LD50：2340mg/kg(大鼠经口)；889mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：氯硅烷类单体对眼、上呼吸道粘膜有强烈刺激性。局部可出现充血、水肿，甚至坏死。长时间接触高浓度，可引起鼻粘膜萎缩、支气管炎、肺充血和肺水肿。粘膜和皮肤接触其液体，可致灼伤。可引起皮炎。\r\n危险特性：遇明火、高热易燃。燃烧时，放出有毒气体。与氧化剂接触猛烈反应。遇水或水蒸气发生剧烈反应释出有刺激性和腐蚀性的氯化氢烟雾。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、强碱、潮湿空气。', '757', '卤代硅烷', '1728', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (295, '98-12-4', '81133', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气\0', 'cyclohexyltrichlorosilane；monocyclohexyl trichlor', 'C6H11Cl3Si', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '环己三氯硅烷', '外观与性状：无色液体，带有刺激性气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.20(25℃)\r\n沸点(℃)：208\r\n相对密度(空气=1)：7.5\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于有机硅化合物制造。\r\n主要成分：纯品\r\nCAS号：98-12-4\r\n相对分子质量：217.59\r\n化学类别：98-12-4\r\n燃烧性：可燃\r\n闪点：85\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化硅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品的蒸气对皮肤、眼睛和粘膜有强烈的刺激性。遇水或水蒸气释放出的氯化氢气体有刺激性和腐蚀性。\r\n危险特性：可燃。燃烧时，放出有毒气体。遇火焰、热源或氧化剂有中等程度的爆炸危险。遇水或水蒸气发生剧烈反应释出有刺激性和腐蚀性的氯化氢烟雾。遇潮时对大多数金属有强腐蚀性。\r\n', '强氧化剂、潮湿空气。', '757', '卤代硅烷', '1763', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (296, '76-86-8', '81133', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、接触。尤其要注意避免与水接触。搬运时要轻装轻\0', 'triphenylchlorosilane；chloro triphenylsilane', 'C18H15ClSi', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '三苯基氯硅烷', '外观与性状：白色固体, 易水解。\r\n熔点(℃)：88-89\r\n相对密度(水=1)：\r\n沸点(℃)：378\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于多数有机溶剂。\r\n主要用途：用作制造高分子有机硅的原料。\r\n主要成分：纯品\r\nCAS号：76-86-8\r\n相对分子质量：294.86\r\n化学类别：76-86-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硅、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：氯硅烷类单体对眼、上呼吸道粘膜有强烈刺激性。局部可出现充血、水肿，甚至坏死。长时间接触高浓度，可引起鼻粘膜萎缩、支气管炎、肺充血和肺水肿。可致眼和皮肤灼伤。\r\n危险特性：可燃。燃烧时，放出有毒气体。遇水或水蒸气发生剧烈反应释出有刺激性和腐蚀性的氯化氢烟雾。遇潮时具有强腐蚀性。\r\n', '强氧化剂、潮湿空气。', '761', '卤代炔', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (297, '10039-54-0', '81508', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的\0', 'hydroxylamine sulfate；oxammonium sulfate', 'H8N2O6S', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '硫酸羟胺；硫酸胲', '外观与性状：无色结晶。\r\n熔点(℃)：172\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、微溶于乙醇。\r\n主要用途：用作分析试剂，还原剂，影片、照相洗印药，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：10039-54-0\r\n相对分子质量：164.15\r\n化学类别：10039-54-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化硫、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与还原剂、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品系高铁血红蛋白形成剂。吸入或口服后，可出现紫绀、惊厥和昏迷。对眼和皮肤有刺激性。\r\n危险特性：强还原剂。遇热能分解形成有腐蚀性并易爆炸的烟雾。与氧化剂接触猛烈反应。8%的硫酸羟胺水溶液加热至90℃时即发生爆炸性分解。具有腐蚀性。\r\n', '强还原剂。', '762', '脂肪胺', '2865', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (298, '10026-12-7', '81515', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免产生粉尘。避免与酸类、接触。尤其要注意避免与水接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空\0', 'niobium pentachloride；columbium pentachloride', 'NbCl5', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收或运至废物处理场所处置。', '五氯化铌；氯化钶', '外观与性状：淡黄色晶状固体, 潮解性极强。\r\n熔点(℃)：194\r\n相对密度(水=1)：2.75\r\n沸点(℃)：241\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醇、浓盐酸。\r\n主要用途：用作试剂、制造纯铌的原料、中间体。\r\n主要成分：纯品\r\nCAS号：10026-12-7\r\n相对分子质量：270.19\r\n化学类别：10026-12-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：1400mg/kg(大鼠经口)；829mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：目前，尚未见引起人中毒的报告。粉尘和蒸气对皮肤、眼睛和粘膜有刺激性。\r\n危险特性：遇水或水蒸气发生剧烈反应释出有刺激性和腐蚀性的氯化氢烟雾。具有腐蚀性。\r\n', '强酸、潮湿空气。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (299, '7721-01-9', '81516', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿橡胶耐酸碱服，戴橡胶耐酸碱手套。避免产生粉尘。避免与碱类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容\0', 'tantalum chloride；tantalum pentachloride', 'TaCl5', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防酸碱工作服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '五氯化钽；氯化钽', '外观与性状：淡黄色晶状粉末, 易潮解。\r\n熔点(℃)：221\r\n相对密度(水=1)：3.68\r\n沸点(℃)：239.3\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于醇、王水及浓硫酸、氯仿、四氯化碳、二硫化碳、微溶于乙醇。\r\n主要用途：用于医药，用作纯金属钽的原料、中间体、有机物氯化剂。\r\n主要成分：纯品\r\nCAS号：7721-01-9\r\n相对分子质量：358.21\r\n化学类别：7721-01-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：氯化氢。\r\n急性毒性：LD50：1900mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与碱类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有毒。遇水能产生氯化氢，对皮肤和粘膜有刺激作用。\r\n危险特性：遇水反应产生有毒和腐蚀性的烟雾。遇潮时对大多数金属有腐蚀性。具有腐蚀性。\r\n', '强碱、潮湿空气。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (300, '96-37-7', '32011', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'methylcyclopentane', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '甲基环戊烷', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：-142.5\r\n相对密度(水=1)：0.75\r\n沸点(℃)：71.8\r\n相对密度(空气=1)：2.9\r\n饱和蒸气压(kPa)：13.33(17.9℃)\r\n燃烧热(kJ/mol)：3920.4\r\n临界温度(℃)：259.5\r\n临界压力(MPa)：3.79\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、乙醚、苯、丙酮、等多数有机溶剂。\r\n主要用途：用作溶剂及色谱分析标准物质，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：96-37-7\r\n相对分子质量：84.16\r\n化学类别：96-37-7\r\n燃烧性：易燃\r\n闪点：-18\r\n引燃温度：258\r\n爆炸下限：1.0\r\n爆炸上限：8.4\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。其蒸气或雾对眼睛、皮肤、粘膜和上呼吸道有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。高速冲击、流动、激荡后可因产生静电火花放电引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '2298', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (301, '75-79-6', '32186', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸气释放到工作场所空气中。避\0', 'methyltrichlorosilane；methyl silicochloroform', 'CH3Cl3Si', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '甲基三氯硅烷；甲基硅仿', '外观与性状：无色液体，具有刺鼻恶臭，易潮解。\r\n熔点(℃)：-90\r\n相对密度(水=1)：1.28\r\n沸点(℃)：66.5\r\n相对密度(空气=1)：5.17\r\n饱和蒸气压(kPa)：20.0(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、醚。\r\n主要用途：用于制造硅酮化合物。\r\n主要成分：纯品\r\nCAS号：75-79-6\r\n相对分子质量：149.46\r\n化学类别：75-79-6\r\n燃烧性：易燃\r\n闪点：-9\r\n引燃温度：>404\r\n爆炸下限：7.6\r\n爆炸上限：20.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、氧化硅、氯化氢、光气。\r\n急性毒性：LD50：\r\nLC50：2740mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道和眼结膜有强烈刺激作用。接触者可有流泪、咳嗽、头痛、恶心、呕吐、喘息、易激动、皮肤发痒等症状。吸入后可因喉、支气管的痉挛、水肿，化学性肺炎、肺水肿而致死。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热或遇水分解放热, 放出有毒的腐蚀性烟气。具有腐蚀性。\r\n', '强酸、强碱、强氧化剂、水。', '757', '卤代硅烷', '1250', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (302, '3188-13-4', '32090', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'chloromethyl ethyl ether', 'C3H7ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制\0', '氯甲基乙醚', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.02\r\n沸点(℃)：82\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：3188-13-4\r\n相对分子质量：94.54\r\n化学类别：3188-13-4\r\n燃烧性：易燃\r\n闪点：-6\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '通常商品加有稳定剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇高热、明火、氧化剂有引起燃烧的危险。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。遇潮气、水份分解出有毒的甲醛气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、酸类。', '770', '醚', '2354', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (303, '79-22-1', '32150', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（全面罩）。必要时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'methyl chloroformate；methyl chlorocarbonate', 'C2H3ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂\0', '氯甲酸甲酯；氯碳酸甲酯', '外观与性状：无色液体，有强烈刺激性气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.22\r\n沸点(℃)：71.4\r\n相对密度(空气=1)：3.26\r\n饱和蒸气压(kPa)：16.93(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于苯、甲醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成及制造杀虫剂，也用于制取催泪性毒气。\r\n主要成分：纯品\r\nCAS号：79-22-1\r\n相对分子质量：94.50\r\n化学类别：79-22-1\r\n燃烧性：易燃\r\n闪点：18～23\r\n引燃温度：504\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：50mg/kg(大鼠经口)；7120mg/kg(兔经皮)\r\nLC50：338mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与酸类、碱类、醇类、胺类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对呼吸道、眼结膜有剧烈刺激作用。人接触后表现为眼及上呼吸道刺激及表皮灼伤。较高浓度时发生肺水肿。本品刺激强度为氯气的5倍。涂于豚鼠皮肤引起深度坏死及形成焦痂。与兔眼接触造成永久性角膜损害。\r\n危险特性：遇明火、高热易引起燃烧，并放出有毒气体。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。具有腐蚀性。\r\n', '酸类、强碱、醇类、胺类、水。', '749', '羧酸酯', '1238', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (304, '541-41-3', '32151', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（半面罩）。必要时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'ethyl chloroformate；ethyl chlorocarbonate', 'C3H5ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '氯甲酸乙酯；氯碳酸乙酯', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：-80.6\r\n相对密度(水=1)：1.14\r\n沸点(℃)：94\r\n相对密度(空气=1)：3.74\r\n饱和蒸气压(kPa)：7.06(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于苯、氯仿、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成及用作溶剂。\r\n主要成分：纯品\r\nCAS号：541-41-3\r\n相对分子质量：108.53\r\n化学类别：541-41-3\r\n燃烧性：易燃\r\n闪点：16\r\n引燃温度：500\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、光气。\r\n急性毒性：LD50：50mg/kg(大鼠经口)；7120mg/kg(兔经皮)\r\nLC50：646mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与酸类、碱类、醇类、胺类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：人接触后主要中毒表现为眼及上呼吸道刺激；高浓度时可发生肺水肿。涂于豚鼠皮肤引起深度坏死及形成焦痂。与兔眼接触造成永久性角膜损害。\r\n危险特性：遇明火、高热易引起燃烧，并放出有毒气体。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。具有腐蚀性。\r\n', '酸类、强碱、水、醇类、胺类。', '749', '羧酸酯', '1182', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (305, '108-23-6', '32152', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（半面罩）。必要时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸\0', 'isopropyl chloroformate', 'C4H7ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂\0', '氯甲酸异丙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.08\r\n沸点(℃)：104.6\r\n相对密度(空气=1)：4.2\r\n饱和蒸气压(kPa)：2.80(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醚。\r\n主要用途：用作农药中间体。\r\n主要成分：纯品\r\nCAS号：108-23-6\r\n相对分子质量：122.55\r\n化学类别：108-23-6\r\n燃烧性：易燃\r\n闪点：-11\r\n引燃温度：\r\n爆炸下限：4.0\r\n爆炸上限：15.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：100mg/kg(大鼠经口)\r\nLC50：1504mg/m3，1小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：人接触后中毒表现为眼及上呼吸道刺激；高浓度时可发生肺水肿。涂于豚鼠皮肤引起深度坏死及形成焦痂。与兔眼接触造成永久性角膜损害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解能放出剧毒的光气。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、水。', '749', '羧酸酯', '2407', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (306, '110-91-8', '33617', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸\0', 'morpholine；diethylene oximide', 'C4H9NO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', '吗啉；1,4-氧氮杂环己烷', '外观与性状：无色油状液体，有氨味。\r\n熔点(℃)：-4.6\r\n相对密度(水=1)：1.00\r\n沸点(℃)：128.4\r\n相对密度(空气=1)：3.0\r\n饱和蒸气压(kPa)：0.93(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：346\r\n临界压力(MPa)：\r\n辛醇/水分配系数：-0.86\r\n溶解性：与水混溶、可混溶于多数有机溶剂。\r\n主要用途：用作分析试剂，及树脂、蜡类、虫胶等的溶剂。\r\n主要成分：纯品\r\nCAS号：110-91-8\r\n相对分子质量：87.12\r\n化学类别：110-91-8\r\n燃烧性：易燃\r\n闪点：35\r\n引燃温度：310\r\n爆炸下限：1.8\r\n爆炸上限：10.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1050mg/kg(大鼠经口)；500mg/kg(兔经皮)\r\nLC50：28480mg/m3，8小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气或雾强烈刺激呼吸道粘膜，可引起支气管炎、肺炎、肺水肿。高浓度吸入可致死。蒸气、雾或液体对眼有强烈刺激性，严重者可导致失明。皮肤接触可发生灼伤。吞咽本品液体可灼伤消化道，大量吞咽可致死。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。\r\n', '酸类、酰基氯、酸酐、强氧化剂。', '800', '未指定的化学类别', '2054', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (307, '8006-61-9', '31001', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。灌装时应控制流速，且有接地装置，防\0', 'Gasoline；Petrol', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。或在保证安全情况下，就地焚烧。大量泄漏\0', '汽油', '外观与性状：无色或淡黄色易挥发液体, 具有特殊臭味。\r\n熔点(℃)：<-60\r\n相对密度(水=1)：0.70～0.79\r\n沸点(℃)：40～200\r\n相对密度(空气=1)：3.5\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于苯、二硫化碳、醇、脂肪。\r\n主要用途：主要用作汽油机的燃料, 用于橡胶、制鞋、印刷、制革、颜料等行业, 也可用作机械零件的去污剂。\r\n主要成分：C4～C12脂肪烃和环烷烃。\r\nCAS号：8006-61-9\r\n相对分子质量：\r\n化学类别：8006-61-9\r\n燃烧性：易燃\r\n闪点：-50\r\n引燃温度：415～530\r\n爆炸下限：1.3\r\n爆炸上限：6.0\r\n最小点火能：\r\n最大爆炸压力：0.813\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：67000mg/kg(小鼠经口)(120号溶剂汽油)\r\nLC50：103000mg/m3，2小时(小鼠吸入)(120号溶剂汽油)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒：对中枢神经系统有麻醉作用。轻度中毒症状有头晕、头痛、恶心、呕吐、步态不稳、共济失调。高浓度吸入出现中毒性脑病。极高浓度吸入引起意识突然丧失、反射性呼吸停止。可伴有中毒性周围神经病及化学性肺炎。部分患者出现中毒性精神病。液体吸入呼吸道可引起吸入性?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '1203', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (308, '111-84-2', '33505', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。灌装时应控制流速，\0', 'nonane', 'C9H20', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，\0', '壬烷；正壬烷', '外观与性状：无色透明液体。\r\n熔点(℃)：-51\r\n相对密度(水=1)：0.72\r\n沸点(℃)：150.8\r\n相对密度(空气=1)：4.4\r\n饱和蒸气压(kPa)：1.33(39℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、可混溶于苯、丙酮、氯仿。\r\n主要用途：用作色谱分析标准物质、溶剂，用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-84-2\r\n相对分子质量：128.26\r\n化学类别：111-84-2\r\n燃烧性：易燃\r\n闪点：31\r\n引燃温度：205\r\n爆炸下限：0.7\r\n爆炸上限：5.6\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：16768mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：大鼠吸入8100mg/m3浓度引起轻度震颤、共济矢调和眼刺激。无人的资料。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (309, '17392-83-5', '33602', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：高浓度环境中，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl lactate', 'C4H8O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '乳酸甲酯；2-羟基丙酸甲酯', '外观与性状：无色液体。\r\n熔点(℃)：-66.2\r\n相对密度(水=1)：1.09\r\n沸点(℃)：144.8\r\n相对密度(空气=1)：3.6\r\n饱和蒸气压(kPa)：12(42℃)\r\n燃烧热(kJ/mol)：2078.3\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、多数有机溶剂。\r\n主要用途：用作纤维素、油漆、染色素的溶剂。\r\n主要成分：纯品\r\nCAS号：17392-83-5\r\n相对分子质量：104.10\r\n化学类别：17392-83-5\r\n燃烧性：易燃\r\n闪点：49\r\n引燃温度：385\r\n爆炸下限：2.2(100℃)\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。具有刺激性。\r\n危险特性：易燃，遇明火、高热能引起燃烧爆炸。与强氧化剂发生反应, 可引起燃烧。\r\n', '强氧化剂、强酸、强碱、水、空气。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (310, '687-47-8', '33602', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：高浓度环境中，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethyl lactate', 'C5H10O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '乳酸乙酯；2-羟基丙酸乙酯', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：-26\r\n相对密度(水=1)：1.02～1.04\r\n沸点(℃)：154\r\n相对密度(空气=1)：4.07\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：2736.6\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于醇、芳烃、酯、烃类、油类。\r\n主要用途：用作纤维素酯、树脂、涂料等的溶剂，也用作香料。\r\n主要成分：纯品\r\nCAS号：687-47-8\r\n相对分子质量：118.13\r\n化学类别：687-47-8\r\n燃烧性：易燃\r\n闪点：46\r\n引燃温度：400\r\n爆炸下限：1.5\r\n爆炸上限：11.4\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2500mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气或雾对鼻、咽喉有刺激作用。蒸气对眼睛有刺激性；眼接触本品液体或雾可能造成灼伤。皮肤较长时间接触有刺激性。大量口服引起恶心、呕吐。\r\n危险特性：易燃，遇明火、高热能引起燃烧爆炸。与强氧化剂发生反应, 可引起燃烧。\r\n', '强氧化剂、酸类、碱类。', '749', '羧酸酯', '1192', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (311, '75-77-4', '32186', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止烟雾和蒸\0', 'trimethylchlorosilane', 'C3H9ClSi', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的\0', '三甲基氯硅烷；氯化三甲基硅烷', '外观与性状：无色至淡黄色透明液体。\r\n熔点(℃)：-40\r\n相对密度(水=1)：0.85\r\n沸点(℃)：57.6\r\n相对密度(空气=1)：3.7\r\n饱和蒸气压(kPa)：13.33(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、甲醇。\r\n主要用途：用作硅酮油制造的中间体、憎水剂、分析用试剂。\r\n主要成分：纯品\r\nCAS号：75-77-4\r\n相对分子质量：108.64\r\n化学类别：75-77-4\r\n燃烧性：易燃\r\n闪点：-28\r\n引燃温度：\r\n爆炸下限：1.8\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硅、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品极度易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道、眼睛、皮肤粘膜有强烈刺激性。吸入后可因喉、支气管的痉挛、水肿、炎症，化学性肺炎、肺水肿而致死。接触工人往往有眼痛、流泪、咳嗽、头痛、易激动、皮肤发痒等。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热或遇水分解放热, 放出有毒的腐蚀性烟气。具有腐蚀性。\r\n', '强酸、强碱、水。', '759', '卤代烷', '1298', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (312, '123-63-7', '33576', '监测方法：\r\n工程控制：密闭操作，注意通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'paraldehyde', 'C6H12O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '三聚乙醛', '外观与性状：无色油状液体，有芳香的气味。\r\n熔点(℃)：12.6\r\n相对密度(水=1)：0.99\r\n沸点(℃)：124.0\r\n相对密度(空气=1)：4.55\r\n饱和蒸气压(kPa)：1.33(24℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：290.0\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作溶剂，以及用于有机合成，橡胶促进剂和抗氧剂制造等。\r\n主要成分：纯品\r\nCAS号：123-63-7\r\n相对分子质量：132.16\r\n化学类别：123-63-7\r\n燃烧性：易燃\r\n闪点：27\r\n引燃温度：235\r\n爆炸下限：1.3\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1530mg/kg(大鼠经口)；14000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害，对粘膜和呼吸道有刺激作用，中毒表现有头痛、困倦、支气管炎。\r\n危险特性：易燃，遇明火有引起燃烧的危险。受高热分解放出有毒的气体。与氧化剂接触猛烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱、氢氰酸、塑料、橡胶。', '773', '醛', '1264', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (313, '121-44-8', '32168', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴导管式防毒面具。紧急事态抢救或撤离时，应该佩戴氧气呼吸器、空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。充装\0', 'triethylamine；N,N-diethylethanamine', 'C6H15N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀\0', '三乙胺；N,N-二乙基乙胺', '外观与性状：无色油状液体，有强烈氨臭。\r\n熔点(℃)：-114.8\r\n相对密度(水=1)：0.70\r\n沸点(℃)：89.5\r\n相对密度(空气=1)：3.48\r\n饱和蒸气压(kPa)：8.80(20℃)\r\n燃烧热(kJ/mol)：4333.8\r\n临界温度(℃)：259\r\n临界压力(MPa)：3.04\r\n辛醇/水分配系数：1.45\r\n溶解性：微溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作溶剂、阻聚剂、防腐剂，及合成染料等。\r\n主要成分：纯品\r\nCAS号：121-44-8\r\n相对分子质量：101.19\r\n化学类别：121-44-8\r\n燃烧性：易燃\r\n闪点：<0\r\n引燃温度：249\r\n爆炸下限：1.2\r\n爆炸上限：8.0\r\n最小点火能：0.75\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：460mg/kg(大鼠经口)；570mg/kg(兔经皮)\r\nLC50：6000mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道有强烈的刺激性，吸入后可引起肺水肿甚至死亡。口服腐蚀口腔、食道及胃。眼及皮肤接触可引起化学性灼伤。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。具有腐蚀性。\r\n', '强氧化剂、酸类。', '762', '脂肪胺', '1296', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (314, '102-69-2', '33618', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'tri-n-propylamine；N,N-dipropanamine', 'C9H21N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '三正丙胺', '外观与性状：无色液体，有氨的气味。\r\n熔点(℃)：-93\r\n相对密度(水=1)：0.75\r\n沸点(℃)：156\r\n相对密度(空气=1)：4.9\r\n饱和蒸气压(kPa)：0.39(20℃)\r\n燃烧热(kJ/mol)：6335.7\r\n临界温度(℃)：320.9\r\n临界压力(MPa)：2.23\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醚、易溶于乙醇。\r\n主要用途：为有机合成中间体，用于制取全氟化人造血浆和石油化工季胺分子筛催化剂等。\r\n主要成分：纯品\r\nCAS号：102-69-2\r\n相对分子质量：143.27\r\n化学类别：102-69-2\r\n燃烧性：易燃\r\n闪点：36\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：72mg/kg(大鼠经口)；429mg/kg(兔经皮)\r\nLC50：5100mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。具有腐蚀性。\r\n', '强氧化剂、酸类。', '762', '脂肪胺', '2260', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (315, '102-82-9', '82510', '监测方法：\r\n工程控制：密闭操作，注意通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'tri-n-butylamine', 'C12H27N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑\0', '三正丁胺', '外观与性状：无色液体，有类似氨的气味。\r\n熔点(℃)：-70\r\n相对密度(水=1)：0.78\r\n沸点(℃)：216.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.32(55℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作溶剂、中间体、杀虫剂、乳化剂等。\r\n主要成分：纯品\r\nCAS号：102-82-9\r\n相对分子质量：185.35\r\n化学类别：102-82-9\r\n燃烧性：易燃\r\n闪点：86\r\n引燃温度：210\r\n爆炸下限：1.4\r\n爆炸上限：6.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：540mg/kg(大鼠经口)；250mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.2类  碱性腐蚀品\r\n危险性综述：本品易燃，具腐蚀性、强刺激性，可致人体灼伤，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。可致灼伤。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热易引起燃烧爆炸。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、酸类、酰基氯、酸酐。', '762', '脂肪胺', '2542', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (316, '91-17-8', '33550', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：高浓度环境中，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'decahydronaphthalene；Naphthane', 'C10H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '十氢萘；萘烷', '外观与性状：无色液体，有芳香气味。\r\n熔点(℃)：-43.3(顺)\r\n相对密度(水=1)：0.89(顺)\r\n沸点(℃)：194.6(顺)\r\n相对密度(空气=1)：4.76\r\n饱和蒸气压(kPa)：0.13(22.5℃)\r\n燃烧热(kJ/mol)：6280.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作油、脂、树脂、橡胶等的溶剂和除漆剂，润滑剂。\r\n主要成分：纯品\r\nCAS号：91-17-8\r\n相对分子质量：138.25\r\n化学类别：91-17-8\r\n燃烧性：易燃\r\n闪点：54\r\n引燃温度：255\r\n爆炸下限：0.7(100℃)\r\n爆炸上限：5.4(100℃)\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4170mg/kg(大鼠经口)；5900mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤粘膜有刺激性，有麻醉作用。吸入后可引起呼吸道刺激、头痛、头晕。液体或高浓度蒸气对眼有刺激性。慢性影响：长期接触可引起周围神经病。对胃肠道有影响。皮肤接触可引起小水疱、湿疹、皮肤脱脂。对肾脏可能有影响。\r\n危险特性：易燃，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。\r\n', '强氧化剂。', '800', '未指定的化学类别', '1147', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (317, '8030-30-6', '32004', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧\0', 'Crude oil', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '石脑油；粗汽油', '外观与性状：无色或浅黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.78～0.97\r\n沸点(℃)：20～160\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：可分离出多种有机原料，如汽油、苯、煤油、沥青等。\r\n主要成分：主要为烷烃的C4～C6成份。\r\nCAS号：8030-30-6\r\n相对分子质量：\r\n化学类别：8030-30-6\r\n燃烧性：易燃\r\n闪点：-2\r\n引燃温度：350\r\n爆炸下限：1.1\r\n爆炸上限：8.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：16000mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：石脑油蒸气可引起眼及上呼吸道刺激症状，如浓度过高，几分钟即可引起呼吸困难、紫绀等缺氧症状。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '800', '未指定的化学类别', '1256', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (318, '8032-32-4', '32002', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'Petroleum ether', NULL, NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '石油醚；石油精', '外观与性状：无色透明液体，有煤油气味。\r\n熔点(℃)：<-73\r\n相对密度(水=1)：0.64～0.66\r\n沸点(℃)：40～80\r\n相对密度(空气=1)：2.50\r\n饱和蒸气压(kPa)：53.32(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于无水乙醇、苯、氯仿、油类、等多数有机溶剂。\r\n主要用途：主要用作溶剂及作为油脂的抽提用。\r\n主要成分：戊烷、己烷。\r\nCAS号：8032-32-4\r\n相对分子质量：\r\n化学类别：8032-32-4\r\n燃烧性：易燃\r\n闪点：<-20\r\n引燃温度：280\r\n爆炸下限：1.1\r\n爆炸上限：8.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：40mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过25℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品极度易燃，具强刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：其蒸气或雾对眼睛、粘膜和呼吸道有刺激性。中毒表现可有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。本品可引起周围神经炎。对皮肤有强烈刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。燃烧时产生大量烟雾。与氧化剂能发生强烈反应。高速冲击、流动、激荡后可因产生静电火花放电引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '800', '未指定的化学类别', '1271', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (319, '75-64-9', '32172', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴导管式防毒面具。紧急事态抢救或撤离时，应该佩戴氧气呼吸器、空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。充装\0', 'tert-butylamine；1,1-dimethylethylamine', 'C4H11N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀\0', '叔丁胺；1,1-二甲基乙胺', '外观与性状：无色液体，有氨味。\r\n熔点(℃)：-72.6\r\n相对密度(水=1)：0.69\r\n沸点(℃)：44.5\r\n相对密度(空气=1)：2.5\r\n饱和蒸气压(kPa)：45.32(25℃)\r\n燃烧热(kJ/mol)：2992.9\r\n临界温度(℃)：210.8\r\n临界压力(MPa)：3.84\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于无水乙醇、苯、氯仿、乙醚、等多数有机溶剂。\r\n主要用途：用作橡胶促进剂、化学试剂及合成药品、染料、杀虫剂等。\r\n主要成分：纯品\r\nCAS号：75-64-9\r\n相对分子质量：73.14\r\n化学类别：75-64-9\r\n燃烧性：易燃\r\n闪点：-8.8\r\n引燃温度：380\r\n爆炸下限：1.7\r\n爆炸上限：8.9\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：78mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收可能致死。对眼睛、皮肤、粘膜和呼吸道有强烈刺激作用。吸入后可引起喉、支气管的痉挛、水肿，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。具有腐蚀性。\r\n', '强氧化剂、强酸、酸类。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (320, '75-65-0', '32066', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、\0', 'tert-butyl alcohol；trimethyl carbinol', 'C4H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。若是液体，尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放\0', '叔丁醇；三甲基甲醇', '外观与性状：无色结晶或液体，有樟脑气味。\r\n熔点(℃)：25.3\r\n相对密度(水=1)：0.79\r\n沸点(℃)：82.8\r\n相对密度(空气=1)：2.55\r\n饱和蒸气压(kPa)：5.33(24.5℃)\r\n燃烧热(kJ/mol)：2630.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.37\r\n溶解性：溶于水、醇、醚。\r\n主要用途：用于有机合成，制造香精等。\r\n主要成分：纯品\r\nCAS号：75-65-0\r\n相对分子质量：74.12\r\n化学类别：75-65-0\r\n燃烧性：易燃\r\n闪点：11\r\n引燃温度：470\r\n爆炸下限：2.3\r\n爆炸上限：8.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入或口服对身体有害。对眼睛、皮肤、粘膜和呼吸道有刺激作用。中毒表现可有头痛、恶心、眩晕。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、酸酐、强氧化剂。', '789', '醇', '1120', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (321, '558-17-8', '32048', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触毒物时，应该佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意检测毒物。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'tert-butyl iodide；trimethyliodomethane', 'C4H9I', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖\0', '叔丁基碘；碘叔丁烷', '外观与性状：无色或带微黄色液体。\r\n熔点(℃)：-34\r\n相对密度(水=1)：1.57(0℃)\r\n沸点(℃)：99～100(部分分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：用于分析及用于有机合成。\r\n主要成分：纯品\r\nCAS号：558-17-8\r\n相对分子质量：184.02\r\n化学类别：558-17-8\r\n燃烧性：易燃\r\n闪点：7\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，遇明火、高热、或与氧化剂接触能燃烧, 并散发出有毒气体。受热分解放出有毒的碘化物烟气。\r\n', '强氧化剂、强酸、强碱。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (322, '1345-04-6', '61506', '监测方法：火焰原子吸收光谱法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：作业工人应该佩戴自吸过滤式防尘口罩。必要时，佩戴空气呼吸器、氧气呼吸器或长管面具。\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接\0', 'antimony trisulfide；antimonous sulfide', 'Sb2S3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '三硫化锑；三硫化二锑', '外观与性状：红色粉末。\r\n熔点(℃)：546\r\n相对密度(水=1)：4.62\r\n沸点(℃)：550\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于盐酸。\r\n主要用途：用于制颜料、烟火、火柴等。\r\n主要成分：纯品\r\nCAS号：1345-04-6\r\n相对分子质量：339.68\r\n化学类别：1345-04-6\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气、受热。\r\n燃烧(分解)产物：氧化硫、硫化氢、氧化锑。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：IARC致癌性评论：动物致癌证据有限，人类致癌缺乏证据。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：接触锑及其化合物可致眼结膜和呼吸道刺激，发生支气管炎，较重者出现胸痛、呼吸困难、肺炎。口服中毒有急性胃肠炎，肝、肾及心肌损害。慢性影响：长期接触低浓度锑化合物粉尘可致鼻炎，鼻中隔穿孔，支气管炎，口腔炎，消化功能障碍。可致皮肤损害。\r\n危险特性：与氧化剂接触, 有引起燃烧爆炸的危险。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '氧化剂、酸类。', '783', '硫化物', '1549', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (323, '10325-94-7', '51522', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。搬运时要轻装轻卸，防止包装及容器损坏。配备相\0', 'cadmium nitrate；cadmium dinitrate', 'Cd(NO3)2.4H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸镉', '外观与性状：无色针状或棱形晶体, 有吸潮性, 在空气中会潮解。\r\n熔点(℃)：59.4\r\n相对密度(水=1)：2.46\r\n沸点(℃)：132\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、丙酮、乙酸。\r\n主要用途：用于制瓷器和玻璃上色等。\r\n主要成分：含量: 工业级 二级≥99.0％; 三级≥98.5％。\r\nCAS号：10325-94-7\r\n相对分子质量：308.49\r\n化学类别：10325-94-7\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：100mg/kg(小鼠经口)\r\nLC50：3850mg/m3(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：急性中毒：吸入可引起呼吸道刺激症状，可发生化学性肺炎，肺水肿；误食后可引起急剧的胃肠道刺激症状，有恶心、呕吐、腹泻、腹痛、里急后重、全身乏力、肌肉疼痛和虚脱等，重者可危及生命。慢性中毒：长期接触引起支气管炎，肺气肿，以肾小管病变为主的肾脏损害。重者可发生?\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '易燃或可燃物、硫、磷。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (324, '10099-59-9', '51523', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：保持良好的卫生习惯。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时轻装轻卸，保持包\0', 'lanthanum nitrate', 'La(NO3)3.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸镧', '外观与性状：白色粒状晶体, 易湿解。\r\n熔点(℃)：40\r\n相对密度(水=1)：2.05\r\n沸点(℃)：126\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于乙醇。\r\n主要用途：用于制光学玻璃、萤光粉、陶瓷电容器添加剂、石油精制加工催化剂。\r\n主要成分：含量≥99.0％。\r\nCAS号：10099-59-9\r\n相对分子质量：433.00\r\n化学类别：10099-59-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：4500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃。\r\n侵入途径：吸入。\r\n健康危害：人吸入镧及其化合物烟尘可出现头痛和恶心等症状。大鼠急性镧中毒的症状有立即排便、运动失调、呼吸困难，常因呼吸衰竭或心力衰竭而死亡。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与可燃物的混合物易于着火，并会猛烈燃烧。高温时分解，释出剧毒的氮氧化物气体。\r\n', '还原剂、易燃或可燃物。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (325, '10045-94-0', '61030', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：作业工人应该佩戴自吸过滤式防尘口罩。必要时，佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿连衣式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬\0', 'mercuric nitrate；mercury pernitrate', 'Hg(NO3)2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸汞；硝酸高汞', '外观与性状：无色或白色透明结晶，有潮解性。\r\n熔点(℃)：79\r\n相对密度(水=1)：4.39\r\n沸点(℃)：180(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、不溶于乙醇、溶于硝酸。\r\n主要用途：用作分析试剂，及用于有机合成，药品和雷汞的制造。\r\n主要成分：纯品\r\nCAS号：10045-94-0\r\n相对分子质量：324.63\r\n化学类别：10045-94-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化氮、氧化汞。\r\n急性毒性：LD50：26mg/kg(大鼠经口)；75mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过70％。包装密封。应与易燃物或可燃物、还原剂、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品助燃，高毒，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：汞离子可使含巯基的酶丧失活性，失去功能；还能与酶中的氨基、二巯基、羧基、羟基以及细胞膜内的磷酰基结合，引起相应的损害。急性中毒：有头痛、头晕、乏力、失眠、多梦、口腔炎、发热等全身症状。可有食欲不振、恶心、腹痛、腹泻等。部分患者皮肤出现红色斑丘疹。严重者可?\n危险特性：是一种温和的氧化剂，与有机物、还原剂、硫、磷等混合，易着火燃烧。受热分解产生有毒的烟气。\r\n', '易燃或可燃物、强还原剂、无机物、磷、活性金属粉末、等。', '793', '硝酸盐', '1625', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (326, '506-93-4', '51068', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸\0', 'guanidine nitrate；guanidine mononitrate', 'CH6N4O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸胍；硝酸亚氨脲', '外观与性状：白色颗粒。\r\n熔点(℃)：217\r\n相对密度(水=1)：\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、微溶于丙酮、不溶于苯、乙醚。\r\n主要用途：用于制造炸药、消毒剂、照像化学品等。\r\n主要成分：纯品\r\nCAS号：506-93-4\r\n相对分子质量：122.08\r\n化学类别：506-93-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道具有刺激作用，过量吸入可致死。高温下释放出氮氧化物气体，对呼吸道有刺激性。\r\n危险特性：强氧化剂。受热、接触明火、或受到摩擦、震动、撞击时可发生爆炸。加热至150℃ 时分解并爆炸。与硝基化合物和氯酸盐组成的混合物对震动和摩擦敏感并可能爆炸。受高热分解，产生有毒的氮氧化物。\r\n', '强还原剂、易燃或可燃物、硫、磷。', '746', '硝基烷烃', '1467', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (327, '10294-41-4', '51524', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止\0', 'cerium nitrate；cerous nitrate', 'Ce(NO3)3.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铈；硝酸亚铈', '外观与性状：白色结晶, 工业品呈微红色, 有潮解性。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：200(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、溶于乙醇、丙酮。\r\n主要用途：用于制造煤气灯网罩、药物、试剂，并用于原子能、电子管等工业。\r\n主要成分：纯品\r\nCAS号：10294-41-4\r\n相对分子质量：434.25\r\n化学类别：10294-41-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：4200mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：至今尚未见铈及其化合物职业性中毒的报告。但高浓度时对肝脏有毒性作用。生产中应防止溅入眼内，以免引起眼损害。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (328, '13597-99-4', '51061', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及\0', 'beryllium nitrate；beryllium dinitrate', 'Be(NO3)2.3H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铍', '外观与性状：白色或微黄色结晶, 有潮解性。\r\n熔点(℃)：60\r\n相对密度(水=1)：1.56\r\n沸点(℃)：100～200(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于乙醇。\r\n主要用途：用作化学试剂及用于气灯和乙炔灯罩的硬化。\r\n主要成分：纯品\r\nCAS号：13597-99-4\r\n相对分子质量：187.08\r\n化学类别：13597-99-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：50mg/kg(豚鼠腹腔)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，高毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：短期大量接触，可发生急性铍痛。主要表现为急性化学性肺炎。肝脏往往肿大，有压痛，甚至出现黄疸。口服可溶性铍盐可引起胃粘膜出血坏死。进入眼内可致结膜炎，重者可致灼伤。长期接触小量铍可发生慢性铍病。除有无力、消瘦、食欲不振外，常有胸闷、胸痛、气短和咳嗽。X 线检?\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与易氧化物、硫磺、亚硫酸氢钠、还原剂、强酸接触能引起燃烧或爆炸。受高热分解，产生有毒的氮氧化物。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '2464', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (329, '10035-06-0', '51522', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装\0', 'bismuth nitrate；nitric acid bismuth salt', 'Bi(NO3)3.5H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸铋', '外观与性状：无色透明有光泽结晶, 有吸湿性。\r\n熔点(℃)：30(分解)\r\n相对密度(水=1)：2.83\r\n沸点(℃)：80(失去5H2O)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于稀硝酸、乙醇、丙酮。\r\n主要用途：用于药物和铋盐制造, 用作各种触媒原料。\r\n主要成分：纯品\r\nCAS号：10035-06-0\r\n相对分子质量：485.10\r\n化学类别：10035-06-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激性。至今未发现有职业中毒报导。非职业性中毒可发生肝、肾、中枢神经系统损害及药疹等。\r\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (330, '7789-18-6', '51058', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防\0', 'cesium nitrate；nitric acid cesium salt', 'CsNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '硝酸铯', '外观与性状：白色结晶粉末, 易潮解, 有盐硝味。\r\n熔点(℃)：414\r\n相对密度(水=1)：2.71(500℃)\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于丙酮、微溶于乙醇。\r\n主要用途：用于铯盐制造。\r\n主要成分：纯品\r\nCAS号：7789-18-6\r\n相对分子质量：194.92\r\n化学类别：7789-18-6\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：2390mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激作用。迄今未见中毒的病例报告；工业生产中，也未见有对工人身体健康产生明显损害的报道。\r\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '1451', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (331, '7790-69-4', '51054', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸\0', 'lithium nitrate', 'LiNO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '硝酸锂', '外观与性状：无色三角晶体或白色粉末, 吸湿性强。\r\n熔点(℃)：264\r\n相对密度(水=1)：2.38\r\n沸点(℃)：600(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇。\r\n主要用途：用于制造陶器、烟火、热交换介质、分析试剂等。\r\n主要成分：纯品\r\nCAS号：7790-69-4\r\n相对分子质量：68.94\r\n化学类别：7790-69-4\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物、氧化锂。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激作用。接触后可引起胃痛、恶心、呕吐、头痛、眩晕等，大剂量可引起肾损害。在高温下分解产生剧毒的氮氧化物。\r\n危险特性：强氧化剂。遇可燃物着火时，能助长火势。与易氧化物、硫磺、亚硫酸氢钠、还原剂、强酸接触能引起燃烧或爆炸。燃烧分解时, 放出有毒的氮氧化物气体。受高热分解，产生有毒的氮氧化物。\r\n', '还原剂、易燃或可燃物。', '793', '硝酸盐', '2722', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (332, NULL, '51522', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包\0', 'palladium nitrate；palladous nitrate', 'Pd(NO3)2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '硝酸钯；硝酸亚钯', '外观与性状：棕黄色结晶或粉末, 有潮解性。\r\n熔点(℃)：分解\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于稀硝酸。\r\n主要用途：用作分析试剂, 分离氯和碘, 用作有机合成催化剂。\r\n主要成分：含量≥98.0％。\r\nCAS号：\r\n相对分子质量：230.41\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：迄今未见引起职业中毒的报告。对皮肤有刺激性。热解释出剧毒的氮氧化物气体。\r\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (333, '13478-00-7', '51522', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器\0', 'nickel nitrate', 'Ni(NO3)2.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸镍；硝酸亚镍', '外观与性状：青绿色单斜结晶，易潮解。\r\n熔点(℃)：56.7\r\n相对密度(水=1)：2.05\r\n沸点(℃)：136.7\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇、氨水。\r\n主要用途：用于镀镍及制造镍催化剂。\r\n主要成分：纯品\r\nCAS号：13478-00-7\r\n相对分子质量：290.81\r\n化学类别：13478-00-7\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：1620mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须密封，切勿受潮。应与还原剂、酸类、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入本品粉尘对呼吸道有刺激性，个别敏感者可引起哮喘、支气管炎等。大量口服刺激胃肠道，引起呕吐、腹泻。粉尘对眼有刺激性，水溶液可引起灼伤。皮肤接触可引起皮炎。慢性影响：有皮炎、哮喘、慢性支气管炎、慢性鼻炎等。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。急剧加热时可发生爆炸。\r\n', '强还原剂、强酸。', '793', '硝酸盐', '2725', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (334, NULL, '51522', '监测方法：火焰原子吸收光谱法；催化极谱法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、活性金属粉末、接触。搬运时要\0', 'cobaltous nitrate', 'Co(NO3)2.6H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '硝酸钴；硝酸亚钴', '外观与性状：红色棱形结晶，易潮解。\r\n熔点(℃)：55\r\n相对密度(水=1)：1.87\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、酸。\r\n主要用途：用作颜料、催化剂及用于陶瓷工业。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：291.05\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌缺乏证据。\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、活性金属粉末、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼、呼吸道和皮肤有刺激性。吸入后引起气短、咳嗽等。口服引起腹痛、呕吐。\r\n危险特性：无机氧化剂。在火场中能助长任何燃烧物的火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。在74℃开始分解，放出有毒的氮氧化物。\r\n', '易燃或可燃物、强还原剂、活性金属粉末、硫、磷。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (335, '7758-09-9', '51073', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、活性金属粉末、接触。搬运时要轻装轻卸，\0', 'potassium nitrite', 'KNO2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '亚硝酸钾', '外观与性状：白色至微黄色棱柱形或条状结晶，易潮解。\r\n熔点(℃)：387\r\n相对密度(水=1)：1.92\r\n沸点(℃)：分解\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、不溶于丙酮、微溶于乙醇。\r\n主要用途：用作分析试剂，用于医药及有机合成等。\r\n主要成分：纯品\r\nCAS号：7758-09-9\r\n相对分子质量：85.10\r\n化学类别：7758-09-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：200mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与还原剂、酸类、活性金属粉末、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：口服刺激口腔和胃肠道。大量口服可引起亚硝酸盐中毒，表现有紫绀、血压下降、呼吸困难、恶心、呕吐、头晕、腹痛、心率快、心律不齐、惊厥、昏迷，甚至死亡。吸入本品粉尘对呼吸道有刺激性；高浓度吸入的毒作用类似口服。本品对眼及皮肤有刺激性。\r\n危险特性：无机氧化剂。与有机物、可燃物的混合物能燃烧和爆炸，并放出有毒和刺激性的氧化氮气体。与铵盐、可燃物粉末或氰化物的混合物会爆炸。加热或遇酸能产生剧毒的氮氧化物气体。\r\n', '强还原剂、强酸、活性金属粉末。', '793', '硝酸盐', '1488', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (336, '7632-00-0', '51525', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、活性金属粉末、酸类、接触。搬运时要轻装轻卸，防\0', 'sodium nitrite', 'NaNO2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '亚硝酸钠', '外观与性状：白色或淡黄色细结晶，无臭，略有咸味，易潮解。\r\n熔点(℃)：271\r\n相对密度(水=1)：2.17\r\n沸点(℃)：320(分解)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、微溶于乙醇、甲醇、乙醚。\r\n主要用途：用于染料、医药等的制造，也用于有机合成。\r\n主要成分：含量:工业级 、试剂级均为:  一级≥99.0％;二级≥98.0％。\r\nCAS号：7632-00-0\r\n相对分子质量：69.01\r\n化学类别：7632-00-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：85mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装要求密封，不可与空气接触。应与还原剂、活性金属粉末、酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：毒作用为麻痹血管运动中枢、呼吸中枢及周围血管；形成高铁血红蛋白。急性中毒表现为全身无力、头痛、头晕、恶心、呕吐、腹泻、胸部紧迫感以及呼吸困难；检查见皮肤粘膜明显紫绀。严重者血压下降、昏迷、死亡。接触工人手、足部皮肤可发生损害。\r\n危险特性：无机氧化剂。与有机物、可燃物的混合物能燃烧和爆炸，并放出有毒和刺激性的氧化氮气体。与铵盐、可燃物粉末或氰化物的混合物会爆炸。加热或遇酸能产生剧毒的氮氧化物气体。\r\n', '强还原剂、活性金属粉末、强酸。', '793', '硝酸盐', '1500', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (337, NULL, '51525', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防尘口罩。必要时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、酸类、活性金属粉末、接触。搬运时要轻装轻卸，\0', 'calcium nitrite', 'Ca(NO2)2.H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '亚硝酸钙', '外观与性状：无色或微黄色结晶，有潮解性。\r\n熔点(℃)：100(失结晶水)\r\n相对密度(水=1)：2.53\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水。\r\n主要用途：用于有机合成和医药。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：150.11\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与还原剂、酸类、活性金属粉末、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃。\r\n侵入途径：吸入、食入。\r\n健康危害：。\r\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。高温时分解，释出剧毒的氮氧化物气体。\r\n', '强还原剂、强酸、活性金属粉末。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (338, '7789-12-0', '51520', '监测方法：二苯碳酰二肼比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。必要时，佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、醇类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配\0', 'sodium dichromate', 'Na2Cr2O7.2H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '重铬酸钠；红矾钠', '外观与性状：桔红色结晶，易潮解。\r\n熔点(℃)：357(无水)\r\n相对密度(水=1)：2.35\r\n沸点(℃)：400(无水)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于醇。\r\n主要用途：用于印染、制革、化学、医药、电镀等。\r\n主要成分：含量: 工业级 一级、二级≥98.0％。\r\nCAS号：7789-12-0\r\n相对分子质量：297.99\r\n化学类别：7789-12-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：可能产生有害的毒性烟雾。\r\n急性毒性：LD50：50mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人类为阳性，动物致癌证据不充分。\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不超过35℃，相对湿度不超过75％。包装密封。应与还原剂、醇类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，为致癌物，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒：吸入后可引起急性呼吸道刺激症状、鼻出血、声音嘶哑、鼻粘膜萎缩，有时出现哮喘和紫绀。重者可发生化学性肺炎。口服可刺激和腐蚀消化道，引起恶心、呕吐、腹痛、血便等；重者出现呼吸困难、紫绀、休克、肝损害及急性肾功能衰竭等。慢性影响：有接触性皮炎、铬溃疡?\n危险特性：强氧化剂。遇强酸或高温时能释出氧气，促使有机物燃烧。与硝酸盐、氯酸盐接触剧烈反应。有水时与硫化钠混合能引起自燃。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。具有较强的腐蚀性。\r\n', '强还原剂、醇类、水、活性金属粉末、硫、磷、强酸。', '777', '铬酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (339, '7778-50-9', '51520', '监测方法：二苯碳酰二肼比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。必要时，佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及\0', 'potassium dichromate', 'K2Cr2O7', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理\0', '重铬酸钾；红矾钾', '外观与性状：桔红色结晶。\r\n熔点(℃)：398\r\n相对密度(水=1)：2.68\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于乙醇。\r\n主要用途：用于皮革、火柴、印染、化学、电镀等工业。\r\n主要成分：含量:工业级 一级、二级≥98.0％。\r\nCAS号：7778-50-9\r\n相对分子质量：294.21\r\n化学类别：7778-50-9\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：可能产生有害的毒性烟雾。\r\n急性毒性：LD50：190mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物致癌缺乏证据，人类致癌证据充分。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过35℃，相对湿度不超过75％。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，为致癌物，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒：吸入后可引起急性呼吸道刺激症状、鼻出血、声音嘶哑、鼻粘膜萎缩，有时出现哮喘和紫绀。重者可发生化学性肺炎。口服可刺激和腐蚀消化道，引起恶心、呕吐、腹痛和血便等；重者出现呼吸困难、紫绀、休克、肝损害及急性肾功能衰竭等。慢性影响：有接触性皮炎、铬溃疡?\n危险特性：强氧化剂。遇强酸或高温时能释出氧气，促使有机物燃烧。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。有水时与硫化钠混合能引起自燃。与硝酸盐、氯酸盐接触剧烈反应。具有较强的腐蚀性。\r\n', '强还原剂、易燃或可燃物、酸类、活性金属粉末、硫、磷。', '777', '铬酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (340, '7789-09-5', '51520', '监测方法：二苯碳酰二肼比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。必要时，佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防止包装及\0', 'ammonium dichromate', '(NH4)2Cr2O7', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用干燥的砂土或石灰覆盖，大量泄漏：收集回收或运至废物处理场所处置。', '重铬酸铵；红矾铵', '外观与性状：桔黄色单斜结晶。\r\n熔点(℃)：分解\r\n相对密度(水=1)：2.15\r\n沸点(℃)：\r\n相对密度(空气=1)：8.7\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、不溶于丙酮、溶于乙醇。\r\n主要用途：用作鞣革、媒染剂、烟花、香料合成等。\r\n主要成分：含量: 工业级≥95％。\r\nCAS号：7789-09-5\r\n相对分子质量：252.07\r\n化学类别：7789-09-5\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌证据充分。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，为致癌物，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒：吸入后可引起急性呼吸道刺激症状、鼻出血、声音嘶哑、鼻粘膜萎缩，有时出现哮喘和紫绀。重者可发生化学性肺炎。口服可刺激和腐蚀消化道，引起恶心、呕吐、腹痛和血便等；重者出现呼吸困难、紫绀、休克、肝损害及急性肾功能衰竭等。皮肤或眼睛接触引起刺激或灼伤，?\n危险特性：强氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。遇强酸接触会自燃。与硝酸盐、氯酸盐接触剧烈反应。\r\n', '强还原剂、易燃或可燃物、强酸、醇类、硫、磷。', '777', '铬酸盐', '1439', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (341, '7789-38-0', '51510', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，作业工人应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防\0', 'sodium bromate；bromic acid sodium salt', 'NaBrO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '溴酸钠', '外观与性状：白色结晶或晶状粉末, 无味。\r\n熔点(℃)：381(分解)\r\n相对密度(水=1)：3.34(17.5℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于乙醇。\r\n主要用途：用作分析试剂和氧化剂、烫发药剂，与溴化钠混合用作金的溶解剂。\r\n主要成分：含量≥98.5％。\r\nCAS号：7789-38-0\r\n相对分子质量：150.91\r\n化学类别：7789-38-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氧化钠。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：粉尘对眼睛和呼吸道有刺激性。\r\n危险特性：强氧化剂。与铵盐、金属粉末、可燃物、有机物或其它易氧化物形成爆炸性混合物，经摩擦或受热易引起燃烧或爆炸。与硫酸接触容易发生爆炸。能与铝、砷、铜、碳、金属硫化物、有机物、磷、硒、硫剧烈反应。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷、硫酸。', '764', '卤素含氧酸盐', '1494', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (342, '13967-90-3', '51510', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，作业工人应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。\0', 'barium bromate', 'Ba(BrO3)2.H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '溴酸钡', '外观与性状：白色带光泽结晶或晶状粉末。\r\n熔点(℃)：260(分解)\r\n相对密度(水=1)：3.99(18℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于乙醇、多数有机溶剂，溶于丙酮。\r\n主要用途：用作分析试剂、氧化剂、制备稀土溴酸盐、低碳钢腐蚀抑制剂。\r\n主要成分：纯品\r\nCAS号：13967-90-3\r\n相对分子质量：411.21\r\n化学类别：13967-90-3\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氧化钡。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，剧毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入后刺激上呼吸道。眼和皮肤接触有刺激性。口服引起腹痛、恶心、呕吐、腹泻、脉缓、面色苍白、紫绀、呼吸困难、流涎、惊厥、昏迷、胃肠出血、进行性肌麻痹、心律紊乱等。可致死。慢性影响：长期接触钡化合物的工人，可有无力、气促、流涎、口腔粘膜肿胀糜烂、鼻炎、结膜炎?\n危险特性：强氧化剂。与铵盐、金属粉末、可燃物、有机物或其它易氧化物形成爆炸性混合物，经摩擦或受热易引起燃烧或爆炸。与硫酸接触容易发生爆炸。能与铝、砷、铜、碳、金属硫化物、有机物、磷、硒、硫剧烈反应。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '764', '卤素含氧酸盐', '2719', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (343, '7758-01-2', '51510', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，作业工人应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，防\0', 'potassium bromate；bromic acid potassium salt', 'KBrO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处\0', '溴酸钾', '外观与性状：无色三角晶体或白色晶状粉末。\r\n熔点(℃)：370(分解)\r\n相对密度(水=1)：3.27(17.5℃)\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于丙酮、微溶于乙醇。\r\n主要用途：用作分析试剂、氧化剂、食品添加剂、羊毛漂白处理剂。\r\n主要成分：含量: 工业级≥99.8％。\r\nCAS号：7758-01-2\r\n相对分子质量：167.01\r\n化学类别：7758-01-2\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氧化钾。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤、粘膜有刺激性。口服后，可引起恶心、呕吐、胃痛、呕血、腹泻等。严重者发生肾小管坏死和肝脏损害，高铁血红蛋白血症，听力损害。大量接触可致血压下降。\r\n危险特性：强氧化剂。与铵盐、金属粉末、可燃物、有机物或其它易氧化物形成爆炸性混合物，经摩擦或受热易引起燃烧或爆炸。与硫酸接触容易发生爆炸。能与铝、砷、铜、碳、金属硫化物、有机物、磷、硒、硫剧烈反应。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '764', '卤素含氧酸盐', '1484', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (344, '34018-28-5', '51510', '监测方法：双硫腙比色法；火焰原子吸收光谱法；石墨炉原子吸收光谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，作业工人应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。\0', 'lead bromate', 'Br2O6Pb', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：在专家指导下清除。', '溴酸铅', '外观与性状：无色结晶。\r\n熔点(℃)：180(分解)\r\n相对密度(水=1)：5.53\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于热水、不溶于冷水。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：34018-28-5\r\n相对分子质量：463.01\r\n化学类别：34018-28-5\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氧化铅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，剧毒。\r\n侵入途径：吸入、食入。\r\n健康危害：铅及其化合物损害造血、神经、消化系统及肾脏。职业中毒主要为慢性。　神经系统主要表现为神经衰弱综合征、周围神经病(以运动功能受累较明显)，重者出现铅中毒性脑病。消化系统表现有齿龈铅线。食欲不振、恶心、腹胀、腹泻或便秘；腹绞痛见于中度及重度中毒病例。造血系统损?\n危险特性：强氧化剂。能与可燃物、有机物或易氧化物质形成爆炸性混合物，经摩擦和与少量水接触可导致燃烧或爆炸。\r\n', '还原剂、易燃或可燃物、硫、磷。', '764', '卤素含氧酸盐', '1450', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (345, NULL, '51510', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，作业工人应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻\0', 'silver bromate', 'AgBrO3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '溴酸银', '外观与性状：白色粉末，对光敏感。\r\n熔点(℃)：分解\r\n相对密度(水=1)：5.21\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于热水、溶于氨水。\r\n主要用途：用作氧化剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：235.78\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢、氧化银。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：粉尘对眼睛和呼吸道有刺激性。口服刺激胃肠道，引起腹痛，甚至有呕吐、剧烈胃痛、出血性胃炎的表现。\r\n危险特性：强氧化剂。与铵盐、金属粉末、可燃物、有机物或其它易氧化物形成爆炸性混合物，经摩擦或受热易引起燃烧或爆炸。与硫酸接触容易发生爆炸。能与铝、砷、铜、碳、金属硫化物、有机物、磷、硒、硫剧烈反应。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '764', '卤素含氧酸盐', '1450', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (346, '559-90-2', '61621', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、酸类、碱类、\0', 'dimethyl ethanedioate；methyl oxalate', 'C4H6O4', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '乙二酸二甲酯；草酸甲酯', '外观与性状：无色单斜结晶。\r\n熔点(℃)：54\r\n相对密度(水=1)：1.15\r\n沸点(℃)：164.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(20℃)\r\n燃烧热(kJ/mol)：1672.8\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于冷水、溶于乙醇、乙醚。\r\n主要用途：用于制取高纯度的甲醇。\r\n主要成分：纯品\r\nCAS号：559-90-2\r\n相对分子质量：118.10\r\n化学类别：559-90-2\r\n燃烧性：可燃\r\n闪点：75\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。加热分解产生毒性气体。\r\n', '酸类、碱、强氧化剂、强还原剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (347, '95-92-1', '61621', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂\0', 'diethyl ethanedioate；ethyl oxalate', 'C6H10O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '乙二酸二乙酯；草酸乙酯', '外观与性状：无色油状液体，有芳香气味。\r\n熔点(℃)：-40.6\r\n相对密度(水=1)：1.08\r\n沸点(℃)：185.4\r\n相对密度(空气=1)：5.04\r\n饱和蒸气压(kPa)：1.33(84℃)\r\n燃烧热(kJ/mol)：2992.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于乙醇、乙醚、乙酸乙酯、等多数有机溶剂。\r\n主要用途：用作溶剂、染料中间体，及油漆、药物的合成。\r\n主要成分：纯品\r\nCAS号：95-92-1\r\n相对分子质量：146.14\r\n化学类别：95-92-1\r\n燃烧性：可燃\r\n闪点：75\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：400mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有强烈刺激性。高浓度严重损害粘膜、上呼吸道、眼和皮肤。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。加热分解产生易燃的有毒气体。\r\n', '酸类、碱、强氧化剂、强还原剂、水。', '749', '羧酸酯', '2525', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (348, '2050-60-4', '61621', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（全面罩）\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂\0', 'dibutyl ethanedioate；butyl oxalate', 'C10H18O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成\0', '乙二酸二丁酯；草酸丁酯', '外观与性状：水白色液体，略有气味。\r\n熔点(℃)：-29.6\r\n相对密度(水=1)：0.99\r\n沸点(℃)：245.5\r\n相对密度(空气=1)：7.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、酮、酯。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：2050-60-4\r\n相对分子质量：202.25\r\n化学类别：2050-60-4\r\n燃烧性：可燃\r\n闪点：104.4\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有强烈刺激性。高浓度接触严重损害粘膜、上呼吸道、眼睛和皮肤。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热可燃。加热分解产生易燃的有毒气体。与氧化剂可发生反应。\r\n', '酸类、碱、强氧化剂、强还原剂。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (349, NULL, '61125', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'Ethion；ethion', 'C9H22O4P2S4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡\0', '乙硫磷；益赛昂', '外观与性状：纯品为白色至琥珀色油状液体, 工业品为油状液体, 有恶臭。\r\n熔点(℃)：-12～-15\r\n相对密度(水=1)：1.22\r\n沸点(℃)：125(0.0013kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于氯仿、苯、二甲苯、易溶于丙酮、甲醇、乙醇。\r\n主要用途：用作农药杀虫剂。\r\n主要成分：含量: 50％乳油; 25％可湿性粉剂; 4％粉剂。\r\nCAS号：\r\n相对分子质量：384.45\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化磷、氧化硫。\r\n急性毒性：LD50：13～34mg/kg(大鼠经口)；1600mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：有机磷农药抑制胆碱酯酶活性，造成神经生理功能紊乱。急性中毒：短期内接触(口服、吸入、皮肤、粘膜)大量引起急性中毒。表现有头痛、头昏、食欲减退、恶心、呕吐、腹痛、腹泻、流涎、瞳孔缩小、呼吸道分泌物增多、多汗、肌束震颤等。重者出现肺水肿、脑水肿、昏迷、呼吸麻痹?\n危险特性：受热分解，放出磷、硫的氧化物等毒性气体。\r\n', '强氧化剂、碱类、酸类。', '800', '未指定的化学类别', '2783', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (350, '26087-47-8', '61875', '监测方法：气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：生产操作或农业使用时，佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', 'Kitazine P；IBP', 'C13H21O3PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。若是液体，尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性\0', '异稻瘟净；克打净 P', '外观与性状：纯品为无色固体或液体，工业品为淡黄色，有臭味。\r\n熔点(℃)：22.5～23.8\r\n相对密度(水=1)：\r\n沸点(℃)：126(0.005kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.005(126℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于多数有机溶剂。\r\n主要用途：用作农药防虫剂。\r\n主要成分：含量: 40％、50％乳油。\r\nCAS号：26087-47-8\r\n相对分子质量：288.34\r\n化学类别：26087-47-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化磷、氧化硫。\r\n急性毒性：LD50：366mg/kg(大鼠经口)\r\nLC50：2836mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：大鼠吸入后，出现嗜睡、共济失调和呼吸困难。\r\n危险特性：遇明火、高热可燃。受热分解，放出磷、硫的氧化物等毒性气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、碱类。', '800', '未指定的化学类别', '3018', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (351, '75-43-4', '22044', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），防止气体泄漏到工作场所空气中。避免与氧化剂、碱金属、碱土金属、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'dichlorofluoromethane；Freon-21', 'CHCl2F', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '一氟二氯甲烷；氟利昂-21', '外观与性状：无色、有似四氯化碳气味的气体。\r\n熔点(℃)：-135\r\n相对密度(水=1)：1.48\r\n沸点(℃)：8.9\r\n相对密度(空气=1)：3.82\r\n饱和蒸气压(kPa)：202.65(28.4℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：178.5\r\n临界压力(MPa)：5.17\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：用作溶剂、致冷剂、气溶胶喷射剂。\r\n主要成分：纯品\r\nCAS号：75-43-4\r\n相对分子质量：102.92\r\n化学类别：75-43-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、氯化氢。\r\n急性毒性：LD50：\r\nLC50：210000mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱金属、碱土金属、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具窒息性，该物质对大气臭氧层破坏力极强。\r\n侵入途径：吸入。\r\n健康危害：有迅速的窒息作用。高浓度吸入可引起定向障碍、恶心、呕吐、麻醉作用、心律紊乱、低血压，甚至死亡。\r\n危险特性：不燃。遇火或赤热表面会分解出剧毒的氯化氢、氟化氢，还可能有光气。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、碱金属、碱土金属、易燃或可燃物。', '759', '卤代烷', '1029', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (352, '103-72-0', '61656', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'phenyl isothiocyanate；phenyl mustard oil', 'C7H5NS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '异硫氰酸苯酯；苯基芥子油', '外观与性状：无色或淡黄色液体，有强烈刺激性气味。\r\n熔点(℃)：-21\r\n相对密度(水=1)：1.14\r\n沸点(℃)：221\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(47.2℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作有机合成中间体，及合成药物，也用于生化分析。\r\n主要成分：纯品\r\nCAS号：103-72-0\r\n相对分子质量：135.18\r\n化学类别：103-72-0\r\n燃烧性：可燃\r\n闪点：87\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氧化硫。\r\n急性毒性：LD50：87mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入本品对呼吸道有强烈刺激作用，可引起死亡。对眼和皮肤有强烈刺激性，可引起灼伤。慢性影响：肝、肾损害。\r\n危险特性：接触酸及酸气时，能放出有毒的氰化物及氧化硫烟气。与强氧化剂接触可发生化学反应。若遇高热可发生剧烈分解，引起容器破裂或爆炸事故。\r\n', '水、醇类、强碱、胺类、酸类、强氧化剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (353, '7774-41-6', '61011', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触毒物时，必须佩戴自吸过滤式防毒面具（全面罩）或头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与酸类、卤素、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理\0', 'arsenic acid；arsenic acid,hemihydrate', 'H3AsO4.1/2H2O', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '砷酸；原砷酸', '外观与性状：无色至白色透明斜方晶系细小板状结晶, 具有潮解性。\r\n熔点(℃)：35.5\r\n相对密度(水=1)：2.0～2.5\r\n沸点(℃)：160(脱水)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、碱液、甘油。\r\n主要用途：用于制造有机颜料, 制备无机盐或有机砷酸盐, 也用于制造杀虫剂、玻璃、并用于制药等。\r\n主要成分：纯品\r\nCAS号：7774-41-6\r\n相对分子质量：150.95\r\n化学类别：7774-41-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化砷。\r\n急性毒性：LD50：48mg/kg(大鼠经口)；238mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与酸类、卤素、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，高毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：砷及其化合物对体内酶蛋白巯基有特殊亲和力。大量吸入砷化合物可致咳嗽、胸痛、呼吸困难、头痛、眩晕、全身衰弱、烦躁、痉挛和昏迷；可有消化道症状；重者可致死。口服致急性胃肠炎、休克、周围神经病、贫血及中毒性肝病、心肌炎等。可因呼吸中枢麻痹而死亡。慢性影响：长期?\n危险特性：遇高热、明火会产生剧毒的蒸气。与金属接触会散发出剧毒的砷化氢。\r\n', '酸类、卤素、水、潮湿空气。', '766', '无机酸', '1553', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (354, '57-06-7', '61656', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触毒物时，佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'allyl isothiocyanate；allyl mustard oil', 'C4H5NS', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水\0', '异硫氰酸烯丙酯；人造芥子油', '外观与性状：无色或淡黄色油状液体，有刺激性气味。\r\n熔点(℃)：-80\r\n相对密度(水=1)：1.01\r\n沸点(℃)：150.7\r\n相对密度(空气=1)：3.41\r\n饱和蒸气压(kPa)：1.33(38.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：2.11\r\n溶解性：微溶于水、溶于醇。\r\n主要用途：用作熏蒸剂。\r\n主要成分：纯品\r\nCAS号：57-06-7\r\n相对分子质量：99.15\r\n化学类别：57-06-7\r\n燃烧性：易燃\r\n闪点：46\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氧化氮、氰化氢、氧化硫。\r\n急性毒性：LD50：112mg/kg(大鼠经口)；88mg/kg(兔经皮)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物可疑阳性，人类无可靠证据。\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性，具致敏性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对呼吸道有刺激性，引起鼻炎、咽喉炎、支气管炎等。可有眼刺激症状，引起结膜角膜炎。皮肤接触引起灼热、疼痛、发红。作用较长时间可出现水疱。对皮肤有致敏作用，可引起皮肤湿疹。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热或与酸接触会产生剧毒的氰化物气体。\r\n', '水、醇类、强碱、胺类、酸类、强氧化剂。', '800', '未指定的化学类别', '1545', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (355, '542-85-8', '61656', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'ethyl isothiocyanate', 'C3H5NS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '异硫氰酸乙酯', '外观与性状：无色油状液体。\r\n熔点(℃)：-5.9\r\n相对密度(水=1)：1.00(15℃)\r\n沸点(℃)：131～132\r\n相对密度(空气=1)：3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于制药和杀虫剂。\r\n主要成分：纯品\r\nCAS号：542-85-8\r\n相对分子质量：87.14\r\n化学类别：542-85-8\r\n燃烧性：易燃\r\n闪点：32\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢、硫化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有剧烈的芥末味。对眼睛、皮肤、粘膜和上呼吸道有强烈的刺激作用。吸入后，可引起喉、支气管的痉挛、炎症、水肿，化学性肺炎、肺水肿，严重者可致死。\r\n危险特性：遇明火、高热易燃。受高热或与酸接触会产生剧毒的氰化物气体。\r\n', '强氧化剂、强碱、酸类、醇类、胺类。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (356, '103-71-9', '61109', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'phenyl isocyanate', 'C7H5NO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用碱性物质处理\0', '异氰酸苯酯', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：-30\r\n相对密度(水=1)：1.1\r\n沸点(℃)：166\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(10.6℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于乙醚。\r\n主要用途：用于鉴别醇及胺，也作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：103-71-9\r\n相对分子质量：119.12\r\n化学类别：103-71-9\r\n燃烧性：易燃\r\n闪点：55\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：940mg/kg(大鼠经口)；7130mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品后对呼吸道有强烈刺激性，可引起肺水肿。对眼和皮肤有刺激性，可引起灼伤。口服刺激和灼伤口腔和消化道。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。加热至沸点以上时即分解释出有毒的亚硝酸蒸气。与酸类、胺类、醇、碱类和水发生强烈反应，有引起燃烧爆炸的危险。遇水或水蒸气分解放出有毒的气体。\r\n', '水、醇类、强碱、胺类、酸类、强氧化剂。', '800', '未指定的化学类别', '2487', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (357, '625-28-5', '61629', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触毒物时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'isopentanenitrile；isobutyl cyanide', 'C5H9N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', '异戊腈；异丁基氰', '外观与性状：无色液体。\r\n熔点(℃)：-100.8\r\n相对密度(水=1)：0.79\r\n沸点(℃)：130.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于丙酮、可混溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：625-28-5\r\n相对分子质量：83.13\r\n化学类别：625-28-5\r\n燃烧性：易燃\r\n闪点：25\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：233mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：兔皮下注射，最低致死量为 43.4mg/kg，出现呼吸兴奋和痉挛性麻痹。\r\n危险特性：遇明火易燃。受高热燃烧并分解产生有毒气体。\r\n', '强氧化剂、强还原剂、强酸。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (358, '111-68-2', '61728', '监测方法：\r\n工程控制：生产过程密闭，全面通风。尽可能采取隔离操作。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，全面通风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', 'n-heptylamine；1-amino-n-heptane', 'C7H17N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '正庚胺；1-氨基庚烷', '外观与性状：无色液体。\r\n熔点(℃)：-23\r\n相对密度(水=1)：0.73\r\n沸点(℃)：155\r\n相对密度(空气=1)：4.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：4927.8\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、醚。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-68-2\r\n相对分子质量：115.22\r\n化学类别：111-68-2\r\n燃烧性：易燃\r\n闪点：35\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：100mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对皮肤、粘膜有刺激作用。人口服 2毫克即出现心悸、口干、头痛、四肢麻木、血压略有增高。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类、酸酐、酰基氯、二氧化碳。', '762', '脂肪胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (359, '100-53-8', '61591', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', 'benzyl mercaptan；α-toluenethiol', 'C7H8S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳\0', '苄硫醇；α-甲苯硫醇', '外观与性状：水白色液体，有强烈的气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.06\r\n沸点(℃)：194.8\r\n相对密度(空气=1)：4.28\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、二硫化碳。\r\n主要用途：用于香精制造。\r\n主要成分：纯品\r\nCAS号：100-53-8\r\n相对分子质量：124.21\r\n化学类别：100-53-8\r\n燃烧性：易燃\r\n闪点：70\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、硫化物。\r\n急性毒性：LD50：493mg/kg(大鼠经口)\r\nLC50：902mg/m3，4小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热易燃。受高热分解产生有毒的硫化物烟气。\r\n', '强氧化剂、强碱。', '789', '醇', '3071', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (360, '91-22-5', '61847', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'Quinoline', 'C9H7N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', '喹啉；苯并吡啶', '外观与性状：无色液体，日久变黄，有特殊气味。\r\n熔点(℃)：-14.5\r\n相对密度(水=1)：1.09\r\n沸点(℃)：237.7\r\n相对密度(空气=1)：4.5\r\n饱和蒸气压(kPa)：0.13(59.7℃)\r\n燃烧热(kJ/mol)：4696.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：2.6\r\n溶解性：溶于水、醇、醚、二硫化碳、等多数有机溶剂。\r\n主要用途：用于药物合成。\r\n主要成分：纯品\r\nCAS号：91-22-5\r\n相对分子质量：129.16\r\n化学类别：91-22-5\r\n燃烧性：可燃\r\n闪点：99\r\n引燃温度：480\r\n爆炸下限：1.0\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：460mg/kg(大鼠经口)；540mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气对鼻、喉有刺激性。吸入后可引起头痛、头晕、恶心。对眼睛、皮肤有刺激性。口服刺激口腔和胃。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强酸。', '800', '未指定的化学类别', '2656', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (361, '598-31-2', '61604', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其蒸气时，建议佩戴过滤式防毒面具（半面罩）。高浓度环境中，应该佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'bromopropanone；acetonyl bromide', 'C3H5BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离300m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃\0', '溴丙酮', '外观与性状：无色液体, 有刺激性臭味, 接触空气转变成紫色。\r\n熔点(℃)：-54\r\n相对密度(水=1)：1.63(0℃)\r\n沸点(℃)：136\r\n相对密度(空气=1)：4.7\r\n饱和蒸气压(kPa)：1.20(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、丙酮。\r\n主要用途：用于有机合成, 也用作化学武器。\r\n主要成分：纯品\r\nCAS号：598-31-2\r\n相对分子质量：136.97\r\n化学类别：598-31-2\r\n燃烧性：易燃\r\n闪点：21\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性，具强烈催泪性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有强烈的催泪性，对眼睛有刺激性，对上呼吸道刺激性强烈。皮肤直接接触其液体，可引起水疱，皮炎及荨麻疹。\r\n危险特性：遇明火易燃。受高热燃烧并分解产生有毒气体。\r\n', '强氧化剂。', '775', '酮', '1569', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (362, '74-89-5', '21043', '监测方法：对硝基苯胺重氮盐比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器或空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、酸类、卤素\0', 'monomethylamine；aminomethane', 'CH5N', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，将残余气或漏出气用排风机送至水洗\0', '一甲胺(无水)；氨基甲烷', '外观与性状：无色气体，有似氨的气味。\r\n熔点(℃)：-93.5\r\n相对密度(水=1)：0.66\r\n沸点(℃)：-6.8\r\n相对密度(空气=1)：1.09\r\n饱和蒸气压(kPa)：202.65(25℃)\r\n燃烧热(kJ/mol)：1059.6\r\n临界温度(℃)：156.9\r\n临界压力(MPa)：4.07\r\n辛醇/水分配系数：-0.173\r\n溶解性：易溶于水、溶于乙醇、乙醚、等\r\n主要用途：用于橡胶硫化促进剂、染料、医药、杀虫剂、表面活性剂的合成等。\r\n主要成分：纯品\r\nCAS号：74-89-5\r\n相对分子质量：31.10\r\n化学类别：74-89-5\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：430\r\n爆炸下限：4.9\r\n爆炸上限：20.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：2400mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入。\r\n健康危害：本品具有强烈刺激性和腐蚀性。吸入后，可引起咽喉炎、支气管炎、支气管肺炎，重者可致肺水肿、呼吸窘迫综合征而死亡；极高浓度吸入引起声门痉挛、喉水肿而很快窒息死亡。可致呼吸道灼伤。对眼和皮肤有强烈刺激和腐蚀性，可致严重灼伤。口服溶液可致口、咽、食道灼伤。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。接触热、火星、火焰或氧化剂易燃烧爆炸。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '酸类、卤素、酸酐、强氧化剂、氯仿。', '762', '脂肪胺', '1061', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (363, '506-68-3', '61001', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。\r\n呼吸系统防护：可能接触毒物时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、碱类、接触。搬运时要轻装轻卸，防止包装\0', 'cyanogen bromide；bromine cyanide', 'CNBr', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：在专家指导下清除。', '溴化氰；氰化溴', '外观与性状：无色或白色针状或立方形结晶, 常温下挥发。\r\n熔点(℃)：52\r\n相对密度(水=1)：2.02(20℃)\r\n沸点(℃)：61～62\r\n相对密度(空气=1)：3.65\r\n饱和蒸气压(kPa)：13.33(23℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于醇、醚。\r\n主要用途：用于有机合成、炼金、制杀虫剂等。\r\n主要成分：纯品\r\nCAS号：506-68-3\r\n相对分子质量：105.92\r\n化学类别：506-68-3\r\n燃烧性：不燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：氰化氢、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，剧毒，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：毒作用似氢氰酸，并有明显刺激性。吸入后引起紫绀、头痛、头晕、恶心、呕吐、虚弱、神志不清、惊厥、呼吸困难、咳嗽，重者发生肺水肿，可致死。对眼和皮肤有强烈刺激性，可致灼伤。口服后引起口腔和胃刺激或灼伤，可引起死亡。\r\n危险特性：与水或水蒸气接触会散发出剧毒、易燃和腐蚀性的溴化氢和氰化氢气体。有不纯物质存在时能很快引起分解, 并引起爆炸。\r\n', '强氧化剂、碱类。', '800', '未指定的化学类别', '1889', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (364, '10031-18-2', '61509', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：作业工人应该佩戴导管式防毒面具。必要时，佩戴空气呼吸器、氧气呼吸器或长管面具。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。实行就业前和定期的体检。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿聚乙烯防毒服，戴氯丁橡胶手套。避免产生粉尘。避免与酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残留有害物。', 'mercurous bromide；mercury(Ⅰ)bromide', 'BrHg', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '溴化亚汞；一溴化汞', '外观与性状：白色细小四角结晶体或粉末, 受热变黄, 冷后恢复白色。\r\n熔点(℃)：345(升华)\r\n相对密度(水=1)：7.31\r\n沸点(℃)：\r\n相对密度(空气=1)：19.3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于乙醇。\r\n主要用途：主要用于医药。\r\n主要成分：纯品\r\nCAS号：10031-18-2\r\n相对分子质量：280.50\r\n化学类别：10031-18-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：溴化氢、氧化汞。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：汞离子可使含巯基的酶丧失活性，失去功能；还能与酶中的氨基、二巯基、羧基、羟基以及细胞膜内的磷酰基结合，引起相应的损害。急性中毒：有头痛、头晕、乏力、失眠、多梦、口腔炎、发热等全身症状。可有食欲不振、恶心、腹痛、腹泻等。部分患者皮肤出现红色斑丘疹。严重者可?\n危险特性：受高热升华产生有毒气体。\r\n', '强酸。', '797', '金属卤化物', '1634', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (365, '100-39-0', '61065', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触毒物时，佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', 'benzyl bromide', 'C7H7Br', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成\0', '溴化苄；苄基溴', '外观与性状：无色液体，有芳香气味，具有催泪性。\r\n熔点(℃)：-4.0\r\n相对密度(水=1)：1.44\r\n沸点(℃)：198\r\n相对密度(空气=1)：5.8\r\n饱和蒸气压(kPa)：2.00(114℃)\r\n燃烧热(kJ/mol)：4278.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯。\r\n主要用途：用于有机合成及制造发泡剂。\r\n主要成分：纯品\r\nCAS号：100-39-0\r\n相对分子质量：171.04\r\n化学类别：100-39-0\r\n燃烧性：可燃\r\n闪点：86\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、胺类、醇类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，具催泪性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有刺激性，可引起明显的呼吸道刺激，胸部紧束感。吸入高浓度蒸气可出现呼吸道炎症，甚至肺水肿。有催泪作用。皮服接触可引起皮炎和荨麻疹。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的溴化物气体。与强氧化剂接触可发生化学反应。\r\n', '碱类、胺类、强氧化剂、醇类。', '784', '卤代芳烃', '1737', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (366, '7789-40-4', '61023', '监测方法：石墨炉原子吸收光谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴隔离式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。车间应配备急救设备及药品。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴隔离式呼吸器，穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容\0', 'thallium bromide；thallium bromide', 'TlBr', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '溴化铊；溴化亚铊', '外观与性状：黄白色结晶性粉末。\r\n熔点(℃)：460(约)\r\n相对密度(水=1)：7.56\r\n沸点(℃)：815\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.33(522℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、不溶于丙酮。\r\n主要用途：用于制造药物。\r\n主要成分：纯品\r\nCAS号：7789-40-4\r\n相对分子质量：284.31\r\n化学类别：7789-40-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：铊及其化合物为强烈的神经毒，对肝肾有损害。急性中毒：表现有恶心、呕吐、腹部绞痛、厌食等症状，肢体及躯干有感觉、痛觉过敏；重者可发生中毒性脑病、中毒性神经病。脱发为其特异表现。皮肤出现皮疹，指甲有白色横纹。可有肝、肾损害。慢性中毒：主要症状有脱发、乏力、胃?\n危险特性：受高热分解产生有毒的溴化物气体。\r\n', '强氧化剂、强酸。', '797', '金属卤化物', '1707', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (367, '96-32-2', '61103', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。现场备有冲洗眼及皮肤的设备。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'methyl bromoacetate', 'C3H5BrO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用碱性物质处理。大\0', '溴乙酸甲酯；溴醋酸甲酯', '外观与性状：无色至黄色液体，有吸湿性。\r\n熔点(℃)：<-50\r\n相对密度(水=1)：1.65\r\n沸点(℃)：145\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.00(51℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于甲醇、乙醚。\r\n主要用途：用于合成除草剂，也作染料、药品制造的中间体。\r\n主要成分：纯品\r\nCAS号：96-32-2\r\n相对分子质量：152.98\r\n化学类别：96-32-2\r\n燃烧性：易燃\r\n闪点：62\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、呼吸道粘膜有强烈的刺激作用，重者可引起肺水肿。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热或遇水、酸分解放热, 放出有毒烟气。\r\n', '酸类、碱类、强氧化剂、强还原剂。', '749', '羧酸酯', '2643', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (368, '105-36-2', '61103', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。现场备有冲洗眼及皮肤的设备。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄\0', 'ethyl bromoacetate', 'C4H7BrO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用碱性物质处理。大\0', '溴乙酸乙酯；溴醋酸乙酯', '外观与性状：无色至黄色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.51\r\n沸点(℃)：158.8\r\n相对密度(空气=1)：5.8\r\n饱和蒸气压(kPa)：0.35(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、苯。\r\n主要用途：用于有机合成，制造军用毒气。\r\n主要成分：纯品\r\nCAS号：105-36-2\r\n相对分子质量：167.01\r\n化学类别：105-36-2\r\n燃烧性：易燃\r\n闪点：47.8\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：小鼠皮下最低中毒剂量(TDL0)：332mg/kg(83周，间断)，致肿瘤阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极\0', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、呼吸道粘膜有强烈的刺激作用，重者可引起肺水肿。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热分解产生有毒的溴化物气体。\r\n', '碱类、酸类、强氧化剂、强还原剂。', '749', '羧酸酯', '1603', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (369, '689-97-4', '21060', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（半面罩）或空气呼吸器\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄\0', 'vinyl acetylene；buten-3-yne', 'C4H4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。如无危险，就地燃烧，同时喷雾\0', '乙烯基乙炔', '外观与性状：常温下为气体。\r\n熔点(℃)：-118\r\n相对密度(水=1)：0.71\r\n沸点(℃)：5\r\n相对密度(空气=1)：1.8\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：16.8\r\n临界压力(MPa)：5.035\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：在工业上是重要的烯炔烃化合物, 用于制备合成橡胶的单体2-氯丁二烯-[1,3]等。\r\n主要成分：纯品\r\nCAS号：689-97-4\r\n相对分子质量：52.04\r\n化学类别：689-97-4\r\n燃烧性：易燃\r\n闪点：<-5\r\n引燃温度：\r\n爆炸下限：2\r\n爆炸上限：100\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、氧、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：急性中毒的表现：头痛、眩晕、腿无力、颌关节痛、出汗、咽喉干燥，有时有恶心、呕吐及腹泻。长期接触后，可发生神经衰弱综合征，低血压等。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热极易燃烧爆炸。在空气中非常容易氧化生成过氧化物, 受热或撞击、甚至轻微摩擦即发生爆炸。能与浓硫酸、发烟硝酸猛烈反应, 甚至发生爆炸。在精馏操作过程中, 易发生自聚, 引起事故, 应加阻聚剂。\r\n', '强氧化剂、酸类、氧、卤素。', '796', '炔烃', '1954', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (370, '544-10-5', '33526', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '1-chlorohexane；n-hexyl chloride', 'C6H13Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '1-氯己烷；己基氯', '外观与性状：无色液体，有芳香气味。\r\n熔点(℃)：-83\r\n相对密度(水=1)：0.88\r\n沸点(℃)：134\r\n相对密度(空气=1)：4.2\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于甲醇、乙醇、苯、油类、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：544-10-5\r\n相对分子质量：120.62\r\n化学类别：544-10-5\r\n燃烧性：易燃\r\n闪点：35\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害，对眼睛、皮肤、粘膜和呼吸道有刺激作用。中毒表现可有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热易燃。受热分解能放出剧毒的光气。与氧化剂能发生强烈反应。\r\n', '强氧化剂、强碱。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (371, '76-16-4', '22034', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（半面罩）或空气呼吸器\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：一般不需特殊防护。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶碰撞、损坏。配备泄漏应急处理设备。', 'hexafluoroethane', 'C2F6', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '六氟乙烷；全氟乙烷', '外观与性状：无色、无臭的气体。\r\n熔点(℃)：-101\r\n相对密度(水=1)：1.61\r\n沸点(℃)：-78\r\n相对密度(空气=1)：4.7\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作绝缘气、等离子蚀刻剂, 高介电强度泠却剂。\r\n主要成分：纯品\r\nCAS号：76-16-4\r\n相对分子质量：138.0\r\n化学类别：76-16-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：本品可引起快速窒息。接触后引起头痛、恶心和眩晕。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '759', '卤代烷', '2193', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (372, '76-19-7', '22035', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（半面罩）或空气呼吸器\r\n眼睛防护：一般不需要特殊防护。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶碰撞、损坏。配备泄漏应急处理设备。', 'octafluoropropane；perflurane', 'C3F8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '八氟丙烷；全氟丙烷', '外观与性状：无色气体。\r\n熔点(℃)：-183\r\n相对密度(水=1)：\r\n沸点(℃)：-36.7\r\n相对密度(空气=1)：6.6\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作蚀刻剂。\r\n主要成分：纯品\r\nCAS号：76-19-7\r\n相对分子质量：188.0\r\n化学类别：76-19-7\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：吸入高浓度本品气体有麻醉作用。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '759', '卤代烷', '2424', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (373, '115-25-3', '22036', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（半面罩）或空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶碰撞、损坏。配备泄漏应急处理设备。', 'octafluorocyclobutane；perfluorocyclobutane', 'C4F8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '八氟环丁烷；全氟环丁烷', '外观与性状：无色、无臭的气体。\r\n熔点(℃)：-41.4\r\n相对密度(水=1)：1.51(21.1℃)\r\n沸点(℃)：6.04\r\n相对密度(空气=1)：7.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作稳定无毒的食品气雾喷射剂、介质气体。\r\n主要成分：纯品\r\nCAS号：115-25-3\r\n相对分子质量：200.0\r\n化学类别：115-25-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：目前，未见职业中毒的报道，但热解时能放出高毒的氟化氢。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '759', '卤代烷', '1976', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (374, '360-89-4', '22038', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：注意检测毒物。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶\0', 'octafluorobut-2-ene；perfluoro-2-butene', 'C4F8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '八氟-2-丁烯；全氟-2-丁烯', '外观与性状：无色气体。\r\n熔点(℃)：-139--129\r\n相对密度(水=1)：\r\n沸点(℃)：1.2\r\n相对密度(空气=1)：6.9\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：360-89-4\r\n相对分子质量：200.0\r\n化学类别：360-89-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、过氧化物、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，有毒，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：热解能放出高毒氟化氢。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、过氧化物。', '765', '卤代烯', '2422', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (375, '382-21-8', '22038', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：注意检测毒物。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防毒物渗透工作服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与氧化剂、还原剂、酸类、接触。搬运时戴好钢瓶安全帽和防震橡\0', 'octafluoroisobutylene；perfluoroisobutylene', 'C4F8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '八氟异丁烯；全氟异丁烯', '外观与性状：无色气体, 略带青草味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.59(0℃)\r\n沸点(℃)：6.5-7.0\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醚、苯。\r\n主要用途：用作制备耐腐蚀性聚合物的原料。\r\n主要成分：纯品\r\nCAS号：382-21-8\r\n相对分子质量：200.02\r\n化学类别：382-21-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：氟化物。\r\n急性毒性：LD50：\r\nLC50：24.54mg/m3，1小时(大鼠吸入)；7.36mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入。\r\n健康危害：本品毒作用带窄，危险性大。主要作用为引起急性中毒性肺水肿。对人的上呼吸道刺激一般不明显，吸入后可有头晕、恶心、胸闷、咳嗽等，但数小时后可发生急性化学性肺炎或肺水肿，甚至发生成人呼吸窘迫综合征（ARDS）。可致死亡。\r\n危险特性：不燃的剧毒气体。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。\r\n', '强酸、强氧化剂、强还原剂。', '765', '卤代烯', '2422', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (376, '63938-10-3', '22042', '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度较高时，应视污染气体浓度的高低和作业环境中是否缺氧来选择过滤式防毒面具（半面罩）或空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：一般不需特殊防护。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时戴好钢瓶安全帽和防震橡皮圈，防止钢瓶碰撞、损坏。配备泄漏应急处理设备。', 'chlorotetrafluoroethane；monochlorotetrafluoroetha', 'C2HF4Cl', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏气的容器移至空旷处，注意通风。漏气容器要妥善处理，修复、检验后再用。', '氯四氟乙烷', '外观与性状：无色气体。\r\n熔点(℃)：-177\r\n相对密度(水=1)：\r\n沸点(℃)：-10.2\r\n相对密度(空气=1)：4.7\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：63938-10-3\r\n相对分子质量：136.5\r\n化学类别：63938-10-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、氧化剂、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：本品经热解能放出有高毒的氯化氢和氟化氢气体。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、易燃或可燃物。', '759', '卤代烷', '1021', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (377, '75-63-8', '22049', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处\0', 'bromotrifluoromethane', 'CBrF3', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '三氟溴甲烷', '外观与性状：无色气体。\r\n熔点(℃)：-168\r\n相对密度(水=1)：\r\n沸点(℃)：-58.7\r\n相对密度(空气=1)：5.3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：66.6\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作致冷剂。\r\n主要成分：纯品\r\nCAS号：75-63-8\r\n相对分子质量：148.91\r\n化学类别：75-63-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、溴化氢。\r\n急性毒性：LD50：\r\nLC50：416mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、氧化剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具刺激性，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：对皮肤有刺激作用，对眼睛、粘膜和上呼吸道有刺激作用。有迅速窒息作用。吸入高浓度的三氟溴甲烷可引起眩晕、定向障碍、共济失调、麻醉作用、恶心或呕吐。本品能增高心脏对肾上腺素的敏感性，引起心律失常。\r\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、易燃或可燃物。', '759', '卤代烷', '1009', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (378, '10035-10-6', '23004', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与氧化剂、碱类、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备\0', 'hydrogen bromide', 'HBr', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。喷氨水或其它稀碱液中和。构筑围堤或挖坑收\0', '溴化氢', '外观与性状：无色、有辛辣刺激气味的气体。\r\n熔点(℃)：-86.9\r\n相对密度(水=1)：\r\n沸点(℃)：-66.8\r\n相对密度(空气=1)：2.71\r\n饱和蒸气压(kPa)：53.32/-78.0℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：90.0\r\n临界压力(MPa)：8.51\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇。\r\n主要用途：作为有机及无机溴化物制造的原料，也用于制触媒及药物。\r\n主要成分：纯品\r\nCAS号：10035-10-6\r\n相对分子质量：80.91\r\n化学类别：10035-10-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：溴化氢。\r\n急性毒性：LD50：\r\nLC50：2858ppm，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入。\r\n健康危害：人吸入的最小中毒浓度为5ppm。液态溴化氢可引起皮肤、 粘膜的刺激或灼伤。长期低浓度接触可引起呼吸道刺激症状和消化功能障碍。\r\n危险特性：不燃。能与普通金属发生反应, 放出氢气而与空气形成爆炸性混合物。纯品在空气中较稳定，但遇光及热易被氧化而游离出溴。遇溴氧能发生爆炸性反应。遇水时有强腐蚀性。\r\n', '强氧化剂、碱类。', '776', '非金属卤化物', '1048', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (379, '7783-07-5', '23007', '监测方法：氢化物发生－原子吸收光谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与\0', 'hydrogen selenide', 'H2Se', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，将漏出气用排风机送至空旷地方或装设适\0', '硒化氢', '外观与性状：无色、有恶臭的气体。\r\n熔点(℃)：-66.1\r\n相对密度(水=1)：2.12/-42℃\r\n沸点(℃)：-41.1\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：53.32/-53.6℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、二硫化碳。\r\n主要用途：半导体用料，及制金属硒化物和含硒的有机化合物等。\r\n主要成分：纯品\r\nCAS号：7783-07-5\r\n相对分子质量：80.98\r\n化学类别：7783-07-5\r\n燃烧性：易燃\r\n闪点：<-50\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：300ppb，8小时(豚鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入。\r\n健康危害：对上呼吸道粘膜和眼结膜有强烈的刺激作用。急性中毒：接触数分钟至 3小时内，陆续出现中毒症状：流泪、咽痛、咳嗽，伴有胸闷、胸痛。重者进一步发展为化学性肺炎或肺水肿，患者出现呼吸困难，心率加快，面色苍白，皮肤粘膜紫绀。除呼吸系统症状外，可伴有畏寒、发热。接触本?\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热能引起燃烧爆炸。与氧化剂接触猛烈反应。\r\n', '强氧化剂、水、硝酸。', '752', '非金属氢化物', '2202', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (380, '7990-91-2', '23015', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离易燃、可燃物。防止气体或蒸气泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止\0', 'chlorine trifluoride', 'ClF3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离300m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。若是气体，喷雾状水稀释。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏\0', '三氟化氯', '外观与性状：无色气体或绿色液体。\r\n熔点(℃)：-76.3\r\n相对密度(水=1)：\r\n沸点(℃)：11.3\r\n相对密度(空气=1)：3.14\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：用作氟化剂、燃烧剂、推进剂中的氧化剂、高温金属的切割油。\r\n主要成分：纯品\r\nCAS号：7990-91-2\r\n相对分子质量：92.45\r\n化学类别：7990-91-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢、氯化氢。\r\n急性毒性：LD50：\r\nLC50：299ppm，1小时(大鼠吸入)；178mg/m3，1小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、氧化剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入。\r\n健康危害：对皮肤、粘膜有刺激作用。\r\n危险特性：强氧化剂。能与多种物品发生具有危险性的强烈反应。遇有机物，立即自行燃烧爆炸。与水猛烈反应，放出氟化氢和氯气。并能与砂子以及其它含硅物品（如玻璃、石棉等）强烈反应，也能与金属和非金属元素激烈反应。\r\n', '强氧化剂、易燃或可燃物。', '741', '卤素与卤间化合物', '1749', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (381, '124-11-8', '33514', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧\0', '1-nonene', 'C9H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '1-壬烯；香茅烯', '外观与性状：无色液体。\r\n熔点(℃)：-81.4\r\n相对密度(水=1)：0.73\r\n沸点(℃)：146.9\r\n相对密度(空气=1)：4.35\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：5959.4\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：124-11-8\r\n相对分子质量：126.24\r\n化学类别：124-11-8\r\n燃烧性：易燃\r\n闪点：26(O.C)\r\n引燃温度：\r\n爆炸下限：0.8\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或口服对身体有害，其蒸气或雾对眼睛、皮肤、粘膜和呼吸道有刺激性。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。\r\n', '强氧化剂。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (382, '7783-60-0', '23019', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与酸类、接触。尤其要注意避免与水接触。搬运时戴好钢瓶安全帽和防\0', 'sulphur tetrafluoride；sulfur tetrafluoride', 'SF4', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离300m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '四氟化硫', '外观与性状：无色、带刺激性气味的气体。\r\n熔点(℃)：-124\r\n相对密度(水=1)：1.95(液);2.35(固)\r\n沸点(℃)：-38\r\n相对密度(空气=1)：3.7\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：91\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于苯。\r\n主要用途：用作氟化剂。\r\n主要成分：纯品\r\nCAS号：7783-60-0\r\n相对分子质量：108.05\r\n化学类别：7783-60-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：96mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与酸类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：具有强烈毒性的刺激性气体，可引起类似光气的呼吸道损害。实验动物有明显的肺水肿改变。\r\n危险特性：遇水或水蒸气、酸或酸气产生剧毒的烟雾。腐蚀性很强, 可腐蚀玻璃和大多数金属。\r\n', '潮湿空气、酸类、活性金属粉末。', '776', '非金属卤化物', '2418', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (383, '7783-80-4', '23024', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与碱类、接触。尤其要注意避免与水接触。搬运时\0', 'tellurium hexafluoride', 'TeF6', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。漏气容器要妥善处理，修复、检验后再用。', '六氟化碲', '外观与性状：无色、有蒜臭的气体。\r\n熔点(℃)：-37.6\r\n相对密度(水=1)：4.01(固);2.50(液)\r\n沸点(℃)：35.5\r\n相对密度(空气=1)：7.2\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作化学药品。\r\n主要成分：纯品\r\nCAS号：7783-80-4\r\n相对分子质量：241.61\r\n化学类别：7783-80-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、碱类、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入。\r\n健康危害：吸入高浓度可引起头痛、头晕、无力、恶心、呕吐、呼吸困难、呼气蒜臭味、口内金属味等症状，严重时肝、肾受损。对皮肤、眼睛、粘膜有强烈刺激性。\r\n危险特性：在水中分解放出剧毒的腐蚀性气体。具有腐蚀性。\r\n', '潮湿空气、强碱、易燃或可燃物。', '776', '非金属卤化物', '2195', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (384, '7783-82-6', '23025', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体或蒸气泄漏到工作场所空气中。避免与活性金属粉末、接触。尤其要注意避免与水接触。搬运时戴好钢瓶安全帽\0', 'tungsten hexafluoride；tungstenfluoride', 'WF6', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。若是气体，合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。若是液体，用干燥的砂土或类似物质吸收，若大量泄漏，构筑围堤或\0', '六氟化钨', '外观与性状：无色气体或浅黄色液体或固体，固体为易潮解的白色结晶, 接触潮湿空气冒烟。\r\n熔点(℃)：2.3\r\n相对密度(水=1)：3.44(15℃)\r\n沸点(℃)：17.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：171\r\n临界压力(MPa)：0.45\r\n辛醇/水分配系数：\r\n溶解性：溶于多数有机溶剂。\r\n主要用途：用于钨的化学蒸镀, 用作氟化剂。\r\n主要成分：纯品\r\nCAS号：7783-82-6\r\n相对分子质量：297.8\r\n化学类别：7783-82-6\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与活性金属粉末、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：遇潮湿、空气或水分解，散发出剧毒和有腐蚀性的氟化氢烟雾。本品可引起眼睛、皮肤和粘膜非常严重的灼伤。\r\n危险特性：能与许多物质发生化学反应。遇潮气、空气或水解, 放出剧毒的腐蚀性氟化氢气体。腐蚀性很强, 能侵蚀几乎所有的金属, 能迅速腐蚀湿的玻璃。\r\n', '空气、水、活性金属粉末。', '797', '金属卤化物', '2196', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (385, '460-19-5', '23028', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。保持良好的卫生习惯。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体\0', 'cyanogen', 'C2N2', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。如有可能，将残余气或漏出\0', '氰', '外观与性状：无色气体，具有类似杏仁的气味。\r\n熔点(℃)：-34.4\r\n相对密度(水=1)：0.96\r\n沸点(℃)：-21.2\r\n相对密度(空气=1)：2.34\r\n饱和蒸气压(kPa)：53.32/-33℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、易溶于乙醇、乙醚、等\r\n主要用途：用作熏蒸剂及有机合成原料。\r\n主要成分：纯品\r\nCAS号：460-19-5\r\n相对分子质量：52.04\r\n化学类别：460-19-5\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：6.6\r\n爆炸上限：42.6\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氰化氢、氧化氮。\r\n急性毒性：LD50：\r\nLC50：350ppm，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过10℃。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制\0', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，高毒，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：氰的刺激性比氰化氢略弱，而毒性则小得多。氰的轻度中毒，病人出现乏力、头痛、头昏、胸闷及粘膜刺激症状；严重中毒者，呼吸困难，意识丧失，出现惊厥，最后可因呼吸中枢麻痹而死亡。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热能引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。遇水或水蒸气、酸或酸气产生剧毒的烟雾。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '水、酸类、强氧化剂。', '743', '腈', '1026', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (386, '10036-47-2', '23031', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。远离易燃、可燃物。防止气体或蒸气泄漏到工作场所空气中。避免与还原剂、接触。禁止震动、撞击和摩擦。\0', 'tetrafluorohydrazine；dinitrogen tetrafluoride', 'N2F4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将漏出气用排风机送至空旷地方或装设适当喷头烧掉。漏气容器要妥善处理，修复、检验后再用。', '四氟(代)肼', '外观与性状：无色气体。\r\n熔点(℃)：-163\r\n相对密度(水=1)：1.5(-100℃)\r\n沸点(℃)：-73\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：10036-47-2\r\n相对分子质量：104.0\r\n化学类别：10036-47-2\r\n燃烧性：不燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物、氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入。\r\n健康危害：本品剧毒。热解放出高毒的氮氧化物和氟化氢气体。\r\n危险特性：遇热、撞击或在容器中受压时能引起爆炸。与还原剂接触能引起爆炸性反应，与三氯化氮、氧气接触会发生剧烈反应。遇氢气自燃，并引起爆炸。\r\n', '强还原剂、易燃或可燃物、空气、氧。', '762', '脂肪胺', '1955', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (387, '684-16-2', '23032', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与氧化剂、醇类、接触。尤其要注意避免与水接触。搬运时轻装轻卸，防止钢瓶及\0', 'hexafluoroacetone', 'C3F6O', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器\0', '六氟丙酮', '外观与性状：无色气体。\r\n熔点(℃)：-125.5\r\n相对密度(水=1)：1.32\r\n沸点(℃)：-27.3\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：2.84\r\n辛醇/水分配系数：\r\n溶解性：溶于氯代烃。\r\n主要用途：用作溶剂，用于医药、农药和一些化学品的合成。\r\n主要成分：纯品\r\nCAS号：684-16-2\r\n相对分子质量：166.03\r\n化学类别：684-16-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：275ppm，3小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、醇类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒，具强刺激性。\r\n侵入途径：吸入。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入后可因咽喉、支气管的痉挛、水肿，化学性肺炎或肺水肿而致死。症状有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇水发生强力反应放出热量。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '水、醇类、强氧化剂。', '775', '酮', '2420', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (388, '463-58-1', '23033', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免\0', 'carbonyl sulfide；carbon oxysulfide', 'COS', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。如有可能，将漏出气用排风\0', '硫化羰；氧硫化碳', '外观与性状：无色恶臭气体, 易潮解。\r\n熔点(℃)：-138.2\r\n相对密度(水=1)：1.24(-87℃,液体)\r\n沸点(℃)：-50.2\r\n相对密度(空气=1)：2.1\r\n饱和蒸气压(kPa)：1204.23(21℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于乙醇、甲苯。\r\n主要用途：合成含硫的有机化合物。\r\n主要成分：纯品\r\nCAS号：463-58-1\r\n相对分子质量：60.07\r\n化学类别：463-58-1\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：12\r\n爆炸上限：28.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入。\r\n健康危害：本品对肺有轻微刺激性，主要作用于中枢神经系统，严重中毒时可引起抽搐，乃至发生呼吸麻痹而死亡。\r\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热能引起燃烧爆炸。燃烧时生成有毒的二氧化硫气体。与氧化剂接触猛烈反应。遇水或水蒸气反应放出有毒和易燃的气体。\r\n', '强氧化剂、碱类。', '783', '硫化物', '2204', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (389, '2699-79-8', '23034', '监测方法：直接进样－气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与碱类、接触。尤其要注意避免与水接触。搬运时戴好钢瓶安全帽和防\0', 'sulfuryl fluoride；sulfuric oxyfluoride', 'F2O2S', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离300m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '硫酰氟；氟氧化硫', '外观与性状：无色、无臭气体。\r\n熔点(℃)：-137\r\n相对密度(水=1)：1.7(液体)\r\n沸点(℃)：-55\r\n相对密度(空气=1)：3.5\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、苯、四氯化碳。\r\n主要用途：用作分析试剂、药品、染料、杀虫剂及熏蒸剂的成分。\r\n主要成分：纯品\r\nCAS号：2699-79-8\r\n相对分子质量：102.1\r\n化学类别：2699-79-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化硫、氟化氢。\r\n急性毒性：LD50：100mg/kg(豚鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与碱类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品的急性毒作用主要损害中枢神经系统，引起惊厥。\r\n危险特性：遇水或水蒸气反应放热并产生有毒的腐蚀性气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强碱、水。', '753', '无机酰卤', '2191', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (390, '353-50-4', '23035', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。注意检测毒物。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。避免与氧化剂、接触。尤其要注意避免与水接触。搬运时戴好钢瓶安全帽和\0', 'fluorophosgene；carbonyl fluoride', 'OCF2', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '氟光气；碳酰氟', '外观与性状：带有刺激性的无色气体, 遇水分解。\r\n熔点(℃)：-114\r\n相对密度(水=1)：1.14(-114℃)\r\n沸点(℃)：-83\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇。\r\n主要用途：用于生产氟塑料等。\r\n主要成分：纯品\r\nCAS号：353-50-4\r\n相对分子质量：66.01\r\n化学类别：353-50-4\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氟化氢。\r\n急性毒性：LD50：\r\nLC50：270mg/m3，4小时(大鼠吸入)；972mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒，具强刺激性。\r\n侵入途径：吸入。\r\n健康危害：本品对呼吸道粘膜具有强烈的刺激作用。急性中毒可致化学性肺炎和肺水肿。因本品常和氟烃的其他热裂解气共存, 故很少见到单纯氟光气中毒的报道。在热裂解气中毒所致呼吸道损害中，氟光气是一种重要的致病因子。\r\n危险特性：在水中分解放出剧毒的腐蚀性气体。具有强腐蚀性。\r\n', '强氧化剂、潮湿空气。', '741', '卤素与卤间化合物', '2417', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (391, '71-41-0', '33553', '监测方法：对二甲氨基苯甲醛比色法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1-amyl alcohol；1-pentanol', 'C5H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '1-戊醇；正戊醇', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：-78.2\r\n相对密度(水=1)：0.81\r\n沸点(℃)：137.8\r\n相对密度(空气=1)：3.04\r\n饱和蒸气压(kPa)：1.33(44.9℃)\r\n燃烧热(kJ/mol)：3317.7\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.16\r\n溶解性：微溶于水、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成，药物制造。\r\n主要成分：纯品\r\nCAS号：71-41-0\r\n相对分子质量：88.15\r\n化学类别：71-41-0\r\n燃烧性：易燃\r\n闪点：33\r\n引燃温度：300\r\n爆炸下限：1.2\r\n爆炸上限：10.0\r\n最小点火能：\r\n最大爆炸压力：0.740\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2200mg/kg(大鼠经口)；3600mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害，其蒸气或雾对眼睛、皮肤、粘膜和上呼吸道有刺激作用。还可引起头痛、眩晕、呼吸困难、咳嗽、恶心、呕吐、腹泻等；严重者有复视、耳聋、谵妄等，有时出现高铁血红蛋白血症。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受热放出辛辣的腐蚀性烟雾。与氧化剂接触猛烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强酸、强氧化剂、酰基氯、酸酐。', '789', '醇', '1105', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (392, '106-48-9', '61703', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬\0', 'p-chlorophenol', 'C6H5ClO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '对氯酚；对氯苯酚', '外观与性状：白色结晶，有不愉快气味。\r\n熔点(℃)：42.8\r\n相对密度(水=1)：1.30\r\n沸点(℃)：217\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(49.8℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、醚、苯。\r\n主要用途：用作染料及药品合成的中间体。\r\n主要成分：纯品\r\nCAS号：106-48-9\r\n相对分子质量：128.56\r\n化学类别：106-48-9\r\n燃烧性：可燃\r\n闪点：115\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：670mg/kg(大鼠经口)；1500mg/kg(兔经皮)\r\nLC50：11mg/m3(大鼠吸入)\r\n致癌性：IARC致癌性评论：对人可能致癌。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为可疑致癌物，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道及皮肤有强烈刺激作用。吸入后可能因喉、支气管的炎症、水肿、痉挛，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、头痛和恶心。给动物本品后几分钟后即出现不安、呼吸加速，并迅速发展为无力、震颤、阵挛性抽搐、气急、昏迷甚至死亡?\n危险特性：遇明火、高热可燃。受高热分解产生有毒的腐蚀性烟气。与强氧化剂接触可发生化学反应。具有腐蚀性。\r\n', '强氧化剂、强酸、酰基氯、酸酐。', '742', '酚', '2020', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (393, '107-14-2', '61634', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'chloroacetonitrile；chloromethyl cyanide', 'C2H2ClN', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制\0', '氯乙腈；氰化氯甲烷', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.19\r\n沸点(℃)：126(分解)\r\n相对密度(空气=1)：3.0\r\n饱和蒸气压(kPa)：1.06(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于烃类、醇。\r\n主要用途：用作杀虫剂，有机合成中间体。\r\n主要成分：纯品\r\nCAS号：107-14-2\r\n相对分子质量：75.50\r\n化学类别：107-14-2\r\n燃烧性：易燃\r\n闪点：47\r\n引燃温度：\r\n爆炸下限：1\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氯化氢。\r\n急性毒性：LD50：220mg/kg(大鼠经口)；71mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：如吸入、口服或经皮肤吸收，可能引起死亡。蒸气或雾对眼、粘膜和上呼吸道有刺激性。可引起紫绀。\r\n危险特性：遇明火、高热易燃。受热分解释出高毒蒸气。遇水或水蒸气、酸或酸气产生有毒的可燃性气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强酸、强碱、水。', '800', '未指定的化学类别', '2668', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (394, '74-97-5', '61574', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴循环式氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。防止蒸气泄漏到工作场所空气中。避免与碱金属、接触。搬运时要轻装轻卸，防止包装及容器损坏。\0', 'chlorobromomethane；monochloromonobromomethane', 'CH2BrCl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：\0', '氯溴甲烷；亚甲基溴氯', '外观与性状：无色透明液体，有类似氯仿的特殊气味。\r\n熔点(℃)：-88\r\n相对密度(水=1)：1.94\r\n沸点(℃)：69～71\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：19.62(25℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：297\r\n临界压力(MPa)：6.08\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、丙酮、乙醚、苯、四氯化碳、等多数有机溶剂。\r\n主要用途：用作小型灭火剂，还用作矿物浮选剂和涂料的渗透剂。\r\n主要成分：纯品\r\nCAS号：74-97-5\r\n相对分子质量：129.38\r\n化学类别：74-97-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、溴化氢。\r\n急性毒性：LD50：5000mg/kg(大鼠经口)；4300mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与碱金属、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有刺激性，高浓度有麻醉作用。接触后引起眼和上呼吸道刺激，精神错乱，头晕，甚至发生神志丧失。皮肤接触液状本品，引起刺痛感，继续接触可致皮炎。长期或反复接触，对皮肤有刺激作用。\r\n危险特性：受高热分解放出有毒的气体。与碱金属能发生剧烈反应。\r\n', '碱金属。', '759', '卤代烷', '1887', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (395, '7783-79-1', '23023', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。防止气体泄漏到工作场所空气中。远离易燃、可燃物。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。', 'selenium hexafluoride；selenium fluoride', 'SeF6', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。喷雾状水稀释。漏气容器要妥善处理，修复、检验后再用。', '六氟化硒', '外观与性状：无色、有气味的气体。\r\n熔点(℃)：-39(升华)\r\n相对密度(水=1)：3.25(-25℃)\r\n沸点(℃)：-34.5\r\n相对密度(空气=1)：7.1\r\n饱和蒸气压(kPa)：86.8(-48.7℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作氟化剂。\r\n主要成分：纯品\r\nCAS号：7783-79-1\r\n相对分子质量：192.95\r\n化学类别：7783-79-1\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。应严格执行极毒物品“五双”管理制度。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，剧毒，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：对粘膜有刺激作用。动物吸入引起呼吸困难，可因肺水肿而致死。\r\n危险特性：不燃的剧毒气体。\r\n', '易燃或可燃物。', '776', '非金属卤化物', '2194', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (396, '103-16-2', NULL, '监测方法：4-氨基安替比林分光光度法；溶剂解吸－气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：尽可能减少直接接触。工作完毕，淋浴更衣。工作服不准带至非作业场所。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、碱类、\0', 'p-benzyloxyphenol；benzyl hydroquinone', 'C13H12O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '对苄氧基苯酚；氢醌苄基醚', '外观与性状：淡褐色固体。\r\n熔点(℃)：122.5\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于冷水、易溶于热水、丙酮、等多数有机溶剂。\r\n主要用途：在橡胶工业中用作抗氧剂。\r\n主要成分：纯品\r\nCAS号：103-16-2\r\n相对分子质量：200.23\r\n化学类别：103-16-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤、粘膜和上呼吸道有刺激作用，有报道可引起接触性皮炎。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强碱。', '742', '酚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (397, '112-84-5', NULL, '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：空气中粉尘浓度超标时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：及时换洗工作服。保持良好的卫生习惯。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接\0', 'erucamide；erucylamide', 'C22H43NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '芥酸酰胺；二十二烯酸酰胺', '外观与性状：气味柔和的固体。\r\n熔点(℃)：75-80\r\n相对密度(水=1)：0.89\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于乙醇、丙酮。\r\n主要用途：用作热塑性塑料的润滑剂、分离剂、防粘剂、内脱模剂。\r\n主要成分：纯品\r\nCAS号：112-84-5\r\n相对分子质量：337.59\r\n化学类别：112-84-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：目前，未见职业中毒的报道资料。\r\n危险特性：遇明火、高热可燃。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂、强酸。', '767', '酰胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (398, NULL, '51522', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，\0', 'rhodium nitrate', 'Rh(NO3)3', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硝酸铑', '外观与性状：棕黄色结晶或红色结晶。\r\n熔点(℃)：分解\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：易溶于水。\r\n主要用途：用作氧化剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：288.90\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、还原剂、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃。\r\n侵入途径：吸入、食入。\r\n健康危害：毒性很小，迄今未见有中毒病例报告。但其热解可放出有毒的氮氧化物气体。\r\n危险特性：无机氧化剂。与可燃物的混合物易于着火，并会猛烈燃烧。具有腐蚀性。\r\n', '还原剂、易燃或可燃物。', '793', '硝酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (399, NULL, '61820', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。\0', '4,4-dinitrodiphenyl carbazide；p,p\'-dinitrodipheny', 'C13H12N6O5', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '4,4\'-二硝基二苯基二氨基脲；4,4-二硝基二苯基卡巴肼', '外观与性状：淡黄色针状结晶或粉末。\r\n熔点(℃)：361\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、不溶于醚、溶于醇。\r\n主要用途：分析上用于测定镉。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：332.23\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：受高热分解出有毒气体。对人有毒，有刺激性。\r\n危险特性：可燃。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (400, '7783-70-2', '81061', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离易燃、可燃物。防止蒸气泄漏到工作场所空气中。避免与醇类、接触。尤其要注意避免与水接触。在氮气中操作处置。搬\0', 'antimony pentafluoride', 'SbF5', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或专用收集器内，回收或运至废物处理场所处\0', '五氟化锑', '外观与性状：无色油状液体。\r\n熔点(℃)：\r\n相对密度(水=1)：2.99\r\n沸点(℃)：149.5\r\n相对密度(空气=1)：2.2\r\n饱和蒸气压(kPa)：1.33/25℃\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于无水乙醇。\r\n主要用途：用于制取锑化合物。\r\n主要成分：纯品\r\nCAS号：7783-70-2\r\n相对分子质量：216.74\r\n化学类别：7783-70-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氟化氢、氧化锑。\r\n急性毒性：LD50：\r\nLC50：270mg/m3(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、醇类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品不燃，高毒，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。吸入可能由于喉、支气管痉挛、水肿、炎症，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：不燃。强氧化剂。接触有机物有引起燃烧的危险。遇磷酸盐能强烈反应。遇水剧烈反应生成刺激性和腐蚀性极强的氟化氢，并伴有响声。遇潮时对玻璃、其它硅质材料及大多数金属有强腐蚀性。\r\n', '水、醇类、易燃或可燃物。', '797', '金属卤化物', '1732', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (401, '3497-00-5', '81130', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所\0', 'benzene phosphorus thiodichloride；phenyl phosphor', 'C6H5Cl2PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '苯硫代磷酰二氯；苯硫代二氯化膦', '外观与性状：无色液体, 在空气中微发烟。\r\n熔点(℃)：\r\n相对密度(水=1)：1.38\r\n沸点(℃)：205(17.33kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：17.33(205℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：3497-00-5\r\n相对分子质量：211.05\r\n化学类别：3497-00-5\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：接触潮气可分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫、氯化氢、氧化磷。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：误服或吸入会中毒。对皮肤、眼睛和粘膜有刺激性和腐蚀性。\r\n危险特性：可燃。遇水或水蒸气反应放出有毒和易燃的气体。\r\n', '强氧化剂、强碱、潮湿空气。', '739', '有机酰卤', '2799', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (402, '2524-03-0', '81131', '监测方法：\r\n工程控制：密闭操作，局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所\0', 'O,O\'-dimethylthiophosphoryl chloride', 'C2H6ClO2PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', 'O,O\'-二甲基硫代磷酰氯', '外观与性状：无色或微黄色液体，有令人窒息的刺激性气味。\r\n熔点(℃)：无资料\r\n相对密度(水=1)：1.33\r\n沸点(℃)：66/2.13kPa\r\n相对密度(空气=1)：无资料\r\n饱和蒸气压(kPa)：0.32/40℃\r\n燃烧热(kJ/mol)：无资料\r\n临界温度(℃)：无资料\r\n临界压力(MPa)：无资料\r\n辛醇/水分配系数：无资料\r\n溶解性：不溶于水、溶于苯、氯仿、乙醚、等多数有机溶剂。\r\n主要用途：用于合成有机磷杀虫剂。\r\n主要成分：纯品\r\nCAS号：2524-03-0\r\n相对分子质量：160.56\r\n化学类别：2524-03-0\r\n燃烧性：可燃\r\n闪点：105\r\n引燃温度：无资料\r\n爆炸下限：无资料\r\n爆炸上限：无资料\r\n最小点火能：无资料\r\n最大爆炸压力：无资料\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氯化氢、氧化硫、磷烷。\r\n急性毒性：LD50：1800mg/kg(小鼠经口)\r\nLC50：340mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，有毒，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：过量接触刺激上呼吸道。高浓度对肺有刺激性，出现咳嗽、不适、呼吸困难等。患呼吸系统疾病者，对本毒物的敏感性增加。\r\n危险特性：遇明火、高热可燃。当加热到 120℃以上时，开始急剧分解。若遇高热可发生剧烈分解，引起容器破裂或爆炸事故。遇水或醇分解释出有毒烟雾。具有腐蚀性。\r\n', '强氧化剂、强碱。', '739', '有机酰卤', '2267', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (403, '131-73-7', '11073', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿紧袖工作服，长筒胶鞋。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿紧袖工作服，长筒胶鞋，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂\0', '2,4,6,2\',4\',6\'-hexanitrodiphenylamine；Hexyl', 'C12H7N6O12', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。避免震动、撞击和摩擦。小量泄漏：用干石灰、苏打灰覆盖，收集于密闭容器中做好标记，待处理。大量泄漏：与有关技术部门联系，确定清除方法。', '2,4,6,2\',4\',6\'-六硝基二苯胺；黑喜尔', '外观与性状：黄色针状或菱形结晶，对光敏感。\r\n熔点(℃)：240～241\r\n相对密度(水=1)：1.64\r\n沸点(℃)：爆炸\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、乙醇、微溶于丙酮、溶于碱、热乙酸。\r\n主要用途：用于制造弹药及用作钾盐的分析。\r\n主要成分：\r\nCAS号：131-73-7\r\n相对分子质量：439.22\r\n化学类别：131-73-7\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：大鼠和小鼠经口1179mg/kg，小鼠发生肝细胞癌，大鼠无肿瘤发生。\r\n', '储存于阴凉、干燥、通风的专用爆炸品库房。远离火种、热源。应与氧化剂、酸类、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。禁止震动、撞击和摩擦。', '危险性类别：第 1 类  爆炸品\r\n危险性综述：本品属爆炸品，可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体可能有害。对眼睛、皮肤、粘膜和呼吸道有刺激作用。\r\n危险特性：受热、接触明火、或受到摩擦、震动、撞击时可发生爆炸。\r\n', '强氧化剂、强酸、强碱。', '787', '硝基芳香化合物', '0079', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (404, '112-16-3', '81633', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶耐酸碱手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶耐酸碱手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类\0', 'lauroyl chloride；dodecanoyl chloride', 'C12H23ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '十二(烷)酰氯；月桂酰氯', '外观与性状：无色液体。\r\n熔点(℃)：-17\r\n相对密度(水=1)：0.92\r\n沸点(℃)：145/2.40kPa\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.47/137℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于乙醚、苯。\r\n主要用途：用于制药工业和有机合成。\r\n主要成分：纯品\r\nCAS号：112-16-3\r\n相对分子质量：218.78\r\n化学类别：112-16-3\r\n燃烧性：可燃\r\n闪点：>112\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、碱类、醇类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第8.1类  酸性腐蚀品\r\n危险性综述：本品可燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对粘膜、上呼吸道、眼和皮肤有强烈的刺激性。吸入后，可因喉及支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。可致灼伤。\r\n危险特性：遇明火、高热可燃。受热分解释出高毒烟雾。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。遇潮时对大多数金属有腐蚀性。\r\n', '强氧化剂、强酸、强碱、水、醇类。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (405, '97-88-1', '33601', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴直接式防毒面具（半面罩）。必要时，佩戴导管式防毒面具或自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'n-butyl methacrylate；methacrylic acid n-butyl est', 'C8H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围\0', '甲基丙烯酸正丁酯；异丁酸正丁酯', '外观与性状：无色、具有甜味和酯气味的液体。\r\n熔点(℃)：<-50\r\n相对密度(水=1)：0.90(20℃)\r\n沸点(℃)：160\r\n相对密度(空气=1)：4.91\r\n饱和蒸气压(kPa)：0.65(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚、溶于多数有机溶剂。\r\n主要用途：用于有机合成, 制造塑料、光学玻璃的粘结剂，纺织、皮革及造纸用助剂。\r\n主要成分：纯品\r\nCAS号：97-88-1\r\n相对分子质量：142.22\r\n化学类别：97-88-1\r\n燃烧性：易燃\r\n闪点：41.1\r\n引燃温度：259\r\n爆炸下限：2\r\n爆炸上限：8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：光照、受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1490mg/kg(小鼠腑腔内)；11300mg/kg(兔经皮)\r\nLC50：19689mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤、粘膜有中等刺激作用。接触后可能有烧灼感、咳嗽、眩晕、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，遇明火、高热能引起燃烧爆炸。在受热、光和紫外线的作用下易发生聚合，粘度逐渐增加，严重时整个容器的单体可全部发生不规则爆发性聚合。\r\n', '强氧化剂、强酸、强碱。', '781', '丙烯酰基化合物', '2227', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (406, '119-27-7', '41013', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防毒物渗透手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿透气型防毒服，戴防毒物渗透手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。搬\0', '2,4-dinitroanisole', 'C7H6N2O5', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。使用无火花工具收集回收或运至废物处理场所处置。', '2,4-二硝基苯甲醚；2,4-二硝基茴香醚', '外观与性状：无色到黄色针状结晶体。\r\n熔点(℃)：89\r\n相对密度(水=1)：1.34\r\n沸点(℃)：\r\n相对密度(空气=1)：6.83\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于热水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于染料中间体及用作杀虫卵剂。\r\n主要成分：纯品\r\nCAS号：119-27-7\r\n相对分子质量：198.14\r\n化学类别：119-27-7\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。包装密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第4.1类  易燃固体\r\n危险性综述：本品易燃，具爆炸性，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品吸收进入体内后，可引起高铁血红蛋白血症，出现紫绀。具有刺激性。\r\n危险特性：易燃，遇明火、高热、摩擦、撞击有引起燃烧的危险。燃烧时放出有毒的刺激性烟雾。与氧化剂混合能形成爆炸性混合物。\r\n', '强氧化剂、强碱。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (407, '581-89-5', '41513', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、接触。搬运时要轻装轻\0', '2-nitronaphthalene', 'C10H7NO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。使用无火花工具收集回收或运至废物处理场所处置。', '2-硝基萘', '外观与性状：无色结晶。\r\n熔点(℃)：79\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：97.8(312.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等\r\n主要用途：用于制造染料，及用于有机合成。\r\n主要成分：纯品\r\nCAS号：581-89-5\r\n相对分子质量：173.16\r\n化学类别：581-89-5\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：4400mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：狗经口最低中毒剂量(TDL0)：2400mg/kg(34周)，致肿瘤阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第4.1类  易燃固体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有刺激性。眼接触可引起结膜炎，严重时可致角膜损害。\r\n危险特性：遇明火、高热易燃。受高热分解, 放出有毒的蒸气。与氧化剂混合能形成爆炸性混合物。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂、强还原剂。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (408, '100-99-2', '42022', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：作业时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，必须佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'aluminium triisobutyl；triisobutylaluminium', 'C12H27Al', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用防爆泵转移至槽车或专用收集器\0', '三异丁基铝', '外观与性状：无色澄清液体，具有强烈的霉烂气味。\r\n熔点(℃)：-5.6\r\n相对密度(水=1)：0.78\r\n沸点(℃)：114(4.00kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(47℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯。\r\n主要用途：用于有机合成及作聚合烯烃的催化剂。\r\n主要成分：纯品\r\nCAS号：100-99-2\r\n相对分子质量：198.33\r\n化学类别：100-99-2\r\n燃烧性：易燃\r\n闪点：<0\r\n引燃温度：<4\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化铝。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存时必须用充有惰性气体或特定的容器包装。储存于阴凉、通风的库房。远离火种、热源。库温不超过25℃，相对湿度不超过75％。包装要求密封，不可与空气接触。应与氧化剂、酸类、醇类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具\0', '危险性类别：第4.2类  自燃物品\r\n危险性综述：本品易燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：本品具有强烈的刺激性和腐蚀性，主要损害呼吸道和眼结膜。高浓度吸入时可引起中毒性肺水肿。吸入其烟雾可发生金属烟雾热。皮肤接触可致灼伤，产生充血、水肿和水疱，疼痛剧烈。\r\n危险特性：化学反应活性很高，接触空气会冒烟自燃。对微量的氧及水分反应极其灵敏，易引起燃烧爆炸。与氧化剂能发生强烈反应。遇水强烈分解, 放出易燃的烷烃气体。遇高温剧烈分解。\r\n', '强氧化剂、酸类、水、空气、氧、醇类。', '794', '金属烃基化合物', '3051', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (409, NULL, '51517', '监测方法：双硫腙比色法；火焰原子吸收光谱法；石墨炉原子吸收光谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬\0', 'lead iodate；lead(Ⅱ) iodate', 'Pb(IO3)2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：避免扬尘，使用无火花工具收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后\0', '碘酸铅', '外观与性状：白色粉末。\r\n熔点(℃)：300(分解)\r\n相对密度(水=1)：6.16\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于硝酸、不溶于氨水、醇。\r\n主要用途：用于烟花配制及用作氧化剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：557.05\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：碘化氢、氧化铅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，剧毒。\r\n侵入途径：吸入、食入。\r\n健康危害：铅及其化合物损害造血、神经、消化系统及肾脏。职业中毒主要为慢性。神经系统主要表现为神经衰弱综合征、周围神经病(以运动功能受累较明显)，重者出现铅中毒性脑病。消化系统表现有齿龈铅线、食欲不振、恶心、腹胀、腹泻或便秘；腹绞痛见于中度及重度中毒病例。造血系统损害?\n危险特性：无机氧化剂。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。受热分解放出有毒的碘化物烟气。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '764', '卤素含氧酸盐', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (410, '7727-21-1', '51504', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴头罩型电动送风过滤式防尘呼吸器。高浓度环境中，建议佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。避免产生粉尘。避免与还原剂、活性金属粉末、碱类、醇类、接触。搬运时要轻装轻卸，防\0', 'potassium persulfate', 'K2S2O8', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与有机物、还原剂、易燃物接触。小量泄漏：将地面洒上苏打灰，收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回\0', '过硫酸钾；高硫酸钾', '外观与性状：白色结晶，无气味，有潮解性。\r\n熔点(℃)：\r\n相对密度(水=1)：2.48\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、不溶于乙醇。\r\n主要用途：用作漂白剂、还原剂、照相药品、分析试剂、聚合促进剂等。\r\n主要成分：纯品\r\nCAS号：7727-21-1\r\n相对分子质量：270.32\r\n化学类别：7727-21-1\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氧化硫、氧气。\r\n急性毒性：LD50：802mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装密封。应与还原剂、活性金属粉末、碱类、醇类、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品粉尘对鼻、喉和呼吸道有刺激性，引起咳嗽及胸部不适。对眼有刺激性。吞咽刺激口腔及胃肠道，引起腹痛、恶心和呕吐。慢性影响：过敏性体质者接触可发生皮疹。\r\n危险特性：无机氧化剂。与有机物、还原剂、易燃物如硫、磷等接触或混合时有引起燃烧爆炸的危险。急剧加热时可发生爆炸。\r\n', '强还原剂、活性金属粉末、强碱、水、醇类。', '798', '高锰酸盐', '1492', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (411, '12372-57-5', '51064', '监测方法：二甲酚橙比色法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。避免产生粉尘。避免与还原剂、接触。搬运时要轻装轻卸，\0', 'zirconium nitrate；dusicnan zirkonicity', 'Zr(NO3)4', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。勿使泄漏物与还原剂、有机物、易燃物或金属粉末接触。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。或用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回\0', '硝酸锆', '外观与性状：白色板状结晶, 有吸湿性。\r\n熔点(℃)：\r\n相对密度(水=1)：1.40\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：无意义\r\n临界压力(MPa)：无意义\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇。\r\n主要用途：用作防腐剂、试剂及用于锆盐制造。\r\n主要成分：纯品\r\nCAS号：12372-57-5\r\n相对分子质量：339.24\r\n化学类别：12372-57-5\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：3170mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装必须完整密封，防止吸潮。应与易燃物或可燃物、还原剂、等分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第5.1类  氧化剂\r\n危险性综述：本品助燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜有刺激作用。工业上接触尚未见有中毒病例。在高温下可分解，释放出剧毒的氮氧化物气体，吸入后可引起中毒。\r\n危险特性：无机氧化剂。遇可燃物着火时，能助长火势。与还原剂、有机物、易燃物如硫、磷或金属粉末等混合可形成爆炸性混合物。受高热分解，产生有毒的氮氧化物。\r\n', '还原剂、易燃或可燃物、活性金属粉末、硫、磷。', '793', '硝酸盐', '2728', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (412, '95-55-6', '61720', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻\0', '2-aminophenol；o-aminophenol', 'C6H7NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '2-氨基苯酚；邻氨基苯酚', '外观与性状：白色或浅灰色结晶粉末。\r\n熔点(℃)：170～174\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用于制造染料、药物、塑料固化剂。\r\n主要成分：纯品\r\nCAS号：95-55-6\r\n相对分子质量：109.12\r\n化学类别：95-55-6\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1300mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入过量的本品粉尘，可引起高铁血红蛋白血症。有致敏作用，能引起支气管哮喘及接触性变应性皮炎。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、酰基氯、酸酐、酸类、氯仿。', '742', '酚', '2512', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (413, '75-03-6', '61571', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴循环式氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、接\0', 'iodoethane；ethyl iodide', 'C2H5I', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '碘乙烷；乙基碘', '外观与性状：无色澄清重质液体，有醚的气味。\r\n熔点(℃)：-108\r\n相对密度(水=1)：1.93\r\n沸点(℃)：72.4\r\n相对密度(空气=1)：5.38\r\n饱和蒸气压(kPa)：13.33(18.0℃)\r\n燃烧热(kJ/mol)：1490.6\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：2.0\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于医药，有机合成。\r\n主要成分：纯品\r\nCAS号：75-03-6\r\n相对分子质量：155.97\r\n化学类别：75-03-6\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、碘化氢。\r\n急性毒性：LD50：330mg/kg(大鼠静脉)；560mg/kg(小鼠静脉)\r\nLC50：65000mg/m3，1/2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装要求密封，不可与空气接触。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入对呼吸道有强烈刺激性，并出现麻醉作用，可有肝、肾损害。眼和皮肤接触引起强烈刺激，甚至发生灼伤。可经皮肤迅速吸收。口服灼伤消化道。\r\n危险特性：遇明火、高热能燃烧。遇高热时能分解出有毒的碘化物烟雾。遇水或水蒸气反应放热并产生有毒的腐蚀性气体。与氧化剂接触猛烈反应。\r\n', '强氧化剂、强碱。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (414, '97-95-0', '33554', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。\0', '2-ethylbutyl alcohol；2-ethyl butanol', 'C6H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '2-乙基丁醇', '外观与性状：无色液体。\r\n熔点(℃)：-114.4\r\n相对密度(水=1)：0.83\r\n沸点(℃)：148.9\r\n相对密度(空气=1)：3.4\r\n饱和蒸气压(kPa)：0.12/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用作溶剂，用于有机合成。\r\n主要成分：纯品\r\nCAS号：97-95-0\r\n相对分子质量：102.18\r\n化学类别：97-95-0\r\n燃烧性：易燃\r\n闪点：58\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1850mg/kg(大鼠经口)；1260mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收，对机体有害。对皮肤有刺激性。对眼有强烈刺激作用，接触后引起眼损害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。受热放出辛辣的烟气。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '789', '醇', '2275', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (415, '108-11-2', '33554', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'methyl isobutylcarbinol；1,3-dimethylbutanol', 'C6H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '甲基异丁基甲醇；1,3-二甲基丁醇', '外观与性状：无色液体。\r\n熔点(℃)：-90\r\n相对密度(水=1)：0.81(20℃)\r\n沸点(℃)：131.8\r\n相对密度(空气=1)：3.52\r\n饱和蒸气压(kPa)：0.37(70℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：312\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇、烃类、多数有机溶剂。\r\n主要用途：用于制造泡沫剂、浮选剂以及添加剂、润滑剂、溶剂、稳定剂、喷漆和用于有机合成。\r\n主要成分：纯品\r\nCAS号：108-11-2\r\n相对分子质量：102.18\r\n化学类别：108-11-2\r\n燃烧性：易燃\r\n闪点：41\r\n引燃温度：\r\n爆炸下限：1.0\r\n爆炸上限：5.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2590mg/kg(大鼠经口)；2880mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度蒸气对眼、鼻、喉和肺有刺激性，并抑制中枢神经系统而呈现麻醉作用，如长时间麻醉可因呼吸衰竭而致死。对眼有强烈刺激性，可导致永久性失明。液体对皮肤有轻度刺激性，可经皮肤吸收引起中毒。摄入有轻度毒性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。受热放出辛辣的烟气。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '789', '醇', '2053', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (416, '591-23-1', '33557', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '3-methylcyclohexanol；m-methylcyclohexanol', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '3-甲基环己醇；间甲基环己醇', '外观与性状：无色透明液体, 具有类似薄荷气味。\r\n熔点(℃)：-47\r\n相对密度(水=1)：0.91\r\n沸点(℃)：173-175.3\r\n相对密度(空气=1)：3.94\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于普通溶剂。\r\n主要用途：用作橡胶、油、树脂、蜡及喷漆等的溶剂, 也作为润滑剂的抗氧剂。\r\n主要成分：纯品\r\nCAS号：591-23-1\r\n相对分子质量：114.19\r\n化学类别：591-23-1\r\n燃烧性：易燃\r\n闪点：<61\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1750mg/kg(兔经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：人接触过高浓度本品，可引起头痛、眼及上呼吸道刺激。液体对皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。接触氧化剂会发生爆炸。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (417, '583-59-5', '33557', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2-methylcyclohexanol；O-methylcyclohexanol', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '2-甲基环己醇；邻甲基环己醇', '外观与性状：无色粘稠液体, 有芳香气味。\r\n熔点(℃)：-9.5\r\n相对密度(水=1)：0.93(20℃)\r\n沸点(℃)：173-175.3\r\n相对密度(空气=1)：3.94\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于醇、醚。\r\n主要用途：用作橡胶、油、树脂、蜡及喷漆等的溶剂, 也作为润滑剂的抗氧剂。\r\n主要成分：纯品\r\nCAS号：583-59-5\r\n相对分子质量：114.19\r\n化学类别：583-59-5\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：人接触过高浓度，可引起头痛、眼及上呼吸道刺激；有麻醉作用。对皮肤有刺激性。摄入后引起中枢神经系统抑制。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。接触氧化剂会发生爆炸。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸酐、酰基氯。', '789', '醇', '2617', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (418, '589-91-3', '33557', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '4-methylcyclohexanol', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '4-甲基环己醇', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.91\r\n沸点(℃)：173-175.3\r\n相对密度(空气=1)：3.94\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于普通溶剂。\r\n主要用途：用作橡胶、油、树脂、蜡和喷漆等的溶剂, 也作为润滑剂的抗氧剂。\r\n主要成分：纯品\r\nCAS号：589-91-3\r\n相对分子质量：114.19\r\n化学类别：589-91-3\r\n燃烧性：易燃\r\n闪点：<61\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1660mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：人接触较高浓度本品，可引起头痛、眼及上呼吸道刺激。液体对皮肤有刺激性。可经皮肤吸收引起中毒。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。接触氧化剂会发生爆炸。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酰基氯、酸酐。', '789', '醇', '2297', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (419, '564-02-3', '32009', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2,2,3-trimethylpentane', 'C8H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。然后运至空旷的地方掩埋、蒸发、或焚烧。\0', '2,2,3-三甲基戊烷', '外观与性状：无色液体。\r\n熔点(℃)：-112.27\r\n相对密度(水=1)：0.72\r\n沸点(℃)：109.84\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：4(23.69℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于乙醇、溶于乙醚。\r\n主要用途：作溶剂用。\r\n主要成分：纯品\r\nCAS号：564-02-3\r\n相对分子质量：114.2\r\n化学类别：564-02-3\r\n燃烧性：易燃\r\n闪点：-3\r\n引燃温度：\r\n爆炸下限：1.0\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有刺激性。吸入属低毒。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (420, '6117-91-5', '33558', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还\0', '2-buten-1-ol；crotonyl alcohol', 'C4H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', '2-丁烯醇；巴豆醇', '外观与性状：无色液体，有特殊气味。\r\n熔点(℃)：<-30\r\n相对密度(水=1)：0.85\r\n沸点(℃)：114.5\r\n相对密度(空气=1)：2.49\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚。\r\n主要用途：用作化学中间体，制造杀虫剂、增塑剂、医药、涂料等。\r\n主要成分：纯品\r\nCAS号：6117-91-5\r\n相对分子质量：72.10\r\n化学类别：6117-91-5\r\n燃烧性：易燃\r\n闪点：27\r\n引燃温度：349\r\n爆炸下限：4.2\r\n爆炸上限：35.3\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：930mg/kg(大鼠经口)；1270mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。高浓度丁烯醇对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强酸、强氧化剂、强还原剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (421, '107-19-7', '33559', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸\0', 'propargyl alcohol；2-propyny-1-ol', 'C3H4O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。大量\0', '炔丙醇；2-丙炔-1-醇', '外观与性状：无色液体，有香叶气味。\r\n熔点(℃)：-50\r\n相对密度(水=1)：0.97\r\n沸点(℃)：115\r\n相对密度(空气=1)：1.93\r\n饱和蒸气压(kPa)：1.55/20℃\r\n燃烧热(kJ/mol)：1729.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、醇、醚。\r\n主要用途：用作除锈剂、化学中间体、腐蚀抑制剂、溶剂、稳定剂等。\r\n主要成分：纯品\r\nCAS号：107-19-7\r\n相对分子质量：56.07\r\n化学类别：107-19-7\r\n燃烧性：易燃\r\n闪点：36(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：20mg/kg(大鼠经口)；16mg/kg(兔经皮)\r\nLC50：2000mg/m3，2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度丙炔醇对眼睛、皮肤、粘膜和呼吸道有强烈的刺激作用。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。严重者可能致死。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。受热放出辛辣的烟气。与氧化剂、五氧化二磷发生反应。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内?\n', '强氧化剂、强酸、强碱、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (422, '115-19-5', '33560', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2-methyl-3-butyn-2-ol；2,2-dimethylethynyl carbino', 'C5H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '2-甲基-3-丁炔-2-醇；2,2-二甲基乙炔甲醇', '外观与性状：无色、有芳香气味的液体。\r\n熔点(℃)：3\r\n相对密度(水=1)：0.86(20℃)\r\n沸点(℃)：104\r\n相对密度(空气=1)：2.49\r\n饱和蒸气压(kPa)：1.6(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于丙酮、苯、四氯化碳、石油醚。\r\n主要用途：用作溶剂、中间体、含氯溶剂的稳定剂。\r\n主要成分：纯品\r\nCAS号：115-19-5\r\n相对分子质量：84.13\r\n化学类别：115-19-5\r\n燃烧性：易燃\r\n闪点：25\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1950mg/kg(大鼠经口)；1800mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强还原剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (423, '77-75-8', '33560', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '3-methyl-1-pentyn-3-ol；ethylethynyl methyl carbin', 'C6H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系统。大\0', '3-甲基-1-戊炔-3-醇；2-乙炔-2-丁醇', '外观与性状：无色液体, 有酸的气味和焦灼味。\r\n熔点(℃)：-30.6\r\n相对密度(水=1)：0.87\r\n沸点(℃)：122\r\n相对密度(空气=1)：3.38\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于乙醇。\r\n主要用途：用作氯化溶剂的稳定剂、电镀光亮剂、有机合成中间体、溶剂。\r\n主要成分：纯品\r\nCAS号：77-75-8\r\n相对分子质量：98.1\r\n化学类别：77-75-8\r\n燃烧性：易燃\r\n闪点：26\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：300mg/kg(大鼠经口)；700mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。对皮肤、眼睛具有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强酸、强氧化剂、强还原剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (424, '513-86-0', '33561', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩；可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止烟雾或粉尘泄漏到工作场所空气中。避免与氧\0', '3-hydroxy-2-butanone；acetyl methyl carbinol', 'C4H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。若是液体，防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后\0', '3-羟基-2-丁酮；乙酰基乙醇', '外观与性状：微黄色液体或结晶性固体, 易挥发。\r\n熔点(℃)：15\r\n相对密度(水=1)：1.02\r\n沸点(℃)：147-148\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、微溶于醚、石油醚。\r\n主要用途：用于制作香精和香料。\r\n主要成分：纯品\r\nCAS号：513-86-0\r\n相对分子质量：88.10\r\n化学类别：513-86-0\r\n燃烧性：易燃\r\n闪点：41.1\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤有刺激作用，其蒸气或雾对眼睛、粘膜及上呼吸道有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '775', '酮', '2621', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (425, NULL, '33562', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。注意个人清洁卫生。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '3-acetyl-1-propanol；5-hydroxy-2-pentanone', 'C5H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放\0', '3-乙酰-1-丙醇；5-羟基-2-戊基酮', '外观与性状：无色透明液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.01\r\n沸点(℃)：208(97.31kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：97.31(208℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、溶于乙醇、乙醚。\r\n主要用途：用作试剂、医药中间体。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：102.13\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：36.0\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对中枢神经系统有影响，可引起肝、肾障碍。长期接触可引起慢性中毒。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (426, '1569-02-4', '33569', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'propylene glycol monoethyl ether；1-ethoxy-2-propa', 'C5H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '丙二醇乙醚；1-乙氧基-2-丙醇', '外观与性状：无色液体。\r\n熔点(℃)：-90\r\n相对密度(水=1)：0.90(25℃)\r\n沸点(℃)：132.2\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.96(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶。\r\n主要用途：用作溶剂。\r\n主要成分：纯品\r\nCAS号：1569-02-4\r\n相对分子质量：104.15\r\n化学类别：1569-02-4\r\n燃烧性：易燃\r\n闪点：43(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：7000～7110mg/kg(大鼠经口)[50%水溶液]；8100mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：动物中毒表现以中枢神经系统抑制为主，可致眼、呼吸道刺激和肾损害。用本品溶液滴兔眼，可引起结膜刺激和暂时性角膜混浊。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (427, '629-14-1', '33569', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethylene glycol diethyl ether；1,2-diethoxyethane', 'C6H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '乙二醇二乙醚；1,2-二乙氧基乙烷', '外观与性状：无色液体，稍有醚的气味。\r\n熔点(℃)：-74.0\r\n相对密度(水=1)：0.84\r\n沸点(℃)：121.4\r\n相对密度(空气=1)：6.56\r\n饱和蒸气压(kPa)：1.25/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作溶剂，及去垢剂的溶剂，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：629-14-1\r\n相对分子质量：118.17\r\n化学类别：629-14-1\r\n燃烧性：易燃\r\n闪点：35\r\n引燃温度：205\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4390mg/kg(大鼠经口)；2440mg/kg(豚鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。对眼睛、皮肤有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '770', '醚', '1153', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (428, '109-59-1', '33569', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'ethylene glycol isopropyl ether；2-isopropoxyethan', 'C5H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '乙二醇异丙醚；2-异丙氧基乙醇', '外观与性状：无色液体，略有不愉快气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.91\r\n沸点(℃)：139~143\r\n相对密度(空气=1)：3.6\r\n饱和蒸气压(kPa)：0.80/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于多数有机溶剂。\r\n主要用途：用作溶剂。\r\n主要成分：纯品\r\nCAS号：109-59-1\r\n相对分子质量：104.09\r\n化学类别：109-59-1\r\n燃烧性：易燃\r\n闪点：33(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：500～1000mg/kg(大鼠经口)；4900mg/kg(小鼠经口)\r\nLC50：3100mg/m3，4小时(大鼠吸入)；1930mg/m3，7小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对大鼠可引起肝、肾损害。未见职业性危害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (429, '4435-53-4', '33571', '监测方法：羟胺－氯化铁分光光度法\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '3-methoxybutyl acetate；butoxyl', 'C7H14O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '乙酸-3-甲氧基丁酯；3-甲氧基丁基乙酸酯', '外观与性状：无色液体, 味苦, 略有气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.95-0.96(20℃)\r\n沸点(℃)：173\r\n相对密度(空气=1)：5.05\r\n饱和蒸气压(kPa)：0.40(30℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于多数有机溶剂。\r\n主要用途：用作树脂及涂料的溶剂。\r\n主要成分：纯品\r\nCAS号：4435-53-4\r\n相对分子质量：146.19\r\n化学类别：4435-53-4\r\n燃烧性：易燃\r\n闪点：60\r\n引燃温度：\r\n爆炸下限：2.3\r\n爆炸上限：15\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4210mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、粘膜有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '749', '羧酸酯', '2708', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (430, '540-84-1', '32009', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2,2,4-trimethylpentane；isooctane', 'C8H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。然后运至空旷的地方掩埋、蒸发、或焚烧。\0', '2,2,4-三甲基戊烷；异辛烷', '外观与性状：无色、透明液体。\r\n熔点(℃)：-107.4\r\n相对密度(水=1)：0.69\r\n沸点(℃)：99.2\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醚、易溶于醇、丙酮、苯、氯仿、等\r\n主要用途：用于有机合成, 用作溶剂及气相色谱的对比样品。\r\n主要成分：纯品\r\nCAS号：540-84-1\r\n相对分子质量：114.2\r\n化学类别：540-84-1\r\n燃烧性：易燃\r\n闪点：-7\r\n引燃温度：\r\n爆炸下限：1.0\r\n爆炸上限：6.0\r\n最小点火能：1.35\r\n最大爆炸压力：0.790\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入或口服对身体有害。对皮肤有刺激性。本品蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。遇强氧化剂会引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', '1262', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (431, '106-92-3', '33572', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、碱\0', 'allyl glycidyl ether；1-allyloxy-2,3-epoxy propane', 'C6H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '烯丙基缩水甘油醚', '外观与性状：无色、透明液体, 有特殊的臭味。\r\n熔点(℃)：-100\r\n相对密度(水=1)：0.96\r\n沸点(℃)：154\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：0.37(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于丙酮、苯、四氯化碳、醇。\r\n主要用途：用作纤维改性剂、氯化有机物的稳定剂、合成树脂反应性稀释剂和改性剂。\r\n主要成分：纯品\r\nCAS号：106-92-3\r\n相对分子质量：114.2\r\n化学类别：106-92-3\r\n燃烧性：易燃\r\n闪点：57\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：920mg/kg(大鼠经口)；2550mg/kg(兔经皮)\r\nLC50：860ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对中枢神经有抑制作用。可致肺水肿。对眼有重度刺激，可致结膜炎、虹膜炎和角膜混浊。对皮肤有中度刺激，致敏作用较强。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '酸类、碱类、氧化剂。', '770', '醚', '2219', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (432, '32749-94-3', '33574', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2,3-dimethylpentaldehyde；2,3-dimethylvaleraldehyd', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '2,3-二甲基戊醛', '外观与性状：无色液体。\r\n熔点(℃)：-110\r\n相对密度(水=1)：0.83\r\n沸点(℃)：140.5\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：32749-94-3\r\n相对分子质量：114.19\r\n化学类别：32749-94-3\r\n燃烧性：易燃\r\n闪点：58\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3540mg/kg(大鼠经口)；7100mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、还原剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。其蒸气或雾对眼睛、皮肤、粘膜和呼吸道有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱、强还原剂。', '773', '醛', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (433, '123-05-7', '33575', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-ethyl hexanal；2-ethylhexaldehyde', 'C8H16O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '2-乙基己醛', '外观与性状：无色或黄色液体, 带有特殊清淡气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.82\r\n沸点(℃)：163.4\r\n相对密度(空气=1)：4.41\r\n饱和蒸气压(kPa)：0.13(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于多数有机溶剂。\r\n主要用途：供有机合成、香料用。\r\n主要成分：纯品\r\nCAS号：123-05-7\r\n相对分子质量：128.22\r\n化学类别：123-05-7\r\n燃烧性：易燃\r\n闪点：44\r\n引燃温度：375\r\n爆炸下限：0.8\r\n爆炸上限：72\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3730mg/kg(大鼠经口)；5040mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有毒。对眼睛、皮肤、粘膜和上呼吸道有刺激作用。接触后能引起头痛、咳嗽、咽喉痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱。', '773', '醛', '1191', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (434, '765-34-4', '33578', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。防止皮肤和粘膜的损害。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2,3-epoxypropionaldehyde；glycidaldehyde', 'C3H4O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '2,3-环氧丙醛；缩水甘油醛', '外观与性状：无色不稳定液体, 有刺鼻气味。\r\n熔点(℃)：-61.8\r\n相对密度(水=1)：1.14(20℃)\r\n沸点(℃)：112-113\r\n相对密度(空气=1)：2.58\r\n饱和蒸气压(kPa)：10.13(57-58℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于石油醚、易溶于多数有机溶剂。\r\n主要用途：用作在棉织品处理、皮革、鞣革和蛋白凝固中双官能的化学中间体和交联剂。\r\n主要成分：纯品\r\nCAS号：765-34-4\r\n相对分子质量：72.06\r\n化学类别：765-34-4\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：230mg/kg(大鼠经口)；200mg/kg(兔经皮)\r\nLC50：740mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气对眼及呼吸道有刺激性。对皮肤有明显刺激作用。少数病例有过敏反应。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '758', '环氧化合物', '2622', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (435, '97-97-2', '33579', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。定期体检。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'dimethyl chloroacetal；chloroacetaldehyde dimethyl', 'C4H9ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。撒湿冰或冰水冷却\0', '二甲基氯乙缩醛', '外观与性状：无色液体, 有刺激性臭味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.08-1.09(25℃)\r\n沸点(℃)：126-132\r\n相对密度(空气=1)：4.3\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚、苯。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：97-97-2\r\n相对分子质量：124.57\r\n化学类别：97-97-2\r\n燃烧性：易燃\r\n闪点：28\r\n引燃温度：232.2\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。对眼、粘膜和上呼吸道有刺激性，对皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '773', '醛', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (436, '108-60-1', '61087', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', 'dichloroisopropyl ether', 'C6H12Cl2O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '二氯异丙基醚；二氯异丙醚', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.11\r\n沸点(℃)：187.8\r\n相对密度(空气=1)：6.0\r\n饱和蒸气压(kPa)：0.01/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于多数有机溶剂。\r\n主要用途：用作脂、蜡、润滑脂的溶剂和去漆剂、去垢剂、萃取剂。\r\n主要成分：纯品\r\nCAS号：108-60-1\r\n相对分子质量：171.09\r\n化学类别：108-60-1\r\n燃烧性：可燃\r\n闪点：85\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：240mg/kg(大鼠经口)；296mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼和粘膜有刺激作用。可使大鼠发生肝、肾损害。未见人中毒报告。\r\n危险特性：遇明火、高热可燃。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '770', '醚', '2490', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (437, '75-86-5', '61088', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', '2-hydroxyisobutyronitrile；acetone cyanohydrin', 'C4H7NO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系\0', '2-羟基异丁腈；氰丙醇', '外观与性状：无色或亮黄色液体。\r\n熔点(℃)：-20\r\n相对密度(水=1)：0.93\r\n沸点(℃)：120(分解)\r\n相对密度(空气=1)：2.93\r\n饱和蒸气压(kPa)：3.07(82℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、易溶于乙醇、乙醚、溶于丙酮、苯、微溶于石油醚、二硫化碳。\r\n主要用途：是有机玻璃单体－甲基丙烯酸甲酯的中间体，还用于有机合成、农药制造等。\r\n主要成分：纯品\r\nCAS号：75-86-5\r\n相对分子质量：85.11\r\n化学类别：75-86-5\r\n燃烧性：易燃\r\n闪点：63\r\n引燃温度：687.8\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：15mg/kg(小鼠经口)；140mg/kg(豚鼠经皮)；17mg/kg(大鼠经口)\r\nLC50：575ppm，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品的蒸气或液体对皮肤、粘膜均有刺激作用，毒作用与氢氰酸相同。一般接触４－５分钟后出现症状，早期中毒症状有无力、头昏、头痛、胸闷、心悸、恶心、呕吐和食欲减退，严重者可致死。可引起皮炎。\r\n危险特性：遇明火、高热易燃。与氧化剂可发生反应。受热分解成氢氰酸及丙酮。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强酸、强碱、强氧化剂、强还原剂。', '743', '腈', '1541', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (438, '594-42-3', '61089', '监测方法：\r\n工程控制：密闭操作，注意通风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、接触。搬运时\0', 'trichloromethylsulphenyl chloride；perchloromethyl', 'CCl4S', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收\0', '三氯甲基硫酰氯；过氯甲硫醇', '外观与性状：黄色油状液体, 有不愉快的气味。\r\n熔点(℃)：\r\n相对密度(水=1)：1.70(20℃)\r\n沸点(℃)：148-149(分解)\r\n相对密度(空气=1)：6.41\r\n饱和蒸气压(kPa)：0.31(20℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于有机合成, 用作染料中间体、熏蒸药。\r\n主要成分：纯品\r\nCAS号：594-42-3\r\n相对分子质量：185.89\r\n化学类别：594-42-3\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：氯化氢、硫化物。\r\n急性毒性：LD50：82mg/kg(大鼠经口)\r\nLC50：296mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。本品严重损害粘膜、上呼吸道、眼睛和皮肤。吸入后可因喉和支气管的痉挛、炎症和水肿，化学性肺炎或肺水肿而致死。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：受高热分解产生有毒的氯化物气体。\r\n', '强氧化剂、强碱、水、潮湿空气。', '739', '有机酰卤', '1670', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (439, '1600-27-7', '61093', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。\0', 'mercuric acetate', 'C4H6O4Hg', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，用塑料布、帆布覆盖。收集回收或运至废物处理场所处置。', '乙酸汞；醋酸汞', '外观与性状：白色结晶或粉末，有乙酸气味。\r\n熔点(℃)：179~182\r\n相对密度(水=1)：3.27\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇。\r\n主要用途：用作有机合成催化剂、分析试剂，也用于医药工业。\r\n主要成分：纯品\r\nCAS号：1600-27-7\r\n相对分子质量：318.59\r\n化学类别：1600-27-7\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化汞。\r\n急性毒性：LD50：76mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：有刺激作用。如吸入、摄入或经皮吸收后对身体有害，严重者可致死。侵犯神经系统，引起进行性神经麻痹、共济失调、精神障碍等。\r\n危险特性：受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '750', '金属氧化物', '1629', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (440, '115-09-3', '61093', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。实行就业前和定期的体检。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时\0', 'chloromethyl mercury；monomethyl mercurychloride', 'CH3ClHg', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '氯化甲基汞；甲基氯化汞', '外观与性状：红色结晶, 具有特殊臭味。\r\n熔点(℃)：170\r\n相对密度(水=1)：4.06\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于种子消毒。\r\n主要成分：纯品\r\nCAS号：115-09-3\r\n相对分子质量：251.07\r\n化学类别：115-09-3\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化汞。\r\n急性毒性：LD50：16mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品属有机汞。有机汞系亲脂性毒物，主要侵犯神经系统。有机汞中毒的主要表现有：无论任何途径侵入，均可发生口腔炎，口服引起急性胃肠炎；神经精神症状有神经衰弱综合征、精神障碍、昏迷、瘫痪、震颤、共济失调、向心性视野缩小等；可发生肾脏损害；可致皮肤损害。\r\n危险特性：遇明火、高热可燃。受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂、强酸。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (441, NULL, '61096', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴防尘面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。实行就业前和定期的体检。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴防尘面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、碱类、接触。搬运时要轻装轻卸，防\0', 'triethyl tin sulfate', 'C6H16O4SSn', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '硫酸三乙基锡', '外观与性状：白色固体, 有刺激性臭味。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作农药，防治麦赤霉病、水稻稻瘟病。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：302.94\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化物、氧化锡。\r\n急性毒性：LD50：10mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品属有机锡。工业性有机锡中毒的主要临床表现有：眼和鼻粘膜的刺激症状；中毒性神经衰弱综合征；重症出现中毒性脑病。溅入眼内引起结膜炎。可致变应性皮炎。摄入有机锡化合物可致中毒性脑水肿，可产生后遗症，如瘫痪、精神失常和智力障碍。慢性影响：神经衰弱综合征。\r\n危险特性：遇明火、高热可燃。加热分解产生毒性气体。\r\n', '强氧化剂、强碱。', '794', '金属烃基化合物', '2788', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (442, '75-74-1', '61097', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备\0', 'lead tetramethyl；tetramethyl lead', 'C4H12Pb', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '四甲铅；四甲基铅', '外观与性状：无色油状液体, 有特臭。\r\n熔点(℃)：-27.5\r\n相对密度(水=1)：1.99\r\n沸点(℃)：110\r\n相对密度(空气=1)：6.5\r\n饱和蒸气压(kPa)：3.33(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于多数有机溶剂，脂肪。\r\n主要用途：作为内燃机燃料汽油的添加剂以防震。\r\n主要成分：纯品\r\nCAS号：75-74-1\r\n相对分子质量：267.33\r\n化学类别：75-74-1\r\n燃烧性：易燃\r\n闪点：38\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化铅。\r\n急性毒性：LD50：108mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，对环境有严重危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品为神经毒。吸入、经口和经皮肤吸收均可引起中毒。四甲铅引起人中毒迄今尚未见报道。动物实验四甲铅中毒与四乙铅相似，实验动物出现兴奋、痉挛、共济失调、震颤、昏迷等。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '794', '金属烃基化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (443, '1885-14-9', '61101', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。现场备有冲洗眼及皮肤的设备。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', 'phenyl chloroformate；chloroformic acid phenyl est', 'C7H5ClO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '氯甲酸苯酯', '外观与性状：无色油状液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.25\r\n沸点(℃)：95/2.67kPa\r\n相对密度(空气=1)：1.0\r\n饱和蒸气压(kPa)：1.73/74℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、易溶于石油醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：1885-14-9\r\n相对分子质量：156.57\r\n化学类别：1885-14-9\r\n燃烧性：可燃\r\n闪点：75\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：490mg/kg(大鼠经口)；3970mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与碱类、醇类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道及皮肤有强烈的刺激作用。吸入、摄入或经皮肤吸收能致死。吸入后可能因喉、支气管的痉挛、水肿而致死。其症状有烧灼感、恶心、呕吐、咳嗽、喘息、喉炎、气短。\r\n危险特性：可燃。遇明火能燃烧。遇水或受热会反应放出具有刺激性和腐蚀性的白色氯化氢烟雾。\r\n', '碱类、醇类、胺类、水。', '749', '羧酸酯', '2746', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (444, '108-47-4', '33615', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。实行就业前和定期的体检。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', '2,4-dimethylpyridine；2,4-lutidine', 'C7H9N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。收集运至空旷的地方掩埋、\0', '2,4-二甲基吡啶；2,4-卢剔啶', '外观与性状：无色液体, 有胡椒气味。\r\n熔点(℃)：-60.0\r\n相对密度(水=1)：0.93\r\n沸点(℃)：157～158\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：4740(76.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于多数有机溶剂。\r\n主要用途：用于有机合成, 合成药物和用作溶剂。\r\n主要成分：纯品\r\nCAS号：108-47-4\r\n相对分子质量：107.2\r\n化学类别：108-47-4\r\n燃烧性：易燃\r\n闪点：37\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：400～800mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。对眼睛有强烈刺激性。对皮肤、粘膜和上呼吸道有刺激性。接触后可引起咳嗽、胸痛、呼吸困难、胃肠功能紊乱。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、酸类、酰基氯、酸酐。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (445, '75-97-8', '33582', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。高浓度环境中，建议佩戴空气呼吸器\r\n眼睛防护：可能接触其蒸气时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'tert-butyl methyl ketone；3,3-dimethyl-2-butanone', 'C6H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。然后运至空旷的地方\0', '甲基叔丁基(甲)酮；3,3-二甲基-2-丁酮', '外观与性状：无色液体。\r\n熔点(℃)：-49.8\r\n相对密度(水=1)：0.80(25℃)\r\n沸点(℃)：106\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、醚、丙酮。\r\n主要用途：用作溶剂。\r\n主要成分：纯品\r\nCAS号：75-97-8\r\n相对分子质量：100.2\r\n化学类别：75-97-8\r\n燃烧性：易燃\r\n闪点：23\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。具有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂。', '775', '酮', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (446, '1634-04-4', '32084', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'methyl-tert-butyl ether；tert-butyl methyl ether', 'C5H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '甲基叔丁基醚', '外观与性状：无色液体, 具有醚样气味。\r\n熔点(℃)：-109(凝)\r\n相对密度(水=1)：0.76\r\n沸点(℃)：53～56\r\n相对密度(空气=1)：3.1\r\n饱和蒸气压(kPa)：31.9(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作汽油添加剂。\r\n主要成分：纯品\r\nCAS号：1634-04-4\r\n相对分子质量：88.2\r\n化学类别：1634-04-4\r\n燃烧性：易燃\r\n闪点：-10\r\n引燃温度：\r\n爆炸下限：1.6\r\n爆炸上限：15.1\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3030mg/kg(大鼠经口)；>7500mg/kg(兔经皮)\r\nLC50：85000mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用，可引起化学性肺炎。对皮肤有刺激性。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与氧化剂接触猛烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '770', '醚', '2398', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (447, '108-10-1', '32075', '监测方法：溶剂解吸－气相色谱法；热解吸－气相色谱法\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：可能接触其蒸气时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl isobutyl ketone；4-methyl-2-pentanone', 'C6H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用\0', '甲基异丁基甲酮；4-甲基-2-戊酮', '外观与性状：水样透明液体, 有令人愉快的酮样香味。\r\n熔点(℃)：-83.5\r\n相对密度(水=1)：0.80(25℃)\r\n沸点(℃)：115.8\r\n相对密度(空气=1)：3.45\r\n饱和蒸气压(kPa)：2.13(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：298.2\r\n临界压力(MPa)：3.27\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于多数有机溶剂。\r\n主要用途：用作喷漆、硝基纤维、某些纤维醚、樟脑、油脂、天然和合成橡胶的溶剂。\r\n主要成分：纯品\r\nCAS号：108-10-1\r\n相对分子质量：100.16\r\n化学类别：108-10-1\r\n燃烧性：易燃\r\n闪点：15.6\r\n引燃温度：459\r\n爆炸下限：1.35\r\n爆炸上限：7.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2080mg/kg(大鼠经口)\r\nLC50：32720mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有麻醉和刺激作用。人吸入 4.1g/m3时引起中枢神经系统的抑制和麻醉；吸入 0.41-2.05g/m3时，可引起胃肠道反应，如恶心、呕吐、食欲不振、腹泻，以及呼吸道刺激症状；低于 84mg/m3 时没有不适感。\r\n危险特性：易燃，遇高热、明火、氧化剂有引起燃烧的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', '1245', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (448, '624-83-9', '32164', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（全面罩）或自给式呼吸器。。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'methyl isocyanate', 'C2H3NO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即进行隔离，小泄漏时隔离300m，大泄漏时隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性\0', '甲基异氰酸酯', '外观与性状：带有强烈气味的无色液体，有催泪性。\r\n熔点(℃)：-45\r\n相对密度(水=1)：0.97\r\n沸点(℃)：37～39\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：46.39(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：作为有机合成原料，用作农药西维因的中间体。\r\n主要成分：纯品\r\nCAS号：624-83-9\r\n相对分子质量：57.05\r\n化学类别：624-83-9\r\n燃烧性：易燃\r\n闪点：-6\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：305mg/kg(大鼠经口)；213mg/kg(兔经皮)\r\nLC50：11.7mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、醇类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入低浓度本品蒸气或雾对呼吸道有刺激性；高浓度吸入可因支气管和喉的炎症、痉挛，严重的肺水肿而致死。蒸气对眼有强烈的刺激性，引起流泪、角膜上皮水肿、角膜云翳。液态对皮肤有强烈的刺激性。口服刺激胃肠道。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。化学反应性强，易聚合，易吸湿。遇水、酸类或与有机物、氧化剂接触，都可放出大量热而引起剧烈燃烧，并放出有毒和易燃的二氧化硫。遇水或水蒸气反应放出有毒和易燃的气体。在火场中，受热的容器有爆炸危?\n', '水、醇类、强碱、酸类、强氧化剂。', '749', '羧酸酯', '2480', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (449, '628-28-4', '32083', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：高浓度接触时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'methyl-n-butylether；n-butyl methyl ether', 'C5H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。然后运至空旷的地方掩埋、蒸发、或焚烧。\0', '甲基正丁基醚；1-甲氧基丁烷', '外观与性状：无色液体。\r\n熔点(℃)：-115.5\r\n相对密度(水=1)：0.74\r\n沸点(℃)：70～71\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用作溶剂、麻醉剂, 并用于有机合成。\r\n主要成分：纯品\r\nCAS号：628-28-4\r\n相对分子质量：88.2\r\n化学类别：628-28-4\r\n燃烧性：易燃\r\n闪点：-10\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品具有麻醉和刺激作用。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与氧化剂能发生强烈反应。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '770', '醚', '2350', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (450, '60-34-4', '32183', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴空气呼吸器、氧气呼吸器或长管面具。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。在氮气中操\0', 'methylhydrazine', 'CH6N2', NULL, '迅速撤离泄漏污染区人员至安全区，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃\0', '甲基肼；甲肼', '外观与性状：无色液体，有氨的气味。\r\n熔点(℃)：-20.9\r\n相对密度(水=1)：0.87\r\n沸点(℃)：87.8\r\r\n相对密度(空气=1)：1.6\r\n饱和蒸气压(kPa)：6.61(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚。\r\n主要用途：用作有机合成中间体、溶剂。\r\n主要成分：纯品\r\nCAS号：60-34-4\r\n相对分子质量：46.07\r\n化学类别：60-34-4\r\n燃烧性：易燃\r\n闪点：-8\r\n引燃温度：194\r\n爆炸下限：2.5\r\n爆炸上限：98.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：71mg/kg(大鼠经口)；95mg/kg(兔经皮)\r\nLC50：64mg/m3，4小时(大鼠吸入)\r\n致癌性：小鼠经口最低中毒剂量(TDL0)：7175mg/kg(36周，连续)，致肿瘤阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、过氧化物、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，高毒，具腐蚀性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：意外吸入甲基肼蒸气可出现流泪、喷嚏、咳嗽，以后可见眼充血、支气管痉挛、呼吸困难，继之恶心、呕吐。皮肤接触引起灼伤。慢性吸入甲基肼可致轻度高铁血红蛋白形成，可引起溶血。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。在空气中遇尘土、石棉、木材等疏松性物质能自燃。遇过氧化氢或硝酸等氧化剂，也能自燃。高热时其蒸气能发生爆炸。具有腐蚀性。\r\n', '强氧化剂、氧、过氧化物。', '762', '脂肪胺', '1244', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (451, '107-31-3', '31037', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'methyl formate', 'C2H4O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '甲酸甲酯；蚁酸甲酯', '外观与性状：无色液体，有芳香气味。\r\n熔点(℃)：-99.8\r\n相对密度(水=1)：0.98\r\n沸点(℃)：32.0\r\n相对密度(空气=1)：2.07\r\n饱和蒸气压(kPa)：53.32(16℃)\r\n燃烧热(kJ/mol)：978.7\r\n临界温度(℃)：214\r\n临界压力(MPa)：6.00\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、甲醇。\r\n主要用途：用于有机合成，乙酸纤维的溶剂，分析试剂等。\r\n主要成分：纯品\r\nCAS号：107-31-3\r\n相对分子质量：60.05\r\n化学类别：107-31-3\r\n燃烧性：易燃\r\n闪点：-32\r\n引燃温度：449\r\n爆炸下限：4.5\r\n爆炸上限：32.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1622mg/kg(兔经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过28℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有麻醉和刺激作用。人接触一定浓度的本品，发生明显的刺激作用；反复接触可致痉挛甚至死亡。\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱类。', '749', '羧酸酯', '1243', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (452, '109-94-4', '31038', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'ethyl formate', 'C3H6O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '甲酸乙酯；蚁酸乙酯', '外观与性状：无色易流动液体，有芳香气味。\r\n熔点(℃)：-79\r\n相对密度(水=1)：0.92\r\n沸点(℃)：54.3\r\n相对密度(空气=1)：2.55\r\n饱和蒸气压(kPa)：13.33(5.4℃)\r\n燃烧热(kJ/mol)：1637.3\r\n临界温度(℃)：235.3\r\n临界压力(MPa)：4.74\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于苯、乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作醋酸或硝酸纤维的溶剂，以及用于香精合成和医药生产。\r\n主要成分：纯品\r\nCAS号：109-94-4\r\n相对分子质量：74.08\r\n化学类别：109-94-4\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：440\r\n爆炸下限：2.7\r\n爆炸上限：16.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1850mg/kg(大鼠经口)；20000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：小鼠经皮最低中毒剂量(TDL0)：10mg/kg，10周(间断)，致肿瘤阳性。\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：具有麻醉和刺激作用。吸入后，引起上呼吸道刺激、头痛、头晕、恶心、呕吐、倦睡、神志丧失。对眼和皮肤有刺激性。口服刺激口腔和胃，引起中枢神经系统抑制。\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱。', '749', '羧酸酯', '1190', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (453, '110-74-7', '32122', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'n-propyl formate；propyl methanoate', 'C4H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系\0', '甲酸正丙酯；蚁酸正丙酯', '外观与性状：无色液体, 具有特殊香味。\r\n熔点(℃)：-92.9\r\n相对密度(水=1)：0.91\r\n沸点(℃)：81.3\r\n相对密度(空气=1)：3.04\r\n饱和蒸气压(kPa)：11.3(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于多数有机溶剂。\r\n主要用途：用作有机溶剂, 并用于制造香料、熏蒸杀虫剂和杀菌剂。\r\n主要成分：纯品\r\nCAS号：110-74-7\r\n相对分子质量：88.10\r\n化学类别：110-74-7\r\n燃烧性：易燃\r\n闪点：-3\r\n引燃温度：455\r\n爆炸下限：2.7\r\n爆炸上限：13.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3980mg/kg(大鼠经口)；3400mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮服吸收后对身体有害。对皮肤有刺激性。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、强酸、卤素。', '749', '羧酸酯', '1281', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (454, '592-84-7', '32123', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'butyl formate；butyl methanoate', 'C5H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系\0', '甲酸丁酯；蚁酸正丁酯', '外观与性状：无色液体，具有果子香味。\r\n熔点(℃)：-90.0\r\n相对密度(水=1)：0.91\r\n沸点(℃)：106.8\r\n相对密度(空气=1)：3.52\r\n饱和蒸气压(kPa)：5.33(31.6℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于苯、丙酮、石油醚。\r\n主要用途：用作溶剂，用于香料制造、有机合成、化学试剂等。\r\n主要成分：纯品\r\nCAS号：592-84-7\r\n相对分子质量：102.12\r\n化学类别：592-84-7\r\n燃烧性：易燃\r\n闪点：18\r\n引燃温度：320\r\n爆炸下限：1.6\r\n爆炸上限：8.3\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2656mg/kg(兔经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：具有麻醉和刺激作用。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂接触猛烈反应。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', '1128', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (455, '542-55-2', '32123', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。特别注意眼和呼吸道的防护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避\0', 'isobutyl formate；isobutyl methanoate', 'C5H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '甲酸异丁酯；蚁酸异丁酯', '外观与性状：无色液体, 有水果香味。\r\n熔点(℃)：-95.8\r\n相对密度(水=1)：0.89\r\n沸点(℃)：98.4\r\n相对密度(空气=1)：3.52\r\n饱和蒸气压(kPa)：4.35(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于醇、乙醚、苯、石油醚。\r\n主要用途：用作纤维素、树脂和漆的溶剂, 还用于制造香料、杀虫剂和用于有机合成。\r\n主要成分：纯品\r\nCAS号：542-55-2\r\n相对分子质量：102.13\r\n化学类别：542-55-2\r\n燃烧性：易燃\r\n闪点：10\r\n引燃温度：322\r\n爆炸下限：1.7\r\n爆炸上限：8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3100mg/kg(兔经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。可引起灼伤。本品对眼睛、皮肤、粘膜和上呼吸道有强烈的刺激作用，吸入后可引起喉、支气管的痉挛、炎症、水肿，化学性肺炎、肺水肿。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂接触猛烈反应。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、碱、酸类。', '749', '羧酸酯', '2393', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (456, '638-49-3', '33595', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'n-amyl formate；n-pentyl formate', 'C6H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '甲酸正戊酯', '外观与性状：无色液体。\r\n熔点(℃)：-73.5\r\n相对密度(水=1)：0.89\r\n沸点(℃)：130.4\r\n相对密度(空气=1)：4.0\r\n饱和蒸气压(kPa)：6.53(50℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：302.6\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作油脂、树脂及涂料的溶剂，杀虫剂及杀菌剂的中间体。\r\n主要成分：纯品\r\nCAS号：638-49-3\r\n相对分子质量：116.16\r\n化学类别：638-49-3\r\n燃烧性：易燃\r\n闪点：26.7\r\n引燃温度：379\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜和皮肤有刺激作用，具麻醉作用。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', '1109', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (457, '110-45-2', '33595', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴直接式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴直接式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'isoamyl formate；isopentyl formate', 'C6H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围\0', '甲酸异戊酯；蚁酸异戊酯', '外观与性状：无色液体, 有特殊香味。\r\n熔点(℃)：-93.5\r\n相对密度(水=1)：0.89\r\n沸点(℃)：124.2\r\n相对密度(空气=1)：4.0\r\n饱和蒸气压(kPa)：1.33(17℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于多数有机溶剂。\r\n主要用途：用作有机溶剂, 用于制造香料、熏蒸杀虫剂和杀菌剂。\r\n主要成分：纯品\r\nCAS号：110-45-2\r\n相对分子质量：116.16\r\n化学类别：110-45-2\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：1.7\r\n爆炸上限：10.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：9840mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤和上呼吸道粘膜有刺激作用。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸、强碱、卤素。', '749', '羧酸酯', '1109', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (458, '61599-24-4', NULL, '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', '4-fluorobutanol', 'C4H9FO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '4-氟丁醇', '外观与性状：高沸点液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：57.5(2.0kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.0(57.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：61599-24-4\r\n相对分子质量：92.11\r\n化学类别：61599-24-4\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢。\r\n急性毒性：LD50：0.9mg/kg(小鼠腑腔内)；0.9mg/kg(小鼠皮下)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：\r\n危险性综述：本品可燃，剧毒。\r\n侵入途径：吸入、食入。\r\n健康危害：在体内可生成氟丁酸，再降解为氟乙酸，影响中枢神经系统和心脏。严重者，可因心跳骤停、抽搐发作时窒息或中枢性呼吸衰竭而危及生命。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氟化物气体。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (459, '463-11-6', NULL, '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接\0', '1-fluoro octane', 'C8H17F', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '1-氟辛烷', '外观与性状：液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：142.5(99.8kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：463-11-6\r\n相对分子质量：132.21\r\n化学类别：463-11-6\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢、一氧化碳、二氧化碳。\r\n急性毒性：LD50：2.7mg/kg(小鼠腑腔内)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：\r\n危险性综述：本品可燃，剧毒，具刺激性，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (460, '115-77-5', NULL, '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消\0', 'pentaerythritol；pentaerythrite', 'C5H12O4', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '季戊四醇', '外观与性状：无嗅、白色或淡黄色晶体。\r\n熔点(℃)：262\r\n相对密度(水=1)：1.38(25℃)\r\n沸点(℃)：276(4.0kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：4.0(276℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于甘油、乙醇、不溶于油类、脂肪、多数有机溶剂。\r\n主要用途：用于制造季戊四醇四硝酸酯炸药、醇酸树脂, 也用作热稳定剂、增塑剂等。\r\n主要成分：纯品\r\nCAS号：115-77-5\r\n相对分子质量：136.15\r\n化学类别：115-77-5\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：450(粉)\r\n爆炸下限：30(g/m3)\r\n爆炸上限：\r\n最小点火能：10\r\n最大爆炸压力：0.62\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：25500mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：人服用本品后，血糖随剂量增加而轻度增高，服用停止，恢复正常。大剂量摄入可引起腹泻。未见有皮肤刺激作用；对眼基本无刺激性。\r\n危险特性：遇明火、高热可燃。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂、强酸、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (461, '77-99-6', NULL, '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消防器材及泄漏应\0', '1,1,1-trihydroxymethylpropane；trimethylolpropane', 'C6H14O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用砂土、干燥石灰或苏打灰混合。收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '1,1,1-三羟甲基丙烷', '外观与性状：固体。\r\n熔点(℃)：56-58\r\n相对密度(水=1)：\r\n沸点(℃)：150(0.03-0.05kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醇、不溶于苯、四氯化碳。\r\n主要用途：用于有机合成。用作缓冲剂。\r\n主要成分：纯品\r\nCAS号：77-99-6\r\n相对分子质量：134.17\r\n化学类别：77-99-6\r\n燃烧性：可燃\r\n闪点：172\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：未见中毒病例报道。\r\n危险特性：遇明火、高热可燃。粉体与空气可形成爆炸性混合物, 当达到一定浓度时, 遇火星会发生爆炸。\r\n', '强氧化剂、强酸。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (462, '111-46-6', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'diethylene glycol；diglycol', 'C4H10O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放\0', '二乙二醇；二甘醇', '外观与性状：无色、无臭、开始味甜回味苦的粘稠液体, 具有吸湿性。\r\n熔点(℃)：-8.0\r\n相对密度(水=1)：1.12(20℃)\r\n沸点(℃)：245.8\r\n相对密度(空气=1)：3.66\r\n饱和蒸气压(kPa)：0.13(91.8℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、不溶于苯、甲苯、四氯化碳。\r\n主要用途：用作人造丝的软化剂和烟草的湿润剂, 还是某些化工产品的中间体, 也用作汽车发动机防冻剂、刹车油等。\r\n主要成分：纯品\r\nCAS号：111-46-6\r\n相对分子质量：106.12\r\n化学类别：111-46-6\r\n燃烧性：可燃\r\n闪点：124\r\n引燃温度：228\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：16600mg/kg(大鼠经口)；26500mg/kg(小鼠经口)；11900mg/kg(兔经皮)\r\nLC50：\r\n致癌性：小鼠口服最低中毒剂量(TDL0)：890g/kg，53周(连续)，致癌， 致膀胱肿瘤，致肾损害。大鼠口服中毒剂量(TD)：584g/kg，2年(连续)，疑致肿瘤剂，致膀胱肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：未见本品引起职业中毒的报道。口服引起恶心、呕吐、腹痛、腹泻及肝、肾损害，可致死。尸检发现主要损害肾脏、肝脏。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (463, '504-63-2', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消防器材及泄漏应急处\0', '1,3-propanediol；1,3-dihydroxypropane', 'C3H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废\0', '1,3-丙二醇', '外观与性状：无色、无臭，具咸味、吸湿性的粘稠液体。\r\n熔点(℃)：-27\r\n相对密度(水=1)：1.05(25℃)\r\n沸点(℃)：210-211\r\n相对密度(空气=1)：2.6\r\n饱和蒸气压(kPa)：0.13(60℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、乙醚。\r\n主要用途：用作溶剂, 用于有机合成。\r\n主要成分：纯品\r\nCAS号：504-63-2\r\n相对分子质量：76.10\r\n化学类别：504-63-2\r\n燃烧性：可燃\r\n闪点：79\r\n引燃温度：400\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：16080mg/kg(大鼠经口)；6500mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼和皮肤无刺激作用。未见中毒报道。\r\n危险特性：遇明火、高热可燃。\r\n', '酰基氯、酸酐、氧化剂、还原剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (464, '57-55-6', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1,2-propanediol；methylglycol', 'C3H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '1,2-丙二醇', '外观与性状：无色、有苦味、略粘稠吸湿的液体。\r\n熔点(℃)：-59\r\n相对密度(水=1)：1.04(25℃)\r\n沸点(℃)：187.2\r\n相对密度(空气=1)：2.62\r\n饱和蒸气压(kPa)：0.02(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、乙醚、多数有机溶剂。\r\n主要用途：用于生产防冻剂、热交换剂树脂和二醇衍生物, 还用作溶剂、增塑剂和湿润剂等。\r\n主要成分：纯品\r\nCAS号：57-55-6\r\n相对分子质量：76.10\r\n化学类别：57-55-6\r\n燃烧性：可燃\r\n闪点：99\r\n引燃温度：371\r\n爆炸下限：2.6\r\n爆炸上限：12.6\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：21000～32200mg/kg(大鼠经口)；22000mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤有原发性刺激作用；对眼无刺激和损害，未见生产性中毒报道。\r\n危险特性：遇明火、高热可燃。\r\n', '酰基氯、酸酐、氧化剂、还原剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (465, '526-73-8', '33536', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1,2,3-trimethylbenzene', 'C9H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '1,2,3-三甲基苯；连三甲苯', '外观与性状：无色液体。\r\n熔点(℃)：-25.5\r\n相对密度(水=1)：0.89\r\n沸点(℃)：176.1\r\n相对密度(空气=1)：4.15\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：395\r\n临界压力(MPa)：3.14\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、苯、酮、四氯化碳、石油醚、等\r\n主要用途：主要用作分析试剂。\r\n主要成分：纯品\r\nCAS号：526-73-8\r\n相对分子质量：120.19\r\n化学类别：526-73-8\r\n燃烧性：易燃\r\n闪点：48\r\n引燃温度：470\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。接触后可引起头痛、头晕、恶心、麻醉作用。可引起皮炎。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂。', '740', '芳香烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (466, '110-98-5', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消防器材及泄漏应急处理设备。\0', 'dipropylene glycol；1,1-oxydi-2-propanol', 'C6H14O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水\0', '二丙二醇', '外观与性状：无色、无臭、略呈粘胶状的液体, 有吸湿性。\r\n熔点(℃)：-40\r\n相对密度(水=1)：1.03(20℃)\r\n沸点(℃)：232\r\n相对密度(空气=1)：4.63\r\n饱和蒸气压(kPa)：0.13(74℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于甲醇、乙醚。\r\n主要用途：用于聚酯树脂的制造。\r\n主要成分：纯品\r\nCAS号：110-98-5\r\n相对分子质量：134.17\r\n化学类别：110-98-5\r\n燃烧性：可燃\r\n闪点：118\r\n引燃温度：310\r\n爆炸下限：2.9\r\n爆炸上限：12.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：14800mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：皮肤刺激性小。对人无不良作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (467, '24800-44-0', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。搬运时轻装轻卸，防止包装破损。配备相应品种和数量的消防器材及泄漏应急处理设备。\0', 'tripropylene glycol', 'C9H20O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤\0', '三丙二醇', '外观与性状：无色、无臭、略呈粘稠的液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.02(25℃)\r\n沸点(℃)：268.0\r\n相对密度(空气=1)：6.63\r\n饱和蒸气压(kPa)：0.13(96℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：24800-44-0\r\n相对分子质量：192.25\r\n化学类别：24800-44-0\r\n燃烧性：可燃\r\n闪点：140\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼和皮肤无刺激性。未见中毒病例报道。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (468, '144-19-4', NULL, '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，必须佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运时\0', '2,2,4-trimethyl-1,3-pentylene glycol', 'C8H18O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。用洁净的铲子收集于干燥、洁净、有盖的容器中。转移至安全场所。若大量泄漏，收集回收或运至废物处理场所处置。', '2,2,4-三甲基-1,3-戊二醇', '外观与性状：白色结晶固体。\r\n熔点(℃)：49-51\r\n相对密度(水=1)：0.94(15℃)\r\n沸点(℃)：109-111(0.53kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、丙酮、苯、醚。\r\n主要用途：用于聚酯制造。用作增塑剂、润滑剂。\r\n主要成分：纯品\r\nCAS号：144-19-4\r\n相对分子质量：146.22\r\n化学类别：144-19-4\r\n燃烧性：可燃\r\n闪点：113\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3730mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：基本无毒害。对眼基本无刺激，对皮肤有轻至中度刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (469, '111-29-5', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应\0', '1,5-pentadiol；1,5-pentylene glycol', 'C5H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水\0', '1,5-戊二醇', '外观与性状：无色、无味、粘稠液体。\r\n熔点(℃)：-18\r\n相对密度(水=1)：0.99(20℃)\r\n沸点(℃)：239\r\n相对密度(空气=1)：3.59\r\n饱和蒸气压(kPa)：<0.0013(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于甲醇、乙醇、丙酮。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：111-29-5\r\n相对分子质量：104.15\r\n化学类别：111-29-5\r\n燃烧性：可燃\r\n闪点：129\r\n引燃温度：335\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5890mg/kg(大鼠经口)；>21ml/Kg(兔经皮]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼有轻微刺激性，对皮肤无刺激性。\r\n危险特性：遇明火、高热可燃。\r\n', '酰基氯、酸酐、氧化剂、氯仿、还原剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (470, '93-56-1', NULL, '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时轻装轻卸，\0', 'styrene glycol', 'C8H10O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。用大量水冲洗，洗水稀释后放入废水系统。若大量泄漏，收集回收或运至废物处理场所处置。', '苯乙二醇', '外观与性状：白色, 近于无臭的固体。\r\n熔点(℃)：66-68\r\n相对密度(水=1)：\r\n沸点(℃)：221\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于甲醇、乙醚。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：93-56-1\r\n相对分子质量：138.16\r\n化学类别：93-56-1\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1000mg/kg(大鼠经口)；2000～2600mg/kg(豚鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤无损害，未见经皮吸收中毒。\r\n危险特性：遇明火、高热可燃。\r\n', '酸类、酰基氯、酸酐、氧化剂。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (471, '107-41-5', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'hexalene glycol；2-methyl-2,4-pentadiol', 'C6H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。\0', '己二醇；2-甲基-2,4-戊二醇', '外观与性状：略带臭味的液体。\r\n熔点(℃)：-40\r\n相对密度(水=1)：0.92(20℃)\r\n沸点(℃)：197.1\r\n相对密度(空气=1)：4.1\r\n饱和蒸气压(kPa)：0.007(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于乙醇、溶于多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：107-41-5\r\n相对分子质量：118.17\r\n化学类别：107-41-5\r\n燃烧性：可燃\r\n闪点：121\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：400mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度对眼、呼吸道有刺激作用。\r\n危险特性：遇明火、高热可燃。\r\n', '强酸、强氧化剂、强还原剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (472, '112-50-5', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。保持良好的卫生习惯。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应品种和数\0', 'triethylene glycol ethyl ether', 'C8H18O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '三乙二醇乙醚', '外观与性状：液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.02(20℃)\r\n沸点(℃)：255.8\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.0013(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作溶剂, 也作为稀释剂和某些化学中间产物。\r\n主要成分：纯品\r\nCAS号：112-50-5\r\n相对分子质量：178.22\r\n化学类别：112-50-5\r\n燃烧性：可燃\r\n闪点：135\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：10600mg/kg(大鼠经口)；8ml/Kg(兔经皮]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼和皮肤几乎无刺激性。未见职业性危害。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (473, '122-99-6', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、接\0', '2-phenoxyethyl alcohol；ethylene glycol phenyl eth', 'C8H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀\0', '2-苯氧基乙醇；乙二醇苯基醚', '外观与性状：无色液体, 有特臭。\r\n熔点(℃)：14\r\n相对密度(水=1)：1.10\r\n沸点(℃)：242\r\n相对密度(空气=1)：4.8\r\n饱和蒸气压(kPa)：5.20(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作醋酸纤维素、树脂、染料和墨水的溶剂, 也用于合成增塑剂、杀菌剂、香料和药物等。\r\n主要成分：纯品\r\nCAS号：122-99-6\r\n相对分子质量：138.16\r\n化学类别：122-99-6\r\n燃烧性：可燃\r\n闪点：121\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对兔眼有一定刺激作用。对无损皮肤刺激不明显，亦不易通过皮肤吸收。未见职业性危害。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、酰基氯、酸酐。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (474, '34590-94-8', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、\0', 'dipropylene glycol monomethyl ether；dipropylene g', 'C7H16O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '二丙二醇甲醚', '外观与性状：无色液体, 具有轻微醚类气味和苦味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.95\r\n沸点(℃)：193-195\r\n相对密度(空气=1)：5.11\r\n饱和蒸气压(kPa)：0.05(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作真漆、油漆、树脂、染料、油类和润滑油的溶剂, 也用作偶合和分散剂。\r\n主要成分：纯品\r\nCAS号：34590-94-8\r\n相对分子质量：149.00\r\n化学类别：34590-94-8\r\n燃烧性：可燃\r\n闪点：74\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：动物实验显示本品有轻度麻醉性及刺激性。未见职业性危害。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (475, '111-77-3', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'diethylene glycol monomethyl ether；methoxydiglyco', 'C5H12O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '二乙二醇单甲基醚；二乙二醇甲醚', '外观与性状：具有微芳香气味并略有苦味的无色液体。\r\n熔点(℃)：-70\r\n相对密度(水=1)：1.04(20℃)\r\n沸点(℃)：194.1\r\n相对密度(空气=1)：4.14\r\n饱和蒸气压(kPa)：0.027(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作溶剂, 也作为稀释剂和某些化学中间产物。\r\n主要成分：纯品\r\nCAS号：111-77-3\r\n相对分子质量：120.15\r\n化学类别：111-77-3\r\n燃烧性：可燃\r\n闪点：83\r\n引燃温度：221\r\n爆炸下限：1.38(135℃)\r\n爆炸上限：22.7(167℃)\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：9210mg/kg(大鼠经口)；650mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：动物实验本品有麻醉作用及损害肾脏。对眼有刺激性。对皮肤刺激作用不明显，可经皮肤吸收。未见职业性危害。\r\n危险特性：遇明火、高热可燃。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。\r\n', '强氧化剂。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (476, '95-63-6', '33536', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1,2,4-trimethylbenzene；pseudocumene', 'C9H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降\0', '1,2,4-三甲基苯；假枯烯', '外观与性状：无色液体。\r\n熔点(℃)：-61\r\n相对密度(水=1)：0.88\r\n沸点(℃)：168.9\r\n相对密度(空气=1)：4.1\r\n饱和蒸气压(kPa)：1.33(51.6℃)\r\n燃烧热(kJ/mol)：5190.3\r\n临界温度(℃)：381.2\r\n临界压力(MPa)：4.40\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、苯、等多数有机溶剂。\r\n主要用途：用于分析试剂、有机合成和制药工业。\r\n主要成分：纯品\r\nCAS号：95-63-6\r\n相对分子质量：120.19\r\n化学类别：95-63-6\r\n燃烧性：易燃\r\n闪点：44\r\n引燃温度：485\r\n爆炸下限：0.9\r\n爆炸上限：7.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：18000mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼、呼吸道有刺激作用;对中枢神经系统有抑制作用。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与氧化剂能发生强烈反应。\r\n', '强氧化剂。', '740', '芳香烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (477, '111-90-0', NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：必要时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。搬运时要轻装轻\0', 'diethylene glycol monoethyl ether；Carbitol', 'C6H14O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，\0', '二乙二醇单乙基醚；二乙二醇乙醚', '外观与性状：具有微弱芳香气味和苦味的无色液体。\r\n熔点(℃)：-76\r\n相对密度(水=1)：0.99(20℃)\r\n沸点(℃)：201.9\r\n相对密度(空气=1)：4.62\r\n饱和蒸气压(kPa)：0.017(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：可混溶于丙酮、苯、氯仿、乙醇、乙醚。\r\n主要用途：用作树胶、喷漆、染料等的溶剂, 也作为稀释剂和某些化学中间产物。\r\n主要成分：纯品\r\nCAS号：111-90-0\r\n相对分子质量：134.18\r\n化学类别：111-90-0\r\n燃烧性：可燃\r\n闪点：94\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5540mg/kg(大鼠经口)；6580mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：动物实验引起麻醉作用及肾脏损害。对眼刺激不明显。对皮肤几无刺激性，未见职业性危害。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸、酰基氯、酸酐。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (478, NULL, NULL, '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备相应品种和数量的消防器材及泄漏\0', 'butylene glycol monoethyl ether', 'C6H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤\0', '丁二醇单乙基醚', '外观与性状：无色液体, 具轻微醚气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.89\r\n沸点(℃)：147\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.40(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：与水混溶、可混溶于油类、多数有机溶剂。\r\n主要用途：用作助溶剂、分散剂及油墨、树脂、真漆、油类和润滑油的溶剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：118.17\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：4000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：引起动物嗜睡，出现刺激症状，可引起肺、肝、肾损害。液体滴入兔眼内，引起眼损害。 未见职业性危害。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (479, '112-15-2', NULL, '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂\0', 'diethylene glycol monoethyl ether acetate；Carbito', 'C8H16O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤\0', '二乙二醇单乙基醚醋酸酯', '外观与性状：无色液体, 具有微弱令人不愉快的气味和苦味。\r\n熔点(℃)：-25\r\n相对密度(水=1)：1.01(20℃)\r\n沸点(℃)：217.4\r\n相对密度(空气=1)：6.07\r\n饱和蒸气压(kPa)：0.007(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、可混溶于醇、醚。\r\n主要用途：为油脂、油墨、树脂的优良溶剂, 用于制造油漆、粘合剂、塑料和除漆剂。\r\n主要成分：纯品\r\nCAS号：112-15-2\r\n相对分子质量：176.22\r\n化学类别：112-15-2\r\n燃烧性：可燃\r\n闪点：110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：11000mg/kg(大鼠经口)[50%水溶液]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃。\r\n侵入途径：吸入、食入。\r\n健康危害：对兔眼有刺激作用。工业接触和使用时，未见对人不良影响。\r\n危险特性：遇明火、高热可燃。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (480, '124-17-4', NULL, '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，佩戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。定期体检。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。搬运时要轻\0', 'diethylene glycolmonobutyl ether acetate；butyl ca', 'C10H20O4', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。\0', '二乙二醇单丁基醚醋酸酯', '外观与性状：具有轻微令人不愉快气味和苦味的清晰液体。\r\n熔点(℃)：-32.2\r\n相对密度(水=1)：0.98(20℃)\r\n沸点(℃)：247\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：<0.0013(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：易溶于水。\r\n主要用途：为油脂、油墨、树脂的优良溶剂, 用于制造油漆、粘合剂、塑料和除漆剂。\r\n主要成分：纯品\r\nCAS号：124-17-4\r\n相对分子质量：204.27\r\n化学类别：124-17-4\r\n燃烧性：可燃\r\n闪点：115\r\n引燃温度：299\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：11920mg/kg(大鼠经口)；5.5ml/Kg(兔经皮]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、酸类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：\r\n危险性综述：本品可燃，具麻醉性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对动物有强麻醉作用，对皮肤粘膜刺激弱，中毒剂量可经皮肤迅速吸收。工业上使用尚无中毒报告。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (481, '98-59-9', '61687', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱\0', '4-toluene sulfonyl chloride；p-toluene sulfonyl ch', 'C7H7ClO2S', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用砂土、干燥石灰或苏打灰混合。置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '4-甲苯磺酰氯；对甲苯磺酰氯', '外观与性状：白色菱状结晶，有刺激性恶臭。\r\n熔点(℃)：71\r\n相对密度(水=1)：\r\n沸点(℃)：145(2.0kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(88℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇、醚、苯。\r\n主要用途：用于有机合成，制造染料、糖精等。\r\n主要成分：纯品\r\nCAS号：98-59-9\r\n相对分子质量：190.65\r\n化学类别：98-59-9\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硫、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤和粘膜有刺激性，并引起迟发性深层疱疹和变态反应。长期接触引起头痛、酩酊感、恶心、呕吐、食欲不振、胃部压迫感和胃肠炎等症状。\r\n危险特性：遇明火、高热易燃。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强碱。', '739', '有机酰卤', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (482, '100-16-3', '61815', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。必要时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、酸类\0', '4-nitrophenylhydrazine；p-nitrophenylhydrazine', 'C6H7N3O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '4-硝基苯肼；对硝基苯肼', '外观与性状：橙黄色结晶粉末。\r\n熔点(℃)：158(分解)\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于热乙醇、乙醚、苯、氯仿、乙酸乙酯。\r\n主要用途：用作检验酮、醛和糖等的试剂。\r\n主要成分：纯品\r\nCAS号：100-16-3\r\n相对分子质量：153.14\r\n化学类别：100-16-3\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、上呼吸道、粘膜和皮肤有刺激性。\r\n危险特性：遇明火、高热可燃。与氧化剂混合能形成爆炸性混合物。经摩擦、震动或撞击可引起燃烧或爆炸。\r\n', '强氧化剂、强还原剂、强酸。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (483, '586-78-7', '61688', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还\0', '4-nitrobromobenzene；p-nitrobromobenzene', 'C6H4BrNO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '4-硝基溴苯；对硝基溴苯', '外观与性状：白色结晶。\r\n熔点(℃)：126～127\r\n相对密度(水=1)：1.94\r\n沸点(℃)：255～256\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、苯、等多数有机溶剂。\r\n主要用途：用于有机合成、染料中间体。\r\n主要成分：纯品\r\nCAS号：586-78-7\r\n相对分子质量：202.01\r\n化学类别：586-78-7\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后可能对身体有害。对眼睛和皮肤有刺激性。经皮肤可迅速吸收，引起高铁血红蛋白血症，出现紫绀。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强碱。', '787', '硝基芳香化合物', '2732', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (484, '100-11-8', '61690', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，应该佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、碱\0', '4-nitrobenzyl bromide；p-nitrobenzyl bromide', 'C7H6BrNO2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：收集回收或运至废物处理场所处置。', '4-硝基溴化苄；对硝基溴化苄', '外观与性状：白色或浅黄色针状结晶，有催泪性。\r\n熔点(℃)：99～100\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作有机分析试剂、染料中间体。\r\n主要成分：纯品\r\nCAS号：100-11-8\r\n相对分子质量：216.04\r\n化学类别：100-11-8\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。应与氧化剂、还原剂、碱类、胺类、醇类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或口服对身体有害。本品对眼睛、粘膜、呼吸道及皮肤有强烈刺激性。吸入后可因喉、支气管的痉挛、炎症、水肿，化学性肺炎或肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火能燃烧。受热分解产生有毒的烟气。与强氧化剂接触可发生化学反应。具有腐蚀性。\r\n', '碱、胺类、强氧化剂、醇类、强还原剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (485, '106-41-2', '61710', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接\0', '4-bromophenol；p-bromophenol', 'C6H5BrO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用砂土、干燥石灰或苏打灰混合。收集置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '4-溴苯酚；对溴酚', '外观与性状：无色或灰白色结晶。\r\n熔点(℃)：66.4\r\n相对密度(水=1)：1.84\r\n沸点(℃)：238\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：1.47(118.2℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、氯仿、等\r\n主要用途：用于有机合成及制药工业，也用作杀虫剂。\r\n主要成分：纯品\r\nCAS号：106-41-2\r\n相对分子质量：173.02\r\n化学类别：106-41-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：523mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：小鼠经皮最低中毒剂量(TDL0)：7200mg/kg(18周，间断)，致肿瘤阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、上呼吸道、粘膜和皮肤有刺激性。长时间接触可引起眼睛的强烈刺激或灼伤。\r\n危险特性：遇明火能燃烧。受高热燃烧并分解产生有毒气体。与强氧化剂接触可发生化学反应。\r\n', '酰基氯、酸酐、强氧化剂。', '742', '酚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (486, '121-69-7', '61756', '监测方法：气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场\0', 'N,N-dimethylaniline', 'C8H11N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', 'N,N-二甲基苯胺', '外观与性状：黄色油状液体。\r\n熔点(℃)：2.5\r\n相对密度(水=1)：0.96\r\n沸点(℃)：193.1\r\n相对密度(空气=1)：4.17\r\n饱和蒸气压(kPa)：0.13(29.5℃)\r\n燃烧热(kJ/mol)：4776.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、氯仿。\r\n主要用途：用作染料中间体、溶剂、稳定剂、分析试剂。\r\n主要成分：纯品\r\nCAS号：121-69-7\r\n相对分子质量：121.18\r\n化学类别：121-69-7\r\n燃烧性：易燃\r\n闪点：62.8\r\n引燃温度：317\r\n爆炸下限：1.0\r\n爆炸上限：7.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1410mg/kg(大鼠经口)；1770mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与酸类、卤素、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：毒性表现与苯胺相似，但较弱。吸收后可引起高铁血红蛋白血症。接触后出现恶心、眩晕、头痛、紫绀等。皮肤接触可发生溃疡。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。\r\n', '酸类、酸酐、酰基氯、氯仿、卤素。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (487, '91-66-7', '61756', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', 'N,N-diethylaniline；N,N-diethylphenylamine', 'C10H15N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', 'N,N-二乙基苯胺', '外观与性状：无色至黄色油状液体, 有特臭。\r\n熔点(℃)：-38.8\r\n相对密度(水=1)：0.93(25℃)\r\n沸点(℃)：215～216\r\n相对密度(空气=1)：5.2\r\n饱和蒸气压(kPa)：0.31(65℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于乙醇、乙醚。\r\n主要用途：用于染料及其中间体合成, 也用于制造药品。\r\n主要成分：纯品\r\nCAS号：91-66-7\r\n相对分子质量：149.23\r\n化学类别：91-66-7\r\n燃烧性：易燃\r\n闪点：88\r\n引燃温度：332\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：782mg/kg(大鼠经口)\r\nLC50：1920mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收可致死。蒸气或雾对眼、粘膜和上呼吸道有刺激性。吸收进入体内引起高铁血红蛋白血症，出现紫绀。\r\n危险特性：遇明火、高热易燃。与氧化剂接触猛烈反应。\r\n', '强氧化剂、强酸。', '785', '芳香胺', '2432', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (488, '135-88-6', '61834', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。搬运时要轻装轻\0', 'N-phenyl-2-naphthylamine', 'C16H13N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿一般作业工作服。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', 'N-苯基-2-萘胺；防老剂D', '外观与性状：淡灰色针状结晶或粉末。\r\n熔点(℃)：108\r\n相对密度(水=1)：1.20\r\n沸点(℃)：399.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、丙酮、苯。\r\n主要用途：用作橡胶抗氧剂、润滑剂、聚合抑制剂。\r\n主要成分：纯品\r\nCAS号：135-88-6\r\n相对分子质量：219.29\r\n化学类别：135-88-6\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：8730mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，具致敏性。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激性。对皮肤有致敏作用。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强酸。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (489, '103-69-5', '61756', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备\0', 'N-ethylaniline', 'C8H11N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水\0', 'N-乙基苯胺', '外观与性状：黄棕色透明油状液体，有苯胺气味。\r\n熔点(℃)：-63.5\r\n相对密度(水=1)：0.96\r\n沸点(℃)：204\r\n相对密度(空气=1)：4.18\r\n饱和蒸气压(kPa)：0.13(38.5℃)\r\n燃烧热(kJ/mol)：4687.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：103-69-5\r\n相对分子质量：121.18\r\n化学类别：103-69-5\r\n燃烧性：可燃\r\n闪点：85\r\n引燃温度：\r\n爆炸下限：1.6\r\n爆炸上限：9.5\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：334mg/kg(大鼠经口)；4700mg/kg(兔经皮)\r\nLC50：1480mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：毒性与苯胺相似，但稍弱。能引起高铁血红蛋白血症，造成组织缺氧，对中枢神经系统及其它脏器有损害。\r\n危险特性：遇明火能燃烧。加热或遇高热分解和接触酸或酸雾均能放出苯胺和氮的氧化物气体。与氧化剂可发生反应。与硝酸反应强烈。\r\n', '酸类、酰基氯、酸酐、强氧化剂、二氧化碳。', '785', '芳香胺', '2272', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (490, '134-32-7', '61830', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：高浓度蒸气接触可应该佩戴过滤式防毒面具（半面罩）；可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触\0', 'α-naphthylamine；α-aminonaphthalene', 'C10H9N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', 'α-萘胺；α-氨基萘', '外观与性状：纯品为无色结晶或块状，有恶臭，易升华。\r\n熔点(℃)：50\r\n相对密度(水=1)：1.13\r\n沸点(℃)：300.8\r\n相对密度(空气=1)：4.93\r\n饱和蒸气压(kPa)：0.13(104.3℃)\r\n燃烧热(kJ/mol)：5281.4\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作染料中间体，以及用于医药工业。\r\n主要成分：纯品\r\nCAS号：134-32-7\r\n相对分子质量：143.18\r\n化学类别：134-32-7\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：779mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人为可疑性反应，动物为不肯定反应。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为可疑致癌物，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有轻微的高铁血红蛋白形成作用，吸入后有可能引起紫绀。对眼有刺激性。对皮肤有弱刺激作用。本品的致癌作用尚无定论，但如长期接触含有已知致癌剂β- 萘胺的本品，有可能引起膀胱癌。\r\n危险特性：可燃。受高热分解放出有毒的气体。与氧化剂可发生反应。\r\n', '酸类、酸酐、强氧化剂。', '785', '芳香胺', '2077', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (491, '91-59-8', '61830', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。\0', 'β-naphthylamine；β-aminonaphthalene', 'C10H9N', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', 'β-萘胺；β-氨基萘', '外观与性状：白色到微粉红色片状，略有芳香气味。\r\n熔点(℃)：111.5\r\n相对密度(水=1)：1.06\r\n沸点(℃)：306.0\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(108.0℃)\r\n燃烧热(kJ/mol)：5270.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于热水、乙醇、乙醚、苯。\r\n主要用途：用作染料中间体、分析试剂。\r\n主要成分：纯品\r\nCAS号：91-59-8\r\n相对分子质量：143.18\r\n化学类别：91-59-8\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：727mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：人类致癌物质。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为致癌物，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有引起高铁血红蛋白血症的作用。中毒症状有紫绀、排尿困难。\r\n危险特性：可燃。受高热分解放出有毒的气体。与氧化剂可发生反应。\r\n', '强氧化剂、酸类、酸酐。', '785', '芳香胺', '1650', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (492, '62-53-3', '61746', '监测方法：盐酸萘乙二胺比色法；溶剂解吸－气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备\0', 'aniline；aminobenzene', 'C6H7N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '苯胺；氨基苯', '外观与性状：无色或微黄色油状液体，有强烈气味。\r\n熔点(℃)：-6.2\r\n相对密度(水=1)：1.02\r\n沸点(℃)：184.4\r\n相对密度(空气=1)：3.22\r\n饱和蒸气压(kPa)：2.00(77℃)\r\n燃烧热(kJ/mol)：3389.8\r\n临界温度(℃)：425.6\r\n临界压力(MPa)：5.30\r\n辛醇/水分配系数：0.94\r\n溶解性：微溶于水、溶于乙醇、乙醚、苯。\r\n主要用途：用于染料、医药、橡胶、树脂、香料等的合成。\r\n主要成分：纯品\r\nCAS号：62-53-3\r\n相对分子质量：93.12\r\n化学类别：62-53-3\r\n燃烧性：可燃\r\n闪点：70\r\n引燃温度：\r\n爆炸下限：1.3\r\n爆炸上限：11.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：空气、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：442mg/kg(大鼠经口)；820mg/kg(兔经皮)\r\nLC50：665mg/m3，7小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。避光保存。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品主要引起高铁血红蛋白血症、溶血性贫血和肝、肾损害。易经皮肤吸收。急性中毒：患者口唇、指端、耳廓紫绀，有头痛、头晕、恶心、呕吐、手指发麻、精神恍惚等；重度中毒时，皮肤、粘膜严重青紫，呼吸困难，抽搐，甚至昏迷，休克。出现溶血性黄疸、中毒性肝炎及肾损害。可?\n危险特性：遇明火、高热可燃。与酸类、卤素、醇类、胺类发生强烈反应，会引起燃烧。\r\n', '强氧化剂、酸类、酰基氯、酸酐。', '785', '芳香胺', '1547', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (493, '108-95-2', '61067', '监测方法：4－氨基安替比林比色法；气相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。尽可能采取隔离操作。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉\0', 'phenol；carbolic acid', 'C6H6O', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用干石灰、苏打灰覆盖，大量泄漏：收集回收或运至废物处理场所处置。', '苯酚；石炭酸', '外观与性状：白色结晶，有特殊气味。\r\n熔点(℃)：40.6\r\n相对密度(水=1)：1.07\r\n沸点(℃)：181.9\r\n相对密度(空气=1)：3.24\r\n饱和蒸气压(kPa)：0.13(40.1℃)\r\n燃烧热(kJ/mol)：3050.6\r\n临界温度(℃)：419.2\r\n临界压力(MPa)：6.13\r\n辛醇/水分配系数：1.46\r\n溶解性：可混溶于乙醇、醚、氯仿、甘油。\r\n主要用途：用作生产酚醛树脂、卡普隆和己二酸的原料，也用于塑料和医药工业。\r\n主要成分：纯品\r\nCAS号：108-95-2\r\n相对分子质量：94.11\r\n化学类别：108-95-2\r\n燃烧性：可燃\r\n闪点：79\r\n引燃温度：715\r\n爆炸下限：1.7\r\n爆炸上限：8.6\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：317mg/kg(大鼠经口)；850mg/kg(兔经皮)\r\nLC50：316mg/m3(大鼠吸入)\r\n致癌性：小鼠经皮最低中毒剂量(TDL0)：16g/kg，40周(间歇)，致癌，皮肤肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。库温不超过30℃，相对湿度不超过70％。包装密封。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具强腐蚀性，可致人体灼伤，对环境有严重危害，对水体和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：苯酚对皮肤、粘膜有强烈的腐蚀作用，可抑制中枢神经或损害肝、肾功能。急性中毒：吸入高浓度蒸气可致头痛、头晕、乏力、视物模糊、肺水肿等。误服引起消化道灼伤，出现烧灼痛，呼出气带酚味，呕吐物或大便可带血液，有胃肠穿孔的可能，可出现休克、肺水肿、肝或肾损害，出现?\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸、强碱。', '742', '酚', '1671', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (494, '108-98-5', '61090', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', 'phenyl mercaptan；thiophenol', 'C6H6S', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或\0', '苯基硫醇；苯硫酚', '外观与性状：无色有窒息性气味的液体。\r\n熔点(℃)：-14.8\r\n相对密度(水=1)：1.07\r\n沸点(℃)：168.3\r\n相对密度(空气=1)：3.8\r\n饱和蒸气压(kPa)：1.33(46.4℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、苯、二硫化碳。\r\n主要用途：用于有机合成、制药工业、以及用作分析试剂。\r\n主要成分：纯品\r\nCAS号：108-98-5\r\n相对分子质量：110.18\r\n化学类别：108-98-5\r\n燃烧性：易燃\r\n闪点：51\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：46.2mg/kg(大鼠经口)；134mg/kg(兔经皮)\r\nLC50：149mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，高毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、粘膜、呼吸道及皮肤有强烈的刺激作用，吸入后可引起喉、支气管痉挛、水肿，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热分解产生有毒的硫化物烟气。\r\n', '强氧化剂、强碱。', '789', '醇', '2337', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (495, '93-58-3', '61624', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl benzoate；benzoic acid methyl ester', 'C8H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '苯甲酸甲酯；苯酸甲酯', '外观与性状：无色液体。\r\n熔点(℃)：-12.3\r\n相对密度(水=1)：1.09\r\n沸点(℃)：198\r\n相对密度(空气=1)：4.68\r\n饱和蒸气压(kPa)：0.13(39℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于甲醇、乙醇、乙醚。\r\n主要用途：用于香料工业及用作溶剂。\r\n主要成分：纯品\r\nCAS号：93-58-3\r\n相对分子质量：136.15\r\n化学类别：93-58-3\r\n燃烧性：可燃\r\n闪点：82\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3430mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮吸收对身体有害。蒸气或雾对眼和上呼吸道有刺激性。对皮肤有刺激性。对呼吸道和皮肤有致敏作用。\r\n危险特性：遇明火、高热能引起燃烧爆炸。与氧化剂接触猛烈反应。\r\n', '强氧化剂、强碱。', '749', '羧酸酯', '2938', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (496, '100-47-0', '61638', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和\0', 'benzonitrile', 'C7H5N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成\0', '苯甲腈；氰化苯', '外观与性状：无色油状液体，有杏仁的气味。\r\n熔点(℃)：-12.8\r\n相对密度(水=1)：1.01\r\n沸点(℃)：190.7\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(28.2℃)\r\n燃烧热(kJ/mol)：3617.8\r\n临界温度(℃)：426.2\r\n临界压力(MPa)：4.22\r\n辛醇/水分配系数：\r\n溶解性：微溶于冷水、溶于热水、易溶于乙醇、乙醚。\r\n主要用途：用作合成橡胶中间体。\r\n主要成分：纯品\r\nCAS号：100-47-0\r\n相对分子质量：103.12\r\n化学类别：100-47-0\r\n燃烧性：可燃\r\n闪点：71\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1200mg/kg(大鼠经皮)；971mg/kg(兔经皮)\r\nLC50：6000mg/m3(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：有因衣服沾染了本品而发生严重中毒的报道。患者出现意识丧失、痉挛。本品对眼有刺激性。皮肤较长时间接触有刺激作用。动物吸入蒸气或小剂量灌胃，主要为麻醉作用。大剂量引起痉挛。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', '2224', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (497, '140-29-4', '61641', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。车间应配备急救设备及药品。单独存放被毒物污染的衣服，洗后备用。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的\0', 'phenylacetonitrile；benzyl cyanide', 'C8H7N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '苯乙腈；氰化苄', '外观与性状：无色油状液体，有刺激气味。\r\n熔点(℃)：-23.8\r\n相对密度(水=1)：1.02\r\n沸点(℃)：233.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(60℃)\r\n燃烧热(kJ/mol)：4278.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：140-29-4\r\n相对分子质量：117.15\r\n化学类别：140-29-4\r\n燃烧性：可燃\r\n闪点：101\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氰化氢。\r\n急性毒性：LD50：270mg/kg(大鼠经口)；270mg/kg(兔经皮)\r\nLC50：430mg/m3，2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具刺激性，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：毒作用与氢氰酸相似，并有局部刺激作用。吸入后出现头痛、头晕、恶心、呕吐、倦睡、上呼吸道刺激、神志丧失等，可引起死亡。对眼和皮肤有刺激性。可经皮服迅速吸收。口服可有消化道刺激症状。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', '2470', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (498, '100-63-0', '61813', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止烟雾或粉尘泄漏到工作场\0', 'phenylhydrazine；hydrazinobenzene', 'C6H8N2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。若是液体，尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑\0', '苯肼；苯基联胺', '外观与性状：淡黄色晶体或油状液体，有刺激性气味。\r\n熔点(℃)：19.4\r\n相对密度(水=1)：1.10\r\n沸点(℃)：243.5\r\n相对密度(空气=1)：4.3\r\n饱和蒸气压(kPa)：1.33(115℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于冷水、溶于热水、乙醇、醚、苯、等多数有机溶剂。\r\n主要用途：用于有机合成及用作分析试剂。\r\n主要成分：纯品\r\nCAS号：100-63-0\r\n相对分子质量：108.14\r\n化学类别：100-63-0\r\n燃烧性：可燃\r\n闪点：70\r\n引燃温度：615\r\n爆炸下限：1.3\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：188mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品可引起溶血性贫血、高铁血红蛋白血症、高胆红素血症，以及中枢神经系统和肝、肾、心脏损害。急性中毒：轻度中毒有头痛、头晕、无力、食欲不振、腹痛、腹泻等。较重时尚有呼吸困难、抽搐、震颤，甚至共济失调、意识不清。重症者出现紫绀、黄疸、白细胞减少，并可发生溶血?\n危险特性：可燃。遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂。', '785', '芳香胺', '2572', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (499, '109-77-3', '61630', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触毒物时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生\0', 'propanedinitrile；dicyanomethane', 'C3H2N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '丙二腈；二氰甲烷', '外观与性状：无色结晶。\r\n熔点(℃)：30.5\r\n相对密度(水=1)：1.05\r\n沸点(℃)：220\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.67(109℃)\r\n燃烧热(kJ/mol)：1650.3\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、醇、苯、微溶于氯仿、乙酸。\r\n主要用途：用于有机合成，金的浸提剂。\r\n主要成分：纯品\r\nCAS号：109-77-3\r\n相对分子质量：66.06\r\n化学类别：109-77-3\r\n燃烧性：可燃\r\n闪点：112\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：60.8mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品毒性似氰化物。氰化物的特异作用为抑制细胞呼吸，造成组织缺氧。大鼠皮下注射近致死量的本品，出现呼吸困难、紫绀和抽搐，尿中硫氰酸盐排出量增加。\r\n危险特性：加热至 120℃，与碱性物质接触，立即猛烈聚合。受高热分解放出有毒的气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', '2647', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (500, NULL, '61876', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿连衣式胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系\0', 'chlordimeform', 'C10H13ClN2', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '杀虫脒', '外观与性状：白色结晶，有氨的气味。\r\n熔点(℃)：32\r\n相对密度(水=1)：1.1\r\n沸点(℃)：163～165\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.11\r\n溶解性：微溶于水、苯、氯仿。\r\n主要用途：作农药杀虫剂。\r\n主要成分：含量: 25％、30％和80％水剂、50％乳剂、2％、5％颗粒剂。\r\nCAS号：\r\n相对分子质量：196.68\r\n化学类别：\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化氮。\r\n急性毒性：LD50：160mg/kg(大鼠经口)；263mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品主要毒作用表现为意识障碍、高铁血红蛋白血症及出血性膀胱炎。短期内大量经皮肤、呼吸道吸收及口服致中毒出现头昏、头痛、乏力、胸闷、恶心、嗜睡、紫绀、尿急、尿频、尿痛、血尿，甚至昏迷。部分中毒者可有心肌损害。血高铁血红蛋白含量升高，大于10％。\r\n危险特性：遇明火、高热可燃。受高热分解，产生有毒的氮氧化物和氯化物气体。\r\n', '强氧化剂。', '800', '未指定的化学类别', '2761', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (501, '79-06-1', '61740', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、碱类、接触\0', 'acrylamide', 'C3H5NO', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '丙烯酰胺', '外观与性状：白色结晶固体，无气味。\r\n熔点(℃)：84.5\r\n相对密度(水=1)：1.12\r\n沸点(℃)：125(3.33kPa)\r\n相对密度(空气=1)：2.45\r\n饱和蒸气压(kPa)：0.21(84.5℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：-0.67\r\n溶解性：溶于水、乙醇、乙醚、丙酮、不溶于苯。\r\n主要用途：用于制造水溶性聚合物即聚丙烯酰胺。\r\n主要成分：纯品\r\nCAS号：79-06-1\r\n相对分子质量：71.08\r\n化学类别：79-06-1\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：150~180mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物阳性。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。不宜大量储存或久存。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，为可疑致癌物。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品是一种蓄积性的神经毒物，主要损害神经系统。轻度中毒以周围神经损害为主；重度可引起小脑病变。中毒多为慢性经过，初起为神经衰弱综合征。继之发生周围神经病。出现四肢麻木，感觉异常，腱反射减弱或消失，抽搐，瘫痪等。重度中毒出现以小脑病变为主的中毒性脑病。出现?\n危险特性：遇明火、高热可燃。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。受高热分解产生有毒的腐蚀性烟气。\r\n', '强氧化剂、酸类、碱类。', '767', '酰胺', '2074', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (502, '142-59-6', '61880', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴自吸过滤式防尘口罩或自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿连衣式胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、碱类、接触。搬运时要\0', 'Dithane D-14；disodium ethylene-1,2-bis-dithiocarb', 'C4H6N2S4Na2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。用洁净的铲子收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收或运至废物处理场所处置。', '代森钠；1,2-亚乙基双二硫代氨基甲酸钠', '外观与性状：有硫样臭味的琥珀样固体。\r\n熔点(℃)：78-81\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作农用杀菌剂。\r\n主要成分：含量: 4.19％水溶液; 93.0％水溶性粉剂。\r\nCAS号：142-59-6\r\n相对分子质量：256.36\r\n化学类别：142-59-6\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、硫化物、氧化钠。\r\n急性毒性：LD50：395mg/kg(大鼠经口)；580mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、等分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，具致敏性，对环境有危害。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼、上呼吸道和皮肤有刺激作用。对皮肤有致敏作用。有致甲状腺肿作用。高浓度有麻醉作用。饮酒后接触本品可致剧吐。大量口服可致死。\r\n危险特性：遇明火、高热可燃。受热分解，放出氮、硫的氧化物等毒性气体。\r\n', '强氧化剂、强酸、强碱、潮湿空气。', '800', '未指定的化学类别', '2771', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (503, '3566-10-7', '61880', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴自吸过滤式防尘口罩或自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿连衣式胶布防毒衣，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、碱类、\0', 'Dithane staneless；Amobam', 'C4H6N2S4(NH4)2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。用洁净的铲子收集于干燥、洁净、有盖的容器中。若大量泄漏，收集回收或运至废物处理场所处置。', '代森铵；1,2-亚乙基双二硫代氨基甲酸铵', '外观与性状：纯品为无色晶体, 工业品为橙黄色或淡黄色水溶液, 呈弱碱性, 有氨及硫化氢臭味。\r\n熔点(℃)：72.5～72.8\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、微溶于乙醇、丙酮、不溶于苯。\r\n主要用途：用作农用杀虫菌剂。\r\n主要成分：含量: 45.0％水溶液。\r\nCAS号：3566-10-7\r\n相对分子质量：246.44\r\n化学类别：3566-10-7\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、硫化物。\r\n急性毒性：LD50：450mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入。\r\n健康危害：对皮肤和粘膜有刺激性。主要通过口服引起中毒，中毒表现为晕厥、呼吸急促和心率增快等。重者出现瞳孔散大、昏迷。\r\n危险特性：遇明火、高热可燃。受热分解，放出氮、硫的氧化物等毒性气体。\r\n', '强氧化剂、强酸、强碱。', '800', '未指定的化学类别', '2771', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (504, '354-32-5', '23037', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿密闭型防毒服，戴橡胶手套。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与还原剂、酸类、接触。尤其要注意避免与水接触\0', 'trifluoroacetyl chloride', 'C2ClF3O', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。漏气容器要妥善处理，修复、检验后再用。', '三氟乙酰氯；氯化三氟乙酰', '外观与性状：无色、有刺激性的气体。\r\n熔点(℃)：-146\r\n相对密度(水=1)：\r\n沸点(℃)：-27\r\n相对密度(空气=1)：4.6\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：354-32-5\r\n相对分子质量：132.5\r\n化学类别：354-32-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、氯化氢、氟化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。保持容器密封。应与易燃物或可燃物、还原剂、酸类、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强刺激性。\r\n侵入途径：吸入。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道具有剧烈的刺激作用。吸入后可引起喉、支气管的炎症、水肿和痉挛，化学性肺炎或肺水肿。接触后可有烧灼感、咳嗽、喘息、气短、头痛、恶心和呕吐。\r\n危险特性：遇水或水蒸气反应放热并产生有毒的腐蚀性气体。遇潮时对大多数金属有腐蚀性。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强还原剂、强酸、易燃或可燃物、水。', '800', '未指定的化学类别', '3057', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (505, '592-43-8', '31009', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-hexene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-己烯', '外观与性状：无色易挥发液体。\r\n熔点(℃)：-141.4\r\n相对密度(水=1)：0.69\r\n沸点(℃)：68.5\r\n相对密度(空气=1)：2.92\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：3981.9\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等\r\n主要用途：用作有机合成的中间体。\r\n主要成分：纯品\r\nCAS号：592-43-8\r\n相对分子质量：84.16\r\n化学类别：592-43-8\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：245\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：蒸气或雾对眼和上呼吸道有刺激性，接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '强氧化剂、酸类。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (506, '763-29-1', '31010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-methyl-1-pentene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-甲基-1-戊烯', '外观与性状：无色易挥发液体，有不愉快的气味。\r\n熔点(℃)：-135\r\n相对密度(水=1)：0.68\r\n沸点(℃)：62.2\r\n相对密度(空气=1)：2.9\r\n饱和蒸气压(kPa)：43.46/37.3℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：763-29-1\r\n相对分子质量：84.16\r\n化学类别：763-29-1\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：300\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：115000mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性，接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '强氧化剂、酸类。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (507, '691-37-2', '31010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '4-methyl-1-pentene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '4-甲基-1-戊烯', '外观与性状：无色液体。\r\n熔点(℃)：-53.6\r\n相对密度(水=1)：0.67\r\n沸点(℃)：54\r\n相对密度(空气=1)：2.90\r\n饱和蒸气压(kPa)：56.52(38℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成, 用作塑料单体。\r\n主要成分：纯品\r\nCAS号：691-37-2\r\n相对分子质量：84.16\r\n化学类别：691-37-2\r\n燃烧性：易燃\r\n闪点：-31\r\n引燃温度：300\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或摄入对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '氧化剂、酸类。', '780', '烯烃', '2288', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (508, '922-61-2', '31010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '3-methyl-2-pentene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '3-甲基-2-戊烯', '外观与性状：无色液体。\r\n熔点(℃)：-138.4--138.8\r\n相对密度(水=1)：0.70\r\n沸点(℃)：70.5(顺);67.6(反)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、苯、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：922-61-2\r\n相对分子质量：84.16\r\n化学类别：922-61-2\r\n燃烧性：易燃\r\n闪点：-6\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '780', '烯烃', '2288', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (509, '625-27-4', '31010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-methyl-2-pentene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-甲基-2-戊烯', '外观与性状：无色液体。\r\n熔点(℃)：-135\r\n相对密度(水=1)：0.69(15℃)\r\n沸点(℃)：66.9\r\n相对密度(空气=1)：2.9\r\n饱和蒸气压(kPa)：43.46(38℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：625-27-4\r\n相对分子质量：84.16\r\n化学类别：625-27-4\r\n燃烧性：易燃\r\n闪点：-23\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入或摄入对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。接触后出现烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '氧化剂、酸类。', '780', '烯烃', '2288', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (510, '691-38-3', '31010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '4-methyl-2-pentene；1-isopropyl-2-methyl ethylene', 'C6H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '4-甲基-2-戊烯', '外观与性状：无色液体。\r\n熔点(℃)：-134.4\r\n相对密度(水=1)：0.67\r\n沸点(℃)：58\r\n相对密度(空气=1)：2.90\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、丙酮、乙醚、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：691-38-3\r\n相对分子质量：84.16\r\n化学类别：691-38-3\r\n燃烧性：易燃\r\n闪点：-33\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或摄入对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '氧化剂、强酸。', '780', '烯烃', '2288', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (511, '121-46-0', '31016', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'dicycloheptadiene；2,5-norbornadiene', 'C7H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '二环庚二烯；2,5-降冰片二烯', '外观与性状：无色液体, 有特臭。\r\n熔点(℃)：-19\r\n相对密度(水=1)：0.85\r\n沸点(℃)：89\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于制环戊二烯系农药及不饱和聚酯树脂等。\r\n主要成分：纯品\r\nCAS号：121-46-0\r\n相对分子质量：92.1\r\n化学类别：121-46-0\r\n燃烧性：易燃\r\n闪点：-11\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：890mg/kg(大鼠经口)\r\nLC50：14100ppm，8小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，有毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品可由呼吸道和消化道进入体内。中毒后引起头痛、咳嗽、迟钝、呼吸困难、恶心。对眼和皮肤有刺激性。对皮肤有脱脂作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '780', '烯烃', '2251', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (512, NULL, '31018', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可建议佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。充\0', '2-pentyne；ethyl methyl acetylene', 'C5H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液\0', '2-戊炔；乙基甲基乙炔', '外观与性状：\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：68.11\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：\r\n聚合危害：\r\n避免接触的条件：\r\n燃烧(分解)产物：\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，对环境有危害，对大气可造成污染。\r\n侵入途径：\r\n健康危害：。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', NULL, '796', '炔烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (513, '557-17-5', '31028', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、卤素、接触。充装要控制流速，防止静电积聚\0', 'methyl propyl ether；1-methoxypropane', 'C4H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '甲丙醚；1-甲氧基丙烷', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.75\r\n沸点(℃)：38.5\r\n相对密度(空气=1)：2.56\r\n饱和蒸气压(kPa)：53.32/22.5℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作溶剂和用于麻醉剂制备。\r\n主要成分：纯品\r\nCAS号：557-17-5\r\n相对分子质量：74.12\r\n化学类别：557-17-5\r\n燃烧性：易燃\r\n闪点：<-20\r\n引燃温度：\r\n爆炸下限：2.0\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过28℃。包装要求密封，不可与空气接触。应与氧化剂、卤素、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具麻醉性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品为麻醉剂。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。长期储存, 可生成具有潜在爆炸危险性的过氧化物。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆?\n', '强氧化剂、氧、卤素、过氯酸。', '770', '醚', '2612', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (514, '6032-29-7', '33553', '监测方法：对二甲氨基苯甲醛比色法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2-amyl alcohol；sec-pentanol', 'C5H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀释后放入废水\0', '2-戊醇；仲戊醇', '外观与性状：无色液体。\r\n熔点(℃)：-50\r\n相对密度(水=1)：0.81\r\n沸点(℃)：119.3\r\n相对密度(空气=1)：3.04\r\n饱和蒸气压(kPa)：0.53(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用作溶剂。\r\n主要成分：含量＞99％。\r\nCAS号：6032-29-7\r\n相对分子质量：88.15\r\n化学类别：6032-29-7\r\n燃烧性：易燃\r\n闪点：34\r\n引燃温度：340\r\n爆炸下限：1.2\r\n爆炸上限：9.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1470mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。其蒸气或雾对眼睛、皮肤、粘膜和上呼吸道有刺激作用，还可引起头痛、头晕、呼吸困难、咳嗽、恶心、呕吐、 腹泻等；严重者有复视、耳聋、谵妄等，有时出现高铁血红蛋白血症*\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强酸、强氧化剂、酸酐、酰基氯。', '789', '醇', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (515, '109-92-2', '31029', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'vinyl ethyl ether；ethoxyethylene', 'C4H8O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '乙烯基乙醚；乙氧基乙烯', '外观与性状：无色液体。\r\n熔点(℃)：-115.3\r\n相对密度(水=1)：0.75\r\n沸点(℃)：35.6\r\n相对密度(空气=1)：2.5\r\n饱和蒸气压(kPa)：57.05/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于丙酮、苯、四氯化碳、等多数有机溶剂。\r\n主要用途：用作化学中间体。\r\n主要成分：纯品\r\nCAS号：109-92-2\r\n相对分子质量：72.11\r\n化学类别：109-92-2\r\n燃烧性：易燃\r\n闪点：-45\r\n引燃温度：200\r\n爆炸下限：1.7\r\n爆炸上限：28.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6153mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入或口服后，先兴奋，随之神志不清、呼吸麻痹。蒸气对呼吸道有刺激性，可致角膜损伤。液体对皮肤有轻度刺激作用。慢性影响：反复接触可能引起肝损害。长期皮肤接触，可因脱脂作用而发生皮炎。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。在空气中久置后能生成有爆炸性的过氧化物。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回?\n', '强氧化剂、氧、酸类。', '770', '醚', '1302', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (516, '534-15-6', '31031', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1,1-dimethoxyethane；dimethylacetal', 'C4H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系\0', '1,1-二甲氧基乙烷；二甲基乙缩醛', '外观与性状：无色液体，有浓芳香气味。\r\n熔点(℃)：-113.2\r\n相对密度(水=1)：0.85\r\n沸点(℃)：61.8\r\n相对密度(空气=1)：3.1\r\n饱和蒸气压(kPa)：8.0/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、氯仿。\r\n主要用途：用于医药和有机合成。\r\n主要成分：纯品\r\nCAS号：534-15-6\r\n相对分子质量：90.12\r\n化学类别：534-15-6\r\n燃烧性：易燃\r\n闪点：-18~23\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6500mg/kg(大鼠经口)；20000mg/kg(兔经皮)\r\nLC50：3000ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '通常商品加有稳定剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。接触空气或在光照条件下可生成具有潜在爆炸危险性的过氧化物。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大?\n', '强氧化剂、强酸。', '772', '金属烷氧化合物', '2377', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (517, '462-95-3', '31031', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'diethoxymethane；ethylal', 'C5H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '二乙氧基甲烷；二乙醇缩甲醛', '外观与性状：无色、澄清易挥发液体，有类似醚的气味。\r\n熔点(℃)：-66.5\r\n相对密度(水=1)：0.87\r\n沸点(℃)：89\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用于树脂和香料合成。\r\n主要成分：纯品\r\nCAS号：462-95-3\r\n相对分子质量：104.15\r\n化学类别：462-95-3\r\n燃烧性：易燃\r\n闪点：<-18\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2604mg/kg(兔经口)\r\nLC50：\r\n致癌性：\r\n', '通常商品加有稳定剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气或雾对眼、粘膜和上呼吸道有刺激性。对皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '772', '金属烷氧化合物', '2373', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (518, '75-33-2', '31035', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'isopropyl mercaptan；isopropanethiol', 'C3H8S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '异丙硫醇；硫代异丙醇', '外观与性状：无色液体，有极不愉快的气味。\r\n熔点(℃)：-130.5\r\n相对密度(水=1)：0.81\r\n沸点(℃)：57~60\r\n相对密度(空气=1)：2.6\r\n饱和蒸气压(kPa)：60.65/38.8℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、等\r\n主要用途：石油分析用的标准，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：75-33-2\r\n相对分子质量：76.15\r\n化学类别：75-33-2\r\n燃烧性：易燃\r\n闪点：-34\r\n引燃温度：\r\n爆炸下限：2.1\r\n爆炸上限：13.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：在空气中缓慢分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱金属、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入后，引起嗅觉丧失、肌无力、惊厥、呼吸麻痹。口服引起恶心、呕吐。对眼和皮肤有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。遇强酸能分解释出有毒气体。遇水释出有毒的腐蚀性气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、酸类、酸酐、酰基氯、碱金属。', '789', '醇', '2402', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (519, '513-53-1', '31036', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'sec-butyl mercaptan；2-butanethiol', 'C4H10S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '仲丁硫醇；第二丁硫醇', '外观与性状：无色液体，有不愉快气味。\r\n熔点(℃)：-165\r\n相对密度(水=1)：0.83\r\n沸点(℃)：85\r\n相对密度(空气=1)：3.11\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚、苯、等\r\n主要用途：用作有机合成中间体。\r\n主要成分：纯品\r\nCAS号：513-53-1\r\n相对分子质量：90.19\r\n化学类别：513-53-1\r\n燃烧性：易燃\r\n闪点：-23\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：在空气中缓慢分解。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱金属、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：如吸入或口服，对机体有害。蒸气或雾对眼和上呼吸道有刺激性。对皮肤有刺激性。接触后引起头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。受热分解或与酸类接触放出有毒气体。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、酸类、酸酐、酰基氯、碱金属。', '789', '醇', '1228', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (520, '542-18-7', 'T32001', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。保持良好的卫生习惯。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'cyclohexyl chloride', 'C6H11Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '环己基氯；氯化环己烷', '外观与性状：无色液体。\r\n熔点(℃)：-43\r\n相对密度(水=1)：0.99\r\n沸点(℃)：142\r\n相对密度(空气=1)：4.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇。\r\n主要用途：用于有机合成, 如环己烯的合成。\r\n主要成分：纯品\r\nCAS号：542-18-7\r\n相对分子质量：118.61\r\n化学类别：542-18-7\r\n燃烧性：易燃\r\n闪点：28\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：\r\nLC50：31000mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。对眼和皮肤有刺激性。接触后可引起恶心、头痛和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。受高热分解产生有毒的氯化物气体。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (521, '513-31-5', 'T32002', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意检测毒物。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '2-bromoallyl bromide；2,3-dibromopropene', 'C3H4Br2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车或\0', '2-溴丙烯基溴；2,3-二溴丙烯', '外观与性状：液体, 有催泪性, 在储存中颜色逐渐变深。\r\n熔点(℃)：\r\n相对密度(水=1)：1.93\r\n沸点(℃)：140-142\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.27(42℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：513-31-5\r\n相对分子质量：199.88\r\n化学类别：513-31-5\r\n燃烧性：易燃\r\n闪点：81\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，具催泪性，对环境有危害，对水体和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。蒸气或雾对眼、粘膜和上呼吸道有刺激性。接触后引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。受高热分解产生有毒的溴化物气体。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '765', '卤代烯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (522, '598-34-4', '32007', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '3-methyl hexane', 'C7H16', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '3-甲基己烷', '外观与性状：无色、有刺激性的液体。\r\n熔点(℃)：-119\r\n相对密度(水=1)：0.69\r\n沸点(℃)：92\r\n相对密度(空气=1)：3.46\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚、酮、苯、等\r\n主要用途：用于有机合成, 用作溶剂、气相色谱对比样品。\r\n主要成分：纯品\r\nCAS号：598-34-4\r\n相对分子质量：100.21\r\n化学类别：598-34-4\r\n燃烧性：易燃\r\n闪点：-4\r\n引燃温度：280\r\n爆炸下限：1\r\n爆炸上限：7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品蒸气能刺激皮肤、眼睛和粘膜，高浓度蒸气具有麻醉作用，对血象有轻度影响。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '771', '烷烃', '1206', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (523, '609-26-7', '32009', '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工\0', '2-methyl-3-ethylpentane；3-ethyl-2-methylpentane', 'C8H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的\0', '2-甲基-3-乙基戊烷；3-乙基-2-甲基戊烷', '外观与性状：无色液体。\r\n熔点(℃)：-114.9\r\n相对密度(水=1)：0.72\r\n沸点(℃)：115.6\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、丙酮、苯、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：609-26-7\r\n相对分子质量：114.23\r\n化学类别：609-26-7\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，有毒，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入蒸气可引起中毒。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸。', '771', '烷烃', '1262', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (524, '563-45-1', '32014', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '3-methyl-1-butene', 'C5H10', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '3-甲基-1-丁烯；异丙基乙烯', '外观与性状：无色易挥发液体，有不愉快气味。\r\n熔点(℃)：-168.5\r\n相对密度(水=1)：0.63\r\n沸点(℃)：31.1\r\n相对密度(空气=1)：2.4\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：191.6\r\n临界压力(MPa)：3.43\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇、醚。\r\n主要用途：用于有机合成和高辛燃料制造。\r\n主要成分：纯品\r\nCAS号：563-45-1\r\n相对分子质量：70.14\r\n化学类别：563-45-1\r\n燃烧性：易燃\r\n闪点：-20\r\n引燃温度：365\r\n爆炸下限：1.5\r\n爆炸上限：9.1\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入或摄入对身体有害。其蒸气或烟雾对眼睛、粘膜和呼吸道有刺激作用。中毒表现可有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '强氧化剂。', '780', '烯烃', '2561', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (525, '109-67-1', '31006', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '1-pentene', 'C5H10', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '1-戊烯；正戊烯', '外观与性状：无色液体，有恶臭。\r\n熔点(℃)：-124\r\n相对密度(水=1)：0.64\r\n沸点(℃)：30.1\r\n相对密度(空气=1)：2.42\r\n饱和蒸气压(kPa)：53.32(12.8℃)\r\n燃烧热(kJ/mol)：3347.2\r\n临界温度(℃)：201\r\n临界压力(MPa)：4.05\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、等\r\n主要用途：用于有机合成和制取异戊二烯，也用作高辛烷汽油的添加剂。\r\n主要成分：纯品\r\nCAS号：109-67-1\r\n相对分子质量：70.14\r\n化学类别：109-67-1\r\n燃烧性：易燃\r\n闪点：-28\r\n引燃温度：275\r\n爆炸下限：1.6\r\n爆炸上限：8.7\r\n最小点火能：0.56\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有麻醉作用,对眼、呼吸道和皮肤有刺激性。吸入后引起头痛、 头晕、恶心虚弱、四肢无力等。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触发生强烈反应, 甚至引起燃烧。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。由于流动、搅拌等，可能产生静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回?\n', '强氧化剂。', '780', '烯烃', '1108', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (526, '2738-18-3', '32019', '监测方法：\r\n工程控制：提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化\0', '2,6-dimethyl-3-heptene', 'C9H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围\0', '2,6-二甲基-3-庚烯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.72(15.5℃)\r\n沸点(℃)：128.5-129\r\n相对密度(空气=1)：4.38\r\n饱和蒸气压(kPa)：3.79(38℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：2738-18-3\r\n相对分子质量：126.23\r\n化学类别：2738-18-3\r\n燃烧性：易燃\r\n闪点：15.4\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：高浓度蒸气具有麻醉性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触猛烈反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、卤素。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (527, '100-50-5', '33580', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、还原剂、碱类\0', '1,2,5,6-tetrahydrobenzaldehyde；3-cyclohexene-1-ca', 'C7H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽车\0', '1,2,5,6-四氢化苯甲醛', '外观与性状：无色液体, 有一种令人舒适的气味。\r\n熔点(℃)：-110\r\n相对密度(水=1)：0.93\r\n沸点(℃)：164.5\r\n相对密度(空气=1)：3.8\r\n饱和蒸气压(kPa)：0.21(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、苯。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：100-50-5\r\n相对分子质量：110.2\r\n化学类别：100-50-5\r\n燃烧性：易燃\r\n闪点：54.4\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2460mg/kg(大鼠经口)；1770mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。本品对皮肤、眼睛、粘膜和上呼吸道有剧烈刺激作用。吸入后可引起喉、支气管的痉挛、水肿、炎症，化学性肺炎或肺水肿。接触后可有烧灼感、咳嗽、眩晕、气短、头痛、恶心和呕吐等。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。遇热释出酸性烟雾。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强碱、强氧化剂、强还原剂。', '773', '醛', '2498', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (528, '591-78-6', '33582', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '2-hexanone；methyl buthyl ketone', 'C6H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '2-己酮；甲基丁基甲酮', '外观与性状：无色液体，有丙酮的气味。\r\n熔点(℃)：-55.8\r\n相对密度(水=1)：0.81\r\n沸点(℃)：127.2\r\n相对密度(空气=1)：3.45\r\n饱和蒸气压(kPa)：1.33/38.8℃\r\n燃烧热(kJ/mol)：3740.7\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于乙醇、甲醇、苯。\r\n主要用途：用作溶剂。\r\n主要成分：纯品\r\nCAS号：591-78-6\r\n相对分子质量：100.16\r\n化学类别：591-78-6\r\n燃烧性：易燃\r\n闪点：23\r\n引燃温度：423\r\n爆炸下限：1.2\r\n爆炸上限：8.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2590mg/kg(大鼠经口)；4800mg/kg(兔经皮)\r\nLC50：8000ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：急性中毒时，具有粘膜刺激和麻醉作用，引起眼和上呼吸道的刺激症状。慢性作用：出现肢端麻木、刺痛、足根烧灼感、寒冷感、上下肢无力等周围神经炎表现。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (529, '110-12-3', '33583', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl isoamyl ketone；isobutylacetone', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '甲基异戊基甲酮；异庚酮', '外观与性状：无色、透明液体, 具有令人有愉快感的气味。\r\n熔点(℃)：-73.9\r\n相对密度(水=1)：0.81(20℃)\r\n沸点(℃)：144\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.6(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于多数有机溶剂。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：110-12-3\r\n相对分子质量：114.18\r\n化学类别：110-12-3\r\n燃烧性：易燃\r\n闪点：43\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3200mg/kg(大鼠经口)；3200～6400mg/kg(小鼠经口)；10000 mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛和皮肤有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', '1110', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (530, '123-19-3', '33583', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'dipropyl ketone；4-heptanone', 'C7H14O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自吸过滤式防毒面具（全面罩），穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的\0', '二丙基甲酮；4-庚酮', '外观与性状：无色、透明、低挥发性并具有香味的液体。\r\n熔点(℃)：-32.6\r\n相对密度(水=1)：0.82\r\n沸点(℃)：143.7\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：0.69(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于多数有机溶剂。\r\n主要用途：用作硝化纤维、原油和树脂等的溶剂, 也用于油漆工业。\r\n主要成分：纯品\r\nCAS号：123-19-3\r\n相对分子质量：114.18\r\n化学类别：123-19-3\r\n燃烧性：易燃\r\n闪点：49\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3057mg/kg(大鼠经口)；>3200mg/kg(小鼠经口)\r\nLC50：12540mg/m3，6小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼仅引起轻微的刺激。尚未见职业中毒的报道。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', '2710', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (531, '108-83-8', '33585', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'diisobutyl ketone；2,6-dimethyl-4-heptanone', 'C8H18O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '二异丁基甲酮；2,6-二甲基-4-庚酮', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：-41.5\r\n相对密度(水=1)：0.81\r\n沸点(℃)：166\r\n相对密度(空气=1)：4.9\r\n饱和蒸气压(kPa)：0.23/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作硝化纤维素、橡胶、树脂等的溶剂和涂料，以及有机合成等。\r\n主要成分：纯品\r\nCAS号：108-83-8\r\n相对分子质量：142.23\r\n化学类别：108-83-8\r\n燃烧性：易燃\r\n闪点：49\r\n引燃温度：396\r\n爆炸下限：0.8\r\n爆炸上限：7.1\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5750mg/kg(大鼠经口)；16000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：高浓度时有刺激和麻醉作用、可造成呼吸中枢抑制。反复接触发生恶心、眩晕。对肝、肾可有轻度影响。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', '1157', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (532, '565-75-3', '32009', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2,3,4-trimethylpentane', 'C8H18', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。然后运至空旷的地方掩埋、蒸发、或焚烧。\0', '2,3,4-三甲基戊烷', '外观与性状：无色液体。\r\n熔点(℃)：-110～-109\r\n相对密度(水=1)：0.72\r\n沸点(℃)：113～114\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醚、氯仿、苯。\r\n主要用途：用作溶剂及气相色谱对比样品。\r\n主要成分：纯品\r\nCAS号：565-75-3\r\n相对分子质量：114.2\r\n化学类别：565-75-3\r\n燃烧性：易燃\r\n闪点：5\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入本品蒸气有毒，有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。遇强氧化剂会引起燃烧爆炸。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (533, '583-60-8', '33586', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', '2-methylcyclohexanone；o-methylcyclohexanone', 'C7H12O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '2-甲基环己酮；邻甲基环己酮', '外观与性状：无色或淡黄色液体，有丙酮气味。\r\n熔点(℃)：-14\r\n相对密度(水=1)：0.92\r\n沸点(℃)：165\r\n相对密度(空气=1)：3.86\r\n饱和蒸气压(kPa)：1.33/55℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作溶剂。\r\n主要成分：纯品\r\nCAS号：583-60-8\r\n相对分子质量：112.17\r\n化学类别：583-60-8\r\n燃烧性：易燃\r\n闪点：48\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2140mg/kg(大鼠经口)；1635mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入高浓度蒸气可造成麻醉和死亡，但因该品气味强烈，一般不致高浓度吸入。液体溅入眼内可致眼损害，高浓度蒸气对眼也有刺激性。经皮肤吸收毒性低。长期反复接触可造成皮肤损害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '775', '酮', '2297', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (534, '123-54-6', '33587', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。避免长期反复接触。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'acetylacetone；2,4-pentanedione', 'C5H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '乙酰丙酮；2,4-戊二酮', '外观与性状：无色或微黄色液体，有酯的气味。\r\n熔点(℃)：-23.2\r\n相对密度(水=1)：0.98\r\n沸点(℃)：140.5\r\n相对密度(空气=1)：3.45\r\n饱和蒸气压(kPa)：0.93/20℃\r\n燃烧热(kJ/mol)：2574.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于醇、氯仿、醚、苯、丙酮、等多数有机溶剂。\r\n主要用途：用作醋酸纤维素的溶剂，有机合成中间体，金属络合剂，涂料干燥剂，润滑剂、杀虫剂。\r\n主要成分：纯品\r\nCAS号：123-54-6\r\n相对分子质量：100.11\r\n化学类别：123-54-6\r\n燃烧性：易燃\r\n闪点：34\r\n引燃温度：340\r\n爆炸下限：1.7\r\n爆炸上限：11.4\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：590mg/kg(大鼠经口)；810mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、还原剂、碱类、卤素、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。对眼睛和皮肤有刺激作用。中毒表现有头痛、恶心和呕吐。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、卤素、强还原剂、强碱。', '775', '酮', '2310', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (535, '109-49-9', '33588', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'allylacetone；5-hexen-2-one', 'C6H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '烯丙基丙酮；5-己烯-2-酮', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.84\r\n沸点(℃)：129.5\r\n相对密度(空气=1)：3.39\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇、醚、等\r\n主要用途：用于合成香料、杀虫剂和药品等。\r\n主要成分：纯品\r\nCAS号：109-49-9\r\n相对分子质量：98.15\r\n化学类别：109-49-9\r\n燃烧性：易燃\r\n闪点：23\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。具有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '强氧化剂、强还原剂、强酸。', '775', '酮', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (536, '141-79-7', '33588', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'methyl isobutenyl ketone；4-methyl-3-pentene-2-one', 'C6H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移至槽\0', '甲基异丁烯甲酮；4-甲基-3-戊烯-2-酮', '外观与性状：无色、透明、有强烈气味的油状液体。\r\n熔点(℃)：-59\r\n相对密度(水=1)：0.85(20℃)\r\n沸点(℃)：130.0\r\n相对密度(空气=1)：3.38\r\n饱和蒸气压(kPa)：1.3(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于多数有机溶剂。\r\n主要用途：用于制造聚氯乙烯、高分子聚合树脂、染料、油墨时的溶剂和矿物浮选, 也用作有机化学产品的中间体和防虫剂。\r\n主要成分：纯品\r\nCAS号：141-79-7\r\n相对分子质量：98.14\r\n化学类别：141-79-7\r\n燃烧性：易燃\r\n闪点：30.6\r\n引燃温度：344\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1120mg/kg(大鼠经口)；1000mg/kg(兔经皮)\r\nLC50：2500ppm(大鼠吸入)[LC]\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤、呼吸道粘膜有刺激作用。当空气中本品达到48mg/m3时即可嗅到气味，当105mg/m3时，即可引起鼻刺激，胸部不适，对眼有刺激。液体可造成角膜损害。高浓度有麻醉性，并可造成肺、肝、肾损害。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。与氯磺酸、发烟硫酸、硫酸剧烈反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若?\n', '强氧化剂、强酸。', '775', '酮', '1229', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (537, '107-70-0', '33591', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', '4-methoxy-4-methyl pentan-2-one；4-methoxy-4-methy', 'C7H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '4-甲氧基-4-甲基-2-戊酮', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：107-70-0\r\n相对分子质量：130.21\r\n化学类别：107-70-0\r\n燃烧性：易燃\r\n闪点：48\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼睛、皮肤和粘膜有刺激作用，高浓度时有麻醉作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂。', '775', '酮', '2293', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (538, '4351-54-6', '33595', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'cyclohexyl formate', 'C7H12O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '甲酸环己酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.006(0℃)\r\n沸点(℃)：162.5\r\n相对密度(空气=1)：4.4\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作有机溶剂。\r\n主要成分：纯品\r\nCAS号：4351-54-6\r\n相对分子质量：128.10\r\n化学类别：4351-54-6\r\n燃烧性：易燃\r\n闪点：51\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：高浓度时有显著刺激作用。目前，未见职业中毒报道。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', '2524', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (539, NULL, '33595', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'methyl cyclohexyl formate', 'C8H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '甲酸甲基环己酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：176-180\r\n相对密度(空气=1)：4.9\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作有机溶剂, 用于制造香料、熏蒸杀虫剂和杀菌剂。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：142.12\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有麻醉作用，对眼睛、皮肤、粘膜有刺激作用。目前，未见职业中毒资料报道。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (540, '104-57-4', '33595', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'benzyl formate；benzyl methanoate', 'C8H8O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系统。大量泄漏：构筑围堤或挖\0', '甲酸苄酯', '外观与性状：具有芳香气味的无色液体。\r\n熔点(℃)：3.6\r\n相对密度(水=1)：1.08\r\n沸点(℃)：203.4\r\n相对密度(空气=1)：4.7\r\n饱和蒸气压(kPa)：1.33(84℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、酮、芳烃、氯代烃。\r\n主要用途：用作有机溶剂。\r\n主要成分：纯品\r\nCAS号：104-57-4\r\n相对分子质量：136.14\r\n化学类别：104-57-4\r\n燃烧性：易燃\r\n闪点：42\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2000mg/kg(大鼠经皮)；1400mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：摄入或经皮肤接触有中等毒性。高浓度时，有麻醉作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (541, '692-45-5', '33595', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、碱\0', 'vinyl formate', 'C3H4O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降低\0', '甲酸乙烯酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：2.41\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用作有机溶剂、杀虫剂、杀菌剂等。\r\n主要成分：纯品\r\nCAS号：692-45-5\r\n相对分子质量：72.06\r\n化学类别：692-45-5\r\n燃烧性：易燃\r\n闪点：<0\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：2800mg/kg(大鼠经口)；2400mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '通常商品加有阻聚剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：摄入和皮肤接触有中度毒性。对眼睛有强烈刺激作用，对皮肤有轻度刺激作用。未见职业中毒的报道。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (542, '622-45-7', '33596', '监测方法：羟胺－氯化铁分光光度法\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或逃生时，建议佩戴空气呼吸器\r\n眼睛防护：空气中浓度较高时，佩戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴防化学品手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'cyclohexyl acetate；cyclohexanol acetate', 'C8H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '乙酸环己酯；环己基乙酸酯', '外观与性状：浅黄色液体, 具水果香味。\r\n熔点(℃)：-65\r\n相对密度(水=1)：0.96\r\n沸点(℃)：173\r\n相对密度(空气=1)：4.9\r\n饱和蒸气压(kPa)：0.93(60℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚、烃类。\r\n主要用途：用于化学合成, 用作香料和树脂、油漆的溶剂。\r\n主要成分：纯品\r\nCAS号：622-45-7\r\n相对分子质量：142.20\r\n化学类别：622-45-7\r\n燃烧性：易燃\r\n闪点：57\r\n引燃温度：335\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6700mg/kg(大鼠经口)；10000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛、皮肤、粘膜和上呼吸道有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱。', '749', '羧酸酯', '2243', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (543, '3522-94-9', '32010', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', '2,2,5-trimethylhexane', 'C9H2O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '2,2,5-三甲基己烷', '外观与性状：无色液体。\r\n熔点(℃)：-116.8\r\n相对密度(水=1)：0.71\r\n沸点(℃)：137.7\r\n相对密度(空气=1)：4.4\r\n饱和蒸气压(kPa)：1.72(21℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、易溶于醇。\r\n主要用途：作为发动机燃料, 也用于有机合成。\r\n主要成分：纯品\r\nCAS号：3522-94-9\r\n相对分子质量：128.26\r\n化学类别：3522-94-9\r\n燃烧性：易燃\r\n闪点：12.8\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：尚无本品吸入中毒的报道。但吸入高浓度烃类化合物可引起呼吸道刺激、头痛、倦睡、精神错乱、震颤、共济失调；极高浓度吸入可致死亡。液体吸入呼吸道可能引起吸入性肺炎、肺水肿。高浓度蒸气或液体对眼有刺激性。液体对皮肤有刺激性。口服毒性低。长期反复皮肤接触可致皮炎。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。与氧化剂能发生强烈反应, 引起燃烧或爆炸。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂。', '771', '烷烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (544, '142-92-7', '33596', '监测方法：羟胺－氯化铁分光光度法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'hexyl acetate', 'C8H16O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放\0', '乙酸正己酯；醋酸己酯', '外观与性状：无色液体，有甜酯气味。\r\n熔点(℃)：-80.9\r\n相对密度(水=1)：0.88\r\n沸点(℃)：171.5\r\n相对密度(空气=1)：4.97\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚、等多数有机溶剂。\r\n主要用途：用作纤维素酯和树脂的溶剂。\r\n主要成分：含量:≥98％；酸值 mgKOH/g≤1 。\r\nCAS号：142-92-7\r\n相对分子质量：144.21\r\n化学类别：142-92-7\r\n燃烧性：易燃\r\n闪点：43\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：42000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。具有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强还原剂、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (545, '108-84-9', '33596', '监测方法：羟胺－氯化铁分光光度法\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'sec-hexyl acetate', 'C8H16O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '乙酸仲己酯', '外观与性状：无色液体，有芳香气味。\r\n熔点(℃)：-63.8\r\n相对密度(水=1)：0.86\r\n沸点(℃)：146.3\r\n相对密度(空气=1)：4.97\r\n饱和蒸气压(kPa)：0.51/20℃\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、等多数有机溶剂。\r\n主要用途：用作硝化纤维素及油漆的溶剂，也用于香料。\r\n主要成分：纯品\r\nCAS号：108-84-9\r\n相对分子质量：144.21\r\n化学类别：108-84-9\r\n燃烧性：易燃\r\n闪点：45(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6160mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、还原剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼睛有刺激作用，可引起头痛、麻醉作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '749', '羧酸酯', '1233', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (546, '628-63-7', '33596', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'banana oil；amylacetic ester', 'C7H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后\0', '香蕉水；乙酸戊酯', '外观与性状：无色、有香蕉气味、易挥发的液体。\r\n熔点(℃)：-100\r\n相对密度(水=1)：0.88\r\n沸点(℃)：142\r\n相对密度(空气=1)：4.5\r\n饱和蒸气压(kPa)：0.67\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于醇、醚。\r\n主要用途：是制造喷漆溶剂、稀释剂的主要成分之一。\r\n主要成分：\r\nCAS号：628-63-7\r\n相对分子质量：130.19\r\n化学类别：628-63-7\r\n燃烧性：易燃\r\n闪点：25\r\n引燃温度：360\r\n爆炸下限：1.0\r\n爆炸上限：10\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6.50ml/Kg[大鼠经口][混合异构体]\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对眼和粘膜有刺激作用，高浓度吸入可引起中枢神经系统损害，甚至肝肾损害。急性中毒可出现急性结膜炎、咽喉炎、支气管肺炎、肺水肿。长期接触，有流泪、咳嗽、喉干、疲劳等症状，重者伴有头痛、恶心、呕吐、胸闷、心悸、食欲不振等。可致皮肤干裂、皮炎或湿疹；可致贫血，嗜?\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '氧化剂、强酸、卤素。', '800', '未指定的化学类别', '1104', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (547, '115-80-0', '33597', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'triethyl orthopropionate；ethyl orthopropinate', 'C9H20O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '原丙酸三乙酯；三乙氧基丙烷', '外观与性状：无色透明液体, 有芳香气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.88\r\n沸点(℃)：155-160\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、醚。\r\n主要用途：用作分析试剂、胶片增感剂, 并用于有机合成、染料和制药工业。\r\n主要成分：纯品\r\nCAS号：115-80-0\r\n相对分子质量：176.26\r\n化学类别：115-80-0\r\n燃烧性：易燃\r\n闪点：60\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：6400～12800mg/kg(大鼠经口)；>10000mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收后对身体有害。对皮肤有刺激作用。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (548, '123-20-6', '33598', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'vinyl butyrate；butyric acid,vinyl ester', 'C6H10O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泵转移\0', '丁酸乙烯酯', '外观与性状：挥发性液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.9\r\n沸点(℃)：117\r\n相对密度(空气=1)：4.0\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作水型涂料的聚合单体。\r\n主要成分：纯品\r\nCAS号：123-20-6\r\n相对分子质量：114.16\r\n化学类别：123-20-6\r\n燃烧性：易燃\r\n闪点：20\r\n引燃温度：\r\n爆炸下限：1.4\r\n爆炸上限：8.8\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：光照易聚合。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：8500mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避光保存。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、碱类、卤素、等分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容\0', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对皮肤、眼睛和粘膜有刺激作用。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。容易自聚，聚合反应随着温度的上升而急骤加剧。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。若遇高热，容器内压增大，有开裂和爆炸?\n', '氧化剂、酸类、碱类、卤素、过氧化物。', '749', '羧酸酯', '2838', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (549, '80-55-7', '33598', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中浓度超标时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethyl hydroxyisobutyrate；ethyl-2-hydroxy-isobutyr', 'C6H12O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲洗，洗水稀释后放入废水系\0', '2-羟基-2-甲基丙酸乙酯；羟基异丁酸乙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：0.98-0.99\r\n沸点(℃)：149-150\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、溶于醇、醚。\r\n主要用途：用作溶剂和用于有机合成和药物制造。\r\n主要成分：纯品\r\nCAS号：80-55-7\r\n相对分子质量：132.16\r\n化学类别：80-55-7\r\n燃烧性：易燃\r\n闪点：44\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、摄入或经皮肤吸收对身体有害。具有刺激性。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。与氧化剂可发生反应。流速过快，容易产生和积聚静电。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强氧化剂、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (550, NULL, '33595', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'n-hexyl formate', 'C7H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤\0', '甲酸正己酯；甲酸己酯', '外观与性状：无色液体，有水果香味。\r\n熔点(℃)：-62.7\r\n相对密度(水=1)：0.88\r\n沸点(℃)：155.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚。\r\n主要用途：用作溶剂，及合成香料的原料。\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：130.19\r\n化学类别：\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼睛、皮肤和粘膜有刺激作用。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (551, '507-09-5', '32113', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴过滤式防毒面具（半面罩）。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴乳胶手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿聚乙烯防毒服，戴乳胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧\0', 'thioacetic acid', 'C2H4OS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统。大量\0', '硫代乙酸；硫代醋酸', '外观与性状：无色液体，有刺激性气味。\r\n熔点(℃)：<-17\r\n相对密度(水=1)：1.07\r\n沸点(℃)：93\r\n相对密度(空气=1)：无资料\r\n饱和蒸气压(kPa)：无资料\r\n燃烧热(kJ/mol)：无资料\r\n临界温度(℃)：无资料\r\n临界压力(MPa)：无资料\r\n辛醇/水分配系数：无资料\r\n溶解性：溶于水、乙醇、乙醚、等\r\n主要用途：用作化学试剂、催泪剂等。\r\n主要成分：纯品\r\nCAS号：507-09-5\r\n相对分子质量：76.11\r\n化学类别：507-09-5\r\n燃烧性：易燃\r\n闪点：<1\r\n引燃温度：无资料\r\n爆炸下限：无资料\r\n爆炸上限：无资料\r\n最小点火能：无资料\r\n最大爆炸压力：无资料\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：200～400mg/kg(大鼠经口)\r\nLC50：无资料\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品是一种催泪毒气。蒸气对鼻、咽喉和皮肤有强烈刺激作用，并可经皮肤吸收而中毒。接触后主要出现皮肤、粘膜尤其是眼和上呼吸道的刺激症状和体征。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受高热分解产生有毒的硫化物烟气。具有腐蚀性。\r\n', '强氧化剂、强碱。', '800', '未指定的化学类别', '2436', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (552, '107-46-0', '32187', '监测方法：\r\n工程控制：密闭操作，全面排风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'hexamethyl disiloxane；hexamethyloxy disilane', 'C6H18SiO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。或在保证安全情况下，就地焚烧。大量泄漏：构筑\0', '六甲基二硅醚；六甲基氧二硅烷', '外观与性状：无色、透明液体, 易潮解。\r\n熔点(℃)：-59\r\n相对密度(水=1)：0.76(25℃)\r\n沸点(℃)：99.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用作硅油、硅橡胶、药品、气相色谱固定液、分析试剂、憎水剂等。\r\n主要成分：纯品\r\nCAS号：107-46-0\r\n相对分子质量：162.4\r\n化学类别：107-46-0\r\n燃烧性：易燃\r\n闪点：-1.1\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化硅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。对皮肤有刺激性。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。\r\n危险特性：遇高热、明火及强氧化剂易引起燃烧。\r\n', '强酸、强碱、强氧化剂、水、潮湿空气。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (553, '111-49-9', '32182', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴导管式防毒面具。紧急事态抢救或撤离时，建议佩戴氧气呼吸器、空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿带面罩式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：尽可能减少直接接触。工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿带面罩式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、接触。搬\0', 'hexamethyleneimine', 'C6H13N', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑围堤或挖坑\0', '六亚甲基亚胺', '外观与性状：无色至微黄色液体, 具有氨气味。\r\n熔点(℃)：-37\r\n相对密度(水=1)：0.88(20℃)\r\n沸点(℃)：138\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用作农药、医药品和橡胶制品的原料。\r\n主要成分：纯品\r\nCAS号：111-49-9\r\n相对分子质量：99.18\r\n化学类别：111-49-9\r\n燃烧性：易燃\r\n闪点：18\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：33mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对皮肤、粘膜和眼睛有强烈刺激性。可致皮肤灼伤。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂、强酸。', '762', '脂肪胺', '2493', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (554, '108-90-7', '33546', '监测方法：吡啶－碱比色法；溶剂解吸－气相色谱法\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'chlorobenzene；monochlorobenzene', 'C6H5Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '氯苯；一氯代苯', '外观与性状：无色透明液体，具有不愉快的苦杏仁味。\r\n熔点(℃)：-45.2\r\n相对密度(水=1)：1.10\r\n沸点(℃)：132.2\r\n相对密度(空气=1)：3.9\r\n饱和蒸气压(kPa)：1.33(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：359.2\r\n临界压力(MPa)：4.52\r\n辛醇/水分配系数：2.84\r\n溶解性：不溶于水、溶于乙醇、乙醚、氯仿、二硫化碳、苯、等多数有机溶剂。\r\n主要用途：作为有机合成的重要原料。\r\n主要成分：纯品\r\nCAS号：108-90-7\r\n相对分子质量：112.56\r\n化学类别：108-90-7\r\n燃烧性：易燃\r\n闪点：28\r\n引燃温度：590\r\n爆炸下限：1.3\r\n爆炸上限：9.6\r\n最小点火能：\r\n最大爆炸压力：0.560\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化物。\r\n急性毒性：LD50：2290mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有严重危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对中枢神经系统有抑制和麻醉作用；对皮肤和粘膜有刺激性。急性中毒：接触高浓度可引起麻醉症状，甚至昏迷。脱离现场，积极救治后，可较快恢复，但数日内仍有头痛、头晕、无力、食欲减退等症状。液体对皮肤有轻度刺激性，但反复接触，则起红斑或有轻度表浅性坏死。慢性中毒：?\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。与过氯酸银、二甲亚砜反应剧烈。\r\n', '强氧化剂。', '784', '卤代芳烃', '1134', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (555, '109-63-3', '32033', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、接触\0', '1-chlorobutane；butyl chloride', 'C4H9Cl', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '氯代正丁烷；丁基氯', '外观与性状：无色液体。\r\n熔点(℃)：-123.1\r\n相对密度(水=1)：0.89\r\n沸点(℃)：78\r\n相对密度(空气=1)：3.20\r\n饱和蒸气压(kPa)：10.57(20℃)\r\n燃烧热(kJ/mol)：2696.7\r\n临界温度(℃)：269\r\n临界压力(MPa)：3.68\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于有机合成及用作溶剂。\r\n主要成分：纯品\r\nCAS号：109-63-3\r\n相对分子质量：92.57\r\n化学类别：109-63-3\r\n燃烧性：易燃\r\n闪点：-12\r\n引燃温度：240\r\n爆炸下限：1.8\r\n爆炸上限：10.1\r\n最小点火能：1.2\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：2670mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品加热分解时，可产生光气，应注意。吸入、口服或经皮肤吸收对身体有害。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受高热分解产生有毒的腐蚀性烟气。与氧化剂能发生强烈反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱。', '759', '卤代烷', '1127', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (556, '107-30-2', '32089', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、\0', 'chloromethyl methyl ether；methyl chloromethyl eth', 'C2H5ClO', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。大量泄漏：构筑\0', '氯甲基甲醚；甲基氯甲醚', '外观与性状：无色或微黄色液体，带有刺激性气味。\r\n熔点(℃)：-103.5\r\n相对密度(水=1)：1.06\r\n沸点(℃)：59.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：34.66(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：作为氯甲基化剂。\r\n主要成分：纯品\r\nCAS号：107-30-2\r\n相对分子质量：80.51\r\n化学类别：107-30-2\r\n燃烧性：易燃\r\n闪点：15.5\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：500mg/kg(大鼠经口)\r\nLC50：182mg/m3，7小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：人类致癌物质。\r\n', '通常商品加有稳定剂。储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。不宜久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急\0', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，为致癌物，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品蒸气对呼吸道有强烈刺激性。吸入较高浓度后立即发生流泪、咽痛、剧烈呛咳、胸闷、呼吸困难并有发热、寒战，脱离接触后可逐渐好转。但经数小时至24小时潜伏期后，可发生化学性肺炎、肺水肿，抢救不及时可死亡。眼及皮肤接触可致灼伤。慢性影响：长期接触本品可引起支气管?\n危险特性：遇高热、明火、氧化剂有引起燃烧的危险。长期储存, 可生成具有潜在爆炸危险性的过氧化物。遇潮气、水份分解出有毒的甲醛气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、酸类。', '770', '醚', '1239', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (557, '105-58-8', '33608', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'diethyl carbonate；ethyl carbonate', 'C5H10O3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀\0', '碳酸二乙酯；碳酸乙酯', '外观与性状：无色液体，略有气味。\r\n熔点(℃)：-43\r\n相对密度(水=1)：1.0\r\n沸点(℃)：125.8\r\n相对密度(空气=1)：4.07\r\n饱和蒸气压(kPa)：1.33(23.8℃)\r\n燃烧热(kJ/mol)：2708.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于醇、酮、酯、等多数有机溶剂。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：105-58-8\r\n相对分子质量：118.13\r\n化学类别：105-58-8\r\n燃烧性：易燃\r\n闪点：25\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：1570mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品为轻度刺激剂和麻醉剂。吸入后引起头痛、头昏、虚弱、恶心、呼吸困难等。液体或高浓度蒸气对眼有刺激性。口服刺激胃肠道。皮肤长期反复接触有刺激性。\r\n危险特性：易燃，遇高热、明火有引起燃烧的危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '749', '羧酸酯', '2366', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (558, '302-01-2', '33631', '监测方法：对二甲氨基苯甲醛分光光度法；溶剂解吸－气相色谱法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（全面罩）或自给式呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（全面罩）或自给式呼吸器，穿连衣式胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'hydrazine anhydrous', 'H4N2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用大量水冲洗，洗水稀\0', '无水肼；无水联胺', '外观与性状：无色发烟液体，有氨的臭味。\r\n熔点(℃)：1.4\r\n相对密度(水=1)：1.01\r\n沸点(℃)：113.5\r\n相对密度(空气=1)：1.11\r\n饱和蒸气压(kPa)：1.92(25℃)\r\n燃烧热(kJ/mol)：621.1\r\n临界温度(℃)：380\r\n临界压力(MPa)：14.69\r\n辛醇/水分配系数：-1.37\r\n溶解性：与水混溶、溶于醇、液氨、等多数有机溶剂。\r\n主要用途：制发泡剂、农作物杀虫剂和水处理剂。\r\n主要成分：纯品\r\nCAS号：302-01-2\r\n相对分子质量：32.05\r\n化学类别：302-01-2\r\n燃烧性：易燃\r\n闪点：38\r\n引燃温度：270\r\n爆炸下限：2.9\r\n爆炸上限：98.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：氧化氮。\r\n急性毒性：LD50：60mg/kg(大鼠经口)；91mg/kg(兔经皮)\r\nLC50：746mg/m3，4小时(大鼠吸入)\r\n致癌性：IARC致癌性评论：动物为阳性反应。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、金属粉末、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具强腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入肼蒸气出现头痛、头晕、恶心、呕吐、腹泻、眼及上呼吸道刺激症状。吸入高浓度蒸气迅速发生中枢神经系统症状，先兴奋，如躁动不安、强直性抽搐，很快进入抑制状态。口服中毒引起频繁恶心、呕吐、腹泻，以后出现暂时性中枢性呼吸抑制、心律紊乱及中枢神经系统症状。可有肝?\n危险特性：易燃，强还原剂。其蒸气能与空气形成范围广阔的爆炸性混合物。遇明火、高热极易燃烧爆炸。受热分解放出有毒的氧化氮烟气。燃烧时发出高热，可能发生爆炸。在空气中遇尘土、石棉、木材等疏松性物质能自燃。遇过氧化氢或硝酸等氧化剂，也能自燃。与各种金属氧化物接触能自行分?\n', '强氧化剂、氧、铜。', '762', '脂肪胺', '2029', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (559, '110-66-7', '32117', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：高浓度环境中，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、碱金属、接触。灌\0', 'amyl mercaptan；1-pentanethiol', 'C5H12S', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '戊硫醇；1-戊硫醇', '外观与性状：无色到淡黄色液体，有特殊气味。\r\n熔点(℃)：-76\r\n相对密度(水=1)：0.86\r\n沸点(℃)：127\r\n相对密度(空气=1)：3.59\r\n饱和蒸气压(kPa)：1.84(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、乙醚、等\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：110-66-7\r\n相对分子质量：104.21\r\n化学类别：110-66-7\r\n燃烧性：易燃\r\n闪点：18(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、硫化氢、氧化硫。\r\n急性毒性：LD50：\r\nLC50：2500mg/m3(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、碱类、碱金属、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：因本品有恶臭味，吸入后可引起恶心。对眼和皮肤有轻度刺激性。口服引起恶心、呕吐。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热或遇酸易产生有毒的硫氧化物气体。\r\n', '碱、强氧化剂、碱金属。', '789', '醇', '1111', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (560, '110-62-3', '32069', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴过滤式防毒面具（半面罩）。\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂\0', 'pentanal；Valeraldehyde', 'C5H10O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。也可以用大量水冲洗，洗水稀释后放入废水系统\0', '戊醛；正戊醛', '外观与性状：无色液体。\r\n熔点(℃)：-91.1\r\n相对密度(水=1)：0.81\r\n沸点(℃)：103\r\n相对密度(空气=1)：2.96\r\n饱和蒸气压(kPa)：3.5(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用作香料、橡胶促进剂。\r\n主要成分：纯品\r\nCAS号：110-62-3\r\n相对分子质量：86.13\r\n化学类别：110-62-3\r\n燃烧性：易燃\r\n闪点：-8\r\n引燃温度：385\r\n爆炸下限：2.6\r\n爆炸上限：14.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3200mg/kg(大鼠经口)；4857mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、还原剂、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气对眼及上呼吸道粘膜有刺激作用。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、强还原剂、氧。', '773', '醛', '2058', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (561, '539-82-2', '33599', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）。必要时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'ethyl valerate', 'C7H14O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用不燃性分散剂制成的乳液刷洗，洗液\0', '戊酸乙酯', '外观与性状：无色油状液体，有果子香气。\r\n熔点(℃)：-91.0\r\n相对密度(水=1)：0.87\r\n沸点(℃)：145.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：297\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水。\r\n主要用途：用作香精。\r\n主要成分：纯品\r\nCAS号：539-82-2\r\n相对分子质量：130.19\r\n化学类别：539-82-2\r\n燃烧性：易燃\r\n闪点：38\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。对眼睛、皮肤、粘膜有刺激性。\r\n危险特性：易燃，遇高热、明火有引起燃烧的危险。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂、强酸。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (562, '591-68-4', '33599', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'butyl valerate', 'C9H18O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '戊酸丁酯', '外观与性状：无色液体, 有特殊气味。\r\n熔点(℃)：-92.8\r\n相对密度(水=1)：0.87(15℃)\r\n沸点(℃)：185.8\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作香料、溶剂，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：591-68-4\r\n相对分子质量：158.23\r\n化学类别：591-68-4\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：>35000mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：尚未见职业中毒报道。\r\n危险特性：易燃，遇高热、明火有引起燃烧的危险。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (563, '2173-56-0', '33599', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'amyl valerate', 'C10H20O2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '戊酸戊酯', '外观与性状：无色液体，有苹果香味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.86(19℃)\r\n沸点(℃)：191～194\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、可混溶于醇、醚。\r\n主要用途：用作香料、溶剂，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：2173-56-0\r\n相对分子质量：172.26\r\n化学类别：2173-56-0\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：>17000mg/kg(豚鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、碱类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：尚未见职业中毒报道。\r\n危险特性：易燃，遇高热、明火有引起燃烧的危险。与氧化剂能发生强烈反应。在火场中，受热的容器有爆炸危险。\r\n', '强氧化剂、强酸、强碱。', '749', '羧酸酯', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (564, '109-66-0', '31002', '监测方法：\r\n工程控制：生产过程密闭，全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：一般不需特殊防护。空气中浓度较高时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'n-pentane', 'C5H12', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用活性炭或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，\0', '戊烷；正戊烷', '外观与性状：无色液体，有微弱的薄荷香味。\r\n熔点(℃)：-129.8\r\n相对密度(水=1)：0.63\r\n沸点(℃)：36.1\r\n相对密度(空气=1)：2.48\r\n饱和蒸气压(kPa)：53.32(18.5℃)\r\n燃烧热(kJ/mol)：3506.1\r\n临界温度(℃)：196.4\r\n临界压力(MPa)：3.37\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、丙酮、苯、氯仿、等多数有机溶剂。\r\n主要用途：用作溶剂，制造人造冰、麻醉剂，合成戊醇、异戊烷等。\r\n主要成分：纯品\r\nCAS号：109-66-0\r\n相对分子质量：72.15\r\n化学类别：109-66-0\r\n燃烧性：易燃\r\n闪点：-40\r\n引燃温度：260\r\n爆炸下限：1.7\r\n爆炸上限：9.8\r\n最小点火能：0.51\r\n最大爆炸压力：0.813\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：446mg/kg(小鼠静脉)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：高浓度可引起眼与呼吸道粘膜轻度刺激症状和麻醉状态，甚至意识丧失。慢性作用为眼和呼吸道的轻度刺激。可引起轻度皮炎。\r\r\n危险特性：极易燃，其蒸气与空气可形成爆炸性混合物，遇明火、高热极易燃烧爆炸。与氧化剂接触发生强烈反应, 甚至引起燃烧。液体比水轻，不溶于水，可随水漂流扩散到远处，遇明火即引起燃烧。在火场中，受热的容器有爆炸危险。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会?\n', '强氧化剂。', '771', '烷烃', '1265', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (565, '107-11-9', '31048\r', '监测方法：\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其蒸气时，佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。尽可能减少直接接触。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸类、\0', 'allylamine；3-aminopropene', 'C3H7N', NULL, '迅速撤离泄漏污染区人员至安全区，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、干燥石灰或苏打灰混合。也可以用大量水冲\0', '烯丙胺；3-氨基丙烯', '外观与性状：无色液体，有强烈的氨味和焦灼味。\r\n熔点(℃)：-88.2\r\n相对密度(水=1)：0.76\r\n沸点(℃)：55.2\r\n相对密度(空气=1)：2.00\r\n饱和蒸气压(kPa)：26.39(20℃)\r\n燃烧热(kJ/mol)：2207.5\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、氯仿。\r\n主要用途：用于制造药品的中间体，及有机合成和制作溶剂等。\r\n主要成分：纯品\r\nCAS号：107-11-9\r\n相对分子质量：57.09\r\n化学类别：107-11-9\r\n燃烧性：易燃\r\n闪点：-29\r\n引燃温度：370\r\n爆炸下限：2.2\r\n爆炸上限：22.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：102mg/kg(大鼠经口)；35mg/kg(兔经皮)\r\nLC50：413mg/m3，8小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。应严格执行\0', '危险性类别：第3.1类  低闪点易燃液体\r\n危险性综述：本品极度易燃，高毒，具腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：蒸气对眼及上呼吸道有强刺激性，严重者伴有恶心、眩晕、头痛等。接触本品的生产工人可发生接触性皮炎。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。燃烧时，放出剧毒的氰化氢气体。在火场高温下，能发生聚合放热，使容器破裂。在酸性催化剂存在下能猛烈聚合爆炸。具有腐蚀性。\r\n', '酸类、酰基氯、酸酐、强氧化剂、二氧化碳。', '781', '丙烯酰基化合物', '2334', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (566, '106-95-6', '32045', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、\0', 'allyl bromide；3-bromopropene', 'C3H5Br', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散\0', '烯丙基溴；3-溴-1-丙烯', '外观与性状：无色到淡黄色液体，有令人不愉快的刺激性气味。\r\n熔点(℃)：-119.4\r\n相对密度(水=1)：1.40\r\n沸点(℃)：71.3\r\n相对密度(空气=1)：4.17\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、氯仿、四氯化碳、二硫化碳、等多数有机溶剂。\r\n主要用途：用于有机合成，树脂和香料中间体。\r\n主要成分：纯品\r\nCAS号：106-95-6\r\n相对分子质量：120.98\r\n化学类别：106-95-6\r\n燃烧性：易燃\r\n闪点：-1\r\n引燃温度：295\r\n爆炸下限：4.3\r\n爆炸上限：7.3\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：30mg/kg(豚鼠经口)\r\nLC50：1000mg/m3，1/2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。包装要求密封，不可与空气接触。应与氧化剂、碱类、分开存放，切忌混储。不宜久存，以免变质。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤、粘膜有刺激作用。可引起严重眼刺激。接触后可引起烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。随接触的浓度和时间的不同，其影响可由较轻刺激到严重的组织损伤。\r\n危险特性：易燃，遇明火、高热、或与氧化剂接触能燃烧, 并散发出有毒气体。受高热分解产生有毒的溴化物气体。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱。', '765', '卤代烯', '1099', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (567, '75-52-5', '33520', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿胶布防毒衣，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与\0', 'nitromethane', 'CH3NO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：用泡沫覆盖，降低蒸气灾害。构筑围堤\0', '硝基甲烷', '外观与性状：无色油状液体。\r\n熔点(℃)：-28.6\r\n相对密度(水=1)：1.14\r\n沸点(℃)：101.2\r\n相对密度(空气=1)：2.11\r\n饱和蒸气压(kPa)：3.71(20℃)\r\n燃烧热(kJ/mol)：708.1\r\n临界温度(℃)：315\r\n临界压力(MPa)：6.30\r\n辛醇/水分配系数：\r\n溶解性：溶于水、醇。\r\n主要用途：用作溶剂和汽油添加剂。\r\n主要成分：纯品\r\nCAS号：75-52-5\r\n相对分子质量：61.04\r\n化学类别：75-52-5\r\n燃烧性：易燃\r\n闪点：35\r\n引燃温度：415\r\n爆炸下限：7.1\r\n爆炸上限：63.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：1510mg/kg(大鼠经口)；1440mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品主要引起中枢神经系统损害，对肝、肾有损害。亦可引起高铁血红蛋白血症。急性中毒：吸入高浓度本品蒸气出现头晕、四肢无力、呼吸困难、紫绀、意识丧失、癫痫样抽搐。对呼吸道粘膜有轻度刺激作用。可发生肝、肾损害，继发肾病。血中高铁血红蛋白含量增高。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。强烈震动及受热或遇无机碱类、氧化剂、烃类、胺类及三氯化铝、六甲基苯等均能引起燃烧爆炸。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强还原剂、酸类、碱类、胺类。', '746', '硝基烷烃', '1261\r', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (568, '79-24-3', '33521', '监测方法：热解吸－气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'nitroethane', 'C2H5NO2', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降\0', '硝基乙烷', '外观与性状：无色液体, 有令人不愉快的气味。\r\n熔点(℃)：-90\r\n相对密度(水=1)：1.05\r\n沸点(℃)：114.0\r\n相对密度(空气=1)：2.58\r\n饱和蒸气压(kPa)：2.08(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、可混溶于乙醇、氯仿、乙醚。\r\n主要用途：用于有机合成, 用作硝化纤维素及其他树脂、蜡、脂肪、染料等的溶剂。\r\n主要成分：纯品\r\nCAS号：79-24-3\r\n相对分子质量：75.07\r\n化学类别：79-24-3\r\n燃烧性：易燃\r\n闪点：28\r\n引燃温度：414.5\r\n爆炸下限：3.4\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的不燃库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、酸类、碱类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：本品有麻醉作用，有轻度刺激性。未见职业中毒报道。\r\n危险特性：易燃，其蒸气与空气可形成爆炸性混合物。强烈震动及受热或遇无机碱类、氧化剂、烃类、胺类及三氯化铝、六甲基苯等均能引起燃烧爆炸。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '强氧化剂、强还原剂、强酸、强碱、胺类。', '746', '硝基烷烃', '2842', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (569, '625-58-1', '32154', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸\0', 'ethyl nitrate；nitric acid ethyl ester', 'C2H5NO3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。撒湿冰或冰水冷\0', '硝酸乙酯', '外观与性状：无色液体, 有令人愉快的气味和甜味。\r\n熔点(℃)：-112\r\n相对密度(水=1)：1.11\r\n沸点(℃)：88.7\r\n相对密度(空气=1)：3.14\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：主要用于药物、香料、染料的合成, 也可用作液体火箭推进剂。\r\n主要成分：纯品\r\nCAS号：625-58-1\r\n相对分子质量：91.07\r\n化学类别：625-58-1\r\n燃烧性：易燃\r\n闪点：10\r\n引燃温度：85\r\n爆炸下限：3.8\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\r\nLC50：\r\n致癌性：\r\n', '储存于有冷藏装置、通风良好、散热良好的不燃结构的库房内。远离火种、热源。应与氧化剂、还原剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入本品后可引起头痛、呕吐和麻醉。可引起高铁血红蛋白血症。\r\r\n危险特性：遇明火、高热极易燃烧爆炸。与还原剂能发生强烈反应。受热分解放出有毒的氧化氮烟气。\r\n', '还原剂、氧化剂。', '790', '硝酸', '1993', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (570, '627-13-4', '32155', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'propyl nitrate', 'C3H7NO3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '硝酸丙酯', '外观与性状：白色到淡黄色液体，有类似醚的气味。\r\n熔点(℃)：-100\r\n相对密度(水=1)：1.05\r\n沸点(℃)：110.5\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇。\r\n主要用途：用作火箭燃料，化学试剂等。\r\n主要成分：纯品\r\nCAS号：627-13-4\r\n相对分子质量：105.09\r\n化学类别：627-13-4\r\n燃烧性：易燃\r\n闪点：20\r\n引燃温度：175\r\n爆炸下限：2.0\r\n爆炸上限：100.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、潮湿空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：200mg/kg(兔静脉)\r\nLC50：38610mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与还原剂、酸类、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：具有刺激性；能引起高铁血红蛋白血症。吸入后出现头痛、恶心、低血压等。\r\n危险特性：易燃，具有强氧化性。遇明火、高热会引起燃烧爆炸。\r\n', '强还原剂、强酸、水。', '790', '硝酸', '1865', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (571, '1002-16-0', '33606', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。注意个人清洁卫生。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'amyl nitrate', 'C5H11NO3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆\0', '硝酸戊酯', '外观与性状：清亮无色至微黄色液体, 具有芳香气味。\r\n熔点(℃)：\r\n相对密度(水=1)：0.99(20℃)\r\n沸点(℃)：150～155\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作柴油燃料的改进剂、溶剂，也用于有机合成。\r\n主要成分：纯品\r\nCAS号：1002-16-0\r\n相对分子质量：133.15\r\n化学类别：1002-16-0\r\n燃烧性：易燃\r\n闪点：51.7\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、还原剂、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入、食入。\r\n健康危害：有报道人在接触本品后，仅见恶心和呕吐。未见本品引起职业中毒的报道。中毒死亡动物可见肝、肾、脑的弥漫性病变，肺充血和水肿。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。\r\n', '还原剂、氧化剂。', '790', '硝酸', '1112', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (572, '1712-64-7', '32155', '监测方法：\r\n工程控制：生产过程密闭，加强通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场严禁吸烟。工作完毕，淋浴更衣。特别注意眼和呼吸道的防护。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气\0', 'isopropyl nitrate', 'C3H7NO3', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土、蛭石或其它惰性材料吸收。大量泄漏：构筑围堤或挖坑收容。用泡沫覆盖，降\0', '硝酸异丙酯', '外观与性状：无色液体。\r\n熔点(℃)：\r\n相对密度(水=1)：1.04\r\n沸点(℃)：101～102\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用作溶剂, 用于有机合成。\r\n主要成分：纯品\r\nCAS号：1712-64-7\r\n相对分子质量：105.1\r\n化学类别：1712-64-7\r\n燃烧性：易燃\r\n闪点：12\r\n引燃温度：\r\n爆炸下限：2\r\n爆炸上限：100\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于通风、低温的库房内。远离火种、热源。保持容器密封。应与还原剂、酸类、活性金属粉末、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.2类  中闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收后对身体有害。本品对皮肤有刺激性。蒸气或雾对眼睛、粘膜和上呼吸道有刺激性。\r\n危险特性：易燃，具有强氧化性。遇明火、高热会引起燃烧爆炸。\r\n', '强还原剂、强酸、活性金属粉末。', '790', '硝酸', '1222', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (573, '124-13-0', '33575', '监测方法：\r\n工程控制：密闭操作，全面排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，全面排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿防静电工作服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免\0', 'octanal；caprylic aldehyde', 'C8H16O', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗\0', '辛醛；羊脂醛', '外观与性状：无色液体，有果子香气。\r\n熔点(℃)：\r\n相对密度(水=1)：0.82\r\n沸点(℃)：163.4\r\n相对密度(空气=1)：4.41\r\n饱和蒸气压(kPa)：2.67(72℃)\r\n燃烧热(kJ/mol)：\r\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于甘油。\r\n主要用途：用于制作香精、香料。\r\n主要成分：纯品\r\nCAS号：124-13-0\r\n相对分子质量：128.22\r\n化学类别：124-13-0\r\n燃烧性：易燃\r\n闪点：51\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：5630mg/kg(大鼠经口)；6350mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、还原剂、碱类、分开存放，切忌混储。不宜大量储存或久存。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第3.3类  高闪点易燃液体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道、眼和皮肤有刺激性。\r\n危险特性：易燃，遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。\r\n', '强氧化剂、强还原剂、强碱。', '773', '醛', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (574, '52-68-6', '61874', '监测方法：硫氰酸汞比色法；2,4-二硝基苯肼分光光度法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴头罩型电动送风过滤式防尘呼吸器。\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴氯丁橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿防毒物渗透工作服，戴氯丁橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。搬运\0', 'Dipterex；trichlorphon', 'C4H8Cl3O4P', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '敌百虫', '外观与性状：纯品为白色结晶，有醛类气味。\r\n熔点(℃)：83～84\r\n相对密度(水=1)：1.73\r\n沸点(℃)：100(13.33kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：13.33(100℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.48\r\n溶解性：溶于水、氯仿、不溶于汽油。\r\n主要用途：用作杀虫剂。\r\n主要成分：含量: 90.0％敌百虫原粉; 80.0％可溶性粉剂。\r\nCAS号：52-68-6\r\n相对分子质量：257.45\r\n化学类别：52-68-6\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢、氧化磷。\r\n急性毒性：LD50：400～900mg/kg(大鼠经口)；500mg/kg(兔经皮)\r\nLC50：\r\n致癌性：大鼠经口最低中毒剂量(TDL0)：186mg/kg/6周(间歇)，致癌，肝肿瘤、血液系统肿瘤。大鼠经皮最低中毒剂量(TDL0)：1950mg/kg/22周(间歇)，疑致肿瘤，肝肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：抑制胆碱酯酶，造成神经生理功能紊乱。出现毒蕈碱样和烟碱样症状。急性中毒：短期内接触大量引起急性中毒。表现有头痛、头昏、食欲减退、恶心、呕吐、腹痛、腹泻、流涎、瞳孔缩小、呼吸道分泌物增多、多汗、肌束震颤等。重者出现肺水肿、脑水肿、昏迷、呼吸中枢麻痹。部分病?\n危险特性：遇明火、高热可燃。受热分解，放出氧化磷和氯化物的毒性气体。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强碱。', '800', '未指定的化学类别', '2783', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (575, '60-57-1', '61127', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：生产操作或农业使用时，建议佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免与氧化剂、酸类、接触。搬运时要轻装轻卸，防止包装及\0', 'Dieldrin', 'C12H8Cl6O', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '狄氏剂；化合物-497', '外观与性状：工业品为褐色固体。\r\n熔点(℃)：175～176\r\n相对密度(水=1)：1.75\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于丙酮、苯、四氯化碳。\r\n主要用途：用作杀虫剂。\r\n主要成分：\r\nCAS号：60-57-1\r\n相对分子质量：380.91\r\n化学类别：60-57-1\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氯化氢。\r\n急性毒性：LD50：46mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物阳性，人类不明确。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品可经呼吸道、胃肠道及完整皮肤吸收入体。过量接触可引起头痛、眩晕、恶心、呕吐、乏力、以后出现肌肉抽搐、肌阵挛和搐搦，可出现昏迷，可有肾损害。吸入中毒者除上述症状外，还有咳嗽、呼吸困难、紫绀，甚至肺水肿。可致接触性皮炎。\r\n危险特性：遇明火、高热可燃。\r\n', '强氧化剂、强酸。', '800', '未指定的化学类别', '2761', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (576, '75-47-8', '61570', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，建议佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴防化学品手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿透气型防毒服，戴防化学品手套。避免产生粉尘。避免与氧化剂、碱类、碱金属、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理\0', 'iodoform；triiodomethane', 'CHI3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '三碘甲烷；碘仿', '外观与性状：黄色粉末或晶体，有不愉快的气味。\r\n熔点(℃)：123\r\n相对密度(水=1)：4.01\r\n沸点(℃)：218\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于苯、乙醚、丙酮。\r\n主要用途：用作防腐剂。\r\n主要成分：纯品\r\nCAS号：75-47-8\r\n相对分子质量：393.73\r\n化学类别：75-47-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、碘化氢。\r\n急性毒性：LD50：355mg/kg(大鼠经口)；1184mg/kg(兔经皮)\r\nLC50：2657mg/m3，7小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装密封。应与氧化剂、碱类、碱金属、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：对呼吸道有刺激性，吸入后出现咳嗽、呼吸困难、胸痛，重者发生肺水肿。高浓度接触可引起神经系统改变，出现精神错乱、兴奋、头痛、幻觉、共济失调等。对眼有刺激性。口服灼伤口腔和胃，出现中枢神经系统抑制及心、肝、肾损害。慢性影响：皮肤长期接触可致湿疹；有时引起全身?\n危险特性：不燃。与锂、钾钠合金接触剧烈反应。本品较不稳定，在空气与阳光照射下容易分解出游离碘能刺激眼睛和呼吸道，并灼伤皮肤。\r\n', '强氧化剂、强碱、碱金属、汞及其化合物。', '759', '卤代烷', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (577, '7774-29-0', '61030', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：作业工人应该佩戴头罩型电动送风过滤式防尘呼吸器。必要时，佩戴隔离式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设备。倒空的容器可能残\0', 'mercuric iodide', 'HgI2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '碘化汞；碘化高汞', '外观与性状：黄色结晶或粉末。\r\n熔点(℃)：259\r\n相对密度(水=1)：6.09\r\n沸点(℃)：354\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(157℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、酸、微溶于无水乙醇。\r\n主要用途：用于医药、化学试剂。\r\n主要成分：纯品\r\nCAS号：7774-29-0\r\n相对分子质量：454.40\r\n化学类别：7774-29-0\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：碘化氢、氧化汞。\r\n急性毒性：LD50：18mg/kg(大鼠经口)；75mg/kg(大鼠经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。避免光照。包装密封。应与氧化剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，高毒，具强刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：如吸入、口服或经皮肤吸收可致死。对眼睛、呼吸道粘膜和皮肤有强烈刺激性。汞及其化合物主要引起中枢神经系统损害及口腔炎，高浓度引起肾损害。\r\n危险特性：受热分解放出有毒的碘化物烟气。与三氟化氯、金属钾、金属钠剧烈反应。\r\n', '强氧化剂。', '797', '金属卤化物', '1638', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (578, '70-34-8', '61677', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：可能接触其蒸气时，必须佩戴自吸过滤式防毒面具（半面罩）；可能接触其粉尘时，建议佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱\0', '2,4-dinitro-1-fluorobenzene；1-fluoro-2,4-dinitrob', 'C6H3FN2O4', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '2,4-二硝基-1-氟苯；1-氟-2,4-二硝基苯', '外观与性状：黄色针状结晶, 液化后为澄黄色液体。\r\n熔点(℃)：27.5～30\r\n相对密度(水=1)：1.48\r\n沸点(℃)：178(3.33kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：2.67(137℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醚、苯、热乙醇。\r\n主要用途：用作蛋白质分析的试剂以及测定酚、吗啡及氨基酸、醛、肟的还原剂。\r\n主要成分：纯品\r\nCAS号：70-34-8\r\n相对分子质量：186.10\r\n化学类别：70-34-8\r\n燃烧性：可燃\r\n闪点：>110\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氟化氢。\r\n急性毒性：LD50：50mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品对眼和皮肤有刺激性。口服可致死亡。\r\n危险特性：遇明火能燃烧。受热分解, 放出有毒的氮氧化物和氟化物烟气。\r\n', '强氧化剂、强碱。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (579, '7790-30-9', '61023', '监测方法：石墨炉原子吸收光谱法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，必须佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。实行就业前和定期的体检。车间应配备急救设备及药品。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿连衣式胶布防毒衣，戴橡胶手套。避免产生粉尘。避免与氧化剂、接触。搬运时要轻装轻卸，防止包装及容器损坏。配备泄漏应急处理设\0', 'thallium iodide；thallous iodide', 'TlI', NULL, '隔离泄漏污染区，限制出入。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '碘化亚铊；碘化铊', '外观与性状：红色立方体结晶或黄色粉末。\r\n熔点(℃)：440\r\n相对密度(水=1)：8.00\r\n沸点(℃)：824\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、不溶于酸、溶于王水及浓硫酸。\r\n主要用途：用于制造药物、光谱分析、热定位的特种过滤器、与溴化铊组成混合结晶、传送极长波长的红外线辐射。\r\n主要成分：纯品\r\nCAS号：7790-30-9\r\n相对分子质量：331.27\r\n化学类别：7790-30-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：碘化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、食用化学品、分开存放，切忌混储。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品不燃，剧毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：铊及其化合物为强烈的神经毒，引起中枢神经系统损害及周围神经病，对肝、肾有损害。\r\n危险特性：受热分解放出有毒的碘化物烟气。\r\n', '强氧化剂、潮湿空气。', '797', '金属卤化物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (580, '110-61-2', '61630', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触毒物时，必须佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴隔离式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。车间应配备急救设备及药品。作业人员应学会自救互救。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统\0', 'butanedinitrile；1,2-dicyanoethane', 'C4H4N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '丁二腈；1,2-二氰基乙烷', '外观与性状：无色无臭的蜡状物。\r\n熔点(℃)：58.1\r\n相对密度(水=1)：1.02\r\n沸点(℃)：267\r\n相对密度(空气=1)：2.1\r\n饱和蒸气压(kPa)：0.27(100℃)\r\n燃烧热(kJ/mol)：2281.0\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、氯仿。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：110-61-2\r\n相对分子质量：80.09\r\n化学类别：110-61-2\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：950mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：本品动物实验小剂量引起中枢神经系统兴奋，大剂量引起抑制，致死剂量引起抽搐、窒息。在大鼠和兔体内本品约有60％转化为氰化物。\r\n危险特性：遇明火能燃烧。与氧化剂可发生反应。受高热或与酸接触会产生剧毒的氰化物气体。\r\n', '强氧化剂、强还原剂、强酸、强碱。', '743', '腈', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (581, '98-50-0', '61856', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤复式防尘口罩。紧急事态抢救或撤离时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤复式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧\0', 'arsanilic acid；atoxylic acid', 'C6H8NO3As', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物\0', '对氨基苯胂酸；对阿散酸', '外观与性状：白色、无气味晶状粉末。\r\n熔点(℃)：232\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于热水、微溶于冷水、乙醇、乙酸、不溶于丙酮、醚、苯、氯仿。\r\n主要用途：用于医药制造及用作测定铵、铈、锆的试剂。\r\n主要成分：纯品\r\nCAS号：98-50-0\r\n相对分子质量：217.06\r\n化学类别：98-50-0\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、氧化砷。\r\n急性毒性：LD50：220mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。具有刺激作用。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的砷和氧化氮烟雾。受高热或接触酸或酸雾放出剧毒的烟雾。\r\n', '强氧化剂。', '800', '未指定的化学类别', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (582, '10294-34-5', '22023', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（全面罩）紧急事态抢救或撤离时，建议佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿橡胶耐酸碱服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿橡胶耐酸碱服，戴橡胶手套。防止气体或蒸气泄漏到工作场所空气中。避免与氧化剂、碱类、醇类、碱金属、接触。尤其要注意避免与水接触。搬运时要轻装轻卸\0', 'boron trichloride；boron chloride', 'BCl3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防酸碱工作服。尽可能切断泄漏源。若是气体，合理通风，加速扩散。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器要妥善处理，修复、\0', '三氯化硼；氯化硼', '外观与性状：无色发烟液体或气体，有强烈臭味，易潮解。\r\n熔点(℃)：-107.3\r\n相对密度(水=1)：1.43\r\n沸点(℃)：12.5\r\n相对密度(空气=1)：4.03\r\n饱和蒸气压(kPa)：101.32(12.5℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、二硫化碳。\r\n主要用途：用作半导体硅的掺杂源或有机合成催化剂，还用于高纯硼或有机硼的制取。\r\n主要成分：纯品\r\nCAS号：10294-34-5\r\n相对分子质量：117.19\r\n化学类别：10294-34-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氧化硼。\r\n急性毒性：LD50：\r\nLC50：12171mg/m3，1小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过10℃。保持容器密封。应与氧化剂、碱类、醇类、碱金属、等分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，具强腐蚀性、强刺激性，可致人体灼伤。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。可引起化学灼伤。对眼睛、皮肤、粘膜和上呼吸道有强烈的腐蚀作用。吸入后可因喉、支气管的痉挛、水肿，化学性肺炎、肺水肿而致死。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐。慢性影响：具有神经毒性。\r\n危险特性：化学反应活性很高，遇水发生爆炸性分解。与铜及其合金有可能生成具有爆炸性的氯乙炔。遇潮气时对大多数金属有强腐蚀性，也能腐蚀玻璃等。在潮湿空气中可形成白色的腐蚀性浓厚烟雾。\r\n', '水、碱、醇类、碱金属、强氧化剂。', '776', '非金属卤化物', '1741', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (583, '106-50-3', '61789', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、\0', 'p-phenylenediamine；1,4-diaminobenzene', 'C6H8N2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '对苯二胺；1,4-二氨基苯', '外观与性状：白色至淡紫红色晶体。\r\n熔点(℃)：147\r\n相对密度(水=1)：\r\n沸点(℃)：267\r\n相对密度(空气=1)：3.7\r\n饱和蒸气压(kPa)：0.14(100℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇、乙醚、苯、氯仿。\r\n主要用途：作为染料中间体，环氧树脂固化剂，及橡胶防老剂DNP、DOP、DBP等的生产。\r\n主要成分：纯品\r\nCAS号：106-50-3\r\n相对分子质量：108.14\r\n化学类别：106-50-3\r\n燃烧性：可燃\r\n闪点：68\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：80mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物不明确。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具强致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：不易因吸入而中毒，口服毒性剧烈，与苯胺同。本品有很强的致敏作用，可引起接触性皮炎、湿疹、支气管哮喘。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、酸类、酰基氯、酸酐、氯仿。', '785', '芳香胺', '1673', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (584, '123-31-9', '61725', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能采取隔离操作。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。尽可能采取隔离操作。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉\0', 'p-dihydroxybenzene；p-hydroquinone', 'C6H6O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '对苯二酚；氢醌', '外观与性状：白色结晶。\r\n熔点(℃)：170.5\r\n相对密度(水=1)：1.33\r\n沸点(℃)：285\r\n相对密度(空气=1)：3.81\r\n饱和蒸气压(kPa)：0.13(132.4℃)\r\n燃烧热(kJ/mol)：2849.8\r\n临界温度(℃)：549.9\r\n临界压力(MPa)：7.45\r\n辛醇/水分配系数：0.59\r\n溶解性：溶于水、易溶于乙醇、乙醚。\r\n主要用途：制取黑白显影剂、蒽醌染料、偶氮染料、橡胶防老剂、稳定剂和抗氧剂。\r\n主要成分：纯品\r\nCAS号：123-31-9\r\n相对分子质量：110.11\r\n化学类别：123-31-9\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：499\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：光照、空气。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：320mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：IARC致癌性评论：动物不明确，人类无可靠数据。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装要求密封，不可与空气接触。应与氧化剂、酸类、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品毒性比酚大。成人误服1g，即可出现头痛、头晕、耳鸣、面色苍白、紫绀、恶心、呕吐、腹痛、窒息感、呼吸困难、心动过速、震颤、肌肉抽搐、惊厥、谵妄和虚脱。严重者可出现呕血、血尿和溶血性黄疸。尿呈青色或棕绿色。皮肤可因原发性刺激和变态反应而致皮炎，可引起皮肤色?\n危险特性：遇明火、高热可燃。与强氧化剂接触可发生化学反应。受高热分解放出有毒的气体。\r\n', '酰基氯、酸酐、碱、强氧化剂、强酸。', '742', '酚', '2662', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (585, '106-51-4', '61822', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、接触。搬运\0', 'p-quinone；1,4-benzoquinone', 'C6H4O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '对苯醌；1,4-苯醌', '外观与性状：金黄色棱柱状结晶，有刺激性气味。\r\n熔点(℃)：115.7\r\n相对密度(水=1)：1.32\r\n沸点(℃)：升华\r\n相对密度(空气=1)：3.73\r\n饱和蒸气压(kPa)：0.01(25℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：0.2(计算值)\r\n溶解性：溶于热水、乙醇、乙醚、碱液。\r\n主要用途：用作染料中间体，分析中用于测定氨基酸。\r\n主要成分：纯品\r\nCAS号：106-51-4\r\n相对分子质量：108.09\r\n化学类别：106-51-4\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：435\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：130mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。应严格执行极毒物品“五双”管理制度。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，高毒，具强刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品有强烈的刺激性。高浓度接触刺激粘膜、上呼吸道、眼睛和皮肤。眼接触其蒸气可引起结膜和角膜损害，表现为结膜色素沉着，角膜溃疡。皮肤接触局部有色素减退、红斑、肿胀、丘疹和水疱。长时间接触可引起坏死。口服可致死。\r\n危险特性：遇明火、高热可燃。受高热升华产生有毒气体。加热分解产生毒性气体。\r\n', '强氧化剂。', '800', '未指定的化学类别', '2587', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (586, '56-38-2', '61874', '监测方法：气相色谱法；盐酸萘乙二胺比色法\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：生产操作或农业使用时，佩戴自吸过滤式防毒面具（全面罩）。空气中浓度较高时，必须佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿连衣式胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。注意个人清洁卫生。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿连衣式胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到\0', 'Parathion；Folidol', 'C10H14NO5PS', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。不要直接接触泄漏物。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成\0', '对硫磷', '外观与性状：纯品为无色无臭的液体，工业品为棕色并有蒜臭的液体。\r\n熔点(℃)：6.0\r\n相对密度(水=1)：1.26\r\n沸点(℃)：157(0.08kPa)\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.08(157℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：作农药杀虫剂。\r\n主要成分：纯品\r\nCAS号：56-38-2\r\n相对分子质量：291.27\r\n化学类别：56-38-2\r\n燃烧性：可燃\r\n闪点：\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、氧化磷、氧化硫、氧化氮。\r\n急性毒性：LD50：6～15mg/kg(大鼠经口)；5～100mg/kg(兔经皮)\r\nLC50：31.5mg/m3，4小时(大鼠吸入)\r\n致癌性：大鼠经口最低中毒剂量(TDL0)：1260mg/kg/80周(连续)，疑致肿瘤，肾上腺皮质肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：抑制胆碱酯酶活性，造成神经生理功能紊乱。急性中毒：短期内接触(口服、吸入、皮肤、粘膜)大量引起急性中毒。表现有头痛、头昏、食欲减退、恶心、呕吐、腹痛、腹泻、流涎、瞳孔缩小、呼吸道分泌物增多、多汗、肌束震颤等。重者出现肺水肿、脑水肿、昏迷、呼吸麻痹。部分病例?\n危险特性：遇明火、高热可燃。受热分解，放出磷、硫的氧化物等毒性气体。\r\n', '强氧化剂、碱类。', '783', '硫化物', '2783', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (587, '15191-25-0', '61655', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿聚乙烯防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、\0', 'p-thiocyanatoaniline', 'C7H6N2S', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '对硫氰基苯胺；对硫氰酸苯胺', '外观与性状：针状结晶。\r\n熔点(℃)：57～58\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、易溶于乙醇、溶于乙醚、苯。\r\n主要用途：用作有机合成的重要原料, 还用作种子消毒剂硫化氰的配料。\r\n主要成分：纯品\r\nCAS号：15191-25-0\r\n相对分子质量：150.20\r\n化学类别：15191-25-0\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：228mg/kg(大鼠经口)；40mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品蒸气有恶臭，对眼睛和上呼吸道有刺激性。急性中毒是由于其解离产生的氰化物所致，后者抑制呼吸酶，造成组织缺氧。其水溶液可致角膜暂时性混浊。对皮肤有致敏性，引起小丘疹，发痒。\r\n危险特性：遇明火能燃烧。接触酸和酸雾产生剧毒气体。\r\n', '强氧化剂、酸类。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (588, '106-47-8', '61766', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴氧气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸\0', 'p-chloroaniline', 'C6H6ClN', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '对氯苯胺', '外观与性状：白色结晶或淡黄色固体。\r\n熔点(℃)：72.5\r\n相对密度(水=1)：1.43\r\n沸点(℃)：232\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(59.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.83\r\n溶解性：溶于热水、多数有机溶剂。\r\n主要用途：用作染料中间体、药品、农业化学品。\r\n主要成分：纯品\r\nCAS号：106-47-8\r\n相对分子质量：127.57\r\n化学类别：106-47-8\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮、氯化氢。\r\n急性毒性：LD50：310mg/kg(大鼠经口)；360mg/kg(兔经皮)\r\nLC50：\r\n致癌性：IARC致癌性评论：对人可能致癌。\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，为可疑致癌物，具刺激性，对环境有危害。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品为高铁血红蛋白形成剂。能经无损皮肤吸叫，对眼有刺激性。\r\n危险特性：遇明火、高热可燃。受高热分解，产生有毒的氮氧化物和氯化物气体。\r\n', '酸类、酸酐、酰基氯、氯仿、强氧化剂。', '785', '芳香胺', '2018', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (589, '98-54-4', '61701', '监测方法：\r\n工程控制：密闭操作，注意通风。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，注意通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、碱类、接触。\0', 'p-tert-butylphenol；4-tert-butylphenol', 'C10H14O', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：收集回收或运至废物处理场所处置。', '对叔丁苯酚；4-叔丁基苯酚', '外观与性状：白色针状结晶, 有轻微的苯酚臭味。\r\n熔点(℃)：98\r\n相对密度(水=1)：0.91(114℃)\r\n沸点(℃)：237\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于丙酮、甲醇、苯。\r\n主要用途：是生产对叔丁基酚甲醛树脂的重要原料, 也用于合成油溶性酚醛树脂、合成橡胶的增塑剂、油漆的添加剂, 医药上用于生产驱虫剂等。\r\n主要成分：纯品\r\nCAS号：98-54-4\r\n相对分子质量：150.21\r\n化学类别：98-54-4\r\n燃烧性：可燃\r\n闪点：97\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：3250mg/kg(大鼠经口)；2520mg/kg(兔经皮)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、碱类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性，具致敏性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼、皮肤、粘膜有刺激作用；对皮肤有致敏性。皮肤接触可引起皮炎。反复接触本品可引起白斑病，白斑除发生于手背、腕部等皮肤暴露部分外，亦可出现于非暴露部位皮肤，有时呈对称性。动物实验证实本品经口或经呼吸道染毒均可引起皮肤白斑。\r\n危险特性：遇明火、高热可燃。受高热分解, 放出刺激性烟气。与氧化剂能发生强烈反应。\r\n', '碱类、酰基氯、酸酐、氧化剂、铜。', '742', '酚', '2229', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (590, '100-01-6', '61777', '监测方法：气相色谱法；紫外分光光度法；高效液相色谱法\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸\0', 'p-nitroaniline；4-nitroaniline', 'C6H6N2O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。大量泄漏：用塑料布、帆布覆盖。然后收集回收或运至废物处理场所处置。', '对硝基苯胺；4-硝基苯胺', '外观与性状：黄色结晶或粉末。\r\n熔点(℃)：148.5\r\n相对密度(水=1)：1.42\r\n沸点(℃)：331.7\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.13(142.4℃)\r\n燃烧热(kJ/mol)：3181.0\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.39\r\n溶解性：不溶于水、微溶于苯、溶于乙醇、乙醚、丙酮、易溶于醇。\r\n主要用途：用作染料及抗氧剂的中间体，腐蚀抑制剂，分析试剂。\r\n主要成分：纯品\r\nCAS号：100-01-6\r\n相对分子质量：138.13\r\n化学类别：100-01-6\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：750mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，对环境有危害，对水体可造成污染。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品毒性比苯胺大。可通过皮肤和呼吸道吸收，是一种强烈的高铁血红蛋白形成剂。吸收后数小时内可出现紫绀。并有溶血作用，可发生溶血性贫血。长期大量接触可引起肝损害。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强酸、酰基氯、酸酐、氯仿。', '785', '芳香胺', '1661', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (591, '100-02-7', '61712', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：可能接触其粉尘时，佩戴头罩型电动送风过滤式防尘呼吸器。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴头罩型电动送风过滤式防尘呼吸器，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、碱类、接\0', 'p-nitrophenol', 'C6H5NO3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，用洁净的铲子收集于干燥、洁净、有盖的容器中。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：用塑料布、帆布覆盖。然后收集回收\0', '对硝基苯酚', '外观与性状：无色至淡黄色结晶粉末，有似苦杏仁的气味。\r\n熔点(℃)：113～114\r\n相对密度(水=1)：1.49\r\n沸点(℃)：279\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：0.92(16℃)\r\n燃烧热(kJ/mol)：2879.2\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：1.91\r\n溶解性：溶于热水、醇、醚。\r\n主要用途：用于染料制造，药物制造及用作试剂。\r\n主要成分：纯品\r\nCAS号：100-02-7\r\n相对分子质量：139.11\r\n化学类别：100-02-7\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：283\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：250mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品易燃，有毒，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对皮肤有强烈刺激作用。能经皮肤和呼吸道吸收。动物实验可引起高铁血红蛋白血症，体温升高，肝、肾损害。\r\n危险特性：遇明火、高热或与氧化剂接触，有引起燃烧爆炸的危险。受热分解放出有毒的氧化氮烟气。\r\n', '强氧化剂、强还原剂、强碱。', '742', '酚', '1663', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (592, '619-80-7', '61743', '监测方法：\r\n工程控制：密闭操作，局部排风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中粉尘浓度超标时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，彻底清洗。工作服不准带至非作业场所。单独存放被毒物污染的衣服，洗后备用。保持良好的卫生习惯。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、还原剂、碱类\0', 'p-nitrobenzamide', 'C7H6N2O3', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。不要直接接触泄漏物。小量泄漏：避免扬尘，小心扫起，置于袋中转移至安全场所。也可以用大量水冲洗，洗水稀释后放入废水系统。大量泄漏：收集回收或运至废物处理场所处置。', '对硝基苯甲酰胺', '外观与性状：针状结晶。\r\n熔点(℃)：201.4\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：619-80-7\r\n相对分子质量：166.14\r\n化学类别：619-80-7\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：476mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、还原剂、碱类、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。具有刺激性。\r\n危险特性：遇明火、高热可燃。受热分解放出有毒的氧化氮烟气。与强氧化剂接触可发生化学反应。\r\n', '强氧化剂、强碱、强还原剂。', '787', '硝基芳香化合物', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (593, NULL, '23011', '监测方法：盐酸萘乙二胺比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作完毕，淋浴更衣。注意个人清洁卫生。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿密闭型防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。防止气体或蒸气泄漏到工作\0', 'nitrogen trioxide；nitrous anhydride', 'N2O3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。漏气容器\0', '三氧化二氮；亚硝酐', '外观与性状：红棕色气体, 低温时为深蓝色液体或固体。\r\n熔点(℃)：-102\r\n相对密度(水=1)：1.45(0.27kPa)\r\n沸点(℃)：-10(分解)\r\n相对密度(空气=1)：1.45\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、甲苯、乙醚、氯仿、四氯化碳、酸、碱。\r\n主要用途：\r\n主要成分：纯品\r\nCAS号：\r\n相对分子质量：76.02\r\n化学类别：\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：不稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于通风、低温的库房内。远离火种、热源。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，有毒，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：氮氧化物主要损害呼吸道。吸入初期仅有轻微的眼及呼吸道刺激症状，如咽部不适、干咳等。常经数小时至十几小时或更长时间潜伏期后发生迟发性肺水肿、成人呼吸窘迫综合征，出现胸闷、呼吸窘迫、咳嗽、咯泡沫痰、紫绀等。可并发气胸及纵隔气肿。肺水肿消退后两周左右可出现迟发?\n危险特性：本品不燃烧, 但有强氧化性, 遇有机物可引起燃烧。若遇高热可发生剧烈分解，引起容器破裂或爆炸事故。\r\n', '易燃或可燃物、还原剂。', '748', '非金属氧化物', '2421', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (594, '99-52-5', '61779', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风。尽可能机械化、自动化。\r\n呼吸系统防护：空气中粉尘浓度超标时，佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，应该佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。及时换洗工作服。工作前后不饮酒，用温水洗澡。注意检测毒物。实行就业前和定期的体检。\r\n', '密闭操作，提供充分的局部排风。操作尽可能机械化、自动化。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免\0', 'p-nitro-o-toluidine；4-nitro-2-toluidine', 'C7H8N2O2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '对硝基邻甲苯胺；4-硝基-2-甲基苯胺', '外观与性状：黄色晶体。\r\n熔点(℃)：104\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于乙醇、乙醚。\r\n主要用途：用于棉麻纤维织物的染色和印花显色, 也可用于涂料的生产。\r\n主要成分：纯品\r\nCAS号：99-52-5\r\n相对分子质量：152.15\r\n化学类别：99-52-5\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入、口服或经皮肤吸收对身体有害。对眼睛、粘膜、上呼吸道和皮肤有刺激性。吸收进入体内致高铁血红蛋白血症，出现紫绀。\r\n危险特性：遇明火、高热可燃。燃烧分解时, 放出有毒的氮氧化物气体。\r\n', '酸类、酰基氯、酸酐、氯仿、水。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (595, '102-92-7', '61699', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：可能接触其蒸气时，应该佩戴自吸过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，佩戴空气呼吸器\r\n眼睛防护：高浓度接触时，戴化学安全防护眼镜。\r\n身体防护：穿透气型防毒服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿透气型防毒服，戴橡胶耐油手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。\0', 'p-bromoanisole；4-bromoanisole', 'C7H7BrO', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。防止进入下水道、排洪沟等限制性空间。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释\0', '对溴苯甲醚；4-溴苯甲醚', '外观与性状：无色或淡黄色液体。\r\n熔点(℃)：13～14\r\n相对密度(水=1)：1.46\r\n沸点(℃)：215\r\n相对密度(空气=1)：1.49\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、氯仿。\r\n主要用途：用作溶剂及用于有机合成。\r\n主要成分：纯品\r\nCAS号：102-92-7\r\n相对分子质量：187.04\r\n化学类别：102-92-7\r\n燃烧性：可燃\r\n闪点：94\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、溴化氢。\r\n急性毒性：LD50：3800mg/kg(大鼠经口)；2200mg/kg(小鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。保持容器密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：吸入其蒸气对呼吸道有刺激性，可出现兴奋、共济失调等症状。受高热分解产生有毒气体。\r\n危险特性：遇明火能燃烧。受高热分解放出有毒的气体。\r\n', '强氧化剂、强酸。', '770', '醚', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (596, '41931-18-4', '61817', '监测方法：\r\n工程控制：密闭操作，局部排风。\r\n呼吸系统防护：空气中粉尘浓度较高时，应该佩戴自吸过滤式防尘口罩。紧急事态抢救或撤离时，佩戴自给式呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防毒物渗透工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。单独存放被毒物污染的衣服，洗后备用。\r\n', '密闭操作，局部排风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防尘口罩，戴化学安全防护眼镜，穿防毒物渗透工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生粉尘。避免与氧化剂、酸类、接触。\0', 'p-bromophenylhydrazine；4-bromophenylhydrazine', 'C6H7BrN2', NULL, '隔离泄漏污染区，限制出入。切断火源。建议应急处理人员戴防尘面具（全面罩），穿防毒服。小量泄漏：小心扫起，置于袋中转移至安全场所。大量泄漏：收集回收或运至废物处理场所处置。', '对溴苯肼；4-溴苯肼', '外观与性状：白色针状结晶。\r\n熔点(℃)：106～107\r\n相对密度(水=1)：\r\n沸点(℃)：\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、氯仿、苯。\r\n主要用途：用于有机合成及糖类的检定。\r\n主要成分：纯品\r\nCAS号：41931-18-4\r\n相对分子质量：187.05\r\n化学类别：41931-18-4\r\n燃烧性：可燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氮氧化物、溴化氢。\r\n急性毒性：LD50：600mg/kg(大鼠经口)\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。包装密封。应与氧化剂、酸类、食用化学品、分开存放，切忌混储。配备相应品种和数量的消防器材。储区应备有合适的材料收容泄漏物。', '危险性类别：第6.1类  毒害品\r\n危险性综述：本品可燃，有毒，具刺激性。\r\n侵入途径：吸入、食入。\r\n健康危害：本品受高热分解放出有毒气体，对人体有刺激作用和毒性。\r\n危险特性：遇明火、高热可燃。受高热分解放出有毒的气体。\r\n', '强氧化剂、酸类。', '785', '芳香胺', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (597, '7446-09-5', '23013', '监测方法：盐酸副玫瑰苯胺比色法；甲醛缓冲液－盐酸副玫瑰苯胺分光光度法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴正压自给式呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿聚乙烯防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿聚乙烯防毒服，戴橡胶手套。远离易燃、可燃物。防止气体泄漏到工作场所空气中。避免与氧化剂、还原剂、接触。搬运时轻装轻卸，防止\0', 'sulfur dioxide', 'SO2', NULL, '迅速撤离泄漏污染区人员至上风处，并立即进行隔离，小泄漏时隔离150m，大泄漏时隔离450m，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。从上风处进入现场。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理\0', '二氧化硫；亚硫酸酐', '外观与性状：无色气体，特臭。\r\n熔点(℃)：-75.5\r\n相对密度(水=1)：1.43\r\n沸点(℃)：-10\r\n相对密度(空气=1)：2.26\r\n饱和蒸气压(kPa)：338.42(21.1℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：157.8\r\n临界压力(MPa)：7.87\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇。\r\n主要用途：用于制造硫酸和保险粉等。\r\n主要成分：含量: 工业级 一级≥99.9％;  二级≥99.0％。\r\nCAS号：7446-09-5\r\n相对分子质量：64.06\r\n化学类别：7446-09-5\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化硫。\r\n急性毒性：LD50：\r\nLC50：6600mg/m3，1小时(大鼠吸入)\r\n致癌性：小鼠吸入最低中毒浓度(TCL0)：500ppm/5分种/30周(间歇)，疑致肿瘤。\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与易燃物或可燃物、氧化剂、还原剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品不燃，有毒，具强刺激性，对大气可造成严重污染。\r\n侵入途径：吸入。\r\n健康危害：易被湿润的粘膜表面吸收生成亚硫酸、硫酸。对眼及呼吸道粘膜有强烈的刺激作用。大量吸入可引起肺水肿、喉水肿、声带痉挛而致窒息。急性中毒：轻度中毒时，发生流泪、畏光、咳嗽，咽、喉灼痛等；严重中毒可在数小时内发生肺水肿；极高浓度吸入可引起反射性声门痉挛而致窒息。?\n危险特性：不燃。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '强还原剂、强氧化剂、易燃或可燃物。', '748', '非金属氧化物', '1079', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (598, '10102-44-0', '23012', '监测方法：盐酸萘乙二胺比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。保持良好的卫生习惯。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。远离易燃、可燃物。防止气体或蒸气泄漏到工作场所空气中。避免与还原\0', 'nitrogen dioxide；dinitrogen tetroxide', 'NO2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。若是气体，合理通风，加速扩散。喷雾状水稀释、溶解。构筑围堤或挖坑收容产生的大量废水。漏气容器要妥善处理，修复、检验后再用。若是液体，\0', '二氧化氮；四氧化二氮', '外观与性状：黄褐色液体或气体，有刺激性气味。\r\n熔点(℃)：-9.3\r\n相对密度(水=1)：1.45\r\n沸点(℃)：22.4\r\n相对密度(空气=1)：3.2\r\n饱和蒸气压(kPa)：101.32(22℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：158\r\n临界压力(MPa)：10.13\r\n辛醇/水分配系数：\r\n溶解性：溶于水。\r\n主要用途：用于制硝酸、硝化剂、氧化剂、催化剂、丙烯酸酯聚合抑制剂等。\r\n主要成分：纯品\r\nCAS号：10102-44-0\r\n相对分子质量：46.01\r\n化学类别：10102-44-0\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮氧化物。\r\n急性毒性：LD50：\r\nLC50：126mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过15℃。应与易燃物或可燃物、还原剂、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，有毒，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：氮氧化物主要损害呼吸道。吸入气体初期仅有轻微的眼及上呼吸道刺激症状，如咽部不适、干咳等。常经数小时至十几小时或更长时间潜伏期后发生迟发性肺水肿、成人呼吸窘迫综合征，出现胸闷、呼吸窘迫、咳嗽、咯泡沫痰、紫绀等。可并发气胸及纵隔气肿。肺水肿消退后两周左右可出?\n危险特性：本品不会燃烧, 但可助燃。具有强氧化性。遇衣物、锯末、棉花或其它可燃物能立即燃烧。与一般燃料或火箭燃料以及氯代烃等猛烈反应引起爆炸。遇水有腐蚀性，腐蚀作用随水分含量增加而加剧。\r\n', '易燃或可燃物、强还原剂、硫、磷。', '748', '非金属氧化物', '1067', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (599, '76-14-2', '22046', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴安全防护眼镜。\r\n身体防护：穿化学防护服。\r\n手防护：戴橡胶耐油手套。\r\n其他防护：注意检测毒物。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴安全防护眼镜，穿化学防护服，戴橡胶耐油手套。防止气体泄漏到工作场所空气中。远离易燃、可燃物。搬运时戴好钢瓶安全帽和防震橡皮\0', 'dichlorotetrafluoroethane；tetrafluorodichloroetha', 'C2Cl2F4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿化学防护服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '二氯四氟乙烷；四氟二氯乙烷', '外观与性状：无色气体，有类似氯仿气味。\r\n熔点(℃)：-94\r\n相对密度(水=1)：1.53(0℃)\r\n沸点(℃)：3.8\r\n相对密度(空气=1)：5.9\r\n饱和蒸气压(kPa)：182(20℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：145.7\r\n临界压力(MPa)：3.29\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用作致冷剂、气溶胶喷射剂、发泡剂。\r\n主要成分：纯品\r\nCAS号：76-14-2\r\n相对分子质量：171.0\r\n化学类别：76-14-2\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氯化氢、氟化氢。\r\n急性毒性：LD50：\r\nLC50：4970～5330mg/m3， 30分钟(大鼠、小鼠、兔)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与易燃物或可燃物、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\r\n健康危害：未见急性中毒病例报道。但可引起皮肤冻伤。\r\n危险特性：受高热分解，放出有毒的氟化物和氯化物气体。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '易燃或可燃物。', '759', '卤代烷', '1958', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (600, '4109-96-0', '23042', '监测方法：\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：正常工作情况下，佩带过滤式防毒面具（全面罩）。高浓度环境中，必须佩戴氧气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿胶布防毒衣。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴导管式防毒面具，穿胶布防毒衣，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。避免产生烟雾。防止气体泄漏到工作场所空气中。避免与\0', 'dichlorosilane', 'H2Cl2Si', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相连的通风橱内。漏气容器要妥善处理，修复、检验后\0', '二氯硅烷', '外观与性状：无色气体。\r\n熔点(℃)：-122\r\n相对密度(水=1)：1.26\r\n沸点(℃)：8.3\r\n相对密度(空气=1)：3.59\r\n饱和蒸气压(kPa)：167.16(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：溶于苯、乙醚、等多数有机溶剂。\r\n主要用途：用于合成硅的有机化合物。\r\n主要成分：纯品\r\nCAS号：4109-96-0\r\n相对分子质量：101.01\r\n化学类别：4109-96-0\r\n燃烧性：易燃\r\n闪点：\r\n引燃温度：58\r\n爆炸下限：4.1\r\n爆炸上限：99.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：受热、潮湿空气。\r\n燃烧(分解)产物：氯化氢、氧化硅。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、干燥、通风良好的库房。远离火种、热源。包装必须密封，切勿受潮。钢瓶温度不应超过52℃。应与氧化剂、碱类、醇类、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，有毒，具腐蚀性、刺激性，可致人体灼伤。\r\n侵入途径：吸入。\r\n健康危害：对上下呼吸道、皮肤和眼睛有腐蚀性和刺激性。本品遇水或空气中的水份迅速水解形成氯化氢（盐酸）。盐酸可致皮肤灼伤和粘膜刺激。接触后表现有流泪、咳嗽、咳痰、呼吸困难、流涎等。可引起肺炎或肺水肿。眼接触可致灼伤，导致失明。\r\n危险特性：易燃，其蒸气能与空气形成范围广阔的爆炸性混合物。遇热源和明火有燃烧爆炸的危险。与卤素及其它氧化剂剧烈反应。遇水或水蒸气剧烈反应，生成盐酸烟雾。\r\n', '强碱、水、醇类、强氧化剂。', '757', '卤代硅烷', '2189', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (601, '75-71-8', '22045', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度超标时，应该佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿一般作业防护服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，防止气体泄漏到工作场所空气中。避免与氧化剂、碱金属、碱土金属、接触。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备\0', 'dichlorodifluoromethane；Freon-12', 'CCl2F2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。如有可能，即时使用。漏气容器要妥善处理，修复、检验后再用。', '二氯二氟甲烷；氟里昂-12', '外观与性状：无色无臭气体。\r\n熔点(℃)：-158\r\n相对密度(水=1)：1.46(-30℃)\r\n沸点(℃)：-29.8\r\n相对密度(空气=1)：4.2\r\n饱和蒸气压(kPa)：506.62(16.1℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：111.5\r\n临界压力(MPa)：4.01\r\n辛醇/水分配系数：2.16\r\n溶解性：不溶于水、溶于醇、醚。\r\n主要用途：用作致冷剂、气溶杀虫药发射剂。\r\n主要成分：含量≥99.0％。\r\nCAS号：75-71-8\r\n相对分子质量：120.92\r\n化学类别：75-71-8\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氟化氢、氯化氢。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、碱金属、碱土金属、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃，对环境有危害，对水体、土壤和大气可造成污染，对大气臭氧层有极强破坏力。\r\n侵入途径：吸入。\r\n健康危害：是一种对心脏毒作用强烈而又迅速的物质。能引起动物心律不齐、室性心动过速、心动过缓、房室传导阻滞、急性心力衰竭、血压降低等心血管系统的改变。国外有大量吸入引起致命性心律紊乱、虚脱、心动骤停而死亡的病例报道。\r\n危险特性：不燃。受高热分解，放出有毒的氟化物和氯化物气体。\r\n', '强氧化剂、碱金属、碱土金属、铝。', '759', '卤代烷', '1028', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (602, '124-40-3', '21044', '监测方法：二甲氨基二硫代甲酸铜比色法\r\n工程控制：生产过程密闭，加强通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，佩戴自吸过滤式防毒面具（全面罩）。紧急事态抢救或撤离时，建议佩戴氧气呼吸器或空气呼吸器\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。\r\n', '密闭操作，加强通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（全面罩），穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、酸类、卤素\0', 'dimethylamine', 'C2H7N', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '二甲胺(无水)', '外观与性状：无色气体，高浓度的带有氨味，低浓度的有烂鱼味。\r\n熔点(℃)：-92.2\r\n相对密度(水=1)：0.68\r\n沸点(℃)：6.9\r\n相对密度(空气=1)：1.55\r\n饱和蒸气压(kPa)：202.65(10℃)\r\n燃烧热(kJ/mol)：1741.8\r\n临界温度(℃)：164.5\r\n临界压力(MPa)：5.31\r\n辛醇/水分配系数：-0.38\r\n溶解性：易溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成及沉淀氢氧化锌等。\r\n主要成分：纯品\r\nCAS号：124-40-3\r\n相对分子质量：45.08\r\n化学类别：124-40-3\r\n燃烧性：易燃\r\n闪点：-17.8\r\n引燃温度：400\r\n爆炸下限：2.8\r\n爆炸上限：14.4\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳、氧化氮。\r\n急性毒性：LD50：\r\nLC50：8354mg/m3，6小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。保持容器密封。应与氧化剂、酸类、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具强刺激性。\r\n侵入途径：吸入、食入、经皮吸收。\r\n健康危害：本品对眼和呼吸道有强烈的刺激作用。皮肤接触液态二甲胺可引起坏死，眼睛接触可引起角膜损伤、混浊。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、酸类、卤素。', '762', '脂肪胺', '1032', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (603, '7783-41-7', '23014', '监测方法：离子选择性电极法；氟试剂－镧盐比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。\r\n呼吸系统防护：空气中浓度较高时，必须佩戴空气呼吸器、氧气呼吸器或长管面具\r\n眼睛防护：呼吸系统防护中已作防护。\r\n身体防护：穿密闭型防毒服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场严禁吸烟。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴空气呼吸器，穿密闭型防毒服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。防止气体或蒸气泄漏到工作场所空气中。远离易燃、可燃物。搬运时要轻装轻卸，防止包装\0', 'difluorine monoxide；oxygen difluoride', 'F2O', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离450m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防毒服。勿使泄漏物与可燃物质（如木材、纸、油等）接触。尽可能切断泄漏源。合理通风，加速扩散。如有可能，将残余气或漏出气用排风机送至水洗塔或与塔相\0', '二氟化氧；一氧化二氟', '外观与性状：无色、有轻微刺激的气体。\r\n熔点(℃)：-223.8\r\n相对密度(水=1)：1.90(-224℃,液体)\r\n沸点(℃)：-144.8\r\n相对密度(空气=1)：1.43\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-58\r\n临界压力(MPa)：0.50\r\n辛醇/水分配系数：\r\n溶解性：\r\n主要用途：用于氧化和氟化反应。\r\n主要成分：纯品\r\nCAS号：7783-41-7\r\n相对分子质量：54.00\r\n化学类别：7783-41-7\r\n燃烧性：助燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氟化氢。\r\n急性毒性：LD50：\r\nLC50：300mg/m3，1小时(大鼠吸入)；137mg/m3，1小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。防止受潮。应与易燃物或可燃物、食用化学品、分开存放，切忌混储。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品助燃，有毒，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：较高浓度接触本品一定时间，可发生迟发性刺激症状，表现有头痛、头昏、胸闷、恶心、咳嗽、气急等。严重者可导致肺水肿。皮肤接触一定压力下的高浓度本品可造成灼伤。\r\n危险特性：氧化性极强。受热分解产生有毒的烟气。与许多物质包括水蒸气和空气可产生剧烈反应，甚至发生爆炸。\r\n', '易燃或可燃物。', '776', '非金属卤化物', '2190', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (604, '106-97-8', '21012', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤\0', 'n-butane', 'C4H10', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '正丁烷', '外观与性状：无色气体，有轻微的不愉快气味。\r\n熔点(℃)：-138.4\r\n相对密度(水=1)：0.58\r\n沸点(℃)：-0.5\r\n相对密度(空气=1)：2.05\r\n饱和蒸气压(kPa)：106.39(0℃)\r\n燃烧热(kJ/mol)：2653\r\n临界温度(℃)：151.9\r\n临界压力(MPa)：3.79\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、醇、氯仿。\r\n主要用途：用于有机合成和乙烯制造，仪器校正，也用作燃料等。\r\n主要成分：纯品\r\nCAS号：106-97-8\r\n相对分子质量：58.12\r\n化学类别：106-97-8\r\n燃烧性：易燃\r\n闪点：-60\r\n引燃温度：287\r\n爆炸下限：1.5\r\n爆炸上限：8.5\r\n最小点火能：0.25\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：658000ppm，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不超过30℃，相对湿度不超过80％。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具窒息性。\r\n侵入途径：吸入。\r\n健康危害：高浓度有窒息和麻醉作用。急性中毒：主要症状有头晕、头痛、嗜睡和酒醉状态、严重者可昏迷。慢性影响：接触以丁烷为主的工人有头晕、头痛、睡眠不佳、疲倦等。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、卤素。', '771', '烷烃', '1011', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (605, '7727-37-9', '22005', '监测方法：\r\n工程控制：密闭操作。提供良好的自然通风条件。\r\n呼吸系统防护：一般不需特殊防护。当作业场所空气中氧气浓度低于18％时，必须佩戴空气呼吸器、氧气呼吸器或长管面具\r\n眼睛防护：一般不需特殊防护。\r\n身体防护：穿一般作业工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：避免高浓度吸入。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作。密闭操作，提供良好的自然通风条件。操作人员必须经过专门培训，严格遵守操作规程。防止气体泄漏到工作场所空气中。搬运时轻装轻卸，防止钢瓶及附件破损。配备泄漏应急处理设备。', 'nitrogen', 'N2', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。建议应急处理人员戴自给正压式呼吸器，穿一般作业工作服。尽可能切断泄漏源。合理通风，加速扩散。漏气容器要妥善处理，修复、检验后再用。', '氮；氮气', '外观与性状：无色无臭气体。\r\n熔点(℃)：-209.8\r\n相对密度(水=1)：0.81(-196℃)\r\n沸点(℃)：-195.6\r\n相对密度(空气=1)：0.97\r\n饱和蒸气压(kPa)：1026.42(-173℃)\r\n燃烧热(kJ/mol)：无意义\r\n临界温度(℃)：-147\r\n临界压力(MPa)：3.40\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、乙醇。\r\n主要用途：用于合成氨，制硝酸，用作物质保护剂，冷冻剂。\r\n主要成分：含量: 高纯氮≥99.999％; 工业级 一级≥99.5％; 二级≥98.5％。\r\nCAS号：7727-37-9\r\n相对分子质量：28.01\r\n化学类别：7727-37-9\r\n燃烧性：不燃\r\n闪点：无意义\r\n引燃温度：无意义\r\n爆炸下限：无意义\r\n爆炸上限：无意义\r\n最小点火能：无意义\r\n最大爆炸压力：无意义\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氮气。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。储区应备有泄漏应急处理设备。', '危险性类别：第2.2类  不燃气体\r\n危险性综述：本品不燃。\r\n侵入途径：吸入。\r\n健康危害：空气中氮气含量过高，使吸入气氧分压下降，引起缺氧窒息。吸入氮气浓度不太高时，患者最初感胸闷、气短、疲软无力；继而有烦躁不安、极度兴奋、乱跑、叫喊、神情恍惚、步态不稳，称之为“氮酩酊”，可进入昏睡或昏迷状态。吸入高浓度，患者可迅速昏迷、因呼吸和心跳停止而死?\n危险特性：若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', NULL, '779', '非金属单质', '1066', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (606, '74-98-6', '21011', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤素、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时轻装轻卸，防\0', 'propane', 'C3H8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '丙烷', '外观与性状：无色气体，纯品无臭。\r\n熔点(℃)：-187.6\r\n相对密度(水=1)：0.58(-44.5℃)\r\n沸点(℃)：-42.1\r\n相对密度(空气=1)：1.56\r\n饱和蒸气压(kPa)：53.32(-55.6℃)\r\n燃烧热(kJ/mol)：2217.8\r\n临界温度(℃)：96.8\r\n临界压力(MPa)：4.25\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：74-98-6\r\n相对分子质量：44.10\r\n化学类别：74-98-6\r\n燃烧性：易燃\r\n闪点：-104\r\n引燃温度：450\r\n爆炸下限：2.1\r\n爆炸上限：9.5\r\n最小点火能：0.31\r\n最大爆炸压力：0.843\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃。\r\n侵入途径：吸入。\r\n健康危害：本品有单纯性窒息及麻醉作用。人短暂接触 1％丙烷，不引起症状；10％以下的浓度，只引起轻度头晕；接触高浓度时可出现麻醉状态、意识丧失；极高浓度墒笨芍轮舷ⅰ*\r\n危险特性：易燃气体。与空气混合能形成爆炸性混合物，遇热源和明火有燃烧爆炸的危险。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、卤素。', '771', '烷烃', '1978', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (607, '115-07-1', '21018', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、酸类、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时轻装轻卸，防\0', 'propylene；propene', 'C3H6', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '丙烯', '外观与性状：无色、有烃类气味的气体。\r\n熔点(℃)：-191.2\r\n相对密度(水=1)：0.5\r\n沸点(℃)：-47.7\r\n相对密度(空气=1)：1.48\r\n饱和蒸气压(kPa)：602.88(0℃)\r\n燃烧热(kJ/mol)：2049\r\n临界温度(℃)：91.9\r\n临界压力(MPa)：4.62\r\n辛醇/水分配系数：\r\n溶解性：溶于水、乙醇。\r\n主要用途：用于制丙烯腈、环氧丙烷、丙酮等。\r\n主要成分：纯品\r\nCAS号：115-07-1\r\n相对分子质量：42.08\r\n化学类别：115-07-1\r\n燃烧性：易燃\r\n闪点：-108\r\n引燃温度：455\r\n爆炸下限：1.0\r\n爆炸上限：15.0\r\n最小点火能：0.282\r\n最大爆炸压力：0.843\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：本品为单纯窒息剂及轻度麻醉剂。急性中毒：人吸入丙烯可引起意识丧失，当浓度为15％时，需30分钟；24％时，需3分钟；35％～40％时，需20秒钟；40％以上时，仅需6秒钟，并引起呕吐。慢性影响：长期接触可引起头昏、乏力、全身不适、思维不集中。个别人胃肠道功能发生紊乱。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。与二氧化氮、四氧化二氮、氧化二氮等激烈化合，与其它氧化剂接触剧烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '780', '烯烃', '1077', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (608, '74-99-7', '21055', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：高浓度环境中，建议佩戴过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤素、接触。在传送过程中，\0', 'propyne；methyl acetylene', 'C3H4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释、溶解。构筑围\0', '丙炔；甲基乙炔', '外观与性状：无色气体。\r\n熔点(℃)：-102.6\r\n相对密度(水=1)：0.71(-50℃)\r\n沸点(℃)：-23.3\r\n相对密度(空气=1)：1.38\r\n饱和蒸气压(kPa)：516.76(20℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：129.2\r\n临界压力(MPa)：5.63\r\n辛醇/水分配系数：\r\n溶解性：微溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用于制造丙酮等。\r\n主要成分：纯品\r\nCAS号：74-99-7\r\n相对分子质量：40.06\r\n化学类别：74-99-7\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：1.7\r\n爆炸上限：\r\n最小点火能：0.152\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、卤素、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：急性吸入可刺激呼吸道，引起支气管炎及肺炎；并有麻醉作用。\r\n危险特性：与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、卤素。', '796', '炔烃', '1060', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (609, '463-49-0', '21021', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、碱\0', 'allene；dimethylene methane', 'C3H4', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释。构筑围堤或挖\0', '丙二烯', '外观与性状：无色气体, 略带甜味。\r\n熔点(℃)：-146\r\n相对密度(水=1)：1.79\r\n沸点(℃)：-34.5\r\n相对密度(空气=1)：1.42\r\n饱和蒸气压(kPa)：905.77(21℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于乙醇、易溶于乙醚。\r\n主要用途：作为活性中间体。\r\n主要成分：纯品\r\nCAS号：463-49-0\r\n相对分子质量：40.06\r\n化学类别：463-49-0\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：\r\n爆炸下限：2.1\r\n爆炸上限：13.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：不稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。应与氧化剂、碱类、重金属粉末、汞及其化合物、等分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：有单纯窒息、麻醉和刺激作用。吸入后引起头痛、头晕、倦睡、流涎、呕吐、神志不清。可因缺氧而窒息死亡。眼和皮肤接触液态本品，可致冻伤。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。是非常活泼的物质, 容易产生聚合。在200kPa大气压下可发生爆炸性分解。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强碱、铜、银、汞及其化合物。', '780', '烯烃', '2200', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (610, '7664-41-7', '23003', '监测方法：纳氏试剂比色法\r\n工程控制：严加密闭，提供充分的局部排风和全面通风。提供安全淋浴和洗眼设备。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴过滤式防毒面具（半面罩）。紧急事态抢救或撤离时，必须佩戴空气呼吸器\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴橡胶手套。\r\n其他防护：工作现场禁止吸烟、进食和饮水。工作完毕，淋浴更衣。保持良好的卫生习惯。\r\n', '严加密闭，提供充分的局部排风和全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，戴橡胶手套。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作\0', 'ammonia', 'NH3', NULL, '迅速撤离泄漏污染区人员至上风处，并立即隔离150m，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。合理通风，加速扩散。高浓度泄漏区，喷含盐酸的雾状水中和、稀释、溶解。构筑围堤或挖坑收容产生的大量废水。如有可能，\0', '氨；氨气(液氨)', '外观与性状：无色、有刺激性恶臭的气体。\r\n熔点(℃)：-77.7\r\n相对密度(水=1)：0.82(-79℃)\r\n沸点(℃)：-33.5\r\n相对密度(空气=1)：0.6\r\n饱和蒸气压(kPa)：506.62(4.7℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：132.5\r\n临界压力(MPa)：11.40\r\n辛醇/水分配系数：\r\n溶解性：易溶于水、乙醇、乙醚。\r\n主要用途：用作致冷剂及制取铵盐和氮肥。\r\n主要成分：纯品\r\nCAS号：7664-41-7\r\n相对分子质量：17.03\r\n化学类别：7664-41-7\r\n燃烧性：易燃\r\n闪点：无意义\r\n引燃温度：651\r\n爆炸下限：15.7\r\n爆炸上限：27.4\r\n最小点火能：\r\n最大爆炸压力：0.580\r\n稳定性：稳定\r\n聚合危害：不聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：氧化氮、氨。\r\n急性毒性：LD50：350mg/kg(大鼠经口)\r\nLC50：1390mg/m3，4小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、卤素、食用化学品、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.3类  有毒气体\r\n危险性综述：本品易燃，有毒，具刺激性，对环境有严重危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：低浓度氨对粘膜有刺激作用，高浓度可造成组织溶解坏死。急性中毒：轻度者出现流泪、咽痛、声音嘶哑、咳嗽、咯痰等；眼结膜、鼻粘膜、咽部充血、水肿；胸部 X线征象符合支气管炎或支气管周围炎。中度中毒上述症状加剧，出现呼吸困难、紫绀；胸部 X线征象符合肺炎或间质性肺炎?\n危险特性：与空气混合能形成爆炸性混合物。遇明火、高热能引起燃烧爆炸。与氟、氯等接触会发生剧烈的化学反应。若遇高热，容器内压增大，有开裂和爆炸的危险。\r\n', '卤素、酰基氯、酸类、氯仿、强氧化剂。', '744', '氨', '1005', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (611, '107-00-6', '21025', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、卤\0', '1-butyne；ethylacetylene', 'C4H6', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。合理通风，加速扩散。喷雾状水稀释。构筑围堤或挖坑收容产生的大量废水。如有可能，将漏出气用排风机送至空旷地方或装设适当\0', '1-丁炔；乙基乙炔', '外观与性状：无色、有恶臭的气体。\r\n熔点(℃)：-130.0\r\n相对密度(水=1)：0.67(0℃)\r\n沸点(℃)：8.1\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：190.5\r\n临界压力(MPa)：4.53\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于乙醇、乙醚、等多数有机溶剂。\r\n主要用途：用作有机合成的中间体及特殊燃料。\r\n主要成分：纯品\r\nCAS号：107-00-6\r\n相对分子质量：54.09\r\n化学类别：107-00-6\r\n燃烧性：易燃\r\n闪点：<-6.7(O.C)\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、卤素、氯代烃、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性。\r\n侵入途径：吸入。\r\n健康危害：有刺激和窒息作用。过量接触引起眩晕、定向障碍、头痛、兴奋、中枢神经系统抑制、麻醉作用。\r\n危险特性：与空气混合能形成爆炸性混合物。遇热、明火或强氧化剂有燃烧爆炸的危险。本品易聚合，只有经过稳定化处理才允许储运。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、卤素、氯代烃。', '796', '炔烃', '2452', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (612, '590-18-1', '21019', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，但建议特殊情况下，佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：一般不需要特殊防护，高浓度接触时可戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、酸类、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时轻装轻卸，防\0', '2-butylene；2-butene', 'C4H8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释。构筑围堤或挖\0', '2-丁烯(顺式)', '外观与性状：无色气体。\r\n熔点(℃)：-139\r\n相对密度(水=1)：0.63\r\n沸点(℃)：1.0\r\n相对密度(空气=1)：2.0\r\n饱和蒸气压(kPa)：141.65(10℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：160\r\n临界压力(MPa)：4.10\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、溶于多数有机溶剂。\r\n主要用途：用于制丁二烯及合成碳四、碳五的衍生物等。\r\n主要成分：纯品\r\nCAS号：590-18-1\r\n相对分子质量：56.11\r\n化学类别：590-18-1\r\n燃烧性：易燃\r\n闪点：-73\r\n引燃温度：324\r\n爆炸下限：1.6\r\n爆炸上限：9.7\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：420000mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：有轻度麻醉和刺激作用，并可引起窒息。急性中毒：出现粘膜刺激症状、嗜睡、血压稍升高、心率增快。高浓度吸入可引起窒息、昏迷。慢性影响：长期接触以丁烯为主的混合性气体，工人有头痛、头晕、嗜睡或失眠、易兴奋、易疲倦、全身乏力、记忆力减退。有时有粘膜慢性刺激症状。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。受热可能发生剧烈的聚合反应。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '780', '烯烃', '1012', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (613, '106-98-9', '21019', '监测方法：气相色谱法\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：一般不需要特殊防护，高浓度接触时可佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体泄漏到工作场所空气中。避免与氧化剂、酸类、接触。在传送过程中，钢瓶和容器必须接地和跨接，防止产生静电。搬运时轻装轻卸，防\0', '1-butylene', 'C4H8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释。构筑围堤或挖\0', '1-丁烯', '外观与性状：无色气体。\r\n熔点(℃)：-185.3\r\n相对密度(水=1)：0.67\r\n沸点(℃)：-6.3\r\n相对密度(空气=1)：1.93\r\n饱和蒸气压(kPa)：189.48(10℃)\r\n燃烧热(kJ/mol)：2538.8\r\n临界温度(℃)：146.4\r\n临界压力(MPa)：4.02\r\n辛醇/水分配系数：\r\n溶解性：不溶于水、微溶于苯、易溶于乙醇、乙醚。\r\n主要用途：用于制丁二烯、异戊二烯、合成橡胶等。\r\n主要成分：纯品\r\nCAS号：106-98-9\r\n相对分子质量：56.11\r\n化学类别：106-98-9\r\n燃烧性：易燃\r\n闪点：-80\r\n引燃温度：385\r\n爆炸下限：1.6\r\n爆炸上限：10.0\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热、光照。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：420000mg/m3，2小时(小鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入。\r\n健康危害：有轻度麻醉和刺激作用，并可引起窒息。急性中毒：出现粘膜刺激症状、嗜睡、血压稍升高、心率增快。高浓度吸入可引起窒息、昏迷。慢性影响：长期接触以丁烯为主的混合性气体，工人有头痛、头晕、嗜睡或失眠、易兴奋、易疲倦、全身乏力、记忆力减退。有时有粘膜慢性刺激症状。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。遇热源和明火有燃烧爆炸的危险。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。与氧化剂接触猛烈反应。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '780', '烯烃', '1012', NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (614, '591-93-5', '21023', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止气体或蒸气泄漏到工作场所空气中。避免与氧化\0', '1,4-pentadiene', 'C5H8', NULL, '迅速撤离泄漏污染区人员至上风处，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。尽可能切断泄漏源。若是气体，用工业覆盖层或吸附/ 吸收剂盖住泄漏点附近的下水道等地方，防止气体进入。合理通风，加速扩散。喷雾状水稀释。漏\0', '1,4-戊二烯', '外观与性状：无色液体或气体。\r\n熔点(℃)：-148\r\n相对密度(水=1)：0.66\r\n沸点(℃)：26\r\n相对密度(空气=1)：\r\n饱和蒸气压(kPa)：53.32(8.3℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：用于有机合成。\r\n主要成分：纯品\r\nCAS号：591-93-5\r\n相对分子质量：68.12\r\n化学类别：591-93-5\r\n燃烧性：易燃\r\n闪点：<4\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：吸入、口服后对身体有害，对皮肤有刺激作用。其蒸气或雾对眼睛、粘膜和上呼吸道有刺激作用。中毒表现有烧灼感、咳嗽、喘息、喉炎、气短、头痛、恶心和呕吐等。\r\n危险特性：其蒸气与空气可形成爆炸性混合物，遇明火、高热能引起燃烧爆炸。受热可能发生剧烈的聚合反应。其蒸气比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (615, '504-60-9', '21023', '监测方法：\r\n工程控制：生产过程密闭，全面通风。\r\n呼吸系统防护：空气中浓度较高时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免长期反复接触。进入罐、限制性空间或其它高浓度区作业，须有人监护。\r\n', '密闭操作，全面通风。操作人员必须经过专门培训，严格遵守操作规程。建议操作人员佩戴自吸过滤式防毒面具（半面罩），戴化学安全防护眼镜，穿防静电工作服，远离火种、热源，工作场所严禁吸烟。使用防爆型的通风系统和设备。防止蒸气泄漏到工作场所空气中。避免与氧化剂、酸\0', '1,3-pentadiene；1,3-piperlene', 'C5H8', NULL, '迅速撤离泄漏污染区人员至安全区，并进行隔离，严格限制出入。切断火源。建议应急处理人员戴自给正压式呼吸器，穿防静电工作服。从上风处进入现场。尽可能切断泄漏源。小量泄漏：用砂土或其它不燃材料吸附或吸收。也可以用不燃性分散剂制成的乳液刷洗，洗液稀释后放入废水系\0', '1,3-戊二烯；间戊二烯', '外观与性状：无色液体。\r\n熔点(℃)：-92.7(工业纯)\r\n相对密度(水=1)：0.68\r\n沸点(℃)：42.3\r\n相对密度(空气=1)：2.4\r\n饱和蒸气压(kPa)：53.32(24.7℃)\r\n燃烧热(kJ/mol)：\r\n临界温度(℃)：\r\n临界压力(MPa)：\r\n辛醇/水分配系数：\r\n溶解性：不溶于水。\r\n主要用途：主要的工业用途是生产石油树脂。\r\n主要成分：纯品\r\nCAS号：504-60-9\r\n相对分子质量：68.12\r\n化学类别：504-60-9\r\n燃烧性：易燃\r\n闪点：-29\r\n引燃温度：\r\n爆炸下限：\r\n爆炸上限：\r\n最小点火能：\r\n最大爆炸压力：\r\n稳定性：稳定\r\n聚合危害：聚合\r\n避免接触的条件：受热。\r\n燃烧(分解)产物：一氧化碳、二氧化碳。\r\n急性毒性：LD50：\r\nLC50：140000mg/m3，2小时(大鼠吸入)\r\n致癌性：\r\n', '储存于阴凉、通风的库房。远离火种、热源。库温不宜超过30℃。应与氧化剂、酸类、分开存放，切忌混储。采用防爆型照明、通风设施。禁止使用易产生火花的机械设备和工具。储区应备有泄漏应急处理设备和合适的收容材料。', '危险性类别：第2.1类  易燃气体\r\n危险性综述：本品极度易燃，具刺激性，对环境有危害，对水体、土壤和大气可造成污染。\r\n侵入途径：吸入、食入。\r\n健康危害：对眼睛、皮肤、粘膜和呼吸道有刺激作用。\r\n危险特性：易燃，与空气混合能形成爆炸性混合物。接触热、火星、火焰或氧化剂易燃烧爆炸。若遇高热，可发生聚合反应，放出大量热量而引起容器破裂和爆炸事故。气体比空气重，能在较低处扩散到相当远的地方，遇火源会着火回燃。\r\n', '强氧化剂、强酸。', '780', '烯烃', NULL, NULL, NULL, NULL, NULL, NULL, b'0');
INSERT INTO `cb_fire_chemical` VALUES (616, '75-38-7', '21031', '监测方法：\r\n工程控制：生产过程密闭化。提供良好的自然通风条件。\r\n呼吸系统防护：空气中浓度超标时，建议佩戴自吸过滤式防毒面具（半面罩）\r\n眼睛防护：必要时，戴化学安全防护眼镜。\r\n身体防护：穿防静电工作服。\r\n手防护：戴一般作业防护手套。\r\n其他防护：工作现场严禁吸烟。避免高浓度吸入。\r\n', '生产过程密闭化。密闭操作，提供良好的自然通风条件。操作