package com.yeejoin.amos.boot.module.ymt.flc.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.UnitInfoApproveDto;
import com.yeejoin.amos.boot.module.ymt.flc.biz.service.impl.UnitInfoApproveServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 企业信息审批意见表
 *
 * @author system_generator
 * @date 2021-11-11
 */
@RestController
@Api(tags = "企业信息审批意见表Api")
@RequestMapping(value = "/flc-unit-info-approve")
public class UnitInfoApproveController extends BaseController {

    @Autowired
    UnitInfoApproveServiceImpl unitInfoApproveServiceImpl;

    /**
     * 新增企业信息审批意见表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增企业信息审批意见表", notes = "新增企业信息审批意见表")
    public ResponseModel<UnitInfoApproveDto> save(@RequestBody UnitInfoApproveDto model) {
        model = unitInfoApproveServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新企业信息审批意见表", notes = "根据sequenceNbr更新企业信息审批意见表")
    public ResponseModel<UnitInfoApproveDto> updateBySequenceNbrFlcUnitInfoApprove(@RequestBody UnitInfoApproveDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(unitInfoApproveServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个企业信息审批意见表", notes = "根据sequenceNbr查询单个企业信息审批意见表")
    public ResponseModel<UnitInfoApproveDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(unitInfoApproveServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "企业信息审批意见表分页查询", notes = "企业信息审批意见表分页查询")
    public ResponseModel<Page<UnitInfoApproveDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<UnitInfoApproveDto> page = new Page<UnitInfoApproveDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(unitInfoApproveServiceImpl.queryForFlcUnitInfoApprovePage(page));
    }



}
