package com.yeejoin.amos.boot.module.common.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.dto.*;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersPost;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 机构/部门/人员表 服务类
 *
 * @author tb
 * @date 2021-06-18
 */
public interface IOrgUsrService {
    /**
     * 查询上级单位
     *
     * @param parent_id
     * @return
     */
    String selectUpUnitByParam(String parent_id);

    /**
     * 获取父级
     *
     * @param topId
     * @param entityList
     * @param packageURL
     * @param IDMethodName
     * @param IDHierarchy
     * @param NAMEMethodName
     * @param PARENTIDMethodName
     * @param OrgTypeMethodName
     * @return
     * @throws Exception
     */
    List<OrgMenuDto> getTree(Long topId, Collection<MaintenanceCompany> entityList, String packageURL, String IDMethodName, int IDHierarchy,
                             String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

    List<OrgMenuDto> getCompanyTree(Long topId, Collection<Object> entityList, String packageURL, String IDMethodName, int IDHierarchy,
                             String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName, String OrgCodeMethodName) throws Exception;

    /**
     * 获取子数据集合
     *
     * @param topId
     * @param entityList
     * @param packageURL
     * @param IDMethodName
     * @param IDHierarchy
     * @param NAMEMethodName
     * @param PARENTIDMethodName
     * @param OrgTypeMethodName
     * @return
     * @throws Exception
     */
    List<OrgMenuDto> getSub(Long topId, Collection<Object> entityList, String packageURL, String IDMethodName, int IDHierarchy,
                            String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;

    List<OrgMenuDto> getCompanySub(Long topId, Collection<Object> entityList, String packageURL, String IDMethodName, int IDHierarchy,
                            String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName, String OrgCodeMethodName) throws Exception;

    /**
     * 组装融合调度单位人员信息
     *
     * @param ids
     * @return
     * @throws Exception
     */
    List<Map<String, Object>> returnCompanyPersonMsg(List<Long> ids) throws Exception;

    /**
     * 获取动态表单数据
     *
     * @param id
     * @return
     * @throws Exception
     */
    List<FormValue> getFormValue(Long id) throws Exception;

    /**
     * 保存 机构/部门/人员基本信息
     *
     * @param
     * @throws Exception
     */
    void saveOrgUsr(OrgUsr orgUsr, OrgUsr oriOrgUsr) throws Exception;

    /**
     * 新增机构/部门/人员基本信息和动态表单数据
     *
     * @param orgUsr
     * @param alertFromValuelist
     */
    OrgUsrDto saveOrgUsrDynamicFormInstance(OrgUsr orgUsr, List<DynamicFormInstance> alertFromValuelist) throws Exception;

    /**
     * 更新机构/部门/人员基本信息和动态表单数据
     *
     * @param instanceId    实例id
     * @param fromValueList 动态表单数据列表
     * @throws Exception
     */
    void updateDynamicFormInstance(Long instanceId, List<DynamicFormInstance> fromValueList) throws Exception;

    /**
     * @param id
     * @throws Exception
     */
    Map<String, Object> selectForShowById(OrgUsr orgUsr, Long id) throws Exception;

    Map<String, Object> selectForShowByIduser(OrgUsr orgUsr, Long id) throws Exception;


    List<OrgUsr> selectCompanyDepartmentMsg();

    OrgUsrDto saveOrgUsr(OrgUsrDto OrgUsrDto) throws Exception;

    OrgUsrDto saveOrgPerson(OrgPersonDto OrgPersonDto) throws Exception;

    OrgUsrDto updateByIdOrgUsr(OrgUsrDto OrgUsrDto, Long id) throws Exception;

    OrgPersonDto updateByIdOrgPerson(OrgPersonDto OrgPersonDto, Long id) throws Exception;

    OrgUsrFormDto selectCompanyById(Long id) throws Exception;

    IPage<OrgUsr> bizOrgTypeListPage(String pageNum, String pageSize, String bizOrgType) throws Exception;

    void saveDepartment(List<OrgDepartmentDto> OrgDepartmentDto, Long id) throws Exception;

    void saveCompany(List<OrgUsrDto> OrgUsrDto) throws Exception;

    OrgPersonFormDto selectPersonById(Long id) throws Exception;

    OrgPersonFormDto selectPersonByIdDetail(Long id) throws Exception;

    List<OrgMenuDto> selectPersonTree() throws Exception;

    void savePersonList(List<OrgPersonDto> OrgPersonDto) throws Exception;

    OrgUsrDto saveOrgDepartment(OrgDepartmentDto OrgDepartmentDto) throws Exception;

    OrgDepartmentDto updateByIdOrgDepartment(OrgDepartmentDto OrgDepartmentDto, Long id) throws Exception;

    OrgDepartmentFormDto selectDepartmentById(Long id) throws Exception;

    List<Map<String, Object>> selectForShowByListId(List<Long> ids) throws Exception;

    List<Map<String, Object>> selectForShowByListIdUser(List<Long> ids) throws Exception;

    /**
     * * @param null
     *
     * @return <PRE>
     * author tw
     * date 2021/7/20
     * </PRE>
     * <p>
     * 列表
     */
    List<CompanyDto> listContractDto(Integer pageNum, Integer pageSize, RequestData requestData);

    /**
     * * @param null
     *
     * @return <PRE>
     * author tw
     * date 2021/7/20
     * </PRE>
     * <p>
     * 统计
     */
    Integer listContractDtoCount(RequestData par);

    /**
     * * @param null
     *
     * @return <PRE>
     * author tw
     * date 2021/7/26
     * </PRE>
     */

    List<OrgUsrzhDto> getOrgUsrzhDto(String name);

    List<ESOrgUsrDto> selectByIddata(String name);

    List<Map<String, Object>> getparent();

    List<OrgUsrExcelDto> exportToExcel(Map<String,Object> par);

    UserUnitDto getUserUnit(String userId);

    List<UserDto> getUserInfo(String userId);

    /**
     * 根据登陆人获取公司部门人员树
     */
    List<OrgMenuDto> companyUserTreeByUser(AgencyUserModel user);

    /**
     * 根据登陆人获取公司部门树
     */
    List<OrgMenuDto> companyTreeByUser(AgencyUserModel user);


    /**
     * 根据登录人及类型获取公司部门树
     * @param reginParams 公司及部门信息
     * @param type  默认查询公司及部门，公司：COMPANY，部门：DEPARTMENT
     * @return
     */
    List<OrgMenuDto> companyTreeByUserAndType(ReginParams reginParams, String type, String station);

    /**
     * 获取公司部门树全量
     * @param type  默认查询公司及部门，公司：COMPANY，部门：DEPARTMENT
     * @return
     */
    List<OrgMenuDto> companyTreeAll(String type);


   List<OrgUsr> companyTreeByUserAndTypeNoTree(ReginParams reginParams, String type) ;

    /**
     * 根据登陆人获取公司列表(关联重点部位)
     */
    List<CheckObjectDto> companyListByUser(AgencyUserModel user,String bizOrgCode);

    /**
     * 获取登陆人关联机场单位人员信息，部门信息
     */
    List<Map<String, Object>> getLoginUserDetails(String userId, AgencyUserModel user);

    List<OrgUsr> getPersonListByParentId(Long id);

    /**
     * 根据parentId 导出机场单位人员    bug2657 by kongfm
     *
     * @param parentId
     * @return
     */
    List<OrgUsrExcelDto> exportPersonToExcelByParentId(Long parentId);

    /**
     * 根据机场人员id获取amos账号信息
     *
     * @param orgUserId
     * @return
     * @throws
     */
    AgencyUserModel getAmosIdByOrgUserId(String orgUserId) throws Exception;

    /**
     * 根据机场人员id(逗号分割)获取amos账号信息列表
     *
     * @param orgUserIds
     * @return
     * @throws
     */
    List<String> getAmosIdListByOrgUserId(String orgUserIds) throws Exception;

    /**
     * 查询目标公司下所有人员的简要信息，数据包含：所在公司id和name ,人员id和name,岗位id和name
     *
     * @param ids
     * @return
     */
    List<Map<String, Object>> getPersonDetailByCompanyIds(List<String> ids);


    List<OrgUsr> selectCompanyUsers(Long orgUnitId);


    OrgUsr selectByAmosOrgId(Long id);


    List<OrgUsr> getPersonListByParentIds(List<String> ids);

    List<OrgUsrFormDto> getUnSyncOrgCompanyList(List<Long> companyIdList);

    OrgUsr getDetailById(Long id);


    /**
     * 获取父级
     *
     * @param topId
     * @param entityList
     * @param packageURL
     * @param IDMethodName
     * @param IDHierarchy
     * @param NAMEMethodName
     * @param PARENTIDMethodName
     * @param OrgTypeMethodName
     * @return
     * @throws Exception
     */
    List<OrgMenuDto> getTreeFlc(Long topId, Collection<Object> entityList, String packageURL, String IDMethodName, int IDHierarchy,
                                String NAMEMethodName, String PARENTIDMethodName, String OrgTypeMethodName) throws Exception;


    OrgUsrDto saveOrgPersonFlc(OrgPersonDto OrgPersonDto) throws Exception;

    void updateByIdOrgPersonFlc(OrgPersonDto OrgPersonVo, Long id) throws Exception;

    JSONObject selectPersonByUserId(Long userId) throws Exception;

    UserDto getUserParentInfo(String userId);

    UserDto selectByIdUser( String userId);

    List<OrgUsr> getListById(List<String> ids);
    /**
     * 根据机构类型获取列表不分页
     * @param orgTypes 机构类型（逗号分割）
     * @param orgCode 机构编码
     * @return list不分页
     */
    List<OrgUsr> getListByBizOrgTypeCode(String orgTypes, String orgCode);

    /**
     *  公司部门树，包含用户数量统计
     * @param reginParams 用户信息
     * @return List<OrgMenuDto>
     */
    List<OrgMenuDto> companyTreeByUserNumber(ReginParams reginParams);

    List<OrgMenuDto> companyTreeByUser(ReginParams reginParams);
    /**
     * 人员新增同步新增消防人员
     * @param peopleInfoDto 基本信息
     * @return PeopleInfoDto
     */
    PeopleInfoDto peopleSave(PeopleInfoDto peopleInfoDto);

    /**
     * 获取人员详情
     * @param id 人员id
     * @return 人员
     */
    PeopleInfoDto selectPeopleById(Long id);

    /**
     * 根据id，type删除
     * @param id 主键
     * @param type 类型
     */
    String deletePeopleById(Long id, String type, AgencyUserModel user);

    /**
     * 查询身份证号码是否重复
     * @param certificatesNumber 身份证号码
     * @param orgUserId
     * @return 标识
     */
    boolean checkCertificatesNumber(String certificatesNumber, Long orgUserId);

    /**
     * 根据id删除消防人员
     * @param id
     * @return
     */
    String deleteFirefighterPeopleById(Long id, String type);
    
     OrgUsr selectParentOrgUsr(OrgUsr orgUsr);

    List<OrgMenuDto> companyUserTreeByUserAndType(ReginParams reginParams);
    List<OrgMenuDto> companyUserTreeByUserAndTypeAll(String bizorgcode);

    List<DynamicFormInstance> selectTelById(List<String> ids, String type);

    List<FirefightersPost> selectPostById(List<String> ids);

}
