package com.yeejoin.amos.patrol.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.patrol.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.dao.entity.PointInputItem;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.patrol.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.business.vo.InputItemVo;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import org.springframework.stereotype.Repository;

@Repository
public interface InputItemMapper extends BaseMapper {
    public void updateInputItem(InputItem item);

    public List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

    public long countInputItemInfoData(InputItemPageParam param);

    public List<InputItemVo> getInputItemInfo(InputItemPageParam param);

    public List<InputItemVo> getInputItemListByNames(@Param("itemNames") String[] items, @Param("orgCode") String orgCode);

    public List<PointInputItemVo> queryCustomInputItem( HashMap<String, Object> param );

    public List<InputItemVo> getInputItemListByitemNos(@Param("itemNos") String[] itemNos);

    public List<PointInputItemVo> queryCustomInputItemByPointId(@Param("pointId") Long pointId, @Param("equipmentId") String equipmentName );

    public PointInputItemVo getInputItemByEquipmentName(@Param("equipmentName") String equipmentName );
}
