package com.yeejoin.amos.boot.module.jyjc.biz.service.impl.handler;

import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationHandlerService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author yangyang
 * @version v1.0
 * @date 2023/11/8 15:10
 */
@Service
public class JyjcInspectionApplicationHandlerFactory implements ApplicationContextAware {

    private static final Map<String, IJyjcInspectionApplicationHandlerService> SERVICE_POOL = new HashMap<>(12);

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationContext.getBeansOfType(IJyjcInspectionApplicationHandlerService.class).forEach((beanName, bean) -> SERVICE_POOL.put(bean.type(), bean));
    }

    public static IJyjcInspectionApplicationHandlerService apply(String type) {
        IJyjcInspectionApplicationHandlerService objectSceneService = SERVICE_POOL.get(type);
        if (Objects.isNull(objectSceneService)) {
            throw new IllegalArgumentException("SERVICE_POOL type: " + type + " is not found !");
        }
        return objectSceneService;
    }
}
