package com.yeejoin.amos.patrol.business.util;

import com.yeejoin.amos.patrol.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.core.enums.QueryOperatorEnum;

import java.text.SimpleDateFormat;
import java.util.List;

public class CheckParamUtil {

	public static CheckRecordParam checkCalendar(List<DaoCriteria> daoCriterias){
		CheckRecordParam param = new CheckRecordParam();
		for(int i=0;i<daoCriterias.size();i++){
			DaoCriteria daoCriteria = daoCriterias.get(i);
			String operator = daoCriteria.getOperator();
			String name = daoCriteria.getPropertyName();
			if("checkTime".equals(name)){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
				param.setCheckTime(daoCriterias.get(i).getValue().toString());
			}else if("userId".equals(name)){
				param.setUserId(daoCriterias.get(i).getValue().toString());
			}else if("routeId".equals(name)){
				param.setRouteId(Long.valueOf(daoCriterias.get(i).getValue().toString()));
			}else if("orgCode".equals(name) && operator.equals(QueryOperatorEnum.EQUAL.getName())){
				param.setOrgCode(daoCriterias.get(i).getValue().toString()+"%");
			}else if("bizOrgCode".equals(name)){
				param.setOrgCode(daoCriterias.get(i).getValue().toString());
			}
		}		
		return param;
		
	}
}
