package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
/**
* 警情接警记录
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertCalledDto", description="警情接警记录")
public class AlertCalledDto extends BaseDto{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "警情状态")
    private Boolean alertStatus;

    @ApiModelProperty(value = "系统/人工")
    private String type;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;

    @ApiModelProperty(value = "报警类型")
    private String alarmType;

    @ApiModelProperty(value = "报警类型code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "报警方式")
    private String alarmMode;

    @ApiModelProperty(value = "报警方式code")
    private String alarmModeCode;

    @ApiModelProperty(value = "通话记录信息id")
    private Integer callRecordId;

    @ApiModelProperty(value = "父警情id")
    private Long fatherAlert;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "接警时间")
    private Date callTime;

    @ApiModelProperty(value = "接警时长")
    private Double callTimeNum;

    @ApiModelProperty(value = "警情来源")
    private String alertSource;

    @ApiModelProperty(value = "警情来源code")
    private String alertSourceCode;

    @ApiModelProperty(value = "警情类型")
    private String alertType;

    @ApiModelProperty(value = "警情类型code")
    private String alertTypeCode;

    @ApiModelProperty(value = "事发单位")
    private String unitInvolved;

    @ApiModelProperty(value = "被困人数")
    private Integer trappedNum;

    @ApiModelProperty(value = "伤亡人数")
    private Integer casualtiesNum;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "救援方格")
    private String rescueGrid;

    @ApiModelProperty(value = "坐标x")
    private Double coordinateX;

    @ApiModelProperty(value = "坐标y")
    private Double coordinateY;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "发送人名称")
    private String recUserName;
    
    @ApiModelProperty(value = "接警时间开始---用于列表过滤")
    private Date callTimeStart ;
    
    @ApiModelProperty(value = "接警时间结束---用于列表过滤")
    private Date callTimeEnd ;
    
    @ApiModelProperty(value = "响应级别字典code 为了过滤用（只有航空器故障有）")
    private String responseLevelCode;

    @ApiModelProperty(value = "警情状态str")
    private String alertStatusStr;

    @ApiModelProperty(value = "来源系统")
    private String systemSource;
    @ApiModelProperty(value = "系统来源code")
    private String systemSourceCode;
}
