package com.yeejoin.amos.boot.module.tcm.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
* 警情表单
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_alert_form")
@ApiModel(value="AlertForm对象", description="警情表单")
public class AlertForm extends BaseEntity {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情类型")
    private String alertTypeCode;

    @ApiModelProperty(value = "字段名称")
    private String fieldName;

    @ApiModelProperty(value = "英文名称")
    private String fieldCode;

    @ApiModelProperty(value = "字段类型")
    private String fieldType;

    @ApiModelProperty(value = "字段值字典code")
    private String fieldValueCode;

    @ApiModelProperty(value = "是否一行显示")
    private Boolean block;

    //新加排序字段
    @ApiModelProperty(value = "排序字段")
    private int sortNum;

    @ApiModelProperty(value = "接口地址")
    private String url;
    
}
