package com.yeejoin.amos.boot.biz.common.annotation;


import java.lang.annotation.*;


@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface FieldDisplayDefine {

    String value();
    /**
     * 字段别名 兼容前端使用
     *
     * @return 别名key
     */
    String alias() default "";

    Class<?> type() default String.class;

    String format() default "yyyy-MM-dd";

    boolean isExist() default true;

    String typeHandler() default "defaultTypeHandler";

    String dictCode() default "";

    /**
     * 是否冗余字段，如行政区划名称，冗余时则该字段不再记录变更日志
     * @return 是否冗余
     */
    boolean isRepeatColumn() default false;
}
