package com.yeejoin.amos.api.openapi.enums;

import lombok.Getter;

/**
 * 气瓶类型枚举
 */
@Getter
public enum CylinderType {
    VEHICLE_CNG_LNG_H2("VEHICLE_CNG_LNG_H2", "车用气瓶（CNG/LNG/氢气）"),
    LIQUEFIED_GAS_LPG("LIQUEFIED_GAS_LPG", "液化石油气瓶"),
    COMPRESSED_GAS("COMPRESSED_GAS", "压缩气体气瓶"),
    DISSOLVED_ACETYLENE("DISSOLVED_ACETYLENE", "溶解乙炔气瓶"),
    MIXED_GAS("MIXED_GAS", "混合气体气瓶"),
    CRYOGENIC_INSULATED("CRYOGENIC_INSULATED", "低温绝热气瓶"),
    LIQUEFIED_GAS_EXCLUDING_LPG("LIQUEFIED_GAS_EXCLUDING_LPG", "液化气体（LPG除外）气瓶");

    private final String code;
    private final String name;

    CylinderType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static CylinderType getByCode(String code) {
        for (CylinderType cylinderType : CylinderType.values()) {
            if (cylinderType.code.equals(code)) {
                return cylinderType;
            }
        }
        return null;
    }
}
