package com.yeejoin.amos.boot.module.cylinder.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 气瓶充装统计表-企业-以天为维度
 *
 * @author system_generator
 * @date 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_record_statistics_unit_day")
public class CylinderFillingRecordStatisticsUnitDay extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装次数
     */
	@TableField("total_sum")
    private Integer totalSum;

    /**
     * 充装前检查数量
     */
	@TableField("filling_before_sum")
    private Integer fillingBeforeSum;

    /**
     * 充装后检查数量
     */
	@TableField("filling_after_sum")
    private Integer fillingAfterSum;

    /**
     * 企业编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 区域编码
     */
    @TableField("region_code")
    private String regionCode;

    /**
     * 充装日期
     */
	@TableField("filling_date")
    private Date fillingDate;

    /**
     * 充装检查不合格数
     */
	@TableField("filling_not_passed_count")
    private int fillingNotPassedCount;

    /**
     * 累计充装量
     */
	@TableField("filling_quantity")
    private BigDecimal fillingQuantity;

}
