package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderQuestionInfoDto;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.CylinderQuestionInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 问题信息列表
 *
 * @author system_generator
 * @date 2024-06-01
 */
@RestController
@Api(tags = "问题信息列表Api")
@RequestMapping(value = "/cylinder-question-info")
public class CylinderQuestionInfoController extends BaseController {

    @Autowired
    CylinderQuestionInfoServiceImpl cylinderQuestionInfoServiceImpl;

    /**
     * 新增问题信息列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增问题信息列表", notes = "新增问题信息列表")
    public ResponseModel<CylinderQuestionInfoDto> save(@RequestBody CylinderQuestionInfoDto model) {
        model = cylinderQuestionInfoServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新问题信息列表", notes = "根据sequenceNbr更新问题信息列表")
    public ResponseModel<CylinderQuestionInfoDto> updateBySequenceNbrCylinderQuestionInfo(@RequestBody CylinderQuestionInfoDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(cylinderQuestionInfoServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除问题信息列表", notes = "根据sequenceNbr删除问题信息列表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(cylinderQuestionInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个问题信息列表", notes = "根据sequenceNbr查询单个问题信息列表")
    public ResponseModel<CylinderQuestionInfoDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(cylinderQuestionInfoServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "问题信息列表分页查询", notes = "问题信息列表分页查询")
    public ResponseModel<Page<CylinderQuestionInfoDto>> queryForPage(@ApiParam(value = "页数") @RequestParam(value = "current") int current,
																	 @ApiParam(value = "每页大小") @RequestParam(value = "size") int size,
                                                                     @ApiParam(value = "appId") @RequestParam(value = "appId",required = false) String appId,
																	 @ApiParam(value = "问题类型枚举") @RequestParam(value = "questionType",required = false) String questionType,
																	 @ApiParam(value = "行政区域code")  @RequestParam(value = "regionCode",required = false) String regionCode) {
        Page<CylinderQuestionInfoDto> page = new Page<CylinderQuestionInfoDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(cylinderQuestionInfoServiceImpl.queryForCylinderQuestionInfoPage(page,questionType, regionCode, appId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/init")
    @ApiOperation(httpMethod = "PUT", value = "问题数据初始化", notes = "问题数据初始化,运维专用")
    public ResponseModel<String> initData() {
        cylinderQuestionInfoServiceImpl.initData();
        return ResponseHelper.buildResponse("success");
    }
}
