package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgPipelineOperationHistServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.IdxBizJgPipelineOperationHistDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 管道删除历史表
 *
 * @author system_generator
 * @date 2025-06-03
 */
@RestController
@Api(tags = "管道删除历史表Api")
@RequestMapping(value = "/idx-biz-jg-pipeline-delete-history")
public class IdxBizJgPipelineOperationHistController extends BaseController {

    @Autowired
    IdxBizJgPipelineOperationHistServiceImpl IdxBizJgPipelineOperationHistServiceImpl;

    /**
     * 新增管道删除历史表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增管道删除历史表", notes = "新增管道删除历史表")
	public ResponseModel<IdxBizJgPipelineOperationHistDto> save(@RequestBody IdxBizJgPipelineOperationHistDto model) {
	    model = IdxBizJgPipelineOperationHistServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新管道删除历史表", notes = "根据sequenceNbr更新管道删除历史表")
	public ResponseModel<IdxBizJgPipelineOperationHistDto> updateBySequenceNbrIdxBizJgPipelineOperationHist(@RequestBody IdxBizJgPipelineOperationHistDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(IdxBizJgPipelineOperationHistServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除管道删除历史表", notes = "根据sequenceNbr删除管道删除历史表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(IdxBizJgPipelineOperationHistServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个管道删除历史表",  notes = "根据sequenceNbr查询单个管道删除历史表")
	public ResponseModel<IdxBizJgPipelineOperationHistDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(IdxBizJgPipelineOperationHistServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "管道删除历史表分页查询",  notes = "管道删除历史表分页查询")
	public ResponseModel<Page<IdxBizJgPipelineOperationHistDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizJgPipelineOperationHistDto> page = new Page<IdxBizJgPipelineOperationHistDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(IdxBizJgPipelineOperationHistServiceImpl.queryForIdxBizJgPipelineOperationHistPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "管道删除历史表列表全部数据查询",   notes = "管道删除历史表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizJgPipelineOperationHistDto>> selectForList() {
	    return ResponseHelper.buildResponse(IdxBizJgPipelineOperationHistServiceImpl.queryForIdxBizJgPipelineOperationHistList());
	}
}
