package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintenanceContractEqDto;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgMaintenanceContractEqServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 维保备案设备关系表
 *
 * @author system_generator
 * @date 2023-12-18
 */
@RestController
@Api(tags = "维保备案设备关系表Api")
@RequestMapping(value = "/jg-maintenance-contract-eq")
public class JgMaintenanceContractEqController extends BaseController {

    @Autowired
    JgMaintenanceContractEqServiceImpl jgMaintenanceContractEqServiceImpl;

    /**
     * 新增维保备案设备关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增维保备案设备关系表", notes = "新增维保备案设备关系表")
	public ResponseModel<JgMaintenanceContractEqDto> save(@RequestBody JgMaintenanceContractEqDto model) {
	    model = jgMaintenanceContractEqServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新维保备案设备关系表", notes = "根据sequenceNbr更新维保备案设备关系表")
	public ResponseModel<JgMaintenanceContractEqDto> updateBySequenceNbrJgMaintenanceContractEq(@RequestBody JgMaintenanceContractEqDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgMaintenanceContractEqServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除维保备案设备关系表", notes = "根据sequenceNbr删除维保备案设备关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgMaintenanceContractEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个维保备案设备关系表",  notes = "根据sequenceNbr查询单个维保备案设备关系表")
	public ResponseModel<JgMaintenanceContractEqDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgMaintenanceContractEqServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "维保备案设备关系表分页查询",  notes = "维保备案设备关系表分页查询")
	public ResponseModel<Page<JgMaintenanceContractEqDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgMaintenanceContractEqDto> page = new Page<JgMaintenanceContractEqDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgMaintenanceContractEqServiceImpl.queryForJgMaintenanceContractEqPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "维保备案设备关系表列表全部数据查询",   notes = "维保备案设备关系表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgMaintenanceContractEqDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgMaintenanceContractEqServiceImpl.queryForJgMaintenanceContractEqList());
	}
}
