package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.changeRegistrationUnit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationUnit;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationUnitEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationUnitEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationUnitServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class ChangeRegistrationUnitEditUpdateService {

    private final JgChangeRegistrationUnitServiceImpl mainService;

    private final JgChangeRegistrationUnitEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgChangeRegistrationUnit jgChangeRegistrationUnit = getOneByApplyNoSingle(applyNo);
        List<JgChangeRegistrationUnitEq> eqs = eqService.list(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>().eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, jgChangeRegistrationUnit.getSequenceNbr()).select(JgChangeRegistrationUnitEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgChangeRegistrationUnitEq::getEquId).collect(Collectors.toSet());
    }

    public JgChangeRegistrationUnit getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgChangeRegistrationUnit>().eq(JgChangeRegistrationUnit::getApplyNo, applyNo));
    }

    private JgChangeRegistrationUnit getOneByApplyNoSingle(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgChangeRegistrationUnit>().eq(JgChangeRegistrationUnit::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
    }

    public Set<String> getProIdsByApplyNo(String applyNo) {
        JgChangeRegistrationUnit jgChangeRegistrationUnit = getOneByApplyNoSingle(applyNo);
        List<JgChangeRegistrationUnitEq> proIds = eqService.list(new LambdaQueryWrapper<JgChangeRegistrationUnitEq>().eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, jgChangeRegistrationUnit.getSequenceNbr()).select(JgChangeRegistrationUnitEq::getProjectContraptionId, BaseEntity::getSequenceNbr));
        return proIds.stream().map(JgChangeRegistrationUnitEq::getProjectContraptionId).collect(Collectors.toSet());
    }

}