package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.installNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class InstallNoticeEditUpdateService {
    private final JgInstallationNoticeServiceImpl installationNoticeService;

    private final JgInstallationNoticeEqServiceImpl installationNoticeEqService;

    private final IdxBizJgUseInfoServiceImpl useInfoService;

    private static final List<String> NOT_FLOWING_STATE = Arrays.asList("6610", "6614", "6615");

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgInstallationNotice jgInstallationNotice = installationNoticeService.getOne(new LambdaQueryWrapper<JgInstallationNotice>().eq(JgInstallationNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgInstallationNotice::getProjectContraptionId, JgInstallationNotice::getNoticeStatus));
        List<JgInstallationNoticeEq> eqs;
        if (StringUtils.isNotEmpty(jgInstallationNotice.getProjectContraptionId())) { // 装置逻辑
            if (NOT_FLOWING_STATE.contains(jgInstallationNotice.getNoticeStatus())) {
                //  非流程中查询装置下的管道-原因未纳管装置可进行装置的增减
                List<IdxBizJgUseInfo> useInfos = useInfoService.list(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getProjectContraptionId, jgInstallationNotice.getProjectContraptionId()).select(IdxBizJgUseInfo::getRecord));
                return useInfos.stream().map(IdxBizJgUseInfo::getRecord).collect(Collectors.toSet());
            } else {
                // 流程中按照eq表查询
                eqs = installationNoticeEqService.list(new LambdaQueryWrapper<JgInstallationNoticeEq>().eq(JgInstallationNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgInstallationNoticeEq::getEquId, BaseEntity::getSequenceNbr));
            }
        } else {
            eqs = installationNoticeEqService.list(new LambdaQueryWrapper<JgInstallationNoticeEq>().eq(JgInstallationNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgInstallationNoticeEq::getEquId, BaseEntity::getSequenceNbr));
        }
        return eqs.stream().map(JgInstallationNoticeEq::getEquId).collect(Collectors.toSet());
    }

    public JgInstallationNotice getOneByApplyNo(String applyNo) {
        return installationNoticeService.getOne(new LambdaQueryWrapper<JgInstallationNotice>().eq(JgInstallationNotice::getApplyNo, applyNo));
    }
}
