package com.yeejoin.amos.boot.module.jg.biz.handler;

import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class ToBeSubmitDetailStrategyFactory {

    private final Map<String, ToBeSubmitDetailStrategy> strategyMap = new HashMap<>();

    @Autowired
    public ToBeSubmitDetailStrategyFactory(List<ToBeSubmitDetailStrategy> strategies) {
        for (ToBeSubmitDetailStrategy strategy : strategies) {
            strategyMap.put(strategy.supportBusinessType(), strategy);
        }
    }

    public ToBeSubmitDetailStrategy getStrategy(String businessType) {
        ToBeSubmitDetailStrategy strategy = strategyMap.get(businessType);
        if (strategy == null) {
            throw new IllegalArgumentException("Unsupported businessType: " + businessType);
        }
        return strategy;
    }
}
