package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNoticeEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgInstallationNoticeEqMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeEqService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeEqDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 安装告知设备关系表服务实现类
 *
 * @author system_generator
 * @date 2023-12-18
 */
@Service
public class JgInstallationNoticeEqServiceImpl extends BaseService<JgInstallationNoticeEqDto,JgInstallationNoticeEq,JgInstallationNoticeEqMapper> implements IJgInstallationNoticeEqService {
    /**
     * 分页查询
     */
    public Page<JgInstallationNoticeEqDto> queryForJgInstallationNoticeEqPage(Page<JgInstallationNoticeEqDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<JgInstallationNoticeEqDto> queryForJgInstallationNoticeEqList()   {
        return this.queryForList("" , false);
    }

    public List<JgInstallationNoticeEq> getListByEquIds(List<String> equIds) {
        QueryWrapper<JgInstallationNoticeEq> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().in(JgInstallationNoticeEq::getEquId, equIds);
        queryWrapper.lambda().eq(JgInstallationNoticeEq::getIsDelete,false);
        return list(queryWrapper);
    }
}