package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.date.StopWatch;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.boot.module.common.api.dto.BaseEnterpriseCertDto;
import com.yeejoin.amos.boot.module.common.api.entity.BaseEnterpriseCert;
import com.yeejoin.amos.boot.module.common.biz.service.impl.BaseEnterpriseCertServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.jyjc.api.entity.*;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultParamMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class HisDataHandlerServiceImpl {

    @Resource
    private JyjcInspectionApplicationEquipMapper jyjcInspectionApplicationEquipMapper;

    @Resource
    private JyjcInspectionApplicationMapper jyjcInspectionApplicationMapper;

    @Resource
    private JyjcInspectionHistoryServiceImpl inspectionHistoryService;

    @Resource
    private JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationService;

    @Resource
    private BaseEnterpriseCertServiceImpl enterpriseCertService;

    @Resource
    private JyjcInspectionResultParamMapper jyjcInspectionResultParamMapper;

    @Resource
    private ObjectMapper objectMapper;

    @Transactional(rollbackFor = Exception.class)
    public void pieLineDataHandlerV1() {
        List<JyjcInspectionApplicationEquip> applicationEquips = jyjcInspectionApplicationEquipMapper.queryWaitFlushData();
        log.info("处理前：待压力管道数据条数: {}", applicationEquips.size());
        applicationEquips.forEach(applicationEquip -> {
            // 更新设备表装置id
            LambdaUpdateWrapper<JyjcInspectionApplicationEquip> updateWrapperEquip = new LambdaUpdateWrapper<>();
            updateWrapperEquip.eq(BaseEntity::getSequenceNbr, applicationEquip.getSequenceNbr());
            updateWrapperEquip.set(JyjcInspectionApplicationEquip::getProjectContraptionId, applicationEquip.getProjectContraptionId());
            jyjcInspectionApplicationEquipMapper.update(null, updateWrapperEquip);
            // 更新报检申请表装置id
            LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapperApp = new LambdaUpdateWrapper<>();
            updateWrapperApp.eq(BaseEntity::getSequenceNbr, applicationEquip.getApplicationSeq());
            updateWrapperApp.set(JyjcInspectionApplication::getProjectContraptionId, applicationEquip.getProjectContraptionId());
            jyjcInspectionApplicationMapper.update(null, updateWrapperApp);
        });
        List<JyjcInspectionApplicationEquip> applicationEquipAfter = jyjcInspectionApplicationEquipMapper.queryWaitFlushData();
        log.info("处理前：待压力管道数据条数: {}", applicationEquipAfter.size());
    }

    public void openDataHandlerV1() {
        List<JyjcOpeningApplication> openingApplications = jyjcOpeningApplicationService.list(new LambdaQueryWrapper<JyjcOpeningApplication>().eq(JyjcOpeningApplication::getStatus, "已完成"));
        openingApplications.forEach(jyjcOpeningApplication -> {
            JyjcInspectionHistory history = inspectionHistoryService.getBySSeq(jyjcOpeningApplication.getSequenceNbr());
            if (history != null) {
                JSONObject hisData = history.getHistoryData();
                List<BaseEnterpriseCertDto> certDtos = hisData.getJSONArray(BizCommonConstant.UNIT_LICENCE_KEY).toJavaList(BaseEnterpriseCertDto.class);
                fillAgencyClassify2Cert(jyjcOpeningApplication, certDtos);
            }
        });
    }

    private void fillAgencyClassify2Cert(JyjcOpeningApplication jyjcOpeningApplication, List<BaseEnterpriseCertDto> certDtos) {
        certDtos.forEach(certDto -> {
            List<Long> certSeqs = jyjcOpeningApplicationService.getCertFromHisData(jyjcOpeningApplication, certDto);
            LambdaUpdateWrapper<BaseEnterpriseCert> updateWrapperCert = new LambdaUpdateWrapper<>();
            updateWrapperCert.set(BaseEnterpriseCert::getAgencyClassify, jyjcOpeningApplication.getAgencyClassify());
            updateWrapperCert.in(com.yeejoin.amos.boot.biz.common.entity.BaseEntity::getSequenceNbr, certSeqs);
            enterpriseCertService.update(null, updateWrapperCert);
        });
    }

    public Long pipeLenFix() {
        StopWatch watch = new StopWatch();
        watch.start();
        List<JyjcInspectionResultParam> resultParams = jyjcInspectionResultParamMapper.selectList(new LambdaQueryWrapper<JyjcInspectionResultParam>().eq(JyjcInspectionResultParam::getParamType, "IdxBizJgTechParamsPipeline"));
        resultParams.parallelStream().forEach(c -> {
            JSONObject paramObj = JSON.parseObject(c.getParamJson());
            if(paramObj != null){
                try {
                    List<Map<String, Object>> equips = objectMapper.readValue(
                            objectMapper.writeValueAsString(paramObj.get("equip")),
                            new TypeReference<ArrayList<Map<String, Object>>>() {
                            }
                    );
                    equips.forEach(equip -> {
                        if (!equip.containsKey(com.yeejoin.amos.boot.module.jg.api.common.BizCommonConstant.PIPE_LENGTH)) {
                            equip.put(com.yeejoin.amos.boot.module.jg.api.common.BizCommonConstant.PIPE_LENGTH, equip.get("pipeLength"));
                        }
                    });
                    paramObj.put("equip", equips);
                    LambdaUpdateWrapper<JyjcInspectionResultParam> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(JyjcInspectionResultParam::getParamJson, JSON.toJSONString(paramObj));
                    updateWrapper.eq(BaseEntity::getSequenceNbr, c.getSequenceNbr());
                    jyjcInspectionResultParamMapper.update(null, updateWrapper);
                } catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        });
        watch.stop();
        log.info("压力管道检验技术参数补充字段pipeLengthText，总处理数量：{}， 耗时信息：{}", resultParams.size(), watch.getTotalTimeSeconds());
        return (long) resultParams.size();
    }
}
