package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.EquipmentBizServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/dp/biz-equipment")
@Api(tags = "大屏-设备相关-业务API")
public class EquipmentBizController {


    private final EquipmentBizServiceImpl equipmentBizServiceImpl;


    @Autowired
    public EquipmentBizController(EquipmentBizServiceImpl equipmentBizServiceImpl) {
        this.equipmentBizServiceImpl = equipmentBizServiceImpl;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getFormRecordById/map", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "表格查询详情", notes = "表格查询详情")
    public ResponseModel<Object> getFormRecordByIdMap(@RequestParam Map<String, Object> map) {
        return ResponseHelper.buildResponse(equipmentBizServiceImpl.getFormRecordByIdMap(map));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getChildren")
    @ApiOperation(httpMethod = "GET", value = "通过设备种类code获取设备类别", notes = "通过设备种类code获取设备类别")
    public ResponseModel<List<EquipmentCategory>> getChildren(String code) {
        return ResponseHelper.buildResponse(equipmentBizServiceImpl.getChildren(code));
    }

}
