package com.yeejoin.amos.boot.module.tcm.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.BaseEquipParamDefineServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.BaseEquipParamDefineDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 设备定义与技术参数表关联关系表
 *
 * @author system_generator
 * @date 2023-12-18
 */
@RestController
@Api(tags = "设备定义与技术参数表关联关系表Api")
@RequestMapping(value = "/base-equip-param-define")
public class BaseEquipParamDefineController extends BaseController {

    @Autowired
    BaseEquipParamDefineServiceImpl baseEquipParamDefineServiceImpl;

    /**
     * 新增设备定义与技术参数表关联关系表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增设备定义与技术参数表关联关系表", notes = "新增设备定义与技术参数表关联关系表")
	public ResponseModel<BaseEquipParamDefineDto> save(@RequestBody BaseEquipParamDefineDto model) {
	    model = baseEquipParamDefineServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新设备定义与技术参数表关联关系表", notes = "根据sequenceNbr更新设备定义与技术参数表关联关系表")
	public ResponseModel<BaseEquipParamDefineDto> updateBySequenceNbrBaseEquipParamDefine(@RequestBody BaseEquipParamDefineDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(baseEquipParamDefineServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除设备定义与技术参数表关联关系表", notes = "根据sequenceNbr删除设备定义与技术参数表关联关系表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(baseEquipParamDefineServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个设备定义与技术参数表关联关系表",  notes = "根据sequenceNbr查询单个设备定义与技术参数表关联关系表")
	public ResponseModel<BaseEquipParamDefineDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(baseEquipParamDefineServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "设备定义与技术参数表关联关系表分页查询",  notes = "设备定义与技术参数表关联关系表分页查询")
	public ResponseModel<Page<BaseEquipParamDefineDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<BaseEquipParamDefineDto> page = new Page<BaseEquipParamDefineDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(baseEquipParamDefineServiceImpl.queryForBaseEquipParamDefinePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "设备定义与技术参数表关联关系表列表全部数据查询",   notes = "设备定义与技术参数表关联关系表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<BaseEquipParamDefineDto>> selectForList() {
	    return ResponseHelper.buildResponse(baseEquipParamDefineServiceImpl.queryForBaseEquipParamDefineList());
	}
}
