package com.yeejoin.amos.patrol.business.vo;


import com.yeejoin.amos.patrol.dao.entity.BasicEntity;
import lombok.Data;

import java.util.Date;


@Data
public class PointQueryVo extends BasicEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 参考地址
     */
    private String address;

    /**
     * 分类编号
     */
    private long catalogId;

    /**
     * 3维坐标(x,y,z)
     */
    private String coordinates;

    /**
     * 创建用户id
     */
    private String creatorId;

    /**
     * 有效巡检距离
     */
    private int distance;

    /**
     * 扩展字段
     */
    private String extendJson;

    /**
     * 定点拍照数
     */
    private int fixedShot;

    /**
     * 是否为固定点(1:固定点，0：移动点)
     */
    private String isFixed;

    /**
     * 无计划巡检是否评分(is_score = 1评分,0不评分)
     */
    private String isScore;

    /**
     * 最新更新时间
     */
    private Date lastUpdateTime;

    /**
     * 经度
     */
    private String latitude;

    /**
     * 风险等级(1:一级，2：二级，3：三级，4：四级，5：五级)
     */
    private String level;

    /**
     * 纬度
     */
    private String longitude;

    /**
     * 点名称
     */
    private String name;

    /**
     * 是否允许离线巡检
     */
    private Boolean offline;

    /**
     * 权限系统org code
     */
    private String orgCode;

    /**
     * 点编号
     */
    private String pointNo;

    /**
     * 备注说明
     */
    private String remark;

    /**
     * 路线id
     */
    private String routeId;

    /**
     * 路线名称
     */
    private String routeName;

    /**
     * 是否保存地理信(1:记录，0：不记录)
     */
    private String saveGps;

    /**
     * 最大拍照数
     */
    private int shotMaxNumber;

    /**
     * 最小拍照数
     */
    private int shotMinNumber;

    /**
     * 是否允许普通拍照(1：允许，0：不允许)
     */
    private String usuallyShot;

    /**
     * 是否删除：0表示未删除，1表示已删除
     */
    private boolean isDelete;

    /**
     * 归属区域/部门id
     */
    private String chargeDeptId ;

    /**
     * 负责人id
     */
    private String chargePersonId ;

    /**
     * 负责人id
     */
    private String chargePersonName ;


    /**
     * 状态：0 未纳入巡检，1 合格；2 不合格；3 漏检
     */
    private String status;

    /**
     * 3维模型楼层
     */
    private Integer floor;

    /**
     * 是否室内
     */
    private Boolean isIndoor;

    /**
     * 原始字段
     */
    private String originalId;

    /**
     * 风险源id
     */
    private String riskSourceId;

    /**
     * ue4位置
     */

    private String ue4Location;

    /**
     * ue4旋转
     */

    private String ue4Rotation;

    private String bizOrgCode;

    private String bizOrgName;

    /**
     * 物理区域id（数据来源于装备wl_area）
     */
    private Long areaId;
    /**
     * 物理区域名称（数据来源于装备wl_area）
     */
    private String areaName;
}