package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum CylinderTypeEnum {
    CYLINDER("瓶", "2300"),
    SEAMLESS_CYLINDER("无缝气瓶(车用)", "2310"),
    WELDED_CYLINDER("焊接气瓶(车用)", "2320"),
    SPECIAL_CYLINDER("特种气瓶(车用)", "23T0");

    private final String name;
    private final String code;

    public static String of(String code) {
        for (CylinderTypeEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }
}
