package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 注册登记信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgRegisterInfoDto", description="注册登记信息表")
public class IdxBizJgRegisterInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "登记机关组织机构代码")
    @TableField("ORGANIZATION_CODE")
    private String organizationCode;

    @ApiModelProperty(value = "登记机关名称")
    @TableField("ORGANIZATION_NAME")
    private String organizationName;

    @ApiModelProperty(value = "使用登记证编号")
    @TableField("USE_ORG_CODE")
    private String useOrgCode;

    @ApiModelProperty(value = "注册状态")
    @TableField("REGISTER_STATE")
    private String registerState;

    @ApiModelProperty(value = "设备代码")
    @TableField("EQU_CODE")
    private String equCode;

    @ApiModelProperty(value = "设备种类")
    @TableField("EQU_LIST")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    @TableField("EQU_CATEGORY")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    @TableField("EQU_DEFINE")
    private String equDefine;

    @ApiModelProperty(value = "产品名称")
    @TableField("PRODUCT_NAME")
    private String productName;

    @ApiModelProperty(value = "品牌名称")
    @TableField("BRAND_NAME")
    private String brandName;

    @ApiModelProperty(value = "设备型号")
    @TableField("EQU_TYPE")
    private String equType;

    @ApiModelProperty(value = "设备总价值（万元）")
    @TableField("EQU_PRICE")
    private String equPrice;

    @ApiModelProperty(value = "使用登记证")
    @TableField("USE_REGISTRATION_CERTIFICATE")
    private String useRegistrationCertificate;

    @ApiModelProperty(value = "使用标志")
    @TableField("USE_SIGN")
    private String useSign;

    @ApiModelProperty(value = "产品照片")
    @TableField("PRODUCT_PHOTO")
    private String productPhoto;

    @ApiModelProperty(value = "车辆牌号")
    @TableField("CAR_NUMBER")
    private String carNumber;

    @ApiModelProperty(value = "车架编号")
    @TableField("FRAME_NUMBER")
    private String frameNumber;

    @ApiModelProperty(value = "发动机编号")
    @TableField("ENGINE_NUMBER")
    private String engineNumber;

    @ApiModelProperty(value = "电动机编号")
    @TableField("MOTOR_NUMBER")
    private String motorNumber;

}
