package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 保险信息
 *
 * @author system_generator
 * @date 2021-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ElevatorInsureDto", description="保险信息")
public class ElevatorInsureDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "承保单位")
    private String contractingUnit;

    @ApiModelProperty(value = "承保单位id")
    private Long contractingUnitId;

    @ApiModelProperty(value = "服务单位")
    private String serviceUnit;

    @ApiModelProperty(value = "服务单位id")
    private Long serviceUnitId;

    @ApiModelProperty(value = "理赔电话")
    private String claimPhone;

    @ApiModelProperty(value = "保险截止日期")
    private Date insureEndDate;

    @ApiModelProperty(value = "保单号")
    private String insureNum;

    @ApiModelProperty(value = "理赔主体")
    private String claimBody;

    @ApiModelProperty(value = "保险附件")
    private List<AttachmentDto> insureAttach;

}
