package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.api.dto.CurrentStatusDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.biz.constats.Constants;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureDetailsServiceImpl;

import feign.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author system_generator
 * @date 2021-08-04
 */
@RestController
@Api(tags = "故障维修单Api")
@RequestMapping(value = "/common/failure-details")
public class FailureDetailsController extends BaseController {


    @Autowired
    FailureDetailsServiceImpl failureDetailsServiceImpl;

    @Autowired
    WorkflowFeignService workflowFeignService;

    /**
     * 新增
     *
     * @return
     * @throws Exception
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<Object> save(@RequestBody FailureDetailsDto model) {
        try {
            return ResponseHelper.buildResponse(failureDetailsServiceImpl.savemodel(model, getSelectedOrgInfo()));
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseHelper.buildResponse(false);
        }
    }




    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<FailureDetailsDto> selectOne(@PathVariable Long sequenceNbr) {

        return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForOne(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<IPage<FailureDetailsDto>> queryForPage(@RequestParam(value = "current") Long current, @RequestParam
            (value = "size") Long size, @RequestParam Integer type, Long currentStatus,
                                                                Integer userId,
                                                                String startTime, String endTime) {
        Page<FailureDetails> page = new Page<FailureDetails>();
        if (current > 0) {
            page.setCurrent((current - 1) * size);
        } else {
            page.setCurrent(current);
        }

        page.setSize(size);
        ReginParams userInfo = getSelectedOrgInfo();
        IPage<FailureDetailsDto> failureDetailDTOsIPage = new Page<>();

        IPage<FailureDetails> failureDetailsIPage = failureDetailsServiceImpl.queryForFailureDetailsPage(page, userInfo, currentStatus, startTime, endTime, userId, type);

        BeanUtils.copyProperties(failureDetailsIPage, FailureDetailsDto.class);
        List<FailureDetails> records = failureDetailsIPage.getRecords();
        List<FailureDetailsDto> failureDetailsDtoList = new ArrayList<>();
        records.forEach(failureDetails -> {
            FailureDetailsDto failureDetailsDto = new FailureDetailsDto();
            BeanUtils.copyProperties(failureDetails, failureDetailsDto);

            failureDetailsDto.setCurrentStatusName(
                    Constants.currentStatusNameMap.get(failureDetails.getCurrentStatus()));
            failureDetailsDtoList.add(failureDetailsDto);
        });
        failureDetailDTOsIPage.setRecords(failureDetailsDtoList);
        failureDetailDTOsIPage.setTotal(failureDetailsIPage.getTotal());

        return ResponseHelper.buildResponse(failureDetailDTOsIPage);
    }


    /**
     * 根据状态查询当前下全部数据
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据状态查询当前下全部数据", notes = "根据状态查询当前下全部数据")
    @GetMapping(value = "/list/{currentStatus}")
    public ResponseModel<List<FailureDetails>> selectStatusForList(@PathVariable Long currentStatus) {

        return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureStatus(currentStatus));
    }

    /**
     * 查询当前状态任务数量
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询当前状态任务数量", notes = "查询当前状态任务数量")
    @GetMapping(value = "/list/count")
    public ResponseModel<List<CurrentStatusDto>> selectStatusCount(Integer type, Long currentStatus, String startTime, String endTime, Integer userId) {
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryStatusCount(getSelectedOrgInfo(), type, currentStatus, startTime, endTime, userId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "流程信息", notes = "流程信息")
    @GetMapping(value = "/processHistory")
    public ResponseModel<Object> selectHistoryt(@RequestParam Long sequenceNbr) {
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.getCurrentProcessHistoryTask(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "权限button的显示", notes = "权限button的显示")
    @GetMapping(value = "/getExcuteTaskAuthButton/{sequenceNbr}")
    public ResponseModel<Integer> getExcuteTaskAuthButton(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.getExcuteTaskAuthButton(sequenceNbr, getSelectedOrgInfo()));

    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询当前任务详情", notes = "查询当前任务详情")
    @GetMapping(value = "/getCurrentTask/{sequenceNbr}")
    public ResponseModel<Object> getCurrentTask(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.getCurrentTask(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "流程图高亮", notes = "流程图高亮")
    @GetMapping(value = "/activistHistory/gethighLine")
    public ResponseModel<Object> thighLine(@RequestParam("instanceId") String instanceId) {
        return ResponseHelper.buildResponse(workflowFeignService.thighLine(instanceId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询状态枚举", notes = "查询状态枚举")
    @GetMapping(value = "/getStatus")
    public ResponseModel<Object> getStatusEunms() {
        return ResponseHelper.buildResponse(FailureStatuEnum.getEnumList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/downloadFile/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "流程图高亮图片", notes = "流程图高亮图片")
    public  ResponseEntity<String> downloadFile(@PathVariable Long sequenceNbr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String processId = failureDetailsServiceImpl.queryBySeq(sequenceNbr).getProcessId();
        Response feignResponse = workflowFeignService.thighLineImg(processId);
        try {
            Response.Body body = feignResponse.body();
//            response.setContentType("application/octet-stream");// 
//            response.setHeader("content-type", "application/octet-stream");
//            response.setContentType("text/xml");// 
//            response.setHeader("content-type", "text/xml");
//            response.setCharacterEncoding("utf-8");
//            response.setHeader("Content-Disposition", "attachment;fileName=workflow.svg");
//            response.reset();
//            byte[] b = new byte[1024];
//            int len;
//            while ((len = body.asInputStream().read(b, 0, 1024)) != -1) {
//                out.write(b, 0, len);
//            }
//            out.flush();
             return new ResponseEntity<String>(IOUtils.toString(body.asInputStream()),  HttpStatus.OK);
            		 //.toByteArray(body.asInputStream()), responseHeaders, HttpStatus.OK);
        } catch (Exception e) {
        	throw new BaseException("Error exporting diagram", "500", processId);
        }
        
    }

    /**
     * Web端列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list/weblist")
    @ApiOperation(httpMethod = "GET", value = "Web端列表分页查询", notes = "Web端列表分页查询")
    public ResponseModel<IPage<FailureDetailsDto>> queryForPageList(@RequestParam(value = "current") Long current, @RequestParam
            (value = "size") Long size, @RequestParam (required = false) Long currentStatus,
                                                                    @RequestParam (required = false)String submissionName,
                                                                    @RequestParam (required = false) String startTime,
                                                                    @RequestParam (required = false) String endTime,
                                                                    @RequestParam (required = false) Long  submissionBranchId,
                                                                    @RequestParam (required = false) Long sequenceNbr ) {
        Page<FailureDetailsDto> page = new Page<>();
        if (current.longValue() > 0) {
            page.setCurrent((current - 1) * size);
        } else {
            page.setCurrent(current);
        }

        page.setSize(size);
        ReginParams userInfo = getSelectedOrgInfo();
        IPage<FailureDetailsDto> failureDetailDTOsIPage = new Page<>();

        IPage<FailureDetailsDto> failureDetailsIPage = failureDetailsServiceImpl.queryForPageList(page, userInfo,
                currentStatus, startTime, endTime, submissionName,submissionBranchId,sequenceNbr);

        BeanUtils.copyProperties(failureDetailsIPage, FailureDetailsDto.class);
        List<FailureDetailsDto> records = failureDetailsIPage.getRecords();
        List<FailureDetailsDto> failureDetailsDtoList = new ArrayList<FailureDetailsDto>();
        records.stream().forEach(failureDetails -> {
            FailureDetailsDto failureDetailsDto = new FailureDetailsDto();
            BeanUtils.copyProperties(failureDetails, failureDetailsDto);

            failureDetailsDto.setCurrentStatusName(
                    Constants.currentStatusNameMap.get(failureDetails.getCurrentStatus()));
            failureDetailsDtoList.add(failureDetailsDto);
        });
        failureDetailDTOsIPage.setRecords(failureDetailsDtoList);
        failureDetailDTOsIPage.setTotal(failureDetailsIPage.getTotal());

        return ResponseHelper.buildResponse(failureDetailDTOsIPage);
    }

}
