package com.yeejoin.amos;

import java.net.InetAddress;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

/**
 * 
 * <pre>
 * 
 * </pre>
 *
 * @author gwb
 * @version $Id: OpenapiApplication.java, v 0.1 2021年9月27日 下午3:29:30 gwb Exp $
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@EnableScheduling
@MapperScan(basePackages = { "org.typroject.tyboot.*.*.face.orm.dao",
		"com.yeejoin.amos.api.*.face.orm.dao",
		"org.typroject.tyboot.face.*.orm.dao*",
		"com.yeejoin.amos.boot.module.cylinder.api.mapper",
		"com.yeejoin.amos.boot.module.cylinder.flc.api.mapper",
		"com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan(basePackages = { "org.typroject", "com.yeejoin.amos" }, excludeFilters = @ComponentScan.Filter(
		type = FilterType.REGEX,
		pattern = "com.yeejoin.amos.component.config.TransactionalUntil|com.yeejoin.amos.boot.biz.common.controller.*|com.yeejoin.amos.boot.module.common.api.core.framework.*"
))
public class OpenapiApplication {

	private static final Logger logger = LogManager.getLogger(OpenapiApplication.class);

	public static void main(String[] args) throws Exception {
//    	//license授权验证
//    	System.setProperty("root.path",ClassPathUtil.getPath()+"/config");
//    	log.info("（license.bat）url：" + ClassPathUtil.getPath()+"/config");
//    	A.v();
		// 服务启动
		ConfigurableApplicationContext context = SpringApplication.run(OpenapiApplication.class, args);
		GlobalExceptionHandler.setAlwaysOk(true);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = env.getProperty("server.servlet.context-path");
		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
	}
}
