package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderInspectionDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderUnitDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderInspectionModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderInspectionMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderInspection;


/**
 * 
 * <pre>
 * 气瓶检验信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderInspectionService extends BaseService<TmCylinderInspectionModel, TmCylinderInspection, TmCylinderInspectionMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	public String createCylinderInspection(List<TmCylinderInspectionModel> model) {
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("气瓶检验信息为空.");
		syncCylinderInspectionModel(model);
		for (TmCylinderInspectionModel cylinderInspectionModel : model) {
			cylinderInspectionModel.setRecDate(new Date());
			cylinderInspectionModel.setAppId(getAppId());
			this.createWithModel(cylinderInspectionModel);
		}
		return "OK";
	}

	private void syncCylinderInspectionModel(List<TmCylinderInspectionModel> model) {
		syncCylinderDataService.syncCylinderInspection(model);
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}	
}
