package com.yeejoin.amos.api.openapi.face.service;


import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderFillingModelList;
import com.yeejoin.amos.api.openapi.face.model.CylinderTagsModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.CylinderTagsMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.CylinderTags;


/**
 * 
 * <pre>
 * 气瓶标签信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class CylinderTagsService extends BaseService<CylinderTagsModel,CylinderTags,CylinderTagsMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
    @Transactional(rollbackFor= {Exception.class})
	public String createCylinderTag(List<CylinderTagsModel> model) {
		// TODO Auto-generated method stub
		if (ValidationUtil.isEmpty(model))
			throw new BadRequest("气瓶标签信息为空.");
    	
		for (CylinderTagsModel cylinderTagsModel : model) {
			cylinderTagsModel.setRecDate(new Date());
			cylinderTagsModel.setAppId(getAppId());
			this.createWithModel(cylinderTagsModel);
		}
		return "OK";
	}

	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}	
}
