package com.yeejoin.equipmanage.common.vo;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zjw
 * @date 2020-09-04
 */
@Data
@ApiModel(description = "消防设施管理")
public class EquipmentManageVo  implements Serializable {

    private static final long serialVersionUID = 7556874233599L;
    /**
     * 主键
     */
    private String id;

    /**
     * 名称
     */
    private String name;

    /**
     * 编号
     */
    private String code;

    /**
     * 系统类别
     */
    private String systemType;
    private String systemTypeCode;


    private String formGroupId;
    /**
     * 安装日期
     */
    private String installDate;

    /**
     * 负责人
     */
    private String chargePerson;

    /**
     * 施工单位
     */
    private String constructionUnit;
    private String constructionUnitCode;
    /**
     * 维保单位
     */
    private String maintenanceUnit;
    private String maintenanceUnitCode;
    /**
     * 维保频率
     */
    private String maintenanceFrequency;

    /**
     * 首次维保日期
     */
    private String firstMaintenanceDate;

    /**
     * 最后更新者的id
     */
    private String recUserId;

    /**
     * 更新时间
     */
    private String  recDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 系统图片url
     */
    private List<FileUploadVo> systemimg;
    /**
     * 平面图
     */
    private List<FileUploadVo> faceimg;
    /**
     * 视频说明
     */
    private FileUploadVo video;
    /**
     * 操作手册
     */
    private List<FileUploadVo> instruction;
    /**
     * 资质证书
     */
    private  List<FileUploadVo> asser;

    private String sort;

    /**
     * 画布id
     */
    private Long sceneId;

    /**
     * 设备数量
     */
    private Integer equipCount;

    private Long instanceId;

    private String bizOrgCode;

    private String bizOrgName;

    private String controBoxBuildName;
    private String controBoxBuildId;
}
