package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description: 违规管理
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingTaskBadManagementVo {

	// 人员类型 0主持人 1交底人 2施工负责人 3安全员 4记录人 5交底人员 6技术员 7工程人员 8施工人员 9违章人员 10分包商负责人 99 发布人
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "任务id")
	private Long id;

	@ApiModelProperty(value = "所属项目id")
	@TableFormat(entityName = "rpm_project", fieldName = "name", operFieldName = "projectName")
	private Long projectId;
	private String projectName;

	@ApiModelProperty(value = "任务编号")
	private String taskNo;

	@ApiModelProperty(value = "发起人id")
	@TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "createPersonName")
	private Long createPersonId;
	private String createPersonName;

	@ApiModelProperty(value = "起止时间")
	private Date startTime;

	@ApiModelProperty(value = "结束时间")
	private Date endTime;

	@ApiModelProperty(value = "任务状态")
	private Long status;

	@ApiModelProperty(value = "任务状态名称")
	private String statusName;

	@ApiModelProperty(value = "违章内容")
	private String body;

	@ApiModelProperty(value = "分包商企业ID")
	@TableFormat(entityName = "rpm_company", fieldName = "name", operFieldName = "companyName")
	private Long companyId;
	private String companyName;
	@ApiModelProperty(value = "分包商责任人")
	@TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "personLiableName")
	private Long personLiable;
	private String personLiableName;

	@ApiModelProperty(value = "图片")
	@ImagePrefix
	List<String> filePath;

	@ApiModelProperty(value = "违章人员数据")
	@TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "badManagementName")
	private Long badManagementId;
	private String badManagementName;
	private Object badManagementObject;

	@ApiModelProperty(value = "审核人")
	@TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "auditPersonName")
	private Long auditPersonId;
	private String auditPersonName;

	@ApiModelProperty(value = "违章类型")
	private String type;

	@ApiModelProperty(value = "违章性质")
	private String nature;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@ApiModelProperty(value = "执行人")
	List<TaskPerson> taskPersonList;

	@ApiModelProperty(value = "任务类型")
	private Long taskType;
	
    private TaskPerson taskPerson;
}
