package com.yeejoin.amos.boot.module.hygf.api.dto;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 户用光伏监盘采集器表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JpCollectorDto", description="户用光伏监盘采集器表")
public class JpCollectorDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "sn编码")
    private String snCode;

    @ApiModelProperty(value = "状态")
    private String state;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "sim卡号")
    private String simCode;

    @ApiModelProperty(value = "数据来源")
    private String dataSource;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "采集器版本")
    private String version;

    @ApiModelProperty(value = "出场日期")
    private Date dischargeDate;

    @ApiModelProperty(value = "生产日期")
    private Date productDate;

    @ApiModelProperty(value = "数据上传间隔")
    private Double dataPeriod;

    @ApiModelProperty(value = "本次上电工作时间")
    private Date thisWorkTime;

    @ApiModelProperty(value = "累计工作时间")
    private Date totalWorkTime;

    @ApiModelProperty(value = "第三方电站id")
    private String thirdStationId;

    @ApiModelProperty(value = "第三方厂商标识")
    private String thirdCode;

    @ApiModelProperty(value = "所属电站")
    private String stationName;

    @ApiModelProperty(value = "电站地址")
    private String addr;

    @ApiModelProperty(value = "采集器列表")
    private List<JpInverter> jpInverters;

    private List<String> stationIds;

     @ApiModelProperty(value = "采集器名称")
     private String name;


 @ApiModelProperty(value = "类型")
 private String collectorType;

 @ApiModelProperty(value = "信号强度")
 private String signalStrength;


 @ApiModelProperty(value = "所属项目公司")
 private String companyName;

}
