package com.yeejoin.amos.boot.module.jxiop.biz.tdmapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IndicatorDataMapper extends BaseMapper<IndicatorData> {

    @Select("select `value`, created_time as createdTime, `value_f` as valueF from iot_data.indicator_data where address=#{address} and  created_time >= #{startTime} and created_time <= #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData>   selectDataByAddressAndtime(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId);


    @Select("select `value`, created_time as createdTime, `value_f` as valueF from iot_data.indicator_data where address=#{address} and  ts >= #{startTime} and ts <= #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData>   selectDataByAddressAndtimeTs(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId);

    @Select("select  ts as createdTime, `value_f` as valueF from iot_data.indicator_data where address=#{address} and  ts between #{startTime} and #{endTime} and gateway_id =#{gatewayId}")
    List<IndicatorData> getDataByTsAndAddress(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId);


    @Select("select `unit` from iot_data.indicator_data where address=#{address} and gateway_id =#{gatewayId} limit 1")
    IndicatorData selectUnitByAddressAndGatewayId(@Param("address")String address, @Param("gatewayId")String gatewayId);


    @Select("select `value`, created_time as createdTime, `value_f` as valueF, `address`, gateway_id as gatewayId from iot_data.indicator_data where  created_time >= #{startTime} and created_time <= #{endTime} and ((gateway_id =#{gatewayId} and address=#{address}) or (gateway_id =#{gatewayId1} and address=#{address1})) ")
    List<IndicatorData>   selectDataByAddressAndtimeNew(@Param("address")String address,@Param("startTime") String startTime, @Param("endTime")String endTime, @Param("gatewayId")String gatewayId, @Param("gatewayId1")String gatewayId1, @Param("address1")String address1);


    @Select("select `value` from iot_data.indicator_data where id =#{id}")
    List<IndicatorData> selectDataById (@Param("id")String id);


    @Select("select `id`,  `value` from iot_data.indicator_data where `address` in (${addresses}) and gateway_id = #{gatewayId}")
    List<IndicatorData> selectByAddresses(@Param("addresses") String addresses, @Param("gatewayId") String gatewayId);

    /**
     * 根据测点名称查询测点值信息
     * @param equipmentIndexName 测点名称
     * @param gatewayId 网关Id
     * @param date 时间
     * @param limitNum 分页条数
     */
    @Select("SELECT created_time as createdTime, avg( `value_f` ) as valueF FROM iot_data.indicator_data  WHERE gateway_id = #{gatewayId}  AND equipment_index_name = #{equipmentIndexName}  AND ts > #{date} GROUP BY created_time order by created_time desc LIMIT #{limitNum}")
    List<IndicatorData> selectByIndexNameAndDate(@Param("equipmentIndexName") String equipmentIndexName, @Param("gatewayId") String gatewayId, @Param("date") String date, @Param("limitNum") Integer limitNum);


    @Select("select `value`, created_time from iot_data.indicator_data where id =#{id}  and  ts >= #{startTime} and ts <= #{endTime} ")
    List<IndicatorData> selectDataByequipmentIndexNameAndtimeAndEquipmentNumber(@Param("id") String id, @Param("startTime") String startTime, @Param("endTime") String endTime);

    @Select("select `value`,`value_f`, address, gateway_id from iot_data.indicator_data where ts > NOW()-10m and gateway_id = #{gatewayId}")
    List<IndicatorData> selectDataByGatewayIdAndAddress(@Param("gatewayId") String gatewayId);
    @Select("select created_time,`value`,`value_f`, address, gateway_id from iot_data.indicator_data where gateway_id = #{gatewayId} and `address` in ( ${addresses} ) and  ts >= #{startTime} and ts <= #{endTime}")
    List<IndicatorData> selectDataByGatewayIdAndAddressForAlarmInfoDetail(@Param("gatewayId") String gatewayId,@Param("addresses") String addresses,@Param("startTime") String startTime, @Param("endTime") String endTime);

}
