package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;


public class RequestChangeData extends JSONObject {

    /**
     * 批量编辑时表格key-公共使用
     */
    public static final String multiDataKey = "tableData";

    /**
     * 删除的数据表格key-管道使用
     */
    public static final String deletedDataKey = "deleteData";

    /**
     * 变更说明
     */
    public static final String changeReasonKey = "changeReason";

    /**
     * 变更说明附件
     */
    public static final String changeReasonAttachmentKey = "changeAttachment";

    public void validated(ReginParams reginParams) {
        // 监管单位编辑需要上传变更说明
        if (!reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            if (!this.containsKey(changeReasonKey) || !this.containsKey(changeReasonAttachmentKey)) {
                throw new BadRequest("变更说明和变更说明附件不能为空！");
            }
        }
    }

}