package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.module.common.api.dto.IBaseChangeData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 安全追溯-维保备案信息表
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_maintenance_record_info")
@Group("idx_biz_jg_maintenance_record_info")
public class IdxBizJgMaintenanceRecordInfo extends TzsBaseEntity implements IBaseChangeData {




    /**
     *
     */
    @TableField("\"RECORD\"")
    private String record;


    /**
     *
     */
    @TableField("\"INSTANCE_ID\"")
    private String instanceId;

    /**
     *
     */
    @TableField("\"STATUS\"")
    private String status;

    /**
     *
     */
    @TableField("\"ME_UNIT_CREDIT_CODE\"")
    @FieldDisplayDefine(value = "维保单位统一信用代码")
    private String meUnitCreditCode;

    /**
     *
     */
    @TableField("\"ME_UNIT_NAME\"")
    @FieldDisplayDefine(value = "维保单位名称")
    private String meUnitName;

    /**
     * 维保备案合同
     */
    @TableField("\"REPAIR_INFORM\"")
    @FieldDisplayDefine(value = "维保备案合同附件", type = JSON.class)
    private String repairInform;

    /**
     * 维保合同开始日期
     */
    @TableField("\"INFORM_START\"")
    @FieldDisplayDefine(value = "维保合同开始日期")
    private Date informStart;

    /**
     * 维保合同结束日期
     */
    @TableField("\"INFORM_END\"")
    @FieldDisplayDefine(value = "维保合同结束日期")
    private Date informEnd;

    /**
     *维保负责人1姓名
     */
    @TableField("\"ME_MASTER\"")
    @FieldDisplayDefine(value = "维保负责人1姓名")
    private String meMaster;


    /**
     *维保负责人1身份证
     */
    @TableField("\"ME_MASTER_ID\"")
    @FieldDisplayDefine(value = "维保负责人1身份证")
    private String meMasterId;


    /**
     *维保负责人1电话
     */
    @TableField("\"ME_MASTER_PHONE\"")
    @FieldDisplayDefine(value = "维保负责人1电话")
    private String meMasterPhone;


    /**
     *维保负责人2姓名
     */
    @TableField("\"ME_MASTER1\"")
    @FieldDisplayDefine(value = "维保负责人2姓名")
    private String meMaster1;


    /**
     *维保负责人2身份证
     */
    @TableField("\"ME_MASTER1_ID\"")
    @FieldDisplayDefine(value = "维保负责人2身份证")
    private String meMaster1Id;


    /**
     *维保负责人2电话
     */
    @FieldDisplayDefine(value = "维保负责人2电话")
    @TableField("\"ME_MASTER1_PHONE\"")
    private String meMaster1Phone;

    /**
     *
     */
    @TableField("\"EMERGENCYCALL\"")
    private String emergencycall;

    /**
     *
     */
    @TableField("\"ME_CYCLE\"")
    private String meCycle;

    /**
     *
     */
    @TableField("\"OVERHAUL_CYCLE\"")
    private String overhaulCycle;

    /**
     *
     */
    @TableField("\"ME24_TELEPHONE\"")
    private String me24Telephone;

    /**
     *
     */
    @TableField("\"SEQUENCE_CODE\"")
    private String sequenceCode;

    @TableField(exist = false)
    private String supervisoryCode;

    /**
     * 原始业务id(如维保备案id)
     */
    @TableField("\"SOURCE_ID\"")
    private String sourceId;

    /**
     * 其他维保附件
     */
    @FieldDisplayDefine(value = "其他维保附件", type = JSON.class)
    @TableField("\"ME_OTHER_ACCESSORIES\"")
    private String meOtherAccessories;
}
