package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.MonthPowerServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.MonthPowerDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 按月统计
 *
 * @author system_generator
 * @date 2023-09-20
 */
@RestController
@Api(tags = "按月统计Api")
@RequestMapping(value = "/month-power")
public class MonthPowerController extends BaseController {

    @Autowired
    MonthPowerServiceImpl monthPowerServiceImpl;

    /**
     * 新增按月统计
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增按月统计", notes = "新增按月统计")
	public ResponseModel<MonthPowerDto> save(@RequestBody MonthPowerDto model) {
	    model = monthPowerServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新按月统计", notes = "根据sequenceNbr更新按月统计")
	public ResponseModel<MonthPowerDto> updateBySequenceNbrMonthPower(@RequestBody MonthPowerDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    return ResponseHelper.buildResponse(monthPowerServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除按月统计", notes = "根据sequenceNbr删除按月统计")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(monthPowerServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个按月统计",  notes = "根据sequenceNbr查询单个按月统计")
	public ResponseModel<MonthPowerDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(monthPowerServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "按月统计分页查询",  notes = "按月统计分页查询")
	public ResponseModel<Page<MonthPowerDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<MonthPowerDto> page = new Page<MonthPowerDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(monthPowerServiceImpl.queryForMonthPowerPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "按月统计列表全部数据查询",   notes = "按月统计列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<MonthPowerDto>> selectForList() {

	    monthPowerServiceImpl.getMonthPower();

	    return ResponseHelper.buildResponse(null);
	}
}
