package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 液化气体气瓶充装信息-充装记录
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderFillingRecordDto", description="液化气体气瓶充装信息-充装记录")
public class CylinderFillingRecordDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "充装记录Id")
    private String fillingRecordId;

    @ApiModelProperty(value = "充装企业名称")
    private String fillingUnitName;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "气瓶品种")
    private String cylinderVariety;

    @ApiModelProperty(value = "二维码编号")
    private String qrCode;

    @ApiModelProperty(value = "电子标签编号")
    private String electronicLabelCode;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "单位内部编号")
    private String unitInnerCode;

    @ApiModelProperty(value = "产权单位")
    private String propertyUnit;

    @ApiModelProperty(value = "充装开始时间")
    private String fillingStarttime;

    @ApiModelProperty(value = "充装结束时间")
    private String fillingEndtime;

    @ApiModelProperty(value = "充装人员姓名")
    private String fillingUser;

    @ApiModelProperty(value = "充装量（Kg）")
    private Double fillingQuantity;

    @ApiModelProperty(value = "室温")
    private Double temperature;

    @ApiModelProperty(value = "异常情况")
    private Integer abnormal;

    @ApiModelProperty(value = "异常情况")
    private String abnormalStr;


    @ApiModelProperty(value = "充装前检查时间")
    private String inspectionDate;

   @ApiModelProperty(value = "充装前检查结果")
   private String fillingResult;

    @ApiModelProperty(value = "充装前检查人员")
    private String inspectorUser;

    @ApiModelProperty(value = "充装后检查人员姓名")
    private String inspector;

    @ApiModelProperty(value = "充装后检查时间")
    private String inspectionDateAfter;

    @ApiModelProperty(value = "充装后检查结果")
    private String checkResult;


    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "1初次同步数据   2上层系统已同步数据   0已删除数据")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;


 @ApiModelProperty(value = "是否在检验有效期以内")
 private String isValid;

 @ApiModelProperty(value = "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致")
 private Integer same;

 @ApiModelProperty(value = "气瓶外表面的颜色标志是否符合规定")
 private Integer isRegulations;

 @ApiModelProperty(value = "气瓶瓶阀的出气口螺纹型式是否符合GB/T15383")
 private Integer isComplianceWithgbt;

 @ApiModelProperty(value = "气瓶内有无剩余压力")
 private Integer haveStillPressure;

 @ApiModelProperty(value = "气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
 private Integer isComplete;

 @ApiModelProperty(value = "气瓶的安全附件齐全并符合安全要求")
 private Integer haveSecurityDocuments;

 @ApiModelProperty(value = "充装量在规定范围内")
 private Integer withinScope;

 @ApiModelProperty(value = "瓶阀及其与瓶口连接的密封良好")
 private Integer sealedState;

 @ApiModelProperty(value = "瓶体未出现鼓包变形或泄露等严重缺陷")
 private Integer defective;

 @ApiModelProperty(value = "瓶体温度没有异常升高的迹象")
 private Integer abnormalTemperature;

 @ApiModelProperty(value = "气瓶粘贴警示标签和充装标签")
 private Integer warningSign;


}
