package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.api.entity.UserCar;
import com.yeejoin.amos.boot.module.jcs.api.mapper.UserCarMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerTransferCompanyResourcesService;
import com.yeejoin.amos.boot.module.jcs.api.service.IUserCarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;


/**
 * 航空器信息服务实现类
 *
 * @author system_generator
 * @date 2021-06-29
 */
@Service
public class UserCarServiceImpl extends BaseService<AircraftDto, UserCar, UserCarMapper> implements IUserCarService {

    @Autowired
    UserCarMapper UserCarMapper;

    @Autowired
    IPowerTransferCompanyResourcesService companyResourcesService;


    @Override
    public UserCar selectByAmosUserId(Long id) {
        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", id);
        return UserCarMapper.selectOne(queryWrapper);
    }

    @Override
    public UserCar selectByCarId(Long id) {
        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("car_id", id);
        return UserCarMapper.selectOne(queryWrapper);
    }

    @Override
    public List<UserCar> selectList() {
        return this.list();
    }

    @Override
    public String selectListid() {
        return UserCarMapper.selectListid();
    }

    @Override
    public void add(UserCar userCar) {

        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", userCar.getAmosUserId());
        UserCar uer = UserCarMapper.selectOne(queryWrapper);
        if (uer != null) {
            userCar.setSequenceNbr(uer.getSequenceNbr());
            UserCarMapper.updateById(userCar);
        } else {
            UserCarMapper.insert(userCar);
        }
    }

    @Override
    public void delete(UserCar userCar) {
        QueryWrapper<UserCar> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("amos_user_id", userCar.getAmosUserId());
        UserCarMapper.delete(queryWrapper);
    }

    @Override
    public int countUserCarExecuting(Long userId) {
        UserCar userCar = this.selectByAmosUserId(userId);
        if (userCar == null) {
            return 0;
        }
        PowerTransferCompanyResources resource = companyResourcesService.getResourceById(userCar.getCarId().toString());
        if (resource == null) {
            return 0;
        }
        if ("executing".equals(resource.getCarStatus())) {
            return 1;
        } else {
            return 0;
        }
    }

}
