package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.CylinderFillingRecord;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.CylinderFillingRecordMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ICylinderFillingRecordService;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderFillingRecordDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;

/**
 * 液化气体气瓶充装信息-充装记录服务实现类
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Service
public class CylinderFillingRecordServiceImpl extends BaseService<CylinderFillingRecordDto,CylinderFillingRecord,CylinderFillingRecordMapper> implements ICylinderFillingRecordService {
    /**
     * 分页查询
     */
    public Page<CylinderFillingRecordDto> queryForCylinderFillingRecordPage(Page<CylinderFillingRecordDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderFillingRecordDto> queryForCylinderFillingRecordList()   {
        return this.queryForList("" , false);
    }

    public Double queryIntegirtyByAppId(String appId) {
        return this.baseMapper.queryIntegirtyByAppId(appId);
    }

    public Double getFillingSum(String r, Date time) {
        return this.baseMapper.getFillingSum(r,time);
    }

    public Page<CylinderFillingRecordDto> queryListByQueryDto(Page<CylinderFillingRecordDto> page, CylinderFillingRecordDto cylinderFillingRecordDto, String sortParam, String sortRule) {
        Page<List<CylinderFillingRecordDto>>list = this.baseMapper.queryListByQueryDto(page,cylinderFillingRecordDto.getFillingUnitName(),cylinderFillingRecordDto.getPropertyUnit(),cylinderFillingRecordDto.getFactoryNum(),
                cylinderFillingRecordDto.getCylinderVariety(), cylinderFillingRecordDto.getQrCode(), cylinderFillingRecordDto.getElectronicLabelCode(),cylinderFillingRecordDto.getSequenceCode(),cylinderFillingRecordDto.getUnitInnerCode(),
                cylinderFillingRecordDto.getFillingStarttime(), cylinderFillingRecordDto.getFillingEndtime(), sortParam,sortRule,cylinderFillingRecordDto.getAppId());
        Page<CylinderFillingRecordDto> page1 = new Page<>();
        List<CylinderFillingRecordDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(list.getRecords()),CylinderFillingRecordDto.class);
        page1.setCurrent(page.getCurrent());
        page1.setSize(page.getSize());
        page1.setTotal(list.getTotal());
        page1.setRecords(resultDtoList);
        return  page1;
    }

    public Double getFillingSumByMonth(String appId, Date time) {
        return baseMapper.getFillingSumByMonth(appId,time);
    }

    public Integer getFillingCountByMonth(String appId, Date time) {
        return baseMapper.getFillingCountByMonth(appId,time);
    }

    public Double getFillingSumByDate(String appId, Date time) {
        return baseMapper.getFillingSumByDate(appId,time);
    }
}