package com.yeejoin.amos.boot.biz.common.utils;

/**
 * @description:
 * @author: tw
 * @createDate: 2021/6/22
 * redis key
 */
public class RedisKey {

    /**根据动态表单code获取动态表单列表*/
    public static final String FORM_CODE = "form_code_";
    /**根据字典code获取数据字典列表*/
    public static final String DATA_DICTIONARY_CODE= "data_dictionary_code_";
    /**根据字典code获取数据字典列表*/
    public static final String DATA_DICTIONARY_CODE_XIN= "data_dictionary_code_xin_";
    /**根据id获取消防人员基本信息*/
    public static final String FIREFIGHTERS_ID="firefighters_id_";
    /**根据id获取消防人员列表基本信息*/
    public static final String FIREFIGHTERS_LIST_ID="firefighters_id_list_";
    /**根据消防人员id查询岗位学历信息工作经历*/
    public static final String EDUCATION_POST_EXPERIENCE_FIREFIGHTERS_ID="education_post_experience_firefighters_id_";
    /**根据合同信id 查询合同信息*/
    public static final String CONTRACT_ID="contract_id_";
    /**根据思想状况信息id 查询思想信息*/
    public static final String THOUGHT_ID="thought_id_";
    /**根据警情id查询警情详情记录*/
    public static final String ALERTCALLED_ID="alertcalled_id_";
    /**特种设备根据警情id查询警情详情记录*/
    public static final String TZS_ALERTCALLED_ID="tzs_alertcalled_id_";
    /**联通CTI token */
    public static final String CTI_TOKEN = "cti_token";
    /**微信公众平台 token */
    public static final String WECHAT_TOKEN = "wechat_token";
    /**微信公众平台 token */
    public static final String WECHAT_JS_TOKEN = "wechat_js_token";
    /**警情联系人*/
    public static final String CONTACT_USER = "contact_user";

    /**联通CTIuser token */
    public static final String CTI_USER_TOKEN = "cti_user_token";

    /** 企业用户注册前缀 */
    public static final String FLC_USER_TEL = "flc_tel_";

    /**
     * 装备指标Key值
     */
    public static final String EQUIP_INDEX_ADDRESS = "equip_index_address";

    /**
     * 装备指标Key值
     */
    public static final String EQUIP_INDEX_ADDRESS_KEY = "equip_index_address_key";

    /**
     * 韶山换流站指标Key
     */
    public static final String EQUIP_INDEX_ADDRESS_KEY_STATION = "equip_index_address_key_station";

    /** 驼峰转下划线(简单写法，效率低于 ) */
	public static String humpToLine(String str) {
		return str.replaceAll("[A-Z]", "_$0").toLowerCase();
	}

    /**
     * 用户新缓存前缀
     */
	public static final String REGION_REDIS_PREFIX = "biz_";
    /**
     * 创建区域key
     * @param token 权限
     * @return String
     */
    public static String buildReginKey(String userId, String token) {
        return REGION_REDIS_PREFIX + userId + "_" + token;
    }

    /**
     * 模糊重新区域key
     * @param token 权限
     * @return String
     */
    public static String buildPatternKey(String token) {
        return REGION_REDIS_PREFIX + "*" + "_" + token;
    }
    
    /**
     * 判断str1中包含str2的个数
      * @param str1
     * @param str2
     * @return counter
     */
    public static int countStr(String str1, String str2) {
    	int counter=0;
        if (str1.indexOf(str2) == -1) {
	        return 0;
        } else if (str1.indexOf(str2) != -1) {
	        counter++;
	        countStr(str1.substring(str1.indexOf(str2) +
                   str2.length()), str2);
               return counter;
        }
	        return 0;
    }
}
