package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
* 特种设备基本信息-施工信息Vo
*
* @author duanwei
* @date 2022-07-20
*/
@EqualsAndHashCode(callSuper = true)
@Data
public class ConstructionInfoModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "设备唯一标识码")
    /**
    * 设备唯一标识码
    */
    private String sequenceCode;
            @ApiModelProperty(value = "监管系统唯一编码")
    /**
    * 监管系统唯一编码
    */
    private String superviseCode;
            @ApiModelProperty(value = "施工类型(安装、改造、移装)")
    /**
    * 施工类型(安装、改造、移装)
    */
    private String constructionType;
            @ApiModelProperty(value = "施工单位统一社会信用代码")
    /**
    * 施工单位统一社会信用代码
    */
    private String uscUnitCreditCode;
            @ApiModelProperty(value = "施工单位名称")
    /**
    * 施工单位名称
    */
    private String uscUnitName;
            @ApiModelProperty(value = "安装/改造/移装告知ID")
    /**
    * 安装/改造/移装告知ID
    */
    private String uscInformId;
            @ApiModelProperty(value = "施工时间")
    /**
    * 施工时间
    */
    private Date uscDate;
}
