package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 
 * <pre>
 * 电梯
 * </pre>
 *
 * @author gwb
 * @version $Id: Elevator.java, v 0.1 2021年9月30日 下午3:27:18 gwb Exp $
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tcb_elevator")
public class Elevator extends BaseEntity {


	/**
	 * <pre>
	 * 
	 * </pre>
	 */
	private static final long serialVersionUID = 5715164115243510569L;
	/**
	 * 主键
	 */
	@TableField("sequence_nbr")
	private Long sequenceNbr;
	/**
	 * 电梯应急救援识别码
	 */
	@TableField("rescue_code")
	private Integer rescueCode;
	/**
	 * 设备注册代码
	 */
	@TableField("register_code")
	private String registerCode;
	/**
	 * 所属省
	 */
	@TableField("province")
	private String province;
	/**
	 * 所属地市
	 */
	@TableField("city")
	private String city;
	/**
	 * 所属区县
	 */
	@TableField("district")
	private String district;
	/**
	 * 所属区域代码
	 */
	@TableField("region_code")
	private String regionCode;
	/**
	 * 安装地址
	 */
	@TableField("address")
	private String address;
	/**
	 * 经度
	 */
	@TableField("longitude")
	private String longitude;
	/**
	 * 纬度
	 */
	@TableField("latitude")
	private String latitude;
	/**
	 * 内部编号
	 */
	@TableField("inner_num")
	private String innerNum;
	/**
	 * 电梯品牌
	 */
	@TableField("brand")
	private String brand;
	/**
	 * 出厂编号
	 */
	@TableField("factory_num")
	private String factoryNum;
	/**
	 * 电梯安装单位
	 */
	@TableField("installation_unit")
	private String installationUnit;
	/**
	 * 制造日期（出厂时间）
	 */
	@TableField("factory_date")
	private Date factoryDate;
	/**
	 * 电梯大修/改造日期
	 */
	@TableField("overhaul_date")
	private Date overhaulDate;
	/**
	 * 开始使用日期
	 */
	@TableField("start_use_date")
	private Date startUseDate;
	/**
	 * 设备类别
	 */
	@TableField("category")
	private String category;
	/**
	 * 使用场所分类
	 */
	@TableField("use_site_category")
	private String useSiteCategory;
	/**
	 * 电梯型号
	 */
	@TableField("model")
	private String model;
	/**
	 * 电梯层数
	 */
	@TableField("floors")
	private Integer floors;
	/**
	 * 电梯站数
	 */
	@TableField("stations")
	private Integer stations;
	/**
	 * 电梯门数
	 */
	@TableField("doors")
	private Integer doors;
	/**
	 * 电梯额定速度(单位：m/s)
	 */
	@TableField("rated_speed")
	private Float ratedSpeed;
	/**
	 * 电梯额定载重量(单位：kg)
	 */
	@TableField("rated_load")
	private Float ratedLoad;
	/**
	 * 最大荷载人数
	 */
	@TableField("max_person_load")
	private Integer maxPersonLoad;
	/**
	 * 提升高度（单位m）
	 */
	@TableField("raise_height")
	private Float raiseHeight;
	/**
	 * 拖动方式
	 */
	@TableField("drag_mode")
	private String dragMode;
	/**
	 * 电梯使用状态
	 */
	@TableField("use_status")
	private Integer useStatus;
	/**
	 * 使用单位
	 */
	@TableField("use_unit")
	private String useUnit;
	/**
	 * 使用单位id
	 */
	@TableField("use_unit_id")
	private Long useUnitId;
	/**
	 * 制造单位名称
	 */
	@TableField("manufacturer_name")
	private String manufacturerName;
	/**
	 * 制造许可编号
	 */
	@TableField("manufacturing_license")
	private String manufacturingLicense;
	/**
	 * 维护周期
	 */
	@TableField("maintain_period")
	private String maintainPeriod;
	/**
	 * 维保类型
	 */
	@TableField("maintain_type")
	private String maintainType;
	/**
	 * 维保单位
	 */
	@TableField("maintain_unit")
	private String maintainUnit;
	/**
	 * 维保单位id
	 */
	@TableField("maintain_unit_id")
	private Long maintainUnitId;
	/**
	 * 维保负责人
	 */
	@TableField("maintain_leader")
	private String maintainLeader;
	/**
	 * 维保负责人id
	 */
	@TableField("maintain_leader_id")
	private Long maintainLeaderId;
	/**
	 * 维保负责人手机
	 */
	@TableField("maintain_leader_phone")
	private String maintainLeaderPhone;
	/**
	 * 主机模式
	 */
	@TableField("host_model")
	private String hostModel;
	/**
	 * 主机编号
	 */
	@TableField("host_num")
	private String hostNum;
	/**
	 * 动力类型
	 */
	@TableField("engine_type")
	private String engineType;
	/**
	 * 动力编号
	 */
	@TableField("engine_num")
	private String engineNum;
	/**
	 * 面板模型
	 */
	@TableField("panel_model")
	private String panelModel;
	/**
	 * 面板编号
	 */
	@TableField("panel_num")
	private String panelNum;
	/**
	 * 级联模型
	 */
	@TableField("cascade_model")
	private String cascadeModel;
	/**
	 * 级联线路模型
	 */
	@TableField("cascade_line_model")
	private String cascadeLineModel;
	/**
	 * 扶手带类型
	 */
	@TableField("handrail_type")
	private String handrailType;
	/**
	 * 扶手面板模型
	 */
	@TableField("handrail_panel_model")
	private String handrailPanelModel;
	/**
	 * 扶手面板品牌
	 */
	@TableField("handrail_panel_brand")
	private String handrailPanelBrand;
	/**
	 * 滚转机模式
	 */
	@TableField("roller_mode")
	private String rollerMode;
	/**
	 * 倾斜的角度
	 */
	@TableField("tilt_angle")
	private String tiltAngle;
	/**
	 * 横向跨度
	 */
	@TableField("horizontal_span")
	private String horizontalSpan;
	/**
	 * 运行噪音
	 */
	@TableField("running_noise")
	private String runningNoise;
	/**
	 * 运行方式
	 */
	@TableField("running_mode")
	private String runningMode;
	/**
	 * 运行振动
	 */
	@TableField("running_vibration")
	private String runningVibration;
	/**
	 * 功率
	 */
	@TableField("power")
	private String power;
	/**
	 * 原始表id（来自历史数据库）
	 */
	@TableField("original_id")
	private String originalId;
	/**
	 * 是否删除（1：已删除，0：未删除）
	 */
	@TableField("is_delete")
	private Boolean isDelete;
	/**
	 * 更新日期
	 */
	@TableField("rec_date")
	private Date recDate;
	/**
	 * 更新人员id
	 */
	@TableField("rec_user_id")
	private String recUserId;
	/**
	 * 更新人员名称
	 */
	@TableField("rec_user_name")
	private String recUserName;
	/**
	 * 检验报告编号
	 */
	@TableField("inspection_report_no")
	private String inspectionReportNo;
	/**
	 * 检验时间
	 */
	@TableField("inspection_date")
	private Date inspectionDate;
	/**
	 * 下次检验时间
	 */
	@TableField("next_inspection_time")
	private Date nextInspectionTime;
	/**
	 * 检验单位
	 */
	@TableField("inspection_unit_name")
	private String inspectionUnitName;
	/**
	 * 使用单位主管机构
	 */
	@TableField("use_unit_authority")
	private String useUnitAuthority;
}

