package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterExcelCraneDto", description = "消防水鹤")
public class WaterExcelCraneDto extends WaterBaseResourceDto {
	@ExcelIgnore
	private static final long serialVersionUID = 1L;

	@ExcelProperty(value = "高度（cm）", index = 15)
	@ApiModelProperty(value = "高度（cm）")
	private Float height;

	@ExcelProperty(value = "供水单位名称", index = 16)
	@ApiModelProperty(value = "供水单位名称")
	private String waterSupplyName;

	@ExcelProperty(value = "所属管网", index = 17)
	@ApiModelProperty(value = "所属管网")
	private String pipeNetwork;

	@ExcelIgnore
	@ApiModelProperty(value = "消防给水管网形式类型代码")
	private String pipeTypeCode;

	@ExplicitConstraint(type = "XFJSGW", indexNum = 18, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防给水管网形式", index = 18)
	@ApiModelProperty(value = "消防给水管网形式")
	private String pipeTypeName;

	@ExcelProperty(value = "管网直径（cm）", index = 19)
	@ApiModelProperty(value = "管网直径（cm）")
	private Float pipeDiameter;

	@ExcelProperty(value = "加水车道数量(个)", index = 20)
	@ApiModelProperty(value = "加水车道数量(个)")
	private Integer waterfillingLaneNum;

	@ExcelProperty(value = "进水管直径(cm)", index = 21)
	@ApiModelProperty(value = "进水管直径(cm)")
	private Float inletPipeDiameter;

	@ExcelProperty(value = "出水管直径(cm)", index = 22)
	@ApiModelProperty(value = "出水管直径(cm)")
	private Float outletPipeDiameter;

	@ExcelIgnore
	@ApiModelProperty(value = "水源可用状态类别代码")
	private String statusCode;

	@ExplicitConstraint(type = "SYZT", indexNum = 23, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "水源可用状态", index = 23)
	@ApiModelProperty(value = "水源可用状态类别名称")
	private String status;

	@ExcelProperty(value = "所属路段", index = 24)
	@ApiModelProperty(value = "所属路段")
	private String section;

}
