package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "WaterExcelHydrantDto", description = "消火栓")
public class WaterExcelHydrantDto extends WaterBaseResourceDto {

	@ExcelIgnore
	private static final long serialVersionUID = 1L;


	@ExcelProperty(value = "所属管网", index = 24)
	@ApiModelProperty(value = "所属管网")
	private String pipeNetwork;

	@ExcelIgnore
	@ApiModelProperty(value = "消防给水管网形式类型代码")
	private String pipeTypeCode;

	@ExplicitConstraint(type = "XFJSGW", indexNum = 25, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防给水管网形式", index = 25)
	@ApiModelProperty(value = "消防给水管网形式")
	private String pipeTypeName;

	@ExcelProperty(value = "管网直径（cm）", index = 15)
	@ApiModelProperty(value = "管网直径（cm）")
	private Float pipeDiameter;

	@ExplicitConstraint(type = "XHSXTLX", indexNum = 16, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消火栓系统类型", index = 16)
	@ApiModelProperty(value = "消火栓系统类型")
	private String systemType;

	@ExcelIgnore
	@ApiModelProperty(value = "消火栓系统类型code")
	private String systemTypeCode;

	@ExcelProperty(value = "消火栓类型", index = 17)
	@ExplicitConstraint(type = "HSLX", indexNum = 17, sourceClass = CommonExplicitConstraint.class)
	@ApiModelProperty(value = "消火栓类型")
	@TableField(exist = false)
	private String hydrantType;

	@ExplicitConstraint(type = "XHSFZXS", indexNum = 18, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消火栓放置形式", index = 18)
	@ApiModelProperty(value = "消火栓放置形式")
	private String placeForm;

	@ExcelIgnore
	@ApiModelProperty(value = "消火栓放置形式code")
	private String placeFormCode;

	@ExplicitConstraint(type = "XFSDJK", indexNum = 21, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "消防水带接口", index = 21)
	@ApiModelProperty(value = "消防水带接口")
	private String hoseConnection;

	@ExcelIgnore
	@ApiModelProperty(value = "消防水带接口code")
	private String hoseConnectionCode;

	@ExplicitConstraint(type = "QSXS", indexNum = 20, sourceClass = CommonExplicitConstraint.class) // 动态下拉内容
	@ExcelProperty(value = "取水形式", index = 20)
	@ApiModelProperty(value = "取水形式")
	private String intakeForm;

	@ExcelProperty(value = "供水单位名称", index = 19)
	@ApiModelProperty(value = "供水单位名称")
	private String waterSupplyName;

	@ExcelProperty(value = "道路路口路段", index = 22)
	@ApiModelProperty(value = "道路路口路段简要情况")
	private String roadJunctionInfo;


	@ExcelProperty(value = "消防设施状况", index = 23)
	@ApiModelProperty(value = "消防设施状况分类")
	private String facilitiesCategory;

	@ExcelIgnore
	@ApiModelProperty(value = "消防设施状况分类code")
	private String facilitiesCategoryCode;


}




