package com.yeejoin.amos.boot.module.common.api.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;

import java.util.List;
import java.util.Map;

/**
 * iot feign
 *
 * @author Dell
 */
@FeignClient(name ="${iot.fegin.name:AMOS-API-IOT}", path = "iot", configuration = {MultipartSupportConfig.class})
public interface IotFeignClient {

      
    /**
     * 根据航班号查询航班信息
     **/
    @RequestMapping(value = "/v1/iot/DynamicFlightInfo/{flightNo}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> getDynamicFlightInfo(@PathVariable(value = "flightNo") String flightNo);


    @RequestMapping(value = "/v1/iot/DynamicFlightInfo/list", method = RequestMethod.GET)
    ResponseModel<List<Map<String, Object>>> findImgByFileCategory();
    
    @RequestMapping(value = "/v1/iot/DynamicFlightInfo/detail/{dynamicFlightId}", method = RequestMethod.GET)
    ResponseModel<Map<String, Object>> findImgByDynamicFlightId(@PathVariable(value = "dynamicFlightId") String dynamicFlightId);

    @RequestMapping(value = "/v1/iot/DynamicFlightInfo/plane/{dynamicFlightId}", method = RequestMethod.GET)
    ResponseModel<Object> DynamicFlightInfo(@PathVariable(value = "dynamicFlightId") String dynamicFlightId);
}
