package com.yeejoin.equipmanage.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@ApiModel(value = "车辆信息视图对象")
@Data
public class CarInfoDto implements Serializable {

    @ApiModelProperty(value = "设备id")
    private Long id;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "所属队伍")
    private String teamId;

    @ApiModelProperty(value = "所属队伍名称")
    private String teamName;

    @ApiModelProperty(value = "车牌号")
    private String carNum;

    @ApiModelProperty(value = "车辆类型")
    private Long equipmentId;

    @ApiModelProperty(value = "车辆类型名称")
    private String equipmentName;

    @ApiModelProperty(value = "分类id名称")
    private String categoryName;

    @ApiModelProperty(value = "分类id")
    private Long categoryId;

    @ApiModelProperty(value = "车辆状态")
    private String carState;

    @ApiModelProperty(value = "车辆状态描述")
    private String carStateDesc;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "规格型号")
    private String standard;

    @ApiModelProperty(value = "底盘品牌")
    private String chassisBrand;

    @ApiModelProperty(value = "厂商id")
    private Long manufacturerId;

    @ApiModelProperty(value = "底盘国别")
    private String chassisCountry;

    @ApiModelProperty(value = "国别")
    private String country;

    @ApiModelProperty(value = "进口国产")
    private Boolean isImport;

    @ApiModelProperty(value = "二维码")
    private String qrCode;

    @ApiModelProperty(value = "保养周期")
    private String maintenanceCycle;

    @ApiModelProperty(value = "3c认证")
    private Boolean cccAuth;

    @ApiModelProperty(value = "物联编码")
    private String iotCode;

    @ApiModelProperty(value = "所属单位id(来源于平台)")
    private String agencyId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "车辆图片")
    private List<String> image;

    @ApiModelProperty(value = "车辆资源列表")
    private List<Map<String, Object>> resourceList;

    @ApiModelProperty(value = "绑定人姓名")
    private String userName;
}
