package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author keyong
 * @title: EquipmentSpecificRelation
 * <pre>
 * @description: 设备关联关系表
 * </pre>
 * @date 2021/01/14 18:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_specific_relation")
@ApiModel(value = "EquipmentSpecificRelation设备关联关系表", description = "设备关联关系表")
public class EquipmentSpecificRelation extends BaseEntity {

    @ApiModelProperty(value = "装备id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "被绑定者id")
    private Long relationEquipmentSpecificId;

    @ApiModelProperty(value = "类型：1-安防；2-消防")
    private String type;

    @ApiModelProperty(value = "创建者")
    private String createBy;

    @ApiModelProperty(value = "备注")
    private String remark;
}
